/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.utilidades;

import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.utilidades.IGestorDatosOpciones;
import es.aeat.pftw.mtrc.utilidades.JarResources;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public abstract class GestorDatosBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected IGestorDatosOpciones gestorDatosGenerado = null;
    private DocumentBuilderFactory factory = null;
    private DocumentBuilder builder = null;
    private JarResources jar = null;
    private Document docGenerico = null;
    private Document docEspecifico = null;
    private String origenDatosGenerico = "";
    private String origenDatosEspecifico = "";

    public String getOrigenDatosGenerico() throws ExceptionMotor {
        try {
            return this.origenDatosGenerico;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public IGestorDatosOpciones getGestorDatosOpcionesGeneradoSinDependencias() {
        return this.gestorDatosGenerado;
    }

    public void dispose() {
        this.factory = null;
        this.builder = null;
        this.jar = null;
        this.docGenerico = null;
        this.docEspecifico = null;
        this.origenDatosGenerico = "";
        this.origenDatosEspecifico = "";
    }

    public String getOrigenDatosEspecifico() throws ExceptionMotor {
        try {
            return this.origenDatosEspecifico;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public boolean setRecursoDeJar(String rutaJar, String recurso, boolean elGenerico) throws ExceptionMotor {
        try {
            this.setJar(null);
            this.setJar(new JarResources(rutaJar));
            InputStream is = this.getJar().getResourceInputStream(recurso);
            if (elGenerico) {
                this.setDocGenerico(null);
                this.setFactory(DocumentBuilderFactory.newInstance());
                this.setBuilder(this.getFactory().newDocumentBuilder());
                this.setDocGenerico(this.getBuilder().parse(is));
                this.setOrigenDatosGenerico(rutaJar + "(" + recurso + ")");
                this.cargarDocument(this.getDocGenerico(), true);
            } else {
                this.setDocEspecifico(null);
                this.setFactory(DocumentBuilderFactory.newInstance());
                this.setBuilder(this.getFactory().newDocumentBuilder());
                this.setDocEspecifico(this.getBuilder().parse(is));
                this.setOrigenDatosEspecifico(rutaJar + "(" + recurso + ")");
                this.cargarDocument(this.getDocEspecifico(), false);
            }
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public boolean setFichero(String rutaFichero) throws ExceptionMotor {
        return this.setFichero(rutaFichero, true);
    }

    public boolean setFichero(String rutaFichero, boolean elGenerico) throws ExceptionMotor {
        try {
            FileInputStream is = new FileInputStream(rutaFichero);
            if (elGenerico) {
                this.setDocGenerico(null);
                this.setFactory(DocumentBuilderFactory.newInstance());
                this.setBuilder(this.getFactory().newDocumentBuilder());
                this.setDocGenerico(this.getBuilder().parse(is));
                this.setOrigenDatosGenerico(rutaFichero);
                this.cargarDocument(this.getDocGenerico(), true);
            } else {
                this.setDocEspecifico(null);
                this.setFactory(DocumentBuilderFactory.newInstance());
                this.setBuilder(this.getFactory().newDocumentBuilder());
                this.setDocEspecifico(this.getBuilder().parse(is));
                this.setOrigenDatosEspecifico(rutaFichero);
                this.cargarDocument(this.getDocEspecifico(), false);
            }
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public boolean setEntityManager(Object em) throws ExceptionMotor {
        return this.setEntityManager(em, "", true);
    }

    public boolean setEntityManager(Object em, String modKey) throws ExceptionMotor {
        return this.setEntityManager(em, modKey, true);
    }

    public boolean setEntityManager(Object em, String modKey, boolean elGenerico) throws ExceptionMotor {
        try {
            if (em == null) {
                return true;
            }
            return this.cargarDesdeBBDD(em, modKey, elGenerico);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public boolean setInputStream(InputStream is) throws ExceptionMotor {
        return this.setInputStream(is, true);
    }

    public boolean setInputStream(InputStream is, boolean elGenerico) throws ExceptionMotor {
        try {
            if (elGenerico) {
                this.setDocGenerico(null);
                this.setFactory(DocumentBuilderFactory.newInstance());
                this.setBuilder(this.getFactory().newDocumentBuilder());
                this.setDocGenerico(this.getBuilder().parse(is));
                this.setOrigenDatosGenerico("InputStream");
                this.cargarDocument(this.getDocGenerico(), true);
            } else {
                this.setDocEspecifico(null);
                this.setFactory(DocumentBuilderFactory.newInstance());
                this.setBuilder(this.getFactory().newDocumentBuilder());
                this.setDocEspecifico(this.getBuilder().parse(is));
                this.setOrigenDatosEspecifico("InputStream");
                this.cargarDocument(this.getDocEspecifico(), false);
            }
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public boolean setDocument(Document doc, boolean elGenerico) throws ExceptionMotor {
        try {
            if (elGenerico) {
                this.setDocGenerico(null);
                this.setDocGenerico(doc);
                this.setOrigenDatosGenerico("Document");
                this.cargarDocument(doc, true);
            } else {
                this.setDocEspecifico(null);
                this.setDocEspecifico(doc);
                this.setOrigenDatosEspecifico("Document");
                this.cargarDocument(doc, false);
            }
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected abstract boolean cargarDocument(Document var1, boolean var2) throws ExceptionMotor;

    protected boolean cargarDesdeBBDD(Object em, String modKey, boolean generica) throws ExceptionMotor {
        FuncionesUtiles.getFuncionesUtiles().muestraAviso("No procede...");
        return false;
    }

    protected boolean cargarDesdeBBDD(Object em, String modKey) throws ExceptionMotor {
        return this.cargarDesdeBBDD(em, modKey, true);
    }

    protected void setFactory(DocumentBuilderFactory factory) {
        this.factory = factory;
    }

    protected DocumentBuilderFactory getFactory() {
        return this.factory;
    }

    protected void setBuilder(DocumentBuilder builder) {
        this.builder = builder;
    }

    protected DocumentBuilder getBuilder() {
        return this.builder;
    }

    protected void setJar(JarResources jar) {
        this.jar = jar;
    }

    protected JarResources getJar() {
        return this.jar;
    }

    protected void setDocGenerico(Document docGenerico) {
        this.docGenerico = docGenerico;
    }

    protected Document getDocGenerico() {
        return this.docGenerico;
    }

    protected void setDocEspecifico(Document docEspecifico) {
        this.docEspecifico = docEspecifico;
    }

    protected Document getDocEspecifico() {
        return this.docEspecifico;
    }

    protected void setOrigenDatosGenerico(String origenDatosGenerico) {
        this.origenDatosGenerico = origenDatosGenerico;
    }

    protected void setOrigenDatosEspecifico(String origenDatosEspecifico) {
        this.origenDatosEspecifico = origenDatosEspecifico;
    }
}

