/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.utilidades;

import es.aeat.pftw.mtrc.tipos.TipoDatosCampoValor;
import es.aeat.pftw.mtrc.utilidades.IGestorDatosAuxiliares;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampoValor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GestorDatosAuxiliaresGenerado
implements IGestorDatosAuxiliares,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Map<String, List<ITipoDatosCampoValor>> coleccionGenerica = new HashMap<String, List<ITipoDatosCampoValor>>();
    protected Map<String, List<ITipoDatosCampoValor>> coleccionEspecifica = new HashMap<String, List<ITipoDatosCampoValor>>();
    protected List<ITipoDatosCampoValor> arrayListTemporal = null;

    protected void setColeccionGenerica(Map<String, List<ITipoDatosCampoValor>> coleccionGenerica) {
        this.coleccionGenerica = coleccionGenerica;
    }

    protected Map<String, List<ITipoDatosCampoValor>> getColeccionGenerica() {
        return this.coleccionGenerica;
    }

    protected void setColeccionEspecifica(Map<String, List<ITipoDatosCampoValor>> coleccionEspecifica) {
        this.coleccionEspecifica = coleccionEspecifica;
    }

    protected Map<String, List<ITipoDatosCampoValor>> getColeccionEspecifica() {
        return this.coleccionEspecifica;
    }

    protected void setArrayListTemporal(List<ITipoDatosCampoValor> arrayListTemporal) {
        this.arrayListTemporal = arrayListTemporal;
    }

    protected List<ITipoDatosCampoValor> getArrayListTemporal() {
        return this.arrayListTemporal;
    }

    @Override
    public IGestorDatosAuxiliares getGestorDatosAuxiliaresGeneradoSinDependencias() {
        return this;
    }

    @Override
    public String getRegistro(String tabla, String clave) throws ExceptionMotor {
        try {
            List<ITipoDatosCampoValor> table = null;
            int i = 1;
            while (true) {
                switch (i) {
                    case 1: {
                        table = this.getColeccionEspecifica().get(tabla.toUpperCase());
                        break;
                    }
                    case 2: {
                        table = this.getColeccionGenerica().get(tabla.toUpperCase());
                        break;
                    }
                    default: {
                        return "";
                    }
                }
                if (table != null) {
                    int indice = TipoDatosCampoValor.indiceListaContieneCampo(table, clave);
                    if (indice != -1) {
                        return table.get(indice).getValor();
                    }
                    return "";
                }
                ++i;
            }
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public List<ITipoDatosCampoValor> getTabla(String tabla, boolean orden) throws ExceptionMotor {
        try {
            List<ITipoDatosCampoValor> table = null;
            int i = 1;
            while (true) {
                switch (i) {
                    case 1: {
                        table = this.getColeccionEspecifica().get(tabla.toUpperCase());
                        break;
                    }
                    case 2: {
                        table = this.getColeccionGenerica().get(tabla.toUpperCase());
                        break;
                    }
                    default: {
                        return new ArrayList<ITipoDatosCampoValor>();
                    }
                }
                if (table != null) {
                    return table;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public List<ITipoDatosCampoValor> getTabla(String tabla) throws ExceptionMotor {
        return this.getTabla(tabla, false);
    }

    @Override
    public Map<String, String> getTablaHashMap(String tabla) throws ExceptionMotor {
        try {
            List<ITipoDatosCampoValor> tablaLista = null;
            int i = 1;
            while (true) {
                switch (i) {
                    case 1: {
                        tablaLista = this.getColeccionEspecifica().get(tabla.toUpperCase());
                        break;
                    }
                    case 2: {
                        tablaLista = this.getColeccionGenerica().get(tabla.toUpperCase());
                        break;
                    }
                    default: {
                        return new HashMap<String, String>();
                    }
                }
                if (tablaLista != null) {
                    HashMap<String, String> tablaHashMap = new HashMap<String, String>();
                    for (ITipoDatosCampoValor tipoDatosCampoValor : tablaLista) {
                        tablaHashMap.put(tipoDatosCampoValor.getNombreCampo(), tipoDatosCampoValor.getValor());
                    }
                    return tablaHashMap;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public List<ITipoDatosCampoValor> getTablaFiltrada(String tablaPadre, String tablaHija, String claveAjena, boolean ordenar) throws ExceptionMotor {
        try {
            ArrayList<ITipoDatosCampoValor> res = new ArrayList<ITipoDatosCampoValor>();
            String[] claves = null;
            List<ITipoDatosCampoValor> table = null;
            int i = 1;
            while (true) {
                switch (i) {
                    case 1: {
                        table = this.getColeccionEspecifica().get("RELACION_" + tablaPadre.toUpperCase() + "_" + tablaHija.toUpperCase());
                        break;
                    }
                    case 2: {
                        table = this.getColeccionGenerica().get("RELACION_" + tablaPadre.toUpperCase() + "_" + tablaHija.toUpperCase());
                        break;
                    }
                    default: {
                        return new ArrayList<ITipoDatosCampoValor>();
                    }
                }
                if (table != null) {
                    int indice = TipoDatosCampoValor.indiceListaContieneCampo(table, claveAjena);
                    if (indice != -1) {
                        claves = table.get(indice).getValor().split(";");
                        for (int j = 0; j < claves.length; ++j) {
                            res.add(new TipoDatosCampoValor(claves[j], this.getRegistro(tablaHija, claves[j])));
                        }
                        return res;
                    }
                    return res;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public List<ITipoDatosCampoValor> getTablaFiltrada(String tablaPadre, String tablaHija, String claveAjena) throws ExceptionMotor {
        return this.getTablaFiltrada(tablaPadre, tablaHija, claveAjena, true);
    }

    @Override
    public boolean setEntityManager(Object ObjEm) throws ExceptionMotor {
        return false;
    }

    @Override
    public void cargaFicheros(List<ITipoDatosCampoValor> listado) throws ExceptionMotor {
    }
}

