/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.utilidades;

import es.aeat.pftw.mtrc.motor.FactoriaMotor;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.utilidades.IGeneradorDinamicoClases;
import es.aeat.pftw.mtrc.utilidades.LectorFicheroJar;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public final class GeneradorDinamicoClases
implements Serializable,
IGeneradorDinamicoClases {
    private static final long serialVersionUID = 1L;
    private String propiedad = "";
    private String rutaFicheroJar = "";
    private Properties propiedades;
    private transient ClassLoader cargadorAEmplear = null;

    public GeneradorDinamicoClases(String rutaFicheroJar) throws ExceptionMotor {
        this(rutaFicheroJar, null);
    }

    public GeneradorDinamicoClases(String sRutaFicheroJar, ClassLoader cCargadorAEmplear) throws ExceptionMotor {
        try {
            this.rutaFicheroJar = sRutaFicheroJar;
            this.cargadorAEmplear = cCargadorAEmplear;
            this.propiedades = new Properties();
            if (this.rutaFicheroJar.trim().length() > 0) {
                LectorFicheroJar lf = new LectorFicheroJar(this.rutaFicheroJar);
                InputStream is = lf.getInputStream("Clases.properties");
                this.propiedades.load(is);
            }
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public GeneradorDinamicoClases(Properties pPropiedades) {
        this.propiedades = pPropiedades;
    }

    @Override
    public Object crearInstanciaClase(String sPropiedad) throws ExceptionMotor {
        try {
            this.propiedad = sPropiedad;
            String nombreClase = this.propiedades.getProperty(this.propiedad);
            return Class.forName(nombreClase).newInstance();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, this.propiedad);
        }
    }

    @Override
    public String getPropiedad() {
        return this.propiedad;
    }

    @Override
    public void setPropiedad(String valor) {
        this.propiedad = valor;
    }

    @Override
    public String getRutaFicheroJar() {
        return this.rutaFicheroJar;
    }

    @Override
    public void setRutaFicheroJar(String valor) {
        this.rutaFicheroJar = valor;
    }

    @Override
    public boolean setClassLoader(ClassLoader cCargadorAEmplear) {
        this.cargadorAEmplear = cCargadorAEmplear;
        return true;
    }

    @Override
    public Class<?>[] clasesConstructor(Class<?> clase, Object[] param) {
        try {
            Class<?>[] parametros = null;
            boolean encontrado = false;
            for (int i = 0; i < clase.getConstructors().length; ++i) {
                parametros = clase.getConstructors()[i].getParameterTypes();
                if (parametros.length != param.length) continue;
                encontrado = true;
                for (int j = 0; j < parametros.length; ++j) {
                    if (param[j] == null || FuncionesUtiles.getFuncionesUtiles().clasesIguales(param[j].getClass(), parametros[j])) continue;
                    encontrado = false;
                    break;
                }
                if (!encontrado) continue;
                return parametros;
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public Object loadClassFromJarFile(String nombreClase, Object[] parametrosConstructor, ClassLoader cargadorPadre) {
        try {
            String ruta;
            if (cargadorPadre == null) {
                cargadorPadre = FactoriaMotor.class.getClassLoader();
            }
            if ((ruta = this.rutaFicheroJar).length() == 0) {
                return null;
            }
            if (ruta.indexOf("File:/") != 0) {
                ruta = "File:/" + ruta;
            }
            ArrayList<URL> arrayURL = new ArrayList<URL>();
            StringBuffer urlSb = new StringBuffer();
            urlSb.append("jar:");
            urlSb.append(ruta);
            urlSb.append("!/");
            arrayURL.add(new URL(urlSb.toString()));
            Object ret = this.loadClassFromJarFile(nombreClase, parametrosConstructor, cargadorPadre, arrayURL);
            if (ret != null) {
                return ret;
            }
            File f = new File(this.rutaFicheroJar);
            if (f.exists()) {
                URL[] a = new URL[]{f.toURI().toURL()};
                return this.loadClassFromJarFile(nombreClase, parametrosConstructor, cargadorPadre, a);
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected Object loadClassFromJarFile(String nombreClase, Object[] parametrosConstructor, ClassLoader cargadorPadre, List<URL> arrayURL) {
        URL[] urls = (URL[])Array.newInstance(URL.class, arrayURL.size());
        return this.loadClassFromJarFile(nombreClase, parametrosConstructor, cargadorPadre, urls);
    }

    protected Object loadClassFromJarFile(String nombreClase, Object[] parametrosConstructor, ClassLoader cargadorPadre, URL[] urls) {
        try {
            ClassLoader cargadorMomentaneo = this.cargadorAEmplear;
            URLClassLoader cargadorClases = null;
            if (this.cargadorAEmplear == null) {
                cargadorClases = cargadorPadre == null ? URLClassLoader.newInstance(urls) : URLClassLoader.newInstance(urls, cargadorPadre);
                Object ret = null;
                try {
                    ret = FuncionesUtiles.getFuncionesUtiles().getInstancia(cargadorClases.loadClass(nombreClase), parametrosConstructor);
                }
                catch (Exception ex) {
                    FuncionesUtiles.getFuncionesUtiles().muestraInfoDebug("Clase " + nombreClase + " : " + ex.toString());
                }
                if (ret != null) {
                    FuncionesUtiles.getFuncionesUtiles().muestraInfoDebug("Clase " + nombreClase + " cargada");
                    cargadorClases = null;
                    return ret;
                }
                cargadorMomentaneo = cargadorClases;
            }
            if (cargadorMomentaneo != null) {
                if (parametrosConstructor == null) {
                    return FuncionesUtiles.getFuncionesUtiles().getInstancia(Class.forName(nombreClase), null);
                }
                Class<?> clase = cargadorMomentaneo.loadClass(nombreClase);
                Object instancia = FuncionesUtiles.getFuncionesUtiles().getInstancia(clase, parametrosConstructor);
                if (instancia == null) {
                    throw new ExceptionMotor("El constructor de la clase " + nombreClase + " retorno nulo");
                }
                FuncionesUtiles.getFuncionesUtiles().muestraInfoDebug("Clase " + nombreClase + " cargada");
                return instancia;
            }
            return null;
        }
        catch (Exception ex) {
            FuncionesUtiles.getFuncionesUtiles().muestraInfoDebug("Clase : " + nombreClase + " : " + ex.toString());
            return null;
        }
    }

    @Override
    public Object loadClassFromJarFile(String nombreClase, ClassLoader cargadorPadre) {
        return this.loadClassFromJarFile(nombreClase, null, cargadorPadre);
    }

    @Override
    public Object loadClassFromJarFile(String nombreClase, Object[] parametrosConstructor) {
        return this.loadClassFromJarFile(nombreClase, parametrosConstructor, null);
    }

    @Override
    public Object loadClassFromJarFile(String nombreClase) {
        try {
            return this.loadClassFromJarFile(nombreClase, null, null);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Object loadClassFromPath(String pathClass) {
        try {
            return Class.forName(pathClass).newInstance();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static List<Object> ejecutaMetodoDeClase(Object oClase, String sMetodo, Class<?>[] cClaseTipos, Object[] parametros) {
        try {
            ArrayList<Object> ret = new ArrayList<Object>();
            ret.add(Boolean.TRUE);
            Class<?> clase = oClase.getClass();
            Method metodo = clase.getMethod(sMetodo, cClaseTipos);
            ret.add(metodo.invoke(oClase, parametros));
            return ret;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

