/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.utilidades;

import es.aeat.pftw.mtrc.IAop;
import es.aeat.pftw.mtrc.configuracion.IGestorConfiguracion;
import es.aeat.pftw.mtrc.configuracion.IGestorConfiguracionLooper;
import es.aeat.pftw.mtrc.configuracion.RegError;
import es.aeat.pftw.mtrc.digest.Sello;
import es.aeat.pftw.mtrc.gestionFicheros.IGestorFicheros;
import es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.IGestorTraducciones;
import es.aeat.pftw.mtrc.motor.IEventosMensajes;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.procesadorReglas.OperacionesV2;
import es.aeat.pftw.mtrc.tipos.TipoDatoRetornoProceso;
import es.aeat.pftw.mtrc.tipos.TipoDatosCampoValor;
import es.aeat.pftw.mtrc.utilidades.ByteWriterAEAT;
import es.aeat.pftw.mtrc.utilidades.LectorFicheroJar;
import es.aeat.pftw.mtrc.utilidades.ObjectInputStreamAEAT;
import es.aeat.pftw.mtrc.utilidades.StringAEAT;
import es.aeat.pftw.mtrp.configuracion.IRegEntrada;
import es.aeat.pftw.mtrp.configuracion.IRegError;
import es.aeat.pftw.mtrp.configuracion.IRegTabla;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.procesadorReglas.IOperaciones;
import es.aeat.pftw.mtrp.puente.ITablaMotorEntrada;
import es.aeat.pftw.mtrp.tipos.ITipoDatoRetornoProceso;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampoValor;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampos;
import es.aeat.pftw.mtrp.utilidades.IFuncionesUtiles;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class FuncionesUtiles
implements Serializable,
IFuncionesUtiles {
    private static final long serialVersionUID = 1L;
    private final String __OBFUSCATE = "OBFAEAT";
    private Map<String, Long> conjuntoDeContadoresMilisegundos = new HashMap<String, Long>();
    private PrintStream errAnterior = null;
    private PrintStream outAnterior = null;
    private boolean puedoRestaurar = false;
    private final String LITERAL_TERMINACION_FICHERO_TEMPORAL = "~tmp";
    public final int TAM_BUFFER_CADENA = 0x2000000;
    private List<IEventosMensajes> listenersEventosMensajes = null;
    private static FuncionesUtiles instanciaFuncionesUtiles = null;
    private static boolean aopInyectorAOPDisponible = true;

    private FuncionesUtiles() {
    }

    public static FuncionesUtiles getFuncionesUtiles() {
        if (instanciaFuncionesUtiles == null) {
            instanciaFuncionesUtiles = new FuncionesUtiles();
        }
        return instanciaFuncionesUtiles;
    }

    public static void dispose() {
        instanciaFuncionesUtiles = null;
    }

    @Override
    public String obtenerDirectorioBaseDeClase(Class<?> c) {
        try {
            String s = c.toString();
            s = s.substring(s.lastIndexOf(46) + 1) + ".class";
            String path = c.getResource(s).getPath();
            String so = System.getProperty("os.name").toUpperCase();
            if (path.startsWith("file:")) {
                path = path.substring(5);
                path = path.substring(0, path.lastIndexOf(33));
            }
            if (so.contains("WINDOWS") && path.contains(":")) {
                path = path.substring(1);
            }
            path = path.replaceAll("%20", " ");
            path = path.substring(0, path.lastIndexOf(47));
            return path;
        }
        catch (Exception exx) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean copyFile(InputStream inputStreamOrigen, String rutaFicheroDestino) {
        File fichero = null;
        try {
            fichero = new File(rutaFicheroDestino);
            boolean bl = this.copyFile(inputStreamOrigen, fichero);
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            fichero = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean copyFile(String origen, String destino) {
        File fOrigen = null;
        File fDestino = null;
        FileInputStream forigen = null;
        try {
            boolean ret = true;
            fOrigen = new File(origen);
            fDestino = new File(destino);
            forigen = new FileInputStream(fOrigen);
            ret = this.copyFile((InputStream)forigen, fDestino);
            forigen.close();
            boolean bl = ret;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            forigen = null;
            fOrigen = null;
            fDestino = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean copyFile(InputStream inputStreamOrigen, File fichero) {
        FileOutputStream fo = null;
        try {
            byte[] buffer = new byte[1024];
            boolean eof = false;
            fo = new FileOutputStream(fichero);
            while (!eof) {
                int bytesLeidos = inputStreamOrigen.read(buffer);
                if (bytesLeidos != 1024) {
                    eof = true;
                }
                if (bytesLeidos != -1 && eof) {
                    byte[] ultimoBuffer = new byte[bytesLeidos];
                    System.arraycopy(buffer, 0, ultimoBuffer, 0, bytesLeidos);
                    fo.write(ultimoBuffer);
                    break;
                }
                if (bytesLeidos != 1024) continue;
                fo.write(buffer);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                fo.close();
            }
            catch (Exception ex) {
            }
            finally {
                fo = null;
            }
        }
    }

    @Override
    public boolean fileExists(String fichero) {
        return this.ficheroExiste(fichero);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ficheroExiste(String ruta) {
        File f = null;
        try {
            f = new File(ruta);
            boolean bl = f.exists();
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            f = null;
        }
    }

    @Override
    public String obtenerRutaDirectorioFichero(String ruta) {
        try {
            File f = new File(ruta);
            if (f.isDirectory()) {
                return ruta + File.separatorChar;
            }
            File padre = f.getParentFile();
            if (padre.isDirectory()) {
                return padre.getPath() + File.separatorChar;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean borraFichero(String ruta) {
        File f = null;
        try {
            f = new File(ruta);
            f.delete();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            f = null;
        }
    }

    @Override
    public boolean ficheroEscribible(String ruta) {
        try {
            return this.ficheroEscribible(ruta, 0);
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ficheroEscribible(String ruta, int kbNecesarios) {
        File f = null;
        FileWriter fw = null;
        try {
            f = new File(ruta);
            fw = new FileWriter(f);
            if (kbNecesarios < 1) {
                fw.write("Fichero Escribible");
            } else {
                String relleno = "";
                while (kbNecesarios > 0) {
                    relleno = relleno + "X";
                }
                fw.write(relleno);
            }
            fw.close();
            f.delete();
            boolean relleno = true;
            return relleno;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            fw = null;
            f = null;
        }
    }

    @Override
    public void inicializarContadorMilisegundos() {
        this.inicializarContadorMilisegundos("STANDARD");
    }

    @Override
    public void inicializarContadorMilisegundos(String nombreContador) {
        this.conjuntoDeContadoresMilisegundos.put(nombreContador.toUpperCase(), System.currentTimeMillis());
    }

    @Override
    public long mostrarContadorMilisegundos() {
        return this.mostrarContadorMilisegundos("STANDARD");
    }

    @Override
    public long mostrarContadorMilisegundos(String nombreContador) {
        return System.currentTimeMillis() - this.conjuntoDeContadoresMilisegundos.get(nombreContador.toUpperCase());
    }

    @Override
    public boolean redireccionaOutErrFichero(String fichero) {
        try {
            if (!this.puedoRestaurar) {
                this.errAnterior = System.err;
                this.outAnterior = System.out;
            }
            PrintStream ps = new PrintStream(new FileOutputStream(fichero));
            System.setOut(ps);
            System.setErr(ps);
            this.puedoRestaurar = true;
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public boolean redireccionaOutErrRestaurar() {
        try {
            if (!this.puedoRestaurar) {
                return false;
            }
            System.setOut(this.outAnterior);
            System.setErr(this.errAnterior);
            this.puedoRestaurar = false;
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private String mostrarContador(long dif) {
        long diff = dif;
        try {
            String cadFinal = "";
            String diffStr = "";
            String milisegundos = "";
            String segundos = "";
            String minutos = "";
            String horas = "";
            double dbl = 0.0;
            long lng = 0L;
            diffStr = String.valueOf(diff);
            if (diffStr.length() < "000".length()) {
                diffStr = "000" + diffStr;
            }
            if ((lng = Long.valueOf(diffStr.substring(diffStr.length() - 3)).longValue()) > 0L) {
                milisegundos = String.valueOf(lng).trim() + " Milisegundo";
                if (lng > 1L) {
                    milisegundos = milisegundos + "s";
                }
            }
            diff = diffStr.length() == 3 ? 0L : Long.valueOf(diffStr.substring(0, diffStr.length() - 3));
            diffStr = String.valueOf(diff);
            dbl = diff / 3600L;
            lng = (long)dbl;
            if (lng > 0L) {
                horas = String.valueOf(lng).trim() + " Hora";
                if (lng > 1L) {
                    horas = horas + "s";
                }
                diff -= lng * 3600L;
            } else {
                horas = "";
            }
            dbl = diff / 60L;
            lng = (long)dbl;
            if (lng > 0L) {
                minutos = String.valueOf(lng).trim() + " Minuto";
                if (lng > 1L) {
                    minutos = minutos + "s";
                }
                diff -= lng * 60L;
            } else {
                minutos = "";
            }
            if (diff > 0L) {
                segundos = String.valueOf(diff).trim() + " Segundo";
            }
            if (diff > 1L) {
                segundos = segundos + "s";
            }
            if (horas.length() > 0) {
                cadFinal = horas;
            }
            if (minutos.length() > 0) {
                cadFinal = cadFinal + " " + minutos;
            }
            if (segundos.length() > 0) {
                cadFinal = cadFinal + " " + segundos;
            }
            if (milisegundos.length() > 0) {
                cadFinal = cadFinal + " " + milisegundos;
            }
            if (cadFinal.length() == 0) {
                cadFinal = "0 Milisegundos";
            } else if (cadFinal.charAt(0) == ' ') {
                cadFinal = cadFinal.substring(1);
            }
            return cadFinal;
        }
        catch (Exception ex) {
            this.muestraError(ex);
            return diff + " milisegundos";
        }
    }

    @Override
    public String mostrarContador() {
        return this.mostrarContador("STANDARD");
    }

    @Override
    public String mostrarContador(String nombreContador) {
        try {
            long diff = System.currentTimeMillis() - this.conjuntoDeContadoresMilisegundos.get(nombreContador.toUpperCase());
            return this.mostrarContador(diff);
        }
        catch (Exception ex) {
            return "Desconocido por error " + ex.toString();
        }
    }

    @Override
    public List<ITablaMotorEntrada> hashMap2ArrayListTablaMotorEntrada(Map<String, ITablaMotorEntrada> h) {
        try {
            if (h == null) {
                return null;
            }
            ArrayList<ITablaMotorEntrada> res = new ArrayList<ITablaMotorEntrada>();
            String obj2 = null;
            Set<String> s = h.keySet();
            for (String obj2 : s) {
                res.add(h.get(obj2));
            }
            return res;
        }
        catch (Exception ex) {
            this.muestraError(ex);
            return null;
        }
    }

    @Override
    public List<String> hashMap2ArrayList(Map<String, String> h) {
        try {
            if (h == null) {
                return null;
            }
            ArrayList<String> res = new ArrayList<String>();
            String obj2 = null;
            Set<String> s = h.keySet();
            for (String obj2 : s) {
                res.add(obj2);
                res.add(String.valueOf(h.get(obj2)));
            }
            return res;
        }
        catch (Exception ex) {
            this.muestraError(ex);
            return null;
        }
    }

    @Override
    public List<?> hashMap2List(Map<String, ?> h) {
        try {
            if (h == null) {
                return null;
            }
            ArrayList res = new ArrayList();
            String obj2 = null;
            Set<String> s = h.keySet();
            for (String obj2 : s) {
                res.add(h.get(obj2));
            }
            return res;
        }
        catch (Exception ex) {
            this.muestraError(ex);
            return null;
        }
    }

    public Object getClase(String nombreClase, ISesion sesion) {
        try {
            Object clase = null;
            try {
                clase = Class.forName(nombreClase).newInstance();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (clase == null) {
                try {
                    clase = Class.forName(nombreClase.replaceAll("\\.", "/")).newInstance();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (clase == null && (clase = sesion.getModelo().getClaseGeneradorDinamicoClases().loadClassFromJarFile(nombreClase)) == null) {
                clase = sesion.getModelo().getClaseGeneradorDinamicoClases().loadClassFromJarFile(nombreClase.replaceAll("\\.", "/"));
            }
            if (clase == null) {
                throw new ExceptionMotor("clase no encontrada");
            }
            return clase;
        }
        catch (Exception ex) {
            this.muestraError(ex);
            return null;
        }
    }

    @Override
    public String sello(String rutaFichero, char caracterFinal) throws Exception {
        return this.selloPos(rutaFichero, 237, caracterFinal);
    }

    @Override
    public String selloPos(String rutaFichero, int posSello, char caracterFinal) throws Exception {
        int leidos;
        RandomAccessFile file = new RandomAccessFile(rutaFichero, "rw");
        byte[] datos = new byte[5120];
        boolean deboLimpiarSello = true;
        Sello sello = new Sello();
        if (posSello > 5120) {
            this.muestraAviso("AVISO: Revisar la funcion de selloPos, no esta sellando correctamente");
        }
        while ((leidos = file.read(datos)) != -1) {
            if (deboLimpiarSello) {
                for (int i = 0; i < 13; ++i) {
                    datos[posSello + i] = 32;
                }
                deboLimpiarSello = false;
            }
            sello.update(datos, 0, leidos);
        }
        file.seek(posSello);
        String cad = sello.sellar();
        cad = cad + caracterFinal;
        file.write(cad.getBytes());
        file.close();
        return cad;
    }

    @Override
    public String selloPos(byte[] fichero, int posSello, char caracterFinal) throws Exception {
        for (int i = 0; i < 13; ++i) {
            fichero[posSello + i] = 32;
        }
        Sello sello = new Sello();
        sello.update(fichero, 0, fichero.length);
        String cad = sello.sellar() + caracterFinal;
        for (int i = 0; i < 13; ++i) {
            fichero[posSello + i] = cad.getBytes()[i];
        }
        return cad;
    }

    @Override
    public boolean compruebaSelloXML(String ficheroXML) throws Exception {
        try {
            int leidos;
            RandomAccessFile file = new RandomAccessFile(ficheroXML, "rw");
            byte[] datos = new byte[5120];
            Sello sello = new Sello();
            String selloLeido = "";
            int posSello = -1;
            int pos = -1;
            String literalSello = "Sello=\"";
            while ((leidos = file.read(datos)) != -1) {
                String cadenaFichero = new String(datos);
                pos = cadenaFichero.indexOf("Sello=\"");
                if (pos > -1 && posSello == -1) {
                    posSello = pos;
                    selloLeido = cadenaFichero.substring(posSello + "Sello=\"".length(), posSello + "Sello=\"".length() + 13);
                    for (int i = 0; i < 13; ++i) {
                        datos[posSello + "Sello=\"".length() + i] = 32;
                    }
                }
                sello.update(datos, 0, leidos);
            }
            file.seek(posSello);
            String cad = sello.sellar();
            file.close();
            return selloLeido.startsWith(cad);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public boolean compruebaSello(String fichero) throws Exception {
        return this.compruebaSello(fichero, 237);
    }

    @Override
    public boolean compruebaSello(String fichero, int posSello) throws Exception {
        try {
            String[] sellos = this.dameSello(fichero, posSello);
            return sellos[0].startsWith(sellos[1]);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public String[] dameSello(String fichero, int posSello) throws Exception {
        int leidos;
        RandomAccessFile file = new RandomAccessFile(fichero, "rw");
        byte[] datos = new byte[5120];
        if (posSello > 5120) {
            this.muestraAviso("AVISO: Revisar la funcion de compruebaSello, no esta sellando correctamente");
        }
        boolean deboLimpiarSello = true;
        Sello sello = new Sello();
        String selloLeido = "";
        while ((leidos = file.read(datos)) != -1) {
            String cadenaFichero = new String(datos);
            if (deboLimpiarSello) {
                selloLeido = cadenaFichero.substring(posSello, posSello + 13);
                for (int i = 0; i < 13; ++i) {
                    datos[posSello + i] = 32;
                }
                deboLimpiarSello = false;
            }
            sello.update(datos, 0, leidos);
        }
        file.seek(posSello);
        String cad = sello.sellar();
        file.close();
        return new String[]{selloLeido, cad};
    }

    @Override
    public boolean compruebaSello(byte[] fichero) throws Exception {
        return this.compruebaSello(fichero, 237);
    }

    @Override
    public boolean compruebaSello(byte[] fichero, int posSello) throws Exception {
        try {
            String[] sellos = this.dameSello(fichero, posSello);
            return sellos[0].startsWith(sellos[1]);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public String[] dameSello(byte[] fichero, int posSello) throws Exception {
        byte[] selloLeido = new byte[13];
        for (int i = 0; i < 13; ++i) {
            selloLeido[i] = fichero[posSello + i];
            fichero[posSello + i] = 32;
        }
        Sello sello = new Sello();
        sello.update(fichero, 0, fichero.length);
        String cad = sello.sellar();
        for (int i = 0; i < 13; ++i) {
            fichero[posSello + i] = selloLeido[i];
        }
        return new String[]{new String(selloLeido), cad};
    }

    @Override
    public String calculaSelloSinPosicion(byte[] fichero) throws Exception {
        Sello sello = new Sello();
        sello.update(fichero, 0, fichero.length);
        return sello.sellar();
    }

    public Map<String, String> traducirTipoCampo(Map<String, String> propiedades, IGestorTraducciones gestor) {
        return this.traducirTipoCampo(propiedades, gestor, null);
    }

    public Map<String, String> traducirTipoCampo(Map<String, String> propiedades, IGestorTraducciones gestor, Map<String, ITablaMotorEntrada> listaCamposBD) {
        try {
            String condicion = "";
            try {
                condicion = propiedades.get("VALIDACIONTIPODATO").toString().toUpperCase();
            }
            catch (Exception ex) {
                condicion = "";
            }
            if (condicion.indexOf("IF(") > -1) {
                Map modificado = (Map)((HashMap)propiedades).clone();
                condicion = this.evaluaExpresion(condicion, gestor, listaCamposBD);
                modificado.put("SUSTITUCION", "");
                int pos = condicion.indexOf(59);
                if (pos > -1) {
                    String sustitucion = "";
                    sustitucion = listaCamposBD == null ? gestor.traduceCadena(this.desCodificaCadena(condicion.substring(pos + 1))) : gestor.traduceCadena(this.desCodificaCadena(condicion.substring(pos + 1)), listaCamposBD);
                    condicion = condicion.substring(0, pos);
                    while (Integer.valueOf(((String)modificado.get("LONGITUD")).toString()) > sustitucion.length()) {
                        sustitucion = sustitucion + sustitucion.substring(0, 1);
                    }
                    modificado.put("SUSTITUCION", sustitucion);
                }
                modificado.put("TIPODATO", condicion);
                return modificado;
            }
            propiedades.put("SUSTITUCION", "");
            return propiedades;
        }
        catch (Exception ex) {
            this.muestraError(ex);
            return null;
        }
    }

    private String evaluaExpresion(String expresion, IGestorTraducciones gestor, Map<String, ITablaMotorEntrada> listaCamposBD) {
        try {
            int pos = expresion.indexOf("IF(");
            if (pos > -1) {
                String cadena = expresion.substring("IF(".length(), expresion.length() - 1);
                String condicion = cadena.substring(0, cadena.indexOf(44));
                String[] resultados = this.parteExpresion(cadena.substring(cadena.indexOf(44) + 1));
                String operador = "";
                String operador1 = "";
                String operador2 = "";
                Double dblOperador1 = null;
                Double dblOperador2 = null;
                pos = condicion.indexOf("==");
                if (pos != -1) {
                    operador1 = condicion.substring(0, pos);
                    operador2 = condicion.substring(pos + 2);
                    operador = "=";
                } else {
                    pos = condicion.indexOf("!=");
                    if (pos != -1) {
                        operador1 = condicion.substring(0, pos);
                        operador2 = condicion.substring(pos + 2);
                        operador = "!";
                    } else {
                        pos = condicion.indexOf(62);
                        if (pos != -1) {
                            operador1 = condicion.substring(0, pos);
                            operador2 = condicion.substring(pos + 1);
                            operador = ">";
                        } else {
                            pos = condicion.indexOf(60);
                            if (pos != -1) {
                                operador1 = condicion.substring(0, pos);
                                operador2 = condicion.substring(pos + 1);
                                operador = "<";
                            }
                        }
                    }
                }
                if (listaCamposBD == null) {
                    operador1 = gestor.traduceCadena(this.desCodificaCadena(operador1));
                    operador2 = gestor.traduceCadena(this.desCodificaCadena(operador2));
                } else {
                    operador1 = gestor.traduceCadena(this.desCodificaCadena(operador1), listaCamposBD);
                    operador2 = gestor.traduceCadena(this.desCodificaCadena(operador2), listaCamposBD);
                }
                if (this.esNumerico(operador1) && this.esNumerico(operador2)) {
                    dblOperador1 = Double.valueOf(operador1);
                    dblOperador2 = Double.valueOf(operador2);
                }
                if (operador.equalsIgnoreCase("=")) {
                    if (dblOperador1 != null) {
                        if (dblOperador1.doubleValue() == dblOperador2.doubleValue()) {
                            return this.evaluaExpresion(resultados[0], gestor, listaCamposBD);
                        }
                        return this.evaluaExpresion(resultados[1], gestor, listaCamposBD);
                    }
                    if (operador1.compareTo(operador2) == 0) {
                        return this.evaluaExpresion(resultados[0], gestor, listaCamposBD);
                    }
                    return this.evaluaExpresion(resultados[1], gestor, listaCamposBD);
                }
                if (operador.equalsIgnoreCase("!")) {
                    if (dblOperador1 != null) {
                        if (dblOperador1.doubleValue() != dblOperador2.doubleValue()) {
                            return this.evaluaExpresion(resultados[0], gestor, listaCamposBD);
                        }
                        return this.evaluaExpresion(resultados[1], gestor, listaCamposBD);
                    }
                    if (operador1.compareTo(operador2) != 0) {
                        return this.evaluaExpresion(resultados[0], gestor, listaCamposBD);
                    }
                    return this.evaluaExpresion(resultados[1], gestor, listaCamposBD);
                }
                if (operador.equalsIgnoreCase(">")) {
                    if (dblOperador1 != null) {
                        if (dblOperador1 > dblOperador2) {
                            return this.evaluaExpresion(resultados[0], gestor, listaCamposBD);
                        }
                        return this.evaluaExpresion(resultados[1], gestor, listaCamposBD);
                    }
                    if (operador1.compareTo(operador2) > 0) {
                        return this.evaluaExpresion(resultados[0], gestor, listaCamposBD);
                    }
                    return this.evaluaExpresion(resultados[1], gestor, listaCamposBD);
                }
                if (operador.equalsIgnoreCase("<")) {
                    if (dblOperador1 != null) {
                        if (dblOperador1 < dblOperador2) {
                            return this.evaluaExpresion(resultados[0], gestor, listaCamposBD);
                        }
                        return this.evaluaExpresion(resultados[1], gestor, listaCamposBD);
                    }
                    if (operador1.compareTo(operador2) < 0) {
                        return this.evaluaExpresion(resultados[0], gestor, listaCamposBD);
                    }
                    return this.evaluaExpresion(resultados[1], gestor, listaCamposBD);
                }
            }
            return expresion;
        }
        catch (Exception ex) {
            this.muestraError(ex);
            return expresion;
        }
    }

    private String[] parteExpresion(String expresion) {
        try {
            int contador = 0;
            int j = 0;
            String[] res = new String[2];
            String cadTmp = "";
            for (int i = 0; i < expresion.length(); ++i) {
                if (expresion.charAt(i) == ',' && contador == 0) {
                    res[j] = cadTmp;
                    cadTmp = "";
                    ++j;
                    continue;
                }
                if (expresion.charAt(i) == '(') {
                    ++contador;
                } else if (expresion.charAt(i) == ')') {
                    --contador;
                }
                cadTmp = cadTmp + expresion.charAt(i);
            }
            res[j] = cadTmp;
            return res;
        }
        catch (Exception ex) {
            this.muestraError(ex);
            return null;
        }
    }

    @Override
    public String codificaCadena(String cadenaSinCodificar) {
        try {
            String resultado = "";
            for (int i = 0; i < cadenaSinCodificar.length(); ++i) {
                char chr;
                char ascii = chr = cadenaSinCodificar.charAt(i);
                resultado = resultado.length() == 0 ? resultado + ascii : resultado + "-" + ascii;
            }
            return resultado;
        }
        catch (Exception ex) {
            this.muestraError(ex);
            return cadenaSinCodificar;
        }
    }

    @Override
    public String desCodificaCadena(String cadenaCodificada) {
        try {
            String resultado = "";
            String[] arrStr = cadenaCodificada.split("-");
            for (int i = 0; i < arrStr.length; ++i) {
                int ascii;
                try {
                    ascii = Integer.valueOf(arrStr[i]);
                }
                catch (Exception ex) {
                    return cadenaCodificada;
                }
                char chr = (char)ascii;
                resultado = resultado + chr;
            }
            if (cadenaCodificada.indexOf("-") == -1 && (resultado.charAt(0) < ' ' || resultado.charAt(0) > '\u0080') && resultado.charAt(0) != '\u00a4' && resultado.charAt(0) != '\u00a5') {
                return cadenaCodificada;
            }
            return resultado;
        }
        catch (Exception ex) {
            this.muestraError(ex);
            return cadenaCodificada;
        }
    }

    @Override
    public boolean esNumerico(String valor) {
        try {
            new BigDecimal(valor.trim());
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public String object2String(Object obj) {
        try {
            return obj.toString();
        }
        catch (Exception ex) {
            return "";
        }
    }

    @Override
    public void borraFicherosTemporalesExportacion(List<List<String>> ficheros) {
        try {
            for (int i = 0; i < ficheros.size(); ++i) {
                List<String> listaFich = ficheros.get(i);
                for (int j = 0; j < listaFich.size(); ++j) {
                    if (listaFich.get(j) == null || listaFich.get(j).toString().length() <= 0 || !this.ficheroExiste(listaFich.get(j).toString())) continue;
                    this.borraFichero(listaFich.get(j).toString());
                }
            }
        }
        catch (Exception ex) {
            this.muestraError(ex);
        }
    }

    @Override
    public List<ITipoDatosCampos> concatenaArrayList(List<ITipoDatosCampos> primero, List<ITipoDatosCampos> segundo) {
        try {
            int i;
            ArrayList<ITipoDatosCampos> ret = new ArrayList<ITipoDatosCampos>();
            if (primero != null) {
                for (i = 0; i < primero.size(); ++i) {
                    ret.add(primero.get(i));
                }
            }
            if (segundo != null) {
                for (i = 0; i < segundo.size(); ++i) {
                    ret.add(segundo.get(i));
                }
            }
            return ret;
        }
        catch (Exception ex) {
            this.muestraError(ex);
            return null;
        }
    }

    public void concatenaArrayListStrings(List<String> destino, List<String> nuevo) {
        try {
            if (destino == null && nuevo != null) {
                destino = new ArrayList<String>();
            }
            if (nuevo != null) {
                for (String string : nuevo) {
                    destino.add(string);
                }
            }
        }
        catch (Exception ex) {
            this.muestraError(ex);
        }
    }

    @Override
    public <T> T[] concatenaByteArrays(T[] a, T[] b) throws Exception {
        int alen = a.length;
        int blen = b.length;
        if (alen == 0) {
            return b;
        }
        if (blen == 0) {
            return a;
        }
        Object[] result = (Object[])Array.newInstance(a.getClass().getComponentType(), alen + blen);
        System.arraycopy(a, 0, result, 0, alen);
        System.arraycopy(b, 0, result, alen, blen);
        return result;
    }

    @Override
    public Map<Object, Object> concatenaHashMap(Map<Object, Object> primero, Map<Object, Object> segundo) {
        try {
            Map ret = null;
            if (primero != null) {
                ret = (Map)((HashMap)primero).clone();
            }
            if (segundo != null) {
                if (ret == null) {
                    ret = (Map)((HashMap)segundo).clone();
                } else {
                    Set<Object> s = segundo.keySet();
                    Object clave2 = null;
                    for (Object clave2 : s) {
                        ret.put(clave2, segundo.get(clave2));
                    }
                }
            }
            return ret;
        }
        catch (Exception ex) {
            this.muestraError(ex);
            return null;
        }
    }

    @Override
    public <T> List<T> cloneList(List<T> list) throws ExceptionMotor {
        try {
            List c = (List)list.getClass().newInstance();
            for (T t : list) {
                Object copy = t.getClass().getDeclaredMethod("clone", new Class[0]).invoke(t, new Object[0]);
                c.add(copy);
            }
            return c;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public <T> List<T> concatList(List<T> list, List<T> list2) throws ExceptionMotor {
        try {
            for (T t : list2) {
                list.add(t);
            }
            return list;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public String dameCadenaPadreLocalizacion(List<ITipoDatosCampoValor> localiz) throws ExceptionMotor {
        try {
            List<ITipoDatosCampoValor> loc = this.cloneList(localiz);
            if (loc.size() > 0) {
                loc.remove(loc.size() - 1);
            }
            return loc.toString();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public String localizacion2String(List<ITipoDatosCampoValor> localiz) throws Exception {
        String ret = "";
        for (int i = 0; i < localiz.size(); ++i) {
            if (ret.length() > 0) {
                ret = ret + ",";
            }
            ret = ret + localiz.get(i).getNombreCampo() + "(" + localiz.get(i).getValor() + ")";
        }
        return ret;
    }

    @Override
    public <K, V> Map<K, V> cloneMap(Map<K, V> map) throws ExceptionMotor {
        try {
            Map c = (Map)map.getClass().newInstance();
            for (K iterado : map.keySet()) {
                Object copy = map.get(iterado).getClass().getDeclaredMethod("clone", new Class[0]).invoke(map.get(iterado), new Object[0]);
                c.put(iterado, copy);
            }
            return c;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public String versionSistemaOperativo() {
        try {
            String ssoo = System.getProperty("os.name");
            if (ssoo.equalsIgnoreCase("Windows NT")) {
                return "T";
            }
            if (ssoo.equalsIgnoreCase("Windows 95")) {
                return "5";
            }
            if (ssoo.equalsIgnoreCase("Windows 98")) {
                return "8";
            }
            if (ssoo.equalsIgnoreCase("Windows XP")) {
                return "X";
            }
            if (ssoo.equalsIgnoreCase("Windows 2000")) {
                return "Y";
            }
            return "O";
        }
        catch (Exception ex) {
            return "E";
        }
    }

    @Override
    public boolean clasesIguales(Class<?> clase1, Class<?> clase2) {
        try {
            if (clase1 == null) {
                return true;
            }
            if (Object.class.equals(clase2)) {
                return true;
            }
            if (clase2.equals(clase1)) {
                return true;
            }
            if (clase2.isInterface()) {
                for (int i = 0; i < clase1.getInterfaces().length; ++i) {
                    if (!this.claseCumpleInterfaz(clase2, clase1.getInterfaces()[i])) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean claseCumpleInterfaz(Class<?> clase, Class<?> interfaz) {
        try {
            if (clase.equals(interfaz)) {
                return true;
            }
            for (int i = 0; i < interfaz.getInterfaces().length; ++i) {
                if (clase.equals(interfaz.getInterfaces()[i])) {
                    return true;
                }
                if (!this.claseCumpleInterfaz(clase, interfaz.getInterfaces()[i])) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public boolean removeReadOnlyFlag(String fichero) {
        try {
            if (!new File(fichero).canWrite()) {
                File f = null;
                try {
                    f = new File(fichero + "~tmp");
                    f.delete();
                    f = null;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                FileInputStream fi = new FileInputStream(new File(fichero));
                FileOutputStream fo = new FileOutputStream(new File(fichero + "~tmp"));
                byte[] buf = new byte[1024];
                int i = 0;
                while ((i = fi.read(buf)) != -1) {
                    fo.write(buf, 0, i);
                }
                fi.close();
                fo.close();
                fi = null;
                fo = null;
                try {
                    f = new File(fichero);
                    f.delete();
                    f = null;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                f = new File(fichero + "~tmp");
                f.renameTo(new File(fichero));
                f = null;
                try {
                    f = new File(fichero + "~tmp");
                    f.delete();
                    f = null;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                f = null;
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public Object limpiaCadenaDeCaracteresDeControl(Object cadena) {
        try {
            String cadaux = cadena.toString();
            int i = 0;
            String caracter = "";
            for (int chr = 0; chr < 3; ++chr) {
                switch (chr) {
                    case 0: {
                        caracter = "\n";
                        break;
                    }
                    case 1: {
                        caracter = "\t";
                        break;
                    }
                    case 2: {
                        caracter = "\r";
                        break;
                    }
                }
                while ((i = cadaux.indexOf(caracter)) != -1) {
                    if (i == 0) {
                        cadaux = cadaux.substring(1);
                        continue;
                    }
                    cadaux = cadaux.substring(0, i) + cadaux.substring(i + 1);
                }
            }
            if (cadaux.compareTo(cadena.toString()) != 0) {
                return cadaux;
            }
            return cadena;
        }
        catch (Exception ex) {
            this.muestraError(ex);
            return cadena;
        }
    }

    @Override
    public boolean existeDirectorio(String pathCompleto) {
        try {
            return this.esDirectorio(pathCompleto);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean esReadOnly(String pathFichero) {
        if (this.existeFichero(pathFichero)) {
            FileWriter fw = null;
            try {
                fw = new FileWriter(pathFichero);
                fw.write("A");
                fw.close();
            }
            catch (IOException e) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean existeFichero(String pathFichero) {
        try {
            File fr = new File(pathFichero);
            return fr.exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean esDirectorio(String pathFichero) {
        try {
            File fr = new File(pathFichero);
            return fr.exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean esFichero(String pathFichero) {
        try {
            File fr = new File(pathFichero);
            return fr.isFile();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean esPath(String pathFichero) {
        try {
            File file = new File(pathFichero);
            return file.isDirectory();
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean borraDirectorio(String ruta) {
        File f = null;
        boolean res = true;
        try {
            f = new File(ruta);
            if (f.isDirectory()) {
                String[] hijos = f.list();
                if (hijos.length > 0) {
                    for (int i = 0; i < hijos.length; ++i) {
                        if (this.borraDirectorio(f.getPath().replace(File.separatorChar, '/') + '/' + hijos[i])) continue;
                        boolean bl = false;
                        return bl;
                    }
                }
                res = f.delete();
            } else {
                res = f.delete();
            }
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            f = null;
        }
        return res;
    }

    @Override
    public String doubleToString(Double dbl) {
        return this.doubleToString((double)dbl);
    }

    private String quitaNotacionCientifica(String sDat) {
        String sDato = sDat;
        String sres = "";
        int pot = 0;
        int posE = sDato.lastIndexOf(69);
        int posDot = sDato.lastIndexOf(46);
        String sDec = "";
        if (posE != -1) {
            pot = Integer.parseInt(sDato.substring(posE + 1, sDato.length()));
            sDato = sDato.replaceAll("\\.", "");
            if (pot >= 0) {
                if (pot + posDot < posE - 1) {
                    sDec = sDato.substring(pot + posDot, posE - 1);
                    if (sDec.length() == 1) {
                        sDec = sDec + "0";
                    }
                } else {
                    sDec = "00";
                }
                sres = pot + posDot >= posE - 1 ? sDato.substring(0, posE - 1) : sDato.substring(0, pot + posDot);
                while (pot + 1 > posE - posDot) {
                    sres = sres + "0";
                    --pot;
                }
                sres = sres + ".";
                sres = sres + sDec;
            } else {
                sres = "0.";
                pot *= -1;
                for (int i = 1; i < pot; ++i) {
                    sres = sres + "0";
                }
                sres = sres + sDato.substring(0, posE - 1);
            }
        } else {
            sres = sDato;
        }
        return sres;
    }

    @Override
    public boolean tieneDecimales(Double dbl) throws ExceptionMotor {
        try {
            if (dbl == null) {
                return false;
            }
            if (dbl.toString().indexOf(46) > 0) {
                Double d = new Double(dbl.toString().substring(dbl.toString().indexOf(46) + 1));
                if (d > 0.0) {
                    return true;
                }
            }
            return false;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public String doubleToString(double dbl) {
        try {
            return this.quitaNotacionCientifica(String.valueOf(dbl));
        }
        catch (Exception ex) {
            this.muestraError(ex);
            return String.valueOf(dbl);
        }
    }

    @Override
    public Map<?, ?> arrayList2HashMap(List<?> arr) {
        try {
            HashMap res = new HashMap();
            for (int i = 0; i < arr.size(); i += 2) {
                res.put(arr.get(i), arr.get(i + 1));
            }
            return res;
        }
        catch (Exception ex) {
            this.muestraError(ex);
            return null;
        }
    }

    @Override
    public void dejaSoloNerroresEntreListas(List<IRegError> listadoErrores, List<IRegError> listadoWarnings, int numErrores) {
        try {
            if (listadoErrores.size() + listadoWarnings.size() == numErrores) {
                return;
            }
            if (listadoWarnings.size() > 0) {
                while (listadoWarnings.size() > 0) {
                    listadoWarnings.remove(listadoWarnings.size() - 1);
                    if (listadoErrores.size() + listadoWarnings.size() != numErrores) continue;
                    return;
                }
            }
            if (listadoErrores.size() + listadoWarnings.size() > numErrores) {
                for (int i = listadoErrores.size() - 1; i >= 0; --i) {
                    if (listadoErrores.get(i).getIdError().equalsIgnoreCase("OVERFLOW_MOTOR") || listadoErrores.get(i).getIdError().equalsIgnoreCase("MAXERR")) continue;
                    listadoErrores.remove(i);
                    if (listadoErrores.size() + listadoWarnings.size() == numErrores) {
                        return;
                    }
                    i = listadoErrores.size();
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    @Override
    public String html2Text(String s) {
        if (s == null || !s.contains("&")) {
            return s;
        }
        String ret = s.replaceAll("&lt;", "<");
        ret = ret.replaceAll("&LT;", "<");
        ret = ret.replaceAll("&gt;", ">");
        ret = ret.replaceAll("&GT;", ">");
        ret = ret.replaceAll("&amp;", "&");
        ret = ret.replaceAll("&AMP;", "&");
        ret = ret.replaceAll("&quot;", "\"");
        ret = ret.replaceAll("&QUOT;", "\"");
        ret = ret.replaceAll("&Eacute;", "\u00c9");
        ret = ret.replaceAll("&EACUTE;", "\u00c9");
        ret = ret.replaceAll("&eacute;", "\u00e9");
        ret = ret.replaceAll("&Ccedil;", "\u00c7");
        ret = ret.replaceAll("&CCEDIL;", "\u00c7");
        ret = ret.replaceAll("&ccedil;", "\u00e7");
        ret = ret.replaceAll("&AElig;", "\u00c6");
        ret = ret.replaceAll("&AELIG;", "\u00c6");
        ret = ret.replaceAll("&aelig;", "\u00e6");
        ret = ret.replaceAll("&Aring;", "\u00c5");
        ret = ret.replaceAll("&ARING;", "\u00c5");
        ret = ret.replaceAll("&aring;", "\u00e5");
        ret = ret.replaceAll("&Auml;", "\u00c4");
        ret = ret.replaceAll("&AUML;", "\u00c4");
        ret = ret.replaceAll("&auml;", "\u00e4");
        ret = ret.replaceAll("&Acirc;", "\u00c2");
        ret = ret.replaceAll("&ACIRC;", "\u00c2");
        ret = ret.replaceAll("&acirc;", "\u00e2");
        ret = ret.replaceAll("&Agrave;", "\u00c0");
        ret = ret.replaceAll("&AGRAVE;", "\u00c0");
        ret = ret.replaceAll("&agrave;", "\u00e0");
        ret = ret.replaceAll("&nbsp;", " ");
        ret = ret.replaceAll("&NBSP;", " ");
        ret = ret.replaceAll("&euro;", "\u0080");
        ret = ret.replaceAll("&EURO;", "\u0080");
        ret = ret.replaceAll("&copy;", "\u00a9");
        ret = ret.replaceAll("&COPY;", "\u00a9");
        ret = ret.replaceAll("&reg;", "\u00ae");
        ret = ret.replaceAll("&Uuml;", "\u00dc");
        ret = ret.replaceAll("&uuml;", "\u00fc");
        ret = ret.replaceAll("&Ucirc;", "\u00db");
        ret = ret.replaceAll("&ucirc;", "\u00fb");
        ret = ret.replaceAll("&Ugrave;", "\u00d9");
        ret = ret.replaceAll("&ugrave;", "\u00f9");
        ret = ret.replaceAll("&szlig;", "\u00df");
        ret = ret.replaceAll("&Oslash;", "\u00d8");
        ret = ret.replaceAll("&oslash;", "\u00f8");
        ret = ret.replaceAll("&Ouml;", "\u00d6");
        ret = ret.replaceAll("&ouml;", "\u00f6");
        ret = ret.replaceAll("&Ocirc;", "\u00d4");
        ret = ret.replaceAll("&ocirc;", "\u00f4");
        ret = ret.replaceAll("&Iuml;", "\u00cf");
        ret = ret.replaceAll("&iuml;", "\u00ef");
        ret = ret.replaceAll("&Euml;", "\u00cb");
        ret = ret.replaceAll("&euml;", "\u00eb");
        ret = ret.replaceAll("&Ecirc;", "\u00ca");
        ret = ret.replaceAll("&ecirc;", "\u00ea");
        ret = ret.replaceAll("&Egrave;", "\u00c8");
        ret = ret.replaceAll("&egrave;", "\u00e8");
        return ret;
    }

    protected String detallameError(Exception ex) {
        if (ex == null) {
            return null;
        }
        String detalle = ex.toString();
        StackTraceElement[] elements = ex.getStackTrace();
        int n = elements.length;
        for (int i = 0; i < n; ++i) {
            detalle = detalle + "\n" + elements[i].getFileName() + "[" + elements[i].getLineNumber() + "] ==> " + elements[i].getMethodName() + "()";
        }
        return detalle;
    }

    @Override
    public void muestraError(Exception ex) {
        this.muestraError(this.detallameError(ex));
    }

    @Override
    public void muestraError(Exception ex, String extra) {
        this.muestraError("INFORMACION EXTRA DEL ERROR : " + extra + "\n" + this.detallameError(ex));
    }

    @Override
    public void muestraError(String detalle) {
        if (detalle == null) {
            return;
        }
        if (this.listenersEventosMensajes == null) {
            System.err.println("Error : " + detalle);
        } else {
            for (int i = 0; i < this.listenersEventosMensajes.size(); ++i) {
                this.listenersEventosMensajes.get(i).eventoError(detalle);
            }
        }
    }

    @Override
    public void muestraAviso(Exception ex, String extra) {
        this.muestraAviso("INFORMACION EXTRA DEL AVISO : " + extra + "\n" + this.detallameError(ex));
    }

    @Override
    public void muestraAviso(Exception ex) {
        this.muestraAviso(this.detallameError(ex));
    }

    @Override
    public void muestraAviso(String detalle) {
        if (detalle == null) {
            return;
        }
        if (this.listenersEventosMensajes == null) {
            System.err.println("Aviso : " + detalle);
        } else {
            for (int i = 0; i < this.listenersEventosMensajes.size(); ++i) {
                this.listenersEventosMensajes.get(i).eventoAviso(detalle);
            }
        }
    }

    @Override
    public void muestraInfo(Exception ex, String extra) {
        this.muestraInfo("INFORMACION EXTRA : " + extra + "\n" + this.detallameError(ex));
    }

    @Override
    public void muestraInfo(Exception ex) {
        this.muestraInfo(this.detallameError(ex));
    }

    @Override
    public void muestraInfo(String detalle) {
        if (detalle == null) {
            return;
        }
        if (this.listenersEventosMensajes == null) {
            System.out.println("Info : " + detalle);
        } else {
            for (int i = 0; i < this.listenersEventosMensajes.size(); ++i) {
                this.listenersEventosMensajes.get(i).eventoInformacion(detalle);
            }
        }
    }

    @Override
    public void muestraInfoDebug(Exception ex, String extra) {
        this.muestraInfoDebug("INFORMACION EXTRA : " + extra + "\n" + this.detallameError(ex));
    }

    @Override
    public void muestraInfoDebug(Exception ex) {
        this.muestraInfoDebug(this.detallameError(ex));
    }

    @Override
    public void muestraInfoDebug(String detalle) {
        if (detalle == null) {
            return;
        }
        if (this.listenersEventosMensajes == null) {
            System.out.println("InfoDebug : " + detalle);
        } else {
            for (int i = 0; i < this.listenersEventosMensajes.size(); ++i) {
                this.listenersEventosMensajes.get(i).eventoInformacionDebug(detalle);
            }
        }
    }

    public void addEventosMensajes(IEventosMensajes escuchador) throws ExceptionMotor {
        try {
            if (this.listenersEventosMensajes == null) {
                this.listenersEventosMensajes = new ArrayList<IEventosMensajes>();
            }
            this.listenersEventosMensajes.add(escuchador);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void removeEventosMensajes() throws ExceptionMotor {
        try {
            if (this.listenersEventosMensajes != null) {
                this.listenersEventosMensajes.clear();
                this.listenersEventosMensajes = null;
            }
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public String rellena(String cad, char chr, int longitud) {
        return this.rellena(cad, chr, longitud, false);
    }

    @Override
    public String truncaCadena(String cad, int longitud, boolean ponerTresPuntitos) {
        if (cad != null && cad.length() > longitud) {
            cad = longitud > 5 && ponerTresPuntitos ? cad.substring(0, longitud - 3) + "..." : cad.substring(0, longitud);
        }
        return cad;
    }

    @Override
    public String rellena(String cadena, char chr, int longitud, boolean alreves) {
        String cad = cadena;
        try {
            while (cad.length() < longitud) {
                if (alreves) {
                    cad = chr + cad;
                    continue;
                }
                cad = cad + chr;
            }
            return cad;
        }
        catch (Exception ex) {
            this.muestraError(ex);
            return cad;
        }
    }

    @Override
    public boolean mayorQue(String valor1, String valor2) throws Exception {
        BigDecimal b2;
        BigDecimal b1 = new BigDecimal(valor1.trim());
        return b1.compareTo(b2 = new BigDecimal(valor2.trim())) > 0;
    }

    @Override
    public boolean menorQue(String valor1, String valor2) throws Exception {
        BigDecimal b2;
        BigDecimal b1 = new BigDecimal(valor1.trim());
        return b1.compareTo(b2 = new BigDecimal(valor2.trim())) < 0;
    }

    @Override
    public File creaArchivoTemporal() {
        return this.creaArchivoTemporal(null, null);
    }

    @Override
    public File creaArchivoTemporal(String ini, String ext) {
        String extension = ext;
        String inicio = ini;
        try {
            if (inicio == null) {
                inicio = "Mot";
            }
            if (inicio.length() == 0) {
                inicio = "Mot";
            }
            if (extension == null) {
                extension = "Tmp";
            }
            if (extension.length() == 0) {
                extension = "Tmp";
            }
            File f = File.createTempFile(inicio, "." + extension);
            f.deleteOnExit();
            return f;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    @Override
    public boolean sonIguales(boolean esEntradaNumerica, Object valor1, Object valor2) {
        try {
            if (valor1 != null && valor1.toString().equalsIgnoreCase(valor2.toString())) {
                return true;
            }
            if (esEntradaNumerica) {
                try {
                    if (this.esNumerico(valor1.toString()) && this.esNumerico(valor2.toString()) && new BigDecimal(valor1.toString().trim()).compareTo(new BigDecimal(valor2.toString().trim())) == 0) {
                        return true;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String convertStream2String(InputStream is) throws ExceptionMotor, IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charset.forName("ISO-8859-1")));
        StringAEAT sb = new StringAEAT();
        String line = null;
        while ((line = reader.readLine()) != null) {
            sb.append(line + "\n");
        }
        return sb.getString();
    }

    @Override
    public InputStream string2inputstream(String cadena, Charset chrset) {
        try {
            return new ByteArrayInputStream(cadena.getBytes(chrset));
        }
        catch (Exception ex) {
            this.muestraError(ex);
            return null;
        }
    }

    @Override
    public String convertStream2StringPersistencia(InputStream is) throws ExceptionMotor, IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charset.forName("ISO-8859-1")));
        StringAEAT sb = new StringAEAT();
        int line = 0;
        while ((line = reader.read()) != -1) {
            sb.append((char)line);
        }
        return sb.getString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String obfuscate(String s, int version) {
        try {
            switch (version) {
                case 1: {
                    StringBuffer buf = new StringBuffer();
                    byte[] b = s.getBytes();
                    StringBuffer stringBuffer = buf;
                    synchronized (stringBuffer) {
                        buf.append("OBFAEAT");
                        for (int i = 0; i < b.length; ++i) {
                            byte b1 = b[i];
                            byte b2 = b[s.length() - (i + 1)];
                            int i1 = 127 + b1 + b2;
                            int i2 = 127 + b1 - b2;
                            int i0 = i1 * 256 + i2;
                            String x = Integer.toString(i0, 36);
                            switch (x.length()) {
                                case 1: {
                                    buf.append('0');
                                }
                                case 2: {
                                    buf.append('0');
                                }
                                case 3: {
                                    buf.append('0');
                                }
                            }
                            buf.append(x);
                        }
                        return buf.toString();
                    }
                }
            }
            return s;
        }
        catch (Exception ex) {
            this.muestraError(ex);
            return s;
        }
    }

    @Override
    public String deobfuscate(String s, int version) {
        try {
            switch (version) {
                case 1: {
                    if (s.startsWith("OBFAEAT")) {
                        s = s.substring("OBFAEAT".length());
                    }
                    byte[] b = new byte[s.length() / 2];
                    int l = 0;
                    for (int i = 0; i < s.length(); i += 4) {
                        String x = s.substring(i, i + 4);
                        int i0 = Integer.parseInt(x, 36);
                        int i1 = i0 / 256;
                        int i2 = i0 % 256;
                        b[l++] = (byte)((i1 + i2 - 254) / 2);
                    }
                    return new String(b, 0, l);
                }
            }
            return s;
        }
        catch (Exception ex) {
            this.muestraError(ex);
            return s;
        }
    }

    @Override
    public String comprimeCadena(String s, Charset chrs) {
        try {
            byte[] input = s.getBytes(chrs);
            byte[] output = new byte[0x2000000];
            Deflater compresser = new Deflater(-1, true);
            compresser.setInput(input);
            compresser.finish();
            int compressedDataLength = 0;
            String outputString = "";
            while ((compressedDataLength = compresser.deflate(output)) != 0) {
                outputString = outputString + new String(output, 0, compressedDataLength, chrs);
            }
            return outputString;
        }
        catch (Exception ex) {
            this.muestraError(ex);
            return s;
        }
    }

    @Override
    public String desComprimeCadena(String s, Charset chrs) {
        try {
            byte[] input = s.getBytes(chrs);
            Inflater decompresser = new Inflater(true);
            decompresser.setInput(input, 0, input.length);
            byte[] result = new byte[0x2000000];
            int resultLength = 0;
            String outputString = "";
            do {
                if ((resultLength = decompresser.inflate(result)) <= 0) continue;
                outputString = outputString + new String(result, 0, resultLength, chrs);
            } while (decompresser.getRemaining() != 0);
            return outputString;
        }
        catch (Exception ex) {
            this.muestraError(ex);
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dameNombreTablaRaiz(IGestorConfiguracion gc) {
        IAop gclooper = null;
        try {
            gclooper = (IGestorConfiguracionLooper)this.getInstancia(Class.forName("es.aeat.pftw.mtrc.configuracion.GestorConfiguracionLooper"), new Object[]{gc});
            String tabla = "";
            IRegTabla t = (IRegTabla)gclooper.getPrimerElemento("Tablas".toUpperCase());
            while (t != null) {
                if (t.getNivel() == 0) {
                    tabla = t.getIdTabla();
                    break;
                }
                t = (IRegTabla)gclooper.getSiguienteElemento();
            }
            if (tabla.length() == 0) {
                throw new ExceptionMotor("No se cual es la tabla de nivel 0!!!!!!!");
            }
            String string = tabla;
            return string;
        }
        catch (Exception ex) {
            this.muestraError(ex);
            String string = "";
            return string;
        }
        finally {
            if (gclooper != null) {
                try {
                    gclooper.dispose();
                }
                catch (Exception e) {}
                gclooper = null;
            }
        }
    }

    public void expandeTransXXX(ISesion sesion, IGestorFicheros gestor, IGestorTraducciones gt, String[] nombreFicherosTrans, String xmlSalida) {
        try {
            int i;
            for (i = 0; i < nombreFicherosTrans.length; ++i) {
                gestor.addnombreFicheroTraducciones(nombreFicherosTrans[i]);
            }
            if (gt.cargarEstructura(gestor.getFicheroGestorTraducciones(), true)) {
                gestor.setGestorTraducciones(gt);
            }
            for (i = 0; i < gt.getDocumentosTraduccion().size(); ++i) {
                int j;
                String nom = xmlSalida;
                if (i > 0 && (j = nom.indexOf(".xml")) > -1) {
                    nom = nom.substring(0, j) + i + ".xml";
                }
                this.document2file(gt.getDocumentosTraduccion().get(i), nom);
            }
            gt.getDocumentosTraduccion().clear();
            gt.setDocumentosTraduccion(null);
        }
        catch (Exception ex) {
            this.muestraError(ex);
        }
    }

    @Override
    public boolean sonIgualesXML(String xml1, String xml2) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setCoalescing(true);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setIgnoringComments(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        String cabecera = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"yes\" ?>";
        if (!xml1.startsWith(cabecera.substring(0, 12))) {
            xml1 = cabecera + xml1;
        }
        Document doc1 = db.parse(this.string2inputstream(xml1, Charset.forName("ISO-8859-1")));
        doc1.normalizeDocument();
        if (!xml2.startsWith(cabecera.substring(0, 12))) {
            xml2 = cabecera + xml2;
        }
        Document doc2 = db.parse(this.string2inputstream(xml2, Charset.forName("ISO-8859-1")));
        doc2.normalizeDocument();
        Element root = doc1.getDocumentElement();
        this.sortChildren(root, new DefaultNodeNameComparator());
        root = doc2.getDocumentElement();
        this.sortChildren(root, new DefaultNodeNameComparator());
        return doc1.isEqualNode(doc2);
    }

    protected void sortChildren(Node parent, Comparator<Node> comparator) throws Exception {
        NodeList children = parent.getChildNodes();
        if (children.getLength() == 0) {
            return;
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            this.sortChildren(n, comparator);
            nodes.add(n);
        }
        Collections.sort(nodes, Collections.reverseOrder(comparator));
        for (Node n : nodes) {
            parent.appendChild(n);
        }
    }

    @Override
    public Document documentFromString(String sDatos) throws Exception {
        String str = "ISO-8859-1";
        InputSource iso = new InputSource(new InputStreamReader((InputStream)new ByteArrayInputStream(sDatos.getBytes(str)), Charset.forName(str)));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(iso);
    }

    @Override
    public String XmlDoc2String(Document doc) throws Exception {
        StringWriter stw = new StringWriter();
        Transformer serializer = TransformerFactory.newInstance().newTransformer();
        serializer.setOutputProperty("encoding", doc.getXmlEncoding());
        serializer.transform(new DOMSource(doc), new StreamResult(stw));
        return stw.toString();
    }

    @Override
    public Document xmlString2Document(String xml) throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes());
        DocumentBuilderFactory newInstance = DocumentBuilderFactory.newInstance();
        newInstance.setNamespaceAware(true);
        Document parse = newInstance.newDocumentBuilder().parse(inputStream);
        return parse;
    }

    @Override
    public boolean document2file(Document doc, String rutaXML) {
        try {
            File fileSal = new File(rutaXML);
            FileOutputStream fos = new FileOutputStream(fileSal);
            fos.write(doc.getDocumentElement().toString().getBytes());
            fos.close();
            return true;
        }
        catch (Exception ex) {
            this.muestraError(ex);
            return false;
        }
    }

    public String document2StringV2(Document doc) {
        try {
            Class<?> newClass = Class.forName("org.apache.xml.serialize.OutputFormat");
            Constructor<?> c = newClass.getConstructor(Document.class, String.class, Boolean.TYPE);
            Object formato = c.newInstance(doc, "UTF-8", true);
            StringWriter se = new StringWriter();
            newClass = Class.forName("org.apache.xml.serialize.XMLSerializer");
            c = newClass.getConstructor(Writer.class, formato.getClass());
            Object ser = c.newInstance(se, formato);
            try {
                Method met = ser.getClass().getMethod("serialize", Document.class);
                met.invoke(ser, doc);
            }
            catch (Exception e) {
                return "error";
            }
            return se.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "ERROR";
        }
    }

    public String document2String(Document doc) {
        String sDoc = doc.getDocumentElement().toString();
        Pattern patron = Pattern.compile("[\t]*", 2);
        Matcher match = patron.matcher(sDoc);
        String s1 = match.replaceAll("");
        patron = Pattern.compile("><", 2);
        match = patron.matcher(s1);
        String s = match.replaceAll(">\n<");
        String[] sv = s.split("\n");
        String tabs = "";
        s = "";
        for (int n = 0; n < sv.length; ++n) {
            int abrir = sv[n].indexOf(60);
            int cerrar = sv[n].indexOf("</");
            if (cerrar == -1) {
                cerrar = sv[n].indexOf("/>");
            }
            if (cerrar != abrir) {
                tabs = tabs + "\t";
            }
            s = s + tabs;
            s = s + sv[n];
            s = s + "\n";
            if (cerrar == -1 || tabs.length() <= 0) continue;
            tabs = tabs.substring(1);
        }
        return s;
    }

    @Override
    public boolean existeIndice(Object[] coleccion, int index) {
        try {
            return coleccion[index] != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public Document file2document(String rutaXML) {
        try {
            FileInputStream fi = new FileInputStream(new File(rutaXML));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(fi);
        }
        catch (Exception ex) {
            this.muestraError(ex);
            return null;
        }
    }

    @Override
    public void bytes2file(byte[] data, String fileName) throws FileNotFoundException, IOException, ExceptionMotor {
        try {
            FileOutputStream out = new FileOutputStream(fileName);
            ((OutputStream)out).write(data);
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public byte[] file2bytesISO(String ruta) throws FileNotFoundException, IOException, ExceptionMotor {
        try {
            String line;
            FileInputStream fis = new FileInputStream(new File(ruta));
            BufferedInputStream bis = new BufferedInputStream(fis);
            BufferedReader breader = new BufferedReader(new InputStreamReader(bis));
            ByteWriterAEAT br = new ByteWriterAEAT();
            while ((line = breader.readLine()) != null) {
                br.writeln(line);
            }
            fis.close();
            bis.close();
            return br.getBytes();
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public byte[] file2bytes(File file) throws IOException, ExceptionMotor {
        try {
            int offset;
            FileInputStream is = new FileInputStream(file);
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                // empty if block
            }
            byte[] bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw new IOException("No se pudo leer el fichero entero " + file.getName());
            }
            ((InputStream)is).close();
            return bytes;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public String dameNombrePartidaSinParentesis(String partida) {
        int i = partida.indexOf("(");
        if (i > -1) {
            return partida.substring(0, i);
        }
        return partida;
    }

    public String dameRutaCompletaEntrada(IGestorConfiguracion gc, String nombreEntrada) {
        try {
            IRegEntrada ent = gc.getEntrada(nombreEntrada);
            if (ent == null) {
                throw new Exception("La entrada " + nombreEntrada + " no existe!!!");
            }
            String ret = ent.getIdVariable();
            if (gc.getRuta(ent.getIdVariable()).length() > 0) {
                ret = gc.getRuta(ent.getIdVariable());
            }
            IRegTabla tab = gc.getTabla(ent.getIdTabla());
            while (true) {
                ret = tab.getIdTabla() + "/" + ret;
                if (tab.getNivel() == 0) break;
                tab = gc.getTabla(tab.getTablaPadre());
            }
            return "/" + ret;
        }
        catch (Exception ex) {
            this.muestraError(ex);
            return nombreEntrada;
        }
    }

    @Override
    public String cadenaSinTildes(String cadena) {
        try {
            return cadena.replaceAll("\u00c1", "A").replaceAll("\u00c0", "A").replaceAll("\u00e1", "a").replaceAll("\u00e0", "a").replaceAll("\u00c9", "E").replaceAll("\u00c8", "E").replaceAll("\u00e9", "e").replaceAll("\u00e8", "e").replaceAll("\u00cd", "I").replaceAll("\u00cc", "I").replaceAll("\u00ed", "i").replaceAll("\u00ec", "i").replaceAll("\u00d3", "O").replaceAll("\u00d2", "O").replaceAll("\u00f3", "o").replaceAll("\u00f2", "o").replaceAll("\u00da", "U").replaceAll("\u00d9", "U").replaceAll("\u00fa", "u").replaceAll("\u00f9", "u");
        }
        catch (Exception ex) {
            this.muestraError(ex);
            return cadena;
        }
    }

    @Override
    public boolean unZip(File jarFile, String destDir) {
        try {
            boolean ret = true;
            JarFile jar = new JarFile(jarFile);
            Enumeration<JarEntry> enume = jar.entries();
            while (enume.hasMoreElements()) {
                JarEntry file = enume.nextElement();
                File f = new File(destDir + File.separator + file.getName());
                if (file.isDirectory()) {
                    ret &= f.mkdir();
                    continue;
                }
                InputStream is = jar.getInputStream(file);
                FileOutputStream fos = new FileOutputStream(f);
                while (is.available() > 0) {
                    fos.write(is.read());
                }
                fos.close();
                is.close();
            }
            return true;
        }
        catch (Exception ex) {
            this.muestraError(ex);
            return false;
        }
    }

    @Override
    public byte[] object2byteArray(Object objeto) throws ExceptionMotor {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(objeto);
            oos.flush();
            oos.close();
            bos.flush();
            byte[] ret = bos.toByteArray();
            bos.close();
            return ret;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Object byteArray2object(byte[] bytes) throws ExceptionMotor {
        try {
            return new ObjectInputStream(new ByteArrayInputStream(bytes)).readObject();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Object byteArray2object(byte[] bytes, ClassLoader cls) throws ExceptionMotor {
        try {
            return new ObjectInputStreamAEAT(new ByteArrayInputStream(bytes), cls).readObject();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public InputStream byteArray2inputStream(byte[] bytes) throws IOException {
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public byte[] inputStream2byteArray(InputStream is) throws IOException {
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean eof = false;
        while (!eof) {
            int bytesLeidos = is.read(buffer);
            if (bytesLeidos != 1024) {
                eof = true;
            }
            if (bytesLeidos != -1 && eof) {
                baos.write(buffer, 0, bytesLeidos);
                break;
            }
            if (bytesLeidos != 1024) continue;
            baos.write(buffer, 0, bytesLeidos);
        }
        baos.flush();
        baos.close();
        return baos.toByteArray();
    }

    @Override
    public List<ITipoDatosCampoValor> ListRaw2ListTipada(List<String> listado) throws ExceptionMotor {
        try {
            ArrayList<ITipoDatosCampoValor> ret = new ArrayList<ITipoDatosCampoValor>();
            for (int i = 0; i < listado.size(); i += 2) {
                ret.add(new TipoDatosCampoValor(listado.get(i), listado.get(i + 1)));
            }
            return ret;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public InputStream getRecurso(String nombreRecurso, String rutaJar) throws ExceptionMotor {
        InputStream is = null;
        try {
            Object lfj;
            if (FuncionesUtiles.getFuncionesUtiles().fileExists(nombreRecurso)) {
                is = new FileInputStream(nombreRecurso);
            }
            if (is == null) {
                lfj = null;
                lfj = new LectorFicheroJar(rutaJar);
                is = ((LectorFicheroJar)lfj).getInputStream(nombreRecurso);
            }
            if (is == null) {
                throw new ExceptionMotor("recurso no encontrado");
            }
            lfj = is;
            return lfj;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, nombreRecurso);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    public String getMemoriaLibre() {
        try {
            Runtime runtime = Runtime.getRuntime();
            NumberFormat format = NumberFormat.getInstance();
            StringBuilder sb = new StringBuilder();
            long maxMemory = runtime.maxMemory();
            long allocatedMemory = runtime.totalMemory();
            long freeMemory = runtime.freeMemory();
            sb.append("****************************************************************************\n");
            sb.append("free memory: " + format.format(freeMemory / 1024L));
            sb.append("\nallocated memory: " + format.format(allocatedMemory / 1024L));
            sb.append("\nmax memory: " + format.format(maxMemory / 1024L));
            sb.append("\ntotal free memory: " + format.format((freeMemory + (maxMemory - allocatedMemory)) / 1024L));
            return format.format((freeMemory + (maxMemory - allocatedMemory)) / 1024L);
        }
        catch (Exception ex) {
            return ex.toString();
        }
    }

    public Object getInstancia(String nombreClase, Object[] parametrosInit, ClassLoader cl) throws ExceptionMotor {
        Class<?> clase = null;
        try {
            if (cl != null) {
                clase = cl.loadClass(nombreClase);
            }
            if (clase == null) {
                if (this.getClass().getClassLoader() != null) {
                    clase = this.getClass().getClassLoader().loadClass(nombreClase);
                }
                if (clase == null) {
                    clase = Class.forName(nombreClase);
                }
            }
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
        return this.getInstancia(clase, parametrosInit);
    }

    public Object getInstancia(String nombreClase, Object[] parametrosInit) throws ExceptionMotor {
        return this.getInstancia(nombreClase, parametrosInit, this.getClass().getClassLoader());
    }

    @Override
    public Object getInstancia(Class<?> clase, Object[] parametrosInit) throws ExceptionMotor {
        if (aopInyectorAOPDisponible) {
            try {
                Object instancia = Class.forName("aop.InyectorAOP").getMethod("getInstancia", Class.class).invoke(null, clase);
                if (instancia == null) {
                    throw new Exception("Clase no adaptada a AOP...");
                }
                try {
                    this.ejecutaInit(instancia, clase, parametrosInit, true);
                }
                catch (Exception ex) {
                    throw new Exception("No se pudo realizar el constructor de la clase... " + clase.getCanonicalName());
                }
                return instancia;
            }
            catch (Exception ex) {
                aopInyectorAOPDisponible = false;
            }
        }
        try {
            Object instancia = clase.newInstance();
            this.ejecutaInit(instancia, clase, parametrosInit, true);
            return instancia;
        }
        catch (Exception ex) {
            String cls = "";
            try {
                cls = clase.getName();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new ExceptionMotor(ex, cls);
        }
    }

    private void ejecutaInit(Object instancia, Class<?> clase, Object[] parametrosInit, boolean lanzaExcepcion) throws Exception {
        block3: {
            try {
                if (IAop.class.isInstance(instancia)) {
                    ((IAop)instancia).init(parametrosInit);
                }
            }
            catch (Exception ex) {
                if (!lanzaExcepcion) break block3;
                throw ex;
            }
        }
    }

    @Override
    public byte[] serializaObjeto(Object obj) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        ObjectOutputStream o = new ObjectOutputStream(b);
        o.writeObject(obj);
        return b.toByteArray();
    }

    @Override
    public Object desSerializaObjeto(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream b = new ByteArrayInputStream(bytes);
        ObjectInputStream o = new ObjectInputStream(b);
        return o.readObject();
    }

    @Override
    public void serializaObjeto(Object obj, String path) throws ExceptionMotor {
        try {
            FileOutputStream f_out = new FileOutputStream(path);
            ObjectOutputStream obj_out = new ObjectOutputStream(f_out);
            obj_out.writeObject(obj);
            try {
                obj_out.close();
            }
            catch (Exception ex) {}
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Object desSerializaObjeto(String path) throws ExceptionMotor {
        ObjectInputStream obj_in = null;
        try {
            FileInputStream f_in = new FileInputStream(path);
            obj_in = new ObjectInputStream(f_in);
            Object object = obj_in.readObject();
            return object;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
        finally {
            try {
                if (obj_in != null) {
                    obj_in.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    @Override
    public boolean esLLamadaRecursiva() throws ExceptionMotor {
        try {
            StackTraceElement[] pila = Thread.currentThread().getStackTrace();
            for (int i = 0; i < pila.length; ++i) {
                if (!pila[i].getClassName().equalsIgnoreCase(this.getClass().getName()) || !pila[i].getMethodName().equalsIgnoreCase("esLLamadaRecursiva")) continue;
                StackTraceElement metodo = pila[i + 1];
                for (int j = i + 2; j < pila.length; ++j) {
                    boolean fname = false;
                    if (pila[j].getFileName() == null || pila[j].getFileName().equalsIgnoreCase(metodo.getFileName())) {
                        fname = true;
                    }
                    if (!pila[j].getClassName().equalsIgnoreCase(metodo.getClassName()) || !pila[j].getMethodName().equals(metodo.getMethodName()) || !fname) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public String convierteMesenNumero(String mes) {
        if (mes.trim().equalsIgnoreCase("ENERO")) {
            return "01";
        }
        if (mes.trim().equalsIgnoreCase("FEBRERO")) {
            return "02";
        }
        if (mes.trim().equalsIgnoreCase("MARZO")) {
            return "03";
        }
        if (mes.trim().equalsIgnoreCase("ABRIL")) {
            return "04";
        }
        if (mes.trim().equalsIgnoreCase("MAYO")) {
            return "05";
        }
        if (mes.trim().equalsIgnoreCase("JUNIO")) {
            return "06";
        }
        if (mes.trim().equalsIgnoreCase("JULIO")) {
            return "07";
        }
        if (mes.trim().equalsIgnoreCase("AGOSTO")) {
            return "08";
        }
        if (mes.trim().equalsIgnoreCase("SEPTIEMBRE")) {
            return "09";
        }
        if (mes.trim().equalsIgnoreCase("OCTUBRE")) {
            return "10";
        }
        if (mes.trim().equalsIgnoreCase("NOVIEMBRE")) {
            return "11";
        }
        if (mes.trim().equalsIgnoreCase("DICIEMBRE")) {
            return "12";
        }
        return "00";
    }

    @Override
    public String convierteNumeroEnMes(String num) {
        if (num.trim().equalsIgnoreCase("01")) {
            return "ENERO";
        }
        if (num.trim().equalsIgnoreCase("02")) {
            return "FEBRERO";
        }
        if (num.trim().equalsIgnoreCase("03")) {
            return "MARZO";
        }
        if (num.trim().equalsIgnoreCase("04")) {
            return "ABRIL";
        }
        if (num.trim().equalsIgnoreCase("05")) {
            return "MAYO";
        }
        if (num.trim().equalsIgnoreCase("06")) {
            return "JUNIO";
        }
        if (num.trim().equalsIgnoreCase("07")) {
            return "JULIO";
        }
        if (num.trim().equalsIgnoreCase("08")) {
            return "AGOSTO";
        }
        if (num.trim().equalsIgnoreCase("09")) {
            return "SEPTIEMBRE";
        }
        if (num.trim().equalsIgnoreCase("10")) {
            return "OCTUBRE";
        }
        if (num.trim().equalsIgnoreCase("11")) {
            return "NOVIEMBRE";
        }
        if (num.trim().equalsIgnoreCase("12")) {
            return "DICIEMBRE";
        }
        return "";
    }

    @Override
    public boolean existeConstructorPorDefecto(Class<?> clase) throws Exception {
        Constructor<?>[] constructores;
        for (Constructor<?> constructor : constructores = clase.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 0 || constructor.getModifiers() != 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public void muestraTrazaAccesoDDBB(String cadena) {
    }

    public ITipoDatoRetornoProceso completaConErroresRecomendadosLista(ITipoDatoRetornoProceso retorno, ISesion sesion) {
        try {
            TipoDatoRetornoProceso ret = new TipoDatoRetornoProceso(retorno);
            ret.setListadoErrores(this.completaConErroresRecomendadosLista(ret.getListadoErrores(), sesion));
            ret.setListadoWarnings(this.completaConErroresRecomendadosLista(ret.getListadoWarnings(), sesion));
            return ret;
        }
        catch (Exception ex) {
            return retorno;
        }
    }

    public IRegError generarErrorSiNoExiste(ISesion sesion, String idError) throws ExceptionMotor {
        try {
            IRegError err = sesion.getModelo().getGestorConfiguracion().getError(idError);
            if (err == null) {
                try {
                    if (idError.endsWith(".0")) {
                        err = sesion.getModelo().getGestorConfiguracion().getError(idError.substring(0, idError.length() - 2));
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (err == null) {
                    err = new RegError();
                    err.inicializaRegError(idError, "");
                    err.setTipoError("E");
                    if (idError.equalsIgnoreCase("CHRNV")) {
                        err.setMsg("Caracteres no v\u00e1lidos.");
                    } else if (idError.equalsIgnoreCase("OVERFLOW_MOTOR")) {
                        err.setMsg("La partida supera el m\u00e1ximo permitido.");
                    } else if (idError.equalsIgnoreCase("IMPROCEDENTE")) {
                        err.setMsg("Contenido improcedente.");
                    } else if (idError.equalsIgnoreCase("LNGINC")) {
                        err.setMsg("Longitud incorrecta.");
                    } else if (idError.equalsIgnoreCase("MAXERR")) {
                        err.setMsg("Existen m\u00e1s errores. No se muestran puesto que super\u00f3 el m\u00e1ximo a visualizar.");
                    } else if (idError.equalsIgnoreCase("ADDERR")) {
                        err.setMsg("Error al a\u00f1adir registro.");
                    } else if (idError.equalsIgnoreCase("FECHERR")) {
                        err.setMsg("Fecha incorrecta");
                    } else if (idError.equalsIgnoreCase("ERRMAXREG")) {
                        err.setMsg("No se pueden a\u00f1adir mas registros");
                    } else {
                        err.setMsg("Texto de error no encontrado!!!");
                    }
                }
            }
            return err;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public List<IRegError> completaConErroresRecomendadosLista(List<IRegError> listadoErrores, ISesion sesion) {
        try {
            ArrayList<IRegError> listaClonada = new ArrayList<IRegError>();
            for (IRegError errOriginal : listadoErrores) {
                IRegError clon = errOriginal.clone();
                if (clon.getIdError().equalsIgnoreCase("MAXERR")) {
                    clon.setMensajeRecomendado(clon.getMsg());
                } else {
                    if ("".equals(clon.getMsg()) && clon.getPropiedad("CLASE_ORIGEN_ERROR") != null && clon.getPropiedad("CLASE_ORIGEN_ERROR").toString().equalsIgnoreCase("VALIDACIONPREVIA")) {
                        if (clon.getIdError().equalsIgnoreCase("EMALREG3")) {
                            clon.setMensajeRecomendado("Longitud de Registro incorrecta");
                        } else if (clon.getIdError().equalsIgnoreCase("EMALREG")) {
                            clon.setMensajeRecomendado("Tipo de registro desconocido");
                        } else if (clon.getIdError().equalsIgnoreCase("EMALEMP")) {
                            clon.setMensajeRecomendado("El Fichero est\u00e1 vacio");
                        } else if (clon.getIdError().equalsIgnoreCase("NOREGS")) {
                            clon.setMensajeRecomendado("Fichero sin registros");
                        } else {
                            clon.setMensajeRecomendado("Validaci\u00f3n previa de condiciones");
                        }
                    }
                    if ("".equals(clon.getMsg()) && clon.getPropiedad("CLASE_ORIGEN_ERROR") != null && clon.getPropiedad("CLASE_ORIGEN_ERROR").toString().equalsIgnoreCase("VALIDACIONESTRUCTURA")) {
                        clon.setMensajeRecomendado("Validaci\u00f3n de estructura de registro");
                    }
                    if (!"".equals(clon.getMsg()) && clon.getPropiedad("CLASE_ORIGEN_ERROR") != null && clon.getPropiedad("CLASE_ORIGEN_ERROR").toString().equalsIgnoreCase("VALIDACIONESTRUCTURA")) {
                        clon.setMensajeRecomendado("Contenido incorrecto en '" + clon.getMsg() + "'");
                        clon.setPropiedad("CAMPO", clon.getMsg());
                        clon.setPropiedad("CODERRORI18N", "CONTINCCAMPO");
                    }
                    if (clon.getPropiedad("CLASE_ORIGEN_ERROR") != null && clon.getPropiedad("CLASE_ORIGEN_ERROR").toString().equalsIgnoreCase("VALIDACIONCARACTERES")) {
                        if (clon.getIdError().equalsIgnoreCase("LNGINC")) {
                            clon.setMensajeRecomendado("El dato supera la longitud m\u00e1xima");
                            clon.setPropiedad("CODERRORI18N", "LNGINC");
                        } else {
                            clon.setMensajeRecomendado("Caracteres no v\u00e1lidos en '" + clon.getMsg() + "'");
                            clon.setPropiedad("CODERRORI18N", "CHRNV");
                            clon.setPropiedad("CAMPO", clon.getMsg());
                        }
                    }
                    if (clon.getPropiedad("CLASE_ORIGEN_ERROR") != null && clon.getPropiedad("CLASE_ORIGEN_ERROR").toString().equalsIgnoreCase("VALIDACIONEXTRA")) {
                        if (clon.getIdError().endsWith("1")) {
                            clon.setMensajeRecomendado("Se sustituyen caracteres en '" + clon.getMsg() + "'");
                            clon.setPropiedad("CODERRORI18N", "SUSTCHRS");
                            clon.setPropiedad("CAMPO", clon.getMsg());
                        } else if (clon.getIdError().endsWith("2")) {
                            clon.setMensajeRecomendado("Campo actualizado '" + clon.getMsg() + "'");
                            clon.setPropiedad("CODERRORI18N", "CAMPACT");
                            clon.setPropiedad("CAMPO", clon.getMsg());
                        } else {
                            clon.setMensajeRecomendado("Desconocido pero sobre " + clon.getCampoError() + " " + clon.getMsg());
                            clon.setPropiedad("CAMPO", clon.getCampoError());
                            clon.setPropiedad("CODERRORI18N", "UNKNWN");
                        }
                    }
                    if (clon.getIdError().equalsIgnoreCase("IMPROCEDENTE")) {
                        IRegError errorDefinidoPorUsuario = sesion.getModelo().getGestorConfiguracion().getError(clon.getIdError());
                        String campo = clon.getCampoError();
                        if (clon.getPropiedad("LITERAL") != null) {
                            campo = clon.getPropiedad("LITERAL").toString();
                        }
                        if (errorDefinidoPorUsuario != null) {
                            clon.setMensajeRecomendado(errorDefinidoPorUsuario.getMsg() + " '" + campo + "'");
                            clon.setPropiedad("CODERRORI18N", errorDefinidoPorUsuario.getMsg());
                            clon.setPropiedad("CAMPO", campo);
                        } else {
                            clon.setMensajeRecomendado("Contenido improcedente en '" + campo + "'");
                            clon.setPropiedad("CODERRORI18N", "IMPROCEDENTE");
                            clon.setPropiedad("CAMPO", campo);
                        }
                    }
                    if (clon.getPropiedad("CLASE_ORIGEN_ERROR") != null && clon.getPropiedad("CLASE_ORIGEN_ERROR").toString().equalsIgnoreCase("CASO_ESPECIAL")) {
                        String errorId = clon.getIdError();
                        clon.setMensajeRecomendado(sesion.getModelo().getGestorConfiguracion().getError(errorId).getMsg());
                    }
                    if (clon.getMensajeRecomendado() == null || clon.getMensajeRecomendado().trim().length() == 0) {
                        clon.setMensajeRecomendado(clon.getMsg());
                    }
                }
                if (clon.getPropiedad("CODERRORI18N") == null && clon.getIdError() != null) {
                    clon.setPropiedad("CODERRORI18N", clon.getIdError());
                }
                listaClonada.add(clon);
            }
            return listaClonada;
        }
        catch (Exception ex) {
            return listadoErrores;
        }
    }

    @Override
    public byte[] compressByteArray(byte[] aComprimir) throws ExceptionMotor {
        try {
            Deflater compressor = new Deflater();
            compressor.setLevel(1);
            compressor.setInput(aComprimir);
            compressor.finish();
            ByteArrayOutputStream bos = new ByteArrayOutputStream(aComprimir.length);
            byte[] buf = new byte[1024];
            while (!compressor.finished()) {
                int count = compressor.deflate(buf);
                bos.write(buf, 0, count);
            }
            try {
                bos.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return bos.toByteArray();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public byte[] inflateByteArray(byte[] aDesComprimir) throws ExceptionMotor {
        try {
            InflaterInputStream inflInstream = new InflaterInputStream(new ByteArrayInputStream(aDesComprimir), new Inflater());
            ByteArrayOutputStream outstream = new ByteArrayOutputStream();
            try {
                int l;
                byte[] b = new byte[1024];
                while ((l = inflInstream.read(b, 0, 1024)) != -1) {
                    outstream.write(b, 0, l);
                }
                inflInstream.close();
                outstream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return outstream.toByteArray();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public ITablaMotorEntrada sacaDeLista(Map<String, ITablaMotorEntrada> listaCamposBD, String intento1, String intento2) throws ExceptionMotor {
        try {
            if (listaCamposBD.containsKey(intento1)) {
                return listaCamposBD.get(intento1);
            }
            if (listaCamposBD.containsKey(intento2)) {
                return listaCamposBD.get(intento2);
            }
            throw new Exception("Imposible encontrar ni " + intento1 + " ni " + intento2);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public ITablaMotorEntrada sacaDeListaEx(Map<String, ITablaMotorEntrada> listaCamposBD, String ... intentos) throws ExceptionMotor {
        try {
            for (String intento : intentos) {
                if (!listaCamposBD.containsKey(intento)) continue;
                return listaCamposBD.get(intento);
            }
            throw new Exception("Imposible encontrar campo " + intentos);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public String dameValorAtributo(NamedNodeMap attr, String nombreAtributo) throws ExceptionMotor {
        try {
            for (int i = 0; i < attr.getLength(); ++i) {
                if (!attr.item(i).getNodeName().equalsIgnoreCase(nombreAtributo)) continue;
                return attr.item(i).getNodeValue();
            }
            return null;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public String damePrimeraOpcion(List<String> listado) {
        try {
            if (listado != null && listado.size() > 0) {
                return listado.get(0);
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public IOperaciones getClaseOperaciones() throws ExceptionMotor {
        return OperacionesV2.getOperacionesWrapper();
    }

    protected static class DefaultNodeNameComparator
    implements Comparator<Node> {
        protected DefaultNodeNameComparator() {
        }

        @Override
        public int compare(Node arg0, Node arg1) {
            return arg0.getNodeName().compareTo(arg1.getNodeName());
        }
    }
}

