/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.utilidades;

import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesionExtendida;
import es.aeat.pftw.mtrc.puente.IBusquedaNodos;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import java.io.Serializable;

public class FreezerMotor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private IBusquedaNodos buscadorDeNodosTablaMotor = null;
    private boolean isfreezed = false;
    private Object nodoSalvado = null;
    private Object datosSalvados = null;
    private ISesion sesion = null;

    public FreezerMotor(ISesion sesion) {
        this.sesion = sesion;
        this.isfreezed = false;
    }

    protected ISesion getSesion() {
        return this.sesion;
    }

    public void freezeCompleto() throws ExceptionMotor {
        try {
            if (this.isIsfreezed()) {
                throw new ExceptionMotor("no se puede freeze dos veces, llame a unfreeze o a cancelfreeze");
            }
            this.freeze();
            this.datosSalvados = this.getSesion().getOperaciones().clona();
            if (this.datosSalvados == null) {
                throw new Exception("Error al clonar!!!");
            }
        }
        catch (Exception ex) {
            this.setIsfreezed(false);
            throw new ExceptionMotor(ex);
        }
    }

    public void freeze() throws ExceptionMotor {
        try {
            if (this.isIsfreezed()) {
                throw new ExceptionMotor("no se puede freeze dos veces, llame a unfreeze o a cancelfreeze");
            }
            this.datosSalvados = null;
            this.setNodoSalvado(null);
            this.setNodoSalvado(((ISesionExtendida)this.getSesion()).cloneListaNodosPrincipales());
            this.setIsfreezed(true);
        }
        catch (Exception ex) {
            this.setIsfreezed(false);
            if (ex instanceof ExceptionMotor) {
                throw (ExceptionMotor)ex;
            }
            throw new ExceptionMotor(ex);
        }
    }

    public void cancelfreeze() throws ExceptionMotor {
        try {
            if (!this.isIsfreezed()) {
                throw new ExceptionMotor("llame antes a freeze");
            }
            this.setNodoSalvado(null);
            this.datosSalvados = null;
            this.setIsfreezed(false);
        }
        catch (Exception ex) {
            this.setIsfreezed(false);
            if (ex instanceof ExceptionMotor) {
                throw (ExceptionMotor)ex;
            }
            throw new ExceptionMotor(ex);
        }
    }

    public void unfreeze() throws ExceptionMotor {
        try {
            if (!this.isIsfreezed()) {
                throw new ExceptionMotor("llame antes a freeze");
            }
            this.setIsfreezed(false);
            ((ISesionExtendida)this.getSesion()).overwriteListaNodosPrincipales(this.getNodoSalvado(), this.datosSalvados != null);
            this.setNodoSalvado(null);
            if (this.datosSalvados != null) {
                if (!this.getSesion().getOperaciones().restauraDocumento(this.datosSalvados)) {
                    throw new Exception("Error al restaurar los datos sobre el origen de datos!!!");
                }
                this.datosSalvados = null;
            }
        }
        catch (Exception ex) {
            this.setIsfreezed(false);
            if (ex instanceof ExceptionMotor) {
                throw (ExceptionMotor)ex;
            }
            throw new ExceptionMotor(ex);
        }
    }

    public void dispose() {
        this.sesion = null;
        this.buscadorDeNodosTablaMotor = null;
        this.nodoSalvado = null;
        this.datosSalvados = null;
    }

    public boolean isFreezed() {
        return this.isIsfreezed();
    }

    protected void setBuscadorDeNodosTablaMotor(IBusquedaNodos buscadorDeNodosTablaMotor) {
        this.buscadorDeNodosTablaMotor = buscadorDeNodosTablaMotor;
    }

    protected IBusquedaNodos getBuscadorDeNodosTablaMotor() {
        return this.buscadorDeNodosTablaMotor;
    }

    protected void setIsfreezed(boolean isfreezed) {
        this.isfreezed = isfreezed;
    }

    protected boolean isIsfreezed() {
        return this.isfreezed;
    }

    protected void setNodoSalvado(Object nodoSalvado) {
        this.nodoSalvado = nodoSalvado;
    }

    protected Object getNodoSalvado() {
        return this.nodoSalvado;
    }
}

