/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.utilidades;

import es.aeat.pftw.mtrc.utilidades.IFileWriterAEAT;
import es.aeat.pftw.mtrc.utilidades.IWriterAEAT;
import es.aeat.pftw.mtrc.utilidades.StringAEAT;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class FileWriterAEAT
extends FileOutputStream
implements Serializable,
IWriterAEAT,
IFileWriterAEAT {
    private static final long serialVersionUID = 1L;
    private String newLine = "\r\n";
    private String charset = "ISO-8859-1";
    private boolean escribirAlCerrar = false;
    private List<byte[]> cadenas = new ArrayList<byte[]>();

    public FileWriterAEAT(File file) throws IOException {
        super(file);
    }

    public FileWriterAEAT(File file, boolean append) throws IOException {
        super(file, append);
    }

    public FileWriterAEAT(FileDescriptor fd) throws IOException {
        super(fd);
    }

    public FileWriterAEAT(String fileName) throws IOException {
        super(fileName);
    }

    public FileWriterAEAT(String fileName, boolean append) throws IOException {
        super(fileName, append);
    }

    protected void comunWrite(byte[] datos) throws ExceptionMotor {
        try {
            if (this.isEscribirAlCerrar()) {
                this.cadenas.add(datos);
            } else {
                this.write(datos);
            }
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public void writeln() throws ExceptionMotor {
        try {
            this.comunWrite(this.newLine.getBytes(this.charset));
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public void writeln(String str) throws ExceptionMotor {
        try {
            this.writeln(str.getBytes(this.charset));
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public void writeln(byte[] bbuf) throws IOException {
        try {
            this.comunWrite(bbuf);
            this.comunWrite(this.newLine.getBytes(this.charset));
        }
        catch (ExceptionMotor e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void write(String bbuf) throws ExceptionMotor {
        try {
            this.comunWrite(bbuf.getBytes(this.charset));
        }
        catch (Exception e) {
            throw new ExceptionMotor(e.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isEscribirAlCerrar()) {
            for (byte[] cad : this.cadenas) {
                this.write(cad);
            }
        }
        super.close();
    }

    @Override
    public void setEscribirAlCerrar(boolean escribirAlCerrar) {
        this.escribirAlCerrar = escribirAlCerrar;
    }

    @Override
    public boolean isEscribirAlCerrar() {
        return this.escribirAlCerrar;
    }

    @Override
    public List<byte[]> getCadenas() {
        return this.cadenas;
    }

    @Override
    public void sobreEscribirContenido(String cadena) throws ExceptionMotor {
        try {
            if (!this.isEscribirAlCerrar()) {
                throw new ExceptionMotor("Accion no soportada!!!");
            }
            this.cadenas.clear();
            this.write(cadena);
        }
        catch (ExceptionMotor e) {
            throw e;
        }
        catch (Exception ee) {
            throw new ExceptionMotor(ee);
        }
    }

    @Override
    public String toString() {
        try {
            StringAEAT ret = new StringAEAT();
            for (byte[] cad : this.getCadenas()) {
                ret.append(new String(cad));
            }
            return ret.getString();
        }
        catch (Exception em) {
            em.printStackTrace();
            return super.toString();
        }
    }
}

