/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.utilidades;

import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class FileOutputStreamCompressed
implements Serializable {
    private static final long serialVersionUID = 1L;
    private FileOutputStream fo = null;
    private Charset codificacion = Charset.forName("ISO-8859-1");
    private List<String> cadenas = new ArrayList<String>();

    public FileOutputStreamCompressed(String name) throws FileNotFoundException {
        this.fo = new FileOutputStream(name);
    }

    public FileOutputStreamCompressed(String name, boolean append) throws FileNotFoundException {
        this.fo = new FileOutputStream(name, append);
    }

    public FileOutputStreamCompressed(File file) throws FileNotFoundException {
        this.fo = new FileOutputStream(file);
    }

    public FileOutputStreamCompressed(File file, boolean append) throws FileNotFoundException {
        this.fo = new FileOutputStream(file, append);
    }

    public FileOutputStreamCompressed(FileDescriptor fdObj) {
        this.fo = new FileOutputStream(fdObj);
    }

    public void close() throws IOException {
        String cadenaFinal = "";
        for (int i = 0; i < this.cadenas.size(); ++i) {
            cadenaFinal = cadenaFinal + this.cadenas.get(i);
        }
        cadenaFinal = FuncionesUtiles.getFuncionesUtiles().comprimeCadena(cadenaFinal, this.getCodificacion());
        this.fo.write(cadenaFinal.getBytes(this.getCodificacion()));
        this.cadenas.clear();
        this.fo.close();
    }

    public final FileDescriptor getFD() throws IOException {
        return this.fo.getFD();
    }

    public FileChannel getChannel() {
        return this.fo.getChannel();
    }

    public void write(String cadena) throws IOException {
        this.cadenas.add("" + cadena);
    }

    public void write(byte[] cadena) throws IOException {
        this.write(new String(cadena, 0, cadena.length));
    }

    public void setCodificacion(Charset codificacion) {
        this.codificacion = codificacion;
    }

    public Charset getCodificacion() {
        return this.codificacion;
    }
}

