/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.utilidades;

import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;

public class FileInputStreamCompressed
extends InputStream
implements Serializable {
    private static final long serialVersionUID = 1L;
    private FileInputStream fi = null;
    private Charset codificacion = Charset.forName("ISO-8859-1");
    private byte[] buffer = null;
    private int punteroActual = 0;

    public FileInputStreamCompressed(String name) throws FileNotFoundException {
        this.fi = new FileInputStream(name);
    }

    public FileInputStreamCompressed(File file) throws FileNotFoundException {
        this.fi = new FileInputStream(file);
    }

    public FileInputStreamCompressed(FileDescriptor fdObj) {
        this.fi = new FileInputStream(fdObj);
    }

    @Override
    public void close() throws IOException {
        this.fi.close();
    }

    private byte[] getBuffer() throws IOException {
        if (this.buffer == null) {
            this.buffer = this.readFile(this.fi);
            this.buffer = FuncionesUtiles.getFuncionesUtiles().desComprimeCadena(new String(this.buffer, 0, this.buffer.length, this.getCodificacion()), this.getCodificacion()).getBytes(this.getCodificacion());
        }
        return this.buffer;
    }

    public final FileDescriptor getFD() throws IOException {
        return this.fi.getFD();
    }

    public FileChannel getChannel() {
        return this.fi.getChannel();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.fi.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int longitud = len;
        if (longitud + off + this.punteroActual >= this.getBuffer().length) {
            longitud = this.getBuffer().length - off - this.punteroActual;
        }
        if (longitud > 0) {
            System.arraycopy(this.getBuffer(), off + this.punteroActual, b, 0, longitud);
        }
        if (this.punteroActual == this.getBuffer().length) {
            return -1;
        }
        this.punteroActual += longitud;
        return longitud;
    }

    @Override
    public int read() throws IOException {
        return this.fi.read();
    }

    public void setCodificacion(Charset codificacion) {
        this.codificacion = codificacion;
    }

    public Charset getCodificacion() {
        return this.codificacion;
    }

    private byte[] readFile(InputStream inputStreamOrigen) {
        try {
            byte[] buf = new byte[1024];
            int max = FuncionesUtiles.getFuncionesUtiles().TAM_BUFFER_CADENA;
            byte[] bufferIntermedio = new byte[max];
            int posEscrita = 0;
            boolean eof = false;
            while (!eof) {
                int bytesLeidos = inputStreamOrigen.read(buf);
                if (bytesLeidos != 1024) {
                    eof = true;
                }
                if (bytesLeidos != -1 && eof) {
                    System.arraycopy(buf, 0, bufferIntermedio, posEscrita, bytesLeidos);
                    posEscrita += bytesLeidos;
                    break;
                }
                if (bytesLeidos != 1024) continue;
                System.arraycopy(buf, 0, bufferIntermedio, posEscrita, bytesLeidos);
                posEscrita += bytesLeidos;
            }
            byte[] ret = new byte[posEscrita];
            System.arraycopy(bufferIntermedio, 0, ret, 0, posEscrita);
            return ret;
        }
        catch (Exception ex) {
            FuncionesUtiles.getFuncionesUtiles().muestraError(ex);
            return null;
        }
    }
}

