/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.utilidades;

import es.aeat.pftw.mtrc.utilidades.ByteWriterAEAT;
import es.aeat.pftw.mtrc.utilidades.FileReaderBytes;
import es.aeat.pftw.mtrc.utilidades.IFicherosIntermedios;
import es.aeat.pftw.mtrc.utilidades.IFileReaderBytes;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import java.io.Serializable;

public final class FicherosIntermedios
implements Serializable,
IFicherosIntermedios {
    private static final long serialVersionUID = 1L;
    private int hashRutaFicheroAValidarReal = -1;
    private byte[] rutaFicheroAValidarVirtualLectura = null;
    private ByteWriterAEAT fw = null;
    private IFileReaderBytes fr = null;
    private boolean usarVirtual = false;

    @Override
    public void inicializa() {
        this.hashRutaFicheroAValidarReal = -1;
        this.rutaFicheroAValidarVirtualLectura = null;
        this.fw = null;
        this.fr = null;
        this.usarVirtual = false;
    }

    @Override
    public IFileReaderBytes abrirFichero(byte[] ruta) throws ExceptionMotor {
        try {
            this.fr = null;
            this.fw = null;
            if (this.hashRutaFicheroAValidarReal != ruta.hashCode()) {
                this.hashRutaFicheroAValidarReal = ruta.hashCode();
                this.rutaFicheroAValidarVirtualLectura = (byte[])ruta.clone();
            }
            this.fr = new FileReaderBytes(this.rutaFicheroAValidarVirtualLectura);
            this.fw = new ByteWriterAEAT();
            return this.fr;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean nuevaLinea(String linea, boolean huboCambio) throws ExceptionMotor {
        try {
            if (huboCambio) {
                this.usarVirtual = true;
            }
            if (linea != null) {
                this.fw.write(linea);
            }
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean saltoDeLinea(boolean huboCambio) throws ExceptionMotor {
        try {
            if (huboCambio) {
                this.usarVirtual = true;
            }
            this.fw.writeln();
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void forzarAUsarElVirtual() {
        this.usarVirtual = true;
    }

    @Override
    public boolean cerrarFichero() throws ExceptionMotor {
        try {
            if (this.usarVirtual) {
                this.rutaFicheroAValidarVirtualLectura = this.fw.getBytes();
            }
            if (this.fw != null) {
                this.fw.close();
            }
            this.fw = null;
            if (this.fr != null) {
                this.fr.close();
            }
            this.fr = null;
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean eliminarFicheroVirtual() throws ExceptionMotor {
        try {
            this.rutaFicheroAValidarVirtualLectura = null;
            return true;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void dispose() throws ExceptionMotor {
        this.inicializa();
    }
}

