/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.utilidades;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ClassLoaderFromBytes
extends ClassLoader
implements Serializable {
    private static final long serialVersionUID = 1L;
    List<Object> listaClases = new ArrayList<Object>();

    public ClassLoaderFromBytes(ClassLoader parent, byte[] classBytes) {
        super(parent);
        this.listaClases.add(classBytes);
    }

    public ClassLoaderFromBytes(ClassLoader parent, List<Object> listaClases) {
        super(parent);
        if (listaClases != null && listaClases.size() != 0) {
            for (Object object : listaClases) {
                this.listaClases.add((byte[])object);
            }
        }
    }

    public void dispose() {
        if (this.listaClases != null) {
            this.listaClases.clear();
            this.listaClases = null;
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class<?> cls = this.findLoadedClass(className);
        if (cls != null) {
            return cls;
        }
        try {
            cls = this.intentoCargaClase(null, className, resolve);
        }
        catch (Exception ex) {
            cls = null;
        }
        if (cls != null) {
            return cls;
        }
        if (this.listaClases == null || this.listaClases.size() == 0) {
            throw new ClassNotFoundException("No hay binarios donde buscar : " + className);
        }
        for (Object binarios : this.listaClases) {
            try {
                cls = this.intentoCargaClase((byte[])binarios, className, resolve);
                if (cls == null) continue;
                return cls;
            }
            catch (ClassNotFoundException cnfe) {
                cls = null;
            }
        }
        throw new ClassNotFoundException("Cannot load class: " + className);
    }

    protected Class<?> intentoCargaClase(byte[] classBytes, String className, boolean resolve) throws ClassNotFoundException {
        Class<?> cls = null;
        try {
            if (classBytes == null) {
                throw new NoClassDefFoundError();
            }
            cls = this.defineClass(className, classBytes, 0, classBytes.length);
            if (resolve) {
                this.resolveClass(cls);
            }
        }
        catch (ClassFormatError cfe) {
            throw new ClassNotFoundException(cfe.toString());
        }
        catch (SecurityException e) {
            cls = super.loadClass(className, resolve);
        }
        catch (NoClassDefFoundError nc) {
            cls = super.loadClass(className, resolve);
        }
        return cls;
    }
}

