/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.tipos;

import es.aeat.pftw.mtrp.tipos.IDateMotor;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateMotor
implements Serializable,
IDateMotor {
    private static final long serialVersionUID = 1L;
    private Date date;
    private String fechaCadena;

    public DateMotor(String fecha) {
        this.date = this.pasaloComoUnDate(fecha);
    }

    private Date pasaloComoUnDate(String fecha) {
        if (fecha == null) {
            fecha = "";
        }
        SimpleDateFormat fechaA = new SimpleDateFormat("dd/MM/yyyy");
        if (fecha.length() == 8 && !fecha.contains("-") && !fecha.contains("/")) {
            fecha = fecha.substring(0, 2) + "/" + fecha.substring(2, 4) + "/" + fecha.substring(4);
        }
        fecha = fecha.replaceAll("-", "/");
        this.setFechaCadena(fecha);
        Date retornar = null;
        if (fecha.indexOf(47) != -1) {
            fechaA.setLenient(false);
            try {
                retornar = fechaA.parse(fecha);
                return retornar;
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        return retornar;
    }

    @Override
    public String toString() {
        if (this.getDate() == null) {
            return "";
        }
        return this.getFechaOriginal();
    }

    @Override
    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    public static IDateMotor valueOf(String cadena) {
        return new DateMotor(cadena);
    }

    public static IDateMotor valueOf(IDateMotor dateMotor) {
        return dateMotor;
    }

    protected void setFechaCadena(String fechaCadena) {
        this.fechaCadena = fechaCadena;
    }

    @Override
    public String getFechaOriginal() {
        return this.fechaCadena;
    }
}

