/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.puente;

import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.origenDatos.IOrigenDatos;
import es.aeat.pftw.mtrc.puente.IListaTablaMotor;
import es.aeat.pftw.mtrc.puente.ITablaMotor;
import es.aeat.pftw.mtrc.puente.ListaTablaMotor;
import es.aeat.pftw.mtrc.puente.TablaMotorEntrada;
import es.aeat.pftw.mtrc.tipos.TipoDatosCampoValor;
import es.aeat.pftw.mtrc.utilidades.FileWriterAEAT;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.puente.ITablaMotorEntrada;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampoValor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class TablaMotor
implements Serializable,
ITablaMotor {
    public static long contadorIds = 0L;
    private static final long serialVersionUID = 1L;
    private String nombre;
    private String nombreTablaPadre = "";
    private int nivel;
    private IListaTablaMotor relacionadas;
    private long claveActiva;
    private long claveUnica;
    private long claveSuperior;
    private long claveUnicaSuperior;
    private ITablaMotor ptrTablaPadre = null;
    private IOrigenDatos origenDatosRef = null;
    private ISesion sesion = null;
    private Map<String, Object> cachePartidas = null;
    private Map<String, Integer> cacheEstados = null;

    public TablaMotor(String nom, ITablaMotor tablaPadre, ISesion sesion) throws ExceptionMotor {
        this.sesion = sesion;
        if (sesion != null) {
            this.origenDatosRef = sesion.getOrigenDeDatos();
        }
        this.claveUnica = this.origenDatosRef != null && !this.origenDatosRef.isCreacionIDUnicoAutomatico() ? 0L : ++contadorIds;
        this.claveActiva = 0L;
        this.claveSuperior = 0L;
        this.nombre = nom;
        this.ptrTablaPadre = tablaPadre;
        this.nombreTablaPadre = "";
        this.relacionadas = new ListaTablaMotor();
        if (this.ptrTablaPadre != null) {
            this.nombreTablaPadre = tablaPadre.getNombre();
        }
        this.cachePartidas = new HashMap<String, Object>();
        this.cacheEstados = new HashMap<String, Integer>();
    }

    @Override
    public ISesion getSesion() {
        return this.sesion;
    }

    @Override
    public String getNombre() {
        return this.nombre;
    }

    @Override
    public String getNombreTablaPadre() {
        return this.nombreTablaPadre;
    }

    @Override
    public int getNivel() {
        return this.nivel;
    }

    @Override
    public IListaTablaMotor getRelacionadas() {
        return this.relacionadas;
    }

    @Override
    public void setRelacionadas(IListaTablaMotor listaRel) {
        this.relacionadas = listaRel;
    }

    @Override
    public void setNombre(String nom) {
        this.nombre = nom;
    }

    @Override
    public void setNombreTablaPadre(String nom) {
        this.nombreTablaPadre = nom;
    }

    @Override
    public void setNivel(int iNivel) {
        this.nivel = iNivel;
    }

    @Override
    public ITablaMotor getTablaMotor(String nombre) {
        if (nombre.equalsIgnoreCase(this.nombre)) {
            return this;
        }
        return this.relacionadas.getTablaMotor(nombre);
    }

    @Override
    public ITablaMotor getTablaMotor(Integer i) {
        return this.relacionadas.getTablaMotor(i);
    }

    @Override
    public long getClaveActiva() {
        return this.claveActiva;
    }

    @Override
    public long getClaveUnica() {
        return this.claveUnica;
    }

    @Override
    public long getClaveSuperior() {
        return this.claveSuperior;
    }

    @Override
    public long getClaveUnicaSuperior() {
        return this.claveUnicaSuperior;
    }

    @Override
    public void setClaveSuperior(long clave) {
        this.claveSuperior = clave;
    }

    @Override
    public void setClaveUnicaSuperior(long clave) {
        this.claveUnicaSuperior = clave;
    }

    @Override
    public void setClaveActiva(long clave) {
        if (clave < 0L) {
            clave = 0L;
        }
        this.claveActiva = clave;
    }

    @Override
    public void setClaveUnica(long clave) {
        this.claveUnica = clave;
    }

    @Override
    public boolean establecerEstado(String nombrePartida, String valorString) throws ExceptionMotor {
        return this.establecerEstado(nombrePartida, Integer.valueOf(valorString));
    }

    @Override
    public boolean establecerEstado(String nombrePartida, Integer valorInteger) throws ExceptionMotor {
        try {
            if (this.origenDatosRef.getDifferedWrite() == 1) {
                this.cacheEstados.put(nombrePartida, valorInteger);
                return true;
            }
            return this.origenDatosRef.establecerEstado((ITablaMotor)this, nombrePartida, valorInteger);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public void setPtrTablaPadre(ITablaMotor ptrTablaPadre) {
        this.ptrTablaPadre = ptrTablaPadre;
    }

    @Override
    public ITablaMotor getPtrTablaPadre() {
        return this.ptrTablaPadre;
    }

    @Override
    public int obtenerEstado(String nombrePartida) throws ExceptionMotor {
        try {
            if (this.origenDatosRef.getDifferedWrite() == 1) {
                Integer o = this.cacheEstados.get(nombrePartida);
                if (o == null) {
                    return this.sesion.getModelo().getGestorConfiguracion().getEntrada(nombrePartida).getEstadoInicial();
                }
                return Integer.valueOf(((Object)o).toString());
            }
            return this.origenDatosRef.obtenerEstado(this, nombrePartida);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public String obtenerPartidaString(String nombrePartida, int index) throws ExceptionMotor {
        try {
            return this.origenDatosRef.obtenerPartidaString(this, nombrePartida, index);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public String obtenerPartidaString(String nombrePartida) throws ExceptionMotor {
        try {
            if (this.origenDatosRef.getDifferedWrite() == 1) {
                Object o = this.cachePartidas.get(nombrePartida);
                if (o == null) {
                    return this.sesion.getModelo().getGestorConfiguracion().getEntrada(nombrePartida).getValorInicial();
                }
                return o.toString();
            }
            return this.origenDatosRef.obtenerPartidaString(this, nombrePartida);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public void cerrarTabla() {
        for (int i = 0; i < this.relacionadas.count(); ++i) {
            this.relacionadas.getTablaMotor(i).cerrarTabla();
        }
        this.claveUnicaSuperior = 0L;
        this.claveSuperior = 0L;
        this.claveActiva = 0L;
        this.claveUnica = 0L;
    }

    private String ordenaCamposParaPrintTree(Map<String, ITablaMotorEntrada> campos) {
        try {
            ArrayList<String> arrCampos = new ArrayList<String>();
            Collection<ITablaMotorEntrada> col = campos.values();
            Iterator<ITablaMotorEntrada> i = col.iterator();
            ITablaMotorEntrada t = null;
            while (i.hasNext()) {
                t = i.next();
                arrCampos.add(t.getNombreEntrada() + " = " + t.getValor() + " (" + t.getEstado() + ")");
            }
            Collections.sort(arrCampos);
            return ((Object)arrCampos).toString();
        }
        catch (Exception ex) {
            return "Error al obtener campos";
        }
    }

    private String prvPrintTree(String tabulado, boolean soloNombreTablas) throws ExceptionMotor {
        String subrayado = tabulado + " ";
        for (int i = 0; i < new String("+TABLA     : " + this.nombre).length() - 1; ++i) {
            subrayado = subrayado + "=";
        }
        String cadenaActual = subrayado + "\n" + tabulado + "+TABLA     : " + this.nombre + "\n";
        cadenaActual = cadenaActual + subrayado;
        cadenaActual = cadenaActual + tabulado + " ID LOGICO : " + this.claveActiva + "\n";
        cadenaActual = cadenaActual + tabulado + " ID FISICO : " + this.claveUnica + "\n";
        cadenaActual = cadenaActual + tabulado + " IDINF     : " + this.claveSuperior + "\n";
        String cadTmp = "Null";
        Map<String, ITablaMotorEntrada> campos = this.getRsDatosReferencia();
        if (campos != null && campos.size() > 0) {
            cadTmp = this.ordenaCamposParaPrintTree(campos);
        }
        cadenaActual = cadenaActual + tabulado + " DATOS     : " + cadTmp + "\n";
        cadTmp = "Null";
        if (soloNombreTablas) {
            cadenaActual = ";" + this.nombre + ";";
        }
        if (this.relacionadas != null) {
            TablaMotor rel = null;
            for (int i = 0; i < this.relacionadas.count(); ++i) {
                rel = (TablaMotor)this.relacionadas.getTablaMotor(i);
                if (rel == null) continue;
                cadenaActual = cadenaActual + rel.prvPrintTree(tabulado + "   ", soloNombreTablas);
            }
            rel = null;
        }
        return cadenaActual;
    }

    @Override
    public String printTree() throws ExceptionMotor {
        try {
            String sep = "//////////////////////////////////////////////////////////\n";
            return sep + "INFORMACI\u00d3N NODO :\n" + this.prvPrintTree(" ", false) + "\n" + sep;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean writeTree(String filePath) {
        try {
            FileWriterAEAT fw = new FileWriterAEAT(filePath);
            String cadena = this.printTree();
            String aux = "";
            for (int i = 0; i < cadena.length(); ++i) {
                if (cadena.charAt(i) == '\n') {
                    fw.writeln(aux);
                    aux = "";
                    continue;
                }
                aux = aux + cadena.charAt(i);
            }
            if (aux.length() > 0) {
                fw.writeln(aux);
            }
            fw.close();
            fw = null;
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public String dameListaTablas() throws ExceptionMotor {
        try {
            return this.prvPrintTree("", true);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Map<String, ITablaMotorEntrada> rsDatosClone() throws ExceptionMotor {
        try {
            return (Map)((HashMap)this.getRsDatosReferencia()).clone();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public Map<String, ITablaMotorEntrada> getRsDatosReferencia() throws ExceptionMotor {
        try {
            return this.origenDatosRef.obtenerRegistroFiltroEnPosicion(this);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public boolean limpiaRegistro() throws ExceptionMotor {
        try {
            return this.origenDatosRef.limpiaRegistro(this);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    protected Map<String, ITablaMotorEntrada> clonaRsDatos(Map<String, ITablaMotorEntrada> datos) throws ExceptionMotor {
        try {
            if (datos == null) {
                return null;
            }
            HashMap<String, ITablaMotorEntrada> rsDatosNuevo = new HashMap<String, ITablaMotorEntrada>();
            String entrada2 = "";
            Set<String> s = datos.keySet();
            ITablaMotorEntrada t = new TablaMotorEntrada("");
            if (!t.checkNumeroParametrosParaClonar()) {
                throw new ExceptionMotor("Error no puedo clonar rsDatos");
            }
            t = null;
            for (String entrada2 : s) {
                t = datos.get(entrada2);
                TablaMotorEntrada t2 = new TablaMotorEntrada(t.getNombreEntrada());
                t2.setNombreEntrada(t.getNombreEntrada());
                t2.setEstado(t.getEstado());
                t2.setValor(t.getValor());
                rsDatosNuevo.put(entrada2, t2);
                t2 = null;
            }
            return rsDatosNuevo;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public String getLocalizacion(ITablaMotor nodoPrincipal) {
        if (this.getNombreTablaPadre() == null || this.getNombreTablaPadre().length() == 0) {
            return String.valueOf(this.getClaveActiva());
        }
        return nodoPrincipal.getTablaMotor(this.getNombreTablaPadre()).getLocalizacion(nodoPrincipal) + "-" + this.getClaveActiva();
    }

    @Override
    public long getRecordCount() throws ExceptionMotor {
        return this.origenDatosRef.recordCount(this);
    }

    @Override
    public List<ITipoDatosCampoValor> getLocalizacion() throws ExceptionMotor {
        ArrayList<ITipoDatosCampoValor> ret = new ArrayList<ITipoDatosCampoValor>();
        try {
            for (ITablaMotor ptrAux = this; ptrAux != null; ptrAux = ptrAux.getPtrTablaPadre()) {
                ret.add(0, new TipoDatosCampoValor(ptrAux.getNombre(), String.valueOf(ptrAux.getClaveActiva())));
            }
            return ret;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public List<Object> lightClone() throws ExceptionMotor {
        try {
            ArrayList<Object> clon = new ArrayList<Object>();
            clon.add(this.getClaveUnica());
            clon.add(this.getClaveActiva());
            clon.add(this.getClaveSuperior());
            clon.add(this.getClaveUnicaSuperior());
            ArrayList<List<Object>> relac = null;
            IListaTablaMotor rel = this.getRelacionadas();
            for (int i = 0; i < rel.count(); ++i) {
                ITablaMotor cacheNodo = rel.getTablaMotor(i);
                if (cacheNodo == null) continue;
                if (relac == null) {
                    relac = new ArrayList<List<Object>>();
                }
                relac.add(cacheNodo.lightClone());
                relac.add((List<Object>)i);
                cacheNodo = null;
            }
            clon.add(relac);
            return clon;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean overwriteLightClone(List<Object> clon, boolean esCompleto) throws ExceptionMotor {
        try {
            if (!esCompleto && (Long)clon.get(1) == 0L && this.getClaveActiva() > 0L && this.getSesion().getOperaciones().recordCount(this.nombre) > 0L && this.getSesion().getOperaciones().moveFirst(this.nombre) > 0L) {
                return true;
            }
            this.setClaveUnica((Long)clon.get(0));
            this.setClaveActiva((Long)clon.get(1));
            this.setClaveSuperior((Long)clon.get(2));
            this.setClaveUnicaSuperior((Long)clon.get(3));
            List relac = (List)clon.get(4);
            IListaTablaMotor rel = this.getRelacionadas();
            if (relac != null) {
                for (int i = 0; i < relac.size() - 1; i += 2) {
                    rel.getTablaMotor((Integer)relac.get(i + 1)).overwriteLightClone((List)relac.get(i), esCompleto);
                }
            }
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public ITablaMotor clone(ISesion s) throws CloneNotSupportedException, ExceptionMotor {
        try {
            TablaMotor clon = new TablaMotor(this.getNombre(), this.getPtrTablaPadre(), this.sesion);
            if (s == null) {
                clon.sesion = null;
                clon.origenDatosRef = null;
            } else {
                clon.sesion = s;
                clon.origenDatosRef = s.getOrigenDeDatos();
            }
            clon.setClaveUnica(this.getClaveUnica());
            clon.setClaveActiva(this.getClaveActiva());
            clon.setClaveSuperior(this.getClaveSuperior());
            clon.setClaveUnicaSuperior(this.getClaveUnicaSuperior());
            clon.setNivel(this.getNivel());
            clon.setNombre(this.getNombre());
            clon.setNombreTablaPadre(this.getNombreTablaPadre());
            IListaTablaMotor rel = this.getRelacionadas();
            for (int i = 0; i < rel.count(); ++i) {
                ITablaMotor cacheNodo = rel.getTablaMotor(i);
                if (cacheNodo == null) continue;
                if (clon.getRelacionadas() == null) {
                    clon.setRelacionadas(new ListaTablaMotor());
                }
                clon.getRelacionadas().setTablaMotor(cacheNodo.clone(s), i);
                clon.getRelacionadas().getTablaMotor(i).setPtrTablaPadre(clon);
                cacheNodo = null;
            }
            return clon;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public ITablaMotor clone() throws CloneNotSupportedException {
        try {
            return this.clone(this.sesion);
        }
        catch (ExceptionMotor e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
    }

    @Override
    public String toString() {
        return this.getNombre() + " (ID " + this.getClaveActiva() + " IDINF " + this.getClaveSuperior() + " IDUNICO " + this.getClaveUnica() + ")";
    }

    @Override
    public String toDetailedString() {
        try {
            String cad = "";
            List<ITipoDatosCampoValor> loc = this.getLocalizacion();
            for (int i = 0; i < loc.size(); ++i) {
                cad = cad + "//" + loc.get(i).getNombreCampo() + "[" + loc.get(i).getValor() + "]";
            }
            if (cad.length() == 0) {
                return this.toString();
            }
            return cad;
        }
        catch (Exception ex) {
            FuncionesUtiles.getFuncionesUtiles().muestraAviso(ex);
            return this.toString();
        }
    }

    @Override
    public boolean establecerPartida(String nombrePartida, Object valor) throws ExceptionMotor {
        try {
            if (this.origenDatosRef.getDifferedWrite() == 1) {
                this.cachePartidas.put(nombrePartida, valor);
                return true;
            }
            return this.origenDatosRef.establecerPartida((ITablaMotor)this, nombrePartida, valor);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public Map<String, Object> getCachePartidas() {
        return this.cachePartidas;
    }

    @Override
    public Map<String, Integer> getCacheEstados() {
        return this.cacheEstados;
    }
}

