/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.puente;

import es.aeat.pftw.mtrc.excepciones.NotImplementedException;
import es.aeat.pftw.mtrc.motor.IPartidaModificada;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesionExtendida;
import es.aeat.pftw.mtrc.procesadorReglas.PartidaModificada;
import es.aeat.pftw.mtrc.puente.IGestionOperaciones;
import es.aeat.pftw.mtrc.puente.IListaTablaMotor;
import es.aeat.pftw.mtrc.puente.IRegTablaModificada;
import es.aeat.pftw.mtrc.puente.ITablaMotor;
import es.aeat.pftw.mtrc.puente.RegTablaModificada;
import es.aeat.pftw.mtrc.puente.TablaMotorEntrada;
import es.aeat.pftw.mtrc.tipos.TipoDatosRegistro;
import es.aeat.pftw.mtrc.tipos.TipoListaPartidasAfectadasEnUnaEjecucion;
import es.aeat.pftw.mtrc.utilidades.Formatear;
import es.aeat.pftw.mtrc.utilidades.FreezerMotor;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.utilidades.NodoArbol;
import es.aeat.pftw.mtrp.configuracion.IRegEntrada;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.procesadorReglas.IPartidaModificadaReglas;
import es.aeat.pftw.mtrp.puente.ITablaMotorEntrada;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampoValor;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCriteriosOrdenacion;
import es.aeat.pftw.mtrp.tipos.ITipoDatosRegistro;
import es.aeat.pftw.mtrp.utilidades.INodoArbol;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GestionOperaciones
implements IGestionOperaciones {
    private static final long serialVersionUID = 1L;

    @Override
    public void dispose() {
    }

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
    }

    @Override
    public void recorrerNodosHijos(ISesion sesion, ITablaMotor nodo) throws ExceptionMotor {
        block5: {
            ITablaMotor cTaAux = null;
            try {
                if (nodo.getRelacionadas() != null) {
                    for (int i = 0; i < nodo.getRelacionadas().count(); ++i) {
                        cTaAux = nodo.getRelacionadas().getTablaMotor(i);
                        this.actualizarNodo(sesion, cTaAux, nodo);
                    }
                }
            }
            catch (Exception ex) {
                if (((ISesionExtendida)sesion).isModoSilencioso()) break block5;
                if (ex instanceof ExceptionMotor) {
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex);
            }
        }
    }

    protected void actualizarNodo(ISesion sesion, ITablaMotor cTaAux, ITablaMotor nodo) throws ExceptionMotor {
        try {
            cTaAux.cerrarTabla();
            cTaAux.setClaveSuperior(nodo.getClaveActiva());
            cTaAux.setClaveUnicaSuperior(nodo.getClaveUnica());
            this.moveFirst(sesion, cTaAux.getNombre());
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected void anniadirTablaAListaAfectadasEnUnaEjecucion(ISesion sesion, String nombreTabla, IRegTablaModificada evento) throws ExceptionMotor {
        try {
            List<IRegTablaModificada> eventos = ((ISesionExtendida)sesion).getListaRegistroDeTablasAfectadasEnUnaEjecucion().get(((ISesionExtendida)sesion).getListaRegistroDeTablasAfectadasEnUnaEjecucion().size() - 1).getLista().get(nombreTabla.toUpperCase());
            if (eventos != null) {
                for (int i = 0; i < eventos.size(); ++i) {
                    if (evento.getIdInf() != eventos.get(i).getIdInf() || evento.getId() != eventos.get(i).getId()) continue;
                    if (evento.getAccion().equalsIgnoreCase(eventos.get(i).getAccion())) {
                        return;
                    }
                    if (evento.getAccion().equalsIgnoreCase("del")) {
                        ((ISesionExtendida)sesion).getListaRegistroDeTablasAfectadasEnUnaEjecucion().get(((ISesionExtendida)sesion).getListaRegistroDeTablasAfectadasEnUnaEjecucion().size() - 1).getLista().get(nombreTabla.toUpperCase()).remove(i);
                        return;
                    }
                    if (!evento.getAccion().equalsIgnoreCase("add")) continue;
                    ((ISesionExtendida)sesion).getListaRegistroDeTablasAfectadasEnUnaEjecucion().get(((ISesionExtendida)sesion).getListaRegistroDeTablasAfectadasEnUnaEjecucion().size() - 1).getLista().get(nombreTabla.toUpperCase()).remove(i);
                    ((ISesionExtendida)sesion).getListaRegistroDeTablasAfectadasEnUnaEjecucion().get(((ISesionExtendida)sesion).getListaRegistroDeTablasAfectadasEnUnaEjecucion().size() - 1).getLista().get(nombreTabla.toUpperCase()).add(evento);
                    return;
                }
                ((ISesionExtendida)sesion).getListaRegistroDeTablasAfectadasEnUnaEjecucion().get(((ISesionExtendida)sesion).getListaRegistroDeTablasAfectadasEnUnaEjecucion().size() - 1).getLista().get(nombreTabla.toUpperCase()).add(evento);
            } else {
                eventos = new ArrayList<IRegTablaModificada>();
                eventos.add(evento);
                ((ISesionExtendida)sesion).getListaRegistroDeTablasAfectadasEnUnaEjecucion().get(((ISesionExtendida)sesion).getListaRegistroDeTablasAfectadasEnUnaEjecucion().size() - 1).getLista().put(nombreTabla.toUpperCase(), eventos);
            }
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e, "Tabla " + nombreTabla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean borrarRegistros(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        if (((ISesionExtendida)sesion).isEjecutandoBatchAnniadirRegistro()) {
            throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras existan comandos batch_A\u00f1adirRegistro(...) pendientes", Thread.currentThread().getStackTrace());
        }
        if (sesion.getOrigenDeDatos().isOrigenDeDatosOrdenadoPorCriterio()) {
            throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras este ordenado el origen de datos por un criterio", Thread.currentThread().getStackTrace());
        }
        boolean estadoAnteriorCacheOD = sesion.getOrigenDeDatos().isCacheHabilitada();
        try {
            long j = 0L;
            sesion.getOrigenDeDatos().setCacheHabilitada(false);
            while (this.recordCount(sesion, nombreTabla) != 0L && (j = this.moveFirst(sesion, nombreTabla)) != 0L) {
                this.borrarRegistro(sesion, nombreTabla);
            }
            if (!this.refrescarClaveActivaNodo(sesion, nombreTabla)) {
                throw new ExceptionMotor("No se consigue refrescar la clave activa del nodo " + nombreTabla, Thread.currentThread().getStackTrace());
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            if (!((ISesionExtendida)sesion).isModoSilencioso()) {
                if (ex instanceof ExceptionMotor) {
                    ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + "Tabla " + nombreTabla);
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            sesion.getOrigenDeDatos().setCacheHabilitada(estadoAnteriorCacheOD);
        }
    }

    @Override
    public boolean borrarTodosLosRegistrosDeTabla(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        try {
            if (((ISesionExtendida)sesion).isEjecutandoBatchAnniadirRegistro()) {
                throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras existan comandos batch_A\u00f1adirRegistro(...) pendientes", Thread.currentThread().getStackTrace());
            }
            if (sesion.getOrigenDeDatos().isOrigenDeDatosOrdenadoPorCriterio()) {
                throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras este ordenado el origen de datos por un criterio", Thread.currentThread().getStackTrace());
            }
            ITablaMotor nodo = null;
            nodo = ((ISesionExtendida)sesion).getBusquedaNodosObj().get(((ISesionExtendida)sesion).getPunteroActual()).buscarNodo(nombreTabla, ((ISesionExtendida)sesion).getVarNodoPrincipal().get(((ISesionExtendida)sesion).getPunteroActual()));
            if (nodo == null) {
                return false;
            }
            ITablaMotor nodoPadre = null;
            if (!nodo.getNombreTablaPadre().equalsIgnoreCase("")) {
                nodoPadre = ((ISesionExtendida)sesion).getBusquedaNodosObj().get(((ISesionExtendida)sesion).getPunteroActual()).buscarNodo(nodo.getNombreTablaPadre(), ((ISesionExtendida)sesion).getVarNodoPrincipal().get(((ISesionExtendida)sesion).getPunteroActual()));
                long actual = nodoPadre.getClaveActiva();
                if (this.recordCount(sesion, nombreTabla) > 0L) {
                    this.moveFirst(sesion, nodoPadre.getNombre());
                    while (true) {
                        this.borrarRegistros(sesion, nombreTabla);
                        if (this.recordCount(sesion, nombreTabla) == 0L) break;
                        this.moveNext(sesion, nodoPadre.getNombre());
                    }
                    this.move(sesion, nodoPadre.getNombre(), actual);
                }
            } else {
                this.borrarRegistros(sesion, nombreTabla);
            }
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected boolean refrescarClaveActivaNodo(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        try {
            ITablaMotor tAuxPadre;
            ITablaMotor tAux = ((ISesionExtendida)sesion).getBusquedaNodosObj().get(((ISesionExtendida)sesion).getPunteroActual()).buscarNodo(nombreTabla, ((ISesionExtendida)sesion).getVarNodoPrincipal().get(((ISesionExtendida)sesion).getPunteroActual()));
            if (tAux != null && (tAuxPadre = ((ISesionExtendida)sesion).getBusquedaNodosObj().get(((ISesionExtendida)sesion).getPunteroActual()).buscarNodo(tAux.getNombreTablaPadre(), ((ISesionExtendida)sesion).getVarNodoPrincipal().get(((ISesionExtendida)sesion).getPunteroActual()))) != null) {
                tAux.setClaveSuperior(tAuxPadre.getClaveActiva());
                tAux.setClaveUnicaSuperior(tAuxPadre.getClaveUnica());
            }
            return true;
        }
        catch (Exception ex) {
            if (!((ISesionExtendida)sesion).isModoSilencioso()) {
                if (ex instanceof ExceptionMotor) {
                    ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + "Tabla " + nombreTabla);
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
            }
            return false;
        }
    }

    protected boolean borraRegistro(ISesion sesion, ITablaMotor tAux) throws ExceptionMotor {
        try {
            boolean ret;
            String partidaBorrar = tAux.getNombre() + "_ANTES_BORRAR";
            if (sesion.getModelo().getGestorConfiguracion().getEntrada(partidaBorrar) != null) {
                sesion.getGestionReglas().ejecutaReglasDePartida(partidaBorrar);
            }
            if (ret = sesion.getOrigenDeDatos().borrarRegistro(tAux)) {
                this.anniadirTablaAListaAfectadasEnUnaEjecucion(sesion, tAux.getNombre(), new RegTablaModificada(sesion, tAux, "del"));
                partidaBorrar = tAux.getNombre() + "_DESPUES_BORRAR";
                if (sesion.getModelo().getGestorConfiguracion().getEntrada(partidaBorrar) != null) {
                    sesion.getGestionReglas().ejecutaReglasDePartida(partidaBorrar);
                }
                if (sesion.isUsarContadorRegistros()) {
                    int con = sesion.getOrigenDeDatos().getRecordCountTotal();
                    this.establecerPartida(sesion, "CON_REG", con);
                }
            }
            return ret;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long borrarRegistro(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        if (((ISesionExtendida)sesion).isEjecutandoBatchAnniadirRegistro()) {
            throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras existan comandos batch_A\u00f1adirRegistro(...) pendientes", Thread.currentThread().getStackTrace());
        }
        if (sesion.getOrigenDeDatos().isOrigenDeDatosOrdenadoPorCriterio()) {
            throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras este ordenado el origen de datos por un criterio", Thread.currentThread().getStackTrace());
        }
        boolean estadoAnteriorCacheOD = sesion.getOrigenDeDatos().isCacheHabilitada();
        boolean enTransaccion = false;
        try {
            sesion.getOrigenDeDatos().setCacheHabilitada(false);
            long res = 0L;
            ITablaMotor tAux = ((ISesionExtendida)sesion).getBusquedaNodosObj().get(((ISesionExtendida)sesion).getPunteroActual()).buscarNodo(nombreTabla, ((ISesionExtendida)sesion).getVarNodoPrincipal().get(((ISesionExtendida)sesion).getPunteroActual()));
            if (tAux != null && tAux.getClaveActiva() != 0L) {
                enTransaccion = ((ISesionExtendida)sesion).beginTrans();
                if (this.borraRegistro(sesion, tAux)) {
                    this.anniadirTablaAListaAfectadasEnUnaEjecucion(sesion, nombreTabla, new RegTablaModificada(sesion, tAux, "del"));
                    tAux.setClaveActiva(-1L);
                    this.moveFirst(sesion, nombreTabla);
                    ((ISesionExtendida)sesion).actualizarPunterosTablas(tAux);
                }
                res = tAux.getClaveActiva();
                ((ISesionExtendida)sesion).commitTrans();
            } else {
                res = 0L;
            }
            long l = res;
            return l;
        }
        catch (Exception ex) {
            if (!((ISesionExtendida)sesion).isModoSilencioso()) {
                if (ex instanceof ExceptionMotor) {
                    ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + "Tabla " + nombreTabla);
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
            }
            if (enTransaccion) {
                ((ISesionExtendida)sesion).rollBack();
            }
            long l = 0L;
            return l;
        }
        finally {
            sesion.getOrigenDeDatos().setCacheHabilitada(estadoAnteriorCacheOD);
        }
    }

    @Override
    public long move(ISesion sesion, String nombreTabla, long idKey) throws ExceptionMotor {
        return this.moveprv(sesion, nombreTabla, idKey);
    }

    protected long moveprv(ISesion sesion, String nombreTabla, long idKey) throws ExceptionMotor {
        try {
            ITablaMotor tAux = ((ISesionExtendida)sesion).obtenerNodoTabla(nombreTabla);
            if (tAux != null) {
                long rc;
                if (tAux.getNivel() == 0 && idKey != tAux.getClaveActiva()) {
                    return tAux.getClaveActiva();
                }
                if (idKey == 0L) {
                    return tAux.getClaveActiva();
                }
                if (idKey < 0L) {
                    idKey = 1L;
                }
                if ((rc = sesion.getOrigenDeDatos().recordCount(tAux)) == 0L) {
                    tAux.setClaveActiva(0L);
                    tAux.setClaveUnica(0L);
                } else if (rc >= idKey) {
                    tAux.setClaveActiva(idKey);
                    if (tAux.getNivel() != 0) {
                        tAux.setClaveUnica(0L);
                        tAux.setClaveUnica(this.dameIDDeTablaMotor(sesion, tAux));
                    }
                    ((ISesionExtendida)sesion).actualizarPunterosTablas(tAux);
                }
                return tAux.getClaveActiva();
            }
            return 0L;
        }
        catch (Exception ex) {
            if (!((ISesionExtendida)sesion).isModoSilencioso()) {
                if (ex instanceof ExceptionMotor) {
                    ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + "Tabla " + nombreTabla);
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
            }
            return 0L;
        }
    }

    @Override
    public long recordCount(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        try {
            ITablaMotor tAux = ((ISesionExtendida)sesion).getBusquedaNodosObj().get(((ISesionExtendida)sesion).getPunteroActual()).buscarNodo(nombreTabla, ((ISesionExtendida)sesion).getVarNodoPrincipal().get(((ISesionExtendida)sesion).getPunteroActual()));
            if (tAux == null) {
                return 0L;
            }
            return sesion.getOrigenDeDatos().recordCount(tAux);
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e, "Tabla " + nombreTabla);
        }
    }

    protected long dameIDDeTablaMotor(ISesion sesion, ITablaMotor tAux) throws ExceptionMotor {
        try {
            String valorId = sesion.getOrigenDeDatos().obtenerPartidaString(tAux, "ID");
            if (valorId == null || Long.valueOf(valorId) == -1L) {
                ITablaMotorEntrada id;
                Map<String, ITablaMotorEntrada> reg = sesion.getOrigenDeDatos().obtenerRegistroFiltroEnPosicion(tAux);
                if (reg != null && (id = reg.get("ID")) != null) {
                    return Long.valueOf(id.getValor().toString());
                }
                return 0L;
            }
            return Long.valueOf(valorId);
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    @Override
    public boolean moveFirstTodos(ISesion sesion) throws ExceptionMotor {
        try {
            String tablaRaiz = sesion.getModelo().getGestorConfiguracion().getTablaNivel(0).getIdTabla();
            return 1L == this.move(sesion, tablaRaiz, 1L);
        }
        catch (ExceptionMotor e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public long moveFirst(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        try {
            ITablaMotor tAux = null;
            ITablaMotor tAuxPadre = null;
            tAux = ((ISesionExtendida)sesion).obtenerNodoTabla(nombreTabla);
            if (tAux != null) {
                if (tAux.getNivel() == 0) {
                    return tAux.getClaveActiva();
                }
                tAuxPadre = ((ISesionExtendida)sesion).obtenerNodoTabla(tAux.getNombreTablaPadre());
                long rc = 0L;
                if (tAuxPadre == null || tAuxPadre.getClaveActiva() != 0L) {
                    rc = sesion.getOrigenDeDatos().recordCount(tAux);
                }
                if (rc != 0L) {
                    tAux.setClaveActiva(1L);
                    tAux.setClaveUnica(0L);
                    tAux.setClaveUnica(this.dameIDDeTablaMotor(sesion, tAux));
                } else {
                    tAux.setClaveActiva(0L);
                    tAux.setClaveUnica(0L);
                }
                ((ISesionExtendida)sesion).actualizarPunterosTablas(tAux);
                return tAux.getClaveActiva();
            }
            return 0L;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public boolean hasNext(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        try {
            long rc;
            ITablaMotor tAux = ((ISesionExtendida)sesion).obtenerNodoTabla(nombreTabla);
            return tAux != null && (rc = sesion.getOrigenDeDatos().recordCount(tAux)) != 0L && tAux.getClaveActiva() != rc;
        }
        catch (Exception ex) {
            if (!((ISesionExtendida)sesion).isModoSilencioso()) {
                if (ex instanceof ExceptionMotor) {
                    ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + "Tabla " + nombreTabla);
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
            }
            return false;
        }
    }

    @Override
    public boolean moveIfHasNext(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        try {
            if (this.hasNext(sesion, nombreTabla)) {
                this.moveNext(sesion, nombreTabla);
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            if (!((ISesionExtendida)sesion).isModoSilencioso()) {
                if (ex instanceof ExceptionMotor) {
                    ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + "Tabla " + nombreTabla);
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
            }
            return false;
        }
    }

    @Override
    public long moveNext(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        try {
            ITablaMotor tAux = ((ISesionExtendida)sesion).obtenerNodoTabla(nombreTabla);
            if (tAux != null) {
                if (tAux.getNivel() == 0) {
                    return tAux.getClaveActiva();
                }
                long rc = sesion.getOrigenDeDatos().recordCount(tAux);
                if (rc != 0L) {
                    if (tAux.getClaveActiva() != rc) {
                        tAux.setClaveActiva(tAux.getClaveActiva() + 1L);
                        tAux.setClaveUnica(0L);
                        tAux.setClaveUnica(this.dameIDDeTablaMotor(sesion, tAux));
                        ((ISesionExtendida)sesion).actualizarPunterosTablas(tAux);
                    }
                } else {
                    tAux.setClaveActiva(0L);
                }
                return tAux.getClaveActiva();
            }
            return 0L;
        }
        catch (Exception ex) {
            if (!((ISesionExtendida)sesion).isModoSilencioso()) {
                if (ex instanceof ExceptionMotor) {
                    ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + "Tabla " + nombreTabla);
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
            }
            return 0L;
        }
    }

    @Override
    public long moveLast(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        try {
            ITablaMotor tAux = ((ISesionExtendida)sesion).obtenerNodoTabla(nombreTabla);
            if (tAux != null) {
                if (tAux.getNivel() == 0) {
                    return tAux.getClaveActiva();
                }
                long rc = sesion.getOrigenDeDatos().recordCount(tAux);
                if (rc != 0L) {
                    if (tAux.getClaveActiva() != rc) {
                        tAux.setClaveActiva(rc);
                        tAux.setClaveUnica(0L);
                        tAux.setClaveUnica(this.dameIDDeTablaMotor(sesion, tAux));
                        ((ISesionExtendida)sesion).actualizarPunterosTablas(tAux);
                    }
                } else {
                    tAux.setClaveActiva(0L);
                }
                return tAux.getClaveActiva();
            }
            return 0L;
        }
        catch (Exception ex) {
            if (!((ISesionExtendida)sesion).isModoSilencioso()) {
                if (ex instanceof ExceptionMotor) {
                    ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + "Tabla " + nombreTabla);
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
            }
            return 0L;
        }
    }

    @Override
    public long movePrevious(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        try {
            ITablaMotor tAux = ((ISesionExtendida)sesion).obtenerNodoTabla(nombreTabla);
            if (tAux != null) {
                long rc = sesion.getOrigenDeDatos().recordCount(tAux);
                if (rc != 0L) {
                    if (tAux.getNivel() == 0) {
                        return tAux.getClaveActiva();
                    }
                    if (tAux.getClaveActiva() > 1L) {
                        tAux.setClaveActiva(tAux.getClaveActiva() - 1L);
                        tAux.setClaveUnica(0L);
                        tAux.setClaveUnica(this.dameIDDeTablaMotor(sesion, tAux));
                        ((ISesionExtendida)sesion).actualizarPunterosTablas(tAux);
                    }
                } else {
                    tAux.setClaveActiva(0L);
                }
                return tAux.getClaveActiva();
            }
            return 0L;
        }
        catch (Exception ex) {
            if (!((ISesionExtendida)sesion).isModoSilencioso()) {
                if (ex instanceof ExceptionMotor) {
                    ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + "Tabla " + nombreTabla);
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
            }
            return 0L;
        }
    }

    @Override
    public ITablaMotorEntrada obtenerPartidayEstado(ISesion sesion, String nombrePartida) throws ExceptionMotor {
        return new TablaMotorEntrada(nombrePartida, this.obtenerPartidaString(sesion, nombrePartida), this.obtenerEstadoPartida(sesion, nombrePartida));
    }

    @Override
    public String obtenerPartidaIndexada(ISesion sesion, String nombrePartida, int index) throws ExceptionMotor {
        return this.obtenerPartidaString(sesion, nombrePartida, null, index);
    }

    @Override
    public String obtenerPartidaString(ISesion sesion, String nombrePartida) throws ExceptionMotor {
        return this.obtenerPartidaString(sesion, nombrePartida, null);
    }

    @Override
    public String obtenerPartidaString(ISesion sesion, String nombrePartida, Map<String, String> propCampo) throws ExceptionMotor {
        return this.obtenerPartidaString(sesion, nombrePartida, propCampo, null);
    }

    protected String obtenerPartidaString(ISesion sesion, String nombrePartida, Map<String, String> propCampo, Integer index) throws ExceptionMotor {
        Object res = null;
        try {
            String nombreTabla = ((ISesionExtendida)sesion).buscarPartidaEnTabla(nombrePartida);
            if (nombreTabla.length() == 0) {
                throw new ExceptionMotor("La partida no se encuentra en ninguna tabla del modelo", Thread.currentThread().getStackTrace());
            }
            ITablaMotor tAux = ((ISesionExtendida)sesion).getBusquedaNodosObj().get(((ISesionExtendida)sesion).getPunteroActual()).buscarNodo(nombreTabla, ((ISesionExtendida)sesion).getVarNodoPrincipal().get(((ISesionExtendida)sesion).getPunteroActual()));
            if (tAux == null) {
                throw new ExceptionMotor("La relaci\u00f3n que identifica la partida con su tabla no es correcta nombre de tabla: " + nombreTabla, Thread.currentThread().getStackTrace());
            }
            res = index != null ? tAux.obtenerPartidaString(nombrePartida.toUpperCase(), index) : tAux.obtenerPartidaString(nombrePartida.toUpperCase());
            if (res != null && res.toString().trim().length() == 0) {
                res = this.devolverValorDatoParseadoSegunTipo(sesion, nombrePartida);
            }
            if (res == null) {
                res = this.obtenerValorInicialPartida(sesion, nombrePartida);
            }
            if (res != null && res.toString().length() == 0 && sesion.getModelo().getGestorConfiguracion().getEntrada(nombrePartida).getTipoDato().equalsIgnoreCase("CADENA_NUMERICA")) {
                return "0";
            }
            return res.toString();
        }
        catch (Exception ex) {
            if (!((ISesionExtendida)sesion).isModoSilencioso()) {
                if (ex instanceof ExceptionMotor) {
                    ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + "Partida " + nombrePartida);
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex, "Partida " + nombrePartida);
            }
            return null;
        }
    }

    @Override
    public String obtenerPartidaAnteriorDuranteReglaString(ISesion sesion, String nombrePartida) throws ExceptionMotor {
        try {
            String nombreTabla = ((ISesionExtendida)sesion).buscarPartidaEnTabla(nombrePartida);
            if (nombreTabla.length() == 0) {
                throw new ExceptionMotor("No encuentro nombre de entrada " + nombrePartida, Thread.currentThread().getStackTrace());
            }
            ITablaMotor tAux = ((ISesionExtendida)sesion).obtenerNodoTabla(nombreTabla);
            try {
                return ((ISesionExtendida)sesion).getMapaPartidasAfectadasEnUnaEjecucion().get(nombrePartida + "(" + tAux.getLocalizacion(((ISesionExtendida)sesion).getNodoPrincipal()) + ")").getValorAnterior().toString();
            }
            catch (Exception ex) {
                return this.obtenerPartidaString(sesion, nombrePartida);
            }
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Partida " + nombrePartida);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Partida " + nombrePartida);
        }
    }

    @Override
    public long obtenerClaveActiva(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        long resultado = 0L;
        try {
            ITablaMotor nodo = ((ISesionExtendida)sesion).obtenerNodoTabla(nombreTabla);
            if (nodo == null) {
                throw new ExceptionMotor("No existe ninguna tabla con nombre " + nombreTabla, Thread.currentThread().getStackTrace());
            }
            resultado = nodo.getClaveActiva();
            return resultado;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public long obtenerClaveSuperior(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        long resultado = 0L;
        try {
            ITablaMotor nodo = ((ISesionExtendida)sesion).obtenerNodoTabla(nombreTabla);
            if (nodo == null) {
                throw new ExceptionMotor("No existe ninguna tabla con nombre " + nombreTabla, Thread.currentThread().getStackTrace());
            }
            resultado = nodo.getClaveSuperior();
            return resultado;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int obtenerEstadoPartida(ISesion sesion, String nombrePartida) throws ExceptionMotor {
        boolean modoSilenciosoAnterior = ((ISesionExtendida)sesion).isModoSilencioso();
        try {
            ((ISesionExtendida)sesion).setModoSilencioso(true);
            String nombreTabla = ((ISesionExtendida)sesion).buscarPartidaEnTabla(nombrePartida);
            if (nombreTabla.equalsIgnoreCase("")) {
                throw new ExceptionMotor("La partida no se encuentra en ninguna tabla del modelo", Thread.currentThread().getStackTrace());
            }
            ITablaMotor tAux = ((ISesionExtendida)sesion).getBusquedaNodosObj().get(((ISesionExtendida)sesion).getPunteroActual()).buscarNodo(nombreTabla, ((ISesionExtendida)sesion).getVarNodoPrincipal().get(((ISesionExtendida)sesion).getPunteroActual()));
            if (tAux == null) {
                throw new ExceptionMotor("La relaci\u00f3n que identifica la partida con su tabla no es correcta nombre de tabla: " + nombreTabla, Thread.currentThread().getStackTrace());
            }
            int est = tAux.obtenerEstado(nombrePartida.toUpperCase());
            if (est == -1) {
                try {
                    int n = this.obtenerEstadoDefectoPartida(sesion, nombrePartida);
                    return n;
                }
                catch (Exception ex) {
                    throw new ExceptionMotor(ex, "La partida " + nombrePartida + " no se encuentra en Entradas");
                }
            }
            int n = est;
            return n;
        }
        catch (Exception ex) {
            if (!((ISesionExtendida)sesion).isModoSilencioso()) {
                if (ex instanceof ExceptionMotor) {
                    ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + "Partida " + nombrePartida);
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex, "Partida " + nombrePartida);
            }
            int n = 0;
            return n;
        }
        finally {
            ((ISesionExtendida)sesion).setModoSilencioso(modoSilenciosoAnterior);
        }
    }

    @Override
    public int obtenerEstadoPartidaAnteriorDuranteRegla(ISesion sesion, String nombrePartida) throws ExceptionMotor {
        try {
            String nombreTabla = ((ISesionExtendida)sesion).buscarPartidaEnTabla(nombrePartida);
            if (nombreTabla.length() == 0) {
                throw new ExceptionMotor("No encuentro nombre de entrada " + nombrePartida, Thread.currentThread().getStackTrace());
            }
            ITablaMotor tAux = ((ISesionExtendida)sesion).obtenerNodoTabla(nombreTabla);
            try {
                return ((ISesionExtendida)sesion).getMapaPartidasAfectadasEnUnaEjecucion().get(nombrePartida + "(" + tAux.getLocalizacion(((ISesionExtendida)sesion).getNodoPrincipal()) + ")").getEstadoAnterior();
            }
            catch (Exception ex) {
                return sesion.getOperaciones().obtenerEstadoPartida(nombrePartida);
            }
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Partida " + nombrePartida);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Partida " + nombrePartida);
        }
    }

    @Override
    public boolean estaVacioRegistroDatosTabla(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        try {
            boolean vacio = true;
            Map<String, ITablaMotorEntrada> campos = this.obtenerRegistroDatosTabla(sesion, nombreTabla);
            if (campos == null) {
                return true;
            }
            List<String> camposTabla = sesion.getModelo().getGestorConfiguracion().getCamposDeTabla(nombreTabla);
            Set<String> claves = campos.keySet();
            Iterator<String> it = claves.iterator();
            String clave = "";
            String valor = "";
            String valorInicial = "";
            IRegEntrada entrada = null;
            int pos = -1;
            while (it.hasNext()) {
                clave = it.next().toString();
                if (clave.equalsIgnoreCase("ID") || clave.equalsIgnoreCase("IDINF") || (pos = camposTabla.indexOf(clave)) <= -1) continue;
                entrada = sesion.getModelo().getGestorConfiguracion().getEntrada(clave);
                valor = FuncionesUtiles.getFuncionesUtiles().object2String(campos.get(clave).getValor());
                valorInicial = FuncionesUtiles.getFuncionesUtiles().object2String(entrada.getValorInicial());
                if (entrada.getTipoDato().equalsIgnoreCase("DOBLE") || entrada.getTipoDato().equalsIgnoreCase("BIGDECIMAL")) {
                    if (valorInicial.length() == 0) {
                        valorInicial = "0";
                    }
                    if (valor.length() <= 0 || !((Boolean)sesion.getMotor().getClaseOperaciones().evaluarOperacion(valor, valorInicial, "!")).booleanValue()) continue;
                    return false;
                }
                if (entrada.getTipoDato().equalsIgnoreCase("LOGICO")) {
                    if (valorInicial.length() == 0) {
                        valorInicial = "false";
                    }
                    if (valor.length() <= 0 || Boolean.valueOf(valor).toString().equalsIgnoreCase(Boolean.valueOf(valorInicial).toString())) continue;
                    return false;
                }
                if (valor.trim().equalsIgnoreCase(entrada.getValorInicial().trim())) continue;
                return false;
            }
            return vacio;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public boolean cerrarConexionOrigenDatos(ISesion sesion) throws ExceptionMotor {
        try {
            return sesion.getOrigenDeDatos().cerrarAlmacenamiento();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public boolean abrirConexionOrigenDatos(ISesion sesion) throws ExceptionMotor {
        try {
            return this.abrirConexionOrigenDatos(sesion, null);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public boolean abrirConexionOrigenDatos(ISesion sesion, Object datos) throws ExceptionMotor {
        try {
            return this.abrirConexionOrigenDatos(sesion, datos, null);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public boolean abrirConexionOrigenDatos(ISesion sesion, Object datos, Map<String, String> parametrosInicializacion) throws ExceptionMotor {
        try {
            return sesion.getOrigenDeDatos().abrirAlmacenamiento(datos, parametrosInicializacion);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public ITablaMotor getNodoPrincipal(ISesion sesion) throws ExceptionMotor {
        try {
            return ((ISesionExtendida)sesion).getNodoPrincipal();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public void setNodoPrincipal(ISesion sesion, ITablaMotor nuevoNodoPrincipal) throws ExceptionMotor {
        ((ISesionExtendida)sesion).setNodoPrincipal(nuevoNodoPrincipal);
    }

    @Override
    public INodoArbol getArbolDatos(ISesion sesion) throws ExceptionMotor {
        return this.concatenameNodos(((ISesionExtendida)sesion).getVarNodoPrincipal().get(((ISesionExtendida)sesion).getPunteroActual()));
    }

    protected INodoArbol concatenameNodos(ITablaMotor tabla) throws ExceptionMotor {
        try {
            NodoArbol nodo = new NodoArbol(tabla.getNombre());
            IListaTablaMotor relacionadas = tabla.getRelacionadas();
            for (int i = 0; i < relacionadas.count(); ++i) {
                INodoArbol hijosTmp = this.concatenameNodos((ITablaMotor)relacionadas.get(i));
                if (hijosTmp == null) continue;
                nodo.appendHijo(hijosTmp);
            }
            return nodo;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public String getRegistroFicherosAuxiliares(ISesion sesion, String tabla, String clave) throws ExceptionMotor {
        try {
            return sesion.getModelo().getGestorDatosAuxiliares().getRegistro(tabla, clave);
        }
        catch (Exception ex) {
            if (!((ISesionExtendida)sesion).isModoSilencioso()) {
                if (ex instanceof ExceptionMotor) {
                    ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + "Tabla " + tabla + " clave " + clave);
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex, "Tabla " + tabla + " clave " + clave);
            }
            return "";
        }
    }

    @Override
    public String obtenerTipoPartida(ISesion sesion, String nombrePartida) throws ExceptionMotor {
        try {
            IRegEntrada entrada = sesion.getModelo().getGestorConfiguracion().getEntrada(nombrePartida);
            if (entrada != null) {
                return entrada.getTipoDato();
            }
            return null;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Partida " + nombrePartida);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Partida " + nombrePartida);
        }
    }

    @Override
    public long obtenerIdUnicoTabla(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        try {
            ITablaMotor nodo = ((ISesionExtendida)sesion).obtenerNodoTabla(nombreTabla);
            if (nodo != null) {
                return nodo.getClaveUnica();
            }
            throw new ExceptionMotor("No existe ninguna tabla con nombre " + nombreTabla, Thread.currentThread().getStackTrace());
        }
        catch (Exception ex) {
            if (!((ISesionExtendida)sesion).isModoSilencioso()) {
                if (ex instanceof ExceptionMotor) {
                    ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + "Tabla " + nombreTabla);
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
            }
            return 0L;
        }
    }

    @Override
    public String getLocalizacionEx(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        try {
            ITablaMotor nodo = ((ISesionExtendida)sesion).obtenerNodoTabla(nombreTabla);
            if (nodo != null) {
                List<ITipoDatosCampoValor> listado = nodo.getLocalizacion();
                String ret = "";
                for (ITipoDatosCampoValor iTipoDatosCampoValor : listado) {
                    if (ret.length() > 0) {
                        ret = ret + "-";
                    }
                    ret = ret + iTipoDatosCampoValor.getNombreCampo() + ":" + iTipoDatosCampoValor.getValor();
                }
                return ret;
            }
            throw new ExceptionMotor("No existe ninguna tabla con nombre " + nombreTabla, Thread.currentThread().getStackTrace());
        }
        catch (ExceptionMotor e) {
            throw e;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public String getLocalizacion(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        ((ISesionExtendida)sesion).getNodoPrincipal();
        try {
            ITablaMotor nodo = ((ISesionExtendida)sesion).obtenerNodoTabla(nombreTabla);
            if (nodo != null) {
                List<ITipoDatosCampoValor> listado = nodo.getLocalizacion();
                String ret = "";
                for (ITipoDatosCampoValor iTipoDatosCampoValor : listado) {
                    if (ret.length() > 0) {
                        ret = ret + "-";
                    }
                    ret = ret + iTipoDatosCampoValor.getValor();
                }
                return ret;
            }
            throw new ExceptionMotor("No existe ninguna tabla con nombre " + nombreTabla, Thread.currentThread().getStackTrace());
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public List<?> obtenerOpcion(ISesion sesion, String nombreOpcion) throws ExceptionMotor {
        return sesion.getModelo().getGestorDatosOpciones().getOpcion(nombreOpcion);
    }

    @Override
    public Object obtenerValorPorDefectoPartida(ISesion sesion, String nombrePartida) throws ExceptionMotor {
        try {
            IRegEntrada entrada = sesion.getModelo().getGestorConfiguracion().getEntrada(nombrePartida);
            if (entrada != null) {
                return entrada.getValorInicial();
            }
            return null;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Partida " + nombrePartida);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Partida " + nombrePartida);
        }
    }

    @Override
    public Object getDatos(ISesion sesion) throws ExceptionMotor {
        try {
            if (sesion.getModelo().getPersistenciaObj() == null) {
                throw new ExceptionMotor("No hay clase persistencia...", Thread.currentThread().getStackTrace());
            }
            return sesion.getModelo().getPersistenciaObj().obtener(sesion);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Object getPunteroADatos(ISesion sesion) throws ExceptionMotor {
        try {
            return sesion.getOrigenDeDatos().getPunteroADatos();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean setDatos(ISesion sesion, Object datos) throws ExceptionMotor {
        try {
            if (sesion.getModelo().getPersistenciaObj() == null) {
                throw new ExceptionMotor("No hay clase persistencia...", Thread.currentThread().getStackTrace());
            }
            boolean ret = sesion.getModelo().getPersistenciaObj().establece(sesion.getOrigenDeDatos(), sesion.getOrigenDeDatos(), datos);
            ret &= ((ISesionExtendida)sesion).construirArbol(true);
            return ret &= sesion.getOperaciones().moveFirstTodos();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public List<?> getTablaFicherosAuxiliares(ISesion sesion, String tabla) throws ExceptionMotor {
        try {
            return sesion.getModelo().getGestorDatosAuxiliares().getTabla(tabla);
        }
        catch (Exception ex) {
            if (!((ISesionExtendida)sesion).isModoSilencioso()) {
                if (ex instanceof ExceptionMotor) {
                    ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + "Tabla " + tabla);
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex, "Tabla " + tabla);
            }
            return null;
        }
    }

    @Override
    public List<?> getTablaFicherosAuxiliares(ISesion sesion, String tabla, boolean ordenar) throws ExceptionMotor {
        try {
            return sesion.getModelo().getGestorDatosAuxiliares().getTabla(tabla, ordenar);
        }
        catch (Exception ex) {
            if (!((ISesionExtendida)sesion).isModoSilencioso()) {
                if (ex instanceof ExceptionMotor) {
                    ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + "Tabla " + tabla);
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex, "Tabla " + tabla);
            }
            return null;
        }
    }

    @Override
    public List<?> getTablaFiltradaFicherosAuxiliares(ISesion sesion, String tablaPadre, String tablaHija, String claveAjena) throws ExceptionMotor {
        return this.getTablaFiltradaFicherosAuxiliares(sesion, tablaPadre, tablaHija, claveAjena, true);
    }

    @Override
    public List<?> getTablaFiltradaFicherosAuxiliares(ISesion sesion, String tablaPadre, String tablaHija, String claveAjena, boolean ordenar) throws ExceptionMotor {
        try {
            return sesion.getModelo().getGestorDatosAuxiliares().getTablaFiltrada(tablaPadre, tablaHija, claveAjena, ordenar);
        }
        catch (Exception ex) {
            if (!((ISesionExtendida)sesion).isModoSilencioso()) {
                if (ex instanceof ExceptionMotor) {
                    ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + "TablaPadre " + tablaPadre + " TablaHija " + tablaHija + " ClaveAjena " + claveAjena);
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex, "TablaPadre " + tablaPadre + " TablaHija " + tablaHija + " ClaveAjena " + claveAjena);
            }
            return null;
        }
    }

    @Override
    public void establecerCriterioOrdenacion(ISesion sesion, List<ITipoDatosCriteriosOrdenacion> listaDeCriteriosOrdenacion) throws ExceptionMotor {
        try {
            if (listaDeCriteriosOrdenacion != null && listaDeCriteriosOrdenacion.size() > 0) {
                for (int i = 0; i < listaDeCriteriosOrdenacion.size(); ++i) {
                    if (sesion.getModelo().getGestorConfiguracion().getTabla(listaDeCriteriosOrdenacion.get(i).getTabla()) == null) {
                        sesion.getOrigenDeDatos().setOrigenDeDatosOrdenadoPorCriterio(false);
                        throw new ExceptionMotor("La tabla " + listaDeCriteriosOrdenacion.get(i).getCampos() + " no se encuentra en el gestor de configuraci\u00f3n");
                    }
                    String[] campos = listaDeCriteriosOrdenacion.get(i).getCampos().split(",");
                    for (int j = 0; j < campos.length; ++j) {
                        if (sesion.getModelo().getGestorConfiguracion().getEntrada(campos[j].toUpperCase()) != null) continue;
                        sesion.getOrigenDeDatos().setOrigenDeDatosOrdenadoPorCriterio(false);
                        throw new ExceptionMotor("La entrada " + campos[j] + " no se encuentra en el gestor de configuraci\u00f3n");
                    }
                }
            }
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean establecerPartida(ISesion sesion, String nombrePartida, Object valor, Object valorAnterior) throws ExceptionMotor {
        try {
            if (FuncionesUtiles.getFuncionesUtiles().sonIguales(sesion.getModelo().getGestorConfiguracion().getEntrada(nombrePartida).esTipoNumerico(), valorAnterior, valor)) {
                return true;
            }
            if (!sesion.isEnabled()) {
                return true;
            }
            ITablaMotor tAux = ((ISesionExtendida)sesion).obtenerNodoPartida(nombrePartida);
            if (tAux == null) {
                return false;
            }
            return this.establecerPartida(sesion, tAux, nombrePartida, valor, valorAnterior);
        }
        catch (Exception ex) {
            String str = "Partida " + nombrePartida;
            try {
                str = str + " Valor " + valor.toString() + " ValorAnterior " + valorAnterior.toString();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ex instanceof ExceptionMotor) {
                ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + str);
                throw (ExceptionMotor)ex;
            }
            throw new ExceptionMotor(ex, str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean establecerPartida(ISesion sesion, String nombrePartida, Object valor) throws ExceptionMotor {
        boolean modoSilenciosoAnterior = ((ISesionExtendida)sesion).isModoSilencioso();
        try {
            ITablaMotor tAux = ((ISesionExtendida)sesion).obtenerNodoPartida(nombrePartida);
            if (tAux == null) {
                throw new ExceptionMotor("No se encuentra nodo de Partida");
            }
            ((ISesionExtendida)sesion).setModoSilencioso(true);
            Object valorAnterior = this.obtenerPartida(sesion, nombrePartida);
            ((ISesionExtendida)sesion).setModoSilencioso(modoSilenciosoAnterior);
            boolean bl = this.establecerPartida(sesion, tAux, nombrePartida, valor, valorAnterior);
            return bl;
        }
        catch (Exception ex) {
            if (!((ISesionExtendida)sesion).isModoSilencioso()) {
                String str = "Partida " + nombrePartida;
                try {
                    str = str + " valor " + valor.toString();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (ex instanceof ExceptionMotor) {
                    ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + str);
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex, str);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            ((ISesionExtendida)sesion).setModoSilencioso(modoSilenciosoAnterior);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean establecerPartida(ISesion sesion, ITablaMotor tAux, String nomPartida, Object val, Object valAnterior) throws ExceptionMotor {
        String valor = this.valorDependienteDeTipo(sesion, nomPartida, val.toString());
        String nombrePartida = nomPartida;
        Object valorAnterior = valAnterior;
        boolean heConseguidoEstablecer = false;
        IPartidaModificadaReglas partida = null;
        Object valorEstablecido = null;
        boolean seCreoRegistro = false;
        try {
            IRegEntrada entrada = sesion.getModelo().getGestorConfiguracion().getEntrada(nombrePartida);
            seCreoRegistro = this.crearRegistroSiNoExiste(sesion, tAux);
            if (FuncionesUtiles.getFuncionesUtiles().sonIguales(entrada.esTipoNumerico(), valor, valorAnterior)) {
                partida = null;
                if (((ISesionExtendida)sesion).getListaPartidasAfectadasEnUnaEjecucion().size() > 0) {
                    partida = ((ISesionExtendida)sesion).getListaPartidasAfectadasEnUnaEjecucion().get(((ISesionExtendida)sesion).getListaPartidasAfectadasEnUnaEjecucion().size() - 1).getLista().get(nombrePartida + "(" + tAux.getLocalizacion(((ISesionExtendida)sesion).getVarNodoPrincipal().get(((ISesionExtendida)sesion).getPunteroActual())) + ")");
                }
                if (partida == null) {
                    partida = new PartidaModificada(tAux, nombrePartida);
                    partida.setValorAnterior(valorAnterior);
                }
                partida.setValorPosterior(valor);
                this.anniadirPartidaAListaAfectadasEnUnaEjecucion(sesion, nombrePartida, tAux, partida);
                heConseguidoEstablecer = true;
                partida = null;
                boolean bl = true;
                return bl;
            }
            nombrePartida = nombrePartida.toUpperCase();
            String s = entrada.getTipoDato();
            Object valorEnTablasMotor = tAux.obtenerPartidaString(nombrePartida);
            if (valorEnTablasMotor == null) {
                valorEnTablasMotor = valorAnterior;
            }
            if (s.equalsIgnoreCase("DOBLE")) {
                if (!valorAnterior.getClass().getName().equalsIgnoreCase(Double.class.getName())) {
                    try {
                        valorAnterior = Double.valueOf(valorAnterior.toString());
                    }
                    catch (Exception e) {
                        valorAnterior = new Double(0.0);
                    }
                }
                valorEstablecido = Double.valueOf(valor.toString());
                valorEstablecido = Formatear.getFormatear().formatoDoble((Double)valorEstablecido, entrada.getNumDecimales());
                heConseguidoEstablecer = tAux.establecerPartida(nombrePartida, FuncionesUtiles.getFuncionesUtiles().doubleToString(Double.valueOf(valorEstablecido.toString())));
            } else if (s.equalsIgnoreCase("BIGDECIMAL")) {
                if (!valorAnterior.getClass().getName().equalsIgnoreCase(BigDecimal.class.getName())) {
                    try {
                        valorAnterior = new BigDecimal(valorAnterior.toString().trim());
                    }
                    catch (Exception e) {
                        valorAnterior = BigDecimal.ZERO;
                    }
                }
                valorEstablecido = new BigDecimal(valor.toString().trim());
                valorEstablecido = ((BigDecimal)valorEstablecido).setScale(entrada.getNumDecimales(), 4);
                heConseguidoEstablecer = tAux.establecerPartida(nombrePartida, valorEstablecido);
            } else if (s.equalsIgnoreCase("ENTERO")) {
                if (!valorAnterior.getClass().getName().equalsIgnoreCase(Integer.class.getName())) {
                    try {
                        int i = valorAnterior.toString().indexOf(46);
                        if (i > 0) {
                            valorAnterior = valorAnterior.toString().substring(0, i);
                        }
                        valorAnterior = Integer.valueOf(valorAnterior.toString());
                    }
                    catch (Exception ex) {
                        valorAnterior = 0;
                    }
                }
                valorEstablecido = Double.valueOf(valor.toString()).intValue();
                heConseguidoEstablecer = tAux.establecerPartida(nombrePartida, valorEstablecido);
            } else if (s.equalsIgnoreCase("LOGICO")) {
                if (!valorAnterior.getClass().getName().equalsIgnoreCase(Boolean.class.getName())) {
                    valorAnterior = Boolean.valueOf(valorAnterior.toString());
                }
                valorEstablecido = Boolean.valueOf(valor.toString());
                heConseguidoEstablecer = tAux.establecerPartida(nombrePartida, valorEstablecido);
            } else if (s.equalsIgnoreCase("CADENA")) {
                valorEstablecido = valor;
                heConseguidoEstablecer = tAux.establecerPartida(nombrePartida, valorEstablecido);
            } else if (s.equalsIgnoreCase("FECHA")) {
                valorEstablecido = valor;
                if (valorEstablecido != null && !valorEstablecido.toString().trim().equalsIgnoreCase("") && !((Boolean)sesion.getGestionReglas().ejecutarFuncion(sesion, "esFecha", new Object[]{valorEstablecido, "ddMMyyyy"})).booleanValue()) {
                    heConseguidoEstablecer = false;
                    sesion.getGestionReglas().ejecutarFuncion(sesion, "error", new Object[]{"FECHERR"});
                } else {
                    heConseguidoEstablecer = tAux.establecerPartida(nombrePartida, valorEstablecido);
                }
            } else {
                valorEstablecido = valor;
                heConseguidoEstablecer = tAux.establecerPartida(nombrePartida, valorEstablecido);
            }
            if (heConseguidoEstablecer) {
                if (((ISesionExtendida)sesion).getListaPartidasAfectadasEnUnaEjecucion().size() == 0) {
                    ((ISesionExtendida)sesion).getListaPartidasAfectadasEnUnaEjecucion().add(new TipoListaPartidasAfectadasEnUnaEjecucion(new HashMap<String, IPartidaModificadaReglas>()));
                }
                if ((partida = ((ISesionExtendida)sesion).getListaPartidasAfectadasEnUnaEjecucion().get(((ISesionExtendida)sesion).getListaPartidasAfectadasEnUnaEjecucion().size() - 1).getLista().get(nombrePartida + "(" + tAux.getLocalizacion(((ISesionExtendida)sesion).getVarNodoPrincipal().get(((ISesionExtendida)sesion).getPunteroActual())) + ")")) == null) {
                    partida = new PartidaModificada(tAux, nombrePartida);
                }
                partida.setValorAnterior(valorAnterior);
                partida.setValorPosterior(valorEstablecido);
                this.anniadirPartidaAListaAfectadasEnUnaEjecucion(sesion, nombrePartida, tAux, partida);
            }
            boolean bl = heConseguidoEstablecer;
            return bl;
        }
        catch (Exception ex) {
            if (ex.getMessage().toUpperCase().contains("OVERFLOW_MOTOR")) {
                heConseguidoEstablecer = false;
                sesion.getGestionReglas().ejecutarFuncion(sesion, "error", new Object[]{"OVERFLOW_MOTOR"});
            } else if (!((ISesionExtendida)sesion).isModoSilencioso()) {
                String str = "Partida " + nomPartida;
                try {
                    str = str + " valor " + valor.toString() + " valor " + val.toString() + " valorAnterior " + valAnterior.toString();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (ex instanceof ExceptionMotor) {
                    ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + str);
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex, str);
            }
            boolean bl = heConseguidoEstablecer;
            return bl;
        }
        finally {
            if (!heConseguidoEstablecer && seCreoRegistro) {
                this.borrarRegistro(sesion, tAux.getNombre());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean recargaDatosdelOrigendeDatos(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        FreezerMotor f = new FreezerMotor(sesion);
        try {
            f.freeze();
            ITablaMotor tabla = ((ISesionExtendida)sesion).obtenerNodoTabla(nombreTabla);
            tabla.setClaveActiva(0L);
            tabla.setClaveSuperior(0L);
            tabla.setClaveUnicaSuperior(0L);
            f.unfreeze();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (f.isFreezed()) {
                f.unfreeze();
            }
            f = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean recargaDatosdelOrigendeDatos(ISesion sesion) throws ExceptionMotor {
        FreezerMotor f = new FreezerMotor(sesion);
        try {
            f.freeze();
            ((ISesionExtendida)sesion).getNodoPrincipal().setClaveActiva(0L);
            ((ISesionExtendida)sesion).getNodoPrincipal().setClaveSuperior(0L);
            ((ISesionExtendida)sesion).getNodoPrincipal().setClaveUnicaSuperior(0L);
            f.unfreeze();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (f.isFreezed()) {
                f.unfreeze();
            }
            f = null;
        }
    }

    @Override
    public long anniadirRegistro(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        return this.anniadirRegistro(sesion, nombreTabla, -1L);
    }

    @Override
    public long anniadirRegistro(ISesion sesion, String nombreTabla, long forceIDINF) throws ExceptionMotor {
        if (sesion.getOrigenDeDatos().isOrigenDeDatosOrdenadoPorCriterio()) {
            throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras este ordenado el origen de datos por un criterio", Thread.currentThread().getStackTrace());
        }
        boolean enTransaccion = false;
        try {
            long ret;
            Integer contador = null;
            int max = Integer.valueOf(this.obtenerPartidaString(sesion, "MAX_REG"));
            if (sesion.isUsarContadorRegistros() && max > 0) {
                int con = Integer.valueOf(this.obtenerPartidaString(sesion, "CON_REG"));
                if (con == 0 && (con = sesion.getOrigenDeDatos().getRecordCountTotal()) != 0) {
                    this.establecerPartida(sesion, "CON_REG", con);
                }
                if (con >= max) {
                    sesion.getGestionReglas().ejecutarFuncion(sesion, "error", new Object[]{"ERRMAXREG"});
                    return -2L;
                }
                contador = con + 1;
            }
            ITablaMotor tAux = null;
            tAux = ((ISesionExtendida)sesion).getBusquedaNodosObj().get(((ISesionExtendida)sesion).getPunteroActual()).buscarNodo(nombreTabla, ((ISesionExtendida)sesion).getVarNodoPrincipal().get(((ISesionExtendida)sesion).getPunteroActual()));
            if (tAux == null) {
                return -1L;
            }
            if (tAux.getNivel() == 0 && tAux.getClaveActiva() != 0L) {
                return 1L;
            }
            if (tAux.getNivel() != 0 && tAux.getClaveSuperior() == 0L) {
                this.anniadirRegistro(sesion, tAux.getNombreTablaPadre());
                tAux = ((ISesionExtendida)sesion).getBusquedaNodosObj().get(((ISesionExtendida)sesion).getPunteroActual()).buscarNodo(nombreTabla, ((ISesionExtendida)sesion).getVarNodoPrincipal().get(((ISesionExtendida)sesion).getPunteroActual()));
            }
            ((ISesionExtendida)sesion).beginTrans();
            enTransaccion = true;
            long res = 0L;
            if (forceIDINF > -1L) {
                tAux.setClaveSuperior(forceIDINF);
            }
            if ((ret = sesion.getOrigenDeDatos().anniadirRegistro(tAux)) > 0L) {
                tAux.setClaveActiva(ret);
                this.anniadirTablaAListaAfectadasEnUnaEjecucion(sesion, nombreTabla, new RegTablaModificada(sesion, tAux, "add"));
            }
            tAux.setClaveActiva(ret);
            if (sesion.getOrigenDeDatos().isCreacionIDUnicoAutomatico()) {
                tAux.establecerPartida("ID", String.valueOf(tAux.getClaveActiva()));
            }
            this.recorrerNodosHijos(sesion, tAux);
            res = tAux.getClaveActiva();
            ((ISesionExtendida)sesion).commitTrans();
            if (sesion.isUsarContadorRegistros() && ret > 0L && contador != null) {
                this.establecerPartida(sesion, "CON_REG", contador);
            }
            enTransaccion = false;
            String partidaAnadir = nombreTabla + "_ANADIR";
            if (sesion.getModelo().getGestorConfiguracion().getEntrada(partidaAnadir) != null) {
                sesion.getGestionReglas().ejecutaReglasDePartida(partidaAnadir);
            }
            return res;
        }
        catch (Exception ex) {
            if (!((ISesionExtendida)sesion).isModoSilencioso()) {
                if (ex instanceof ExceptionMotor) {
                    ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + "Tabla " + nombreTabla);
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
            }
            if (enTransaccion) {
                ((ISesionExtendida)sesion).rollBack();
            }
            return 0L;
        }
    }

    protected long anniadirRegistro(ISesion sesion, String nombreTabla, long forceIDINF, boolean llamadaEjecutandoBatchAnniadirRegistro) throws ExceptionMotor {
        try {
            if (((ISesionExtendida)sesion).isEjecutandoBatchAnniadirRegistro() && !llamadaEjecutandoBatchAnniadirRegistro) {
                throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras existan comandos batch_A\u00f1adirRegistro(...) pendientes");
            }
            if (sesion.getOrigenDeDatos().isOrigenDeDatosOrdenadoPorCriterio()) {
                throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras este ordenado el origen de datos por un criterio");
            }
            return this.anniadirRegistro(sesion, nombreTabla, forceIDINF);
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Tabla " + nombreTabla + "(" + forceIDINF + ")");
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla + "(" + forceIDINF + ")");
        }
    }

    @Override
    public boolean batchAnniadirRegistro(ISesion sesion, String nombreTabla, List<ITipoDatosCampoValor> campoValor) throws ExceptionMotor {
        try {
            if (!((ISesionExtendida)sesion).isEjecutandoBatchAnniadirRegistro()) {
                ((ISesionExtendida)sesion).setEjecutandoBatchAnniadirRegistro(true);
                sesion.getOrigenDeDatos().setDifferedWrite(1);
            }
            if (this.anniadirRegistro(sesion, nombreTabla, -1L, true) == -1L) {
                throw new ExceptionMotor("Error al insertar registro...");
            }
            boolean ret = true;
            String valor = null;
            for (int i = 0; i < campoValor.size(); ++i) {
                valor = campoValor.get(i).getValor();
                if (valor == null) {
                    valor = "";
                }
                ret &= this.establecerPartida(sesion, campoValor.get(i).getNombreCampo(), valor.toString());
            }
            return ret &= this.flush(sesion, nombreTabla, true);
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public boolean batchCommit(ISesion sesion) throws ExceptionMotor {
        if (!((ISesionExtendida)sesion).isEjecutandoBatchAnniadirRegistro()) {
            throw new ExceptionMotor("Se llamo a batch_Commit y no hay trabajos pendientes");
        }
        ((ISesionExtendida)sesion).setEjecutandoBatchAnniadirRegistro(false);
        sesion.getOrigenDeDatos().setDifferedWrite(0);
        return sesion.getOrigenDeDatos().commitTrans();
    }

    @Override
    public IRegEntrada obtenerCaracteristicasPartida(ISesion sesion, String nombrePartida) throws ExceptionMotor {
        return sesion.getModelo().getGestorConfiguracion().getEntrada(nombrePartida);
    }

    @Override
    public boolean limpiarRegistro(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        ITablaMotor nodo = null;
        try {
            if (this.recordCount(sesion, nombreTabla) == 0L) {
                return true;
            }
            nodo = ((ISesionExtendida)sesion).getBusquedaNodosObj().get(((ISesionExtendida)sesion).getPunteroActual()).buscarNodo(nombreTabla, ((ISesionExtendida)sesion).getVarNodoPrincipal().get(((ISesionExtendida)sesion).getPunteroActual()));
            if (nodo != null && this.limpiarRegistrosHijos(sesion, nodo.getRelacionadas())) {
                return this.limpiarRegistroActual(sesion, nodo);
            }
            return false;
        }
        catch (Exception ex) {
            if (!((ISesionExtendida)sesion).isModoSilencioso()) {
                if (ex instanceof ExceptionMotor) {
                    ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + "Tabla " + nombreTabla);
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
            }
            return false;
        }
    }

    protected boolean limpiarRegistrosHijos(ISesion sesion, IListaTablaMotor hijos) throws ExceptionMotor {
        ITablaMotor cTaAux = null;
        boolean res = true;
        long id = 0L;
        long rc = 0L;
        try {
            if (hijos == null) {
                return true;
            }
            block2: for (int i = 0; i < hijos.count(); ++i) {
                cTaAux = hijos.getTablaMotor(i);
                id = this.moveFirst(sesion, cTaAux.getNombre());
                rc = this.recordCount(sesion, cTaAux.getNombre());
                while (rc > 0L) {
                    if (!this.limpiarRegistrosHijos(sesion, cTaAux.getRelacionadas())) {
                        return false;
                    }
                    if (!this.limpiarRegistroActual(sesion, cTaAux)) {
                        return false;
                    }
                    if (id == rc) continue block2;
                    id = this.moveNext(sesion, cTaAux.getNombre());
                }
            }
            return res;
        }
        catch (Exception ex) {
            if (!((ISesionExtendida)sesion).isModoSilencioso()) {
                if (ex instanceof ExceptionMotor) {
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex);
            }
            return false;
        }
    }

    protected boolean limpiarRegistroActual(ISesion sesion, ITablaMotor nodo) throws ExceptionMotor {
        try {
            boolean ret = true;
            List<String> entradas = sesion.getModelo().getGestorConfiguracion().getCamposDeTabla(nodo.getNombre());
            for (String ent : entradas) {
                ret &= this.establecerPartida(sesion, ent, sesion.getModelo().getGestorConfiguracion().getEntrada(ent).getValorInicial());
                ret &= this.establecerEstado(sesion, ent, sesion.getModelo().getGestorConfiguracion().getEntrada(ent).getEstadoInicial());
            }
            return ret;
        }
        catch (Exception ex) {
            if (!((ISesionExtendida)sesion).isModoSilencioso()) {
                if (ex instanceof ExceptionMotor) {
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean establecerEstado(ISesion sesion, String nombrePartida, int estado) throws ExceptionMotor {
        if (!sesion.isEnabled()) {
            return true;
        }
        boolean heConseguidoEstablecer = false;
        boolean seCreoRegistro = false;
        ITablaMotor tAux = null;
        try {
            if (FuncionesUtiles.getFuncionesUtiles().sonIguales(sesion.getModelo().getGestorConfiguracion().getEntrada(nombrePartida).esTipoNumerico(), this.obtenerEstadoPartida(sesion, nombrePartida), estado)) {
                boolean bl = true;
                return bl;
            }
            seCreoRegistro = this.crearRegistroSiNoExiste(sesion, ((ISesionExtendida)sesion).obtenerNodoPartida(nombrePartida));
            IPartidaModificadaReglas partida = null;
            tAux = ((ISesionExtendida)sesion).obtenerNodoPartida(nombrePartida);
            int valorAnterior = 0;
            if (tAux == null) {
                throw new ExceptionMotor("No encuentro nodo de partida " + nombrePartida, Thread.currentThread().getStackTrace());
            }
            valorAnterior = this.obtenerEstadoPartida(sesion, nombrePartida);
            if (valorAnterior == estado) {
                boolean bl = true;
                return bl;
            }
            heConseguidoEstablecer = tAux.establecerEstado(nombrePartida, estado);
            if (heConseguidoEstablecer) {
                partida = null;
                if (((ISesionExtendida)sesion).getListaPartidasAfectadasEnUnaEjecucion().size() > 0) {
                    partida = ((ISesionExtendida)sesion).getListaPartidasAfectadasEnUnaEjecucion().get(((ISesionExtendida)sesion).getListaPartidasAfectadasEnUnaEjecucion().size() - 1).getLista().get(nombrePartida + "(" + tAux.getLocalizacion(((ISesionExtendida)sesion).getVarNodoPrincipal().get(((ISesionExtendida)sesion).getPunteroActual())) + ")");
                }
                if (partida == null) {
                    partida = new PartidaModificada(tAux, nombrePartida);
                }
                partida.setEstadoAnterior(valorAnterior);
                partida.setEstadoPosterior(estado);
                this.anniadirPartidaAListaAfectadasEnUnaEjecucion(sesion, nombrePartida, tAux, partida);
                if (!((ISesionExtendida)sesion).inTrans()) {
                    ((ISesionExtendida)sesion).notifica(false);
                }
                partida = null;
            }
            boolean bl = heConseguidoEstablecer;
            return bl;
        }
        catch (Exception ex) {
            if (!((ISesionExtendida)sesion).isModoSilencioso()) {
                if (ex instanceof ExceptionMotor) {
                    ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + "Partida " + nombrePartida + " estado " + estado);
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex, "Partida " + nombrePartida + " estado " + estado);
            }
            boolean bl = heConseguidoEstablecer;
            return bl;
        }
        finally {
            if (tAux != null && !heConseguidoEstablecer && seCreoRegistro) {
                this.borrarRegistro(sesion, tAux.getNombre());
            }
        }
    }

    @Override
    public boolean establecerEstado(ISesion sesion, String nombrePartida, boolean abierta) throws ExceptionMotor {
        if (!sesion.isEnabled()) {
            return true;
        }
        if (abierta) {
            return this.establecerEstado(sesion, nombrePartida, 255);
        }
        return this.establecerEstado(sesion, nombrePartida, 254);
    }

    @Override
    public List<ITablaMotorEntrada> obtenerRegistroDatosTablaArrayList(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        try {
            if (((ISesionExtendida)sesion).isEjecutandoBatchAnniadirRegistro()) {
                throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras existan comandos batch_A\u00f1adirRegistro(...) pendientes", Thread.currentThread().getStackTrace());
            }
            return FuncionesUtiles.getFuncionesUtiles().hashMap2ArrayListTablaMotorEntrada(this.obtenerRegistroDatosTabla(sesion, nombreTabla));
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e, "Tabla " + nombreTabla);
        }
    }

    @Override
    public Map<String, ITablaMotorEntrada> obtenerRegistroDatosTabla(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        try {
            if (((ISesionExtendida)sesion).isEjecutandoBatchAnniadirRegistro()) {
                throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras existan comandos batch_A\u00f1adirRegistro(...) pendientes", Thread.currentThread().getStackTrace());
            }
            ITablaMotor tAux = ((ISesionExtendida)sesion).getBusquedaNodosObj().get(((ISesionExtendida)sesion).getPunteroActual()).buscarNodo(nombreTabla, ((ISesionExtendida)sesion).getVarNodoPrincipal().get(((ISesionExtendida)sesion).getPunteroActual()));
            if (tAux == null) {
                return null;
            }
            return tAux.getRsDatosReferencia();
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e, "Tabla " + nombreTabla);
        }
    }

    @Override
    public List<ITipoDatosRegistro> obtenerRegistroTabla(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        try {
            List<ITablaMotorEntrada> ret = this.obtenerRegistroDatosTablaArrayList(sesion, nombreTabla);
            if (ret == null) {
                return new ArrayList<ITipoDatosRegistro>();
            }
            ArrayList<ITipoDatosRegistro> ret2 = new ArrayList<ITipoDatosRegistro>();
            for (int i = 0; i < ret.size(); ++i) {
                TipoDatosRegistro reg = new TipoDatosRegistro(ret.get(i).getNombreEntrada(), ret.get(i).getValor(), ret.get(i).getEstado());
                if (ret.get(i).getNombreEntrada().toString().equalsIgnoreCase("ID") || ret.get(i).getNombreEntrada().toString().equalsIgnoreCase("IDINF")) {
                    reg.setTipoDato("ENTERO");
                } else {
                    reg.setTipoDato(sesion.getModelo().getGestorConfiguracion().getEntrada(ret.get(i).getNombreEntrada()).getTipoDato());
                }
                ret2.add(reg);
                reg = null;
            }
            return ret2;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public List<ITipoDatosRegistro> obtenerRegistroTabla(ISesion sesion, String nombreTabla, long idRegistro) throws ExceptionMotor {
        FreezerMotor f = new FreezerMotor(sesion);
        try {
            if (idRegistro != this.obtenerClaveActiva(sesion, nombreTabla)) {
                f.freeze();
                if (this.move(sesion, nombreTabla, idRegistro) != idRegistro) {
                    List<ITipoDatosRegistro> list = null;
                    return list;
                }
            }
            List<ITipoDatosRegistro> list = this.obtenerRegistroTabla(sesion, nombreTabla);
            return list;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Tabla " + nombreTabla + " id " + idRegistro);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla + " id " + idRegistro);
        }
        finally {
            if (f.isFreezed()) {
                f.unfreeze();
            }
            f = null;
        }
    }

    @Override
    public List<List<ITipoDatosRegistro>> obtenerTabla(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        try {
            ITablaMotor tAux = ((ISesionExtendida)sesion).getBusquedaNodosObj().get(((ISesionExtendida)sesion).getPunteroActual()).buscarNodo(nombreTabla, ((ISesionExtendida)sesion).getVarNodoPrincipal().get(((ISesionExtendida)sesion).getPunteroActual()));
            if (tAux == null) {
                return null;
            }
            return sesion.getOrigenDeDatos().obtenerTabla(tAux);
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public List<Map<String, ITablaMotorEntrada>> obtenerTablaEx(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        try {
            ITablaMotor tAux = ((ISesionExtendida)sesion).getBusquedaNodosObj().get(((ISesionExtendida)sesion).getPunteroActual()).buscarNodo(nombreTabla, ((ISesionExtendida)sesion).getVarNodoPrincipal().get(((ISesionExtendida)sesion).getPunteroActual()));
            if (tAux == null) {
                return null;
            }
            return sesion.getOrigenDeDatos().obtenerTablaHashMap(tAux);
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public void enablePartidayTablasListeners(ISesion sesion, boolean habilitar) throws ExceptionMotor {
        sesion.getGestionReglas().setPartidayTablasListenersEnabled(habilitar);
    }

    @Override
    public void addPartidaModificadaListener(ISesion sesion, IPartidaModificada componente, String nombrePartida) throws ExceptionMotor {
        try {
            if (sesion.getModelo().getGestorConfiguracion().getEntrada(nombrePartida) == null) {
                throw new ExceptionMotor("Compruebe que " + nombrePartida + " es un nombre de partida correcta...");
            }
            if (((ISesionExtendida)sesion).getListenersPartidaModificada() == null) {
                ((ISesionExtendida)sesion).setListenersPartidaModificada(new HashMap<String, List<IPartidaModificada>>());
            }
            if (((ISesionExtendida)sesion).getListenersPartidaModificada().get(nombrePartida.toUpperCase()) == null) {
                ((ISesionExtendida)sesion).getListenersPartidaModificada().put(nombrePartida.toUpperCase(), new ArrayList());
            }
            if (!((ISesionExtendida)sesion).getListenersPartidaModificada().get(nombrePartida.toUpperCase()).contains(componente)) {
                ((ISesionExtendida)sesion).getListenersPartidaModificada().get(nombrePartida.toUpperCase()).add(componente);
            }
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Partida " + nombrePartida);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Partida " + nombrePartida);
        }
    }

    @Override
    public void addTablaModificadaListener(ISesion sesion, IPartidaModificada componente, String nombreTabla) throws ExceptionMotor {
        try {
            if (sesion.getModelo().getGestorConfiguracion().getTabla(nombreTabla) == null) {
                throw new ExceptionMotor("Compruebe que " + nombreTabla + " es un nombre de tabla correcto...");
            }
            if (((ISesionExtendida)sesion).getListenersTablaModificada() == null) {
                ((ISesionExtendida)sesion).setListenersTablaModificada(new HashMap<String, List<IPartidaModificada>>());
            }
            if (((ISesionExtendida)sesion).getListenersTablaModificada().get(nombreTabla.toUpperCase()) == null) {
                ((ISesionExtendida)sesion).getListenersTablaModificada().put(nombreTabla.toUpperCase(), new ArrayList());
            }
            ((ISesionExtendida)sesion).getListenersTablaModificada().get(nombreTabla.toUpperCase()).add(componente);
            List<String> partidasTabla = sesion.getModelo().getGestorConfiguracion().getCamposDeTabla(nombreTabla);
            for (int i = 0; i < partidasTabla.size(); ++i) {
                this.addPartidaModificadaListener(sesion, componente, partidasTabla.get(i));
            }
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public void refrescarPartidaModificadaListeners(ISesion sesion) throws ExceptionMotor {
        this.refrescarPartidaModificadaListeners(null, null);
    }

    @Override
    public void refrescarPartidaModificadaListeners(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        try {
            for (String partida : ((ISesionExtendida)sesion).getListenersPartidaModificada().keySet()) {
                List<IPartidaModificada> lista = ((ISesionExtendida)sesion).getListenersPartidaModificada().get(partida);
                if (nombreTabla != null && !sesion.getModelo().getGestorConfiguracion().getEntrada(partida).getIdTabla().equalsIgnoreCase(nombreTabla)) continue;
                String valor = this.obtenerPartidaString(sesion, partida);
                int estado = this.obtenerEstadoPartida(sesion, partida);
                for (int i = 0; i < lista.size(); ++i) {
                    lista.get(i).refrescaPartida(partida, 0L, 0L, valor, estado);
                }
            }
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public void removeTablaModificadaListener(ISesion sesion, IPartidaModificada componente, String nombreTabla) throws ExceptionMotor {
        try {
            if (sesion.getModelo().getGestorConfiguracion().getTabla(nombreTabla) == null) {
                throw new ExceptionMotor("Compruebe que " + nombreTabla + " es un nombre de tabla correcto...", Thread.currentThread().getStackTrace());
            }
            if (((ISesionExtendida)sesion).getListenersTablaModificada() != null && ((ISesionExtendida)sesion).getListenersTablaModificada().get(nombreTabla.toUpperCase()) != null) {
                ((ISesionExtendida)sesion).getListenersTablaModificada().get(nombreTabla.toUpperCase()).remove(componente);
                if (((ISesionExtendida)sesion).getListenersTablaModificada().get(nombreTabla.toUpperCase()).size() == 0) {
                    ((ISesionExtendida)sesion).getListenersTablaModificada().remove(nombreTabla.toUpperCase());
                }
            }
            List<String> partidasTabla = sesion.getModelo().getGestorConfiguracion().getCamposDeTabla(nombreTabla);
            for (int i = 0; i < partidasTabla.size(); ++i) {
                this.removePartidaModificadaListener(sesion, componente, partidasTabla.get(i));
            }
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public void removePartidaModificadaListener(ISesion sesion, IPartidaModificada componente, String nombrePartida) throws ExceptionMotor {
        try {
            if (sesion.getModelo().getGestorConfiguracion().getEntrada(nombrePartida) == null) {
                throw new ExceptionMotor("Compruebe que " + nombrePartida + " es un nombre de partida correcta...", Thread.currentThread().getStackTrace());
            }
            if (((ISesionExtendida)sesion).getListenersPartidaModificada() != null && ((ISesionExtendida)sesion).getListenersPartidaModificada().get(nombrePartida.toUpperCase()) != null) {
                ((ISesionExtendida)sesion).getListenersPartidaModificada().get(nombrePartida.toUpperCase()).remove(componente);
                if (((ISesionExtendida)sesion).getListenersPartidaModificada().get(nombrePartida.toUpperCase()).size() == 0) {
                    ((ISesionExtendida)sesion).getListenersPartidaModificada().remove(nombrePartida.toUpperCase());
                }
            }
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Partida " + nombrePartida);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Partida " + nombrePartida);
        }
    }

    @Override
    public void funcionesErrorComportamientoEspecial(ISesion sesion, boolean habilitar) throws ExceptionMotor {
        sesion.isFuncionesErrorComportamientoEspecial();
    }

    @Override
    public boolean isFuncionesErrorComportamientoEspecial(ISesion sesion) throws ExceptionMotor {
        return sesion.isFuncionesErrorComportamientoEspecial();
    }

    @Override
    public Object clona(ISesion sesion) throws ExceptionMotor {
        return sesion.getOrigenDeDatos().clona();
    }

    @Override
    public boolean restauraDocumento(ISesion sesion, Object datos) throws ExceptionMotor {
        return sesion.getOrigenDeDatos().restauraDocumento(datos);
    }

    @Override
    public void setModoTransacciones(ISesion sesion, int modoTransaccion) throws ExceptionMotor {
        sesion.getOrigenDeDatos().setModoTransacciones(modoTransaccion);
    }

    @Override
    public int getModoTransacciones(ISesion sesion) throws ExceptionMotor {
        return sesion.getOrigenDeDatos().getModoTransacciones();
    }

    protected boolean establecerPartidas(ISesion sesion, ITablaMotor tAux) throws ExceptionMotor {
        String nombreTabla = "";
        long iDFisico = 0L;
        long claveSuperior = 0L;
        try {
            nombreTabla = tAux.getNombre();
            iDFisico = tAux.getClaveActiva();
            claveSuperior = tAux.getClaveSuperior();
            if (sesion.getOrigenDeDatos().getDifferedWrite() == 1) {
                try {
                    return sesion.getOrigenDeDatos().establecerPartidas(tAux);
                }
                catch (NotImplementedException ex) {
                    // empty catch block
                }
            }
            return this.establecerPartidas(sesion, tAux.getRsDatosReferencia(), tAux.getNombre(), tAux.getClaveActiva(), tAux.getClaveSuperior(), false);
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Tabla " + nombreTabla + " id " + iDFisico + " id padre " + claveSuperior);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla + " id " + iDFisico + " id padre " + claveSuperior);
        }
    }

    protected boolean establecerPartidas(ISesion sesion, Map<String, ITablaMotorEntrada> rs, String nombreTabla, long iDFisico, long claveSuperior, boolean sonEstados) throws ExceptionMotor {
        try {
            String tabla = "";
            String partida2 = "";
            boolean encontrado = false;
            Set<String> s = rs.keySet();
            for (String partida2 : s) {
                if (partida2.equalsIgnoreCase("ID") || partida2.equalsIgnoreCase("IDINF")) continue;
                tabla = sesion.getModelo().getGestorConfiguracion().getEntrada(partida2).getIdTabla();
                encontrado = false;
                if (tabla.equalsIgnoreCase(nombreTabla)) {
                    encontrado = true;
                    break;
                }
                if (encontrado || ((ISesionExtendida)sesion).isModoSilencioso()) continue;
                throw new ExceptionMotor("Al establecer partidas la partida " + partida2 + " no parece pertenecer a la tabla " + nombreTabla);
            }
            return true;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Tabla " + nombreTabla + " id " + iDFisico + " id padre " + claveSuperior);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla + " id " + iDFisico + " id padre " + claveSuperior);
        }
    }

    @Override
    public boolean flush(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        try {
            if (nombreTabla == null || nombreTabla.length() == 0) {
                return this.establecerPartidas(sesion, null, "", -1L, -1L, false);
            }
            ITablaMotor tAux = ((ISesionExtendida)sesion).getBusquedaNodosObj().get(((ISesionExtendida)sesion).getPunteroActual()).buscarNodo(nombreTabla, ((ISesionExtendida)sesion).getVarNodoPrincipal().get(((ISesionExtendida)sesion).getPunteroActual()));
            if (tAux == null) {
                return false;
            }
            return this.establecerPartidas(sesion, tAux);
        }
        catch (Exception ex) {
            if (!((ISesionExtendida)sesion).isModoSilencioso()) {
                if (ex instanceof ExceptionMotor) {
                    ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + "Tabla " + nombreTabla);
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
            }
            return false;
        }
    }

    protected boolean flush(ISesion sesion, String nombreTabla, boolean llamadaEjecutandoBatchAnniadirRegistro) throws ExceptionMotor {
        if (((ISesionExtendida)sesion).isEjecutandoBatchAnniadirRegistro() && !llamadaEjecutandoBatchAnniadirRegistro) {
            throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras existan comandos batch_A\u00f1adirRegistro(...) pendientes", Thread.currentThread().getStackTrace());
        }
        return this.flush(sesion, nombreTabla);
    }

    @Override
    public boolean flushActualizarRegistro(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        return this.flush(sesion, nombreTabla);
    }

    @Override
    public void setIgnorarRegistrosDeEstados(ISesion sesion, boolean habilitar) throws ExceptionMotor {
        ((ISesionExtendida)sesion).setIgnorarRegistrosDeEstados(habilitar);
    }

    @Override
    public void setTablaIdInfCacheHabilitada(ISesion sesion, boolean habilitar) throws ExceptionMotor {
        ((ISesionExtendida)sesion).setTablaIdInfCacheHabilitada(habilitar);
    }

    @Override
    public boolean getIgnorarRegistrosDeEstados(ISesion sesion) throws ExceptionMotor {
        return ((ISesionExtendida)sesion).getIgnorarRegistrosDeEstados();
    }

    @Override
    public boolean getTablaIdInfCacheHabilitada(ISesion sesion) throws ExceptionMotor {
        return ((ISesionExtendida)sesion).getTablaIdInfCacheHabilitada();
    }

    @Override
    public boolean forzarEscrituraRsDatosRsEstadosalOD(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        try {
            return ((ISesionExtendida)sesion).obtenerNodoTabla(nombreTabla) != null;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected Object obtenerTipoDatoPartida(ISesion sesion, String partida) {
        try {
            IRegEntrada ent = sesion.getModelo().getGestorConfiguracion().getEntrada(partida);
            if (ent != null) {
                String tipo = ent.getTipoDato();
                if (tipo.equalsIgnoreCase("DOBLE")) {
                    return 0.0;
                }
                if (tipo.equalsIgnoreCase("BIGDECIMAL")) {
                    return "0";
                }
                if (tipo.equalsIgnoreCase("LOGICO")) {
                    return Boolean.FALSE;
                }
                if (tipo.equalsIgnoreCase("ENTERO")) {
                    return 0;
                }
                return "";
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Object obtenerValorInicialPartida(ISesion sesion, String partida) throws ExceptionMotor {
        try {
            IRegEntrada ent = sesion.getModelo().getGestorConfiguracion().getEntrada(partida);
            if (ent.getTipoDato().equalsIgnoreCase("ENTERO")) {
                return Integer.valueOf(ent.getValorInicial());
            }
            if (ent.getTipoDato().equalsIgnoreCase("DOBLE")) {
                return Double.valueOf(ent.getValorInicial());
            }
            if (ent.getTipoDato().equalsIgnoreCase("BIGDECIMAL")) {
                return ent.getValorInicial();
            }
            if (ent.getTipoDato().equalsIgnoreCase("LOGICO")) {
                return Boolean.valueOf(ent.getValorInicial());
            }
            if (ent.getTipoDato().equalsIgnoreCase("CADENA_NUMERICA")) {
                return "0";
            }
            return ent.getValorInicial().toString();
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Imposible obtener valor inicial de " + partida);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Imposible obtener valor inicial de " + partida);
        }
    }

    protected Object obtenerDatoPartidaCreadoSegunSuValorString(ISesion sesion, String partida, String valorEnString) {
        try {
            IRegEntrada ent = sesion.getModelo().getGestorConfiguracion().getEntrada(partida);
            if (ent != null) {
                if (ent.getTipoDato().equalsIgnoreCase("DOBLE")) {
                    return Double.valueOf(valorEnString);
                }
                if (ent.getTipoDato().equalsIgnoreCase("BIGDECIMAL")) {
                    return valorEnString;
                }
                if (ent.getTipoDato().equalsIgnoreCase("LOGICO")) {
                    return Boolean.valueOf(valorEnString);
                }
                if (ent.getTipoDato().equalsIgnoreCase("ENTERO")) {
                    return Integer.valueOf(valorEnString);
                }
                return "";
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected int obtenerEstadoDefectoPartida(ISesion sesion, String partida) throws ExceptionMotor {
        try {
            int estadoDevolver = 255;
            IRegEntrada ent = sesion.getModelo().getGestorConfiguracion().getEntrada(partida);
            if (ent != null) {
                estadoDevolver = ent.getEstadoInicial();
            }
            return estadoDevolver;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Partida " + partida);
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e, "Partida " + partida);
        }
    }

    protected Object obtenerDatoDelOrigenSegunSuTipoDato(ISesion sesion, String partida, ITablaMotor nodoAux, Object resultado) {
        if (resultado instanceof String) {
            return this.obtenerDatoDelOrigenSegunSuTipoDato(sesion, partida, nodoAux, (String)resultado);
        }
        if (resultado instanceof Double) {
            return this.obtenerDatoDelOrigenSegunSuTipoDato(sesion, partida, nodoAux, (Double)resultado);
        }
        if (resultado instanceof BigDecimal) {
            return this.obtenerDatoDelOrigenSegunSuTipoDato(sesion, partida, nodoAux, (BigDecimal)resultado);
        }
        if (resultado instanceof Boolean) {
            return this.obtenerDatoDelOrigenSegunSuTipoDato(sesion, partida, nodoAux, (Boolean)resultado);
        }
        if (resultado instanceof Integer) {
            return this.obtenerDatoDelOrigenSegunSuTipoDato(sesion, partida, nodoAux, (Integer)resultado);
        }
        return null;
    }

    @Override
    public Object obtenerPartida(ISesion sesion, String nombrePartida) throws ExceptionMotor {
        try {
            String nombreTabla = ((ISesionExtendida)sesion).buscarPartidaEnTabla(nombrePartida);
            if (nombreTabla.length() == 0) {
                throw new ExceptionMotor("La partida no se encuentra en ninguna tabla del modelo");
            }
            ITablaMotor tAux = ((ISesionExtendida)sesion).getBusquedaNodosObj().get(((ISesionExtendida)sesion).getPunteroActual()).buscarNodo(nombreTabla, ((ISesionExtendida)sesion).getVarNodoPrincipal().get(((ISesionExtendida)sesion).getPunteroActual()));
            if (tAux == null) {
                throw new ExceptionMotor("La relaci\u00f3n que identifica la partida con su tabla no es correcta nombre de tabla: " + nombreTabla);
            }
            Object res = null;
            res = tAux.obtenerPartidaString(nombrePartida.toUpperCase());
            if (res != null) {
                if (res.toString().trim().length() == 0) {
                    res = this.devolverValorDatoParseadoSegunTipo(sesion, nombrePartida);
                }
                return res.toString();
            }
            res = this.obtenerValorInicialPartida(sesion, nombrePartida);
            return res.toString();
        }
        catch (Exception ex) {
            if (!((ISesionExtendida)sesion).isModoSilencioso()) {
                if (ex instanceof ExceptionMotor) {
                    ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + "Partida " + nombrePartida);
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex, "Partida " + nombrePartida);
            }
            return null;
        }
    }

    protected String devolverValorDatoParseadoSegunTipo(ISesion sesion, String nombrePartida) throws ExceptionMotor {
        try {
            IRegEntrada ent = sesion.getModelo().getGestorConfiguracion().getEntrada(nombrePartida);
            if (ent != null) {
                String tipoDato = ent.getTipoDato();
                if (ent.esTipoNumerico()) {
                    return "0";
                }
                if (tipoDato.equalsIgnoreCase("LOGICO") || tipoDato.equalsIgnoreCase("FICTICIA")) {
                    return "false";
                }
                return "";
            }
            throw new ExceptionMotor("No se puede devolver el dato parseado seg\u00fan el tipo porque la partida no tiene indicado el tipo de campo en el fichero Entradas.xml");
        }
        catch (Exception ex) {
            if (!((ISesionExtendida)sesion).isModoSilencioso()) {
                if (ex instanceof ExceptionMotor) {
                    ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + "Partida " + nombrePartida);
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex, "Partida " + nombrePartida);
            }
            return null;
        }
    }

    protected void anniadirPartidaAListaAfectadasEnUnaEjecucion(ISesion sesion, String nombrePartida, ITablaMotor nodo, IPartidaModificadaReglas partida) throws ExceptionMotor {
        try {
            if (!((ISesionExtendida)sesion).inTrans()) {
                return;
            }
            if (partida.getValorAnterior().toString().equals(partida.getValorPosterior().toString()) && partida.getEstadoAnterior() == partida.getEstadoPosterior()) {
                return;
            }
            if (((ISesionExtendida)sesion).getListaPartidasAfectadasEnUnaEjecucion().size() == 0) {
                ((ISesionExtendida)sesion).anniadirGrupoPartidasAfectadasEnUnaEjecucion();
            }
            if (partida.getLocalizacion().length() == 0) {
                partida.setLocalizacion(nodo.getLocalizacion(this.getNodoPrincipal(sesion)));
            }
            if (partida.getValorPosterior() != null && partida.getValorPosterior() instanceof Double && partida.getValorPosterior().toString().contains("E")) {
                partida.setValorPosterior(FuncionesUtiles.getFuncionesUtiles().doubleToString((Double)partida.getValorPosterior()));
            }
            ((ISesionExtendida)sesion).getListaPartidasAfectadasEnUnaEjecucion().get(((ISesionExtendida)sesion).getListaPartidasAfectadasEnUnaEjecucion().size() - 1).getLista().put(nombrePartida + "(" + partida.getLocalizacion() + ")", partida);
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Partida " + nombrePartida);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Partida " + nombrePartida);
        }
    }

    private String valorDependienteDeTipo(ISesion sesion, String nombrePartida, String valString) {
        String valorString = valString;
        try {
            if (valorString == null || valorString.trim().length() == 0) {
                IRegEntrada ent = sesion.getModelo().getGestorConfiguracion().getEntrada(nombrePartida);
                if (ent == null) {
                    throw new ExceptionMotor("No puedo identificar la partida");
                }
                if (ent.getTipoDato().equalsIgnoreCase("ENTERO") || ent.getTipoDato().equalsIgnoreCase("DOBLE") || ent.getTipoDato().equalsIgnoreCase("BIGDECIMAL")) {
                    valorString = "0";
                } else if (ent.getTipoDato().equalsIgnoreCase("LOGICO")) {
                    valorString = "false";
                }
            }
            return valorString;
        }
        catch (Exception ex) {
            return valorString;
        }
    }

    private boolean crearRegistroSiNoExiste(ISesion sesion, ITablaMotor tAux) throws ExceptionMotor {
        try {
            if (tAux != null && tAux.getClaveActiva() == 0L) {
                if (((ISesionExtendida)sesion).getRegistrosA\u00f1adidosPorReglasAlImportar() != null) {
                    ((ISesionExtendida)sesion).getRegistrosA\u00f1adidosPorReglasAlImportar().put(tAux.getNombre(), FuncionesUtiles.getFuncionesUtiles().dameCadenaPadreLocalizacion(tAux.getLocalizacion()));
                }
                return this.anniadirRegistro(sesion, tAux.getNombre()) > 0L;
            }
            return false;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }
}

