/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.puente;

import es.aeat.pftw.mtrc.puente.IBusquedaNodos;
import es.aeat.pftw.mtrc.puente.IListaTablaMotor;
import es.aeat.pftw.mtrc.puente.ITablaMotor;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import java.io.Serializable;

public final class BusquedaNodos
implements Serializable,
IBusquedaNodos {
    private static final long serialVersionUID = 1L;
    private ITablaMotor cacheNodo = null;
    private String nombreTablaPuntero = "";
    private static boolean encontradaBuscada = false;
    private static boolean encontradaFrontera = false;

    public BusquedaNodos(String nombreTablaPuntero) {
        this.nombreTablaPuntero = nombreTablaPuntero;
        this.cacheNodo = null;
    }

    @Override
    public int tablaAnteriorATabla(ITablaMotor nodo, String tablaBuscar, String tablaFrontera) throws ExceptionMotor {
        encontradaBuscada = false;
        encontradaFrontera = false;
        return this.prvTablaAnteriorATabla(nodo, tablaBuscar, tablaFrontera);
    }

    private int prvTablaAnteriorATabla(ITablaMotor nodo, String tablaBuscar, String tablaFrontera) throws ExceptionMotor {
        ITablaMotor cacheNodoAux = null;
        try {
            if (tablaBuscar.equalsIgnoreCase(tablaFrontera)) {
                int n = 2;
                return n;
            }
            if (nodo.getNombre().equalsIgnoreCase(tablaBuscar)) {
                encontradaBuscada = true;
                if (encontradaFrontera) {
                    int n = 2;
                    return n;
                }
            }
            if (nodo.getNombre().equalsIgnoreCase(tablaFrontera)) {
                encontradaFrontera = true;
                if (encontradaBuscada) {
                    int n = 1;
                    return n;
                }
            }
            int ret = 0;
            IListaTablaMotor relacionadas = nodo.getRelacionadas();
            for (int i = 0; i < relacionadas.count(); ++i) {
                Integer miInt = i;
                cacheNodoAux = relacionadas.getTablaMotor(miInt);
                if (cacheNodoAux != null && (ret = this.prvTablaAnteriorATabla(cacheNodoAux, tablaBuscar, tablaFrontera)) != 0) {
                    int n = ret;
                    return n;
                }
                cacheNodoAux = null;
            }
            int n = 0;
            return n;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
        finally {
            cacheNodoAux = null;
        }
    }

    @Override
    public ITablaMotor buscarNodo(String nombre, ITablaMotor nodo) {
        try {
            if (this.cacheNodo != null && this.cacheNodo.getNombre().equalsIgnoreCase(nombre)) {
                return this.cacheNodo;
            }
            if (nodo != null) {
                if (nodo.getNombre().equalsIgnoreCase(nombre)) {
                    this.cacheNodo = nodo;
                    return this.cacheNodo;
                }
                IListaTablaMotor relacionadas = nodo.getRelacionadas();
                for (int i = 0; i < relacionadas.count(); ++i) {
                    Integer miInt = i;
                    this.cacheNodo = relacionadas.getTablaMotor(miInt);
                    if (this.cacheNodo == null) continue;
                    this.cacheNodo = this.buscarNodo(nombre, this.cacheNodo);
                    if (this.cacheNodo == null) continue;
                    return this.cacheNodo;
                }
                return null;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String buscarPathNodo(String nombre, ITablaMotor nodo) {
        String res = "";
        try {
            if (nodo.getNombre().equalsIgnoreCase(nombre)) {
                return nombre;
            }
            res = nodo.getNombre();
            IListaTablaMotor relacionadas = nodo.getRelacionadas();
            for (int i = 0; i < relacionadas.count(); ++i) {
                String devuelto;
                ITablaMotor taux = relacionadas.getTablaMotor(i);
                if (taux == null || (devuelto = this.buscarPathNodo(nombre, taux)).length() <= 0) continue;
                return res + "/" + devuelto;
            }
            return "";
        }
        catch (Exception ex) {
            return "";
        }
    }

    @Override
    public String getNombreTablaPuntero() {
        return this.nombreTablaPuntero;
    }

    @Override
    public IBusquedaNodos clone() {
        try {
            return new BusquedaNodos(this.getNombreTablaPuntero().toString());
        }
        catch (Exception ex) {
            FuncionesUtiles.getFuncionesUtiles().muestraError(ex);
            return null;
        }
    }

    @Override
    public void clearCache() {
        this.cacheNodo = null;
    }
}

