/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.procesadorReglas;

import es.aeat.pftw.mtrc.IAop;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import java.io.Serializable;
import java.text.StringCharacterIterator;

public final class ValidaNif
implements IAop,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean nifOk = false;
    public static final int TAM_NIF = 9;
    public static final int NIF_ERROR = -1;
    public static final int NIF_ERROR_TAMANO = -2;
    public static final int NIF_ERROR_BLANCOS = -3;
    public static final int NIF_ERROR_CARACTERES = -4;
    public static final int NIF_ERROR_3LETRAS = -5;
    public static final int NIF_ERROR_DATOSENTRADA = -6;
    public static final int CIF_ERROR_DC = -10;
    public static final int NIF_ERROR_DC = -11;
    public static final int NIF_ERROR_NUM = -12;
    public static final int NIF_ERROR_DOSNUM = -13;
    public static final int DNI_ERROR_MAX = -20;
    public static final int DNI_ERROR_VALOR = -21;
    public static final int DNI_OK = 0;
    public static final int NIF_OK = 1;
    public static final int NIF_NORESIDENTES = 2;
    public static final int NIF_MENORES14ANOS = 3;
    public static final int NIF_EXTRANJEROS = 4;
    public static final int CIF_OK = 20;
    public static final int CIF_EXTRANJERO_OK = 21;
    public static final int CIF_ORGANIZACION_OK = 22;
    public static final int CIF_NORESIDENTES_OK = 23;
    public static final char[] NUMEROS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final char[] LETRAS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Y', 'Z'};
    public static final char[] LETRASNIF = new char[]{'T', 'R', 'W', 'A', 'G', 'M', 'Y', 'F', 'P', 'D', 'X', 'B', 'N', 'J', 'Z', 'S', 'Q', 'V', 'H', 'L', 'C', 'K', 'E'};
    public static final char[] LETRAS2CIF = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J'};
    public static final char[] LETRASCIF = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'U', 'V'};
    public static final char[] LETRASCIFORG = new char[]{'P', 'Q', 'S', 'R'};
    public static final char[] LETRASREGATRIBRENTAS = new char[]{'E', 'G', 'H', 'J', 'U', 'V'};
    public static final char[] LETRASNIFEXT = new char[]{'X', 'Y', 'Z'};
    public static final char[] LETRASCIFEXT = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'N', 'W'};
    public static final String CEROS = "000000000";
    private String elNif = "";

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
    }

    @Override
    public void dispose() {
    }

    public int checkNif(String nifEntra) {
        if (nifEntra == null || nifEntra.length() == 0) {
            return -1;
        }
        this.elNif = this.aNif(nifEntra);
        if (this.elNif != null) {
            return this.vNif(this.elNif);
        }
        return -1;
    }

    public int checkNifSinFormatear(String nifEntra) {
        if (nifEntra == null || nifEntra.length() == 0) {
            return -1;
        }
        return this.vNif(nifEntra);
    }

    public String getNif() {
        return this.elNif;
    }

    public int vNif(String nif) {
        int i;
        String sNif = nif;
        this.nifOk = false;
        String dos = null;
        int multi = 0;
        int suma = 0;
        long cuent = 0L;
        long resto = 0L;
        if ((sNif = sNif.trim()).length() != 9) {
            return -2;
        }
        char letra1 = '\u0000';
        char letra2 = '\u0000';
        int numeroLetras = 0;
        int posLetra1 = 0;
        int posLetra2 = 0;
        char[] datos = sNif.toCharArray();
        for (i = 0; i < 9; ++i) {
            char ch = datos[i];
            int tipo = Character.getType(ch);
            if (tipo == 1 && numeroLetras == 0) {
                ++numeroLetras;
                letra1 = ch;
                posLetra1 = i;
                continue;
            }
            if (tipo == 1 && numeroLetras == 1) {
                ++numeroLetras;
                letra2 = ch;
                posLetra2 = i;
                continue;
            }
            if (tipo == 1 && numeroLetras == 2) {
                return -5;
            }
            if (tipo == 9) continue;
            return -4;
        }
        if (numeroLetras == 0) {
            if (datos[0] != '0') {
                return -20;
            }
            String sdos = sNif.substring(1);
            if (sdos.equals("11111111") || sdos.equals("22222222") || sdos.equals("33333333") || sdos.equals("44444444") || sdos.equals("55555555") || sdos.equals("66666666") || sdos.equals("77777777") || sdos.equals("88888888") || sdos.equals("99999999") || sdos.equals("00000000")) {
                return -21;
            }
            return 0;
        }
        if (numeroLetras == 1 && ValidaNif.caracEnCad(LETRASCIF, datos[posLetra1]) && posLetra1 == 0 && Character.isDigit(datos[8])) {
            for (i = 1; i < 8; ++i) {
                if (i == 2 || i == 4 || i == 6) {
                    suma += datos[i] - 48;
                    continue;
                }
                multi = (datos[i] - 48) * 2;
                if (multi > 9) {
                    multi -= 9;
                }
                suma += multi;
            }
            if ((suma = 10 - suma % 10) == 10) {
                suma = 0;
            }
            if (suma == datos[i] - 48) {
                if (ValidaNif.caracEnCad(LETRASREGATRIBRENTAS, datos[posLetra1])) {
                    this.nifOk = true;
                    return 23;
                }
                this.nifOk = true;
                return 20;
            }
            return -10;
        }
        if (numeroLetras == 2 && (ValidaNif.caracEnCad(LETRASCIFEXT, datos[posLetra1]) || ValidaNif.caracEnCad(LETRASCIFORG, datos[posLetra1])) && ValidaNif.caracEnCad(LETRAS2CIF, datos[posLetra2]) && posLetra1 == 0 && posLetra2 == 8) {
            for (i = 1; i < 8; ++i) {
                if (i == 2 || i == 4 || i == 6) {
                    suma += datos[i] - 48;
                    continue;
                }
                multi = (datos[i] - 48) * 2;
                if (multi > 9) {
                    multi -= 9;
                }
                suma += multi;
            }
            if (LETRAS2CIF[(suma = 10 - suma % 10) - 1] == datos[posLetra2]) {
                this.nifOk = true;
                if (ValidaNif.caracEnCad(LETRASCIFEXT, datos[posLetra1])) {
                    return 21;
                }
                return 22;
            }
            return -10;
        }
        if (numeroLetras == 1 && ValidaNif.caracEnCad(LETRAS, datos[8]) && ValidaNif.caracEnCad(LETRASNIF, datos[posLetra1]) && posLetra1 == 8) {
            StringBuffer buf = new StringBuffer(sNif.substring(0, posLetra1));
            cuent = Long.parseLong(buf.toString());
            resto = cuent % 23L;
            if (resto + 1L > 23L) {
                return -12;
            }
            if (letra1 == LETRASNIF[(int)resto]) {
                if (sNif.equals("00000001R") || sNif.equals("00000000T") || sNif.equals("99999999R")) {
                    return -1;
                }
                this.nifOk = true;
                return 1;
            }
            return -11;
        }
        if (numeroLetras == 2 && (datos[0] == 'K' || datos[0] == 'L' || datos[0] == 'M') && ValidaNif.caracEnCad(LETRASNIF, datos[posLetra2]) && posLetra2 == 8) {
            dos = sNif.substring(1, 3);
            if (!ValidaNif.caracEnCad(NUMEROS, dos.charAt(0)) || !ValidaNif.caracEnCad(NUMEROS, dos.charAt(1))) {
                return -13;
            }
            i = Integer.parseInt(dos);
            if (i < 1 || i > 56) {
                return -1;
            }
            dos = sNif.substring(1, posLetra2);
            cuent = Long.parseLong(dos);
            resto = cuent % 23L;
            if (++resto > 23L) {
                return -12;
            }
            if (letra2 == LETRASNIF[(int)(resto - 1L)]) {
                this.nifOk = true;
                return 2;
            }
            return -11;
        }
        if (sNif.equals("X0000000T")) {
            return -1;
        }
        if (numeroLetras == 2 && ValidaNif.caracEnCad(LETRASNIFEXT, datos[0]) && ValidaNif.caracEnCad(LETRASNIF, datos[posLetra2]) && posLetra2 == 8) {
            dos = sNif.substring(1, posLetra2);
            cuent = Long.parseLong(dos);
            if (datos[0] == 'Y') {
                cuent += 10000000L;
            } else if (datos[0] == 'Z') {
                cuent += 20000000L;
            }
            resto = cuent % 23L;
            if (++resto > 23L) {
                return -12;
            }
            if (letra2 == LETRASNIF[(int)(resto - 1L)]) {
                this.nifOk = true;
                return 4;
            }
            return -11;
        }
        return -1;
    }

    public boolean isOk() {
        return this.nifOk;
    }

    public String aNif(String origen) {
        String destino = origen.toUpperCase();
        int tam = destino.length();
        if (tam > 9) {
            return "";
        }
        return destino;
    }

    public static String quitaCaracRaros(String datos) {
        StringBuffer buf = new StringBuffer(datos.length());
        StringCharacterIterator iter = new StringCharacterIterator(datos);
        char c = iter.first();
        while (c != '\uffff') {
            if (Character.isLetterOrDigit(c)) {
                buf.append(c);
            }
            c = iter.next();
        }
        return buf.toString();
    }

    public static String quitaBlanInter(String datos) {
        StringBuffer buf = new StringBuffer(datos.length());
        StringCharacterIterator iter = new StringCharacterIterator(datos);
        char c = iter.first();
        while (c != '\uffff') {
            if (c != ' ') {
                buf.append(c);
            }
            c = iter.next();
        }
        return buf.toString();
    }

    public static String quitaCaracter(String datos, char car) {
        StringBuffer buf = new StringBuffer(datos.length());
        StringCharacterIterator iter = new StringCharacterIterator(datos);
        char c = iter.first();
        while (c != '\uffff') {
            if (c != car) {
                buf.append(c);
            }
            c = iter.next();
        }
        return buf.toString();
    }

    public static boolean caracEnCad(char[] datos, char ch) {
        boolean bRet = false;
        int tam = datos.length;
        for (int i = 0; i < tam; ++i) {
            if (datos[i] != ch) continue;
            bRet = true;
            break;
        }
        return bRet;
    }

    public static boolean caracEnCad(String datos, char ch) {
        boolean bRet = false;
        StringCharacterIterator iter = new StringCharacterIterator(datos);
        char c = iter.first();
        while (c != '\uffff') {
            if (c == ch) {
                bRet = true;
                break;
            }
            c = iter.next();
        }
        return bRet;
    }

    public static String quitaAcentos(String datos) {
        StringBuffer cads = new StringBuffer(datos.length());
        StringCharacterIterator iter = new StringCharacterIterator(datos);
        char c = iter.first();
        while (c != '\uffff') {
            switch (c) {
                case '\u00e1': {
                    c = 'a';
                    break;
                }
                case '\u00e9': {
                    c = 'e';
                    break;
                }
                case '\u00ed': {
                    c = 'i';
                    break;
                }
                case '\u00f3': {
                    c = 'o';
                    break;
                }
                case '\u00fa': {
                    c = 'u';
                    break;
                }
                case '\u00c1': {
                    c = 'A';
                    break;
                }
                case '\u00c9': {
                    c = 'E';
                    break;
                }
                case '\u00cd': {
                    c = 'I';
                    break;
                }
                case '\u00d3': {
                    c = 'O';
                    break;
                }
                case '\u00da': {
                    c = 'U';
                    break;
                }
            }
            cads.append(c);
            c = iter.next();
        }
        return cads.toString();
    }

    public static String rellenaCeros(String datos, int tam) {
        StringBuffer buff = new StringBuffer(41);
        int tamAct = datos.length();
        if (tamAct != 9 && tamAct < tam) {
            buff.append(CEROS.substring(0, tam - tamAct));
        }
        buff.append(datos);
        return buff.toString();
    }

    public static String cambComaPunto(String datos) {
        return datos.replace(',', '.');
    }

    public boolean esPersonaFisica(int nTipoNif, boolean bDNI) {
        boolean bPersonaFisica = bDNI ? nTipoNif >= 0 && nTipoNif < 20 : nTipoNif > 0 && nTipoNif < 20;
        return bPersonaFisica;
    }

    public int controlaCuenta(String cad) throws ExceptionMotor {
        int[] peso = new int[]{6, 3, 7, 9, 10, 5, 8, 4, 2, 1};
        long suma = 0L;
        long mod = 0L;
        char[] datos = cad.toCharArray();
        try {
            int i = 7;
            int j = 0;
            while (i >= 0) {
                suma += (long)((datos[i] - 48) * peso[j]);
                --i;
                ++j;
            }
            mod = Math.abs(suma % 11L - 11L);
            if (mod == 10L) {
                mod = 1L;
            }
            if (mod == 11L) {
                mod = 0L;
            }
            if (mod != (long)(datos[8] - 48)) {
                return 1;
            }
            suma = 0L;
            i = 19;
            j = 0;
            while (i >= 10) {
                suma += (long)((datos[i] - 48) * peso[j]);
                --i;
                ++j;
            }
            mod = Math.abs(suma % 11L - 11L);
            if (mod == 10L) {
                mod = 1L;
            }
            if (mod == 11L) {
                mod = 0L;
            }
            if (mod != (long)(datos[9] - 48)) {
                return 2;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ExceptionMotor(e);
        }
        catch (IndexOutOfBoundsException Ioe) {
            throw new ExceptionMotor(Ioe);
        }
        return 0;
    }

    public int controlaCuentaCCV(String cad) throws ExceptionMotor {
        int[] peso = new int[]{6, 3, 7, 9, 10, 5, 8, 4};
        int[] peso2 = new int[]{2, 3, 4, 5, 6, 7, 2, 3, 4, 5};
        char[] datos = cad.toCharArray();
        long mod = 0L;
        long suma = 0L;
        try {
            int i = 7;
            int j = 0;
            while (i >= 0) {
                suma += (long)((datos[i] - 48) * peso[j]);
                --i;
                ++j;
            }
            mod = Math.abs(suma % 11L - 11L);
            if (mod == 10L) {
                mod = 1L;
            }
            if (mod == 11L) {
                mod = 0L;
            }
            if (mod != (long)(datos[8] - 48)) {
                return 1;
            }
            suma = 0L;
            i = 19;
            j = 0;
            while (i >= 10) {
                suma += (long)((datos[i] - 48) * peso2[j]);
                --i;
                ++j;
            }
            mod = Math.abs(suma % 11L - 11L);
            if (mod == 10L) {
                mod = 0L;
            }
            if (mod == 11L) {
                mod = 1L;
            }
            if (mod != (long)(datos[9] - 48)) {
                return 2;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ExceptionMotor(e);
        }
        catch (IndexOutOfBoundsException Ioe) {
            throw new ExceptionMotor(Ioe);
        }
        return 0;
    }

    public static boolean validaNombre(int nifCif, String nombre) {
        if (nombre.trim().equals("") || nombre.length() < 3) {
            return false;
        }
        int resul = nifCif >= 20 && nifCif <= 23 ? 2 : 1;
        if (resul == 2) {
            return nombre.charAt(0) != ' ';
        }
        if (!ValidaNif.isAlfa(nombre)) {
            return false;
        }
        for (int res = 0; res < 3; ++res) {
            if (!(res == 2 ? !ValidaNif.isAlfa(nombre.charAt(res)) && nombre.charAt(res) != '\'' : !ValidaNif.isAlfa(nombre.charAt(res)) && nombre.charAt(res) != '\'' || nombre.charAt(res) == ' ')) continue;
            return false;
        }
        for (resul = 1; resul < 3 && nombre.charAt(0) == nombre.charAt(resul); ++resul) {
        }
        if (resul == 3) {
            return false;
        }
        int p = 0;
        if (nombre.charAt(p++) == ' ') {
            return false;
        }
        if (nombre.charAt(p) == ' ' || nombre.charAt(p) == '\u0000') {
            return false;
        }
        ++p;
        while (p < nombre.length() && nombre.charAt(p) != ' ') {
            ++p;
        }
        if (p == nombre.length()) {
            return false;
        }
        return nombre.charAt(++p) != ' ' && nombre.charAt(p) != '\u0000';
    }

    public static boolean isAlfa(char ch) {
        String letras = "ABCDEFGHIJKLMN\u00d1OPQRSTUVWXYZ\u00c7,',-. ";
        return letras.indexOf(ch) != -1;
    }

    public static boolean isAlfa(String cadena) {
        String cad = cadena;
        cad = cad.toUpperCase();
        for (int i = 0; i < cad.length(); ++i) {
            if (ValidaNif.isAlfa(cad.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

