/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.procesadorReglas;

import es.aeat.pftw.mtrc.tipos.DateMotor;
import es.aeat.pftw.mtrc.utilidades.Formatear;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.procesadorReglas.IOperaciones;
import es.aeat.pftw.mtrp.tipos.IDateMotor;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.GregorianCalendar;

public final class OperacionesV2
implements Serializable,
IOperaciones {
    private static final long serialVersionUID = 1L;
    private static IOperaciones singletonOperacionesWrapper = null;

    private OperacionesV2() {
    }

    public static IOperaciones getOperacionesWrapper() {
        if (singletonOperacionesWrapper == null) {
            singletonOperacionesWrapper = new OperacionesV2();
        }
        return singletonOperacionesWrapper;
    }

    @Override
    public Object sumar(Object opIzq, Object opDer, int numDecimales) throws ExceptionMotor {
        try {
            if (opIzq instanceof Integer) {
                return (Integer)opIzq + (Integer)opDer;
            }
            if (opIzq instanceof Long) {
                return (Long)opIzq + (Long)opDer;
            }
            if (opIzq instanceof Double) {
                return new Double(this.realizarSumaDobles((double)((Double)opIzq), (double)((Double)opDer), numDecimales));
            }
            if (opIzq instanceof BigDecimal) {
                return this.realizarSumaBigDecimal((BigDecimal)opIzq, (BigDecimal)opDer, numDecimales);
            }
            if (opIzq instanceof Float) {
                return Float.valueOf(((Float)opIzq).floatValue() + ((Float)opDer).floatValue());
            }
            if (opIzq instanceof String) {
                return (String)opIzq + (String)opDer;
            }
            return null;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public BigDecimal realizarSumaBigDecimal(BigDecimal opIzq, BigDecimal opDer, int numDecimales) throws ExceptionMotor {
        try {
            return opIzq.add(opDer).setScale(numDecimales, 4);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public BigDecimal realizarSumaBigDecimal(BigDecimal opIzq, BigDecimal opDer) throws ExceptionMotor {
        try {
            return opIzq.add(opDer);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public BigDecimal realizarSumaBigDecimal(Object opIzqu, Object opDere) throws ExceptionMotor {
        try {
            BigDecimal opIzq = null;
            BigDecimal opDer = null;
            opIzq = opIzqu instanceof BigDecimal ? (BigDecimal)opIzqu : this.convierteABigDecimal(opIzqu);
            opDer = opDere instanceof BigDecimal ? (BigDecimal)opDere : this.convierteABigDecimal(opDere);
            return this.realizarSumaBigDecimal(opIzq, opDer);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public BigDecimal realizarSumaBigDecimal(Object opIzqu, Object opDere, int numDecimales) throws ExceptionMotor {
        try {
            BigDecimal opIzq = null;
            BigDecimal opDer = null;
            opIzq = opIzqu instanceof BigDecimal ? (BigDecimal)opIzqu : this.convierteABigDecimal(opIzqu);
            opDer = opDere instanceof BigDecimal ? (BigDecimal)opDere : this.convierteABigDecimal(opDere);
            return this.realizarSumaBigDecimal(opIzq, opDer, numDecimales);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    private int getScale(BigDecimal opIzq, BigDecimal opDer) throws ExceptionMotor {
        try {
            int numeroDecimales = 0;
            numeroDecimales = opIzq.scale() >= opDer.scale() ? opIzq.scale() : opDer.scale();
            if (numeroDecimales == 0) {
                numeroDecimales = 2;
            }
            return numeroDecimales;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public int sumar(int opIzq, int opDer) throws ExceptionMotor {
        return opIzq + opDer;
    }

    @Override
    public long sumar(long opIzq, long opDer) throws ExceptionMotor {
        return opIzq + opDer;
    }

    @Override
    public float sumar(float opIzq, float opDer, int numDecimales) throws ExceptionMotor {
        return opIzq + opDer;
    }

    @Override
    public double sumar(double opIzq, double opDer, int numDecimales) throws ExceptionMotor {
        return this.realizarSumaDobles(opIzq, opDer, numDecimales);
    }

    @Override
    public Object restar(Object opIzq, Object opDer, int numDecimales) throws ExceptionMotor {
        try {
            if (opIzq instanceof Integer) {
                return (Integer)opIzq - (Integer)opDer;
            }
            if (opIzq instanceof Long) {
                return (Long)opIzq - (Long)opDer;
            }
            if (opIzq instanceof Double) {
                return new Double(this.realizarRestaDobles((double)((Double)opIzq), (double)((Double)opDer), numDecimales));
            }
            if (opIzq.getClass().toString().toUpperCase().contains("BIGDECIMAL")) {
                return this.realizarRestaBigDecimal((BigDecimal)opIzq, (BigDecimal)opDer, numDecimales);
            }
            if (opIzq instanceof Float) {
                return Float.valueOf(((Float)opIzq).floatValue() - ((Float)opDer).floatValue());
            }
            return null;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public int restar(int opIzq, int opDer) throws ExceptionMotor {
        return opIzq - opDer;
    }

    @Override
    public long restar(long opIzq, long opDer) throws ExceptionMotor {
        return opIzq - opDer;
    }

    @Override
    public double restar(double opIzq, double opDer, int numDecimales) throws ExceptionMotor {
        return this.realizarRestaDobles(opIzq, opDer, numDecimales);
    }

    @Override
    public float restar(float opIzq, float opDer) throws ExceptionMotor {
        return opIzq - opDer;
    }

    @Override
    public Object multiplicar(Object opIzq, Object opDer, int numDecimales) throws ExceptionMotor {
        try {
            if (opIzq instanceof Integer) {
                return (Integer)opIzq * (Integer)opDer;
            }
            if (opIzq instanceof Long) {
                return (Long)opIzq * (Long)opDer;
            }
            if (opIzq instanceof Double) {
                return new Double(this.realizarMultiplicacionDobles((double)((Double)opIzq), (double)((Double)opDer), numDecimales));
            }
            if (opIzq.getClass().toString().toUpperCase().contains("BIGDECIMAL")) {
                return this.realizarMultiplicacionBigDecimal((BigDecimal)opIzq, (BigDecimal)opDer, numDecimales);
            }
            if (opIzq instanceof Float) {
                return Float.valueOf(((Float)opIzq).floatValue() * ((Float)opDer).floatValue());
            }
            return null;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public BigDecimal realizarMultiplicacionBigDecimal(BigDecimal opIzqBigDec, BigDecimal opDerBigDec, int numDecimales) throws ExceptionMotor {
        try {
            return opIzqBigDec.multiply(opDerBigDec).setScale(numDecimales, 4);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public BigDecimal realizarMultiplicacionBigDecimal(BigDecimal opIzqBigDec, BigDecimal opDerBigDec) throws ExceptionMotor {
        try {
            return opIzqBigDec.multiply(opDerBigDec);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public BigDecimal realizarMultiplicacionBigDecimal(Object opIzqu, Object opDere) throws ExceptionMotor {
        try {
            BigDecimal opIzq = null;
            BigDecimal opDer = null;
            opIzq = opIzqu instanceof BigDecimal ? (BigDecimal)opIzqu : this.convierteABigDecimal(opIzqu);
            opDer = opDere instanceof BigDecimal ? (BigDecimal)opDere : this.convierteABigDecimal(opDere);
            return this.realizarMultiplicacionBigDecimal(opIzq, opDer);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public BigDecimal realizarMultiplicacionBigDecimal(Object opIzqu, Object opDere, int numDecimales) throws ExceptionMotor {
        try {
            BigDecimal opIzq = null;
            BigDecimal opDer = null;
            opIzq = opIzqu instanceof BigDecimal ? (BigDecimal)opIzqu : this.convierteABigDecimal(opIzqu);
            opDer = opDere instanceof BigDecimal ? (BigDecimal)opDere : this.convierteABigDecimal(opDere);
            return this.realizarMultiplicacionBigDecimal(opIzq, opDer, numDecimales);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public int multiplicar(int opIzq, int opDer) throws ExceptionMotor {
        return opIzq * opDer;
    }

    @Override
    public long multiplicar(long opIzq, long opDer) throws ExceptionMotor {
        return opIzq * opDer;
    }

    @Override
    public double multiplicar(double opIzq, double opDer, int numDecimales) throws ExceptionMotor {
        return this.realizarMultiplicacionDobles(opIzq, opDer, numDecimales);
    }

    @Override
    public float multiplicar(float opIzq, float opDer) throws ExceptionMotor {
        return opIzq * opDer;
    }

    @Override
    public Object dividir(Object opIzq, Object opDer, int numDecimales) throws ExceptionMotor {
        try {
            if (opIzq instanceof Integer) {
                if ((Integer)opDer == 0) {
                    return 0;
                }
                return (Integer)opIzq / (Integer)opDer;
            }
            if (opIzq instanceof Long) {
                if ((Long)opDer == 0L) {
                    return 0L;
                }
                return (Long)opIzq / (Long)opDer;
            }
            if (opIzq instanceof Double) {
                if ((Double)opDer == 0.0) {
                    return 0.0;
                }
                return this.realizarDivisionDobles((double)((Double)opIzq), (double)((Double)opDer), numDecimales);
            }
            if (opIzq.getClass().toString().toUpperCase().contains("BIGDECIMAL")) {
                if (this.convierteABigDecimal(opDer).doubleValue() == 0.0) {
                    return BigDecimal.ZERO;
                }
                return this.realizarDivisionBigDecimal((BigDecimal)opIzq, (BigDecimal)opDer, numDecimales);
            }
            if (opIzq instanceof Float) {
                if (((Float)opDer).floatValue() == 0.0f) {
                    return Float.valueOf(0.0f);
                }
                return Float.valueOf(((Float)opIzq).floatValue() / ((Float)opDer).floatValue());
            }
            return null;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public int dividir(int opIzq, int opDer) throws ExceptionMotor {
        try {
            if (opDer != 0) {
                return opIzq / opDer;
            }
            return 0;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public long dividir(long opIzq, long opDer) throws ExceptionMotor {
        try {
            if (opDer != 0L) {
                return opIzq / opDer;
            }
            return 0L;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public float dividir(float opIzq, float opDer) throws ExceptionMotor {
        try {
            if (opDer != 0.0f) {
                return opIzq / opDer;
            }
            return 0.0f;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public double dividir(double opIzq, double opDer, int numDecimales) throws ExceptionMotor {
        try {
            if (opDer != 0.0) {
                return this.realizarDivisionDobles(opIzq, opDer, numDecimales);
            }
            return 0.0;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Double realizarSumaDobles(Double opIzq, Double opDer) throws ExceptionMotor {
        return this.realizarSumaDobles((double)opIzq, (double)opDer);
    }

    @Override
    public Double realizarSumaDobles(Double opIzq, Double opDer, int numDecimales) throws ExceptionMotor {
        return this.realizarSumaDobles((double)opIzq, (double)opDer, numDecimales);
    }

    @Override
    public double realizarSumaDobles(double opIzq, double opDer, int numDecimales) throws ExceptionMotor {
        try {
            BigDecimal opIzqBigDec = new BigDecimal(String.valueOf(opIzq).trim());
            BigDecimal opDerBigDec = new BigDecimal(String.valueOf(opDer).trim());
            BigDecimal resultado = opIzqBigDec.add(opDerBigDec).setScale(numDecimales, 4);
            return Formatear.getFormatear().formatoDoble(resultado.doubleValue(), numDecimales);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public double realizarSumaDobles(double opIzq, double opDer) throws ExceptionMotor {
        try {
            BigDecimal opIzqBigDec = new BigDecimal(String.valueOf(opIzq).trim());
            BigDecimal opDerBigDec = new BigDecimal(String.valueOf(opDer).trim());
            BigDecimal resultado = opIzqBigDec.add(opDerBigDec);
            return resultado.doubleValue();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Double realizarRestaDobles(Double opIzq, Double opDer) throws ExceptionMotor {
        return this.realizarRestaDobles((double)opIzq, (double)opDer);
    }

    @Override
    public Double realizarRestaDobles(Double opIzq, Double opDer, int numDecimales) throws ExceptionMotor {
        return this.realizarRestaDobles((double)opIzq, (double)opDer, numDecimales);
    }

    @Override
    public double realizarRestaDobles(double opIzq, double opDer, int numDecimales) throws ExceptionMotor {
        try {
            BigDecimal opIzqBigDec = new BigDecimal(String.valueOf(opIzq).trim());
            BigDecimal opDerBigDec = new BigDecimal(String.valueOf(opDer).trim());
            BigDecimal resultado = opIzqBigDec.subtract(opDerBigDec).setScale(numDecimales, 4);
            return Formatear.getFormatear().formatoDoble(resultado.doubleValue(), numDecimales);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public double realizarRestaDobles(double opIzq, double opDer) throws ExceptionMotor {
        try {
            BigDecimal opIzqBigDec = new BigDecimal(String.valueOf(opIzq).trim());
            BigDecimal opDerBigDec = new BigDecimal(String.valueOf(opDer).trim());
            BigDecimal resultado = opIzqBigDec.subtract(opDerBigDec);
            return resultado.doubleValue();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public BigDecimal realizarRestaBigDecimal(BigDecimal opIzq, BigDecimal opDer, int numDecimales) throws ExceptionMotor {
        try {
            return opIzq.subtract(opDer).setScale(numDecimales, 4);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public BigDecimal realizarRestaBigDecimal(BigDecimal opIzq, BigDecimal opDer) throws ExceptionMotor {
        try {
            return opIzq.subtract(opDer);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public BigDecimal realizarRestaBigDecimal(Object opIzqu, Object opDere) throws ExceptionMotor {
        try {
            BigDecimal opIzq = null;
            BigDecimal opDer = null;
            opIzq = opIzqu instanceof BigDecimal ? (BigDecimal)opIzqu : this.convierteABigDecimal(opIzqu);
            opDer = opDere instanceof BigDecimal ? (BigDecimal)opDere : this.convierteABigDecimal(opDere);
            return this.realizarRestaBigDecimal(opIzq, opDer);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public BigDecimal realizarRestaBigDecimal(Object opIzqu, Object opDere, int numDecimales) throws ExceptionMotor {
        try {
            BigDecimal opIzq = null;
            BigDecimal opDer = null;
            opIzq = opIzqu instanceof BigDecimal ? (BigDecimal)opIzqu : this.convierteABigDecimal(opIzqu);
            opDer = opDere instanceof BigDecimal ? (BigDecimal)opDere : this.convierteABigDecimal(opDere);
            return this.realizarRestaBigDecimal(opIzq, opDer, numDecimales);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Double realizarMultiplicacionDobles(Double opIzq, Double opDer) throws ExceptionMotor {
        return this.realizarMultiplicacionDobles((double)opIzq, (double)opDer);
    }

    @Override
    public Double realizarMultiplicacionDobles(Double opIzq, Double opDer, int numDecimales) throws ExceptionMotor {
        return this.realizarMultiplicacionDobles((double)opIzq, (double)opDer, numDecimales);
    }

    @Override
    public double realizarMultiplicacionDobles(double opIzq, double opDer, int numDecimales) throws ExceptionMotor {
        try {
            BigDecimal opIzqBigDec = new BigDecimal(String.valueOf(opIzq).trim());
            BigDecimal opDerBigDec = new BigDecimal(String.valueOf(opDer).trim());
            BigDecimal resultado = opIzqBigDec.multiply(opDerBigDec).setScale(numDecimales, 4);
            return Formatear.getFormatear().formatoDoble(resultado.doubleValue(), numDecimales);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public double realizarMultiplicacionDobles(double opIzq, double opDer) throws ExceptionMotor {
        try {
            BigDecimal opIzqBigDec = new BigDecimal(String.valueOf(opIzq).trim());
            BigDecimal opDerBigDec = new BigDecimal(String.valueOf(opDer).trim());
            BigDecimal resultado = opIzqBigDec.multiply(opDerBigDec);
            return resultado.doubleValue();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Double realizarDivisionDobles(Double opIzq, Double opDer) throws ExceptionMotor {
        return this.realizarDivisionDobles((double)opIzq, (double)opDer);
    }

    @Override
    public Double realizarDivisionDobles(Double opIzq, Double opDer, int numDecimales) throws ExceptionMotor {
        return this.realizarDivisionDobles((double)opIzq, (double)opDer, numDecimales);
    }

    @Override
    public double realizarDivisionDobles(double opIzq, double opDer, int numDecimales) throws ExceptionMotor {
        try {
            BigDecimal opIzqBigDec = new BigDecimal(String.valueOf(opIzq).trim());
            BigDecimal opDerBigDec = new BigDecimal(String.valueOf(opDer).trim());
            BigDecimal resultado = opIzqBigDec.divide(opDerBigDec, numDecimales, 4);
            return Formatear.getFormatear().formatoDoble(resultado.doubleValue(), numDecimales);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public double realizarDivisionDobles(double opIzq, double opDer) throws ExceptionMotor {
        try {
            BigDecimal opIzqBigDec = new BigDecimal(String.valueOf(opIzq).trim());
            BigDecimal opDerBigDec = new BigDecimal(String.valueOf(opDer).trim());
            BigDecimal resultado = opIzqBigDec.divide(opDerBigDec, 20, 4);
            return resultado.doubleValue();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public BigDecimal realizarDivisionBigDecimal(BigDecimal opIzq, BigDecimal opDer, int numDecimales) throws ExceptionMotor {
        try {
            return opIzq.divide(opDer, numDecimales, 4);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public BigDecimal realizarDivisionBigDecimal(BigDecimal opIzq, BigDecimal opDer) throws ExceptionMotor {
        BigDecimal bd = null;
        try {
            bd = opIzq.divide(opDer);
            return bd;
        }
        catch (ArithmeticException e) {
            return this.realizarDivisionBigDecimal(opIzq, opDer, 8);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public BigDecimal realizarDivisionBigDecimal(Object opIzqu, Object opDere) throws ExceptionMotor {
        try {
            BigDecimal opIzq = null;
            BigDecimal opDer = null;
            opIzq = opIzqu instanceof BigDecimal ? (BigDecimal)opIzqu : this.convierteABigDecimal(opIzqu);
            opDer = opDere instanceof BigDecimal ? (BigDecimal)opDere : this.convierteABigDecimal(opDere);
            return this.realizarDivisionBigDecimal(opIzq, opDer);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public BigDecimal realizarDivisionBigDecimal(Object opIzqu, Object opDere, int numDecimales) throws ExceptionMotor {
        try {
            BigDecimal opIzq = null;
            BigDecimal opDer = null;
            opIzq = opIzqu instanceof BigDecimal ? (BigDecimal)opIzqu : this.convierteABigDecimal(opIzqu);
            opDer = opDere instanceof BigDecimal ? (BigDecimal)opDere : this.convierteABigDecimal(opDere);
            return this.realizarDivisionBigDecimal(opIzq, opDer, numDecimales);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Object evaluarOperacion(int vOpIzq, Object vOpDer, String sOperador, int numDecimales) throws ExceptionMotor {
        try {
            if (this.esEntero(vOpDer)) {
                return this.evaluarOperacion((double)vOpIzq, (double)Integer.valueOf(vOpDer.toString()).intValue(), sOperador, numDecimales);
            }
            return this.evaluarOperacion((Object)vOpIzq, vOpDer, sOperador, numDecimales);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Object evaluarOperacion(Object vOpIzq, int vOpDer, String sOperador, int numDecimales) throws ExceptionMotor {
        try {
            if (this.esEntero(vOpIzq)) {
                return this.evaluarOperacion((double)Integer.valueOf(vOpIzq.toString()).intValue(), (double)vOpDer, sOperador, numDecimales);
            }
            return this.evaluarOperacion(vOpIzq, (Object)vOpDer, sOperador, numDecimales);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Object evaluarOperacion(int vOpIzq, int vOpDer, String sOperador) throws ExceptionMotor {
        Boolean resultado = Boolean.FALSE;
        try {
            switch (sOperador.toCharArray()[0]) {
                case 'L': {
                    return vOpIzq < vOpDer;
                }
                case 'G': {
                    return vOpIzq > vOpDer;
                }
                case '=': {
                    return vOpIzq == vOpDer;
                }
                case '!': {
                    return vOpIzq != vOpDer;
                }
                case 'H': {
                    return vOpIzq >= vOpDer;
                }
                case 'M': {
                    return vOpIzq <= vOpDer;
                }
                case 'N': {
                    break;
                }
            }
            return resultado;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Object evaluarOperacion(double vOpIzq, double vOpDer, String sOperador, int numDecimales) throws ExceptionMotor {
        BigDecimal bdOpIzq = new BigDecimal(vOpIzq).setScale(numDecimales, 4);
        BigDecimal bdOpDer = new BigDecimal(vOpDer).setScale(numDecimales, 4);
        try {
            switch (sOperador.toCharArray()[0]) {
                case 'L': {
                    return bdOpIzq.compareTo(bdOpDer) < 0;
                }
                case 'G': {
                    return bdOpIzq.compareTo(bdOpDer) > 0;
                }
                case '=': {
                    return bdOpIzq.compareTo(bdOpDer) == 0;
                }
                case '!': {
                    return bdOpIzq.compareTo(bdOpDer) != 0;
                }
                case 'H': {
                    return bdOpIzq.compareTo(bdOpDer) >= 0;
                }
                case 'M': {
                    return bdOpIzq.compareTo(bdOpDer) <= 0;
                }
                case 'N': {
                    break;
                }
            }
            return Boolean.FALSE;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Object evaluarOperacion(IDateMotor vOpIzq, String vOpDer, String sOperador) throws ExceptionMotor {
        return this.evaluarOperacion(vOpIzq, (IDateMotor)new DateMotor(vOpDer), sOperador);
    }

    @Override
    public Object evaluarOperacion(String vOpIzq, IDateMotor vOpDer, String sOperador) throws ExceptionMotor {
        return this.evaluarOperacion((IDateMotor)new DateMotor(vOpIzq), vOpDer, sOperador);
    }

    public Object evaluarOperacionDates(IDateMotor vOpIzq, IDateMotor vOpDer, String sOperador) throws ExceptionMotor {
        try {
            boolean hayNulos;
            GregorianCalendar izq = new GregorianCalendar();
            GregorianCalendar der = new GregorianCalendar();
            izq.setLenient(false);
            der.setLenient(false);
            boolean bl = hayNulos = vOpDer.getDate() == null || vOpIzq.getDate() == null;
            if (!hayNulos) {
                izq.setTime(vOpIzq.getDate());
                der.setTime(vOpDer.getDate());
            }
            switch (sOperador.toCharArray()[0]) {
                case 'L': {
                    if (hayNulos) {
                        throw new Exception("Falta por especificar alguna fecha!!!");
                    }
                    return izq.before(der) && !((Calendar)izq).equals(der);
                }
                case 'G': {
                    if (hayNulos) {
                        throw new Exception("Falta por especificar alguna fecha!!!");
                    }
                    return izq.after(der) && !((Calendar)izq).equals(der);
                }
                case '=': {
                    if (hayNulos) {
                        return vOpDer.getDate() == null && vOpIzq.getDate() == null && vOpDer.getFechaOriginal().equalsIgnoreCase(vOpIzq.getFechaOriginal());
                    }
                    return ((Calendar)izq).equals(der);
                }
                case '!': {
                    return (Boolean)this.evaluarOperacion(vOpDer, vOpIzq, "=") == false;
                }
                case 'H': {
                    if (hayNulos) {
                        throw new Exception("Falta por especificar alguna fecha!!!");
                    }
                    return izq.after(der) || ((Calendar)izq).equals(der);
                }
                case 'M': {
                    if (hayNulos) {
                        throw new Exception("Falta por especificar alguna fecha!!!");
                    }
                    return izq.before(der) || ((Calendar)izq).equals(der);
                }
                case 'N': {
                    throw new ExceptionMotor("No tiene sentido el negativo en las fechas");
                }
            }
            throw new ExceptionMotor("Operador " + sOperador.toCharArray()[0] + " no esperado!!!");
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Object evaluarOperacion(IDateMotor vOpIzq, IDateMotor vOpDer, String sOperador) throws ExceptionMotor {
        return this.evaluarOperacionDates(vOpIzq, vOpDer, sOperador);
    }

    @Override
    public Object evaluarOperacion(BigDecimal vOpIzq, BigDecimal vOpDer, String sOperador) throws ExceptionMotor {
        return this.evaluarOperacion(vOpIzq, vOpDer, sOperador, this.getScale(vOpIzq, vOpDer));
    }

    @Override
    public Object evaluarOperacion(BigDecimal vOpIzq, BigDecimal vOpDer, String sOperador, int numDecimales) throws ExceptionMotor {
        BigDecimal bdOpIzq = new BigDecimal(vOpIzq.toString().trim()).setScale(numDecimales, 4);
        BigDecimal bdOpDer = new BigDecimal(vOpDer.toString().trim()).setScale(numDecimales, 4);
        try {
            switch (sOperador.toCharArray()[0]) {
                case 'L': {
                    return bdOpIzq.compareTo(bdOpDer) < 0;
                }
                case 'G': {
                    return bdOpIzq.compareTo(bdOpDer) > 0;
                }
                case '=': {
                    return bdOpIzq.compareTo(bdOpDer) == 0;
                }
                case '!': {
                    return bdOpIzq.compareTo(bdOpDer) != 0;
                }
                case 'H': {
                    return bdOpIzq.compareTo(bdOpDer) >= 0;
                }
                case 'M': {
                    return bdOpIzq.compareTo(bdOpDer) <= 0;
                }
                case 'N': {
                    break;
                }
            }
            return Boolean.FALSE;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Object evaluarOperacion(String vOpIzq, String vOpDer, String sOperador) throws ExceptionMotor {
        try {
            switch (sOperador.toCharArray()[0]) {
                case '=': {
                    return vOpIzq.equalsIgnoreCase(vOpDer);
                }
                case '!': {
                    return !vOpIzq.equalsIgnoreCase(vOpDer);
                }
                case 'H': {
                    return vOpIzq.compareToIgnoreCase(vOpDer) >= 0;
                }
                case 'G': {
                    return vOpIzq.compareToIgnoreCase(vOpDer) > 0;
                }
                case 'M': {
                    return vOpIzq.compareToIgnoreCase(vOpDer) <= 0;
                }
                case 'L': {
                    return vOpIzq.compareToIgnoreCase(vOpDer) < 0;
                }
            }
            return Boolean.FALSE;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Object evaluarOperacion(boolean vOpIzq, boolean vOpDer, String sOperador) throws ExceptionMotor {
        try {
            switch (sOperador.toCharArray()[0]) {
                case '=': {
                    return vOpIzq == vOpDer;
                }
                case '!': {
                    return vOpIzq != vOpDer;
                }
                case 'Y': {
                    return vOpIzq && vOpDer;
                }
                case 'O': {
                    return vOpIzq || vOpDer;
                }
            }
            return Boolean.FALSE;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public String operadoresComparables(Object opIzq, Object opDer) throws ExceptionMotor {
        try {
            if (opIzq.getClass().toString().equalsIgnoreCase(opDer.getClass().toString())) {
                return opIzq.getClass().toString();
            }
            if (this.operadorNumerico(opIzq) && this.operadorNumerico(opDer)) {
                if (opIzq.getClass().toString().toUpperCase().contains("BIGDECIMAL") || opDer.getClass().toString().toUpperCase().contains("BIGDECIMAL")) {
                    return BigDecimal.class.toString();
                }
                if (opIzq instanceof Double || opDer instanceof Double) {
                    return Double.class.toString();
                }
                if (opIzq instanceof Float || opDer instanceof Float) {
                    return Float.class.toString();
                }
                if (opIzq instanceof Integer || opDer instanceof Integer) {
                    return Integer.class.toString();
                }
                return BigDecimal.class.toString();
            }
            return "";
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean operadorNumerico(Object operador) throws ExceptionMotor {
        try {
            boolean ret;
            boolean bl = ret = operador instanceof Integer || operador instanceof Double || operador instanceof Long || operador instanceof Float || operador.getClass().toString().toUpperCase().contains("BIGDECIMAL");
            if (!ret) {
                return FuncionesUtiles.getFuncionesUtiles().esNumerico(operador.toString());
            }
            return ret;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Object evaluarOperacion(Object vOpIzq, Object vOpDer, String sOperador) throws ExceptionMotor {
        return this.evaluarOperacion(vOpIzq, vOpDer, sOperador, -1);
    }

    @Override
    public Object evaluarOperacion(Object vOpIzq, double vOpDer, String sOperador) throws ExceptionMotor {
        return this.evaluarOperacion(vOpIzq, (Object)new Double(vOpDer), sOperador, -1);
    }

    @Override
    public Object evaluarOperacion(Object vOpIzq, double vOpDer, String sOperador, int numDecimales) throws ExceptionMotor {
        return this.evaluarOperacion(vOpIzq, (Object)new Double(vOpDer), sOperador, numDecimales);
    }

    @Override
    public Object evaluarOperacion(double vOpIzq, Object vOpDer, String sOperador) throws ExceptionMotor {
        return this.evaluarOperacion((Object)new Double(vOpIzq), vOpDer, sOperador, -1);
    }

    @Override
    public Object evaluarOperacion(double vOpIzq, Object vOpDer, String sOperador, int numDecimales) throws ExceptionMotor {
        return this.evaluarOperacion((Object)new Double(vOpIzq), vOpDer, sOperador, numDecimales);
    }

    @Override
    public Object evaluarOperacion(Object vOpIzq, Object vOpDer, String sOperador, int numDecimals) throws ExceptionMotor {
        try {
            int numDecimales = numDecimals;
            String tipo = this.operadoresComparables(vOpDer, vOpIzq);
            if (tipo.length() > 0) {
                if (tipo.toString().toUpperCase().contains("BIGDECIMAL")) {
                    if (numDecimales == -1) {
                        return this.evaluarOperacion(new BigDecimal(vOpIzq.toString().trim()), new BigDecimal(vOpDer.toString().trim()), sOperador);
                    }
                    return this.evaluarOperacion(new BigDecimal(vOpIzq.toString().trim()), new BigDecimal(vOpDer.toString().trim()), sOperador, numDecimales);
                }
                if (tipo.equals(Double.class.toString())) {
                    if (numDecimales == -1) {
                        numDecimales = 2;
                    }
                    return this.evaluarOperacion((double)Double.valueOf(vOpIzq.toString()), (double)Double.valueOf(vOpDer.toString()), sOperador, numDecimales);
                }
                if (tipo.equals(Boolean.class.toString())) {
                    return this.evaluarOperacion(Boolean.valueOf(vOpIzq.toString()), Boolean.valueOf(vOpDer.toString()), sOperador);
                }
                if (tipo.equals(String.class.toString())) {
                    return this.evaluarOperacion(vOpIzq.toString(), vOpDer.toString(), sOperador);
                }
                if (tipo.equals(Integer.class.toString())) {
                    if (numDecimales == -1) {
                        numDecimales = 2;
                    }
                    return this.evaluarOperacion((double)((Integer)vOpIzq).intValue(), (double)((Integer)vOpDer).intValue(), sOperador, numDecimales);
                }
                if (tipo.equals(DateMotor.class.toString())) {
                    return this.evaluarOperacionDates((IDateMotor)vOpIzq, (IDateMotor)vOpDer, sOperador);
                }
                throw new ExceptionMotor("No se que tipo es");
            }
            switch (sOperador.toCharArray()[0]) {
                case '=': {
                    return vOpIzq.toString().compareTo(vOpDer.toString()) == 0;
                }
            }
            return Boolean.FALSE;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    private boolean esEntero(Object param) throws ExceptionMotor {
        try {
            if (param.getClass().toString().toUpperCase().contains("BIGDECIMAL") || param instanceof Double) {
                return false;
            }
            return param.toString().indexOf(46) == -1;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    private BigDecimal convierteABigDecimal(Object op) throws ExceptionMotor {
        try {
            return new BigDecimal(op.toString().trim());
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }
}

