/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.procesadorReglas;

import es.aeat.pftw.mtrc.motor.IMotor;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesionExtendida;
import es.aeat.pftw.mtrc.motor.modelo.sesion.tools.IGestionReglasExtendida;
import es.aeat.pftw.mtrc.procesadorReglas.Comprobaciones;
import es.aeat.pftw.mtrc.procesadorReglas.IFunciones;
import es.aeat.pftw.mtrc.procesadorReglas.IGestionReglas;
import es.aeat.pftw.mtrc.puente.ITablaMotor;
import es.aeat.pftw.mtrc.tipos.TipoDatoRetornoMetodo;
import es.aeat.pftw.mtrc.tipos.TipoValidacionReglas;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtilesExportacion;
import es.aeat.pftw.mtrc.utilidades.ValidacionesGUIExtra;
import es.aeat.pftw.mtrp.configuracion.IRegEntrada;
import es.aeat.pftw.mtrp.configuracion.IRegError;
import es.aeat.pftw.mtrp.configuracion.IRegRegla;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.tipos.ITipoDatoRetornoMetodo;
import es.aeat.pftw.mtrp.tipos.ITipoDatoRetornoProceso;
import es.aeat.pftw.mtrp.tipos.ITipoNotificacion;
import es.aeat.pftw.mtrp.utilidades.INodoArbol;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GestionReglas
implements IGestionReglas {
    private static final long serialVersionUID = 1L;
    private transient IMotor motor = null;

    @Override
    public void dispose() {
        this.motor = null;
    }

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            this.motor = (IMotor)parametros[0];
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean partidaModificada(ISesion sesion, String sNombre, Object vValor) throws ExceptionMotor {
        return this.partidaModificada(sesion, sNombre, vValor, null);
    }

    @Override
    public boolean partidaModificada(ISesion sesion, String sNombre, Object vValor, Map<String, String> propCampo) throws ExceptionMotor {
        if (!sesion.isEnabled()) {
            return true;
        }
        try {
            if (((ISesionExtendida)sesion).isEjecutandoBatchAnniadirRegistro()) {
                throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras existan comandos batch_A\u00f1adirRegistro(...) pendientes", Thread.currentThread().getStackTrace());
            }
            if (sesion.getGestionReglas().isEmpezandoPartidaModificadaDesdeImportacion()) {
                sesion.getGestionReglas().setEmpezandoPartidaModificadaDesdeImportacion(false);
                ITablaMotor tAux = ((ISesionExtendida)sesion).obtenerNodoPartida(sNombre);
                if (tAux != null && tAux.getClaveActiva() != 0L && sesion.getOperaciones().obtenerEstadoPartida(sNombre) == 254) {
                    IRegEntrada ent = sesion.getModelo().getGestorConfiguracion().getEntrada(sNombre);
                    if (!FuncionesUtiles.getFuncionesUtiles().sonIguales(ent.esTipoNumerico(), sesion.getOperaciones().obtenerPartidaString(sNombre), vValor.toString())) {
                        if (propCampo != null) {
                            if (propCampo.containsKey("ERRCALCULADO")) {
                                if (this.getDiscriminante(sesion).contains("P")) {
                                    propCampo.put("CAMPOMOTOR", sNombre);
                                    sesion.getGestionReglas().ejecutarFuncion(sesion, "error", new Object[]{propCampo.get("ERRCALCULADO"), "E", propCampo});
                                }
                                return false;
                            }
                            propCampo.put("CAMPOMOTOR", sNombre);
                            sesion.getGestionReglas().ejecutarFuncion(sesion, "error", new Object[]{"IMPROCEDENTE", "E", propCampo});
                        } else {
                            sesion.getGestionReglas().ejecutarFuncion(sesion, "error", new Object[]{"IMPROCEDENTE", "E", sNombre});
                        }
                        return false;
                    }
                }
            }
            return this.partidaModificadaOestablecerDatosExportacionPartida(sesion, sNombre, vValor, "partidaModificada", false, false, null);
        }
        catch (Exception ex) {
            String str = "Nombre " + sNombre;
            try {
                str = str + " valor " + vValor;
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ex instanceof ExceptionMotor) {
                ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + str);
                throw (ExceptionMotor)ex;
            }
            throw new ExceptionMotor(ex, str);
        }
    }

    protected boolean prePartidaModificadaValidarEntradaDeDatos(ISesion sesion, String sNombre, Object vValor) throws ExceptionMotor {
        try {
            IRegEntrada ent;
            int ret = 0;
            if (vValor != null && (ent = sesion.getModelo().getGestorConfiguracion().getEntrada(sNombre)) != null) {
                if (ent.getTipoDato().equalsIgnoreCase("ALFABETICO")) {
                    int longitudMaxima = ent.getTamannioCampo();
                    if (longitudMaxima == 0) {
                        longitudMaxima = Integer.MAX_VALUE;
                    }
                    ret = ValidacionesGUIExtra.getValidaciones().validarCampoAlfabetico(vValor.toString(), longitudMaxima);
                } else if (ent.getTipoDato().equalsIgnoreCase("CADENA")) {
                    int longitudMaxima = ent.getTamannioCampo();
                    if (longitudMaxima == 0) {
                        longitudMaxima = Integer.MAX_VALUE;
                    }
                    ret = ValidacionesGUIExtra.getValidaciones().validarCampoAlfanum\u00e9rico(vValor.toString(), longitudMaxima);
                } else if (ent.getTipoDato().equalsIgnoreCase("TEL")) {
                    int longitudMaxima = ent.getTamannioCampo();
                    if (longitudMaxima == 0) {
                        longitudMaxima = Integer.MAX_VALUE;
                    }
                    ret = ValidacionesGUIExtra.getValidaciones().validarCampoTelefonoEuropeo(vValor.toString(), longitudMaxima);
                } else if (ent.getTipoDato().equalsIgnoreCase("CADENA_NUMERICA")) {
                    int longitudMaxima = ent.getTamannioCampo();
                    if (longitudMaxima == 0) {
                        longitudMaxima = Integer.MAX_VALUE;
                    }
                    ret = ValidacionesGUIExtra.getValidaciones().validarCampoCadNum(vValor.toString(), longitudMaxima);
                } else if (ent.getTipoDato().equalsIgnoreCase("CADENA_NUMERICA_2")) {
                    int longitudMaxima = ent.getTamannioCampo();
                    if (longitudMaxima == 0) {
                        longitudMaxima = Integer.MAX_VALUE;
                    }
                    ret = ValidacionesGUIExtra.getValidaciones().validarCampoCadNum2(vValor.toString(), longitudMaxima);
                } else if (ent.getTipoDato().equalsIgnoreCase("EMAIL")) {
                    int longitudMaxima = ent.getTamannioCampo();
                    if (longitudMaxima == 0) {
                        longitudMaxima = Integer.MAX_VALUE;
                    }
                    ret = ValidacionesGUIExtra.getValidaciones().validarCampoEmail(vValor.toString(), longitudMaxima);
                } else if (ent.getTipoDato().equalsIgnoreCase("LOGICO")) {
                    ret = ValidacionesGUIExtra.getValidaciones().validarCampoLogico(vValor.toString());
                } else if (ent.getTipoDato().equalsIgnoreCase("ENTERO")) {
                    int longitudMaxima = 0;
                    try {
                        longitudMaxima = Integer.valueOf(ent.getPropiedad("NUMEROENTEROS"));
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (longitudMaxima == 0) {
                        longitudMaxima = Integer.MAX_VALUE;
                    }
                    ret = ValidacionesGUIExtra.getValidaciones().validarCampoEntero(vValor.toString(), longitudMaxima);
                } else if (ent.getTipoDato().equalsIgnoreCase("FECHA")) {
                    ret = ValidacionesGUIExtra.getValidaciones().validarCampoFecha(vValor.toString());
                } else if (ent.getTipoDato().equalsIgnoreCase("DOBLE")) {
                    int enteros = 0;
                    int decimales = 0;
                    try {
                        decimales = ent.getNumDecimales();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    try {
                        try {
                            enteros = Integer.valueOf(ent.getPropiedad("NUMEROENTEROS"));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        if (enteros == 0) {
                            enteros = ent.getTamannioCampo() + decimales;
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    ret = ValidacionesGUIExtra.getValidaciones().validarCampoDoble(vValor.toString(), enteros, decimales);
                } else if (ent.getTipoDato().equalsIgnoreCase("BIGDECIMAL")) {
                    int enteros = 0;
                    int decimales = 0;
                    try {
                        decimales = ent.getNumDecimales();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    try {
                        enteros = Integer.valueOf(ent.getPropiedad("NUMEROENTEROS"));
                    }
                    catch (Exception ex) {
                        try {
                            enteros = ent.getTamannioCampo() - decimales;
                        }
                        catch (Exception exx) {
                            // empty catch block
                        }
                    }
                    ret = ValidacionesGUIExtra.getValidaciones().validarCampoDoble(vValor.toString(), enteros, decimales);
                } else {
                    FuncionesUtiles.getFuncionesUtiles().muestraAviso("Tipo de dato " + ent.getTipoDato() + " no esperado en prePartidaModificada!!!");
                }
            }
            switch (ret) {
                case 1: {
                    sesion.getGestionReglas().ejecutarFuncion(sesion, "error", new Object[]{"CHRNV"});
                    return false;
                }
                case 2: {
                    sesion.getGestionReglas().ejecutarFuncion(sesion, "error", new Object[]{"LNGINC"});
                    return false;
                }
            }
            return true;
        }
        catch (Exception ex) {
            if (ex instanceof ExceptionMotor) {
                throw (ExceptionMotor)ex;
            }
            throw new ExceptionMotor(ex);
        }
    }

    protected boolean partidaModificadaOestablecerDatosExportacionPartida(ISesion sesion, String sNombre, Object vValor, String nombreFuncion, boolean estado, boolean forceToExecute, Map<String, String> propCampo) throws ExceptionMotor {
        if (sesion.isComprobarCaracteresEnPartidaModificada() && !this.prePartidaModificadaValidarEntradaDeDatos(sesion, sNombre, vValor)) {
            return false;
        }
        boolean enTransaccion = false;
        boolean enTran = ((ISesionExtendida)sesion).inTrans();
        try {
            boolean esPartidaModificada = nombreFuncion.equalsIgnoreCase("PartidaModificada");
            boolean resultado = false;
            boolean bSonIguales = false;
            String valorAnterior = "";
            valorAnterior = sesion.getOperaciones().obtenerPartidaString(sNombre, propCampo);
            if (!enTran && ((ISesionExtendida)sesion).getListaPartidasAfectadasPorPartidaModificada() != null && ((ISesionExtendida)sesion).getListaPartidasAfectadasPorPartidaModificada().getLista() != null && ((ISesionExtendida)sesion).getListaPartidasAfectadasPorPartidaModificada().getLista().size() > 0) {
                ((ISesionExtendida)sesion).getListaPartidasAfectadasPorPartidaModificada().getLista().clear();
            }
            if (valorAnterior != null) {
                if (forceToExecute) {
                    vValor = valorAnterior;
                    bSonIguales = false;
                } else {
                    bSonIguales = FuncionesUtiles.getFuncionesUtiles().sonIguales(sesion.getModelo().getGestorConfiguracion().getEntrada(sNombre).esTipoNumerico(), valorAnterior, vValor);
                }
                resultado = bSonIguales;
                if (!bSonIguales) {
                    if (!this.isAlmacenarErrorLista(sesion) && !enTran) {
                        ((IGestionReglasExtendida)sesion.getGestionReglas()).listaErroresEnReglasClear();
                    }
                    this.setPartidaProcesando(sesion, sNombre);
                    if (vValor != null) {
                        if (!enTran) {
                            ((ISesionExtendida)sesion).beginTrans();
                        }
                        enTransaccion = true;
                        if (sesion.getOperaciones().establecerPartida(sNombre, vValor, valorAnterior)) {
                            boolean retorno = false;
                            retorno = esPartidaModificada ? this.dispararRegla(sesion, sNombre) : sesion.getOperaciones().establecerEstado(sNombre, estado);
                            if (retorno) {
                                if (!enTran) {
                                    ((ISesionExtendida)sesion).commitTrans();
                                }
                                enTransaccion = false;
                                resultado = true;
                            } else {
                                if (!enTran) {
                                    ((ISesionExtendida)sesion).rollBack();
                                }
                                enTransaccion = false;
                            }
                        } else {
                            if (!enTran) {
                                ((ISesionExtendida)sesion).rollBack();
                            }
                            enTransaccion = false;
                        }
                    }
                }
            }
            return resultado;
        }
        catch (Exception ex) {
            if (enTransaccion && !enTran) {
                ((ISesionExtendida)sesion).rollBack();
            }
            String str = "Nombre " + sNombre;
            try {
                str = str + " valor " + vValor;
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ex instanceof ExceptionMotor) {
                ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + str);
                throw (ExceptionMotor)ex;
            }
            throw new ExceptionMotor(ex, str);
        }
    }

    protected boolean dispararRegla(ISesion sesion, String nombrePartida) throws ExceptionMotor {
        int tipoReglasActual = this.getTipoReglaBusqueda(sesion);
        boolean limpiarListaReglasBusqueda = false;
        try {
            int i;
            if (((IGestionReglasExtendida)sesion.getGestionReglas()).getListaTipoReglasBusqueda() == null) {
                limpiarListaReglasBusqueda = true;
                ((IGestionReglasExtendida)sesion.getGestionReglas()).setListaTipoReglasBusqueda(new ArrayList<Integer>());
                ((IGestionReglasExtendida)sesion.getGestionReglas()).getListaTipoReglasBusqueda().add(tipoReglasActual);
            }
            for (i = 0; i < ((IGestionReglasExtendida)sesion.getGestionReglas()).getListaTipoReglasBusqueda().size(); ++i) {
                this.setTipoReglaBusqueda(sesion, ((IGestionReglasExtendida)sesion.getGestionReglas()).getListaTipoReglasBusqueda().get(i));
                Map<String, List<IRegRegla>> rsReglasPartidas = sesion.getModelo().getGestorConfiguracion().getReglasDePartidaClasificadas(nombrePartida);
                if (rsReglasPartidas == null || this.procesarReglas(sesion, rsReglasPartidas, nombrePartida)) continue;
                boolean bl = false;
                return bl;
            }
            i = 1;
            return i != 0;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Partida " + nombrePartida);
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e, "Partida " + nombrePartida);
        }
        finally {
            if (limpiarListaReglasBusqueda) {
                ((IGestionReglasExtendida)sesion.getGestionReglas()).setListaTipoReglasBusqueda(null);
            }
            this.setTipoReglaBusqueda(sesion, tipoReglasActual);
        }
    }

    protected boolean procesarReglas(ISesion sesion, Map<String, List<IRegRegla>> rsReglasPartidas, String nombrePartida) throws ExceptionMotor {
        try {
            if (rsReglasPartidas != null) {
                ArrayList<String> tiposDeReglas = new ArrayList<String>();
                if (this.getTipoValidacionReglas(sesion) == 0) {
                    tiposDeReglas.add("V");
                    tiposDeReglas.add("O");
                } else {
                    tiposDeReglas.add(TipoValidacionReglas.getLetraCorrespondencia(this.getTipoValidacionReglas(sesion)));
                }
                for (int i = 0; i < tiposDeReglas.size(); ++i) {
                    List<IRegRegla> reglas = this.ordenaReglas(sesion, rsReglasPartidas.get(((String)tiposDeReglas.get(i)).toString()));
                    if (reglas == null) continue;
                    for (int j = 0; j < reglas.size(); ++j) {
                        if (this.procesaRegla(sesion, reglas.get(j), nombrePartida)) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Partida " + nombrePartida);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Partida " + nombrePartida);
        }
    }

    @Override
    public boolean procesaRegla(ISesion sesion, IRegRegla rsAux, String nombrePartida) throws ExceptionMotor {
        boolean resDispararReglas = false;
        try {
            int i;
            ((ISesionExtendida)sesion).addPartidaQueHizoSaltarRegla(rsAux.getIdRegla(), nombrePartida);
            resDispararReglas = true;
            HashMap<String, Object> valoresInicialesDestinos = new HashMap<String, Object>();
            String sDis = "";
            String[] destinos = rsAux.getDestinos();
            for (i = 0; i < destinos.length; ++i) {
                valoresInicialesDestinos.put(destinos[i], ((ISesionExtendida)sesion).obtenerDestino(destinos[i]));
            }
            sDis = rsAux.getDiscriminante() == null ? "" : rsAux.getDiscriminante();
            if (sDis.length() == 0 || this.getDiscriminante(sesion).toUpperCase().contains(sDis.toUpperCase())) {
                this.setUltimaReglaProcesada(sesion, rsAux.getIdRegla());
                if (this.ejecucionDeReglaEnCodigoNumero(sesion, rsAux.getIdRegla())) {
                    for (i = 0; i < destinos.length; ++i) {
                        if (valoresInicialesDestinos.get(destinos[i]).toString().equalsIgnoreCase(((ISesionExtendida)sesion).obtenerDestino(destinos[i]).toString()) || this.dispararRegla(sesion, destinos[i])) continue;
                        resDispararReglas = false;
                    }
                } else {
                    resDispararReglas = false;
                }
            }
            boolean bl = resDispararReglas;
            return bl;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Partida " + nombrePartida);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Partida " + nombrePartida);
        }
        finally {
            this.setUltimaReglaProcesada(sesion, -1);
        }
    }

    protected boolean ejecucionDeReglaEnCodigoNumero(ISesion sesion, int num) throws ExceptionMotor {
        return sesion.getModelo().getClaseCodigoReglas().ejecutaRegla(sesion, num);
    }

    protected List<IRegRegla> ordenaReglas(ISesion sesion, List<IRegRegla> rsReglas) throws ExceptionMotor {
        try {
            if (rsReglas == null) {
                return null;
            }
            ArrayList<IRegRegla> res = new ArrayList<IRegRegla>();
            IRegRegla r = null;
            for (int i = 0; i < rsReglas.size(); ++i) {
                r = rsReglas.get(i);
                res.add(this.enQueOrdenInsertarRegla(sesion, res, r), r);
            }
            if (rsReglas.size() == 0) {
                res = null;
            }
            return res;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected int enQueOrdenInsertarRegla(ISesion sesion, List<IRegRegla> reglas, IRegRegla r) {
        try {
            int orden = r.getOrden();
            if (orden == Integer.MAX_VALUE) {
                return reglas.size();
            }
            for (int i = 0; i < reglas.size(); ++i) {
                if (orden >= reglas.get(i).getOrden()) continue;
                return i;
            }
            return reglas.size();
        }
        catch (Exception ex) {
            return reglas.size();
        }
    }

    @Override
    public boolean ejecutaReglasDePartida(ISesion sesion, String sNombre) throws ExceptionMotor {
        return this.partidaModificadaOestablecerDatosExportacionPartida(sesion, sNombre, null, "partidaModificada", false, true, null);
    }

    @Override
    public ITipoDatoRetornoProceso comprobarDeclaracion(ISesion sesion, String tablaAChequear, String[] cadenas) throws ExceptionMotor {
        String tipoDiscriminante = sesion.getGestionReglas().getDiscriminante();
        int tipoReglasBusqueda = ((IGestionReglasExtendida)sesion.getGestionReglas()).getTipoReglaBusqueda();
        FuncionesUtiles.getFuncionesUtiles().inicializarContadorMilisegundos("tiempoComprobarDeclaracion");
        boolean cacheOrigenDatosAnterior = sesion.getOrigenDeDatos().isCacheHabilitada();
        try {
            sesion.getOrigenDeDatos().setCacheHabilitada(true);
            if (!sesion.getGestionReglas().getDiscriminante().contains("C")) {
                sesion.getGestionReglas().addDiscriminante("C");
            }
            ((IGestionReglasExtendida)sesion.getGestionReglas()).listaErroresEnReglasClear();
            INodoArbol arbolDatos = sesion.getOperaciones().getArbolDatos();
            String nombrePartidaASaltar = "";
            HashMap<String, String> listaTablasPartidas = new HashMap<String, String>();
            for (String string : cadenas) {
                listaTablasPartidas.put(string.split(",")[0], string.split(",")[1]);
            }
            nombrePartidaASaltar = FuncionesUtiles.getFuncionesUtiles().object2String(listaTablasPartidas.get(tablaAChequear.toUpperCase()));
            INodoArbol hoja = arbolDatos;
            if (hoja.numeroHijos() > 0) {
                for (int i = 0; i < hoja.numeroHijos(); ++i) {
                    this.chequearRegistrosHijosyElMismo(sesion, hoja.getHijo(i).getNombreNodo(), arbolDatos, listaTablasPartidas, i);
                }
            } else {
                this.chequearRegistro(sesion, listaTablasPartidas, nombrePartidaASaltar, tablaAChequear, -1);
            }
            if (tablaAChequear.equalsIgnoreCase(sesion.getModelo().getGestorConfiguracion().getTablaNivel(0).getIdTabla())) {
                this.chequearRegistro(sesion, listaTablasPartidas, nombrePartidaASaltar, tablaAChequear, -1);
            }
            if (((IGestionReglasExtendida)sesion.getGestionReglas()).getErroresComprobarDeclaracion().getListadoErrores().size() + ((IGestionReglasExtendida)sesion.getGestionReglas()).getErroresComprobarDeclaracion().getListadoWarnings().size() >= sesion.getGestionReglas().getMaxErrores()) {
                FuncionesUtiles.getFuncionesUtiles().dejaSoloNerroresEntreListas(((IGestionReglasExtendida)sesion.getGestionReglas()).getErroresComprobarDeclaracion().getListadoErrores(), ((IGestionReglasExtendida)sesion.getGestionReglas()).getErroresComprobarDeclaracion().getListadoWarnings(), sesion.getGestionReglas().getMaxErrores());
                IRegError errMax = sesion.getModelo().getGestorConfiguracion().getError("MAXERR");
                if (errMax != null) {
                    if (((IGestionReglasExtendida)sesion.getGestionReglas()).getErroresComprobarDeclaracion().getListadoWarnings().size() > 0) {
                        ((IGestionReglasExtendida)sesion.getGestionReglas()).getErroresComprobarDeclaracion().getListadoWarnings().add(errMax);
                    } else {
                        ((IGestionReglasExtendida)sesion.getGestionReglas()).getErroresComprobarDeclaracion().getListadoErrores().add(errMax);
                    }
                }
            }
            ITipoDatoRetornoProceso iTipoDatoRetornoProceso = ((IGestionReglasExtendida)sesion.getGestionReglas()).getErroresComprobarDeclaracion();
            return iTipoDatoRetornoProceso;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
        finally {
            sesion.getOrigenDeDatos().setCacheHabilitada(cacheOrigenDatosAnterior);
            sesion.getGestionReglas().setDiscriminante(tipoDiscriminante);
            ((IGestionReglasExtendida)sesion.getGestionReglas()).setTipoReglaBusqueda(tipoReglasBusqueda);
            FuncionesUtiles.getFuncionesUtiles().muestraInfo("Comprobar Declaraci\u00f3n tard\u00f3 : " + FuncionesUtiles.getFuncionesUtiles().mostrarContador("tiempoComprobarDeclaracion"));
        }
    }

    protected void chequearRegistrosHijosyElMismo(ISesion sesion, String nombreTabla, INodoArbol arbolDatos, Map<?, ?> listaTablasPartidas, int i2) throws ExceptionMotor {
        String nombrePartidaASaltar = "";
        nombrePartidaASaltar = nombreTabla.indexOf(47) > -1 ? FuncionesUtiles.getFuncionesUtiles().object2String(listaTablasPartidas.get(nombreTabla.substring(0, nombreTabla.indexOf(47)))) : FuncionesUtiles.getFuncionesUtiles().object2String(listaTablasPartidas.get(nombreTabla));
        try {
            long totalRegistros;
            INodoArbol hoja = arbolDatos.buscaHijo(nombreTabla);
            if (hoja == null) {
                throw new Exception("Imposible encontrar en arbol motor tabla " + nombreTabla);
            }
            boolean bEstaNodoEnTabla = false;
            bEstaNodoEnTabla = nombreTabla.indexOf(47) > -1 ? listaTablasPartidas.containsKey(nombreTabla.substring(0, nombreTabla.indexOf(47))) : listaTablasPartidas.containsKey(nombreTabla);
            if (bEstaNodoEnTabla && (totalRegistros = sesion.getOperaciones().recordCount(nombreTabla)) > 0L) {
                sesion.getOperaciones().moveFirst(nombreTabla);
                int i = 0;
                while ((long)i < totalRegistros) {
                    for (int c = 0; c < hoja.numeroHijos(); ++c) {
                        this.chequearRegistrosHijosyElMismo(sesion, hoja.getHijo(c).getNombreNodo(), arbolDatos, listaTablasPartidas, c);
                    }
                    this.chequearRegistro(sesion, listaTablasPartidas, nombrePartidaASaltar, nombreTabla, i);
                    sesion.getOperaciones().moveNext(nombreTabla);
                    ++i;
                }
            }
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    protected void chequearRegistro(ISesion sesion, Map<?, ?> listaTablasPartidas, String nombrePartidaASaltar, String nombreTabla, int info) throws ExceptionMotor {
        try {
            String nt = nombreTabla.indexOf(47) != -1 ? nombreTabla.substring(0, nombreTabla.indexOf(47)) : nombreTabla;
            nombrePartidaASaltar = FuncionesUtiles.getFuncionesUtiles().object2String(listaTablasPartidas.get(nt));
            ((IGestionReglasExtendida)sesion.getGestionReglas()).setTipoReglaBusqueda(8);
            this.chequear(sesion, nombrePartidaASaltar);
            this.anadirErroresEnLista(sesion, ((IGestionReglasExtendida)sesion.getGestionReglas()).getListaErroresEnReglas());
            ((IGestionReglasExtendida)sesion.getGestionReglas()).setTipoReglaBusqueda(3);
            this.chequear(sesion, nombrePartidaASaltar);
            this.anadirErroresEnLista(sesion, ((IGestionReglasExtendida)sesion.getGestionReglas()).getListaErroresEnReglas());
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected void anadirErroresEnLista(ISesion sesion, List<IRegError> erroresNuevos) throws ExceptionMotor {
        try {
            if (erroresNuevos == null || erroresNuevos.size() == 0) {
                return;
            }
            for (int i = 0; i < erroresNuevos.size(); ++i) {
                if (erroresNuevos.get(i).getPropiedad("TIPO ERROR").toString().equalsIgnoreCase("E")) {
                    ((IGestionReglasExtendida)sesion.getGestionReglas()).getErroresComprobarDeclaracion().getListadoErrores().add(erroresNuevos.get(i));
                    ((IGestionReglasExtendida)sesion.getGestionReglas()).getErroresComprobarDeclaracion().setCorrecto(false);
                    continue;
                }
                ((IGestionReglasExtendida)sesion.getGestionReglas()).getErroresComprobarDeclaracion().getListadoWarnings().add(erroresNuevos.get(i));
            }
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public boolean chequear(ISesion sesion, String sNombre, boolean enTransaccion) throws ExceptionMotor {
        try {
            boolean res;
            if (((ISesionExtendida)sesion).isEjecutandoBatchAnniadirRegistro()) {
                throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras existan comandos batch_A\u00f1adirRegistro(...) pendientes", Thread.currentThread().getStackTrace());
            }
            try {
                if (enTransaccion) {
                    ((ISesionExtendida)sesion).beginTrans();
                }
                res = this.getTipoReglaBusqueda(sesion) == 8 ? ((Boolean)this.ejecutarFuncion(sesion, "comprobarRegistroWarning", new Object[]{sNombre})).booleanValue() : ((Boolean)this.ejecutarFuncion(sesion, "comprobarRegistroConDiscriminante", new Object[]{sNombre})).booleanValue();
                if (enTransaccion) {
                    ((ISesionExtendida)sesion).commitTrans();
                }
            }
            catch (Exception e) {
                boolean res2 = false;
                ((ISesionExtendida)sesion).rollBack();
                throw new ExceptionMotor(e);
            }
            return res;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Partida " + sNombre);
        }
    }

    @Override
    public boolean chequear(ISesion sesion, String sNombre) throws ExceptionMotor {
        return this.chequear(sesion, sNombre, true);
    }

    @Override
    public Object ejecutarFuncion(ISesion sesion, String nombreFuncion, Object[] vParametros) throws ExceptionMotor {
        try {
            ITipoDatoRetornoMetodo ret = this.getEjecutarFuncionDelValidador(sesion, nombreFuncion, vParametros);
            if (ret.isRetornaResultado()) {
                return ret.getObjetoRetorno();
            }
            if (!ret.isNoImplementado()) {
                throw new ExceptionMotor("Retorno de m\u00e9todo no esperado!!!");
            }
            if (nombreFuncion.equalsIgnoreCase("setst")) {
                return ((IFunciones)this.motor.getClaseFunciones()).setst(sesion, vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("getst")) {
                return ((IFunciones)this.motor.getClaseFunciones()).getst(sesion, vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("error")) {
                return ((IFunciones)this.motor.getClaseFunciones()).error(sesion, vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("aviso")) {
                return ((IFunciones)this.motor.getClaseFunciones()).aviso(sesion, vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("longitud")) {
                return ((IFunciones)this.motor.getClaseFunciones()).longitud(sesion, vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("notifica")) {
                return ((IFunciones)this.motor.getClaseFunciones()).notifica(sesion, vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("hoy")) {
                return ((IFunciones)this.motor.getClaseFunciones()).hoy();
            }
            if (nombreFuncion.equalsIgnoreCase("comprobarestadodepartida")) {
                return ((IFunciones)this.motor.getClaseFunciones()).comprobarEstadodePartida(sesion, vParametros);
            }
            if (nombreFuncion.toLowerCase().equalsIgnoreCase("nifvalido")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).nifValido(vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("niffisica")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).nifFisica(vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("nifjuridica")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).nifJuridica(vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("dametiponif")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).dameTipoNif(vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("nombreynif")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).nombreyNif(vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("nombrevalido")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).nombreValido(vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("validarfecha")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).validarFecha(vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("compararfecha")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).compararFecha(vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("valcntapcampos")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).valCntaPCampos(vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("valcntapcadena")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).valCntaPCadena(vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("comprobarnumerojustificante")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).comprobarNumeroJustificante(vParametros[0].toString());
            }
            if (nombreFuncion.equalsIgnoreCase("compNumJust")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).compNumJust(vParametros[0].toString(), vParametros[1].toString());
            }
            if (nombreFuncion.equalsIgnoreCase("validarcodigopostal")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).validarCodigoPostal(vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("rnd")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).rnd(vParametros[0], vParametros[1]);
            }
            if (nombreFuncion.equalsIgnoreCase("comprobarregistro")) {
                return ((IFunciones)this.motor.getClaseFunciones()).comprobarRegistro(sesion, vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("comprobarregistrocondiscriminante")) {
                return ((IFunciones)this.motor.getClaseFunciones()).comprobarRegistroConDiscriminante(sesion, vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("comprobarregistrowarning")) {
                return ((IFunciones)this.motor.getClaseFunciones()).comprobarRegistroWarning(sesion, vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("cabeceranumerojustificante")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).cabeceraNumeroJustificante(vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("comprobarnombrefisica")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).comprobarNombreFisica(vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("emailCorrecto")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).emailCorrecto(vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("valorabsoluto")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).valorAbsoluto(vParametros[0]);
            }
            if (nombreFuncion.equalsIgnoreCase("validarcontraficheroauxiliar")) {
                return ((IFunciones)this.motor.getClaseFunciones()).validarContraFicheroAuxiliar(sesion, vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("generaNumeroJustificante")) {
                return FuncionesUtilesExportacion.getFuncionesUtilesExportacion().generaNumeroJustificante(vParametros).toString();
            }
            if (nombreFuncion.equalsIgnoreCase("generaNumeroDeReferencia")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).generaNumeroDeReferencia(vParametros[0].toString(), vParametros[1].toString()).toString();
            }
            if (nombreFuncion.equalsIgnoreCase("generaNumeroDeReferenciaMI")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).generaNumeroDeReferenciaMI(vParametros[0].toString(), vParametros[1].toString()).toString();
            }
            if (nombreFuncion.equalsIgnoreCase("formatonombrecorrecto")) {
                return ((IFunciones)this.motor.getClaseFunciones()).formatoNombreCorrecto(vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("nombrefisicocorrecto")) {
                return ((IFunciones)this.motor.getClaseFunciones()).nombreFisicoCorrecto(vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("sumatorioCampoTabla")) {
                return ((IFunciones)this.motor.getClaseFunciones()).sumatorioCampoTabla(sesion, vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("registrosDeTabla")) {
                return ((IFunciones)this.motor.getClaseFunciones()).registrosDeTabla(sesion, vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("nifregimenatribucionrentas")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).nifRegimenAtribucionRentas(vParametros);
            }
            if (nombreFuncion.equalsIgnoreCase("abs")) {
                return (Double)((Comprobaciones)this.motor.getClaseComprobaciones()).abs(vParametros[0]);
            }
            if (nombreFuncion.equalsIgnoreCase("esfecha")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).esFecha(vParametros[0].toString(), vParametros[1].toString());
            }
            if (nombreFuncion.equalsIgnoreCase("esfechainvertida")) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).esFechaInvertida(vParametros[0].toString());
            }
            if (nombreFuncion.toLowerCase().startsWith("compruebacodpostal".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).compruebaCodPostal(sesion, vParametros[0].toString());
            }
            if (nombreFuncion.toLowerCase().startsWith("compruebacpconprovi".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).compruebaCPconProvi(sesion, vParametros[0].toString(), vParametros[1].toString(), vParametros[2].toString());
            }
            if (nombreFuncion.toLowerCase().startsWith("compruebaprovincia".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).compruebaProvincia(sesion, vParametros[0].toString(), vParametros[1].toString());
            }
            if (nombreFuncion.toLowerCase().startsWith("esEntero".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).esEntero(vParametros[0].toString());
            }
            if (nombreFuncion.toLowerCase().startsWith("hayRegistros".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).hayRegistros(sesion, vParametros[0].toString());
            }
            if (nombreFuncion.toLowerCase().startsWith("validaIBAN".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).validaIBAN(vParametros[0].toString());
            }
            if (nombreFuncion.toLowerCase().startsWith("validaCuentaCliente".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).validaCuentaCliente(vParametros[0].toString());
            }
            if (nombreFuncion.toLowerCase().startsWith("validaCuentaCorriente".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).validaCuentaCorriente(vParametros[0].toString());
            }
            if (nombreFuncion.toLowerCase().startsWith("validaMovil".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).validaMovil(vParametros[0].toString());
            }
            if (nombreFuncion.toLowerCase().startsWith("validaTeleFax".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).validaTeleFax(vParametros[0].toString());
            }
            if (nombreFuncion.toLowerCase().startsWith("validaTelefono".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).validaTelefono(vParametros[0].toString());
            }
            if (nombreFuncion.toLowerCase().startsWith("desformateaCuentaBancaria".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).desformateaCuentaBancaria(vParametros[0].toString(), Integer.parseInt(vParametros[1].toString()));
            }
            if (nombreFuncion.toLowerCase().startsWith("superaUnAnno".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).superaUnAnno(vParametros[0].toString(), vParametros[1].toString());
            }
            if (nombreFuncion.toLowerCase().startsWith("inferiorUnAnno".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).inferiorUnAnno(vParametros[0].toString(), vParametros[1].toString());
            }
            if (nombreFuncion.toLowerCase().startsWith("dameEjercicio".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).dameEjercicio(vParametros[0].toString());
            }
            if (nombreFuncion.toLowerCase().startsWith("establecerNumeroDias".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).establecerEj(vParametros[0].toString(), vParametros[1].toString());
            }
            if (nombreFuncion.toLowerCase().startsWith("establecerEj".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).establecerNumeroDias(vParametros[0].toString(), vParametros[1].toString());
            }
            if (nombreFuncion.toLowerCase().startsWith("validarFechaPeriodo".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).validarFechaPeriodo(vParametros[0].toString(), vParametros[1].toString(), vParametros[2].toString());
            }
            if (nombreFuncion.toLowerCase().startsWith("convertirIntACadena".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).convertirIntACadena((Integer)vParametros[0]);
            }
            if (nombreFuncion.toLowerCase().startsWith("dameAdministracion".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).dameAdministracion((String)vParametros[0]);
            }
            if (nombreFuncion.toLowerCase().startsWith("dameNIU".toLowerCase())) {
                return ((Comprobaciones)this.motor.getClaseComprobaciones()).dameNIU((String)vParametros[0]);
            }
            throw new ExceptionMotor("No se encuentra la implementaci\u00f3n de la funci\u00f3n " + nombreFuncion);
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Funcion " + nombreFuncion);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Funcion " + nombreFuncion);
        }
    }

    protected ITipoDatoRetornoMetodo getEjecutarFuncionDelValidador(ISesion sesion, String nombreFuncion, Object[] vParametros) throws ExceptionMotor {
        if (sesion.getModelo().getClaseValidador() == null) {
            return new TipoDatoRetornoMetodo(-99998);
        }
        return sesion.getModelo().getClaseValidador().ejecutarFuncion(sesion, nombreFuncion, vParametros);
    }

    @Override
    public void setTipoReglaBusqueda(ISesion sesion, int tipoValidacion) throws ExceptionMotor {
        this.setTipoValidacionReglas(sesion, tipoValidacion);
    }

    @Override
    public int getTipoReglaBusqueda(ISesion sesion) throws ExceptionMotor {
        return this.getTipoValidacionReglas(sesion);
    }

    @Override
    public int getUltimaReglaProcesada(ISesion sesion) throws ExceptionMotor {
        return ((IGestionReglasExtendida)sesion.getGestionReglas()).getUltimaReglaProcesada();
    }

    @Override
    public void setUltimaReglaProcesada(ISesion sesion, int ultimaReglaProcesada) throws ExceptionMotor {
        ((IGestionReglasExtendida)sesion.getGestionReglas()).setUltimaReglaProcesada(ultimaReglaProcesada);
    }

    @Override
    public List<Integer> getListaTipoReglasBusqueda(ISesion sesion) throws ExceptionMotor {
        return ((IGestionReglasExtendida)sesion.getGestionReglas()).getListaTipoReglasBusqueda();
    }

    @Override
    public boolean isAlmacenarErrorLista(ISesion sesion) throws ExceptionMotor {
        return ((IGestionReglasExtendida)sesion.getGestionReglas()).isAlmacenarErrorLista();
    }

    @Override
    public void setAlmacenarErrorLista(ISesion sesion, boolean almacenarErrorLista) throws ExceptionMotor {
        ((IGestionReglasExtendida)sesion.getGestionReglas()).setAlmacenarErrorLista(almacenarErrorLista);
    }

    @Override
    public String getDiscriminante(ISesion sesion) throws ExceptionMotor {
        return ((IGestionReglasExtendida)sesion.getGestionReglas()).getDiscriminante();
    }

    @Override
    public void setDiscriminante(ISesion sesion, String discriminante) throws ExceptionMotor {
        ((IGestionReglasExtendida)sesion.getGestionReglas()).setDiscriminante(discriminante);
    }

    @Override
    public String getPartidaProcesando(ISesion sesion) throws ExceptionMotor {
        return ((IGestionReglasExtendida)sesion.getGestionReglas()).getPartidaProcesando();
    }

    @Override
    public void setPartidaProcesando(ISesion sesion, String partidaProcesando) throws ExceptionMotor {
        ((IGestionReglasExtendida)sesion.getGestionReglas()).setPartidaProcesando(partidaProcesando);
    }

    @Override
    public boolean isEjecutandoReglas(ISesion sesion) throws ExceptionMotor {
        return ((IGestionReglasExtendida)sesion.getGestionReglas()).isEjecutandoReglas();
    }

    @Override
    public void setEjecutandoReglas(ISesion sesion, boolean ejecutandoReglas) throws ExceptionMotor {
        ((IGestionReglasExtendida)sesion.getGestionReglas()).setEjecutandoReglas(ejecutandoReglas);
    }

    @Override
    public boolean isCortarEjecucionReglas(ISesion sesion) throws ExceptionMotor {
        return ((IGestionReglasExtendida)sesion.getGestionReglas()).isCortarEjecucionReglas();
    }

    @Override
    public void setCortarEjecucionReglas(ISesion sesion, boolean cortarEjecucionReglas) throws ExceptionMotor {
        ((IGestionReglasExtendida)sesion.getGestionReglas()).setCortarEjecucionReglas(cortarEjecucionReglas);
    }

    @Override
    public List<IRegError> getListaErroresEnReglas(ISesion sesion) throws ExceptionMotor {
        ArrayList<IRegError> ret = new ArrayList<IRegError>();
        for (int i = 0; i < ((IGestionReglasExtendida)sesion.getGestionReglas()).listaErroresEnReglasSize(); ++i) {
            ret.add(((IGestionReglasExtendida)sesion.getGestionReglas()).listaErroresEnReglasGet(i));
        }
        ((IGestionReglasExtendida)sesion.getGestionReglas()).listaErroresEnReglasClear();
        return ret;
    }

    @Override
    public List<ITipoNotificacion> getNotificaciones(ISesion sesion) throws ExceptionMotor {
        return ((IGestionReglasExtendida)sesion.getGestionReglas()).getNotificaciones();
    }

    @Override
    public List<IRegError> getRefListaErroresEnReglas(ISesion sesion) throws ExceptionMotor {
        return ((IGestionReglasExtendida)sesion.getGestionReglas()).getListaErroresEnReglas();
    }

    @Override
    public int getTipoValidacionReglas(ISesion sesion) throws ExceptionMotor {
        return ((IGestionReglasExtendida)sesion.getGestionReglas()).getTipoValidacionReglas();
    }

    @Override
    public void setTipoValidacionReglas(ISesion sesion, int tipoValidacionReglas) throws ExceptionMotor {
        ((IGestionReglasExtendida)sesion.getGestionReglas()).setTipoValidacionReglas(tipoValidacionReglas);
    }

    @Override
    public boolean isExtraerReglasEnHashMap(ISesion sesion) throws ExceptionMotor {
        return ((IGestionReglasExtendida)sesion.getGestionReglas()).isExtraerReglasEnHashMap();
    }

    @Override
    public void setExtraerReglasEnHashMap(ISesion sesion, boolean extraerReglasEnHashMap) throws ExceptionMotor {
        ((IGestionReglasExtendida)sesion.getGestionReglas()).setExtraerReglasEnHashMap(extraerReglasEnHashMap);
    }

    @Override
    public List<IRegRegla> buscarReglasDePartida(ISesion sesion, String nombrePartida) throws ExceptionMotor {
        try {
            ArrayList<IRegRegla> res = new ArrayList<IRegRegla>();
            List<IRegRegla> rsReglasPartidas = sesion.getModelo().getGestorConfiguracion().getReglasDePartida(nombrePartida);
            if (rsReglasPartidas == null) {
                return res;
            }
            IRegRegla r = null;
            block15: for (int i = 0; i < rsReglasPartidas.size(); ++i) {
                r = rsReglasPartidas.get(i);
                switch (((IGestionReglasExtendida)sesion.getGestionReglas()).getTipoValidacionReglas()) {
                    case 0: {
                        res.add(this.enQueOrdenInsertarRegla(sesion, res, r), r);
                        continue block15;
                    }
                    case 1: {
                        if (!r.getTipoRegla().equalsIgnoreCase("V")) continue block15;
                        res.add(this.enQueOrdenInsertarRegla(sesion, res, r), r);
                        continue block15;
                    }
                    case 2: {
                        if (!r.getTipoRegla().equalsIgnoreCase("O")) continue block15;
                        res.add(this.enQueOrdenInsertarRegla(sesion, res, r), r);
                        continue block15;
                    }
                    case 3: {
                        if (!r.getTipoRegla().equalsIgnoreCase("R")) continue block15;
                        res.add(this.enQueOrdenInsertarRegla(sesion, res, r), r);
                        continue block15;
                    }
                    case 4: {
                        if (!r.getTipoRegla().equalsIgnoreCase("F")) continue block15;
                        res.add(this.enQueOrdenInsertarRegla(sesion, res, r), r);
                        continue block15;
                    }
                    case 5: {
                        if (!r.getTipoRegla().equalsIgnoreCase("E")) continue block15;
                        res.add(this.enQueOrdenInsertarRegla(sesion, res, r), r);
                        continue block15;
                    }
                    case 6: {
                        if (!r.getTipoRegla().equalsIgnoreCase("C")) continue block15;
                        res.add(this.enQueOrdenInsertarRegla(sesion, res, r), r);
                        continue block15;
                    }
                    case 7: {
                        if (!r.getTipoRegla().equalsIgnoreCase("B")) continue block15;
                        res.add(this.enQueOrdenInsertarRegla(sesion, res, r), r);
                        continue block15;
                    }
                    case 8: {
                        if (!r.getTipoRegla().equalsIgnoreCase("W")) continue block15;
                        res.add(this.enQueOrdenInsertarRegla(sesion, res, r), r);
                        continue block15;
                    }
                    case 9: {
                        if (!r.getTipoRegla().equalsIgnoreCase("D")) continue block15;
                        res.add(this.enQueOrdenInsertarRegla(sesion, res, r), r);
                        continue block15;
                    }
                }
            }
            return res;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Partida " + nombrePartida);
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e, "Partida " + nombrePartida);
        }
    }

    @Override
    public boolean establecerDatosExportacionPartida(ISesion sesion, String nombrePartida, Object valorDato, boolean estado) throws ExceptionMotor {
        return this.partidaModificadaOestablecerDatosExportacionPartida(sesion, nombrePartida, valorDato, "establecerDatosExportacionPartida", estado, false, null);
    }
}

