/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.procesadorReglas;

import es.aeat.pftw.mtrc.IAop;
import es.aeat.pftw.mtrc.motor.IMotor;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesionExtendida;
import es.aeat.pftw.mtrc.motor.modelo.sesion.tools.IGestionReglasExtendida;
import es.aeat.pftw.mtrc.procesadorReglas.IFunciones;
import es.aeat.pftw.mtrc.puente.ITablaMotor;
import es.aeat.pftw.mtrc.tipos.DateMotor;
import es.aeat.pftw.mtrc.tipos.TipoNotificacion;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.utilidades.StringUtility;
import es.aeat.pftw.mtrc.utilidades.Validaciones;
import es.aeat.pftw.mtrp.configuracion.IRegEntrada;
import es.aeat.pftw.mtrp.configuracion.IRegError;
import es.aeat.pftw.mtrp.configuracion.IRegRegla;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.tipos.IDateMotor;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Funciones
implements IAop,
Serializable,
IFunciones {
    private static final long serialVersionUID = 1L;
    private transient IMotor motor = null;

    @Override
    public void dispose() throws ExceptionMotor {
        this.motor = null;
    }

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            this.motor = (IMotor)parametros[0];
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Boolean setst(ISesion sesion, Object[] vParametros) throws ExceptionMotor {
        try {
            return this.sets(sesion, vParametros[0].toString(), vParametros[1].toString());
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public int getst(ISesion sesion, Object[] vParametros) {
        return this.gets(sesion, vParametros[0].toString());
    }

    private boolean sets(ISesion sesion, String nombrePartida, Object estado) throws ExceptionMotor {
        try {
            boolean ret = true;
            int estadoInt = 255;
            if (FuncionesUtiles.getFuncionesUtiles().esNumerico(String.valueOf(estado))) {
                estadoInt = Double.valueOf(String.valueOf(estado)).intValue();
            } else if (!Boolean.valueOf(String.valueOf(estado)).booleanValue()) {
                estadoInt = 254;
            }
            String[] arrayDestinos = this.getDestinos(sesion, nombrePartida);
            for (int i = 0; i < arrayDestinos.length; ++i) {
                ret &= sesion.getOperaciones().establecerEstado(arrayDestinos[i], estadoInt);
            }
            return ret;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public int longitud(ISesion sesion, Object[] vParametros) throws ExceptionMotor {
        try {
            return sesion.getOperaciones().obtenerPartidaString(vParametros[0].toString()).length();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    private int gets(ISesion sesion, String nombrePartida) {
        try {
            return sesion.getOperaciones().obtenerEstadoPartida(nombrePartida);
        }
        catch (Exception ex) {
            return 255;
        }
    }

    @Override
    public String[] getDestinos(ISesion sesion, String cadenaDestinos) throws ExceptionMotor {
        try {
            String[] res = StringUtility.getStringUtility().split(cadenaDestinos, ((IGestionReglasExtendida)sesion.getGestionReglas()).getSeparadorDestinos());
            for (int i = 0; i < res.length; ++i) {
                res[i] = res[i].trim();
            }
            return res;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public IDateMotor hoy() throws ExceptionMotor {
        try {
            Calendar ahora = Calendar.getInstance();
            String cadenaFecha = FuncionesUtiles.getFuncionesUtiles().rellena(String.valueOf(ahora.get(5)), '0', 2, true) + "/" + FuncionesUtiles.getFuncionesUtiles().rellena(String.valueOf(ahora.get(2) + 1), '0', 2, true) + "/" + FuncionesUtiles.getFuncionesUtiles().rellena(String.valueOf(ahora.get(1)), '0', 4, true);
            return new DateMotor(cadenaFecha);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Boolean aviso(ISesion sesion, Object[] vParametros) throws ExceptionMotor {
        this.error(sesion, vParametros);
        return true;
    }

    @Override
    public Boolean error(ISesion sesion, Object[] vParametros) throws ExceptionMotor {
        try {
            String idError = vParametros[0].toString();
            IRegError err = FuncionesUtiles.getFuncionesUtiles().generarErrorSiNoExiste(sesion, idError);
            err = err.clone();
            if (vParametros.length != 3) {
                int ultimaRegla;
                if (sesion.getGestionReglas() != null && (ultimaRegla = ((IGestionReglasExtendida)sesion.getGestionReglas()).getUltimaReglaProcesada()) != -1) {
                    err.setPropiedad("TIPO REGLA", sesion.getModelo().getGestorConfiguracion().getRegla(ultimaRegla).getTipoRegla());
                    err.setPropiedad("ID REGLA", String.valueOf(ultimaRegla));
                }
                try {
                    ITablaMotor tAux;
                    if (err.getCampoError() != null && err.getCampoError().length() > 0 && (tAux = ((ISesionExtendida)sesion).obtenerNodoPartida(err.getCampoError())) != null) {
                        err.setPropiedad("LOCALIZACIONERROR", FuncionesUtiles.getFuncionesUtiles().localizacion2String(((ISesionExtendida)sesion).obtenerNodoPartida(err.getCampoError()).getLocalizacion()));
                    }
                }
                catch (Exception ex) {
                    FuncionesUtiles.getFuncionesUtiles().muestraInfo("No pude establecer donde se produjo el error de un campo");
                }
                ((IGestionReglasExtendida)sesion.getGestionReglas()).addErrorAListaErroresEnReglas(err);
                return Boolean.FALSE;
            }
            if (vParametros.length > 2) {
                try {
                    if (vParametros[2] instanceof Map) {
                        Map propCampo = (Map)vParametros[2];
                        Set s = propCampo.keySet();
                        Iterator it = s.iterator();
                        while (it.hasNext()) {
                            String prop = ((String)it.next()).toString();
                            if (prop.equalsIgnoreCase("MENSAJE")) {
                                if (err.getMsg() != null && err.getMsg().trim().length() != 0) continue;
                                err.setPropiedad(prop, (String)propCampo.get(prop));
                                continue;
                            }
                            if (prop.equalsIgnoreCase("CAMPOMOTOR")) {
                                err.setPropiedad("CAMPO ERROR", (String)propCampo.get(prop));
                                continue;
                            }
                            err.setPropiedad(prop, (String)propCampo.get(prop));
                        }
                    } else {
                        err.setPropiedad("CAMPO ERROR", vParametros[2].toString());
                    }
                }
                catch (Exception ex) {
                    err.setPropiedad("CAMPO ERROR", err.getCampoError());
                }
                try {
                    String idPar1 = vParametros[1].toString();
                    if (idPar1.length() > 0) {
                        err.setPropiedad("TIPO ERROR", idPar1);
                    }
                }
                catch (Exception ex) {}
            } else {
                err.setPropiedad("CAMPO ERROR", err.getCampoError());
            }
            boolean ret = false;
            if (sesion.getOperaciones().getFuncionesErrorComportamientoEspecial()) {
                try {
                    String e = err.getPropiedad("TIPO ERROR").toString().trim();
                    if (e.length() > 0 && !e.equalsIgnoreCase("E") && !e.equalsIgnoreCase("H")) {
                        ret = true;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            ((IGestionReglasExtendida)sesion.getGestionReglas()).addErrorAListaErroresEnReglas(err);
            err = null;
            return ret;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Boolean notifica(ISesion sesion, Object[] vParametros) throws ExceptionMotor {
        try {
            String descripcion = vParametros[0].toString();
            Object[] argumentos = vParametros[1].toString().split(",");
            TipoNotificacion not = new TipoNotificacion(descripcion, argumentos);
            ((IGestionReglasExtendida)sesion.getGestionReglas()).addNotificacionAListaNotificaciones(not);
            return Boolean.TRUE;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean comprobarRegistroConDiscriminante(ISesion sesion, Object[] vParametros) throws ExceptionMotor {
        try {
            boolean res = true;
            boolean resSiguiente = true;
            String nombrePartida = vParametros[0].toString().trim();
            String discriminante = sesion.getGestionReglas().getDiscriminante();
            String sDis = "";
            List<IRegRegla> listaReglas = this.motor.getClaseGestionReglas().buscarReglasDePartida((ISesionExtendida)sesion, nombrePartida);
            for (int i = 0; i < listaReglas.size(); ++i) {
                IRegRegla rsAux = listaReglas.get(i);
                sDis = rsAux.getDiscriminante() == null ? "" : rsAux.getDiscriminante();
                if (sDis.length() != 0 && !discriminante.toUpperCase().contains(sDis.toUpperCase())) continue;
                resSiguiente = this.motor.getClaseGestionReglas().procesaRegla((ISesionExtendida)sesion, rsAux, nombrePartida);
                if (!resSiguiente) {
                    FuncionesUtiles.getFuncionesUtiles().muestraInfoDebug("comprobarRegistroConDiscriminante : Regla " + rsAux.getIdRegla() + " retorno falso...");
                }
                res = res && resSiguiente;
            }
            if (res) {
                String resul = sesion.getOperaciones().obtenerPartidaString(nombrePartida);
                if (resul.equalsIgnoreCase("2")) {
                    sesion.getOperaciones().establecerPartida(nombrePartida, 2);
                } else {
                    sesion.getOperaciones().establecerPartida(nombrePartida, 1);
                }
            } else {
                sesion.getOperaciones().establecerPartida(nombrePartida, 0);
            }
            return res;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean comprobarRegistroWarning(ISesion sesion, Object[] vParametros) throws ExceptionMotor {
        try {
            boolean res = true;
            String nombrePartida = vParametros[0].toString().trim();
            List<IRegRegla> listaReglas = this.motor.getClaseGestionReglas().buscarReglasDePartida((ISesionExtendida)sesion, nombrePartida);
            for (int i = 0; i < listaReglas.size(); ++i) {
                res &= this.motor.getClaseGestionReglas().procesaRegla((ISesionExtendida)sesion, listaReglas.get(i), nombrePartida);
            }
            if (res) {
                sesion.getOperaciones().establecerPartida(nombrePartida, 0);
            } else {
                sesion.getOperaciones().establecerPartida(nombrePartida, 2);
            }
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean comprobarRegistro(ISesion sesion, Object[] vParametros) throws ExceptionMotor {
        try {
            boolean res = true;
            String nombrePartida = vParametros[0].toString();
            List<IRegRegla> listaReglas = this.motor.getClaseGestionReglas().buscarReglasDePartida((ISesionExtendida)sesion, nombrePartida);
            for (int i = 0; i < listaReglas.size(); ++i) {
                if (listaReglas.get(i).getTipoRegla().equalsIgnoreCase("W")) continue;
                res &= this.motor.getClaseGestionReglas().procesaRegla((ISesionExtendida)sesion, listaReglas.get(i), nombrePartida);
            }
            if (res) {
                String resul = sesion.getOperaciones().obtenerPartidaString(nombrePartida);
                if (resul.equalsIgnoreCase("2")) {
                    sesion.getOperaciones().establecerPartida(nombrePartida, 2);
                } else {
                    sesion.getOperaciones().establecerPartida(nombrePartida, 1);
                }
            } else {
                sesion.getOperaciones().establecerPartida(nombrePartida, 0);
            }
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Boolean comprobarEstadodePartida(ISesion sesion, Object[] vParametros) throws ExceptionMotor {
        try {
            return this.comprobarEstadodePartida(sesion, vParametros[1].toString(), (Boolean)vParametros[2]);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    private boolean comprobarEstadodePartida(ISesion sesion, String nombrePartida, boolean estadoAComparar) throws ExceptionMotor {
        try {
            int estadoPartida = 255;
            int estAux = 255;
            estAux = estadoAComparar ? 255 : 254;
            estadoPartida = sesion.getOperaciones().obtenerEstadoPartida(nombrePartida);
            return estadoPartida == estAux;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Partida " + nombrePartida);
        }
    }

    @Override
    public Object buscarValorPartida(ISesion sesion, String nombrePartida) throws ExceptionMotor {
        try {
            int actual = ((IGestionReglasExtendida)sesion.getGestionReglas()).getNumDecimales();
            IRegEntrada ent = sesion.getModelo().getGestorConfiguracion().getEntrada(nombrePartida);
            if (ent != null && ent.getTipoDato().equalsIgnoreCase("DOBLE") || ent.getTipoDato().equalsIgnoreCase("BIGDECIMAL") && actual < ent.getNumDecimales()) {
                ((IGestionReglasExtendida)sesion.getGestionReglas()).setNumDecimales(ent.getNumDecimales());
            }
            return sesion.getOperaciones().obtenerPartidaString(nombrePartida);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean validarContraFicheroAuxiliar(ISesion sesion, Object[] vParametros) throws ExceptionMotor {
        try {
            if (sesion.getModelo().getGestorDatosAuxiliares() == null) {
                throw new ExceptionMotor("No se pudieron cargar los ficheros auxiliares");
            }
            return sesion.getModelo().getGestorDatosAuxiliares().getRegistro(vParametros[0].toString(), vParametros[1].toString()).length() > 0;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean formatoNombreCorrecto(Object[] vParametros) throws ExceptionMotor {
        try {
            String nombre = vParametros[0].toString();
            if (nombre.length() == 0) {
                return false;
            }
            char[] letras = nombre.toCharArray();
            if (letras[0] == ' ') {
                return false;
            }
            for (int i = 1; i < letras.length; ++i) {
                if (letras[i] != ' ' || letras[i - 1] != ' ') continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean nombreFisicoCorrecto(Object[] vParametros) throws ExceptionMotor {
        try {
            String nombre = vParametros[0].toString();
            if (nombre.length() == 0 || nombre.length() < 3) {
                return false;
            }
            char[] letras = nombre.toCharArray();
            if (letras[0] == letras[1] && letras[0] == letras[2]) {
                return false;
            }
            if (nombre.indexOf(32, 0) == -1) {
                return false;
            }
            return Validaciones.getValidaciones().esAlfabeticoAEAT(nombre);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Object sumatorioCampoTabla(ISesion sesion, Object[] vParametros) throws ExceptionMotor {
        try {
            String nombrePartida = vParametros[0].toString();
            int numDecimales = Integer.valueOf(vParametros[1].toString());
            IRegEntrada ent = sesion.getModelo().getGestorConfiguracion().getEntrada(nombrePartida);
            long rc = sesion.getOperaciones().recordCount(ent.getIdTabla());
            BigDecimal ret = BigDecimal.ZERO;
            int i = 1;
            while ((long)i <= rc) {
                ret = ret.add(new BigDecimal(sesion.getOperaciones().obtenerPartidaIndexada(nombrePartida, i).trim()));
                ++i;
            }
            if (numDecimales == 0) {
                return ret;
            }
            return ret.setScale(numDecimales, 4);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public int registrosDeTabla(ISesion sesion, Object[] vParametros) throws ExceptionMotor {
        return (int)sesion.getOperaciones().recordCount(vParametros[0].toString());
    }
}

