/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.procesadorReglas;

import es.aeat.pftw.mtrc.IAop;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.procesadorReglas.ValidaNif;
import es.aeat.pftw.mtrc.tipos.DateMotor;
import es.aeat.pftw.mtrc.tipos.TipoDatosCampoValor;
import es.aeat.pftw.mtrc.utilidades.Formatear;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.utilidades.Validaciones;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Comprobaciones
implements IAop,
Serializable {
    private static final long serialVersionUID = 1L;
    private static ValidaNif validarNif = null;
    private final int LONGITUD_MODELO = 3;

    @Override
    public void dispose() throws ExceptionMotor {
        if (validarNif != null) {
            validarNif.dispose();
            validarNif = null;
        }
    }

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            validarNif = (ValidaNif)FuncionesUtiles.getFuncionesUtiles().getInstancia(ValidaNif.class, new Object[0]);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public String dameAdministracion(String nif) throws ExceptionMotor {
        try {
            Class<?> clase = Class.forName("es.aeat.MRBV_APCO.RUTIIMR");
            Object instancia = clase.newInstance();
            Method metodo = clase.getMethod("getNIU", String.class);
            Object ret = metodo.invoke(instancia, nif);
            metodo = ret.getClass().getMethod("getAdm", new Class[0]);
            return metodo.invoke(ret, new Object[0]).toString();
        }
        catch (InvocationTargetException ie) {
            return "";
        }
        catch (ClassNotFoundException ce) {
            throw new ExceptionMotor("No dispongo de las librerias para hacer esta funci\u00f3n!!!");
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public String dameNIU(String nif) throws ExceptionMotor {
        try {
            Class<?> clase = Class.forName("es.aeat.MRBV_APCO.RUTIIMR");
            Object instancia = clase.newInstance();
            Method metodo = clase.getMethod("getNIU", String.class);
            Object ret = metodo.invoke(instancia, nif);
            metodo = ret.getClass().getMethod("getCodigo", new Class[0]);
            return metodo.invoke(ret, new Object[0]).toString();
        }
        catch (InvocationTargetException ie) {
            return "";
        }
        catch (ClassNotFoundException ce) {
            throw new ExceptionMotor("No dispongo de las librerias para hacer esta funci\u00f3n!!!");
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public boolean compNumJust(String modelo, String numJust) throws ExceptionMotor {
        try {
            boolean res = false;
            int digitoControl = 0;
            String numJustFinal = "";
            res = modelo.length() == 0 ? false : ((digitoControl = this.filtroNSerie(numJust, numJustFinal)) == 0 ? false : numJust.substring(0, 3).equals(modelo));
            return res;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public boolean comprobarNumeroJustificante(String numJust) throws ExceptionMotor {
        try {
            boolean res = false;
            int digitoControl = 0;
            String numJustFinal = "";
            res = numJust.equalsIgnoreCase("0") ? true : (digitoControl = this.filtroNSerie(numJust, numJustFinal)) != 0;
            return res;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public String generaNumeroDeReferenciaMI(String nif, String fechaInicioCampa\u00f1a) throws ExceptionMotor {
        return this.generaNumeroDeReferencia(nif, "9998", fechaInicioCampa\u00f1a);
    }

    public String generaNumeroDeReferencia(String nif, String fechaInicioCampa\u00f1a) throws ExceptionMotor {
        return this.generaNumeroDeReferencia(nif, "9999", fechaInicioCampa\u00f1a);
    }

    private String generaNumeroDeReferencia(String nif, String sNumRef, String fechaInicioCampa\u00f1a) throws ExceptionMotor {
        try {
            String comp;
            String nIF;
            int i = 0;
            String digitos = nif;
            if (digitos.length() == 0) {
                throw new Exception("Debe rellenar el Nif para calcular el numero de referencia");
            }
            if (Character.isLetter((digitos = digitos.substring(0, 9)).charAt(8)) && Character.isLetter(digitos.charAt(0))) {
                nIF = "9";
                nIF = nIF + digitos.substring(1, 8);
            } else {
                nIF = Character.isLetter(digitos.charAt(8)) && !Character.isLetter(digitos.charAt(0)) ? digitos.substring(0, 8) : digitos.substring(1, 9);
            }
            sNumRef = sNumRef + nIF;
            Date f = new Date();
            DateFormat df = DateFormat.getDateInstance(3);
            String fechasistema = df.format(f);
            SimpleDateFormat formatter = new SimpleDateFormat("dd/mm/yyyy");
            Date valorFecha = formatter.parse(fechasistema);
            String aux = comp = formatter.format(valorFecha);
            fechasistema = aux.substring(0, 2);
            fechasistema = fechasistema + aux.substring(3, 5);
            fechasistema = fechasistema + "20" + aux.substring(8, 10);
            String sResta = "";
            long lTotalDias = 0L;
            lTotalDias = this.comparaFechas(fechaInicioCampa\u00f1a, fechasistema) == 1 ? this.totalDias(fechasistema, fechaInicioCampa\u00f1a) : this.totalDias(fechaInicioCampa\u00f1a, fechasistema);
            digitos = sResta = Long.toString(Math.abs(lTotalDias));
            if (digitos.length() == 1) {
                digitos = "0" + digitos;
            }
            sNumRef = sNumRef + digitos.substring(0, 2);
            Calendar ahora = Calendar.getInstance();
            long lTotal = (long)(ahora.get(11) + 1) * (long)(ahora.get(12) + 1) * (long)(ahora.get(13) + 1);
            String sHora = "";
            digitos = sHora = Long.toString(lTotal);
            for (i = sHora.length() - 1; i < 4; ++i) {
                digitos = "0" + digitos;
            }
            sNumRef = sNumRef + digitos;
            i = this.modulo7(sNumRef);
            String dG = Integer.toString(i);
            return sNumRef + dG;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    private int modulo7(String num) throws Exception {
        int c = 0;
        int m = 1;
        for (int i = 0; i < num.length(); ++i) {
            if (num.substring(i, i + 1).equals(".")) continue;
            int b = m * c + Integer.parseInt(num.substring(i, i + 1));
            c = b % 7;
            m = 10;
        }
        if (c != 0) {
            c = 7 - c;
            return c;
        }
        return 0;
    }

    private int comparaFechas(String fecha1, String fecha2) {
        if (!this.depuraFecha(fecha1) || !this.depuraFecha(fecha2)) {
            return -2;
        }
        Fecha fe1 = this.fechaaInt(fecha1);
        if (!fe1.valida()) {
            return -2;
        }
        Fecha fe2 = this.fechaaInt(fecha2);
        if (!fe2.valida()) {
            return -2;
        }
        if (fe1.anno() < fe2.anno()) {
            return -1;
        }
        if (fe1.anno() > fe2.anno()) {
            return 1;
        }
        if (fe1.mes() < fe2.mes()) {
            return -1;
        }
        if (fe1.mes() > fe2.mes()) {
            return 1;
        }
        if (fe1.dia() < fe2.dia()) {
            return -1;
        }
        if (fe1.dia() > fe2.dia()) {
            return 1;
        }
        return 0;
    }

    private boolean depuraFecha(String fecha) {
        int[] diasMes = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        Fecha fe = this.fechaaInt(fecha);
        if (!fe.valida()) {
            return false;
        }
        diasMes[1] = fe.anno() % 4 == 0 && (fe.anno() % 100 != 0 || fe.anno() % 400 == 0) ? 29 : 28;
        if (fe.anno() < 0) {
            return false;
        }
        if (fe.mes() < 1 || fe.mes() > 12) {
            return false;
        }
        return fe.dia() >= 1 && fe.dia() <= diasMes[fe.mes() - 1];
    }

    private Fecha fechaaInt(String fecha) {
        boolean valida = false;
        int dia = 0;
        int mes = 0;
        int anno = 0;
        fecha = fecha.replaceAll("/", "");
        if ((fecha = fecha.replaceAll("-", "")).length() != 8) {
            valida = false;
        } else {
            valida = true;
            dia = Integer.parseInt(fecha.substring(0, 2));
            mes = Integer.parseInt(fecha.substring(2, 4));
            anno = Integer.parseInt(fecha.substring(4, 8));
        }
        return new Fecha(dia, mes, anno, valida);
    }

    private long totalDias(String fecha1, String fecha2) {
        int[] diasMes = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        if (!this.depuraFecha(fecha1) || !this.depuraFecha(fecha2)) {
            return -1L;
        }
        Fecha fe1 = this.fechaaInt(fecha1);
        if (!fe1.valida()) {
            return -1L;
        }
        Fecha fe2 = this.fechaaInt(fecha2);
        if (!fe2.valida()) {
            return -1L;
        }
        int tipofecha = this.comparaFechas(fecha1, fecha2);
        if (tipofecha == -2 || tipofecha == 1) {
            return -1L;
        }
        if (tipofecha == 0) {
            return 0L;
        }
        long total = 0L;
        if (fe1.anno() < fe2.anno()) {
            int i;
            diasMes[1] = fe1.anno() % 4 == 0 && (fe1.anno() % 100 != 0 || fe1.anno() % 400 == 0) ? 29 : 28;
            total = diasMes[fe1.mes() - 1] - fe1.dia();
            for (i = fe1.mes(); i < 12; ++i) {
                total += (long)diasMes[i];
            }
            for (i = fe1.anno() + 1; i < fe2.anno(); ++i) {
                if (i % 4 == 0 && (i % 100 != 0 || i % 400 == 0)) {
                    total += 366L;
                    continue;
                }
                total += 365L;
            }
            diasMes[1] = fe2.anno() % 4 == 0 && (fe2.anno() % 100 != 0 || fe2.anno() % 400 == 0) ? 29 : 28;
            for (i = 1; i < fe2.mes(); ++i) {
                total += (long)diasMes[i - 1];
            }
            total += (long)fe2.dia();
        } else {
            diasMes[1] = fe1.anno() % 4 == 0 && (fe1.anno() % 100 != 0 || fe1.anno() % 400 == 0) ? 29 : 28;
            if (fe1.mes() < fe2.mes()) {
                total += (long)(diasMes[fe1.mes() - 1] - fe1.dia());
                for (int i = fe1.mes(); i < fe2.mes() - 1; ++i) {
                    total += (long)diasMes[i];
                }
                total += (long)fe2.dia();
            } else {
                total = fe2.dia() - fe1.dia();
            }
        }
        return total;
    }

    public boolean nifFisica(Object[] vParametros) throws ExceptionMotor {
        try {
            return this.nifFisica(vParametros[0].toString());
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public boolean nifFisica(String sNif) throws ExceptionMotor {
        try {
            int tipoNif = this.getValidarNif().checkNif(sNif);
            return tipoNif == 1 || tipoNif == 4 || tipoNif == 3 || tipoNif == 2;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public boolean nifJuridica(Object[] vParametros) throws ExceptionMotor {
        try {
            return this.nifJuridica(vParametros[0].toString());
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public boolean nifJuridica(String sNif) throws ExceptionMotor {
        try {
            int tipoNif = this.getValidarNif().checkNif(sNif);
            return tipoNif == 21 || tipoNif == 23 || tipoNif == 20 || tipoNif == 22;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public boolean nifValido(Object[] vParametros) throws ExceptionMotor {
        try {
            String sNif = vParametros[0].toString();
            if (sNif.length() == 0) {
                return true;
            }
            int tipoNif = this.getValidarNif().checkNifSinFormatear(sNif);
            return tipoNif > 0;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public boolean nombreValido(Object[] vParametros) throws ExceptionMotor {
        try {
            if (vParametros.length > 0) {
                String nombreValido = vParametros[0].toString();
                if (nombreValido.length() == 0) {
                    return false;
                }
                if (nombreValido.indexOf(32, 0) == -1) {
                    return false;
                }
                char[] letras = nombreValido.toCharArray();
                if (letras[0] == ' ') {
                    return false;
                }
                return (letras[0] != letras[1] || letras[0] != letras[2]) && nombreValido.length() != 0;
            }
            return false;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public boolean validarFecha(Object[] vParametros) throws ExceptionMotor {
        String fdt = "yyyyMMdd";
        boolean resultado = false;
        try {
            String fechaAComparar = vParametros[0].toString();
            String fechaLimiteInferior = "";
            String fechaLimiteSuperior = "";
            try {
                fechaLimiteInferior = ((BigDecimal)vParametros[1]).intValue() + "0101";
            }
            catch (Exception ex) {
                fechaLimiteInferior = ((Double)vParametros[1]).intValue() + "0101";
            }
            try {
                fechaLimiteSuperior = ((BigDecimal)vParametros[2]).intValue() + "1231";
            }
            catch (Exception ex) {
                fechaLimiteSuperior = ((Double)vParametros[2]).intValue() + "1231";
            }
            boolean validafechaAComparar = this.esFechaInvertida(fechaAComparar);
            if (validafechaAComparar) {
                boolean validafechaLimiteInferior = this.esFechaInvertida(fechaLimiteInferior);
                boolean validafechaLimiteSuperior = this.esFechaInvertida(fechaLimiteSuperior);
                if (validafechaLimiteInferior && validafechaLimiteSuperior && validafechaAComparar) {
                    SimpleDateFormat sdf = new SimpleDateFormat(fdt);
                    sdf.setLenient(false);
                    Date dateAComparar = sdf.parse(fechaAComparar);
                    Date dateLimiteInferior = sdf.parse(fechaLimiteInferior);
                    Date dateLimiteSuperior = sdf.parse(fechaLimiteSuperior);
                    if (dateAComparar.compareTo(dateLimiteInferior) >= 0 && dateLimiteSuperior.compareTo(dateAComparar) >= 0) {
                        resultado = true;
                    }
                }
            }
            return resultado;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public int abs(int d) throws ExceptionMotor {
        try {
            return Math.abs(d);
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public double abs(double d) throws ExceptionMotor {
        try {
            return Math.abs(d);
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public long abs(long d) throws ExceptionMotor {
        try {
            return Math.abs(d);
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public Object abs(Object o) throws ExceptionMotor {
        try {
            if (o instanceof String) {
                return this.rnd(o.toString());
            }
            if (o instanceof BigDecimal) {
                return this.abs((BigDecimal)o);
            }
            return Math.abs(Double.valueOf(o.toString()));
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public BigDecimal abs(BigDecimal bg) throws ExceptionMotor {
        try {
            return bg.abs();
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public String abs(String str) throws ExceptionMotor {
        try {
            return this.abs(new BigDecimal(str.trim())).toString();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public boolean nifRegimenAtribucionRentas(Object[] vParametros) throws ExceptionMotor {
        try {
            return this.getValidarNif().checkNif(vParametros[0].toString()) == 23;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public int dameTipoNif(Object[] vParametros) throws ExceptionMotor {
        try {
            return this.getValidarNif().checkNif(vParametros[0].toString());
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public Boolean valCntaPCampos(Object[] vParametros) throws ExceptionMotor {
        try {
            boolean res = false;
            String sCuenta = "";
            if (vParametros.length == 4) {
                String entidad = vParametros[0].toString();
                String oficina = vParametros[1].toString();
                String dc = vParametros[2].toString();
                String cuenta = vParametros[3].toString();
                if (entidad.compareTo("") == 0 || oficina.compareTo("") == 0 || dc.compareTo("") == 0 || cuenta.compareTo("") == 0) {
                    res = true;
                } else {
                    int iErrorCuenta;
                    sCuenta = entidad.trim() + oficina.trim() + dc.trim() + cuenta.trim();
                    if (sCuenta.length() == 20 && !sCuenta.equalsIgnoreCase("00000000000000000000") && (iErrorCuenta = this.getValidarNif().controlaCuenta(sCuenta)) == 0) {
                        res = true;
                    }
                }
            }
            return res;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public Boolean valCntaPCadena(Object[] vParametros) throws ExceptionMotor {
        try {
            boolean res = false;
            String sCuenta = "";
            sCuenta = sCuenta + vParametros[0].toString();
            if (sCuenta.length() == 0) {
                res = true;
            } else if (sCuenta.length() == 20) {
                return this.valCntaPCampos(new Object[]{sCuenta.substring(0, 4), sCuenta.substring(4, 8), sCuenta.substring(8, 10), sCuenta.substring(10)});
            }
            return res;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public boolean nombreyNif(Object[] vParametros) throws ExceptionMotor {
        try {
            String parametroNif = vParametros[0].toString();
            String parametroNombre = vParametros[1].toString();
            if (parametroNif.length() > 0 && parametroNombre.length() > 0) {
                char[] letras = parametroNombre.toCharArray();
                if (this.nifFisica(parametroNif)) {
                    if (parametroNombre.indexOf(32, 0) == -1) {
                        return false;
                    }
                    if (letras[0] == ' ') {
                        return false;
                    }
                    if (letras[0] == letras[1] && letras[0] == letras[2]) {
                        return false;
                    }
                    if (!Validaciones.getValidaciones().esAlfabeticoAEAT(parametroNombre)) {
                        return false;
                    }
                    if (Validaciones.getValidaciones().esNumericaAEAT(parametroNombre)) {
                        return false;
                    }
                } else {
                    if (this.getValidarNif().checkNif(parametroNif) == 0) {
                        return false;
                    }
                    if (letras[0] == ' ') {
                        return false;
                    }
                }
                for (int i = 1; i < letras.length; ++i) {
                    if (letras[i] != ' ' || letras[i - 1] != ' ') continue;
                    return false;
                }
            }
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public boolean caracteresDiferentes(String sCadena) throws ExceptionMotor {
        try {
            char sCaracter = sCadena.substring(0, 1).toCharArray()[0];
            int i = 0;
            if (sCaracter >= '0' && sCaracter <= '9') {
                for (i = 0; i <= 7 && sCaracter == sCadena.substring(i + 1, 1).toCharArray()[0]; ++i) {
                }
                return i != 8;
            }
            return true;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public boolean esFechaInvertida(String sCad) throws ExceptionMotor {
        return this.esFecha(sCad, "yyyyMMdd");
    }

    public boolean esFecha(String sCad, String fdt) throws ExceptionMotor {
        if (fdt.indexOf("m") != -1) {
            FuncionesUtiles.getFuncionesUtiles().muestraAviso("Pattern de fecha incorrecto " + fdt + " se sustituye por " + fdt.replaceAll("m", "M"));
            fdt = fdt.replaceAll("m", "M");
        }
        if (fdt.contains("/") && sCad.contains("-")) {
            sCad = sCad.replaceAll("-", "/");
        } else if (fdt.contains("-") && sCad.contains("/")) {
            sCad = sCad.replaceAll("/", "-");
        }
        if (!fdt.contains("/")) {
            sCad = sCad.replaceAll("/", "");
        }
        if (!fdt.contains("-")) {
            sCad = sCad.replaceAll("-", "");
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(fdt);
            sdf.setLenient(false);
            sdf.parse(sCad);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private int filtroNSerie(String numSerie, String numSerieFinal) throws ExceptionMotor {
        int digitoControl;
        String numeroSerie = numSerie;
        String numeroSerieFinal = numSerieFinal;
        int longNSerie = 0;
        try {
            longNSerie = numeroSerie.length();
            if (longNSerie == 13) {
                int num;
                digitoControl = 0;
                numeroSerieFinal = "";
                numeroSerieFinal = this.obtenerNSerie(numeroSerie);
                longNSerie = numeroSerieFinal.length();
                if (longNSerie == 13 && (num = this.comprobarDigitoControl(numeroSerieFinal)) == -1) {
                    digitoControl = 1;
                }
            } else {
                digitoControl = 0;
            }
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
        return digitoControl;
    }

    private int comprobarDigitoControl(String nSerie) throws ExceptionMotor {
        String numero = "";
        try {
            double dC = Double.parseDouble(nSerie.substring(nSerie.length() - 1, nSerie.length()));
            numero = nSerie.substring(0, nSerie.length() - 1);
            double valor = Double.parseDouble(numero);
            double division = (long)(valor / 7.0);
            double calcDC = valor - division * 7.0;
            calcDC = 7.0 - calcDC;
            if (calcDC == 7.0) {
                calcDC = 0.0;
            }
            if (calcDC == dC) {
                return -1;
            }
            return 0;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    private int nCarsOK(String cadena) throws ExceptionMotor {
        int nCars = 0;
        int numero = 0;
        try {
            for (int i = 0; i < cadena.length(); ++i) {
                numero = Integer.parseInt(cadena.substring(i, i + 1));
                if (numero < 0 && numero > 9) continue;
                ++nCars;
            }
            return nCars;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    private String obtenerNSerie(String numeroSerie) throws ExceptionMotor {
        String numeroSerieFinal;
        String linea = "";
        String sCad = "";
        sCad = numeroSerie;
        try {
            int ixSrc = 0;
            int ixLin = 0;
            numeroSerieFinal = "";
            linea = "";
            for (ixSrc = 0; ixSrc < sCad.length(); ++ixSrc) {
                String cChar = sCad.substring(ixSrc, ixSrc + 1);
                if (cChar.equalsIgnoreCase(" ")) continue;
                if (!cChar.equalsIgnoreCase(" ") && ixLin < 13) {
                    linea = linea + cChar;
                    continue;
                }
                if (this.nCarsOK(linea) <= this.nCarsOK(numeroSerieFinal)) continue;
                numeroSerieFinal = linea;
            }
            if (this.nCarsOK(linea) > this.nCarsOK(numeroSerieFinal)) {
                numeroSerieFinal = linea;
            }
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
        return numeroSerieFinal;
    }

    public int rnd(int d) throws ExceptionMotor {
        try {
            return Math.round(d);
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public double rnd(double d) throws ExceptionMotor {
        try {
            return Math.round(d);
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public long rnd(long d) throws ExceptionMotor {
        try {
            return Math.round(d);
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public BigDecimal rnd(BigDecimal b) throws ExceptionMotor {
        try {
            return this.rnd(b, new BigDecimal(2));
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public BigDecimal rnd(BigDecimal b, BigDecimal cuantos) throws ExceptionMotor {
        try {
            return new BigDecimal(b.toString().trim()).setScale(cuantos.intValue(), 4);
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public String rnd(String s) throws ExceptionMotor {
        try {
            return this.rnd(new BigDecimal(s.trim())).toString();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public String rnd(String s, String cuantos) throws ExceptionMotor {
        try {
            return this.rnd(new BigDecimal(s.trim()), new BigDecimal(cuantos.trim())).toString();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public Object rnd(Object o) throws ExceptionMotor {
        try {
            return new Double(Math.round(new Double(o.toString())));
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public Object rnd(Object o, Object cuantos) throws ExceptionMotor {
        try {
            if (o instanceof String) {
                return this.rnd(o.toString(), cuantos.toString());
            }
            if (o instanceof BigDecimal) {
                return this.rnd((BigDecimal)o, (BigDecimal)cuantos);
            }
            return Formatear.getFormatear().redondea(o, cuantos);
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public boolean cabeceraNumeroJustificante(Object[] vParametros) throws ExceptionMotor {
        try {
            String sModelo = vParametros[0].toString();
            String sNumJust = vParametros[1].toString();
            if (sNumJust.equalsIgnoreCase("0")) {
                return true;
            }
            if (sNumJust.length() < 3) {
                return false;
            }
            return sNumJust.substring(0, 3).equals(sModelo);
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public String valorAbsoluto(String obj) throws ExceptionMotor {
        try {
            return this.abs(obj);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public Object valorAbsoluto(Object obj) throws ExceptionMotor {
        try {
            if (obj instanceof String) {
                return this.abs(obj.toString());
            }
            if (obj instanceof Integer) {
                return this.abs((Integer)obj);
            }
            if (obj instanceof Double) {
                return this.abs((Double)obj);
            }
            if (obj instanceof BigDecimal) {
                return this.abs((BigDecimal)obj);
            }
            return this.abs(obj);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public Boolean comprobarNombreFisica(Object[] vParametros) throws ExceptionMotor {
        try {
            return new Boolean(this.nombreyNif(new Object[]{"00000101D", vParametros[0].toString()}));
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public boolean emailCorrecto(Object[] vParametros) throws ExceptionMotor {
        try {
            String correo = vParametros[0].toString();
            Pattern pat = null;
            Matcher mat = null;
            String a = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
            pat = Pattern.compile(a);
            mat = pat.matcher(correo);
            return mat.find();
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public boolean compararFecha(Object[] vParametros) throws ExceptionMotor {
        try {
            String cad1 = vParametros[0].toString();
            String cad2 = vParametros[1].toString();
            String comparador = vParametros[2].toString();
            if (comparador.equalsIgnoreCase("<>") || comparador.equalsIgnoreCase("!=") && !cad1.equalsIgnoreCase(cad2)) {
                return true;
            }
            if (comparador.indexOf(62) > -1 && cad1.compareTo(cad2) > 0) {
                return true;
            }
            if (comparador.indexOf(60) > -1 && cad1.compareTo(cad2) < 0) {
                return true;
            }
            return comparador.indexOf(61) > -1 && cad1.compareTo(cad2) == 0;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public void setValidarNif(ValidaNif validarNif) throws ExceptionMotor {
        Comprobaciones.validarNif = validarNif;
    }

    public ValidaNif getValidarNif() {
        return validarNif;
    }

    public boolean validarCodigoPostal(Object[] vParametros) throws ExceptionMotor {
        return this.compruebaCodPostal(null, vParametros[0].toString());
    }

    public boolean compruebaCodPostal(ISesion sesion, String codPostal) throws ExceptionMotor {
        try {
            if (codPostal.length() != 5) {
                return false;
            }
            for (int i = 0; i < codPostal.length(); ++i) {
                if (Character.isDigit(codPostal.charAt(i))) continue;
                return false;
            }
            return Integer.valueOf(codPostal) >= 1001 && Integer.valueOf(codPostal) <= 52999;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public boolean compruebaCPconProvi(ISesion sesion, String EntradaProvinciasDatosAuxiliares, String codPostal, String codProvincia) throws ExceptionMotor {
        try {
            if (!this.compruebaCodPostal(sesion, codPostal)) {
                return true;
            }
            if (codProvincia.trim().length() == 0 || codProvincia.trim().equalsIgnoreCase("00")) {
                return true;
            }
            int pos = this.existeCodProvincia(sesion, EntradaProvinciasDatosAuxiliares, codPostal.substring(0, 2));
            if (pos == -1) {
                throw new Exception("Provincia con Codigo " + codPostal.substring(0, 2) + " no existe en Tabla de provincias!!!");
            }
            return sesion.getModelo().getGestorDatosAuxiliares().getTabla(EntradaProvinciasDatosAuxiliares).get(pos).getNombreCampo().trim().equalsIgnoreCase(codProvincia);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public boolean compruebaProvincia(ISesion sesion, String EntradaProvinciasDatosAuxiliares, String t1PROVI) throws ExceptionMotor {
        try {
            return this.existeCodProvincia(sesion, EntradaProvinciasDatosAuxiliares, t1PROVI) != -1;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public int existeCodProvincia(ISesion sesion, String EntradaProvinciasDatosAuxiliares, String codProvincia) throws ExceptionMotor {
        try {
            return TipoDatosCampoValor.indiceListaContieneCampo(sesion.getModelo().getGestorDatosAuxiliares().getTabla(EntradaProvinciasDatosAuxiliares), codProvincia);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public boolean hayRegistros(ISesion sesion, String nombreTabla) throws ExceptionMotor {
        try {
            return sesion.getOperaciones().recordCount(nombreTabla) > 0L;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public boolean esEntero(String valor) throws ExceptionMotor {
        try {
            try {
                Integer.valueOf(valor);
            }
            catch (Exception ex) {
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public boolean validaMovil(String telefonoMovil) {
        return (telefonoMovil.startsWith("6") || telefonoMovil.startsWith("7") || telefonoMovil.startsWith("8")) && telefonoMovil.trim().length() == 9;
    }

    public boolean validaTeleFax(String telefonoFijo) {
        return !telefonoFijo.startsWith("0") && telefonoFijo.trim().length() == 9;
    }

    public boolean validaTelefono(String telefono) {
        return this.validaMovil(telefono) || this.validaTeleFax(telefono);
    }

    public int validaCuentaCorriente(String cuenta) throws ExceptionMotor {
        try {
            cuenta = cuenta.replaceAll("/", "-");
            if (cuenta.length() == 20 && cuenta.indexOf("-") == -1) {
                cuenta = cuenta.substring(0, 4) + "-" + cuenta.substring(4, 8) + "-" + cuenta.substring(8, 10) + "-" + cuenta.substring(10);
            }
            if (cuenta.startsWith("0000")) {
                return 1;
            }
            return this.validaCuentaCliente(cuenta);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public Integer validaCuentaCliente(String cad) throws ExceptionMotor {
        try {
            int[] peso = new int[]{6, 3, 7, 9, 10, 5, 8, 4, 2, 1};
            long suma = 0L;
            long mod = 0L;
            if (cad.length() > 23) {
                return 0;
            }
            if (cad == null | cad.length() != 23) {
                return 1;
            }
            cad = this.desformateaCuentaBancaria(cad, 20);
            char[] datos = cad.toCharArray();
            int i = 7;
            int j = 0;
            while (i >= 0) {
                suma += (long)((datos[i] - 48) * peso[j]);
                --i;
                ++j;
            }
            mod = Math.abs(suma % 11L - 11L);
            if (mod == 10L) {
                mod = 1L;
            }
            if (mod == 11L) {
                mod = 0L;
            }
            if (mod != (long)(datos[8] - 48)) {
                return 1;
            }
            suma = 0L;
            i = 19;
            j = 0;
            while (i >= 10) {
                suma += (long)((datos[i] - 48) * peso[j]);
                --i;
                ++j;
            }
            mod = Math.abs(suma % 11L - 11L);
            if (mod == 10L) {
                mod = 1L;
            }
            if (mod == 11L) {
                mod = 0L;
            }
            if (mod != (long)(datos[9] - 48)) {
                return 2;
            }
            return 0;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public boolean validaIBAN(String cad) throws ExceptionMotor {
        try {
            if (cad.length() < 14 || cad.length() > 34) {
                return false;
            }
            if (!(Validaciones.getValidaciones().esAlfabetico(cad.charAt(0)) && Validaciones.getValidaciones().esAlfabetico(cad.charAt(1)) && Validaciones.getValidaciones().esNumerica(cad.charAt(2)) && Validaciones.getValidaciones().esNumerica(cad.charAt(3)))) {
                return false;
            }
            for (int i = 4; i < cad.length(); ++i) {
                if (Validaciones.getValidaciones().esAlfabetico(cad.charAt(i)) || Validaciones.getValidaciones().esNumerica(cad.charAt(i))) continue;
                return false;
            }
            String iban = cad.substring(4) + cad.substring(0, 2) + "00";
            String ibanNum = "";
            for (byte c : iban.getBytes()) {
                ibanNum = Validaciones.getValidaciones().esNumerica((char)c) ? ibanNum + (char)c : ibanNum + String.valueOf(c - 55);
            }
            BigDecimal val = new BigDecimal(ibanNum);
            val = val.divideAndRemainder(new BigDecimal(97))[1];
            return (val = new BigDecimal(98).subtract(val)).intValue() == Integer.valueOf(cad.substring(2, 4)).intValue();
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public String desformateaCuentaBancaria(String cta, int len) throws ExceptionMotor {
        try {
            String valor = cta;
            String ret = "";
            for (int i = 0; i < valor.length(); ++i) {
                if (!FuncionesUtiles.getFuncionesUtiles().esNumerico(valor.substring(i, i + 1))) continue;
                ret = ret + valor.substring(i, i + 1);
            }
            while (ret.length() < len) {
                ret = ret + "0";
            }
            return ret;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public Boolean superaUnAnno(String fechaInicio, String fechaFinal) throws ExceptionMotor {
        try {
            Date dfechaInicio = new DateMotor(fechaInicio).getDate();
            GregorianCalendar calfechaInicio = new GregorianCalendar();
            calfechaInicio.setLenient(false);
            Date dfechaFinal = new DateMotor(fechaFinal).getDate();
            if (dfechaFinal == null || dfechaInicio == null) {
                return true;
            }
            GregorianCalendar calfechaFinal = new GregorianCalendar();
            calfechaFinal.setLenient(false);
            calfechaFinal.setTime(dfechaFinal);
            calfechaInicio.setTime(dfechaInicio);
            if (calfechaInicio.get(5) == 29 && calfechaInicio.get(2) == 1) {
                ((Calendar)calfechaInicio).add(5, 1);
            }
            ((Calendar)calfechaInicio).add(1, 1);
            ((Calendar)calfechaInicio).add(6, -1);
            return calfechaFinal.after(calfechaInicio);
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public Boolean inferiorUnAnno(String fechaInicio, String fechaFinal) throws ExceptionMotor {
        try {
            Date dfechaInicio = new DateMotor(fechaInicio).getDate();
            GregorianCalendar calfechaInicio = new GregorianCalendar();
            calfechaInicio.setLenient(false);
            Date dfechaFinal = new DateMotor(fechaFinal).getDate();
            if (dfechaFinal == null || dfechaInicio == null) {
                return true;
            }
            GregorianCalendar calfechaFinal = new GregorianCalendar();
            calfechaFinal.setLenient(false);
            calfechaFinal.setTime(dfechaFinal);
            calfechaInicio.setTime(dfechaInicio);
            if (calfechaInicio.get(5) == 29 && calfechaInicio.get(2) == 1) {
                ((Calendar)calfechaInicio).add(5, 1);
            }
            ((Calendar)calfechaInicio).add(1, 1);
            ((Calendar)calfechaInicio).add(6, -1);
            boolean ret = calfechaFinal.before(calfechaInicio);
            return ret;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public Integer dameEjercicio(String argumento) throws ExceptionMotor {
        try {
            int retorna = 0;
            Date dargumento = new DateMotor(argumento).getDate();
            if (dargumento != null) {
                try {
                    GregorianCalendar calargumento = new GregorianCalendar();
                    calargumento.setLenient(false);
                    calargumento.setTime(dargumento);
                    retorna = calargumento.get(1);
                }
                catch (IllegalArgumentException e) {
                    retorna = 0;
                }
            }
            return retorna;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public Integer establecerNumeroDias(String fechaIni, String fechaFin) throws ExceptionMotor {
        try {
            int periodo = 0;
            GregorianCalendar inicio = new GregorianCalendar();
            GregorianCalendar termina = new GregorianCalendar();
            GregorianCalendar inicioMasUnAnno = new GregorianCalendar();
            inicio.setLenient(false);
            termina.setLenient(false);
            inicioMasUnAnno.setLenient(false);
            Date dfechaIni = new DateMotor(fechaIni).getDate();
            Date dfechaFin = new DateMotor(fechaFin).getDate();
            inicio.setTime(dfechaIni);
            termina.setTime(dfechaFin);
            inicioMasUnAnno.setTime(inicio.getTime());
            ((Calendar)inicioMasUnAnno).add(1, 1);
            ((Calendar)inicioMasUnAnno).add(6, -1);
            if (inicio.after(termina)) {
                return -1;
            }
            periodo = termina.get(5) == inicioMasUnAnno.get(5) && termina.get(2) == inicioMasUnAnno.get(2) && termina.get(1) == inicioMasUnAnno.get(1) ? 365 : (inicio.get(1) == termina.get(1) ? termina.get(6) - inicio.get(6) + 1 : ((Calendar)inicio).getMaximum(6) - inicio.get(6) + termina.get(6));
            return periodo;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public String establecerEj(String fechaIni, String fechaFin) throws ExceptionMotor {
        try {
            boolean periodoInferiorAnno;
            Date dfechaIni = new DateMotor(fechaIni).getDate();
            Date dfechaFin = new DateMotor(fechaFin).getDate();
            GregorianCalendar inicio = new GregorianCalendar();
            GregorianCalendar termina = new GregorianCalendar();
            inicio.setLenient(false);
            termina.setLenient(false);
            inicio.setTime(dfechaIni);
            termina.setTime(dfechaFin);
            inicio.clear(11);
            termina.clear(11);
            if (inicio.after(termina)) {
                return "0";
            }
            GregorianCalendar inicioMasUnAnno = new GregorianCalendar();
            inicioMasUnAnno.setLenient(false);
            inicioMasUnAnno.set(inicio.get(1), inicio.get(2), inicio.get(5));
            if (inicioMasUnAnno.get(5) == 29 && inicioMasUnAnno.get(2) == 1) {
                ((Calendar)inicioMasUnAnno).add(5, 1);
            }
            ((Calendar)inicioMasUnAnno).add(1, 1);
            ((Calendar)inicioMasUnAnno).add(6, -1);
            termina.clear(11);
            inicioMasUnAnno.clear(11);
            boolean empiezaUnoEnero = inicio.get(5) == 1 && inicio.get(2) == 0;
            boolean annocompleto = termina.get(5) == inicioMasUnAnno.get(5) && termina.get(2) == inicioMasUnAnno.get(2) && termina.get(1) == inicioMasUnAnno.get(1);
            boolean bl = periodoInferiorAnno = inicioMasUnAnno.after(termina) && !annocompleto;
            if (inicioMasUnAnno.before(termina)) {
                return "0";
            }
            if (annocompleto && empiezaUnoEnero) {
                return "1";
            }
            if (periodoInferiorAnno) {
                return "3";
            }
            return "2";
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public Boolean validarFechaPeriodo(String fechaInicial, String fechaInicioInicialValida, String fechainicialFinalValida) throws ExceptionMotor {
        try {
            Date dfechaInicial = new DateMotor(fechaInicial).getDate();
            Date dfechaInicioInicialValida = new DateMotor(fechaInicioInicialValida).getDate();
            Date dfechainicialFinalValida = new DateMotor(fechainicialFinalValida).getDate();
            if (dfechaInicial == null || dfechaInicioInicialValida == null || dfechainicialFinalValida == null) {
                return false;
            }
            GregorianCalendar calfechaInicial = new GregorianCalendar();
            GregorianCalendar calfechaInicioInicialValida = new GregorianCalendar();
            GregorianCalendar calfechainicialFinalValida = new GregorianCalendar();
            calfechaInicial.setLenient(false);
            calfechaInicioInicialValida.setLenient(false);
            calfechainicialFinalValida.setLenient(false);
            calfechaInicial.setTime(dfechaInicial);
            calfechaInicioInicialValida.setTime(dfechaInicioInicialValida);
            calfechainicialFinalValida.setTime(dfechainicialFinalValida);
            if (calfechaInicial.before(calfechaInicioInicialValida)) {
                return false;
            }
            if (calfechaInicial.after(calfechainicialFinalValida)) {
                return false;
            }
            return true;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public String convertirIntACadena(int valor) {
        return String.valueOf(valor);
    }

    class Fecha {
        private int mDia;
        private int mMes;
        private int mAnno;
        private boolean mValida = false;

        public int dia() {
            return this.mDia;
        }

        public int mes() {
            return this.mMes;
        }

        public int anno() {
            return this.mAnno;
        }

        public boolean valida() {
            return this.mValida;
        }

        public Fecha(int dia, int mes, int anno, boolean valida) {
            this.mDia = dia;
            this.mMes = mes;
            this.mAnno = anno;
            this.mValida = valida;
        }
    }
}

