/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.origenDatos.bbdd.jdbc;

import es.aeat.pftw.mtrc.configuracion.IGestorConfiguracion;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.origenDatos.IOrigenDatos;
import es.aeat.pftw.mtrc.origenDatos.IPersistencia;
import es.aeat.pftw.mtrc.tipos.TipoDatosCampoValor;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrp.configuracion.IRegEntrada;
import es.aeat.pftw.mtrp.configuracion.IRegRelacionada;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.puente.ITablaMotorEntrada;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampoValor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class Persistencia
implements IPersistencia,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<ITipoDatosCampoValor> posicionesTablas = null;

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
    }

    @Override
    public void dispose() throws ExceptionMotor {
    }

    @Override
    public boolean establece(IOrigenDatos objAPersistir, IOrigenDatos io, Object datos) throws ExceptionMotor {
        try {
            throw new ExceptionMotor("No se pudo volcar XML sobre estructura de BBDD");
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected void rellenaClavesActivas(ISesion sesion, String tabla) throws ExceptionMotor {
        try {
            IRegRelacionada relacionadas = sesion.getModelo().getGestorConfiguracion().getRelacionada(tabla);
            if (relacionadas != null) {
                List<String> listaRelaciondas = relacionadas.getTablaRelacionada();
                for (String tablaHija : listaRelaciondas) {
                    long claveActual = sesion.getOperaciones().obtenerClaveActiva(tablaHija);
                    if (claveActual <= 0L) continue;
                    this.posicionesTablas.add(new TipoDatosCampoValor(tablaHija, String.valueOf(claveActual)));
                    this.rellenaClavesActivas(sesion, tablaHija);
                }
            }
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Object obtener(ISesion sesion) throws ExceptionMotor {
        this.posicionesTablas = new ArrayList<ITipoDatosCampoValor>();
        try {
            String raiz = FuncionesUtiles.getFuncionesUtiles().dameNombreTablaRaiz(sesion.getModelo().getGestorConfiguracion());
            this.rellenaClavesActivas(sesion, raiz);
            Document doc = this.dameXMLVacioParaMotor(raiz);
            doc.replaceChild(this.creaNodo(sesion, doc, raiz, doc.getFirstChild()), doc.getFirstChild());
            Document document = doc;
            return document;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
        finally {
            try {
                for (ITipoDatosCampoValor pos : this.posicionesTablas) {
                    sesion.getOperaciones().move(pos.getNombreCampo(), Long.valueOf(pos.getValor()));
                }
            }
            catch (ExceptionMotor ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ExceptionMotor(ex);
            }
        }
    }

    protected boolean esEstadoPorDefecto(Object estado, IRegEntrada ent) throws Exception {
        if (estado == null || estado.toString().trim().length() == 0) {
            return true;
        }
        return ent.getEstadoInicial() == Integer.parseInt(estado.toString());
    }

    protected Node creaNodo(ISesion sesion, Document doc, String tabActual, Node nodoPadre) throws ExceptionMotor {
        try {
            IGestorConfiguracion gc = sesion.getModelo().getGestorConfiguracion();
            Element nodo = doc.createElement(tabActual);
            IRegEntrada ent = null;
            Node hijo = null;
            List<ITablaMotorEntrada> campos = sesion.getOperaciones().obtenerRegistroDatosTablaArrayList(tabActual);
            for (ITablaMotorEntrada tme : campos) {
                if (tme.getNombreEntrada().equalsIgnoreCase("ID") || tme.getNombreEntrada().equalsIgnoreCase("IDINF")) {
                    hijo = doc.createElement(tme.getNombreEntrada());
                    hijo.appendChild(doc.createTextNode(tme.getValor().toString()));
                    nodo.appendChild(hijo);
                    hijo = null;
                    continue;
                }
                ent = gc.getEntrada(tme.getNombreEntrada());
                if (ent == null || this.iguales(ent.getValorInicial(), tme.getValor().toString(), ent.getTipoDato()) && this.esEstadoPorDefecto(tme.getEstado(), ent)) continue;
                hijo = doc.createElement(tme.getNombreEntrada());
                if (!this.esEstadoPorDefecto(tme.getEstado(), ent)) {
                    hijo.setAttribute("ESTADO", tme.getEstado().toString());
                }
                hijo.appendChild(doc.createTextNode(tme.getValor().toString().trim()));
                nodo.appendChild(hijo);
                hijo = null;
            }
            IRegRelacionada relacionadas = sesion.getModelo().getGestorConfiguracion().getRelacionada(tabActual);
            if (relacionadas != null) {
                List<String> listaRelaciondas = relacionadas.getTablaRelacionada();
                for (String tablaHija : listaRelaciondas) {
                    long pos = sesion.getOperaciones().moveFirst(tablaHija);
                    if (pos <= 0L) continue;
                    do {
                        hijo = this.creaNodo(sesion, doc, tablaHija, nodo);
                        nodo.appendChild(hijo);
                        hijo = null;
                    } while (sesion.getOperaciones().moveIfHasNext(tablaHija));
                }
            }
            return nodo;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected boolean iguales(String valor1, String valor2, String tipo) {
        try {
            if (tipo.equalsIgnoreCase("DOBLE") || tipo.equalsIgnoreCase("BIGDECIMAL")) {
                if (valor1.trim().length() == 0) {
                    valor1 = "0";
                }
                if (valor2.trim().length() == 0) {
                    valor2 = "0";
                }
                return Double.parseDouble(valor1) == Double.parseDouble(valor2);
            }
            return valor1.equalsIgnoreCase(valor2);
        }
        catch (Exception ex) {
            FuncionesUtiles.getFuncionesUtiles().muestraAviso(ex);
            return valor1.equalsIgnoreCase(valor2);
        }
    }

    protected Document dameXMLVacioParaMotor(String nodoRaiz) throws ExceptionMotor {
        try {
            String str = "ISO-8859-1";
            String sDatos = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?><" + nodoRaiz + "></" + nodoRaiz + ">";
            InputSource iso = new InputSource(new InputStreamReader((InputStream)new ByteArrayInputStream(sDatos.getBytes(str)), Charset.forName(str)));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(iso);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }
}

