/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.origenDatos.bbdd.jdbc;

import es.aeat.pftw.mtrc.configuracion.IGestorConfiguracion;
import es.aeat.pftw.mtrc.configuracion.RegEntrada;
import es.aeat.pftw.mtrc.excepciones.NotImplementedException;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesionExtendida;
import es.aeat.pftw.mtrc.origenDatos.IOrigenDatos;
import es.aeat.pftw.mtrc.origenDatos.bbdd.jdbc.CacheTablasOrigenDatos;
import es.aeat.pftw.mtrc.puente.ITablaMotor;
import es.aeat.pftw.mtrc.puente.TablaMotorEntrada;
import es.aeat.pftw.mtrc.tipos.TipoDatosRegistro;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrp.configuracion.IRegEntrada;
import es.aeat.pftw.mtrp.configuracion.IRegTabla;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.puente.ITablaMotorEntrada;
import es.aeat.pftw.mtrp.tipos.ITipoDatosRegistro;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Jdbc
implements IOrigenDatos,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient Connection dBConexion = null;
    private String schema = null;
    protected final boolean logAccesosBBDD = false;
    protected CacheTablasOrigenDatos cacheOrigenDatos = null;
    public static final String terminacionEstado = "_E";
    private boolean controlOverflow = true;
    private transient ISesion sesion = null;
    private boolean enTransaccion = false;
    protected Boolean contadorExiste = null;
    protected String sSQL = "";
    private transient Statement consulta = null;
    private transient Statement consultaAux = null;
    private transient Statement consultaSoloLectura = null;
    private transient Statement consultaAuxSoloLectura = null;
    protected transient ResultSet recordSet = null;
    protected transient ResultSet recordSetAuxiliar = null;
    protected transient List<Object> listaRecordSetAbiertos = null;
    protected int differedWrite = 0;
    protected long idTablaRaiz = 1L;
    protected Map<String, String> criteriosOrdenacion = null;
    protected boolean origenDeDatosOrdenadoPorCriterio = false;
    protected final int maxGrupoPreparedStatement = 25;
    protected transient Map<String, PreparedStatement> grupoPreparedStatement = null;
    protected boolean flagEstoyEnMTRE = false;
    public static final int MODO_MAP = 0;
    public static final int MODO_LIST = 1;

    public Jdbc() {
        try {
            this.flagEstoyEnMTRE = Jdbc.class.getClassLoader().getResource("es/aeat/pftw/mtrc/origenDatos/bbdd/jdbc/Jdbc.class").toString().toUpperCase().contains("PFTW-MTRE");
        }
        catch (Exception ex) {
            this.flagEstoyEnMTRE = false;
        }
    }

    @Override
    public void dispose() throws ExceptionMotor {
        this.grupoPreparedStatement = null;
        this.cerrarAlmacenamiento();
        this.sesion = null;
    }

    public Boolean existeContador() throws ExceptionMotor {
        if (!this.sesion.isUsarContadorRegistros()) {
            return false;
        }
        if (this.contadorExiste == null) {
            this.contadorExiste = this.sesion.getModelo().getGestorConfiguracion().getEntrada("CON_REG") != null && this.sesion.getModelo().getGestorConfiguracion().getEntrada("MAX_REG") != null;
        }
        return this.contadorExiste;
    }

    @Override
    public ISesion getSesion() {
        return this.sesion;
    }

    @Override
    public void setSesion(ISesion sesion) {
        this.sesion = sesion;
    }

    @Override
    public long getIdTablaRaiz() {
        return this.idTablaRaiz;
    }

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            this.sesion = (ISesion)parametros[0];
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public int getDifferedWrite() {
        return this.differedWrite;
    }

    @Override
    public void setDifferedWrite(int Modo) {
        this.differedWrite = Modo;
    }

    protected PreparedStatement createPreparedStatement(String ClaveStatement) throws SQLException {
        if (this.getDifferedWrite() == 1) {
            return this.getdBConexion().prepareStatement(ClaveStatement, 1005, 1008, 1);
        }
        return this.getdBConexion().prepareStatement(ClaveStatement, 1004, 1007, 1);
    }

    protected Statement createStatement() throws SQLException {
        return this.getdBConexion().createStatement(1005, 1008);
    }

    protected Statement createStatementSoloLectura() throws SQLException {
        return this.getdBConexion().createStatement(1003, 1007);
    }

    protected String getNombreTablaRaiz() throws ExceptionMotor {
        try {
            IRegTabla regTabla = this.getSesion().getModelo().getGestorConfiguracion().getTablaNivel(0);
            if (regTabla == null) {
                throw new ExceptionMotor("No se han recuperado la tabla de nivel 0.");
            }
            String nombreTablaRaiz = null;
            if (regTabla != null) {
                nombreTablaRaiz = regTabla.getTablaFisica();
            }
            return nombreTablaRaiz;
        }
        catch (ExceptionMotor em) {
            throw em;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public Map<String, String> crearDeclaracionPorDefecto(Connection conexionAbierta) throws ExceptionMotor {
        try {
            HashMap<String, String> parametrosInicializacion = new HashMap<String, String>();
            String nombreTablaRaiz = this.getNombreTablaRaiz();
            if (nombreTablaRaiz == null) {
                throw new ExceptionMotor("No se ha recuperado nombre de la tabla ra\u00edz.");
            }
            if (this.getdBConexion() == null) {
                this.setdBConexion(conexionAbierta);
            }
            Statement consulta = this.createStatementSoloLectura();
            consulta.execute("INSERT INTO " + this.getShema() + nombreTablaRaiz + " (" + "ID" + ") VALUES (DEFAULT)", 1);
            try {
                ResultSet rs = consulta.getGeneratedKeys();
                if (rs.next()) {
                    parametrosInicializacion.put("IDRAIZ", String.valueOf(rs.getLong(1)));
                    return parametrosInicializacion;
                }
            }
            catch (Exception ex) {
                throw new ExceptionMotor("ID de la tabla raiz " + nombreTablaRaiz + " debe ser autoincremantable!!! Info : " + ex.toString());
            }
            throw new ExceptionMotor("ID de la tabla raiz " + nombreTablaRaiz + " debe ser autoincremantable!!!");
        }
        catch (ExceptionMotor e) {
            throw e;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean abrirAlmacenamiento() throws ExceptionMotor {
        try {
            Class.forName(this.getClaseACargar());
            if (this.getUsuario() != null) {
                return this.abrirAlmacenamiento(DriverManager.getConnection(this.getCadenaDeConexion(), this.getUsuario(), this.getPassword()));
            }
            return this.abrirAlmacenamiento(DriverManager.getConnection(this.getCadenaDeConexion()));
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public boolean abrirAlmacenamiento(Object origen) throws ExceptionMotor {
        return this.abrirAlmacenamiento(origen, null);
    }

    @Override
    public boolean abrirAlmacenamiento(Object conexionAbierta, Map<String, String> parametrosInicializacion) throws ExceptionMotor {
        try {
            if (conexionAbierta == null) {
                return this.abrirAlmacenamiento();
            }
            if (parametrosInicializacion == null || !parametrosInicializacion.containsKey("IDRAIZ")) {
                parametrosInicializacion = this.crearDeclaracionPorDefecto((Connection)conexionAbierta);
            }
            this.idTablaRaiz = Long.parseLong(parametrosInicializacion.get("IDRAIZ"));
            this.setdBConexion((Connection)conexionAbierta);
            this.cacheOrigenDatos = new CacheTablasOrigenDatos(this);
            this.getdBConexion().setAutoCommit(false);
            this.listaRecordSetAbiertos = new ArrayList<Object>();
            return true;
        }
        catch (ExceptionMotor em) {
            throw em;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public IGestorConfiguracion getGestorConfiguracion() throws ExceptionMotor {
        return this.getSesion().getModelo().getGestorConfiguracion();
    }

    protected void limpiaCaches() throws ExceptionMotor {
        this.cacheOrigenDatos.clearCache();
    }

    protected boolean cierraRecordSet(ResultSet Rs) {
        try {
            if (Rs != null) {
                Rs.close();
            }
            Rs = null;
            return true;
        }
        catch (Exception Ex) {
            Rs = null;
            return false;
        }
    }

    protected boolean cierraStatement(Statement Stm) {
        try {
            if (Stm != null) {
                Stm.close();
            }
            Stm = null;
            return true;
        }
        catch (Exception Ex) {
            Stm = null;
            return false;
        }
    }

    protected boolean cerrarRecordSetsAbiertos() throws ExceptionMotor {
        return this.cerrarRecordSetsAbiertos(true);
    }

    protected boolean cerrarRecordSetsAbiertos(boolean ForceToClose) throws ExceptionMotor {
        try {
            boolean eliminar = false;
            ResultSet rs = null;
            for (int i = this.listaRecordSetAbiertos.size() - 2; i > -1; i -= 2) {
                rs = (ResultSet)this.listaRecordSetAbiertos.get(i);
                eliminar = ForceToClose;
                if (!eliminar) {
                    try {
                        rs.getRow();
                    }
                    catch (Exception Ex) {
                        eliminar = true;
                    }
                }
                if (!eliminar) continue;
                this.cierraRecordSet(rs);
                this.cierraStatement((Statement)this.listaRecordSetAbiertos.get(i + 1));
                this.listaRecordSetAbiertos.remove(i + 1);
                this.listaRecordSetAbiertos.remove(i);
            }
            return true;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean cerrarAlmacenamiento() throws ExceptionMotor {
        try {
            this.limpiaCaches();
            this.cerrarRecordSetsAbiertos();
            if (this.isEnTransaccion()) {
                this.rollBack();
            }
            if (this.recordSet != null) {
                this.cierraRecordSet(this.recordSet);
            }
            this.cierraStatement(this.consulta);
            this.cierraStatement(this.consultaAux);
            this.cierraStatement(this.consultaSoloLectura);
            this.cierraStatement(this.consultaAuxSoloLectura);
            this.rollBack(true);
            if (this.getdBConexion() != null && !this.getdBConexion().isClosed()) {
                this.getdBConexion().close();
            }
            this.setdBConexion(null);
            return true;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public boolean beginTrans() throws ExceptionMotor {
        try {
            if (this.getDifferedWrite() > 0 && this.isEnTransaccion()) {
                return true;
            }
            if (this.isEnTransaccion()) {
                throw new ExceptionMotor("Ya existe una transaccion activa");
            }
            this.getdBConexion().setAutoCommit(false);
            this.setEnTransaccion(true);
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public boolean commitTrans() throws ExceptionMotor {
        try {
            if (this.getDifferedWrite() > 0) {
                return true;
            }
            if (!this.isEnTransaccion()) {
                throw new ExceptionMotor("No existe ninguna transaccion empezada");
            }
            this.getdBConexion().commit();
            this.setEnTransaccion(false);
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public boolean rollBack(boolean force) throws ExceptionMotor {
        try {
            if (this.getDifferedWrite() > 0 && !force) {
                return true;
            }
            if (!force && !this.isEnTransaccion()) {
                throw new ExceptionMotor("No existe ninguna transaccion empezada");
            }
            this.getdBConexion().rollback();
            this.setEnTransaccion(false);
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public boolean rollBack() throws ExceptionMotor {
        return this.rollBack(false);
    }

    @Override
    public Object ejecutaSQL(String sql) throws ExceptionMotor {
        return this.ejecutaQuery(sql);
    }

    public ResultSet ejecutaQuery(String sql) throws ExceptionMotor {
        return this.ejecutaQuery(sql, this.recordSet);
    }

    protected ResultSet ejecutaQuery(String sql, ResultSet rs) throws ExceptionMotor {
        try {
            if (this.getdBConexion() == null || this.getdBConexion().isClosed()) {
                throw new ExceptionMotor("No existe conexi\u00f3n");
            }
            rs = this.getConsulta().executeQuery(sql);
            return rs;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public long ejecutaInsert(String sql) throws ExceptionMotor {
        try {
            if (this.getdBConexion() == null || this.getdBConexion().isClosed()) {
                throw new ExceptionMotor("No existe conexi\u00f3n");
            }
            this.getConsulta().execute(sql, 1);
            try {
                ResultSet rs = this.getConsulta().getGeneratedKeys();
                if (rs.next()) {
                    return rs.getLong(1);
                }
            }
            catch (Exception ex) {
                return -1L;
            }
            return -1L;
        }
        catch (SQLException ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean ejecutaAccion(String sql) throws ExceptionMotor {
        try {
            if (this.getdBConexion() == null || this.getdBConexion().isClosed()) {
                throw new ExceptionMotor("No existe conexi\u00f3n");
            }
            this.getConsulta().execute(sql);
            return true;
        }
        catch (SQLException ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public long getSiguienteIDFisico(String nombreTabla) throws ExceptionMotor {
        return this.cacheOrigenDatos.getSiguienteIDFisico(nombreTabla);
    }

    @Override
    public long anniadirRegistro(ITablaMotor tab) throws ExceptionMotor {
        try {
            this.cacheOrigenDatos.getRecordCount(tab.getNombre(), tab.getClaveUnicaSuperior());
            long sigID = -1L;
            if (this.getDifferedWrite() <= 0) {
                this.sSQL = tab.getClaveSuperior() < 1L ? "INSERT INTO " + this.getShema() + this.getNombreFisicoDeTabla(tab.getNombre()) : "INSERT INTO " + this.getShema() + this.getNombreFisicoDeTabla(tab.getNombre()) + " (" + "IDINF" + ") VALUES (" + String.valueOf(tab.getClaveUnicaSuperior()) + ")";
                sigID = this.ejecutaInsert(this.sSQL);
                if (sigID == -1L) {
                    this.cacheOrigenDatos.borrarElemento(tab.getNombre(), sigID, tab.getClaveUnicaSuperior());
                    this.recordSet = null;
                    return 0L;
                }
                this.cacheOrigenDatos.addElemento(tab.getNombre(), tab.getClaveUnicaSuperior(), sigID);
            }
            tab.setClaveUnica(sigID);
            tab.setClaveActiva(tab.getClaveActiva() + 1L);
            if (this.existeContador().booleanValue()) {
                ITablaMotor tabRaiz = ((ISesionExtendida)this.sesion).obtenerNodoTabla(this.getNombreTablaRaiz());
                int regs = this.obtenerPartidaInteger(tabRaiz, "CON_REG");
                tabRaiz.establecerPartida("CON_REG", regs + 1);
                this.establecerPartida(tabRaiz, "CON_REG", regs + 1);
            }
            return tab.getClaveActiva();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public boolean borrarRegistro(ITablaMotor tab) throws ExceptionMotor {
        try {
            boolean ret = true;
            if (tab.getClaveActiva() == 0L) {
                return false;
            }
            if (this.cacheOrigenDatos.getCacheHabilitada()) {
                this.cacheOrigenDatos.getRecordCount(tab.getNombre(), this.cacheOrigenDatos.getIdInfFromIdFisico(tab.getNombre(), tab.getClaveActiva()));
                this.cacheOrigenDatos.borrarElemento(tab.getNombre(), tab.getClaveUnica(), tab.getClaveUnicaSuperior());
            }
            if (!this.ejecutaAccion("DELETE FROM " + this.getShema() + this.getNombreFisicoDeTabla(tab.getNombre()) + " WHERE " + "ID" + " = " + String.valueOf(tab.getClaveUnica()))) {
                this.cacheOrigenDatos.clearCache();
                throw new ExceptionMotor("No existe dicho registro");
            }
            if (this.existeContador().booleanValue()) {
                int borrados = this.getConsulta().getUpdateCount();
                ITablaMotor tabRaiz = ((ISesionExtendida)this.sesion).obtenerNodoTabla(this.getNombreTablaRaiz());
                int regs = this.obtenerPartidaInteger(tabRaiz, "CON_REG");
                this.establecerPartida(tabRaiz, "CON_REG", regs - borrados);
            }
            if (this.getDifferedWrite() == 0) {
                this.cacheOrigenDatos.clearCache();
            }
            return ret;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean establecerCriterioOrdenacion(List<String> listaDeCriteriosOrdenacion) {
        boolean campos2222222222;
        block16: {
            this.criteriosOrdenacion = null;
            if (listaDeCriteriosOrdenacion != null && listaDeCriteriosOrdenacion.size() > 0) {
                this.criteriosOrdenacion = new HashMap<String, String>();
                for (int i = 0; i < listaDeCriteriosOrdenacion.size(); i += 3) {
                    String cadena = "";
                    String[] campos2222222222 = listaDeCriteriosOrdenacion.get(i + 2).toString().split(",");
                    for (int j = 0; j < campos2222222222.length; ++j) {
                        if (cadena.length() > 0) {
                            cadena = cadena + ", ";
                        }
                        cadena = cadena + campos2222222222[j];
                    }
                    if (listaDeCriteriosOrdenacion.get(i + 1).toString().compareToIgnoreCase("Desc") == 0) {
                        cadena = cadena + " DESC";
                    }
                    this.criteriosOrdenacion.put(listaDeCriteriosOrdenacion.get(i).toString().toUpperCase(), " ORDER BY " + cadena);
                }
            }
            campos2222222222 = true;
            if (this.cacheOrigenDatos == null) break block16;
            try {
                this.cacheOrigenDatos.clearCache();
            }
            catch (ExceptionMotor exceptionMotor) {
                // empty catch block
            }
            this.cacheOrigenDatos.criteriosOrdenacion = this.criteriosOrdenacion;
        }
        this.origenDeDatosOrdenadoPorCriterio = this.criteriosOrdenacion != null;
        return campos2222222222;
        catch (Exception Ex) {
            boolean bl;
            block17: {
                try {
                    this.criteriosOrdenacion = null;
                    bl = false;
                    if (this.cacheOrigenDatos == null) break block17;
                }
                catch (Throwable throwable) {
                    if (this.cacheOrigenDatos != null) {
                        try {
                            this.cacheOrigenDatos.clearCache();
                        }
                        catch (ExceptionMotor e) {
                            // empty catch block
                        }
                        this.cacheOrigenDatos.criteriosOrdenacion = this.criteriosOrdenacion;
                    }
                    this.origenDeDatosOrdenadoPorCriterio = this.criteriosOrdenacion != null;
                    throw throwable;
                }
                try {
                    this.cacheOrigenDatos.clearCache();
                }
                catch (ExceptionMotor e) {
                    // empty catch block
                }
                this.cacheOrigenDatos.criteriosOrdenacion = this.criteriosOrdenacion;
            }
            this.origenDeDatosOrdenadoPorCriterio = this.criteriosOrdenacion != null;
            return bl;
        }
    }

    protected String dameCriterioDeOrdenacionDeTabla(String nombreTabla) {
        if (this.criteriosOrdenacion == null) {
            return "";
        }
        String ret = this.criteriosOrdenacion.get(nombreTabla.toUpperCase());
        if (ret != null) {
            return ret.toString();
        }
        return "";
    }

    protected long posicionarseEnRegistro(String nombreTabla, long idFisico) throws ExceptionMotor {
        try {
            if (idFisico < 1L) {
                return -1L;
            }
            try {
                if (idFisico == this.recordSet.getLong("ID") && this.recordSet.getMetaData().getTableName(1).equalsIgnoreCase(this.getNombreFisicoDeTabla(nombreTabla))) {
                    return idFisico;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.sSQL = "Select * from " + this.getShema() + this.getNombreFisicoDeTabla(nombreTabla) + " where " + "ID" + " = " + String.valueOf(idFisico) + this.dameCriterioDeOrdenacionDeTabla(nombreTabla);
            this.recordSet = this.ejecutaQuery(this.sSQL, this.recordSet);
            try {
                this.recordSet.first();
                return this.recordSet.getLong("ID");
            }
            catch (SQLException ex) {
                this.recordSet = null;
                return -1L;
            }
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean limpiaRegistro(ITablaMotor tab) throws ExceptionMotor {
        try {
            if (this.posicionarseEnRegistro(tab.getNombre(), tab.getClaveUnica()) == -1L) {
                throw new ExceptionMotor("No existe dicho registro");
            }
            long campoId = this.recordSet.getLong("ID");
            this.recordSet.deleteRow();
            long id = this.anniadirRegistro(tab);
            tab.setClaveActiva(id);
            this.cierraRecordSet(this.recordSetAuxiliar);
            return id == campoId;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public long recordCount(ITablaMotor tab) {
        try {
            return this.cacheOrigenDatos.getRecordCount(tab.getNombre(), tab.getClaveUnicaSuperior());
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    @Override
    public int getRecordCountTotal() throws ExceptionMotor {
        if (!this.existeContador().booleanValue()) {
            return 0;
        }
        ITablaMotor tabRaiz = ((ISesionExtendida)this.sesion).obtenerNodoTabla(this.getNombreTablaRaiz());
        return this.obtenerPartidaInteger(tabRaiz, "CON_REG");
    }

    @Override
    public boolean establecerPartida(ITablaMotor tab, String nombrePartida, double valorDouble) throws ExceptionMotor {
        return this.establecerPartidaNumerica(tab, nombrePartida, String.valueOf(valorDouble));
    }

    public boolean establecerPartida(ITablaMotor tab, String nombrePartida, BigDecimal valorBigDecimal) throws ExceptionMotor {
        return this.establecerPartidaNumerica(tab, nombrePartida, String.valueOf(valorBigDecimal));
    }

    @Override
    public boolean establecerPartida(ITablaMotor tab, String nombrePartida, int valorInt) throws ExceptionMotor {
        return this.establecerPartidaNumerica(tab, nombrePartida, String.valueOf(valorInt));
    }

    @Override
    public boolean establecerPartida(ITablaMotor tab, String nombrePartida, long valorLong) throws ExceptionMotor {
        return this.establecerPartidaNumerica(tab, nombrePartida, String.valueOf(valorLong));
    }

    @Override
    public boolean establecerPartida(ITablaMotor tab, String nombrePartida, boolean valorBooleano) throws ExceptionMotor {
        int logico = 0;
        if (valorBooleano) {
            logico = -1;
        }
        return this.establecerPartida(tab, nombrePartida, logico);
    }

    @Override
    public boolean establecerPartida(ITablaMotor tab, String nombrePartida, String valorString) throws ExceptionMotor {
        try {
            if (this.getDifferedWrite() > 0) {
                return true;
            }
            if (nombrePartida.equalsIgnoreCase("ID") || nombrePartida.equalsIgnoreCase("IDINF")) {
                return this.establecerPartida(tab, nombrePartida, Integer.valueOf(valorString));
            }
            if (!this.ejecutaAccion("UPDATE " + this.getShema() + this.getNombreFisicoDeTabla(tab.getNombre()) + " SET " + nombrePartida + " = '" + valorString + "' WHERE " + "ID" + " = " + String.valueOf(tab.getClaveUnica()))) {
                throw new ExceptionMotor("Imposible establecer partida " + nombrePartida + " a " + valorString);
            }
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    protected boolean establecerPartidaNumerica(ITablaMotor tab, String nombrePartida, String valorLong) throws ExceptionMotor {
        try {
            if (this.getDifferedWrite() > 0) {
                return true;
            }
            if (tab.getClaveActiva() == 0L) {
                return false;
            }
            if (!this.ejecutaAccion("UPDATE " + this.getShema() + this.getNombreFisicoDeTabla(tab.getNombre()) + " SET " + nombrePartida + " = " + valorLong + " WHERE " + "ID" + " = " + String.valueOf(tab.getClaveUnica()))) {
                throw new ExceptionMotor("Imposible establecer partida " + nombrePartida + " a " + valorLong);
            }
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public boolean establecerEstado(ITablaMotor tab, String nombrePartida, int estado) throws ExceptionMotor {
        try {
            return this.establecerPartida(tab, nombrePartida + terminacionEstado, estado);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public boolean establecerEstado(ITablaMotor tab, String nombrePartida, String estado) throws ExceptionMotor {
        return this.establecerEstado(tab, nombrePartida, Integer.valueOf(estado));
    }

    public double sacaDoble(Object obj) throws ExceptionMotor {
        try {
            try {
                return (Double)obj;
            }
            catch (ClassCastException cc) {
                return new Double(obj.toString());
            }
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public int sacaInteger(Object obj) throws ExceptionMotor {
        try {
            try {
                return (Integer)obj;
            }
            catch (ClassCastException cc) {
                return new Integer(obj.toString());
            }
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public boolean sacaBoolean(Object obj) throws ExceptionMotor {
        try {
            try {
                return (Boolean)obj;
            }
            catch (ClassCastException cc) {
                return new Boolean(obj.toString());
            }
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public BigDecimal sacaBigDecimal(Object obj) throws ExceptionMotor {
        try {
            try {
                return (BigDecimal)obj;
            }
            catch (ClassCastException cc) {
                return new BigDecimal(obj.toString());
            }
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public boolean establecerPartida(ITablaMotor tab, String nombrePartida, Object valorObject) throws ExceptionMotor {
        try {
            if (this.getDifferedWrite() > 0) {
                return true;
            }
            if (this.posicionarseEnRegistro(tab.getNombre(), tab.getClaveUnica()) == -1L) {
                return false;
            }
            String partida = FuncionesUtiles.getFuncionesUtiles().dameNombrePartidaSinParentesis(nombrePartida);
            String valor = valorObject.toString();
            IRegEntrada ent = this.getGestorConfiguracion().getEntrada(partida);
            if (ent == null && (partida.equalsIgnoreCase("ID") || partida.equalsIgnoreCase("IDINF"))) {
                ent = new RegEntrada();
                ent.inicializaRegEntrada(partida, tab.getNombre(), "ENTERO".toUpperCase(), "1");
                if (!(valorObject instanceof Integer)) {
                    valorObject = Integer.valueOf(valorObject.toString());
                }
            } else if (!ent.getIdTabla().equalsIgnoreCase(tab.getNombre())) {
                throw new ExceptionMotor("La partida " + partida + " no pertenece a la tabla " + tab.getNombre());
            }
            if (ent != null && ent.esTipoNumerico()) {
                String maximo = "";
                int max = 0;
                if (ent.getTipoDato().equalsIgnoreCase("BIGDECIMAL")) {
                    try {
                        max = Integer.valueOf(ent.getPropiedad("NUMEROENTEROS").toString());
                    }
                    catch (Exception ex) {}
                } else {
                    try {
                        max = Integer.valueOf(ent.getPropiedad("LONGITUD").toString());
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (max == 0) {
                        try {
                            max = Integer.valueOf(ent.getPropiedad("NUMEROENTEROS").toString());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                }
                if (max != 0) {
                    maximo = FuncionesUtiles.getFuncionesUtiles().rellena("", '9', max);
                    int numeroDecimales = ent.getNumDecimales();
                    if (numeroDecimales > 0) {
                        maximo = maximo + "." + FuncionesUtiles.getFuncionesUtiles().rellena("", '9', numeroDecimales);
                    }
                    if (maximo.trim().length() == 0) {
                        maximo = "0";
                    }
                    if (this.isControlOverflow() && FuncionesUtiles.getFuncionesUtiles().mayorQue(valor, maximo)) {
                        FuncionesUtiles.getFuncionesUtiles().muestraError("OVERFLOW partida " + partida);
                        throw new ExceptionMotor("OVERFLOW_MOTOR");
                    }
                    if (this.isControlOverflow() && FuncionesUtiles.getFuncionesUtiles().menorQue(valor, "-" + maximo)) {
                        FuncionesUtiles.getFuncionesUtiles().muestraError("OVERFLOW partida " + partida);
                        throw new ExceptionMotor("OVERFLOW_MOTOR");
                    }
                }
            }
            if (ent.getTipoDato().equalsIgnoreCase("DOBLE")) {
                return this.establecerPartida(tab, nombrePartida, this.sacaDoble(valorObject));
            }
            if (ent.getTipoDato().equalsIgnoreCase("LOGICO")) {
                return this.establecerPartida(tab, nombrePartida, this.sacaBoolean(valorObject));
            }
            if (ent.getTipoDato().equalsIgnoreCase("ENTERO")) {
                return this.establecerPartida(tab, nombrePartida, this.sacaInteger(valorObject));
            }
            if (ent.getTipoDato().equalsIgnoreCase("BIGDECIMAL")) {
                return this.establecerPartida(tab, nombrePartida, this.sacaBigDecimal(valorObject));
            }
            return this.establecerPartida(tab, nombrePartida, valorObject.toString());
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public Object obtenerPartida(ITablaMotor tab, String nombrePartida) throws ExceptionMotor {
        return this.obtenerPartidaString(tab, nombrePartida);
    }

    @Override
    public String obtenerPartidaString(ITablaMotor tab, String nombrePartida) throws ExceptionMotor {
        try {
            if (nombrePartida.equalsIgnoreCase("ID") && tab.getClaveUnicaSuperior() > 0L && tab.getClaveActiva() > 0L) {
                return String.valueOf(this.cacheOrigenDatos.getIdFisico4Row(tab.getNombre(), tab.getClaveActiva(), tab.getClaveUnicaSuperior()));
            }
            if (this.posicionarseEnRegistro(tab.getNombre(), tab.getClaveUnica()) == -1L) {
                return null;
            }
            this.recordSet.first();
            try {
                this.recordSet.refreshRow();
                this.recordSet.first();
            }
            catch (Exception Ex) {
                // empty catch block
            }
            Object res = null;
            try {
                res = this.recordSet.getObject(nombrePartida);
            }
            catch (SQLException s) {
                return null;
            }
            if (res != null) {
                return res.toString();
            }
            return null;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public int obtenerEstado(ITablaMotor tab, String nombrePartida) throws ExceptionMotor {
        try {
            return this.obtenerPartidaInteger(tab, nombrePartida + terminacionEstado);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public Integer obtenerPartidaInteger(ITablaMotor tab, String nombrePartida) throws ExceptionMotor {
        try {
            return Integer.valueOf(this.obtenerPartidaString(tab, nombrePartida));
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public Double obtenerPartidaDouble(ITablaMotor tab, String nombrePartida) throws ExceptionMotor {
        try {
            return Double.valueOf(this.obtenerPartidaString(tab, nombrePartida));
        }
        catch (Exception ex) {
            return new Double(0.0);
        }
    }

    @Override
    public BigDecimal obtenerPartidaBigDecimal(ITablaMotor tab, String nombrePartida) throws ExceptionMotor {
        try {
            return new BigDecimal(this.obtenerPartidaString(tab, nombrePartida).trim());
        }
        catch (Exception ex) {
            return BigDecimal.ZERO;
        }
    }

    @Override
    public Boolean obtenerPartidaBoolean(ITablaMotor tab, String nombrePartida) throws ExceptionMotor {
        try {
            return Boolean.valueOf(this.obtenerPartidaString(tab, nombrePartida));
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected Object obtenerValorSegunSuTipoDeDatos(String campo, String valor) {
        try {
            IRegEntrada ent = this.getSesion().getModelo().getGestorConfiguracion().getEntrada(campo);
            String porDefecto = ent.getValorInicial();
            String tipo = ent.getTipoDato();
            if (tipo.equalsIgnoreCase("DOBLE")) {
                if (valor.length() == 0) {
                    if (porDefecto.length() == 0) {
                        porDefecto = "0";
                    }
                    return Double.valueOf(porDefecto);
                }
                return Double.valueOf(valor);
            }
            if (tipo.equalsIgnoreCase("BIGDECIMAL")) {
                return BigDecimal.ZERO;
            }
            if (tipo.equalsIgnoreCase("LOGICO") || tipo.equalsIgnoreCase("L\u00f3gico")) {
                if (valor.length() == 0) {
                    if (porDefecto.length() == 0) {
                        porDefecto = "false";
                    }
                    if (porDefecto.equalsIgnoreCase("0")) {
                        porDefecto = "false";
                    }
                    if (porDefecto.equalsIgnoreCase("1")) {
                        porDefecto = "true";
                    }
                    return Boolean.valueOf(porDefecto);
                }
                return Boolean.valueOf(valor);
            }
            if (tipo.equalsIgnoreCase("ENTERO")) {
                if (valor.length() == 0) {
                    if (porDefecto == null || porDefecto.length() == 0) {
                        porDefecto = "0";
                    }
                    return Integer.valueOf(porDefecto);
                }
                return Integer.valueOf(valor);
            }
            return valor;
        }
        catch (Exception ex) {
            return valor;
        }
    }

    @Override
    public Map<String, ITablaMotorEntrada> obtenerRegistroFiltroEnPosicion(ITablaMotor tab) throws ExceptionMotor {
        try {
            return this.cacheOrigenDatos.getRecord4Row(tab.getNombre(), tab.getClaveUnicaSuperior(), tab.getClaveActiva(), tab.getClaveUnica(), tab.getNivel());
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean inTrans() throws ExceptionMotor {
        try {
            return this.isEnTransaccion();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean getSopportsSQL() {
        return true;
    }

    @Override
    public void setOrigenDeDatosOrdenadoPorCriterio(boolean origenDeDatosOrdenadoPorCriterio) throws ExceptionMotor {
        throw new ExceptionMotor("No procede en este origen de datos...");
    }

    @Override
    public boolean isOrigenDeDatosOrdenadoPorCriterio() throws ExceptionMotor {
        return this.origenDeDatosOrdenadoPorCriterio;
    }

    @Override
    public void setControlOverflow(boolean controlOverflow) {
        this.controlOverflow = controlOverflow;
    }

    @Override
    public boolean isControlOverflow() {
        return this.controlOverflow;
    }

    @Override
    public Object clona() throws ExceptionMotor {
        throw new ExceptionMotor("No procede en este origen de datos...");
    }

    @Override
    public boolean restauraDocumento(Object datos) throws ExceptionMotor {
        throw new ExceptionMotor("No procede en este origen de datos...");
    }

    @Override
    public void setModoTransacciones(int modoTransaccion) throws ExceptionMotor {
        throw new ExceptionMotor("No procede en este origen de datos...");
    }

    @Override
    public int getModoTransacciones() throws ExceptionMotor {
        throw new ExceptionMotor("No procede en este origen de datos...");
    }

    @Override
    public Object getPunteroADatos() throws ExceptionMotor {
        return this.getdBConexion();
    }

    @Override
    public List<Long> listaIdsTabla(ITablaMotor tab) throws ExceptionMotor {
        return null;
    }

    @Override
    public boolean isCacheHabilitada() throws ExceptionMotor {
        try {
            return this.cacheOrigenDatos.getCacheHabilitada();
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public void setCacheHabilitada(boolean cacheHabilitada) throws ExceptionMotor {
        try {
            this.cacheOrigenDatos.setCacheHabilitada(cacheHabilitada);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected abstract String getClaseACargar();

    protected void setdBConexion(Connection dBConexion) {
        this.dBConexion = dBConexion;
    }

    protected Connection getdBConexion() {
        return this.dBConexion;
    }

    protected abstract String getCadenaDeConexion();

    protected abstract String getUsuario();

    protected abstract String getPassword();

    protected String getShema() {
        if (this.schema == null) {
            this.schema = "APL000.";
            try {
                this.schema = this.getSesion().getModelo().getGestorDatosOpciones().getOpcion("SCHEMA").get(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.schema;
    }

    protected void setEnTransaccion(boolean enTransaccion) {
        this.enTransaccion = enTransaccion;
    }

    protected boolean isEnTransaccion() {
        return this.enTransaccion;
    }

    protected Map<String, ITablaMotorEntrada> obtenerRegistroDeTabla(ITablaMotor tab) throws ExceptionMotor {
        try {
            if (this.posicionarseEnRegistro(tab.getNombre(), tab.getClaveUnica()) == -1L) {
                return null;
            }
            return (Map)this.obtenerRegistroDeTabla(this.recordSet, 0);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected String partidaDeResultSetAUsuario(String valor, IRegEntrada entrada) throws ExceptionMotor {
        try {
            if (entrada != null && entrada.getTipoDato().equalsIgnoreCase("LOGICO")) {
                if (valor.equalsIgnoreCase("-1")) {
                    return "true";
                }
                if (valor.equalsIgnoreCase("0")) {
                    return "false";
                }
            }
            return valor;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public Object obtenerRegistroDeTabla(ResultSet rs, int modo) throws ExceptionMotor {
        try {
            HashMap<String, TablaMotorEntrada> retMap = null;
            ArrayList<TablaMotorEntrada> retList = null;
            if (modo == 0) {
                retMap = new HashMap<String, TablaMotorEntrada>();
            } else {
                retList = new ArrayList<TablaMotorEntrada>();
            }
            ITablaMotorEntrada actual = null;
            ResultSetMetaData estructura = rs.getMetaData();
            for (int i = 1; i <= estructura.getColumnCount(); ++i) {
                String campo = estructura.getColumnLabel(i).toUpperCase();
                IRegEntrada ent = this.getSesion().getModelo().getGestorConfiguracion().getEntrada(campo);
                String valor = rs.getString(i);
                boolean esEstado = campo.endsWith(terminacionEstado);
                if (esEstado) {
                    campo = campo.substring(0, campo.length() - terminacionEstado.length());
                    ent = this.getSesion().getModelo().getGestorConfiguracion().getEntrada(campo);
                }
                if (modo == 0) {
                    if (!retMap.containsKey(campo)) {
                        actual = new TablaMotorEntrada(campo);
                        retMap.put(campo, (TablaMotorEntrada)actual);
                    } else {
                        actual = (ITablaMotorEntrada)retMap.get(campo);
                    }
                } else {
                    actual = new TablaMotorEntrada(campo);
                    if (!retList.contains(actual)) {
                        retList.add((TablaMotorEntrada)actual);
                    } else {
                        actual = (ITablaMotorEntrada)retList.get(retList.indexOf(actual));
                    }
                }
                if (valor == null || valor.equalsIgnoreCase("")) {
                    if (esEstado) {
                        valor = String.valueOf(ent.getEstadoInicial());
                    } else {
                        if (ent == null) {
                            if (modo == 0) {
                                retMap.remove(campo);
                                continue;
                            }
                            retList.remove(actual);
                            continue;
                        }
                        valor = ent.getValorInicial();
                    }
                }
                if (esEstado) {
                    actual.setEstado(valor);
                    continue;
                }
                actual.setValor(this.partidaDeResultSetAUsuario(valor, ent));
            }
            if (modo == 0) {
                return retMap;
            }
            return retList;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected ResultSet obtenerRsComun(ITablaMotor tab) throws ExceptionMotor {
        try {
            String sql = "Select * from " + this.getShema() + this.getNombreFisicoDeTabla(tab.getNombre()) + " where " + "IDINF" + " = " + tab.getClaveUnicaSuperior();
            String sqlPreparedStatement = "Select * from " + this.getShema() + this.getNombreFisicoDeTabla(tab.getNombre()) + " where " + "IDINF" + " = ?";
            ArrayList<Object> parametrosPreparedStatement = new ArrayList<Object>();
            parametrosPreparedStatement.add((int)tab.getClaveUnicaSuperior());
            return this.cacheOrigenDatos.getResultSet(sql, sqlPreparedStatement, parametrosPreparedStatement);
        }
        catch (ExceptionMotor em) {
            throw em;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public List<Map<String, ITablaMotorEntrada>> obtenerTablaHashMap(ITablaMotor tab) throws ExceptionMotor {
        try {
            ArrayList<Map<String, ITablaMotorEntrada>> ret = new ArrayList<Map<String, ITablaMotorEntrada>>();
            ResultSet rs = this.obtenerRsComun(tab);
            if (rs != null && rs.first()) {
                do {
                    ret.add((Map)this.obtenerRegistroDeTabla(rs, 0));
                } while (rs.next());
            }
            return ret;
        }
        catch (ExceptionMotor em) {
            throw em;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public List<List<ITipoDatosRegistro>> obtenerTabla(ITablaMotor tab) throws ExceptionMotor {
        try {
            ArrayList<List<ITipoDatosRegistro>> ret = new ArrayList<List<ITipoDatosRegistro>>();
            ResultSet rs = this.obtenerRsComun(tab);
            if (rs != null && rs.first()) {
                do {
                    ArrayList<TipoDatosRegistro> listado = new ArrayList<TipoDatosRegistro>();
                    List tmp = (List)this.obtenerRegistroDeTabla(rs, 1);
                    for (ITablaMotorEntrada dto : tmp) {
                        listado.add(new TipoDatosRegistro(dto.getNombreEntrada(), dto.getValor(), dto.getEstado()));
                    }
                    ret.add(listado);
                } while (rs.next());
            }
            return ret;
        }
        catch (ExceptionMotor em) {
            throw em;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected PreparedStatement getPreparedStatement(String claveStatement, int modo) throws ExceptionMotor {
        try {
            if (this.grupoPreparedStatement == null) {
                this.grupoPreparedStatement = new HashMap<String, PreparedStatement>();
            }
            PreparedStatement ret = null;
            ret = this.grupoPreparedStatement.get(claveStatement.toUpperCase());
            if (ret != null && (this.flagEstoyEnMTRE || !ret.isClosed())) {
                return ret;
            }
            if (this.grupoPreparedStatement.size() == 25) {
                this.grupoPreparedStatement.remove(this.grupoPreparedStatement.keySet().iterator().next().toString());
            }
            ret = modo == 1 ? this.getdBConexion().prepareStatement(claveStatement, 1) : this.createPreparedStatement(claveStatement);
            this.grupoPreparedStatement.put(claveStatement.toUpperCase(), ret);
            return ret;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public boolean establecerPartidas(ITablaMotor tab) throws ExceptionMotor, NotImplementedException {
        try {
            Long rc;
            boolean ret = false;
            if (tab.getClaveUnica() == 0L) {
                return false;
            }
            if (tab.getClaveUnicaSuperior() == -1L) {
                tab.setClaveUnicaSuperior(tab.getPtrTablaPadre().getClaveUnica());
            }
            String sqlPreparedStatement = "";
            ArrayList<Object> parametrosPreparedStatement = new ArrayList<Object>();
            String obj2 = "";
            Object valor = "";
            String valoresAInsertar = "(" + tab.getClaveUnicaSuperior();
            String sqlPreparedStatementValoresAInsertar = "(?";
            String sql = "Insert into " + this.getShema() + this.getNombreFisicoDeTabla(tab.getNombre()) + " (" + "IDINF" + "";
            sqlPreparedStatement = "Insert into " + this.getShema() + this.getNombreFisicoDeTabla(tab.getNombre()) + " (" + "IDINF" + "";
            parametrosPreparedStatement.add((int)tab.getClaveUnicaSuperior());
            Set<String> s = tab.getCachePartidas().keySet();
            Iterator<String> it = s.iterator();
            String tipoDatoEntrada = "";
            while (it.hasNext()) {
                obj2 = it.next();
                if (obj2.equalsIgnoreCase("ID") || obj2.equalsIgnoreCase("IDINF")) continue;
                sql = sql + ", " + obj2;
                sqlPreparedStatement = sqlPreparedStatement + ", " + obj2;
                parametrosPreparedStatement.add(tab.getCachePartidas().get(obj2));
                valor = tab.getCachePartidas().get(obj2);
                tipoDatoEntrada = this.sesion.getModelo().getGestorConfiguracion().getEntrada(obj2).getTipoDato();
                if (this.sesion.getModelo().getGestorConfiguracion().getEntrada(obj2).esTipoNumerico() || tipoDatoEntrada.equalsIgnoreCase("LOGICO")) {
                    if (tipoDatoEntrada.equalsIgnoreCase("LOGICO")) {
                        valor = (Boolean)valor != false ? "-1" : "0";
                    }
                    valoresAInsertar = valoresAInsertar + "," + valor.toString();
                } else {
                    valoresAInsertar = valoresAInsertar + ",'" + valor.toString() + "'";
                }
                sqlPreparedStatementValoresAInsertar = sqlPreparedStatementValoresAInsertar + ",?";
            }
            s = tab.getCacheEstados().keySet();
            for (String obj2 : s) {
                parametrosPreparedStatement.add(tab.getCacheEstados().get(obj2));
                sql = sql + ", " + obj2 + terminacionEstado;
                sqlPreparedStatement = sqlPreparedStatement + ", " + obj2 + terminacionEstado;
                valor = new Long(tab.getCacheEstados().get(obj2).intValue());
                valoresAInsertar = valoresAInsertar + "," + valor.toString();
                sqlPreparedStatementValoresAInsertar = sqlPreparedStatementValoresAInsertar + ",?";
            }
            sql = sql + ") Values " + valoresAInsertar + ")";
            sqlPreparedStatement = sqlPreparedStatement + ") Values " + sqlPreparedStatementValoresAInsertar + ")";
            ret = false;
            long idUnico = -1L;
            try {
                idUnico = this.ejecutaPreparedInsertStatement(sqlPreparedStatement, parametrosPreparedStatement);
                ret = true;
            }
            catch (ExceptionMotor e) {
                // empty catch block
            }
            if (!ret) {
                idUnico = this.ejecutaInsert(sql);
            }
            if (idUnico != -1L) {
                tab.setClaveUnica(idUnico);
                ret = true;
            }
            if (this.isCacheHabilitada() && (rc = this.cacheOrigenDatos.getRecordCountDeCache(tab.getNombre(), tab.getClaveUnicaSuperior())) != null) {
                Long l = rc;
                Long l2 = rc = Long.valueOf(rc + 1L);
                this.cacheOrigenDatos.setRecordCount(tab.getNombre().toUpperCase() + this.cacheOrigenDatos.getSeparador() + String.valueOf(tab.getClaveUnicaSuperior()), rc);
            }
            if (ret && this.differedWrite == 0) {
                this.commitTrans();
            }
            if (this.existeContador().booleanValue()) {
                ITablaMotor tabRaiz = ((ISesionExtendida)this.sesion).obtenerNodoTabla(this.getNombreTablaRaiz());
                int differedWrite = this.getDifferedWrite();
                String valorRegs = tabRaiz.obtenerPartidaString("CON_REG");
                this.setDifferedWrite(0);
                this.establecerPartida(tabRaiz, "CON_REG", Integer.parseInt(valorRegs));
                this.setDifferedWrite(differedWrite);
            }
            return ret;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public PreparedStatement cargaPreparedStatement(PreparedStatement pConsulta, String sqlPreparedStatement, List<Object> parametrosPreparedStatement) throws ExceptionMotor {
        try {
            if (pConsulta == null) {
                throw new ExceptionMotor("No se pudo hacer!!!");
            }
            Object o = null;
            int i = 0;
            for (i = 0; i < parametrosPreparedStatement.size(); ++i) {
                o = parametrosPreparedStatement.get(i);
                if (o.getClass().getName().equalsIgnoreCase(String.class.getName())) {
                    pConsulta.setString(i + 1, (String)o);
                    continue;
                }
                if (o.getClass().getName().equalsIgnoreCase(Double.class.getName())) {
                    pConsulta.setDouble(i + 1, (Double)o);
                    continue;
                }
                if (o.getClass().getName().equalsIgnoreCase(BigDecimal.class.getName())) {
                    pConsulta.setBigDecimal(i + 1, (BigDecimal)o);
                    continue;
                }
                if (o.getClass().getName().equalsIgnoreCase(Integer.class.getName())) {
                    pConsulta.setInt(i + 1, (Integer)o);
                    continue;
                }
                if (o.getClass().getName().equalsIgnoreCase(Boolean.class.getName())) {
                    if (((Boolean)o).booleanValue()) {
                        pConsulta.setInt(i + 1, -1);
                        continue;
                    }
                    pConsulta.setInt(i + 1, 0);
                    continue;
                }
                throw new Exception("Clase no esperada : " + o.getClass().getName());
            }
            return pConsulta;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor("No se pudo hacer!!!");
        }
    }

    public PreparedStatement ejecutaPreparedStatement(String sqlPreparedStatement, List<Object> parametrosPreparedStatement) throws ExceptionMotor {
        PreparedStatement pConsulta = null;
        try {
            pConsulta = this.getPreparedStatement(sqlPreparedStatement, 0);
            pConsulta = this.cargaPreparedStatement(pConsulta, sqlPreparedStatement, parametrosPreparedStatement);
            pConsulta.execute();
            return pConsulta;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor("No se pudo hacer!!!");
        }
    }

    public long ejecutaPreparedInsertStatement(String sqlPreparedStatement, List<Object> parametrosPreparedStatement) throws ExceptionMotor {
        PreparedStatement pConsulta = null;
        try {
            pConsulta = this.getPreparedStatement(sqlPreparedStatement, 1);
            pConsulta = this.cargaPreparedStatement(pConsulta, sqlPreparedStatement, parametrosPreparedStatement);
            pConsulta.executeUpdate();
            ResultSet rs = pConsulta.getGeneratedKeys();
            rs.next();
            return rs.getLong(1);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor("No se pudo hacer!!!");
        }
    }

    protected void setConsulta(Statement consulta) {
        this.consulta = consulta;
    }

    protected Statement getConsultaSoloLectura() throws ExceptionMotor {
        try {
            if (this.consultaSoloLectura == null || !this.flagEstoyEnMTRE && this.consultaSoloLectura.isClosed()) {
                this.consultaSoloLectura = null;
                this.consultaSoloLectura = this.createStatementSoloLectura();
            }
            return this.consultaSoloLectura;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected Statement getConsulta() throws ExceptionMotor {
        try {
            if (this.consulta == null || !this.flagEstoyEnMTRE && this.consulta.isClosed()) {
                this.consulta = null;
                this.consulta = this.createStatement();
            }
            return this.consulta;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected void setConsultaAux(Statement consultaAux) {
        this.consultaAux = consultaAux;
    }

    protected Statement getConsultaAux() throws ExceptionMotor {
        try {
            if (this.consultaAux == null || this.consultaAux.isClosed()) {
                this.consultaAux = null;
                this.consultaAux = this.createStatement();
            }
            return this.consultaAux;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected Statement getConsultaAuxSoloLectura() throws ExceptionMotor {
        try {
            if (this.consultaAuxSoloLectura == null || this.consultaAuxSoloLectura.isClosed()) {
                this.consultaAuxSoloLectura = null;
                this.consultaAuxSoloLectura = this.createStatementSoloLectura();
            }
            return this.consultaAuxSoloLectura;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean isCreacionIDUnicoAutomatico() {
        return false;
    }

    public String getNombreFisicoDeTabla(String nombreTabla) throws ExceptionMotor {
        try {
            return this.getSesion().getModelo().getGestorConfiguracion().getTabla(nombreTabla.toUpperCase()).getTablaFisica();
        }
        catch (ExceptionMotor e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public boolean getTablaIdInfCacheHabilitada() throws ExceptionMotor {
        return this.cacheOrigenDatos.isCacheUltimaTablaFiltradaHabilitada();
    }

    @Override
    public void setTablaIdInfCacheHabilitada(boolean nuevoEstado) {
        this.cacheOrigenDatos.setTablaIdInfCacheHabilitada(nuevoEstado);
    }

    public boolean getLogAccesosBBDD() {
        return false;
    }
}

