/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.origenDatos.bbdd.jdbc;

import es.aeat.pftw.mtrc.origenDatos.bbdd.jdbc.Jdbc;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.puente.ITablaMotorEntrada;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CacheTablasOrigenDatos
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient ResultSet rs = null;
    private String sSQL = "";
    private String sqlPreparedStatement = "";
    private List<Object> parametrosPreparedStatement = new ArrayList<Object>();
    public Map<String, String> criteriosOrdenacion = null;
    private boolean cacheUltimaTablaFiltradaHabilitada = false;
    private String cacheUltimaTablaFiltradaNombreeIdInf = "";
    private transient ResultSet cacheUltimaTablaFiltrada = null;
    private transient Statement cacheUltimaTablaFiltradaConsulta = null;
    private Map<String, List<Long>> listaDeIdInfyTabla = null;
    private List<Long> listaTraducciones = null;
    private Map<String, Long> listaDeRecordCountTablasCompletas = null;
    List<Long> correspondenciaIdLogicoIdFisico = null;
    private String separador = "~SEPARADOR~";
    private boolean cacheHabilitada = false;
    private Jdbc od = null;
    private boolean logAccesosBBDD = false;

    public CacheTablasOrigenDatos(Jdbc od) {
        this.comunConstructores(od, false);
    }

    private void comunConstructores(Jdbc od, boolean habilitarCache) {
        this.cacheHabilitada = false;
        this.od = od;
        this.listaDeIdInfyTabla = new HashMap<String, List<Long>>();
        this.listaDeRecordCountTablasCompletas = new HashMap<String, Long>();
        this.cacheHabilitada = habilitarCache;
        this.correspondenciaIdLogicoIdFisico = new ArrayList<Long>();
        this.logAccesosBBDD = od.getLogAccesosBBDD();
    }

    private boolean openRecordSet(String sql, String sqlPreparedStatement, List<Object> parametrosPreparedStatement) throws ExceptionMotor {
        try {
            this.rs = this.getResultSet(sql, sqlPreparedStatement, parametrosPreparedStatement);
            return true;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public ResultSet getResultSet(String sql, String sqlPreparedStatement, List<Object> parametrosPreparedStatement) throws ExceptionMotor {
        try {
            this.cierraObjetosBBDD();
            if (parametrosPreparedStatement != null && parametrosPreparedStatement.size() > 0) {
                try {
                    PreparedStatement ps = this.od.ejecutaPreparedStatement(sqlPreparedStatement, parametrosPreparedStatement);
                    return ps.getResultSet();
                }
                catch (ExceptionMotor e) {
                    // empty catch block
                }
            }
            return this.od.ejecutaQuery(sql);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    private boolean openRecordSetExtra(String sql, String cadena_para_cacheUltimaTablaFiltradaNombreeIdInf) throws ExceptionMotor {
        try {
            this.cierraObjetosBBDDExtra();
            this.cacheUltimaTablaFiltradaNombreeIdInf = cadena_para_cacheUltimaTablaFiltradaNombreeIdInf;
            this.cacheUltimaTablaFiltradaConsulta = this.od.createStatement();
            if (this.logAccesosBBDD) {
                System.out.println("Sql : " + sql);
            }
            this.cacheUltimaTablaFiltrada = this.cacheUltimaTablaFiltradaConsulta.executeQuery(sql);
            return true;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    private boolean refrescaListaDeIDsTablas(String nombreTabla, long idInfFisico) throws ExceptionMotor {
        try {
            this.listaTraducciones = null;
            if (idInfFisico < 1L) {
                return false;
            }
            if (this.cacheHabilitada) {
                this.listaTraducciones = this.listaDeIdInfyTabla.get(nombreTabla.toUpperCase() + this.separador + String.valueOf(idInfFisico));
            }
            if (this.listaTraducciones == null) {
                this.sqlPreparedStatement = this.sSQL = "Select Id from " + this.od.getShema() + this.od.getNombreFisicoDeTabla(nombreTabla);
                this.parametrosPreparedStatement.clear();
                if (idInfFisico > 0L) {
                    this.sSQL = this.sSQL.concat(" where IDINF = " + String.valueOf(idInfFisico));
                    this.sqlPreparedStatement = this.sqlPreparedStatement.concat(" where IDINF = ?");
                    this.parametrosPreparedStatement.add((int)idInfFisico);
                }
                if (this.dameCriterioDeOrdenacionDeTabla(nombreTabla).length() > 0) {
                    this.sSQL = this.sSQL + this.dameCriterioDeOrdenacionDeTabla(nombreTabla);
                    this.sqlPreparedStatement = this.sqlPreparedStatement.concat(this.dameCriterioDeOrdenacionDeTabla(nombreTabla));
                } else {
                    this.sSQL = this.sSQL.concat(" order by ID asc");
                    this.sqlPreparedStatement = this.sqlPreparedStatement.concat(" order by ID asc");
                }
                if (!this.openRecordSet(this.sSQL, this.sqlPreparedStatement, this.parametrosPreparedStatement)) {
                    this.cierraObjetosBBDD();
                    return false;
                }
                this.listaTraducciones = null;
                this.listaTraducciones = new ArrayList<Long>();
                if (this.rs.first()) {
                    do {
                        this.listaTraducciones.add(this.rs.getLong("ID"));
                    } while (this.rs.next());
                }
                if (this.cacheHabilitada) {
                    this.listaDeIdInfyTabla.put(nombreTabla.toUpperCase() + this.separador + String.valueOf(idInfFisico), this.listaTraducciones);
                }
            }
            this.cierraObjetosBBDD();
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public void setCacheHabilitada(boolean nuevoEstado) throws ExceptionMotor {
        try {
            if (this.getCacheHabilitada() != nuevoEstado) {
                this.clearCache();
                this.cacheHabilitada = nuevoEstado;
            }
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public boolean isCacheUltimaTablaFiltradaHabilitada() {
        return this.cacheUltimaTablaFiltradaHabilitada;
    }

    public void setTablaIdInfCacheHabilitada(boolean nuevoEstado) {
        this.cacheUltimaTablaFiltradaHabilitada = nuevoEstado;
        try {
            this.cacheUltimaTablaFiltrada.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.cacheUltimaTablaFiltradaConsulta.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cacheUltimaTablaFiltrada = null;
        this.cacheUltimaTablaFiltradaConsulta = null;
        this.cacheUltimaTablaFiltradaNombreeIdInf = "";
    }

    public boolean getCacheHabilitada() {
        return this.cacheHabilitada;
    }

    private long getRecordCount(String nombreTabla, long idInfFisico, boolean actualizarRecordCount) throws ExceptionMotor {
        try {
            Long rc = null;
            if (this.cacheHabilitada) {
                rc = this.listaDeRecordCountTablasCompletas.get(nombreTabla.toUpperCase() + this.separador + String.valueOf(idInfFisico));
            }
            if (idInfFisico <= 0L) {
                return 0L;
            }
            if (rc == null) {
                this.sqlPreparedStatement = this.sSQL = "Select count(*) from " + this.od.getShema() + this.od.getNombreFisicoDeTabla(nombreTabla);
                this.parametrosPreparedStatement.clear();
                this.sSQL = this.sSQL.concat(" where IdInf = " + String.valueOf(idInfFisico));
                this.sqlPreparedStatement = this.sqlPreparedStatement.concat(" where IDINF = ?");
                this.parametrosPreparedStatement.add((int)idInfFisico);
                if (!this.openRecordSet(this.sSQL, this.sqlPreparedStatement, this.parametrosPreparedStatement)) {
                    this.cierraObjetosBBDD();
                    return -1L;
                }
                rc = new Long(0L);
                if (this.rs.first()) {
                    rc = this.rs.getLong(1);
                    this.cierraObjetosBBDD();
                }
                if (actualizarRecordCount) {
                    this.setRecordCount(nombreTabla.toUpperCase() + this.separador + String.valueOf(idInfFisico), rc);
                }
            }
            if (idInfFisico > -1L) {
                this.refrescaListaDeIDsTablas(nombreTabla, idInfFisico);
            }
            this.cierraObjetosBBDD();
            return rc;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public Long getRecordCountDeCache(String nombreTabla, long idInfFisico) throws ExceptionMotor {
        return this.listaDeRecordCountTablasCompletas.get(nombreTabla.toUpperCase() + this.separador + String.valueOf(idInfFisico));
    }

    public long getRecordCount(String nombreTabla, long idInfFisico) throws ExceptionMotor {
        return this.getRecordCount(nombreTabla, idInfFisico, true);
    }

    public void setRecordCount(String nombreTabla, long newRecordCount) throws ExceptionMotor {
        try {
            if (this.cacheHabilitada) {
                this.listaDeRecordCountTablasCompletas.put(nombreTabla.toUpperCase(), new Long(newRecordCount));
            }
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    private long getIdLogicoFromArray(List<Long> lista, long idFisico) throws ExceptionMotor {
        for (int i = 0; i < this.listaTraducciones.size(); ++i) {
            if (this.listaTraducciones.get(i) != idFisico) continue;
            return new Long(i + 1);
        }
        return -1L;
    }

    public long getIdLogico4Row(String nombreTabla, long idInf, long idFisico, long idInfFisico) throws ExceptionMotor {
        try {
            if (!this.refrescaListaDeIDsTablas(nombreTabla, idInfFisico)) {
                return -1L;
            }
            if (this.listaTraducciones == null) {
                return 0L;
            }
            return this.getIdLogicoFromArray(this.listaTraducciones, idFisico);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public long getIdLogico4Row(String nombreTabla, long idFisico) throws ExceptionMotor {
        try {
            long idLogico = -1L;
            if (this.cacheHabilitada) {
                Set<String> claves = this.listaDeIdInfyTabla.keySet();
                Iterator<String> it = claves.iterator();
                String clave = "";
                while (it.hasNext()) {
                    clave = it.next();
                    if (!clave.startsWith(nombreTabla.toUpperCase() + this.separador)) continue;
                    this.listaTraducciones = this.listaDeIdInfyTabla.get(clave);
                    idLogico = this.getIdLogicoFromArray(this.listaTraducciones, idFisico);
                    if (idLogico <= 0L) continue;
                    return idLogico;
                }
            } else {
                this.sSQL = "Select IDINF from " + this.od.getShema() + this.od.getNombreFisicoDeTabla(nombreTabla) + " where " + "ID" + " = " + idFisico;
                this.sqlPreparedStatement = "Select IDINF from " + this.od.getShema() + this.od.getNombreFisicoDeTabla(nombreTabla) + " where " + "ID" + " = ?";
                this.parametrosPreparedStatement.clear();
                this.parametrosPreparedStatement.add((int)idFisico);
                if (!this.openRecordSet(this.sSQL, this.sqlPreparedStatement, this.parametrosPreparedStatement)) {
                    this.cierraObjetosBBDD();
                    return -1L;
                }
                long idInf = 0L;
                if (this.rs.first()) {
                    try {
                        idInf = this.rs.getLong(1);
                    }
                    catch (Exception Ex) {
                        // empty catch block
                    }
                }
                this.cierraObjetosBBDD();
                this.sqlPreparedStatement = this.sSQL = "Select ID from " + this.od.getShema() + this.od.getNombreFisicoDeTabla(nombreTabla);
                this.parametrosPreparedStatement.clear();
                if (idInf > 0L) {
                    this.sSQL = this.sSQL.concat(" where IDINF = " + String.valueOf(idInf));
                    this.sqlPreparedStatement = this.sqlPreparedStatement.concat(" where IDINF = ?");
                    this.parametrosPreparedStatement.add((int)idInf);
                }
                if (this.dameCriterioDeOrdenacionDeTabla(nombreTabla).length() > 0) {
                    this.sSQL = this.sSQL + this.dameCriterioDeOrdenacionDeTabla(nombreTabla);
                    this.sqlPreparedStatement = this.sqlPreparedStatement.concat(this.dameCriterioDeOrdenacionDeTabla(nombreTabla));
                } else {
                    this.sSQL = this.sSQL.concat(" order by ID asc");
                    this.sqlPreparedStatement = this.sqlPreparedStatement.concat(" order by ID asc");
                }
                if (!this.openRecordSet(this.sSQL, this.sqlPreparedStatement, this.parametrosPreparedStatement)) {
                    return -1L;
                }
                boolean encontrado = false;
                if (this.rs.first()) {
                    idInf = 1L;
                    while (true) {
                        if (this.rs.getLong("ID") == idFisico) {
                            encontrado = true;
                            break;
                        }
                        if (!this.rs.next()) break;
                        ++idInf;
                    }
                }
                this.cierraObjetosBBDD();
                if (encontrado) {
                    return idInf;
                }
            }
            return -1L;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public Long getIdFisico4Row(String nombreTabla, long posicionObtener, long idInfFisico) throws ExceptionMotor {
        try {
            if (!this.refrescaListaDeIDsTablas(nombreTabla, idInfFisico)) {
                return -1L;
            }
            if (this.listaTraducciones == null || this.listaTraducciones.size() == 0) {
                return -1L;
            }
            if (posicionObtener > 0L) {
                try {
                    return this.listaTraducciones.get((int)posicionObtener - 1);
                }
                catch (IndexOutOfBoundsException io) {
                    return -1L;
                }
            }
            if (posicionObtener == -2L) {
                return this.listaTraducciones.get(this.listaTraducciones.size() - 1);
            }
            return this.listaTraducciones.get(0);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    private boolean cargaCacheTablaIdInf(String nombreTabla, long idInf) throws ExceptionMotor {
        try {
            String sSQL = "Select * from " + this.od.getShema() + this.od.getNombreFisicoDeTabla(nombreTabla);
            if (idInf > 0L) {
                sSQL = sSQL.concat(" where IDINF = " + String.valueOf(idInf));
            }
            if (this.openRecordSetExtra(sSQL = this.dameCriterioDeOrdenacionDeTabla(nombreTabla).length() > 0 ? sSQL + this.dameCriterioDeOrdenacionDeTabla(nombreTabla) : sSQL.concat(" order by ID asc"), nombreTabla + "~" + String.valueOf(idInf))) {
                return true;
            }
            this.cacheUltimaTablaFiltradaNombreeIdInf = "";
            return false;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, ITablaMotorEntrada> getRecord4Row(String nombreTabla, long idInfFisico, long posicionObtener, long idFisicoLong, int nivel) throws ExceptionMotor {
        String idFisico;
        if (nivel != 0) {
            if (idInfFisico < 1L || posicionObtener < 1L) {
                idFisicoLong = 0L;
            }
            if (idFisicoLong < 1L) {
                idFisicoLong = this.getIdFisico4Row(nombreTabla, posicionObtener, idInfFisico);
            }
        }
        if ((idFisico = String.valueOf(idFisicoLong)).compareToIgnoreCase("-1") == 0) {
            return null;
        }
        if (this.isCacheUltimaTablaFiltradaHabilitada()) {
            if (this.cacheUltimaTablaFiltradaNombreeIdInf.compareToIgnoreCase(nombreTabla + "~" + String.valueOf(idInfFisico)) != 0) {
                this.cargaCacheTablaIdInf(nombreTabla, idInfFisico);
            }
            if (this.cacheUltimaTablaFiltradaNombreeIdInf.length() > 0) {
                try {
                    if (posicionObtener == -1L) {
                        this.cacheUltimaTablaFiltrada.first();
                        return (Map)this.od.obtenerRegistroDeTabla(this.cacheUltimaTablaFiltrada, 0);
                    }
                    if (posicionObtener == -2L) {
                        this.cacheUltimaTablaFiltrada.last();
                        return (Map)this.od.obtenerRegistroDeTabla(this.cacheUltimaTablaFiltrada, 0);
                    }
                    if (this.cacheUltimaTablaFiltrada.getRow() == 0) {
                        this.cacheUltimaTablaFiltrada.first();
                    }
                    do {
                        if (idFisicoLong != this.cacheUltimaTablaFiltrada.getLong("ID")) continue;
                        return (Map)this.od.obtenerRegistroDeTabla(this.cacheUltimaTablaFiltrada, 0);
                    } while (!(idFisicoLong < this.cacheUltimaTablaFiltrada.getLong("ID") && !this.od.isOrigenDeDatosOrdenadoPorCriterio() ? !this.cacheUltimaTablaFiltrada.previous() : !this.cacheUltimaTablaFiltrada.next()));
                }
                catch (Exception ex) {
                    throw new ExceptionMotor("No encuentro en la tabla el registro " + ex.toString());
                }
            }
        }
        this.sSQL = "Select * from " + this.od.getShema() + this.od.getNombreFisicoDeTabla(nombreTabla) + " where " + "ID" + " = " + idFisico;
        this.sqlPreparedStatement = "Select * from " + this.od.getShema() + this.od.getNombreFisicoDeTabla(nombreTabla) + " where " + "ID" + " = ?";
        this.parametrosPreparedStatement.clear();
        this.parametrosPreparedStatement.add(Integer.valueOf(idFisico));
        if (idInfFisico > 0L) {
            this.sSQL = this.sSQL.concat(" and IDINF = " + String.valueOf(idInfFisico));
            this.sqlPreparedStatement = this.sqlPreparedStatement.concat(" and IDINF = ?");
            this.parametrosPreparedStatement.add((int)idInfFisico);
        }
        this.sSQL = this.sSQL + this.dameCriterioDeOrdenacionDeTabla(nombreTabla);
        this.sqlPreparedStatement = this.sqlPreparedStatement.concat(this.dameCriterioDeOrdenacionDeTabla(nombreTabla));
        if (!this.openRecordSet(this.sSQL, this.sqlPreparedStatement, this.parametrosPreparedStatement)) {
            this.cierraObjetosBBDD();
            return null;
        }
        {
            catch (Exception ex) {
                throw new ExceptionMotor(ex);
            }
            try {
                this.rs.first();
                return (Map)this.od.obtenerRegistroDeTabla(this.rs, 0);
            }
            catch (Exception Ex) {}
            {
                this.cierraObjetosBBDD();
                return null;
            }
        }
    }

    public long getUltimoIDLogico(String nombreTabla, long idInf, long idInfFisico) throws ExceptionMotor {
        try {
            if (!this.refrescaListaDeIDsTablas(nombreTabla, idInfFisico)) {
                return -1L;
            }
            if (this.listaTraducciones == null) {
                return 0L;
            }
            return this.listaTraducciones.size();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public long getSiguienteIDFisico(String nombreTabla) throws ExceptionMotor {
        try {
            Long lastIDFisico = null;
            if (lastIDFisico == null) {
                this.sSQL = "Select max(ID) from " + this.od.getShema() + this.od.getNombreFisicoDeTabla(nombreTabla);
                this.parametrosPreparedStatement.clear();
                if (!this.openRecordSet(this.sSQL, this.sSQL, this.parametrosPreparedStatement)) {
                    this.cierraObjetosBBDD();
                    return -1L;
                }
                lastIDFisico = new Long(0L);
                if (this.rs.first()) {
                    try {
                        lastIDFisico = new Long(this.rs.getObject(1).toString());
                    }
                    catch (Exception Ex) {
                        lastIDFisico = new Long(0L);
                    }
                }
            }
            this.cierraObjetosBBDD();
            return lastIDFisico;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public void cierraObjetosBBDD() {
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.rs = null;
        }
    }

    private void cierraObjetosBBDDExtra() {
        if (this.cacheUltimaTablaFiltrada != null) {
            try {
                this.cacheUltimaTablaFiltrada.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.cacheUltimaTablaFiltrada = null;
        }
        if (this.cacheUltimaTablaFiltradaConsulta != null) {
            try {
                this.cacheUltimaTablaFiltradaConsulta.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cacheUltimaTablaFiltradaConsulta = null;
        }
        this.cacheUltimaTablaFiltradaNombreeIdInf = "";
    }

    public boolean clearCache() throws ExceptionMotor {
        try {
            this.cierraObjetosBBDD();
            this.cierraObjetosBBDDExtra();
            if (this.listaTraducciones != null) {
                this.listaTraducciones.clear();
            }
            if (this.listaDeIdInfyTabla != null) {
                this.listaDeIdInfyTabla.clear();
            }
            if (this.listaDeRecordCountTablasCompletas != null) {
                this.listaDeRecordCountTablasCompletas.clear();
            }
            return true;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    private boolean borraElementoDeColeccion(String nombreTabla, long idInfFisico, int index, long idFisico) throws ExceptionMotor {
        try {
            if (!this.cacheHabilitada) {
                return true;
            }
            this.listaTraducciones = this.listaDeIdInfyTabla.get(nombreTabla.toUpperCase() + this.separador + String.valueOf(idInfFisico));
            this.listaTraducciones.remove(index);
            this.listaDeIdInfyTabla.put(nombreTabla.toUpperCase() + this.separador + String.valueOf(idInfFisico), this.listaTraducciones);
            this.listaTraducciones = null;
            this.setRecordCount(nombreTabla.toUpperCase() + this.separador + String.valueOf(idInfFisico), this.getRecordCount(nombreTabla, idInfFisico, false) - 1L);
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public boolean borrarElemento(String nombreTabla, long idInf, long idInfFisico, long idFisico) throws ExceptionMotor {
        try {
            if (!this.cacheHabilitada) {
                return true;
            }
            long idLeido = -1L;
            if (!this.refrescaListaDeIDsTablas(nombreTabla, idInfFisico)) {
                return false;
            }
            if (this.listaTraducciones == null || this.listaTraducciones.size() == 0) {
                return false;
            }
            for (int i = 0; i < this.listaTraducciones.size(); ++i) {
                idLeido = this.listaTraducciones.get(i);
                if (idLeido == idFisico) {
                    return this.borraElementoDeColeccion(nombreTabla, idInfFisico, i, idFisico);
                }
                if (idLeido > idFisico) break;
            }
            return false;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public boolean borrarTabla(String nombreTabla, long idInfFisico) throws ExceptionMotor {
        try {
            if (!this.cacheHabilitada) {
                return true;
            }
            Long numReg = this.listaDeRecordCountTablasCompletas.get(nombreTabla.toUpperCase() + this.separador + String.valueOf(idInfFisico));
            if (numReg == null) {
                numReg = new Long(0L);
            }
            this.setRecordCount(nombreTabla.toUpperCase() + this.separador + String.valueOf(idInfFisico), 0L);
            numReg = this.getRecordCount(nombreTabla, idInfFisico, false) - numReg;
            this.listaTraducciones = new ArrayList<Long>();
            this.listaDeIdInfyTabla.put(nombreTabla.toUpperCase() + this.separador + String.valueOf(idInfFisico), this.listaTraducciones);
            this.listaTraducciones = null;
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public long getIdInfFromIdFisico(String nombreTabla, long idFisico) throws ExceptionMotor {
        try {
            nombreTabla = nombreTabla.toUpperCase();
            if (this.cacheHabilitada) {
                long idLeido = -1L;
                Set<String> claves = this.listaDeIdInfyTabla.keySet();
                Iterator<String> it = claves.iterator();
                String clave = "";
                block5: while (it.hasNext()) {
                    clave = it.next();
                    if (!clave.startsWith(nombreTabla.toUpperCase() + this.separador)) continue;
                    this.listaTraducciones = this.listaDeIdInfyTabla.get(clave);
                    if (this.listaTraducciones == null) continue;
                    for (int i = 0; i < this.listaTraducciones.size(); ++i) {
                        idLeido = this.listaTraducciones.get(i);
                        if (idLeido == idFisico) {
                            return new Long(clave.substring(new String(nombreTabla.toUpperCase() + this.separador).length()));
                        }
                        if (idLeido > idFisico) continue block5;
                    }
                }
            } else {
                this.sSQL = "Select IDINF from " + this.od.getShema() + this.od.getNombreFisicoDeTabla(nombreTabla) + " where " + "ID" + " = " + idFisico;
                this.sqlPreparedStatement = "Select IDINF from " + this.od.getShema() + this.od.getNombreFisicoDeTabla(nombreTabla) + " where " + "ID" + " = ?";
                this.parametrosPreparedStatement.clear();
                this.parametrosPreparedStatement.add((int)idFisico);
                if (!this.openRecordSet(this.sSQL, this.sqlPreparedStatement, this.parametrosPreparedStatement)) {
                    this.cierraObjetosBBDD();
                    return -1L;
                }
                long idInf = -1L;
                if (this.rs.first()) {
                    try {
                        idInf = this.rs.getLong(1);
                    }
                    catch (Exception Ex) {
                        // empty catch block
                    }
                }
                this.cierraObjetosBBDD();
                return idInf;
            }
            this.cierraObjetosBBDD();
            return -1L;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public boolean borrarElemento(String nombreTabla, long idFisico, long idInfFisico) throws ExceptionMotor {
        try {
            if (!this.cacheHabilitada) {
                return true;
            }
            nombreTabla = nombreTabla.toUpperCase();
            return this.borrarElemento(nombreTabla, idFisico, idInfFisico);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public boolean addElemento(String nombreTabla, long idInfUnica, long idFisico) throws ExceptionMotor {
        try {
            if (!this.cacheHabilitada) {
                return true;
            }
            this.listaTraducciones = null;
            this.listaTraducciones = this.listaDeIdInfyTabla.get(nombreTabla.toUpperCase() + this.separador + String.valueOf(idInfUnica));
            if (this.listaTraducciones == null) {
                this.listaTraducciones = new ArrayList<Long>();
            }
            this.listaTraducciones.add(idFisico);
            this.listaDeIdInfyTabla.put(nombreTabla.toUpperCase() + this.separador + String.valueOf(idInfUnica), this.listaTraducciones);
            this.listaTraducciones = null;
            this.setRecordCount(nombreTabla.toUpperCase() + this.separador + String.valueOf(idInfUnica), this.getRecordCount(nombreTabla, idInfUnica, false) + 1L);
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public List<Long> correspondenciaIDLogicoIDFisico(String nombreTabla, long idInf) throws ExceptionMotor {
        try {
            if (this.correspondenciaIdLogicoIdFisico.size() > 0) {
                return this.correspondenciaIdLogicoIdFisico;
            }
            this.sSQL = "Select ID from " + this.od.getShema() + this.od.getNombreFisicoDeTabla(nombreTabla) + " where " + "IDINF" + " = " + idInf;
            this.sqlPreparedStatement = "Select ID from " + this.od.getShema() + this.od.getNombreFisicoDeTabla(nombreTabla) + " where " + "IDINF" + " = ?";
            this.parametrosPreparedStatement.clear();
            this.parametrosPreparedStatement.add((int)idInf);
            if (this.dameCriterioDeOrdenacionDeTabla(nombreTabla).length() > 0) {
                this.sSQL = this.sSQL + this.dameCriterioDeOrdenacionDeTabla(nombreTabla);
                this.sqlPreparedStatement = this.sqlPreparedStatement.concat(this.dameCriterioDeOrdenacionDeTabla(nombreTabla));
            } else {
                this.sSQL = this.sSQL.concat(" order by ID asc");
                this.sqlPreparedStatement = this.sqlPreparedStatement.concat(" order by ID asc");
            }
            if (!this.openRecordSet(this.sSQL, this.sqlPreparedStatement, this.parametrosPreparedStatement)) {
                this.cierraObjetosBBDD();
                return this.correspondenciaIdLogicoIdFisico;
            }
            if (this.rs.first()) {
                do {
                    this.correspondenciaIdLogicoIdFisico.add(this.rs.getLong("ID"));
                } while (this.rs.next());
            }
            this.cierraObjetosBBDD();
            return this.correspondenciaIdLogicoIdFisico;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public boolean limpiarcorrespondenciaIDLogicoIDFisico() throws ExceptionMotor {
        try {
            this.correspondenciaIdLogicoIdFisico = null;
            this.correspondenciaIdLogicoIdFisico = new ArrayList<Long>();
            return true;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    private String dameCriterioDeOrdenacionDeTabla(String nombreTabla) {
        if (this.criteriosOrdenacion == null) {
            return "";
        }
        String ret = this.criteriosOrdenacion.get(nombreTabla.toUpperCase());
        if (ret != null) {
            return ret.toString();
        }
        return "";
    }

    public String getSeparador() {
        return this.separador;
    }
}

