/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.motor.modelo.sesion;

import es.aeat.pftw.mtrc.IAop;
import es.aeat.pftw.mtrc.configuracion.GestorConfiguracionLooper;
import es.aeat.pftw.mtrc.configuracion.IGestorConfiguracionLooper;
import es.aeat.pftw.mtrc.configuracion.RegEntrada;
import es.aeat.pftw.mtrc.gestionFicheros.GestorFicheros;
import es.aeat.pftw.mtrc.gestionFicheros.IGestorFicheros;
import es.aeat.pftw.mtrc.motor.IMotor;
import es.aeat.pftw.mtrc.motor.IPartidaModificada;
import es.aeat.pftw.mtrc.motor.modelo.IModelo;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesionExtendida;
import es.aeat.pftw.mtrc.motor.modelo.sesion.SesionCloned;
import es.aeat.pftw.mtrc.motor.modelo.sesion.tools.GestionOperaciones;
import es.aeat.pftw.mtrc.motor.modelo.sesion.tools.GestionReglas;
import es.aeat.pftw.mtrc.motor.modelo.sesion.tools.IGestionOperaciones;
import es.aeat.pftw.mtrc.motor.modelo.sesion.tools.IGestionOperacionesExtendida;
import es.aeat.pftw.mtrc.motor.modelo.sesion.tools.IGestionReglas;
import es.aeat.pftw.mtrc.motor.modelo.sesion.tools.IGestionReglasExtendida;
import es.aeat.pftw.mtrc.origenDatos.IOrigenDatos;
import es.aeat.pftw.mtrc.puente.BusquedaNodos;
import es.aeat.pftw.mtrc.puente.IBusquedaNodos;
import es.aeat.pftw.mtrc.puente.IRegTablaModificada;
import es.aeat.pftw.mtrc.puente.ITablaMotor;
import es.aeat.pftw.mtrc.puente.ListaTablaMotor;
import es.aeat.pftw.mtrc.puente.TablaMotor;
import es.aeat.pftw.mtrc.tipos.ITipoListaRegistroDeTablasAfectadasEnUnaEjecucion;
import es.aeat.pftw.mtrc.tipos.TipoDatosCampoValor;
import es.aeat.pftw.mtrc.tipos.TipoListaPartidasAfectadasEnUnaEjecucion;
import es.aeat.pftw.mtrc.tipos.TipoListaRegistroDeTablasAfectadasEnUnaEjecucion;
import es.aeat.pftw.mtrc.utilidades.ClassLoaderFromBytes;
import es.aeat.pftw.mtrc.utilidades.FreezerMotor;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrp.IInteraccionConUsuario;
import es.aeat.pftw.mtrp.configuracion.IRegEntrada;
import es.aeat.pftw.mtrp.configuracion.IRegRelacionada;
import es.aeat.pftw.mtrp.configuracion.IRegTabla;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.procesadorReglas.IPartidaModificadaReglas;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampoValor;
import es.aeat.pftw.mtrp.tipos.ITipoListaPartidasAfectadasEnUnaEjecucion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Sesion
implements ISesionExtendida,
Serializable {
    private static final long serialVersionUID = 1L;
    private String id = "";
    private long creadoTimeStamp = 0L;
    private long ultimoAccesoTimeStamp = 0L;
    private FreezerMotor fm = null;
    private Map<String, FreezerMotor> fmNoSingleton = null;
    private IGestorFicheros gestor = null;
    private boolean usarContadorRegistros = true;
    private Integer maximoDeErroresPersonalizado = null;
    private boolean comprobarCaracteresEnPartidaModificada = true;
    Map<String, String> registrosA\u00f1adidosPorReglasAlImportar = null;
    private transient IModelo modelo = null;
    private transient IMotor motor = null;
    protected transient ClassLoaderFromBytes cloader = null;
    private String aliasModelo = "";
    private IOrigenDatos origenDeDatos = null;
    private IGestionReglas gestionReglas = null;
    private IGestionOperaciones gestionOperaciones = null;
    private boolean enabled = true;
    private String infoSwap = null;
    private String punteroActual = "DEFAULT";
    private List<String> nombrePunteros = new ArrayList<String>();
    private List<String> nombreTablaPunteros = new ArrayList<String>();
    private List<Object> nodosSalvados = new ArrayList<Object>();
    private boolean cacheHabilitada = false;
    private Map<String, ITablaMotor> nodoPrincipal = null;
    private Map<String, IBusquedaNodos> busquedaNodosObj = null;
    private List<ITipoListaPartidasAfectadasEnUnaEjecucion> listaPartidasAfectadasEnUnaEjecucion = null;
    private ITipoListaPartidasAfectadasEnUnaEjecucion listaPartidasAfectadasEnUnaEjecucionParaUsuario = null;
    private List<ITipoListaRegistroDeTablasAfectadasEnUnaEjecucion> listaRegistroDeTablasAfectadasEnUnaEjecucion = null;
    private boolean arbolConstruido = false;
    private boolean flagIgnorarRegistrosDeEstados = false;
    private boolean modoSilencioso = false;
    private Map<String, List<IPartidaModificada>> listenersPartidaModificada = null;
    private Map<String, List<IPartidaModificada>> listenersTablaModificada = null;
    private boolean partidayTablasListenersEnabled = true;
    private Map<Integer, String> partidaQueInvocaRegla = new HashMap<Integer, String>();
    private boolean ejecutandoBatchAnniadirRegistro = false;
    private boolean funcionesErrorComportamientoEspecial = false;
    private int posicionSello = -1;
    private String entradaTransOpciones;
    private transient IGestorConfiguracionLooper gestorConfiguracionLooper = null;
    private Object claseExportacionBOE = null;
    private Object claseExportacionXML = null;
    private transient Object claseValidacionPrevia = null;
    private transient Object claseValidacionEstructura = null;
    private transient Object claseValidacionSecuencia = null;
    private Object claseValidacionCaracteres = null;
    private transient Object claseReglasValidacion = null;
    private transient Object claseReglasValidacionXML = null;
    private transient IInteraccionConUsuario instanciaInteraccionConUsuario = null;

    @Override
    public void dispose() throws ExceptionMotor {
        this.listaPartidasAfectadasEnUnaEjecucion = null;
        this.listaPartidasAfectadasEnUnaEjecucionParaUsuario = null;
        this.listaRegistroDeTablasAfectadasEnUnaEjecucion = null;
        this.listenersPartidaModificada = null;
        this.listenersTablaModificada = null;
        this.nodoPrincipal = null;
        this.busquedaNodosObj = null;
        this.nodosSalvados = null;
        this.nombrePunteros = null;
        this.nombreTablaPunteros = null;
        this.modelo = null;
        this.motor = null;
        if (this.cloader != null) {
            this.cloader.dispose();
            this.cloader = null;
        }
        this.eliminaTemporalesImportacionExportacion();
        if (this.gestionReglas != null) {
            ((IGestionReglasExtendida)this.gestionReglas).dispose();
            this.gestionReglas = null;
        }
        if (this.origenDeDatos != null) {
            this.origenDeDatos.dispose();
            this.origenDeDatos = null;
        }
        if (this.gestionOperaciones != null) {
            ((IGestionOperacionesExtendida)this.gestionOperaciones).dispose();
            this.gestionOperaciones = null;
        }
        if (this.gestorConfiguracionLooper != null) {
            this.gestorConfiguracionLooper.dispose();
            this.gestorConfiguracionLooper = null;
        }
        if (this.fm != null) {
            if (this.fm.isFreezed()) {
                this.fm.cancelfreeze();
            }
            this.fm.dispose();
            this.fm = null;
        }
    }

    @Override
    public ClassLoaderFromBytes getCloader() {
        return this.cloader;
    }

    @Override
    public void setCloader(ClassLoaderFromBytes cloader) {
        this.cloader = cloader;
    }

    protected void disposeVars() throws Exception {
        if (this.getVarNodoPrincipal() != null) {
            this.getVarNodoPrincipal().clear();
        }
    }

    @Override
    public boolean cerrarConexionOrigenDatos() throws ExceptionMotor {
        try {
            this.disposeVars();
            return ((IGestionOperacionesExtendida)this.getOperaciones()).cerrarConexionOrigenDatos();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean abrirConexionOrigenDatos() throws ExceptionMotor {
        try {
            this.updateUltimaVezAccedido();
            this.disposeVars();
            if (!this.inicializar()) {
                throw new Exception("Error inicializando sesion...");
            }
            return ((IGestionOperacionesExtendida)this.getOperaciones()).abrirConexionOrigenDatos();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean abrirConexionOrigenDatos(Object data) throws ExceptionMotor {
        return this.abrirConexionOrigenDatos(data, null);
    }

    @Override
    public boolean abrirConexionOrigenDatos(Object data, Map<String, String> parametrosInicializacion) throws ExceptionMotor {
        try {
            this.updateUltimaVezAccedido();
            this.disposeVars();
            boolean ret = ((IGestionOperacionesExtendida)this.getOperaciones()).abrirConexionOrigenDatos(data, parametrosInicializacion);
            if (!this.inicializar()) {
                throw new Exception("Error inicializando sesion...");
            }
            return ret;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public Sesion() {
    }

    public Sesion(String infoSwap) {
        this.infoSwap = infoSwap;
    }

    public Sesion(SesionCloned s, IMotor motor, IModelo modelo) throws Exception {
        this.id = s.getId();
        this.creadoTimeStamp = s.getCreadoTimeStamp();
        this.aliasModelo = s.getAliasModelo();
        this.enabled = s.isEnabled();
        this.cacheHabilitada = s.isCacheHabilitada();
        this.flagIgnorarRegistrosDeEstados = s.isFlagIgnorarRegistrosDeEstados();
        this.modoSilencioso = s.isModoSilencioso();
        this.partidayTablasListenersEnabled = s.isPartidayTablasListenersEnabled();
        this.ejecutandoBatchAnniadirRegistro = s.isEjecutandoBatchAnniadirRegistro();
        this.funcionesErrorComportamientoEspecial = s.isFuncionesErrorComportamientoEspecial();
        this.init(new Object[]{motor, modelo, this.id});
        this.abrirConexionOrigenDatos(s.getOrigenDeDatos());
        this.partidaQueInvocaRegla = (Map)((HashMap)s.getPartidaQueInvocaRegla()).clone();
        this.getVarNodoPrincipal().clear();
        this.getVarNodoPrincipal().put("DEFAULT", s.getNodoPrincipal().get("DEFAULT").clone(this));
        for (int i = 0; i < s.getNombrePunteros().size(); ++i) {
            if (s.getNombrePunteros().get(i).equalsIgnoreCase("DEFAULT") || s.getNombreTablaPunteros().get(i).length() <= 0) continue;
            this.createPtr(s.getNombrePunteros().get(i), s.getNombreTablaPunteros().get(i));
        }
        this.setCurrentPtr("DEFAULT");
        Iterator<String> it = s.getNodoPrincipal().keySet().iterator();
        String ptr = "";
        while (it.hasNext()) {
            ptr = it.next();
            this.getVarNodoPrincipal().put(ptr, s.getNodoPrincipal().get(ptr).clone(this));
            this.busquedaNodosObj.get(ptr).clearCache();
        }
        this.setCurrentPtr("DEFAULT");
    }

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            for (Object object : parametros) {
                if (object instanceof IMotor) {
                    this.motor = (IMotor)object;
                    continue;
                }
                if (object instanceof IModelo) {
                    this.modelo = (IModelo)object;
                    continue;
                }
                if (!(object instanceof String)) continue;
                this.id = object.toString();
            }
            this.aliasModelo = this.modelo.getAlias();
            this.creadoTimeStamp = System.currentTimeMillis();
            this.ultimoAccesoTimeStamp = System.currentTimeMillis();
            this.gestionReglas = (IGestionReglas)FuncionesUtiles.getFuncionesUtiles().getInstancia(GestionReglas.class, new Object[]{this});
            this.gestionOperaciones = (GestionOperaciones)FuncionesUtiles.getFuncionesUtiles().getInstancia(GestionOperaciones.class, new Object[]{this});
            this.nombrePunteros.add("DEFAULT");
            this.nombreTablaPunteros.add("");
            this.nodoPrincipal = new HashMap<String, ITablaMotor>();
            this.busquedaNodosObj = new HashMap<String, IBusquedaNodos>();
            this.listaPartidasAfectadasEnUnaEjecucion = new ArrayList<ITipoListaPartidasAfectadasEnUnaEjecucion>();
            this.listaPartidasAfectadasEnUnaEjecucionParaUsuario = null;
            this.setListaRegistroDeTablasAfectadasEnUnaEjecucion(new ArrayList<ITipoListaRegistroDeTablasAfectadasEnUnaEjecucion>());
            if (this.getCloader() == null) {
                this.setCloader(this.modelo.getCloader(null));
            }
            this.crearPartidasDinamicamente();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public void crearPartidasDinamicamente() throws Exception {
        List<String> entradas;
        RegEntrada nuevaEntrada;
        if (this.modelo.getGestorConfiguracion().getEntrada("MAX_REG") == null) {
            nuevaEntrada = new RegEntrada();
            nuevaEntrada.setIdVariable("MAX_REG");
            nuevaEntrada.setIdPartida("MAX_REG");
            nuevaEntrada.setIdTabla(this.modelo.getGestorConfiguracion().getTablaNivel(0).getIdTabla());
            nuevaEntrada.setTipoDato("ENTERO");
            nuevaEntrada.setValorPorDefecto("0");
            nuevaEntrada.setEstadoInicial("FICTICIA");
            this.modelo.getGestorConfiguracion().getConjuntoDeEntradas().put("MAX_REG", nuevaEntrada);
            entradas = this.modelo.getGestorConfiguracion().getCamposDeTabla(this.modelo.getGestorConfiguracion().getTablaNivel(0).getIdTabla());
            if (entradas == null) {
                this.modelo.getGestorConfiguracion().addConjuntoDeCamposDeTabla(this.modelo.getGestorConfiguracion().getTablaNivel(0).getIdTabla());
                entradas = this.modelo.getGestorConfiguracion().getCamposDeTabla(this.modelo.getGestorConfiguracion().getTablaNivel(0).getIdTabla());
            }
            entradas.add("MAX_REG");
        }
        if (this.isUsarContadorRegistros() && this.modelo.getGestorConfiguracion().getEntrada("CON_REG") == null) {
            nuevaEntrada = new RegEntrada();
            nuevaEntrada.setIdVariable("CON_REG");
            nuevaEntrada.setIdPartida("CON_REG");
            nuevaEntrada.setIdTabla(this.modelo.getGestorConfiguracion().getTablaNivel(0).getIdTabla());
            nuevaEntrada.setTipoDato("ENTERO");
            nuevaEntrada.setValorPorDefecto("0");
            nuevaEntrada.setEstadoInicial("FICTICIA");
            this.modelo.getGestorConfiguracion().getConjuntoDeEntradas().put("CON_REG", nuevaEntrada);
            entradas = this.modelo.getGestorConfiguracion().getCamposDeTabla(this.modelo.getGestorConfiguracion().getTablaNivel(0).getIdTabla());
            if (entradas == null) {
                this.modelo.getGestorConfiguracion().addConjuntoDeCamposDeTabla(this.modelo.getGestorConfiguracion().getTablaNivel(0).getIdTabla());
                entradas = this.modelo.getGestorConfiguracion().getCamposDeTabla(this.modelo.getGestorConfiguracion().getTablaNivel(0).getIdTabla());
            }
            entradas.add("CON_REG");
        }
    }

    @Override
    public void setClaseValidacionPrevia(Object validacionPrevia) {
        this.claseValidacionPrevia = validacionPrevia;
    }

    @Override
    public void setClaseValidacionEstructura(Object validacionEstructura) {
        this.claseValidacionEstructura = validacionEstructura;
    }

    public void setClaseValidacionSecuencia(Object validacionSecuencia) {
        this.claseValidacionSecuencia = validacionSecuencia;
    }

    @Override
    public void setClaseValidacionSecuencias(Object cVc) {
        this.claseValidacionSecuencia = cVc;
    }

    @Override
    public void setClaseValidacionCaracteres(Object validacionCaracteres) {
        this.claseValidacionCaracteres = validacionCaracteres;
    }

    @Override
    public String getId() throws ExceptionMotor {
        return this.id;
    }

    @Override
    public boolean isEjecutandoBatchAnniadirRegistro() {
        return this.ejecutandoBatchAnniadirRegistro;
    }

    @Override
    public void setEjecutandoBatchAnniadirRegistro(boolean ejecutandoBatchAnniadirRegistro) {
        this.ejecutandoBatchAnniadirRegistro = ejecutandoBatchAnniadirRegistro;
    }

    @Override
    public List<ITipoListaPartidasAfectadasEnUnaEjecucion> getListaPartidasAfectadasEnUnaEjecucion() {
        return this.listaPartidasAfectadasEnUnaEjecucion;
    }

    @Override
    public void updateUltimaVezAccedido() {
        this.ultimoAccesoTimeStamp = System.currentTimeMillis();
    }

    public void setPunteroActual(String punteroActual) {
        this.punteroActual = punteroActual.toUpperCase();
    }

    @Override
    public String getPunteroActual() {
        return this.punteroActual;
    }

    public List<String> getNombrePunteros() {
        return this.nombrePunteros;
    }

    public List<String> getNombreTablaPunteros() {
        return this.nombreTablaPunteros;
    }

    public void setCacheHabilitada(boolean cacheHabilitada) {
        this.cacheHabilitada = cacheHabilitada;
    }

    public boolean isCacheHabilitada() {
        return this.cacheHabilitada;
    }

    @Override
    public void setModoSilencioso(boolean modoSilencioso) {
        this.modoSilencioso = modoSilencioso;
    }

    @Override
    public boolean isModoSilencioso() {
        return this.modoSilencioso;
    }

    @Override
    public void setIgnorarRegistrosDeEstados(boolean flagIgnorarRegistrosDeEstados) {
        this.flagIgnorarRegistrosDeEstados = flagIgnorarRegistrosDeEstados;
    }

    @Override
    public boolean getIgnorarRegistrosDeEstados() throws ExceptionMotor {
        return this.flagIgnorarRegistrosDeEstados;
    }

    @Override
    public boolean getTablaIdInfCacheHabilitada() throws ExceptionMotor {
        return this.getOrigenDeDatos().getTablaIdInfCacheHabilitada();
    }

    @Override
    public void setTablaIdInfCacheHabilitada(boolean b) throws ExceptionMotor {
        this.getOrigenDeDatos().setTablaIdInfCacheHabilitada(b);
    }

    public void setArbolConstruido(boolean arbolConstruido) {
        this.updateUltimaVezAccedido();
        this.arbolConstruido = arbolConstruido;
    }

    public boolean isArbolConstruido() {
        return this.arbolConstruido;
    }

    public void setVarNodoPrincipal(Map<String, ITablaMotor> nodoPrincipal) {
        this.updateUltimaVezAccedido();
        this.nodoPrincipal = nodoPrincipal;
    }

    @Override
    public Map<String, ITablaMotor> getVarNodoPrincipal() {
        return this.nodoPrincipal;
    }

    public void setBusquedaNodosObj(Map<String, IBusquedaNodos> busquedaNodosObj) {
        this.updateUltimaVezAccedido();
        this.busquedaNodosObj = busquedaNodosObj;
    }

    @Override
    public Map<String, IBusquedaNodos> getBusquedaNodosObj() {
        return this.busquedaNodosObj;
    }

    @Override
    public IGestionReglas getGestionReglas() throws ExceptionMotor {
        this.updateUltimaVezAccedido();
        return this.gestionReglas;
    }

    @Override
    public long getCreadoTimeStamp() throws ExceptionMotor {
        return this.creadoTimeStamp;
    }

    @Override
    public long getUltimoAccesoTimeStamp() throws ExceptionMotor {
        return this.ultimoAccesoTimeStamp;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean habilitar) {
        this.enabled = habilitar;
    }

    @Override
    public void setModelo(IModelo modelo) throws ExceptionMotor {
        this.modelo = modelo;
        try {
            this.crearPartidasDinamicamente();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public void setMotor(IMotor motor) {
        this.motor = motor;
    }

    @Override
    public IModelo getModelo() {
        return this.modelo;
    }

    @Override
    public IMotor getMotor() throws ExceptionMotor {
        return this.motor;
    }

    @Override
    public String getAliasModelo() throws ExceptionMotor {
        return this.aliasModelo;
    }

    @Override
    public IGestionOperaciones getOperaciones() {
        this.updateUltimaVezAccedido();
        return this.gestionOperaciones;
    }

    @Override
    public void setListenersPartidaModificada(Map<String, List<IPartidaModificada>> listenersPartidaModificada) {
        this.listenersPartidaModificada = listenersPartidaModificada;
    }

    @Override
    public Map<String, List<IPartidaModificada>> getListenersPartidaModificada() {
        return this.listenersPartidaModificada;
    }

    @Override
    public void setListenersTablaModificada(Map<String, List<IPartidaModificada>> listenersTablaModificada) {
        this.listenersTablaModificada = listenersTablaModificada;
    }

    @Override
    public Map<String, List<IPartidaModificada>> getListenersTablaModificada() {
        return this.listenersTablaModificada;
    }

    protected void setPartidayTablasListenersEnabled(boolean partidayTablasListenersEnabled) {
        this.partidayTablasListenersEnabled = partidayTablasListenersEnabled;
    }

    protected boolean isPartidayTablasListenersEnabled() {
        return this.partidayTablasListenersEnabled;
    }

    protected boolean inicializar() throws ExceptionMotor {
        try {
            this.updateUltimaVezAccedido();
            boolean ret = this.construirArbol();
            if (this.getVarNodoPrincipal().get(this.getPunteroActual()) != null) {
                ret &= this.actualizarNodos(this.getVarNodoPrincipal().get(this.getPunteroActual()).getNombre());
                this.setNodoPrincipal(this.getVarNodoPrincipal().get(this.getPunteroActual()));
            }
            return ret;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public String partidaQueHizoSaltarRegla(int idRegla) {
        return this.getPartidaQueInvocaRegla().get(idRegla);
    }

    @Override
    public ITablaMotor getNodoPrincipal() {
        return this.getVarNodoPrincipal().get(this.getPunteroActual());
    }

    @Override
    public void setNodoPrincipal(ITablaMotor nuevoNodoPrincipal) {
        this.updateUltimaVezAccedido();
        this.getVarNodoPrincipal().put(this.getPunteroActual(), nuevoNodoPrincipal);
    }

    protected boolean actualizarNodos(String tabla) throws ExceptionMotor {
        try {
            ITablaMotor nodoAux = this.getBusquedaNodosObj().get(this.getPunteroActual()).buscarNodo(tabla, this.getVarNodoPrincipal().get(this.getPunteroActual()));
            this.recorrerNodosHijos(nodoAux);
            return true;
        }
        catch (Exception ex) {
            if (!this.isModoSilencioso()) {
                if (ex instanceof ExceptionMotor) {
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex);
            }
            return false;
        }
    }

    protected void recorrerNodosHijos(ITablaMotor nodo) throws ExceptionMotor {
        block5: {
            ITablaMotor cTaAux = null;
            try {
                if (nodo.getRelacionadas() != null) {
                    for (int i = 0; i < nodo.getRelacionadas().count(); ++i) {
                        cTaAux = nodo.getRelacionadas().getTablaMotor(i);
                        this.actualizarNodo(cTaAux, nodo);
                    }
                }
            }
            catch (Exception ex) {
                if (this.isModoSilencioso()) break block5;
                if (ex instanceof ExceptionMotor) {
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex);
            }
        }
    }

    @Override
    public void actualizarPunterosTablas(ITablaMotor nodo) throws ExceptionMotor {
        this.recorrerNodosHijos(nodo);
    }

    protected void actualizarNodo(ITablaMotor cTaAux, ITablaMotor nodo) throws ExceptionMotor {
        try {
            cTaAux.cerrarTabla();
            cTaAux.setClaveSuperior(nodo.getClaveActiva());
            cTaAux.setClaveUnicaSuperior(nodo.getClaveUnica());
            this.getOperaciones().moveFirst(cTaAux.getNombre());
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean construirArbol(boolean force) throws ExceptionMotor {
        return this.construirArbol(force, "");
    }

    protected boolean construirArbol() throws ExceptionMotor {
        return this.construirArbol(false, "");
    }

    protected boolean construirArbol(boolean force, String nombreTablaPuntero) throws ExceptionMotor {
        if (!this.isArbolConstruido() || force) {
            try {
                IRegTabla tab = this.getModelo().getGestorConfiguracion().getTablaNivel(0);
                if (tab == null) {
                    throw new ExceptionMotor("No existe tabla de nivel 0. Revise el fichero Tablas.xml");
                }
                this.getVarNodoPrincipal().put(this.getPunteroActual(), new TablaMotor(tab.getIdTabla(), null, this));
                this.getVarNodoPrincipal().get(this.getPunteroActual()).setNivel(0);
                this.getBusquedaNodosObj().put(this.getPunteroActual(), new BusquedaNodos(nombreTablaPuntero));
                if (this.getOrigenDeDatos() != null && !this.cargaArbol(this.getVarNodoPrincipal().get(this.getPunteroActual()).getNombre())) {
                    this.setArbolConstruido(false);
                    return false;
                }
                this.anniadirNodos(this.getVarNodoPrincipal().get(this.getPunteroActual()));
                this.setArbolConstruido(true);
                this.checkArbol();
            }
            catch (Exception ex) {
                if (!this.isModoSilencioso()) {
                    if (ex instanceof ExceptionMotor) {
                        throw (ExceptionMotor)ex;
                    }
                    throw new ExceptionMotor(ex);
                }
                return false;
            }
        }
        return true;
    }

    protected boolean checkArbol() throws ExceptionMotor {
        try {
            boolean ret = true;
            if (this.getVarNodoPrincipal() != null) {
                String tablas = this.getVarNodoPrincipal().get(this.getPunteroActual()).dameListaTablas().toUpperCase();
                IRegTabla tab = (IRegTabla)this.getGestorConfiguracionLooper().getPrimerElemento("Tablas".toUpperCase());
                while (tab != null) {
                    if (tablas.indexOf(";" + tab.getIdTabla().toUpperCase() + ";") == -1) {
                        FuncionesUtiles.getFuncionesUtiles().muestraAviso(new ExceptionMotor("La tabla " + tab.getIdTabla() + " no esta relacionada con nadie. Revise fichero Relacionadas.xml"));
                    }
                    tab = (IRegTabla)this.getGestorConfiguracionLooper().getSiguienteElemento();
                }
            }
            return ret;
        }
        catch (Exception ex) {
            if (!this.isModoSilencioso()) {
                if (ex instanceof ExceptionMotor) {
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex);
            }
            return false;
        }
    }

    protected void anniadirNodos(ITablaMotor nodo) throws ExceptionMotor {
        block14: {
            ITablaMotor cTaAux = null;
            try {
                IRegRelacionada rsTaRel = this.getModelo().getGestorConfiguracion().getRelacionada(nodo.getNombre());
                List<Object> res = new ArrayList();
                if (rsTaRel != null) {
                    res = rsTaRel.getTablaRelacionada();
                }
                ListaTablaMotor relacionadas = new ListaTablaMotor();
                nodo.setRelacionadas(relacionadas);
                boolean flagAddNodosHijos = true;
                for (int i = 0; i < res.size(); ++i) {
                    IRegTabla tab = this.getModelo().getGestorConfiguracion().getTabla(((String)res.get(i)).toString());
                    if (tab.getNivel() != nodo.getNivel() + 1) {
                        FuncionesUtiles.getFuncionesUtiles().muestraAviso(new ExceptionMotor("La tabla " + tab.getIdTabla() + " deberia tener nivel " + nodo.getNivel() + 1 + " Revise Tablas.xml"));
                    }
                    if (!this.getPunteroActual().equalsIgnoreCase("DEFAULT")) {
                        flagAddNodosHijos = false;
                        switch (this.getBusquedaNodosObj().get("DEFAULT").tablaAnteriorATabla(this.getVarNodoPrincipal().get("DEFAULT"), tab.getIdTabla(), this.getBusquedaNodosObj().get(this.getPunteroActual()).getNombreTablaPuntero())) {
                            case 0: {
                                cTaAux = null;
                                break;
                            }
                            case 1: {
                                cTaAux = this.getBusquedaNodosObj().get("DEFAULT").buscarNodo(tab.getIdTabla(), this.getVarNodoPrincipal().get("DEFAULT"));
                                break;
                            }
                            case 2: {
                                cTaAux = this.getBusquedaNodosObj().get("DEFAULT").buscarNodo(tab.getIdTabla(), this.getVarNodoPrincipal().get("DEFAULT")).clone();
                            }
                        }
                    } else {
                        flagAddNodosHijos = true;
                        if (this.getBusquedaNodosObj().get(this.getPunteroActual()).buscarNodo(tab.getIdTabla(), this.getVarNodoPrincipal().get(this.getPunteroActual())) != null) {
                            throw new ExceptionMotor("La tabla " + tab.getIdTabla() + " tiene m\u00e1s de una tabla padre. Revise Relacionadas.xml");
                        }
                        cTaAux = new TablaMotor(((String)res.get(i)).toString(), nodo, this);
                        cTaAux.setNivel(nodo.getNivel() + 1);
                        cTaAux.setClaveSuperior(nodo.getClaveActiva());
                        cTaAux.setClaveUnicaSuperior(nodo.getClaveUnica());
                    }
                    relacionadas.anniadirElemento((Object)i, cTaAux);
                    if (!flagAddNodosHijos) continue;
                    this.anniadirNodos(nodo.getTablaMotor(i));
                }
            }
            catch (Exception ex) {
                if (this.isModoSilencioso()) break block14;
                if (ex instanceof ExceptionMotor) {
                    ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + ((Object)nodo).toString());
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex, ((Object)nodo).toString());
            }
        }
    }

    protected boolean cargaArbol(String nombreTabla) throws ExceptionMotor {
        try {
            ITablaMotor tAux = this.obtenerNodoTabla(nombreTabla);
            if (tAux != null) {
                if (tAux.getNivel() == 0) {
                    tAux.setClaveActiva(1L);
                    tAux.setClaveUnica(this.getOrigenDeDatos().getIdTablaRaiz());
                    return true;
                }
                if (this.getOrigenDeDatos().recordCount(tAux) == 0L) {
                    tAux.setClaveActiva(0L);
                } else {
                    tAux.setClaveActiva(1L);
                }
            }
            return true;
        }
        catch (Exception ex) {
            if (!this.isModoSilencioso()) {
                if (ex instanceof ExceptionMotor) {
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex);
            }
            return false;
        }
    }

    @Override
    public ITablaMotor obtenerNodoTabla(String nombreTabla) throws ExceptionMotor {
        try {
            ITablaMotor nodo = null;
            nodo = this.getBusquedaNodosObj().get(this.getPunteroActual()).buscarNodo(nombreTabla, this.getVarNodoPrincipal().get(this.getPunteroActual()));
            if (nodo != null) {
                return nodo;
            }
            return null;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Map<String, IPartidaModificadaReglas> getMapaPartidasAfectadasEnUnaEjecucion() {
        if (this.getListaPartidasAfectadasEnUnaEjecucion() != null && this.getListaPartidasAfectadasEnUnaEjecucion().size() > 0) {
            return this.getListaPartidasAfectadasEnUnaEjecucion().get(this.getListaPartidasAfectadasEnUnaEjecucion().size() - 1).getLista();
        }
        return null;
    }

    @Override
    public Object obtenerDestino(String sDestino) throws ExceptionMotor {
        try {
            if (sDestino == null) {
                return "";
            }
            if (sDestino.equalsIgnoreCase("VALI") || sDestino.equalsIgnoreCase("NULO") || sDestino.equalsIgnoreCase("NLL")) {
                return "";
            }
            ITablaMotor tAux = this.obtenerNodoPartida(sDestino);
            String val = tAux.obtenerPartidaString(sDestino);
            if (val != null) {
                return val;
            }
            return this.getOperaciones().obtenerValorInicialPartida(sDestino);
        }
        catch (Exception e) {
            throw new ExceptionMotor(e, "Destino " + sDestino);
        }
    }

    @Override
    public ITablaMotor obtenerNodoPartida(String nombrePartida) throws ExceptionMotor {
        try {
            String nombreTabla = this.buscarPartidaEnTabla(nombrePartida);
            ITablaMotor tAux = this.getBusquedaNodosObj().get(this.getPunteroActual()).buscarNodo(nombreTabla, this.getVarNodoPrincipal().get(this.getPunteroActual()));
            if (tAux == null) {
                return null;
            }
            return tAux;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public String buscarPartidaEnTabla(String partida) {
        try {
            IRegEntrada ent = this.getModelo().getGestorConfiguracion().getEntrada(partida);
            if (ent != null) {
                return ent.getIdTabla();
            }
            return "";
        }
        catch (Exception ex) {
            return "";
        }
    }

    public void setListaRegistroDeTablasAfectadasEnUnaEjecucion(List<ITipoListaRegistroDeTablasAfectadasEnUnaEjecucion> listaRegistroDeTablasAfectadasEnUnaEjecucion) {
        this.listaRegistroDeTablasAfectadasEnUnaEjecucion = listaRegistroDeTablasAfectadasEnUnaEjecucion;
    }

    @Override
    public List<ITipoListaRegistroDeTablasAfectadasEnUnaEjecucion> getListaRegistroDeTablasAfectadasEnUnaEjecucion() {
        return this.listaRegistroDeTablasAfectadasEnUnaEjecucion;
    }

    @Override
    public void anniadirGrupoPartidasAfectadasEnUnaEjecucion() throws ExceptionMotor {
        try {
            if (!this.inTrans()) {
                return;
            }
            this.getListaPartidasAfectadasEnUnaEjecucion().add(new TipoListaPartidasAfectadasEnUnaEjecucion(new HashMap<String, IPartidaModificadaReglas>()));
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected void borraGrupoPartidasAfectadasEnUnaEjecucion() throws ExceptionMotor {
        try {
            if (this.getListaPartidasAfectadasEnUnaEjecucion() == null || this.getListaPartidasAfectadasEnUnaEjecucion().size() == 0) {
                FuncionesUtiles.getFuncionesUtiles().muestraAviso(new Exception("Posible error, se pide borrar el ultimo grupo y no hay ninguno"));
                return;
            }
            this.getListaPartidasAfectadasEnUnaEjecucion().remove(this.getListaPartidasAfectadasEnUnaEjecucion().size() - 1);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean beginTrans() throws ExceptionMotor {
        try {
            this.updateUltimaVezAccedido();
            boolean ret = this.getOrigenDeDatos().beginTrans();
            if (this.getOrigenDeDatos().getDifferedWrite() == 1) {
                if (this.nodosSalvados.size() == 0) {
                    this.nodosSalvados.add(this.cloneListaNodosPrincipales());
                }
                if (this.getListaPartidasAfectadasEnUnaEjecucion().size() == 0) {
                    this.anniadirGrupoPartidasAfectadasEnUnaEjecucion();
                }
                if (this.getListaRegistroDeTablasAfectadasEnUnaEjecucion().size() == 0) {
                    this.getListaRegistroDeTablasAfectadasEnUnaEjecucion().add(new TipoListaRegistroDeTablasAfectadasEnUnaEjecucion(new HashMap<String, List<IRegTablaModificada>>()));
                }
                return ret;
            }
            if (ret) {
                this.nodosSalvados.add(this.cloneListaNodosPrincipales());
                this.anniadirGrupoPartidasAfectadasEnUnaEjecucion();
                this.getListaRegistroDeTablasAfectadasEnUnaEjecucion().add(new TipoListaRegistroDeTablasAfectadasEnUnaEjecucion(new HashMap<String, List<IRegTablaModificada>>()));
            }
            return ret;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean rollBack() throws ExceptionMotor {
        try {
            if (this.getGestionReglas().isCancelaReglasEnCurso()) {
                this.getGestionReglas().resetCancelaReglasEnCurso();
            }
            this.updateUltimaVezAccedido();
            if (this.isEjecutandoBatchAnniadirRegistro()) {
                throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras existan comandos batch_A\u00f1adirRegistro(...) pendientes");
            }
            if (!this.inTrans()) {
                return true;
            }
            boolean ret = this.rollbackDataBase();
            if (this.getOrigenDeDatos().getDifferedWrite() == 1) {
                return ret;
            }
            this.notifica(true);
            if (ret) {
                Set<String> s = this.getBusquedaNodosObj().keySet();
                Iterator<String> it = s.iterator();
                while (it.hasNext()) {
                    this.getBusquedaNodosObj().get(it.next().toString()).clearCache();
                }
                s = null;
                this.overwriteListaNodosPrincipales(this.nodosSalvados.get(this.nodosSalvados.size() - 1), true);
                this.nodosSalvados.remove(this.nodosSalvados.size() - 1);
            }
            return ret;
        }
        catch (Exception ex) {
            if (!this.isModoSilencioso()) {
                if (ex instanceof ExceptionMotor) {
                    throw (ExceptionMotor)ex;
                }
                throw new ExceptionMotor(ex);
            }
            return false;
        }
    }

    @Override
    public boolean commitTrans() throws ExceptionMotor {
        try {
            if (this.getGestionReglas().isCancelaReglasEnCurso()) {
                return this.rollBack();
            }
            this.updateUltimaVezAccedido();
            if (this.isEjecutandoBatchAnniadirRegistro()) {
                throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras existan comandos batch_A\u00f1adirRegistro(...) pendientes");
            }
            if (!this.inTrans()) {
                return true;
            }
            boolean ret = this.getOrigenDeDatos().commitTrans();
            if (this.getOrigenDeDatos().getDifferedWrite() == 1) {
                return ret;
            }
            if (ret) {
                this.nodosSalvados.remove(this.nodosSalvados.size() - 1);
                this.notifica(false);
            } else {
                this.borraGrupoPartidasAfectadasEnUnaEjecucion();
            }
            return ret;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean rollbackDataBase() throws ExceptionMotor {
        try {
            this.updateUltimaVezAccedido();
            if (this.isEjecutandoBatchAnniadirRegistro()) {
                throw new ExceptionMotor("Imposible realizar esta operaci\u00f3n mientras existan comandos batch_A\u00f1adirRegistro(...) pendientes");
            }
            if (!this.inTrans()) {
                return true;
            }
            this.borraGrupoPartidasAfectadasEnUnaEjecucion();
            return this.getOrigenDeDatos().rollBack();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean inTrans() throws ExceptionMotor {
        return this.getOrigenDeDatos().inTrans();
    }

    @Override
    public Object cloneListaNodosPrincipales() throws ExceptionMotor {
        try {
            this.updateUltimaVezAccedido();
            ArrayList<Object> saved = new ArrayList<Object>();
            for (int i = 0; i < this.getNombrePunteros().size(); ++i) {
                saved.add(this.getNombrePunteros().get(i));
                saved.add(this.getVarNodoPrincipal().get(this.getNombrePunteros().get(i)).lightClone());
            }
            return saved;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean overwriteListaNodosPrincipales(Object newNodes, boolean esCompleto) throws ExceptionMotor {
        try {
            ArrayList saved = (ArrayList)newNodes;
            for (int i = 0; i < saved.size() - 1; i += 2) {
                this.getVarNodoPrincipal().get(saved.get(i).toString()).overwriteLightClone((ArrayList)saved.get(i + 1), esCompleto);
            }
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void notifica(boolean rev) throws ExceptionMotor {
        try {
            try {
                this.notificarTablasModificadas(this.getListaRegistroDeTablasAfectadasEnUnaEjecucion().get(this.getListaRegistroDeTablasAfectadasEnUnaEjecucion().size() - 1).getLista());
                this.getListaRegistroDeTablasAfectadasEnUnaEjecucion().remove(this.getListaRegistroDeTablasAfectadasEnUnaEjecucion().size() - 1);
            }
            catch (ArrayIndexOutOfBoundsException aioe) {
            }
            catch (IndexOutOfBoundsException Ioe) {
                // empty catch block
            }
            try {
                this.listaPartidasAfectadasEnUnaEjecucionParaUsuario = this.getListaPartidasAfectadasEnUnaEjecucion().get(this.getListaPartidasAfectadasEnUnaEjecucion().size() - 1);
                this.notificarPartidasModificadas(this.getListaPartidasAfectadasEnUnaEjecucion().get(this.getListaPartidasAfectadasEnUnaEjecucion().size() - 1).getLista(), rev);
                this.borraGrupoPartidasAfectadasEnUnaEjecucion();
            }
            catch (ArrayIndexOutOfBoundsException aioe) {
            }
            catch (IndexOutOfBoundsException Ioe) {}
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public ITipoListaPartidasAfectadasEnUnaEjecucion getListaPartidasAfectadasPorPartidaModificada() throws ExceptionMotor {
        return this.listaPartidasAfectadasEnUnaEjecucionParaUsuario;
    }

    @Override
    public boolean notificarPartidasModificadas(Map<String, IPartidaModificadaReglas> listaPartidas, boolean rev) throws ExceptionMotor {
        try {
            boolean ret = true;
            if (!this.isPartidayTablasListenersEnabled()) {
                return true;
            }
            if (listaPartidas == null || listaPartidas.size() == 0) {
                return true;
            }
            if (this.getListenersPartidaModificada() == null || this.getListenersPartidaModificada().size() == 0) {
                return true;
            }
            String nombrePartidaUnicoConIds2 = "";
            String nombrePartida = "";
            List<IPartidaModificada> escuchadores = null;
            int estado = 0;
            String val = "";
            for (String nombrePartidaUnicoConIds2 : listaPartidas.keySet()) {
                nombrePartida = this.dameNombrePartidaSinIDs(nombrePartidaUnicoConIds2.toUpperCase());
                if (listaPartidas.get(nombrePartidaUnicoConIds2).getValorPosterior().toString().equalsIgnoreCase(listaPartidas.get(nombrePartidaUnicoConIds2).getValorAnterior().toString()) && Integer.valueOf(listaPartidas.get(nombrePartidaUnicoConIds2).getEstadoPosterior()).intValue() == Integer.valueOf(listaPartidas.get(nombrePartidaUnicoConIds2).getEstadoAnterior()).intValue() || !this.getListenersPartidaModificada().containsKey(nombrePartida)) continue;
                escuchadores = this.getListenersPartidaModificada().get(nombrePartida);
                estado = rev ? Integer.valueOf(listaPartidas.get(nombrePartidaUnicoConIds2).getEstadoAnterior()).intValue() : Integer.valueOf(listaPartidas.get(nombrePartidaUnicoConIds2).getEstadoPosterior()).intValue();
                for (int i = 0; i < escuchadores.size(); ++i) {
                    try {
                        val = rev ? listaPartidas.get(nombrePartidaUnicoConIds2).getValorAnterior().toString() : listaPartidas.get(nombrePartidaUnicoConIds2).getValorPosterior().toString();
                        escuchadores.get(i).refrescaPartida(nombrePartida, listaPartidas.get(nombrePartidaUnicoConIds2).getIdinf(), listaPartidas.get(nombrePartidaUnicoConIds2).getId(), val, estado);
                        continue;
                    }
                    catch (Exception ex) {
                        ret = false;
                        FuncionesUtiles.getFuncionesUtiles().muestraError(new ExceptionMotor(ex, "Error escuchador para partida " + nombrePartida + " : " + ex.getMessage()));
                    }
                }
            }
            return ret;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    private String dameNombrePartidaSinIDs(String nombrePartidaUnicoConIds) {
        try {
            int i = nombrePartidaUnicoConIds.lastIndexOf(40);
            if (i > -1) {
                return nombrePartidaUnicoConIds.substring(0, i);
            }
            return nombrePartidaUnicoConIds;
        }
        catch (Exception ex) {
            FuncionesUtiles.getFuncionesUtiles().muestraError(ex);
            return nombrePartidaUnicoConIds;
        }
    }

    @Override
    public boolean notificarTablasModificadas(Map<String, List<IRegTablaModificada>> listaTablas) throws ExceptionMotor {
        try {
            if (!this.isPartidayTablasListenersEnabled()) {
                return true;
            }
            if (listaTablas == null || listaTablas.size() == 0) {
                return true;
            }
            if (this.getListenersTablaModificada() == null || this.getListenersTablaModificada().size() == 0) {
                return true;
            }
            List<IPartidaModificada> escuchadores = null;
            for (String tabla : listaTablas.keySet()) {
                List<IRegTablaModificada> evento = listaTablas.get(tabla);
                if (!this.getListenersTablaModificada().containsKey(tabla)) continue;
                escuchadores = this.getListenersTablaModificada().get(tabla);
                for (int i = 0; i < escuchadores.size(); ++i) {
                    for (int j = 0; j < evento.size(); ++j) {
                        if (evento.get(j).getAccion().equalsIgnoreCase("add")) {
                            escuchadores.get(i).registroAniadido(tabla, evento.get(j).getIdInf(), evento.get(j).getId());
                        }
                        if (!evento.get(j).getAccion().equalsIgnoreCase("del")) continue;
                        escuchadores.get(i).registroEliminado(tabla, evento.get(j).getIdInf(), evento.get(j).getId());
                    }
                }
            }
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void addPartidaQueHizoSaltarRegla(int regla, String partida) {
        this.getPartidaQueInvocaRegla().put(regla, partida);
    }

    @Override
    public void createPtr(String nombre, String tabla) throws ExceptionMotor {
        try {
            this.updateUltimaVezAccedido();
            boolean ret = true;
            if (this.getModelo().getGestorConfiguracion().getTabla(tabla) == null) {
                throw new ExceptionMotor("Puntero apuntando a tabla inexistente (" + tabla + ")");
            }
            if (!this.getPunteroActual().equalsIgnoreCase("DEFAULT")) {
                throw new ExceptionMotor("No esta colocado en el puntero por defecto, fallar\u00e1 la creaci\u00f3n del nuevo puntero porque se hace a partir de \u00e9l.");
            }
            String ant = this.getPunteroActual();
            this.setPunteroActual(nombre.toUpperCase());
            boolean addNombre = true;
            for (String ptr : this.getNombrePunteros()) {
                if (!ptr.equalsIgnoreCase(this.getPunteroActual())) continue;
                addNombre = false;
                break;
            }
            if (addNombre) {
                this.getNombrePunteros().add(this.getPunteroActual());
                this.getNombreTablaPunteros().add(tabla);
            }
            if (!(ret = this.construirArbol(true, tabla))) {
                this.setPunteroActual(ant);
            }
            if (!ret) {
                throw new ExceptionMotor("No pudo crearse Puntero " + nombre + " sobre tabla " + tabla);
            }
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void removePtr(String nombre) throws ExceptionMotor {
        try {
            this.updateUltimaVezAccedido();
            if (nombre.equalsIgnoreCase("DEFAULT")) {
                throw new Exception("No se permite eliminar al puntero por defecto...");
            }
            if (this.getVarNodoPrincipal().containsKey(nombre.toUpperCase())) {
                for (int i = 0; i < this.getNombrePunteros().size(); ++i) {
                    if (!this.getNombrePunteros().get(i).equalsIgnoreCase(nombre)) continue;
                    this.getNombrePunteros().remove(i);
                    this.getNombreTablaPunteros().remove(i);
                    break;
                }
            } else {
                throw new Exception("Puntero " + nombre + " no encontrado...");
            }
            this.getVarNodoPrincipal().remove(nombre.toUpperCase());
            this.getBusquedaNodosObj().remove(nombre.toUpperCase());
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void setCurrentPtr(String nombre) throws ExceptionMotor {
        try {
            if (!this.getVarNodoPrincipal().containsKey(nombre.toUpperCase())) {
                throw new Exception("Puntero " + nombre + " no encontrado...");
            }
            this.setPunteroActual(nombre.toUpperCase());
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean existsPtr(String nombre) throws ExceptionMotor {
        try {
            if (this.getNombrePunteros() != null) {
                return this.getNombrePunteros().contains(nombre.toUpperCase());
            }
            return false;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public String getCurrentPtr() throws ExceptionMotor {
        return this.getPunteroActual();
    }

    @Override
    public List<ITipoDatosCampoValor> getPtrList() throws ExceptionMotor {
        try {
            ArrayList<ITipoDatosCampoValor> ret = new ArrayList<ITipoDatosCampoValor>();
            for (int i = 0; i < this.getNombrePunteros().size(); ++i) {
                TipoDatosCampoValor p = new TipoDatosCampoValor(this.getNombrePunteros().get(i), this.getNombreTablaPunteros().get(i));
                try {
                    long cl = this.getBusquedaNodosObj().get(this.getNombrePunteros().get(i)).buscarNodo(this.getNombreTablaPunteros().get(i), this.getVarNodoPrincipal().get(this.getNombrePunteros().get(i))).getClaveActiva();
                    p.setExtra(String.valueOf(cl));
                }
                catch (Exception ex) {
                    p.setExtra("??");
                }
                ret.add(p);
            }
            return ret;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Integer getMaximoDeErroresPersonalizado() {
        return this.maximoDeErroresPersonalizado;
    }

    @Override
    public void setMaximoDeErroresPersonalizado(Integer maximoDeErroresPersonalizado) {
        this.maximoDeErroresPersonalizado = maximoDeErroresPersonalizado;
    }

    @Override
    public void setFuncionesErrorComportamientoEspecial(boolean funcionesErrorComportamientoEspecial) throws ExceptionMotor {
        this.funcionesErrorComportamientoEspecial = funcionesErrorComportamientoEspecial;
    }

    @Override
    public boolean isFuncionesErrorComportamientoEspecial() throws ExceptionMotor {
        return this.funcionesErrorComportamientoEspecial;
    }

    @Override
    public void setControlOverflow(boolean overflowControladoPorMotor) throws ExceptionMotor {
        this.getOrigenDeDatos().setControlOverflow(overflowControladoPorMotor);
    }

    @Override
    public boolean isControlOverflow() throws ExceptionMotor {
        return this.getOrigenDeDatos().isControlOverflow();
    }

    @Override
    public void cancelaReglasEnCurso() throws ExceptionMotor {
        this.getGestionReglas().cancelaReglasEnCurso();
    }

    @Override
    public void setComprobarCaracteresEnPartidaModificada(boolean comprobar) throws ExceptionMotor {
        this.comprobarCaracteresEnPartidaModificada = comprobar;
    }

    @Override
    public boolean isComprobarCaracteresEnPartidaModificada() {
        return this.comprobarCaracteresEnPartidaModificada;
    }

    @Override
    public int getPosicionSello() {
        return this.posicionSello;
    }

    @Override
    public boolean setPosicionSello(int posSello) {
        this.posicionSello = posSello;
        return true;
    }

    @Override
    public String getEntradaTransOpciones() {
        return this.entradaTransOpciones;
    }

    @Override
    public void setEntradaTransOpciones(String entradaTransOpciones) {
        this.entradaTransOpciones = entradaTransOpciones;
    }

    @Override
    public IGestorConfiguracionLooper getGestorConfiguracionLooper() throws ExceptionMotor {
        this.updateUltimaVezAccedido();
        if (this.gestorConfiguracionLooper == null) {
            this.gestorConfiguracionLooper = (IGestorConfiguracionLooper)FuncionesUtiles.getFuncionesUtiles().getInstancia(GestorConfiguracionLooper.class, new Object[]{this.getModelo().getGestorConfiguracion()});
        }
        return this.gestorConfiguracionLooper;
    }

    @Override
    public void setInfoSwap(String infoSwap) {
        this.infoSwap = infoSwap;
    }

    @Override
    public String getInfoSwap() {
        return this.infoSwap;
    }

    @Override
    public IOrigenDatos getOrigenDeDatos() throws ExceptionMotor {
        try {
            this.updateUltimaVezAccedido();
            if (this.origenDeDatos == null) {
                String clase = FuncionesUtiles.getFuncionesUtiles().damePrimeraOpcion(this.getModelo().getGestorDatosOpciones().getOpcion("ClaseOrigenDatos"));
                if (clase == null) {
                    clase = "es.aeat.pftw.mtrc.origenDatos.mem.OrigenDatosMem";
                }
                this.origenDeDatos = (IOrigenDatos)FuncionesUtiles.getFuncionesUtiles().getInstancia(clase, new Object[]{this}, this.getCloader());
            }
            return this.origenDeDatos;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Object getClaseExportacionBOE() throws ExceptionMotor {
        try {
            if (this.claseExportacionBOE == null) {
                String clase = FuncionesUtiles.getFuncionesUtiles().damePrimeraOpcion(this.getModelo().getGestorDatosOpciones().getOpcion("ClaseExportacionBOE"));
                if (clase == null) {
                    clase = this.getVersionTransBOE() == 2.0 ? "es.aeat.pftw.mtrc.gestionFicheros.exportacionV2.boeV2.ExportacionBOE" : "es.aeat.pftw.mtrc.gestionFicheros.exportacion.boe.ExportacionBOE";
                }
                this.claseExportacionBOE = FuncionesUtiles.getFuncionesUtiles().getInstancia(clase, new Object[]{this, false}, this.getCloader());
                if (this.getVersionTransBOE() == 2.0) {
                    if (!Class.forName("es.aeat.pftw.mtrc.gestionFicheros.exportacionV2.boeV2.ExportacionBOE").isInstance(this.claseExportacionBOE)) {
                        throw new ExceptionMotor("La clase exportacion boe debe heredar de es.aeat.pftw.mtrc.gestionFicheros.exportacionV2.boeV2.ExportacionBOE");
                    }
                } else if (!Class.forName("es.aeat.pftw.mtrc.gestionFicheros.exportacion.boe.ExportacionBOE").isInstance(this.claseExportacionBOE)) {
                    throw new ExceptionMotor("La clase exportacion boe debe heredar de es.aeat.pftw.mtrc.gestionFicheros.exportacion.boe.ExportacionBOE");
                }
                if (this.getMaximoDeErroresPersonalizado() != null && this.getModelo() != null && this.getGestorFicheros(this.getEntradaTransOpciones()) != null) {
                    this.getGestorFicheros(this.getEntradaTransOpciones()).setMaxErrores(this.getMaximoDeErroresPersonalizado());
                }
            }
            return this.claseExportacionBOE;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean isCreadaClaseExportacionBOE() {
        return this.claseExportacionBOE != null;
    }

    @Override
    public Object getClaseExportacionXML() throws ExceptionMotor {
        try {
            if (this.claseExportacionXML == null) {
                String clase = FuncionesUtiles.getFuncionesUtiles().damePrimeraOpcion(this.getModelo().getGestorDatosOpciones().getOpcion("ClaseExportacionXML"));
                if (clase == null) {
                    clase = "es.aeat.pftw.mtrc.gestionFicheros.exportacionV2.xml.ExportacionXML";
                }
                this.claseExportacionXML = FuncionesUtiles.getFuncionesUtiles().getInstancia(clase, new Object[]{this, false}, this.getCloader());
                if (!Class.forName("es.aeat.pftw.mtrc.gestionFicheros.exportacionV2.xml.ExportacionXML").isInstance(this.claseExportacionXML)) {
                    throw new ExceptionMotor("La clase exportacion xml debe heredar de es.aeat.pftw.mtrc.gestionFicheros.exportacionV2.xml.ExportacionXML");
                }
                if (this.getMaximoDeErroresPersonalizado() != null && this.getModelo() != null && this.getGestorFicheros(this.getEntradaTransOpciones()) != null) {
                    this.getGestorFicheros(this.getEntradaTransOpciones()).setMaxErrores(this.getMaximoDeErroresPersonalizado());
                }
            }
            return this.claseExportacionXML;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean isCreadaClaseExportacionXML() {
        return this.claseExportacionXML != null;
    }

    @Override
    public boolean isCreadaClaseReglasValidacion() {
        return this.claseReglasValidacion != null;
    }

    @Override
    public boolean isCreadaClaseReglasValidacionXML() {
        return this.claseReglasValidacionXML != null;
    }

    @Override
    public boolean isCreadaClaseValidacionCaracteres() {
        return this.claseValidacionCaracteres != null;
    }

    @Override
    public boolean isCreadaClaseValidacionEstructura() {
        return this.claseValidacionEstructura != null;
    }

    @Override
    public boolean isCreadaClaseValidacionPrevia() {
        return this.claseValidacionPrevia != null;
    }

    @Override
    public boolean isCreadaClaseValidacionSecuencia() {
        return this.claseValidacionSecuencia != null;
    }

    @Override
    public Object getClaseValidacionEstructura() throws ExceptionMotor {
        try {
            if (this.claseValidacionEstructura == null) {
                String clase = FuncionesUtiles.getFuncionesUtiles().damePrimeraOpcion(this.getModelo().getGestorDatosOpciones().getOpcion("ClaseValidacionEstructura"));
                if (clase == null) {
                    clase = this.getVersionTransBOE() == 2.0 ? "es.aeat.pftw.mtrc.gestionFicheros.importacionV2.boeV2.ValidacionEstructura" : "es.aeat.pftw.mtrc.gestionFicheros.importacion.boe.ValidacionEstructura";
                }
                Object[] param = new Object[]{this};
                this.claseValidacionEstructura = FuncionesUtiles.getFuncionesUtiles().getInstancia(clase, param, this.getCloader());
                if (this.getVersionTransBOE() == 2.0) {
                    if (!Class.forName("es.aeat.pftw.mtrc.gestionFicheros.importacionV2.boeV2.ValidacionEstructura").isInstance(this.claseValidacionEstructura)) {
                        throw new ExceptionMotor("La clase validacion estructura debe heredar de es.aeat.pftw.mtrc.gestionFicheros.importacionV2.boeV2.ValidacionEstructura");
                    }
                } else if (!Class.forName("es.aeat.pftw.mtrc.gestionFicheros.importacion.boe.ValidacionEstructura").isInstance(this.claseValidacionEstructura)) {
                    throw new ExceptionMotor("La clase validacion estructura debe heredar de es.aeat.pftw.mtrc.gestionFicheros.importacion.boe.ValidacionEstructura");
                }
                if (this.getMaximoDeErroresPersonalizado() != null && this.getModelo() != null && this.getGestorFicheros(this.getEntradaTransOpciones()) != null) {
                    this.getGestorFicheros(this.getEntradaTransOpciones()).setMaxErrores(this.getMaximoDeErroresPersonalizado());
                }
            }
            return this.claseValidacionEstructura;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Object getClaseValidacionSecuencia() throws ExceptionMotor {
        try {
            if (this.claseValidacionSecuencia == null) {
                String clase = FuncionesUtiles.getFuncionesUtiles().damePrimeraOpcion(this.getModelo().getGestorDatosOpciones().getOpcion("ClaseValidacionSecuencias"));
                if (clase == null) {
                    clase = this.getVersionTransBOE() == 2.0 ? "es.aeat.pftw.mtrc.gestionFicheros.importacionV2.boeV2.ValidacionSecuencias" : "es.aeat.pftw.mtrc.gestionFicheros.importacion.boe.ValidacionSecuencias";
                }
                Object[] param = new Object[]{this};
                this.claseValidacionSecuencia = FuncionesUtiles.getFuncionesUtiles().getInstancia(clase, param, this.getCloader());
                if (this.getVersionTransBOE() == 2.0) {
                    if (!Class.forName("es.aeat.pftw.mtrc.gestionFicheros.importacionV2.boeV2.ValidacionSecuencias").isInstance(this.claseValidacionSecuencia)) {
                        throw new ExceptionMotor("La clase validacion secuencia debe heredar de es.aeat.pftw.mtrc.gestionFicheros.importacionV2.boeV2.ValidacionSecuencias");
                    }
                } else if (!Class.forName("es.aeat.pftw.mtrc.gestionFicheros.importacion.boe.ValidacionSecuencias").isInstance(this.claseValidacionSecuencia)) {
                    throw new ExceptionMotor("La clase validacion secuencia debe heredar de es.aeat.pftw.mtrc.gestionFicheros.importacion.boe.ValidacionSecuencias");
                }
                if (this.getMaximoDeErroresPersonalizado() != null && this.getModelo() != null && this.getGestorFicheros(this.getEntradaTransOpciones()) != null) {
                    this.getGestorFicheros(this.getEntradaTransOpciones()).setMaxErrores(this.getMaximoDeErroresPersonalizado());
                }
            }
            return this.claseValidacionSecuencia;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public double getVersionTransBOE() throws Exception {
        try {
            return Double.parseDouble(this.getModelo().getGestorTraduccionesBOE(this).getVersionTrans());
        }
        catch (Exception ex) {
            if (ex.getMessage().equalsIgnoreCase("Desconozco el fichero a tratar")) {
                throw ex;
            }
            return 1.0;
        }
    }

    @Override
    public Object getClaseValidacionPrevia() throws ExceptionMotor {
        try {
            if (this.claseValidacionPrevia == null) {
                String clase = FuncionesUtiles.getFuncionesUtiles().damePrimeraOpcion(this.getModelo().getGestorDatosOpciones().getOpcion("ClaseValidacionPrevia"));
                if (clase == null) {
                    clase = this.getVersionTransBOE() == 2.0 ? "es.aeat.pftw.mtrc.gestionFicheros.importacionV2.boeV2.ValidacionPrevia" : "es.aeat.pftw.mtrc.gestionFicheros.importacion.boe.ValidacionPrevia";
                }
                Object[] param = new Object[]{this};
                this.claseValidacionPrevia = FuncionesUtiles.getFuncionesUtiles().getInstancia(clase, param, this.getCloader());
                if (this.getVersionTransBOE() == 2.0) {
                    if (!Class.forName("es.aeat.pftw.mtrc.gestionFicheros.importacionV2.boeV2.ValidacionPrevia").isInstance(this.claseValidacionPrevia)) {
                        throw new ExceptionMotor("La clase validacion previa debe heredar de es.aeat.pftw.mtrc.gestionFicheros.importacionV2.boeV2.ValidacionPrevia");
                    }
                } else if (!Class.forName("es.aeat.pftw.mtrc.gestionFicheros.importacion.boe.ValidacionPrevia").isInstance(this.claseValidacionPrevia)) {
                    throw new ExceptionMotor("La clase validacion previa debe heredar de es.aeat.pftw.mtrc.gestionFicheros.importacion.boe.ValidacionPrevia");
                }
                if (this.getMaximoDeErroresPersonalizado() != null && this.getModelo() != null && this.getGestorFicheros(this.getEntradaTransOpciones()) != null) {
                    this.getGestorFicheros(this.getEntradaTransOpciones()).setMaxErrores(this.getMaximoDeErroresPersonalizado());
                }
            }
            return this.claseValidacionPrevia;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Object getClaseValidacionCaracteres() throws ExceptionMotor {
        try {
            if (this.claseValidacionCaracteres == null) {
                String clase = FuncionesUtiles.getFuncionesUtiles().damePrimeraOpcion(this.getModelo().getGestorDatosOpciones().getOpcion("ClaseValidacionCaracteres"));
                if (clase == null) {
                    clase = this.getVersionTransBOE() == 2.0 ? "es.aeat.pftw.mtrc.gestionFicheros.importacionV2.boeV2.ValidacionCaracteres" : "es.aeat.pftw.mtrc.gestionFicheros.importacion.boe.ValidacionCaracteres";
                }
                Object[] param = new Object[]{this};
                this.claseValidacionCaracteres = FuncionesUtiles.getFuncionesUtiles().getInstancia(clase, param, this.getCloader());
                if (this.getVersionTransBOE() == 2.0) {
                    if (!Class.forName("es.aeat.pftw.mtrc.gestionFicheros.importacionV2.boeV2.ValidacionCaracteres").isInstance(this.claseValidacionCaracteres)) {
                        throw new ExceptionMotor("La clase validacion caracteres debe heredar de es.aeat.pftw.mtrc.gestionFicheros.importacionV2.boeV2.ValidacionCaracteres");
                    }
                } else if (!Class.forName("es.aeat.pftw.mtrc.gestionFicheros.importacion.boe.ValidacionCaracteres").isInstance(this.claseValidacionCaracteres)) {
                    throw new ExceptionMotor("La clase validacion caracteres debe heredar de es.aeat.pftw.mtrc.gestionFicheros.importacion.boe.ValidacionCaracteres");
                }
                if (this.getMaximoDeErroresPersonalizado() != null && this.getModelo() != null && this.getGestorFicheros(this.getEntradaTransOpciones()) != null) {
                    this.getGestorFicheros(this.getEntradaTransOpciones()).setMaxErrores(this.getMaximoDeErroresPersonalizado());
                }
            }
            return this.claseValidacionCaracteres;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Object getClaseReglasValidacion() throws ExceptionMotor {
        try {
            if (this.claseReglasValidacion == null) {
                String clase = FuncionesUtiles.getFuncionesUtiles().damePrimeraOpcion(this.getModelo().getGestorDatosOpciones().getOpcion("ClaseReglasValidacion"));
                if (clase == null) {
                    clase = this.getVersionTransBOE() == 2.0 ? "es.aeat.pftw.mtrc.gestionFicheros.importacionV2.boeV2.ReglasValidacion" : "es.aeat.pftw.mtrc.gestionFicheros.importacion.boe.ReglasValidacionBitacora";
                }
                this.claseReglasValidacion = FuncionesUtiles.getFuncionesUtiles().getInstancia(clase, new Object[]{this}, this.getCloader());
                if (this.getVersionTransBOE() == 2.0) {
                    if (!Class.forName("es.aeat.pftw.mtrc.gestionFicheros.importacionV2.boeV2.ReglasValidacion").isInstance(this.claseReglasValidacion)) {
                        throw new ExceptionMotor("La clase reglas de validacion debe heredar de es.aeat.pftw.mtrc.gestionFicheros.importacionV2.boeV2.ReglasValidacion");
                    }
                } else if (!Class.forName("es.aeat.pftw.mtrc.gestionFicheros.importacion.boe.ReglasValidacionBitacora").isInstance(this.claseReglasValidacion)) {
                    throw new ExceptionMotor("La clase reglas de validacion debe heredar de es.aeat.pftw.mtrc.gestionFicheros.importacion.boe.ReglasValidacionBitacora");
                }
                if (this.getMaximoDeErroresPersonalizado() != null && this.getModelo() != null && this.getGestorFicheros(this.getEntradaTransOpciones()) != null) {
                    this.getGestorFicheros(this.getEntradaTransOpciones()).setMaxErrores(this.getMaximoDeErroresPersonalizado());
                }
            }
            return this.claseReglasValidacion;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Object getClaseReglasValidacionXML() throws ExceptionMotor {
        try {
            if (this.claseReglasValidacionXML == null) {
                String clase = FuncionesUtiles.getFuncionesUtiles().damePrimeraOpcion(this.getModelo().getGestorDatosOpciones().getOpcion("ClaseReglasValidacionXML"));
                if (clase == null) {
                    clase = "es.aeat.pftw.mtrc.gestionFicheros.importacionV2.xml.ReglasValidacion";
                }
                this.claseReglasValidacionXML = FuncionesUtiles.getFuncionesUtiles().getInstancia(clase, new Object[]{this}, this.getCloader());
                if (!Class.forName("es.aeat.pftw.mtrc.gestionFicheros.importacionV2.xml.ReglasValidacion").isInstance(this.claseReglasValidacionXML)) {
                    throw new ExceptionMotor("La clase reglas de validacion XML debe heredar de es.aeat.pftw.mtrc.gestionFicheros.importacionV2.xml.ReglasValidacion");
                }
                if (this.getMaximoDeErroresPersonalizado() != null && this.getModelo() != null && this.getGestorFicheros(this.getEntradaTransOpciones()) != null) {
                    this.getGestorFicheros(this.getEntradaTransOpciones()).setMaxErrores(this.getMaximoDeErroresPersonalizado());
                }
            }
            return this.claseReglasValidacionXML;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void eliminaTemporalesImportacionExportacion() throws ExceptionMotor {
        try {
            if (this.claseReglasValidacionXML != null) {
                ((IAop)this.claseReglasValidacionXML).dispose();
                this.claseReglasValidacionXML = null;
            }
            if (this.claseReglasValidacion != null) {
                ((IAop)this.claseReglasValidacion).dispose();
                this.claseReglasValidacion = null;
            }
            if (this.claseValidacionPrevia != null) {
                ((IAop)this.claseValidacionPrevia).dispose();
                this.claseValidacionPrevia = null;
            }
            if (this.claseValidacionEstructura != null) {
                ((IAop)this.claseValidacionEstructura).dispose();
                this.claseValidacionEstructura = null;
            }
            if (this.claseValidacionCaracteres != null) {
                ((IAop)this.claseValidacionCaracteres).dispose();
                this.claseValidacionCaracteres = null;
            }
            if (this.claseValidacionSecuencia != null) {
                ((IAop)this.claseValidacionSecuencia).dispose();
                this.claseValidacionSecuencia = null;
            }
            if (this.claseExportacionBOE != null) {
                ((IAop)this.claseExportacionBOE).dispose();
                this.claseExportacionBOE = null;
            }
            if (this.claseExportacionXML != null) {
                ((IAop)this.claseExportacionXML).dispose();
                this.claseExportacionXML = null;
            }
            if (this.gestor != null) {
                this.gestor.dispose();
                this.gestor = null;
            }
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public void setClaseExportacionBOE(Object exportacionBOE) {
        this.claseExportacionBOE = exportacionBOE;
    }

    @Override
    public void setClaseReglasValidacion(Object claseReglasValidacion) {
        this.claseReglasValidacion = claseReglasValidacion;
    }

    @Override
    public void setClaseReglasValidacionXML(Object claseReglasValidacionXML) {
        this.claseReglasValidacionXML = claseReglasValidacionXML;
    }

    public void setPartidaQueInvocaRegla(Map<Integer, String> partidaQueInvocaRegla) {
        this.partidaQueInvocaRegla = partidaQueInvocaRegla;
    }

    public Map<Integer, String> getPartidaQueInvocaRegla() {
        return this.partidaQueInvocaRegla;
    }

    protected FreezerMotor getFreezer() throws ExceptionMotor {
        try {
            if (this.fm == null) {
                this.fm = new FreezerMotor(this);
            }
            if (this.fm == null) {
                throw new ExceptionMotor("Imposible crear clase Freezer...");
            }
            return this.fm;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void freezeSesionSoloPosicion() throws ExceptionMotor {
        this.getFreezer().freeze();
    }

    @Override
    public void freezeSesionCompleta() throws ExceptionMotor {
        this.getFreezer().freezeCompleto();
    }

    @Override
    public void unfreeze() throws ExceptionMotor {
        this.getFreezer().unfreeze();
    }

    @Override
    public void cancelfreeze() throws ExceptionMotor {
        this.getFreezer().cancelfreeze();
    }

    @Override
    public boolean isFreezed() throws ExceptionMotor {
        return this.getFreezer().isFreezed();
    }

    protected FreezerMotor getFreezerNoSingleton(String idFreezer) throws ExceptionMotor {
        try {
            if (this.fmNoSingleton == null) {
                this.fmNoSingleton = new HashMap<String, FreezerMotor>();
            }
            if (this.fmNoSingleton.get(idFreezer) == null) {
                this.fmNoSingleton.put(idFreezer, new FreezerMotor(this));
            }
            if (this.fmNoSingleton.get(idFreezer) == null) {
                throw new ExceptionMotor("Imposible crear clase Freezer...");
            }
            return this.fmNoSingleton.get(idFreezer);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected boolean existeFreezer(String idFreezer) throws ExceptionMotor {
        try {
            if (this.fmNoSingleton == null) {
                this.fmNoSingleton = new HashMap<String, FreezerMotor>();
            }
            return this.fmNoSingleton.get(idFreezer) != null;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void freezeSesionSoloPosicion(String idFreezer) throws ExceptionMotor {
        this.getFreezerNoSingleton(idFreezer).freeze();
    }

    @Override
    public void freezeSesionCompleta(String idFreezer) throws ExceptionMotor {
        this.getFreezerNoSingleton(idFreezer).freezeCompleto();
    }

    @Override
    public void unfreeze(String idFreezer) throws ExceptionMotor {
        this.getFreezerNoSingleton(idFreezer).unfreeze();
        this.liberaFreezerNoSingleton(idFreezer);
    }

    @Override
    public void cancelfreeze(String idFreezer) throws ExceptionMotor {
        if (!this.existeFreezer(idFreezer)) {
            return;
        }
        this.getFreezerNoSingleton(idFreezer).cancelfreeze();
        this.liberaFreezerNoSingleton(idFreezer);
    }

    @Override
    public boolean isFreezed(String idFreezer) throws ExceptionMotor {
        if (!this.existeFreezer(idFreezer)) {
            return false;
        }
        return this.getFreezerNoSingleton(idFreezer).isFreezed();
    }

    protected void liberaFreezerNoSingleton(String idFreezer) throws ExceptionMotor {
        try {
            if (!this.existeFreezer(idFreezer)) {
                return;
            }
            this.getFreezerNoSingleton(idFreezer).dispose();
            this.fmNoSingleton.remove(idFreezer);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Map<String, String> getRegistrosA\u00f1adidosPorReglasAlImportar() {
        return this.registrosA\u00f1adidosPorReglasAlImportar;
    }

    @Override
    public void setRegistrosA\u00f1adidosPorReglasAlImportar(Map<String, String> m) {
        this.registrosA\u00f1adidosPorReglasAlImportar = m;
    }

    @Override
    public void setInstanciaInteraccionConUsuario(IInteraccionConUsuario instanciaInteraccionConUsuario) {
        this.instanciaInteraccionConUsuario = instanciaInteraccionConUsuario;
    }

    @Override
    public IInteraccionConUsuario getInstanciaInteraccionConUsuario() {
        return this.instanciaInteraccionConUsuario;
    }

    @Override
    public boolean isUsarContadorRegistros() {
        return this.usarContadorRegistros;
    }

    @Override
    public void setUsarContadorRegistros(boolean usarContadorRegistros) {
        this.usarContadorRegistros = usarContadorRegistros;
    }

    @Override
    public IGestorFicheros getGestorFicheros(String entradaTrans) throws ExceptionMotor {
        try {
            if (this.gestor == null) {
                if (this.getModelo().getFicherosTrans(entradaTrans) == null) {
                    throw new Exception("No se dispone de los ficheros trans!!!");
                }
                if (entradaTrans == null || entradaTrans.trim().length() == 0) {
                    throw new Exception("No ha indicado que entrada leer del fichero de trans!!!");
                }
                this.gestor = (IGestorFicheros)FuncionesUtiles.getFuncionesUtiles().getInstancia(GestorFicheros.class, new Object[]{this.getModelo().getClaseTransformaciones()});
                if (this.gestor == null) {
                    throw new ExceptionMotor("No se pudo crear instancia de IGestorFicheros");
                }
                for (String trans : this.getModelo().getFicherosTrans(entradaTrans)) {
                    this.gestor.addnombreFicheroTraducciones(trans);
                }
                List<String> opciones = this.getModelo().getGestorDatosOpciones().getOpcion("MAXERRORES");
                if (opciones != null && opciones.size() > 0) {
                    this.gestor.setMaxErrores(Integer.valueOf(opciones.get(0).toString()));
                }
                if ((opciones = this.getModelo().getGestorDatosOpciones().getOpcion("MAX_FICHERO_KB")) != null && opciones.size() > 0) {
                    long max = -1L;
                    String maxStr = opciones.get(0).toString();
                    if (maxStr.endsWith("bytes")) {
                        maxStr = maxStr.substring(0, maxStr.indexOf("bytes")).trim();
                        max = Long.valueOf(maxStr);
                    } else {
                        max = Long.valueOf(maxStr) * 1000L;
                    }
                    this.gestor.setMaxFicheros(max);
                }
            }
            if (this.gestor == null) {
                throw new Exception("Imposible crear GestorFichero");
            }
            return this.gestor;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }
}

