/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.motor;

import es.aeat.pftw.mtrc.gestionFicheros.importacion.ITransformaciones;
import es.aeat.pftw.mtrc.gestionFicheros.importacion.Transformaciones;
import es.aeat.pftw.mtrc.motor.IMotor;
import es.aeat.pftw.mtrc.motor.modelo.IModelo;
import es.aeat.pftw.mtrc.motor.modelo.Modelo;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesionExtendida;
import es.aeat.pftw.mtrc.motor.modelo.sesion.Sesion;
import es.aeat.pftw.mtrc.motor.modelo.sesion.SesionCloned;
import es.aeat.pftw.mtrc.procesadorReglas.Comprobaciones;
import es.aeat.pftw.mtrc.procesadorReglas.Funciones;
import es.aeat.pftw.mtrc.procesadorReglas.GestionReglas;
import es.aeat.pftw.mtrc.procesadorReglas.IFunciones;
import es.aeat.pftw.mtrc.procesadorReglas.IGestionReglas;
import es.aeat.pftw.mtrc.procesadorReglas.OperacionesV2;
import es.aeat.pftw.mtrc.puente.GestionOperaciones;
import es.aeat.pftw.mtrc.puente.IGestionOperaciones;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.utilidades.Serializer;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.procesadorReglas.IOperaciones;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Motor
implements IMotor {
    private static final long serialVersionUID = 1L;
    protected int timeOutSwap = 0;
    protected HiloSwapThread hiloSwap = null;
    private static volatile ConcurrentMap<String, IModelo> listaModelosDisponibles = null;
    private static volatile ConcurrentMap<String, ISesion> listaSesiones = null;
    private IGestionOperaciones claseGestionOperaciones = null;
    private IGestionReglas claseGestionReglas = null;
    private Comprobaciones claseComprobaciones = null;
    private Funciones claseFunciones = null;
    private ITransformaciones claseTransformaciones = null;

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            listaModelosDisponibles = new ConcurrentHashMap<String, IModelo>();
            listaSesiones = new ConcurrentHashMap<String, ISesion>();
            try {
                this.timeOutSwap = (Integer)parametros[0];
                if (this.timeOutSwap > 0) {
                    this.hiloSwap = new HiloSwapThread(this);
                    this.hiloSwap.start();
                }
            }
            catch (Exception ex) {
                this.timeOutSwap = 0;
                FuncionesUtiles.getFuncionesUtiles().muestraAviso("No se pudo establecer timeoutSwap...");
            }
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public ISesion getSesion(String id, String aliasModelo) throws Exception {
        return this.getSesion(id, aliasModelo, false);
    }

    protected ISesion getSesion(String id, String aliasModelo, boolean vengoDelSwap) throws Exception {
        ISesion s = (ISesion)listaSesiones.get(id);
        if (s != null) {
            if (s.getModelo() != null) {
                return s;
            }
            s = null;
            if (!vengoDelSwap) {
                this.unSwap(id, aliasModelo);
                return this.getSesion(id, aliasModelo, true);
            }
        }
        throw new Exception("Sesion " + id + " no encontrada!!!");
    }

    @Override
    public ISesion getSesion() throws Exception {
        Iterator it;
        if (listaSesiones.size() == 1 && (it = listaSesiones.keySet().iterator()).hasNext()) {
            String id = (String)it.next();
            return this.getSesion(((ISesion)listaSesiones.get(id)).getId(), ((ISesion)listaSesiones.get(id)).getAliasModelo());
        }
        throw new Exception("Sesion no encontrada o existe mas de una sesion!!!");
    }

    protected boolean existeSesion(String id) throws Exception {
        return listaSesiones.get(id) != null;
    }

    @Override
    public synchronized String addSesion(IModelo modeloVinculado) throws Exception {
        if (!listaModelosDisponibles.containsKey(modeloVinculado.getAlias())) {
            throw new Exception("Modelo no encontrado!!!");
        }
        String id = "";
        id = String.valueOf(System.currentTimeMillis());
        while (this.existeSesion(id)) {
            Thread.sleep(45L);
            id = String.valueOf(System.currentTimeMillis());
        }
        Sesion s = (Sesion)FuncionesUtiles.getFuncionesUtiles().getInstancia(Sesion.class, new Object[]{this, modeloVinculado, id});
        listaSesiones.put(id, s);
        return s.getId();
    }

    @Override
    public synchronized void disposeSesion(String id) throws Exception {
        if (listaSesiones.get(id) == null) {
            throw new Exception("Sesion " + id + " no encontrada!!!");
        }
        ((ISesion)listaSesiones.get(id)).dispose();
        listaSesiones.remove(id);
    }

    @Override
    public void disposeModelo(String alias) throws Exception {
        Iterator it = listaSesiones.keySet().iterator();
        ISesion s = null;
        while (it.hasNext()) {
            s = (ISesion)listaSesiones.get(it.next());
            if (s == null || !s.getModelo().getAlias().equalsIgnoreCase(alias)) continue;
            throw new Exception("Sesion [" + s.getId() + "] esta asociada a este modelo, no se puede eliminar...");
        }
        if (listaModelosDisponibles.containsKey(alias)) {
            ((IModelo)listaModelosDisponibles.get(alias)).dispose();
            listaModelosDisponibles.remove(listaModelosDisponibles.get(alias));
            return;
        }
        throw new Exception("Modelo no encontrado!!!");
    }

    @Override
    public void addModelo(IModelo modelo) throws Exception {
        if (this.existeModelo(modelo.getAlias(), modelo.getNombreCompletoJar())) {
            throw new Exception("Alias o Modelo ya existe!!!");
        }
        listaModelosDisponibles.put(modelo.getAlias(), modelo);
    }

    @Override
    public void addModeloClonado(String alias, IModelo modelo) throws Exception {
        ((Modelo)modelo).setAlias(alias);
        listaModelosDisponibles.put(alias, modelo);
    }

    @Override
    public void addModelo(String alias, Object[] DatosParaInicializacion) throws Exception {
        if (alias == null || alias.length() == 0) {
            throw new Exception("Indique alias...");
        }
        if (this.existeModelo(alias, "")) {
            throw new Exception("Alias o Modelo ya existe!!!");
        }
        Object[] param = Arrays.copyOf(DatosParaInicializacion, DatosParaInicializacion.length + 1);
        param[param.length - 1] = alias;
        IModelo m = (IModelo)FuncionesUtiles.getFuncionesUtiles().getInstancia(Modelo.class, param);
        if (m == null) {
            throw new Exception("Error al crear modelo!!!");
        }
        listaModelosDisponibles.put(alias, m);
    }

    protected boolean existeModelo(String nombre, String rutaJar) throws Exception {
        try {
            this.getModelo(nombre, rutaJar);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected IModelo getModelo(String nombre, String rutaJar) throws Exception {
        IModelo m = null;
        Iterator it = listaModelosDisponibles.keySet().iterator();
        while (it.hasNext()) {
            m = (IModelo)listaModelosDisponibles.get(it.next());
            if (nombre.length() > 0 && m.getAlias().equalsIgnoreCase(nombre)) {
                return m;
            }
            if (rutaJar.length() <= 0 || !m.getNombreCompletoJar().equalsIgnoreCase(rutaJar)) continue;
            return m;
        }
        if (nombre.length() > 0) {
            throw new Exception("Modelo " + nombre + " no encontrado!!!");
        }
        if (rutaJar.length() > 0) {
            throw new Exception("Modelo en " + rutaJar + " no encontrado!!!");
        }
        throw new Exception("Modelo no encontrado!!!");
    }

    @Override
    public IModelo getModelo(String alias) throws Exception {
        return this.getModelo(alias, "");
    }

    @Override
    public void dispose() throws ExceptionMotor {
        try {
            if (this.hiloSwap != null) {
                this.hiloSwap.dispose();
                this.hiloSwap = null;
            }
            Iterator it = listaSesiones.keySet().iterator();
            ISesion s = null;
            while (it.hasNext()) {
                s = (ISesion)listaSesiones.get(it.next());
                if (s == null) continue;
                s.dispose();
            }
            listaSesiones.clear();
            IModelo m = null;
            Iterator it2 = listaModelosDisponibles.keySet().iterator();
            while (it2.hasNext()) {
                m = (IModelo)listaModelosDisponibles.get(it2.next());
                m.dispose();
            }
            listaModelosDisponibles.clear();
            if (this.claseFunciones != null) {
                this.claseFunciones.dispose();
                this.claseFunciones = null;
            }
            if (this.claseComprobaciones != null) {
                this.claseComprobaciones.dispose();
                this.claseComprobaciones = null;
            }
            if (this.claseTransformaciones != null) {
                this.claseTransformaciones.dispose();
                this.claseTransformaciones = null;
            }
            if (this.claseGestionOperaciones != null) {
                this.claseGestionOperaciones.dispose();
                this.claseGestionOperaciones = null;
            }
            if (this.claseGestionReglas != null) {
                this.claseGestionReglas.dispose();
                this.claseGestionReglas = null;
            }
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public IGestionOperaciones getClaseGestionOperaciones() throws ExceptionMotor {
        if (this.claseGestionOperaciones == null) {
            this.claseGestionOperaciones = (IGestionOperaciones)FuncionesUtiles.getFuncionesUtiles().getInstancia(GestionOperaciones.class, new Object[0]);
        }
        return this.claseGestionOperaciones;
    }

    @Override
    public IGestionReglas getClaseGestionReglas() throws ExceptionMotor {
        if (this.claseGestionReglas == null) {
            this.claseGestionReglas = (IGestionReglas)FuncionesUtiles.getFuncionesUtiles().getInstancia(GestionReglas.class, new Object[]{this});
        }
        return this.claseGestionReglas;
    }

    @Override
    public Comprobaciones getClaseComprobaciones() throws ExceptionMotor {
        if (this.claseComprobaciones == null) {
            this.claseComprobaciones = (Comprobaciones)FuncionesUtiles.getFuncionesUtiles().getInstancia(Comprobaciones.class, new Object[0]);
        }
        return this.claseComprobaciones;
    }

    @Override
    public IFunciones getClaseFunciones() throws ExceptionMotor {
        if (this.claseFunciones == null) {
            this.claseFunciones = (Funciones)FuncionesUtiles.getFuncionesUtiles().getInstancia(Funciones.class, new Object[]{this});
        }
        return this.claseFunciones;
    }

    @Override
    public IOperaciones getClaseOperaciones() throws ExceptionMotor {
        return OperacionesV2.getOperacionesWrapper();
    }

    @Override
    public ITransformaciones getClaseTransformaciones() throws ExceptionMotor {
        if (this.claseTransformaciones == null) {
            this.claseTransformaciones = (ITransformaciones)FuncionesUtiles.getFuncionesUtiles().getInstancia(Transformaciones.class, new Object[0]);
        }
        return this.claseTransformaciones;
    }

    @Override
    public int getTimeOutSwap() {
        return this.timeOutSwap;
    }

    @Override
    public void unSwap(String sesionId, String aliasModelo) {
        try {
            ISesion s = (ISesion)listaSesiones.get(sesionId);
            if (s != null && ((ISesionExtendida)s).getInfoSwap() != null) {
                FuncionesUtiles.getFuncionesUtiles().muestraInfoDebug("UNSWAP DE " + sesionId);
                Serializer ser = new Serializer(String.valueOf(sesionId));
                s = new Sesion((SesionCloned)ser.recuperaObjeto(((ISesionExtendida)s).getInfoSwap()), this, this.getModelo(aliasModelo));
                listaSesiones.put(sesionId, s);
                s = null;
            }
        }
        catch (Exception e) {
            FuncionesUtiles.getFuncionesUtiles().muestraAviso(e, "No se pudo hacer UnSwap de " + sesionId + "...");
        }
    }

    @Override
    public void checkSwap() {
        try {
            Iterator it = listaSesiones.keySet().iterator();
            ISesion s = null;
            while (it.hasNext()) {
                s = (ISesion)listaSesiones.get(it.next());
                if (s == null || ((ISesionExtendida)s).getInfoSwap() != null || System.currentTimeMillis() - s.getUltimoAccesoTimeStamp() <= (long)this.timeOutSwap) continue;
                FuncionesUtiles.getFuncionesUtiles().muestraInfoDebug("SWAP DE " + s.getId());
                Serializer ser = new Serializer(String.valueOf(s.getId()));
                String ruta = ser.guardaObjeto(new SesionCloned((Sesion)s));
                ser = null;
                listaSesiones.put(s.getId(), new Sesion(ruta));
                s.dispose();
                s = null;
            }
        }
        catch (Exception e) {
            FuncionesUtiles.getFuncionesUtiles().muestraAviso(e, "No se pudo hacer Swap...");
        }
    }

    class HiloSwapThread
    extends Thread
    implements Serializable {
        private static final long serialVersionUID = 1L;
        boolean stop = false;
        IMotor motor = null;

        public HiloSwapThread(IMotor motor2) {
            this.motor = motor2;
            this.setPriority(1);
        }

        public void dispose() {
            this.stop = true;
            this.motor = null;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        if (this.stop) {
                            throw new InterruptedException();
                        }
                        HiloSwapThread.sleep(2000L);
                        if (this.motor == null) continue;
                        this.motor.checkSwap();
                    }
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    FuncionesUtiles.getFuncionesUtiles().muestraError(e);
                    continue;
                }
                break;
            }
        }
    }
}

