/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.gestionFicheros.importacionV2.xml;

import es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.xml.GestorTraduccionesXML;
import es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.xml.IGestorTraduccionesXML;
import es.aeat.pftw.mtrc.gestionFicheros.importacionV2.xml.ISaxEventsListener;
import es.aeat.pftw.mtrc.gestionFicheros.importacionV2.xml.XMLReaderSAXAuxiliar;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.utilidades.INodoArbol;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLReaderSAX
extends DefaultHandler
implements ISaxEventsListener {
    protected ISaxEventsListener escuchadorEventos = null;
    protected IGestorTraduccionesXML gestor = null;
    protected INodoArbol arbolDelMotor = null;
    protected Map<String, Integer> registroDeTabla = null;
    protected List<String> rutaCompletaActual = null;
    protected String ultimoCampoLeido = "";
    protected String ultimaTablaLeida = "";
    protected StringBuffer textBuffer = null;
    protected List<String> tablasConPrelectura = null;
    private String pendienteEOT = "";
    protected String qNameAnterior = "";
    protected XMLReaderSAXAuxiliar saxReader = null;
    protected SAXParserFactory factory = null;
    protected SAXParser saxParser = null;
    protected List<String> ignoraEOT = null;
    protected InputStream isFicheroLectura = null;
    protected byte[] fichero = null;

    public XMLReaderSAX(ISaxEventsListener escuchadorEventos, IGestorTraduccionesXML gestor, INodoArbol arbolDelMotor, byte[] fichero) {
        this.comunConstructores(escuchadorEventos, gestor, arbolDelMotor, fichero);
    }

    public XMLReaderSAX(ISaxEventsListener escuchadorEventos, IGestorTraduccionesXML gestor, INodoArbol arbolDelMotor, byte[] fichero, List<String> tablasConPrelectura) {
        this.comunConstructores(escuchadorEventos, gestor, arbolDelMotor, fichero);
        this.tablasConPrelectura = tablasConPrelectura;
    }

    public void comunConstructores(ISaxEventsListener escuchadorEventos, IGestorTraduccionesXML gestor, INodoArbol arbolDelMotor, byte[] fichero) {
        this.escuchadorEventos = escuchadorEventos;
        this.gestor = (GestorTraduccionesXML)gestor;
        this.arbolDelMotor = arbolDelMotor;
        this.fichero = fichero;
        this.tablasConPrelectura = new ArrayList<String>();
    }

    public InputStream getInputStream() {
        if (this.isFicheroLectura == null) {
            try {
                this.isFicheroLectura = new ByteArrayInputStream(this.fichero);
            }
            catch (Exception Ex) {
                System.err.println("Imposible crear inputstream de fichero");
            }
        }
        return this.isFicheroLectura;
    }

    protected void revisarAtributos(Attributes attrs, Map<String, String> atributosNodo, boolean atributosDeTabla) throws ExceptionMotor {
        try {
            String atrPosible;
            boolean hacerCheckField = true;
            if (this.ignoraEOT.size() > 0 && !atributosDeTabla && this.ignoraEOT.get(this.ignoraEOT.size() - 1).toString().compareToIgnoreCase(this.ultimaTablaLeida) == 0) {
                hacerCheckField = false;
            }
            if (hacerCheckField && attrs != null && attrs.getLength() > 0 && (atrPosible = atributosNodo.get("CAMPO_ATRIBUTO")) != null) {
                String atrPosibleSinParentesis = FuncionesUtiles.getFuncionesUtiles().dameNombrePartidaSinParentesis(atrPosible);
                for (int l = 0; l < attrs.getLength(); ++l) {
                    if (!attrs.getQName(l).equalsIgnoreCase(atrPosibleSinParentesis)) continue;
                    this.checkField(atrPosible, attrs.getValue(l), true, atributosNodo);
                }
            }
        }
        catch (ExceptionMotor em) {
            throw em;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.rutaCompletaActual = new ArrayList<String>();
        this.registroDeTabla = new HashMap<String, Integer>();
        this.pendienteEOT = "";
        this.ignoraEOT = new ArrayList<String>();
        this.ultimaTablaLeida = "";
    }

    @Override
    public void endDocument() throws SAXException {
        this.rutaCompletaActual = null;
        try {
            this.escuchadorEventos.endOfFile();
        }
        catch (ExceptionMotor e) {
            System.err.println(e.toString());
        }
    }

    public String getLineaFichero() {
        return this.getRutaCompletaActual(true);
    }

    protected String getRutaCompletaActual(boolean conContadores) {
        String ret = "";
        Integer tmp = null;
        if (this.rutaCompletaActual != null) {
            for (int i = 0; i < this.rutaCompletaActual.size(); ++i) {
                if (ret.length() > 0) {
                    ret = ret + "/";
                }
                ret = ret + this.rutaCompletaActual.get(i);
                if (!conContadores || (tmp = this.registroDeTabla.get(this.rutaCompletaActual.get(i))) == null) continue;
                ret = ret + "[" + ((Object)tmp).toString() + "]";
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscarPosteriores() {
        try {
            this.saxReader = null;
            this.saxReader = new XMLReaderSAXAuxiliar(this, this.gestor, this.arbolDelMotor, this.fichero);
            this.factory = SAXParserFactory.newInstance();
            this.saxParser = this.factory.newSAXParser();
            this.saxReader.buscaCamposPosteriores(this.registroDeTabla);
            try {
                this.saxParser.parse(this.saxReader.getInputStream(), (DefaultHandler)this.saxReader);
            }
            catch (SAXException Ex) {
                if (Ex.getMessage().compareToIgnoreCase("StopParsing") != 0) {
                    throw new SAXException(Ex);
                }
            }
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
        }
        finally {
            this.saxReader = null;
            this.saxParser = null;
            this.factory = null;
        }
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        try {
            String nombreBuscadoCampo;
            this.rutaCompletaActual.add(qName);
            for (int a = 0; a < attrs.getLength(); ++a) {
                if (!attrs.getQName(a).trim().toLowerCase().startsWith("xmlns:")) continue;
                this.gestor.addNombreYRutaXmlNS(attrs.getQName(a).substring("xmlns:".length()), attrs.getValue(a));
            }
            String nombreBuscado = this.gestor.getTablaConEquivalencia(this.getRutaCompletaActual(false));
            if (nombreBuscado.length() > 0) {
                if (!this.escuchadorEventos.getSoloEstoyContandoNumeroDeRegistros() && this.pendienteEOT.length() > 0) {
                    if (!this.escuchadorEventos.endOfTable(this.pendienteEOT)) {
                        throw new SAXException("StopParsing");
                    }
                    this.ignoraEOT.add(this.pendienteEOT);
                }
                this.ultimaTablaLeida = nombreBuscado;
                this.nuevaTabla(nombreBuscado);
                if (!this.escuchadorEventos.addTable(nombreBuscado)) {
                    throw new SAXException("StopParsing");
                }
                if (!this.escuchadorEventos.getSoloEstoyContandoNumeroDeRegistros()) {
                    if (this.tablasConPrelectura.contains(nombreBuscado.toUpperCase())) {
                        this.buscarPosteriores();
                        if (this.gestor.getCampoConEquivalencia(this.getRutaCompletaActual(false)).length() == 0 && attrs.getLength() > 0) {
                            try {
                                this.revisarAtributos(attrs, this.gestor.getTabla(nombreBuscado), true);
                            }
                            catch (ExceptionMotor e) {
                                throw new SAXException(e.getMessage());
                            }
                        }
                        if (!this.escuchadorEventos.endOfTable(nombreBuscado)) {
                            throw new SAXException("StopParsing");
                        }
                        this.ignoraEOT.add(nombreBuscado);
                    } else {
                        this.pendienteEOT = nombreBuscado;
                    }
                }
            }
            if (!this.escuchadorEventos.getSoloEstoyContandoNumeroDeRegistros() && (nombreBuscadoCampo = this.gestor.getCampoConEquivalencia(this.getRutaCompletaActual(false))) != null && nombreBuscadoCampo.length() > 0) {
                if (this.ultimoCampoLeido.length() > 0) {
                    this.endElementComun(namespaceURI, "", this.qNameAnterior, false);
                }
                this.ultimoCampoLeido = nombreBuscadoCampo;
                try {
                    this.revisarAtributos(attrs, this.gestor.getCampo(this.ultimoCampoLeido), false);
                }
                catch (ExceptionMotor e) {
                    throw new SAXException(e.getMessage());
                }
            }
            this.qNameAnterior = qName;
        }
        catch (ExceptionMotor em) {
            throw new SAXException(em.getMessage());
        }
    }

    protected void endElementComun(String namespaceURI, String sName, String qName, boolean realmenteHaSidoEndElement) throws SAXException {
        try {
            if (!this.escuchadorEventos.getSoloEstoyContandoNumeroDeRegistros()) {
                String nombreTabla;
                if (this.ultimoCampoLeido.length() > 0) {
                    if (this.textBuffer == null) {
                        this.textBuffer = new StringBuffer("");
                    }
                    boolean hacerCheckField = true;
                    if (this.ignoraEOT.size() > 0 && this.ignoraEOT.get(this.ignoraEOT.size() - 1).toString().compareToIgnoreCase(this.ultimaTablaLeida) == 0) {
                        hacerCheckField = false;
                    }
                    if (hacerCheckField && !this.checkCampo(this.ultimoCampoLeido, this.textBuffer.toString(), false, this.gestor.getCampo(this.ultimoCampoLeido))) {
                        throw new SAXException("StopParsing");
                    }
                    this.textBuffer = null;
                    this.ultimoCampoLeido = "";
                }
                if ((nombreTabla = this.gestor.getTablaConEquivalencia(this.getRutaCompletaActual(false))).length() > 0) {
                    boolean hacerEOT = true;
                    if (this.ignoraEOT.size() > 0 && this.ignoraEOT.get(this.ignoraEOT.size() - 1).toString().compareToIgnoreCase(nombreTabla) == 0) {
                        hacerEOT = false;
                        this.ignoraEOT.remove(this.ignoraEOT.size() - 1);
                    }
                    if (hacerEOT) {
                        if (!this.escuchadorEventos.endOfTable(nombreTabla)) {
                            throw new SAXException("StopParsing");
                        }
                        if (this.pendienteEOT.compareToIgnoreCase(nombreTabla) == 0) {
                            this.pendienteEOT = "";
                        }
                    }
                    this.finDeTabla(nombreTabla);
                }
            }
            if (realmenteHaSidoEndElement) {
                this.rutaCompletaActual.remove(this.rutaCompletaActual.size() - 1);
            }
        }
        catch (SAXException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        this.endElementComun(namespaceURI, sName, qName, true);
    }

    protected boolean checkCampo(String campo, String valor, boolean esAtrubuto, Map<String, String> atributosNodo) throws ExceptionMotor {
        return this.escuchadorEventos.checkField(campo, valor, esAtrubuto, atributosNodo);
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        if (this.ultimoCampoLeido.length() == 0) {
            return;
        }
        if (this.escuchadorEventos.getSoloEstoyContandoNumeroDeRegistros()) {
            this.textBuffer = null;
            return;
        }
        if (this.textBuffer == null) {
            this.textBuffer = new StringBuffer("");
        }
        String cadena = new String(buf, offset, len);
        if ((cadena = cadena.replaceAll("\\n", "")).trim().length() > 0) {
            this.textBuffer.append(new String(buf, offset, len));
        }
    }

    protected void nuevaTabla(String nombreTabla) {
        nombreTabla = nombreTabla.toUpperCase();
        Integer tabla = null;
        tabla = this.registroDeTabla.get(nombreTabla);
        if (tabla == null) {
            this.registroDeTabla.put(nombreTabla, new Integer(1));
        } else {
            this.registroDeTabla.put(nombreTabla, new Integer(tabla + 1));
        }
    }

    protected void finDeTabla(String nombreTabla) throws SAXException, ExceptionMotor {
        nombreTabla = nombreTabla.toUpperCase();
        Integer Tabla = null;
        Tabla = this.registroDeTabla.get(nombreTabla);
        if (Tabla == null) {
            System.out.println("finDeTabla : Fin de tabla y no la encuentro!!");
        } else {
            INodoArbol hoja = this.arbolDelMotor.buscaHijo(nombreTabla);
            if (hoja != null) {
                for (int i = 0; i < hoja.numeroHijos(); ++i) {
                    this.borrarContadoresHijos(hoja.get(i));
                }
            }
        }
    }

    protected void borrarContadoresHijos(INodoArbol hoja) throws ExceptionMotor {
        if (hoja != null) {
            this.registroDeTabla.remove(hoja.getNombreNodo());
            for (int i = 0; i < hoja.numeroHijos(); ++i) {
                this.borrarContadoresHijos(hoja.getHijo(i));
            }
        }
    }

    @Override
    public boolean addTable(String nombreTabla) {
        return true;
    }

    @Override
    public boolean checkField(String nombreCampo, Object valor, boolean esAtributo, Map<String, String> atributosNodo) throws ExceptionMotor {
        if (this.gestor.getVariables().get(nombreCampo) != null) {
            this.gestor.getVariables().put(nombreCampo, (String)valor);
        }
        return this.checkCampo(nombreCampo, valor.toString(), esAtributo, atributosNodo);
    }

    @Override
    public boolean endOfTable(String nombreTabla) {
        return true;
    }

    @Override
    public void endOfFile() {
    }

    @Override
    public boolean getSoloEstoyContandoNumeroDeRegistros() {
        return this.escuchadorEventos.getSoloEstoyContandoNumeroDeRegistros();
    }
}

