/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.gestionFicheros.importacionV2.xml;

import es.aeat.pftw.mtrc.configuracion.RegError;
import es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.IGestorTraducciones;
import es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.xml.IGestorTraduccionesXML;
import es.aeat.pftw.mtrc.gestionFicheros.importacionV2.ComunReglasValidacion;
import es.aeat.pftw.mtrc.gestionFicheros.importacionV2.IReglasValidacion;
import es.aeat.pftw.mtrc.gestionFicheros.importacionV2.xml.CodigoComun;
import es.aeat.pftw.mtrc.gestionFicheros.importacionV2.xml.ISaxEventsListener;
import es.aeat.pftw.mtrc.gestionFicheros.importacionV2.xml.XMLReaderSAX;
import es.aeat.pftw.mtrc.tipos.ITipoDatosTabla;
import es.aeat.pftw.mtrc.tipos.TipoDatosCampoValor;
import es.aeat.pftw.mtrc.tipos.TipoDatosRegistroApiladoImportacion;
import es.aeat.pftw.mtrc.tipos.TipoDatosTabla;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.utilidades.StringUtility;
import es.aeat.pftw.mtrp.configuracion.IRegEntrada;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampoValor;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampos;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ReglasValidacion
extends ComunReglasValidacion
implements IReglasValidacion,
ISaxEventsListener {
    private static final long serialVersionUID = 1L;
    private XMLReaderSAX saxReader = null;
    private SAXParserFactory factory = null;
    private SAXParser saxParser = null;
    private List<String> tablasConPrelectura = null;
    private byte[] fichero = null;
    protected reglasValidacionComun instanciaReglasValidacionComun = null;
    private String tablaEnCurso = "";
    List<ITipoDatosCampoValor> camposTabla = null;
    private static final String LITERAL_LONGITUD_ERRONEA = "Longitud de dato para FechaInvertida no es ni 4 ni 8";
    private static final String LITERAL_LONGITUD_ERRONEA2 = "Longitud de dato para FechaInvertidaF no es 10";
    int contadorPrevioNumeroRegistros = 0;
    private boolean flagSoloContarNumeroRegistros = false;
    List<ITipoDatosTabla> listaTablas = null;
    private Map<Integer, List<TipoDatosRegistroApiladoImportacion>> pilaRegistrosQueNoSePuedenCrearAun = null;
    protected Object[] parametrosConstructor = null;

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            super.init(parametros);
            this.tablasConPrelectura = new ArrayList<String>();
            this.parametrosConstructor = parametros;
            this.setListaTablasParaRegRegistro(new ArrayList<String>());
            this.getGestorFichero().errClear();
            for (ITipoDatosTabla tab : ((IGestorTraducciones)this.getGestorFichero().getGestorTraducciones()).getTablas()) {
                if (tab.getPropiedadesTabla() == null || !tab.getPropiedadesTabla().containsKey("PRELECTURA")) continue;
                this.tablasConPrelectura.add(tab.getNombreTabla().toUpperCase());
            }
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void dispose() throws ExceptionMotor {
        super.dispose();
        if (this.instanciaReglasValidacionComun != null) {
            this.instanciaReglasValidacionComun.dispose();
            this.instanciaReglasValidacionComun = null;
        }
        this.resetObjetos();
        this.pilaRegistrosQueNoSePuedenCrearAun = null;
        this.setListaTablasParaRegRegistro(null);
    }

    @Override
    public void resetObjetos() throws ExceptionMotor {
        try {
            super.resetObjetos();
            if (this.pilaRegistrosQueNoSePuedenCrearAun != null) {
                this.getPilaRegistrosQueNoSePuedenCrearAun().clear();
                this.pilaRegistrosQueNoSePuedenCrearAun = null;
            }
            this.setListaTablasParaRegRegistro(new ArrayList<String>());
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected reglasValidacionComun getInstanciaReglasValidacionComun() throws ExceptionMotor {
        if (this.instanciaReglasValidacionComun == null) {
            this.instanciaReglasValidacionComun = new reglasValidacionComun();
            this.instanciaReglasValidacionComun.init(this.parametrosConstructor);
        }
        return this.instanciaReglasValidacionComun;
    }

    @Override
    public String formateaValor(String partida, String tipoDato, String valor, Map<String, String> propiedades, String tDato) throws ExceptionMotor {
        try {
            if (propiedades.containsKey("TIPODATOREAL")) {
                tipoDato = propiedades.get("TIPODATOREAL");
            }
            if (tipoDato.equalsIgnoreCase("1_a_true")) {
                if (valor.equalsIgnoreCase("1")) {
                    return "true";
                }
                if (valor.equalsIgnoreCase("0")) {
                    return "false";
                }
                throw new ExceptionMotor("Valor (" + valor + ") no valido para tipo '" + "1_a_true" + "'");
            }
            if (tipoDato.equalsIgnoreCase("FechaInvertida")) {
                switch (valor.length()) {
                    case 6: {
                        return valor.substring(4, 6) + valor.substring(2, 4) + valor.substring(0, 2);
                    }
                    case 8: {
                        return valor.substring(4, 8) + valor.substring(2, 4) + valor.substring(0, 2);
                    }
                }
                throw new ExceptionMotor(LITERAL_LONGITUD_ERRONEA);
            }
            if (tipoDato.equalsIgnoreCase("FechaInvertidaF")) {
                switch (valor.length()) {
                    case 10: {
                        return valor.substring(8, 10) + "-" + valor.substring(5, 7) + "-" + valor.substring(0, 4);
                    }
                }
                throw new ExceptionMotor(LITERAL_LONGITUD_ERRONEA2);
            }
            return super.formateaValor(partida, tipoDato, valor, propiedades, tDato);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    protected String formateoADecimalesBigDecimal(String valor, Object decimales) throws ExceptionMotor {
        return valor.replaceAll(",", ".");
    }

    @Override
    protected String formateoADecimales(String valor, Object decimales) throws ExceptionMotor {
        return valor.replaceAll(",", ".");
    }

    protected String formateaValorBigDecimal(String valor, Map<String, String> propiedades) throws ExceptionMotor {
        try {
            String res = valor;
            String tipoDato = "";
            try {
                tipoDato = this.getGestor().traduceCadena(propiedades.get("TIPODATO").toString());
            }
            catch (Exception ex) {
                return res;
            }
            if (tipoDato.toUpperCase().indexOf("Valores") == 0) {
                String[] p = StringUtility.getStringUtility().split(tipoDato, ":");
                for (int i = 0; i < p.length; ++i) {
                    String[] q = StringUtility.getStringUtility().split(p[i], "=");
                    if (q.length != 2 || !valor.equalsIgnoreCase(FuncionesUtiles.getFuncionesUtiles().desCodificaCadena(q[0]))) continue;
                    res = FuncionesUtiles.getFuncionesUtiles().desCodificaCadena(q[1]);
                    break;
                }
            } else if (tipoDato.toUpperCase().indexOf("CTE:") == 0) {
                res = FuncionesUtiles.getFuncionesUtiles().desCodificaCadena(tipoDato.substring("CTE:".length()));
            } else if (tipoDato.toUpperCase().indexOf("FUNCION") == 0) {
                res = this.ejecutaMetodoDeClase(tipoDato.substring(8).split(","), valor);
            }
            if (res.compareTo(valor) != 0) {
                return res;
            }
            tipoDato = "";
            try {
                tipoDato = this.getGestor().traduceCadena(propiedades.get("TIPODATO").toString());
            }
            catch (Exception ex) {
                return res;
            }
            if (tipoDato.equalsIgnoreCase("Num")) {
                return this.formateoADecimalesBigDecimal(valor, propiedades.get("DECIMALES"));
            }
            if (tipoDato.equalsIgnoreCase("NumSigno")) {
                res = this.formateoADecimalesBigDecimal(valor.substring(1), propiedades.get("DECIMALES"));
                if (valor.charAt(0) == 'N') {
                    res = "-" + res;
                }
            } else {
                if (valor.trim().length() == 0) {
                    return "";
                }
                res = StringUtility.getStringUtility().rTrim(res);
                res = res.replaceAll("'", "\u00b4");
            }
            return res;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean reglasDeValidacion(byte[] ficheroAValidar) throws ExceptionMotor {
        try {
            if (this.getGestor() == null) {
                throw new ExceptionMotor("No dispongo de gestor de traducciones, llame primero a establecerGestor");
            }
            if (((IGestorTraduccionesXML)this.getGestor()).getListadoAtributosTransXXX().containsKey("SELLO")) {
                String cadena = new String(ficheroAValidar);
                int posSello = cadena.indexOf("SELLO=\"");
                if (posSello == -1) {
                    RegError r = new RegError();
                    r.setPropiedad("NUM ERROR", "NSXML");
                    r.setTipoError("E");
                    this.getGestorFichero().addError("1", r, null);
                    this.setCorrecto(false);
                    boolean bl = false;
                    return bl;
                }
                String s = FuncionesUtiles.getFuncionesUtiles().selloPos(cadena.getBytes(), posSello += "SELLO=\"".length(), ' ');
                if (!s.equalsIgnoreCase(cadena.substring(posSello, posSello + 13))) {
                    RegError r = new RegError();
                    r.setPropiedad("NUM ERROR", "SXMLE");
                    r.setTipoError("E");
                    this.getGestorFichero().addError("1", r, null);
                    this.setCorrecto(false);
                    boolean bl = false;
                    return bl;
                }
            }
            this.abrirFichero(ficheroAValidar);
            this.cargarEstructuras();
            boolean cadena = this.reglasDeValidacion();
            return cadena;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
        finally {
            try {
                this.cerrarFichero();
            }
            catch (ExceptionMotor e) {}
        }
    }

    protected void cargarEstructuras() throws ExceptionMotor {
        try {
            this.setTablas(new HashMap<String, TipoDatosTabla>());
            List<ITipoDatosTabla> listaTablas = this.getGestor().getTablas();
            for (ITipoDatosTabla tdt : listaTablas) {
                String nomTabla;
                if (tdt.getPropiedadesTabla().containsKey("NOIMPORTAR") || (nomTabla = this.creaTabla(tdt)) == null) continue;
                for (ITipoDatosCampos campo : tdt.getCampos()) {
                    this.guardaCampo(nomTabla, campo);
                }
            }
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected String getNombreTabla(ITipoDatosTabla tdt) throws ExceptionMotor {
        try {
            String nombreTabla = tdt.getNombreTabla();
            if (this.getGestorConfiguracion().getTabla(nombreTabla) == null) {
                nombreTabla = null;
            }
            if (nombreTabla == null && tdt.getPropiedadesTabla().get("TABLABBDD") != null) {
                nombreTabla = tdt.getPropiedadesTabla().get("TABLABBDD").trim().toUpperCase();
            }
            if (nombreTabla == null || this.getGestorConfiguracion().getTabla(nombreTabla) == null) {
                return null;
            }
            return nombreTabla;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected String creaTabla(ITipoDatosTabla tdt) throws ExceptionMotor {
        try {
            if (tdt.getPropiedadesTabla().containsKey("NOIMPORTAR")) {
                throw new ExceptionMotor("No se puede crear una tabla con el atributo de no ser importada!!!");
            }
            String nomTabla = this.getNombreTabla(tdt);
            if (nomTabla == null) {
                return null;
            }
            if (this.getTablas().get(nomTabla) != null) {
                return nomTabla;
            }
            this.getTablas().put(nomTabla, new TipoDatosTabla(nomTabla));
            this.getTablas().get(nomTabla).setPropiedadesTabla(tdt.getPropiedadesTabla());
            return nomTabla;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected void guardaCampo(String nomTabla, ITipoDatosCampos campo) throws ExceptionMotor {
        try {
            if (campo != null && campo.getNombreCampo() != null && campo.getNombreCampo().trim().length() > 0) {
                if (campo.getPropiedadesCampos().get("TABLA") != null || campo.getPropiedadesCampos().get("MUEVETABLA") != null) {
                    String tabla = campo.getPropiedadesCampos().get("TABLA");
                    if (tabla == null) {
                        tabla = campo.getPropiedadesCampos().get("MUEVETABLA");
                    }
                    tabla = tabla.trim().toUpperCase();
                    if (this.getTablas().get(tabla) == null) {
                        TipoDatosTabla t = new TipoDatosTabla(tabla);
                        t.setPropiedadesTabla(new HashMap<String, String>());
                        t.getPropiedadesTabla().put("TABLABBDD", tabla);
                        this.creaTabla(t);
                    }
                    nomTabla = tabla;
                }
                if (this.getTablas().get(nomTabla).getCampos() == null) {
                    this.getTablas().get(nomTabla).setCampos(new ArrayList<ITipoDatosCampos>());
                }
                this.getTablas().get(nomTabla).getCampos().add(campo);
            } else if (campo.getPropiedadesCampos().containsKey("VALOR")) {
                String[] partidas;
                for (String p : partidas = campo.getPropiedadesCampos().get("VALOR").split(",")) {
                    ITipoDatosCampos clon = campo.clone();
                    clon.setNombreCampo(p);
                    this.guardaCampo(nomTabla, clon);
                }
            }
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean reglasDeValidacion(String ficheroAValidar) throws ExceptionMotor {
        try {
            return this.reglasDeValidacion(FuncionesUtiles.getFuncionesUtiles().file2bytesISO(ficheroAValidar));
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public void cerrarFichero() throws ExceptionMotor {
        this.getInstanciaReglasValidacionComun().cerrarFichero();
    }

    public void abrirFichero(InputStream is) throws ExceptionMotor {
        this.getInstanciaReglasValidacionComun().abrirFichero(is);
    }

    public void abrirFichero(byte[] bytes) throws ExceptionMotor {
        this.fichero = bytes;
        this.getInstanciaReglasValidacionComun().abrirFichero(new ByteArrayInputStream(bytes));
    }

    public void abrirFichero(String ficheroTXT) throws ExceptionMotor {
        try {
            this.abrirFichero(FuncionesUtiles.getFuncionesUtiles().file2bytesISO(ficheroTXT));
        }
        catch (FileNotFoundException e) {
            throw new ExceptionMotor(e);
        }
        catch (IOException e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public boolean getSoloEstoyContandoNumeroDeRegistros() {
        return this.flagSoloContarNumeroRegistros;
    }

    @Override
    public boolean addTable(String nombreTabla) throws ExceptionMotor {
        try {
            if (this.flagSoloContarNumeroRegistros) {
                ++this.contadorPrevioNumeroRegistros;
                return true;
            }
            this.getGestorFichero().fireProgressEvent();
            if (this.camposTabla == null) {
                this.camposTabla = new ArrayList<ITipoDatosCampoValor>();
            }
            this.camposTabla.clear();
            return true;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public String eventoCadenaAImportar(String cadena) throws ExceptionMotor {
        return cadena;
    }

    private void abreSaxReader(boolean Prelectura) throws ExceptionMotor {
        try {
            this.saxReader = null;
            this.saxReader = Prelectura ? new XMLReaderSAX(this, (IGestorTraduccionesXML)this.getGestor(), this.getArbolDelMotor(), this.fichero, this.tablasConPrelectura) : new XMLReaderSAX(this, (IGestorTraduccionesXML)this.getGestor(), this.getArbolDelMotor(), this.fichero);
            this.factory = SAXParserFactory.newInstance();
            this.saxParser = this.factory.newSAXParser();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    private void cierraSaxReader() throws ExceptionMotor {
        try {
            this.saxParser = null;
            this.factory = null;
            this.saxReader = null;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    protected void recorridoFicheroReglasValidacion() throws ExceptionMotor {
        try {
            this.abreSaxReader(true);
            try {
                this.listaTablas = this.getGestor().getTablas();
                this.flagSoloContarNumeroRegistros = false;
                this.saxParser.parse(this.saxReader.getInputStream(), (DefaultHandler)this.saxReader);
            }
            catch (SAXException ex) {
                if (ex.getMessage().compareToIgnoreCase("StopParsing") != 0) {
                    throw new SAXException(ex);
                }
            }
        }
        catch (ExceptionMotor em) {
            throw em;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
        finally {
            this.cierraSaxReader();
        }
    }

    @Override
    protected Map<String, String> getPropiedadesCampo(String tabla, String campo) throws ExceptionMotor {
        Map<String, String> ret = ((IGestorTraduccionesXML)this.getGestor()).getCampo(campo);
        if (ret == null) {
            ret = ((IGestorTraduccionesXML)this.getGestor()).getPropPartidaEnAtributo(campo);
        }
        return ret;
    }

    @Override
    public boolean checkField(String nombreCampo, Object valor, boolean atributo, Map<String, String> atributosNodo) throws ExceptionMotor {
        try {
            if (this.flagSoloContarNumeroRegistros) {
                return true;
            }
            nombreCampo = nombreCampo.toUpperCase();
            Map<String, String> propCampos = null;
            if (atributo) {
                String atr;
                propCampos = ((IGestorTraduccionesXML)this.getGestor()).getListaCamposEnAtributos(nombreCampo);
                if (propCampos == null && atributosNodo.containsKey("CAMPO_ATRIBUTO") && (atr = atributosNodo.get("CAMPO_ATRIBUTO")).contains("(") && nombreCampo.equalsIgnoreCase(atr.substring(0, atr.indexOf("(")))) {
                    nombreCampo = atr.toUpperCase();
                    propCampos = ((IGestorTraduccionesXML)this.getGestor()).getListaCamposEnAtributos(nombreCampo);
                }
                if (propCampos == null) {
                    throw new ExceptionMotor("No encuentro atributos de campo " + nombreCampo);
                }
                nombreCampo = propCampos.get("PARTIDA");
                if (nombreCampo == null) {
                    if (propCampos.containsKey("TIPODATO") && propCampos.get("TIPODATO").startsWith("CTE:")) {
                        String val = FuncionesUtiles.getFuncionesUtiles().desCodificaCadena(propCampos.get("TIPODATO").substring("CTE:".length()));
                        String pasado = valor.toString();
                        val = FuncionesUtiles.getFuncionesUtiles().rellena(val, val.charAt(0), pasado.length());
                        return val.equalsIgnoreCase(pasado);
                    }
                    throw new ExceptionMotor("Falta atributo PARTIDA a campo " + nombreCampo);
                }
            }
            if (this.getGestor().getVariables().get(nombreCampo) != null) {
                this.getGestor().getVariables().put(nombreCampo, valor.toString());
            }
            if (propCampos == null) {
                propCampos = this.getGestor().getCampo(nombreCampo);
            }
            if (propCampos.get("NOIMPORTAR") == null) {
                if (propCampos.containsKey("VERBATIM")) {
                    this.camposTabla.add(new TipoDatosCampoValor(nombreCampo, valor.toString()));
                } else {
                    this.camposTabla.add(new TipoDatosCampoValor(nombreCampo, FuncionesUtiles.getFuncionesUtiles().limpiaCadenaDeCaracteresDeControl(valor).toString()));
                }
            }
            return true;
        }
        catch (ExceptionMotor em) {
            throw em;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected void comprobarFragmentadas(List<ITipoDatosTabla> listaTablas, int i) throws Exception {
        if (this.getGestorTablasFragmentadas().size() > 0) {
            List<String> nombresTablas = this.getGestorTablasFragmentadas().getNombresTablas();
            for (String tb : nombresTablas) {
                boolean terminarTabla = true;
                for (int k = i; k < listaTablas.size(); ++k) {
                    if (!listaTablas.get(k).getPropiedadesTabla().containsKey("TABLABBDD") || !listaTablas.get(k).getPropiedadesTabla().get("TABLABBDD").equalsIgnoreCase(tb)) continue;
                    terminarTabla = false;
                    break;
                }
                if (!terminarTabla) continue;
                if (this.cumunRegistroNuevo(this.getGestorTablasFragmentadas().getTipoDatosTabla(tb), this.getGestorTablasFragmentadas().getListaCamposTabla(tb), null, null, true)) {
                    this.comprobarTablasAnidadas(this.getGestorTablasFragmentadas().getListaCamposTabla(tb));
                }
                this.getGestorTablasFragmentadas().remove(tb);
            }
        }
    }

    protected String dameLaqueTengaValor(String str1, String str2) throws Exception {
        if (str1 == null) {
            return str2;
        }
        return str1;
    }

    protected void addCampoATabla(String tablaActual, Map<String, String> propCampos, String nombre, String valor, TipoDatosTabla tablaDondeSeEncuentraParaTrans) throws ExceptionMotor {
        try {
            if (propCampos != null && propCampos.containsKey("TABLA") || propCampos.containsKey("MUEVETABLA")) {
                String tabla = propCampos.get("TABLA");
                String mueveTabla = propCampos.get("MUEVETABLA");
                if (!tablaActual.equalsIgnoreCase(tabla) && !tablaActual.equalsIgnoreCase(mueveTabla)) {
                    String filtro = this.nuloACadena(propCampos.get("FILTRO"));
                    this.addRegistrosQueNoSePuedenCrearAun(((Object)this.camposTabla).hashCode(), this.dameLaqueTengaValor(tabla, mueveTabla), filtro, new TipoDatosCampoValor(nombre, valor), tablaDondeSeEncuentraParaTrans);
                    if (mueveTabla != null) {
                        if (filtro != null && filtro.trim().length() > 0) {
                            String[] filtros = filtro.split(";");
                            TipoDatosRegistroApiladoImportacion tda = this.dameUltimoRegistroQueNoSePuedenCrearAunDeTipo(((Object)this.camposTabla).hashCode(), this.dameLaqueTengaValor(tabla, mueveTabla), filtro);
                            String partida = tda.getCampos().get(0).getNombreCampo();
                            String indice = "";
                            if (partida.endsWith(")")) {
                                indice = partida.substring(partida.indexOf("("));
                            }
                            for (String filter : filtros) {
                                String[] filt = filter.split("=");
                                tda.getCampos().add(new TipoDatosCampoValor("[FILTRO]" + filt[0].trim() + indice, filt[1].trim()));
                            }
                        }
                        this.dameUltimoRegistroQueNoSePuedenCrearAunDeTipo(((Object)this.camposTabla).hashCode(), this.dameLaqueTengaValor(tabla, mueveTabla), filtro).setTablaCompletada(true);
                    }
                    return;
                }
            }
            this.camposTabla.add(new TipoDatosCampoValor(nombre, valor));
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    protected boolean esValorPorDefecto(String valor, IRegEntrada ent) {
        String valorInicial = ent.getValorInicial();
        try {
            return Double.parseDouble(valor) == Double.parseDouble(valorInicial);
        }
        catch (Exception ex) {
            return valor.trim().equalsIgnoreCase(valorInicial.trim());
        }
    }

    protected boolean parteComunPartidaModificadaOEstablecerPartida(String campo, String valor) {
        String campoSinParentesis = FuncionesUtiles.getFuncionesUtiles().dameNombrePartidaSinParentesis(campo);
        try {
            String muevetabla = "";
            String tabla = "";
            try {
                muevetabla = this.getGestor().getCampo(campo).get("MUEVETABLA").toString();
            }
            catch (Exception ex) {
                muevetabla = "";
            }
            try {
                tabla = this.getGestor().getCampo(campo).get("TABLA").toString();
            }
            catch (Exception ex) {
                tabla = "";
            }
            if (tabla.length() > 0 && !this.getTablaEnCurso().equalsIgnoreCase(tabla)) {
                if (this.esValorPorDefecto(valor, this.getGestorConfiguracion().getEntrada(campoSinParentesis))) {
                    return false;
                }
                if (this.getGestor().getCampo(campo).get("ACCION") == null) {
                    this.getSesion().getOperaciones().anniadirRegistro(tabla);
                }
                this.setTablaEnCurso(tabla);
            }
            if (muevetabla.length() > 0) {
                if (!this.getTablaEnCurso().equalsIgnoreCase(muevetabla)) {
                    if (this.esValorPorDefecto(valor, this.getGestorConfiguracion().getEntrada(campoSinParentesis))) {
                        return false;
                    }
                } else {
                    this.setTablaEnCurso("");
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return true;
    }

    @Override
    protected boolean partidaModificada(String campo, String valor) throws ExceptionMotor {
        if (!this.parteComunPartidaModificadaOEstablecerPartida(campo, valor)) {
            return true;
        }
        return this.getSesion().getGestionReglas().partidaModificada(campo, valor);
    }

    @Override
    protected boolean establecerPartida(String campo, String valor) throws ExceptionMotor {
        if (!this.parteComunPartidaModificadaOEstablecerPartida(campo, valor)) {
            return true;
        }
        return this.getSesion().getOperaciones().establecerPartida(campo, valor);
    }

    protected void setTablaEnCurso(String tablaEnCurso) {
        this.tablaEnCurso = tablaEnCurso;
    }

    protected String getTablaEnCurso() {
        return this.tablaEnCurso;
    }

    @Override
    protected String getLineaFichero() throws ExceptionMotor {
        if (this.saxReader != null) {
            return this.saxReader.getLineaFichero();
        }
        return "";
    }

    @Override
    protected void setLineaFichero(String linea) {
    }

    @Override
    public int getNumRegistros(String ficheroAValidar) throws ExceptionMotor {
        try {
            return this.getNumRegistros(FuncionesUtiles.getFuncionesUtiles().file2bytesISO(ficheroAValidar));
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public int getNumRegistros(byte[] ficheroAValidar) throws ExceptionMotor {
        try {
            this.abrirFichero(ficheroAValidar);
            this.cerrarFichero();
            this.abreSaxReader(false);
            this.flagSoloContarNumeroRegistros = true;
            this.contadorPrevioNumeroRegistros = 0;
            this.saxParser.parse(this.saxReader.getInputStream(), (DefaultHandler)this.saxReader);
            this.cierraSaxReader();
            this.getGestorFichero().fireProgressEvent(0, this.contadorPrevioNumeroRegistros);
            return this.contadorPrevioNumeroRegistros;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean endOfTable(String nombreTabla) throws ExceptionMotor {
        try {
            this.getGestorFichero().addRegistroLeido(nombreTabla.toUpperCase());
            int i = -1;
            for (int j = 0; j < this.listaTablas.size(); ++j) {
                if (!this.listaTablas.get(j).getNombreTabla().equalsIgnoreCase(nombreTabla)) continue;
                i = j;
                break;
            }
            if (i == -1) {
                throw new ExceptionMotor("No encuentro en gestor la tabla " + nombreTabla);
            }
            this.comprobarFragmentadas(this.listaTablas, i);
            if (this.cumunRegistroNuevo(this.listaTablas.get(i), this.camposTabla, null, null, false)) {
                this.comprobarTablasAnidadas(this.camposTabla);
            }
            this.camposTabla = null;
            this.camposTabla = new ArrayList<ITipoDatosCampoValor>();
            return true;
        }
        catch (ExceptionMotor em) {
            throw em;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void endOfFile() throws ExceptionMotor {
        try {
            this.comprobarFragmentadas(this.listaTablas, Integer.MAX_VALUE);
        }
        catch (ExceptionMotor em) {
            throw em;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public Map<Integer, List<TipoDatosRegistroApiladoImportacion>> getPilaRegistrosQueNoSePuedenCrearAun() throws ExceptionMotor {
        try {
            if (this.pilaRegistrosQueNoSePuedenCrearAun == null) {
                this.pilaRegistrosQueNoSePuedenCrearAun = new HashMap<Integer, List<TipoDatosRegistroApiladoImportacion>>();
            }
            return this.pilaRegistrosQueNoSePuedenCrearAun;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public boolean hasRegistrosQueNoSePuedenCrearAun(int hashTabla) throws ExceptionMotor {
        return this.getPilaRegistrosQueNoSePuedenCrearAun().containsKey(hashTabla);
    }

    public void addRegistrosQueNoSePuedenCrearAun(int hashTabla, String nombreTabla, String filtro, ITipoDatosCampoValor campo, TipoDatosTabla tablaDondeSeEncuentraParaTrans) throws ExceptionMotor {
        try {
            TipoDatosRegistroApiladoImportacion tda = this.dameUltimoRegistroQueNoSePuedenCrearAunDeTipo(hashTabla, nombreTabla, filtro);
            if (tda == null) {
                if (!this.hasRegistrosQueNoSePuedenCrearAun(hashTabla)) {
                    ArrayList listaTda = new ArrayList();
                    this.getPilaRegistrosQueNoSePuedenCrearAun().put(hashTabla, listaTda);
                }
                tda = new TipoDatosRegistroApiladoImportacion(filtro, nombreTabla, tablaDondeSeEncuentraParaTrans);
                this.getPilaRegistrosQueNoSePuedenCrearAun().get(hashTabla).add(tda);
            }
            tda.getCampos().add(campo);
        }
        catch (ExceptionMotor e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    protected String nuloACadena(String cadena) {
        if (cadena == null) {
            return "";
        }
        return cadena;
    }

    public TipoDatosRegistroApiladoImportacion dameUltimoRegistroQueNoSePuedenCrearAunDeTipo(int hashTabla, String nombreTabla, String filtro) throws ExceptionMotor {
        try {
            if (!this.hasRegistrosQueNoSePuedenCrearAun(hashTabla)) {
                return null;
            }
            List<TipoDatosRegistroApiladoImportacion> todas = this.getPilaRegistrosQueNoSePuedenCrearAun().get(hashTabla);
            if (todas != null && todas.size() > 0) {
                for (int i = todas.size() - 1; i > -1; --i) {
                    if (!todas.get(i).getTabla().getNombreTabla().equalsIgnoreCase(nombreTabla) || !this.nuloACadena(todas.get(i).getFiltro()).equalsIgnoreCase(this.nuloACadena(filtro)) || todas.get(i).isTablaCompletada()) continue;
                    return todas.get(i);
                }
            }
            return null;
        }
        catch (ExceptionMotor e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public List<TipoDatosRegistroApiladoImportacion> dameRegistrosQueNoSePuedenCrearAun(int hashTabla) throws ExceptionMotor {
        try {
            if (!this.hasRegistrosQueNoSePuedenCrearAun(hashTabla)) {
                throw new ExceptionMotor("No hay registros apilados!!!");
            }
            return this.getPilaRegistrosQueNoSePuedenCrearAun().get(hashTabla);
        }
        catch (ExceptionMotor e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public void borraRegistrosQueNoSePuedenCrearAun(int hashTabla) throws ExceptionMotor {
        try {
            if (!this.hasRegistrosQueNoSePuedenCrearAun(hashTabla)) {
                throw new ExceptionMotor("No hay registros apilados!!!");
            }
            this.getPilaRegistrosQueNoSePuedenCrearAun().remove(hashTabla);
        }
        catch (ExceptionMotor e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    protected void comprobarTablasAnidadas(List<ITipoDatosCampoValor> camposTablaAMirar) throws Exception {
        if (this.hasRegistrosQueNoSePuedenCrearAun(((Object)camposTablaAMirar).hashCode())) {
            List<TipoDatosRegistroApiladoImportacion> tablasARecorrer = this.dameRegistrosQueNoSePuedenCrearAun(((Object)camposTablaAMirar).hashCode());
            for (TipoDatosRegistroApiladoImportacion tab : tablasARecorrer) {
                this.cumunRegistroNuevo(tab.getTabla(), tab.getCampos(), null, null, false);
            }
            this.borraRegistrosQueNoSePuedenCrearAun(((Object)camposTablaAMirar).hashCode());
        }
    }

    protected class reglasValidacionComun
    extends CodigoComun {
        private static final long serialVersionUID = 1L;

        protected reglasValidacionComun() {
        }
    }
}

