/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.gestionFicheros.importacionV2.boeV2;

import es.aeat.pftw.mtrc.configuracion.RegError;
import es.aeat.pftw.mtrc.gestionFicheros.importacionV2.boeV2.CodigoComun;
import es.aeat.pftw.mtrc.gestionFicheros.importacionV2.boeV2.IValidacionEstructura;
import es.aeat.pftw.mtrc.tipos.ITipoDatosIdentificarTabla;
import es.aeat.pftw.mtrc.tipos.ITipoDatosTabla;
import es.aeat.pftw.mtrc.tipos.TipoDatosCampoValor;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrp.configuracion.IRegError;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.tipos.ITipoDatoRetornoMetodo;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampoValor;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampos;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValidacionEstructura
extends CodigoComun
implements IValidacionEstructura {
    private static final long serialVersionUID = 1L;
    private Map<String, String> arraySecuenciasDesHabilitadas = new HashMap<String, String>();
    private List<ITipoDatosCampoValor> listadoSecuencias = new ArrayList<ITipoDatosCampoValor>();

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            super.init(parametros);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean validaEstructura(String ficheroTXT) throws ExceptionMotor {
        try {
            if (this.getGestorBOE() == null) {
                throw new ExceptionMotor("No dispongo de gestor de traducciones, llame primero a establecerGestor");
            }
            return this.validaEstructura(FuncionesUtiles.getFuncionesUtiles().file2bytesISO(ficheroTXT));
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean validaEstructura(byte[] bytes) throws ExceptionMotor {
        try {
            if (this.getGestorBOE() == null) {
                throw new ExceptionMotor("No dispongo de gestor de traducciones, llame primero a establecerGestor");
            }
            this.getGestorFichero().errClear();
            this.abrirFichero(bytes);
            boolean ret = this.validaEstructura();
            this.cerrarFichero();
            return ret;
        }
        catch (Exception ex) {
            if (this.isFicheroAbierto()) {
                this.cerrarFichero();
            }
            if (ex instanceof ExceptionMotor) {
                throw (ExceptionMotor)ex;
            }
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean establecerEstadoReglaSecuencia(String nombreFuncion, String parametrosFuncion, boolean estado) throws ExceptionMotor {
        try {
            if (estado) {
                if (this.getArraySecuenciasDesHabilitadas().get(nombreFuncion.toUpperCase() + "~" + parametrosFuncion.toUpperCase()) == null) {
                    return false;
                }
                this.getArraySecuenciasDesHabilitadas().remove(nombreFuncion.toUpperCase() + "~" + parametrosFuncion.toUpperCase());
            } else {
                this.getArraySecuenciasDesHabilitadas().put(nombreFuncion.toUpperCase() + "~" + parametrosFuncion.toUpperCase(), "Deshabilitada");
            }
            return true;
        }
        catch (Exception ex) {
            FuncionesUtiles.getFuncionesUtiles().muestraError(ex, "Funcion " + nombreFuncion + " param " + parametrosFuncion + " estado " + estado);
            return false;
        }
    }

    @Override
    public List<ITipoDatosCampoValor> getListadoSecuencias() {
        return this.listadoSecuencias;
    }

    @Override
    public void addSecuenciaLeida(String cadena, ITipoDatosIdentificarTabla tabla) throws ExceptionMotor {
        try {
            this.getListadoSecuencias().add(new TipoDatosCampoValor(cadena.substring(0, tabla.getPosicionesAConsumir()), cadena));
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean validaEstructura() throws ExceptionMotor {
        try {
            this.getGestorFichero().setFueCancelado(false);
            this.setSuperoNumeroMaximoErrores(false);
            this.getGestorFichero().errClear();
            this.setCorrecto(true);
            int longitudRegistro = 0;
            if (this.getGestorBOE() == null) {
                throw new ExceptionMotor("No dispongo de gestor de traducciones, llame primero a establecerGestor");
            }
            String cadena = "";
            List<ITipoDatosCampos> campos = null;
            List<Object> errores = null;
            Map<String, String> propCampos = null;
            List<ITipoDatosTabla> listaTablas = this.getGestorBOE().getTablas();
            Map<String, String> variables = this.getGestorBOE().getVariables();
            String cad = "";
            String cadenaAGrabar = "";
            boolean grabarCadenaAGrabar = false;
            boolean introducirLeidos = this.getGestorFichero().gettotalesLeidos().size() == 0;
            IRegError err = null;
            this.getListadoSecuencias().clear();
            while ((cadena = this.lineaSiguiente()) != null) {
                if (this.getGestorFichero().isFueCancelado()) {
                    this.getListadoSecuencias().clear();
                    throw new ExceptionMotor("Se cancelo...");
                }
                cadenaAGrabar = "";
                grabarCadenaAGrabar = false;
                if (cadena.compareTo(this.getSaltoDeLinea()) == 0) {
                    cadenaAGrabar = cadena;
                } else {
                    ITipoDatosIdentificarTabla ret = this.identificameTablaDeCadena(cadena, false);
                    if (ret != null) {
                        int i = ret.getIndice();
                        int con = this.sacarLongitud(cadena, listaTablas.get(i).getPropiedadesTabla().get("LONGITUD"));
                        if (con == -1) {
                            String cadAux = this.extraeCadenaDeLongitud(listaTablas.get(i).getPropiedadesTabla().get("LONGITUD"));
                            if (cadAux == null) {
                                throw new ExceptionMotor("Error no esperado");
                            }
                            cadena = cadena + cadAux;
                        }
                        this.addSecuenciaLeida(cadena, ret);
                        cad = cadena.substring(0, ret.getPosicionesAConsumir());
                        if (introducirLeidos) {
                            this.getGestorFichero().addRegistroLeido(listaTablas.get(i).getNombreTabla().toUpperCase());
                        }
                        cadena = this.consumeDeCadena(cadena, cad.length());
                        cadenaAGrabar = cadenaAGrabar + cad;
                        campos = listaTablas.get(i).getCampos();
                        errores = new ArrayList();
                        propCampos = null;
                        for (int j = 0; j < campos.size(); ++j) {
                            errores.clear();
                            propCampos = campos.get(j).getPropiedadesCampos();
                            if (propCampos != null && propCampos.containsKey("NOEXPORTAR")) {
                                propCampos.put("LONGITUD", "0");
                            }
                            if ((longitudRegistro = this.sacarLongitud(cadena, propCampos.get("LONGITUD"))) == -1) {
                                cad = cadena;
                            } else {
                                if (cadena.length() < longitudRegistro) {
                                    throw new Exception("Registro " + cad + " longitud superior a cadena a trocear!!! especificado " + longitudRegistro + " pero la cadena tiene " + cadena.length());
                                }
                                cad = cadena.substring(0, longitudRegistro);
                            }
                            cadena = this.consumeDeCadena(cadena, cad.length());
                            if (variables.containsKey(campos.get(j).getNombreCampo().toUpperCase())) {
                                variables.put(campos.get(j).getNombreCampo().toUpperCase(), cad);
                            }
                            this.setColetillaWarning("");
                            if (propCampos.get("NOIMPORTAR") == null || !propCampos.get("NOIMPORTAR").equalsIgnoreCase("NI VALIDAR")) {
                                errores = this.getGestorBOE().validaCampoEx(propCampos, cad);
                            }
                            if (errores.size() > 0) {
                                this.setTransf("");
                                if (propCampos.get("TIPODATO") != null) {
                                    this.setTransf(this.getTransformacionSegunTipoDato(propCampos.get("TIPODATO")));
                                }
                                if (this.getTransf().length() == 0 && propCampos.get("TRANSVE") != null) {
                                    if (this.getTransf().length() > 0) {
                                        this.setTransf(this.getTransf() + ";");
                                    }
                                    this.setTransf(propCampos.get("TRANSVE").toString());
                                }
                                if (this.getTransf().length() > 0 && this.isPermitirTransformaciones()) {
                                    this.getGestorFichero().transfCargaTransformaciones(cad, this.getTransf());
                                    while (this.setTransf(this.getGestorFichero().transfDameSiguienteTransformacion()) != null) {
                                        this.setWarning(this.getGestorBOE().validaCampoEx(propCampos, this.getTransf()));
                                        if (this.getWarning().size() == 0) {
                                            this.setColetillaWarning(this.getGestorFichero().transfDameColetilla());
                                            break;
                                        }
                                        this.setColetillaWarning("");
                                        this.getGestorFichero().setValor(this.getTransf());
                                    }
                                }
                                for (int k = 0; k < errores.size(); ++k) {
                                    if (this.getColetillaWarning().length() == 0) {
                                        this.setCorrecto(false);
                                        err = this.getModelo().getGestorConfiguracion().getErrorIfExists(((String)errores.get(k)).toString());
                                        if (err == null) {
                                            err = new RegError();
                                            err.setIdError(((String)errores.get(k)).toString());
                                        } else {
                                            err = err.clone();
                                        }
                                        this.getGestorFichero().addError(String.valueOf(this.getLineaFichero()), err, propCampos);
                                        err = null;
                                    } else {
                                        grabarCadenaAGrabar = true;
                                        err = this.getModelo().getGestorConfiguracion().getErrorIfExists(((String)errores.get(k)).toString() + this.getColetillaWarning());
                                        if (err == null) {
                                            err = new RegError();
                                            err.setIdError(((String)errores.get(k)).toString() + this.getColetillaWarning());
                                            if (this.getColetillaWarning().length() > 0) {
                                                err.setIdError(err.getIdError() + this.getColetillaWarning());
                                                err.setPropiedad("CLASE_ORIGEN_ERROR", "VALIDACIONEXTRA");
                                            }
                                        } else {
                                            err = err.clone();
                                        }
                                        this.getGestorFichero().addWarning(String.valueOf(this.getLineaFichero()), err, propCampos);
                                        err = null;
                                    }
                                    if (this.getGestorFichero().errCount() < this.getGestorFichero().getMaxErrores()) continue;
                                    this.setSuperoNumeroMaximoErrores(true);
                                    FuncionesUtiles.getFuncionesUtiles().dejaSoloNerroresEntreListas(this.getListaErrores(), this.getListaWarning(), this.getGestorFichero().getMaxErrores());
                                    return false;
                                }
                            }
                            cadenaAGrabar = this.getColetillaWarning().length() > 0 ? cadenaAGrabar + this.getTransf() : cadenaAGrabar + cad;
                        }
                    }
                }
                if (cadenaAGrabar == null) continue;
                if (cadenaAGrabar.equalsIgnoreCase(this.getSaltoDeLinea())) {
                    this.getgestorFicherosIntermediosDatos().saltoDeLinea(grabarCadenaAGrabar);
                    continue;
                }
                cadenaAGrabar = cadenaAGrabar + cadena;
                this.getgestorFicherosIntermediosDatos().nuevaLinea(cadenaAGrabar, grabarCadenaAGrabar);
            }
            if (this.getLineaFichero().equalsIgnoreCase("0")) {
                String errorStr = "NOREGS";
                err = this.getModelo().getGestorConfiguracion().getErrorIfExists(errorStr);
                if (err == null) {
                    err = new RegError();
                    err.setIdError(errorStr);
                } else {
                    err = err.clone();
                }
                this.getGestorFichero().addError("0", err, propCampos);
                err = null;
                this.setCorrecto(false);
                this.getListadoSecuencias().clear();
                return false;
            }
            if (this.getGestorFichero().isFueCancelado()) {
                throw new ExceptionMotor("Se cancelo");
            }
            return this.isCorrecto();
        }
        catch (Exception ex) {
            this.getListadoSecuencias().clear();
            if (ex instanceof ExceptionMotor) {
                throw (ExceptionMotor)ex;
            }
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public String getTransformacionSegunTipoDato(String tipoDato) throws ExceptionMotor {
        try {
            ITipoDatoRetornoMetodo ret;
            if (this.getModelo() != null && this.getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getModelo().getFuncionalidadPersonalizadaModelo().getTransformacionSegunTipoDato(this, tipoDato)).isRetornaResultado()) {
                return ret.getObjetoRetornoAsString();
            }
            return this.getTransformacionSegunTipoDatoRecursivo(tipoDato).getObjetoRetornoAsString();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void cancelar() {
        this.getGestorFichero().cancelar();
    }

    protected String formateaValor(String valor, Map<String, String> propiedades) {
        return valor;
    }

    protected void setArraySecuenciasDesHabilitadas(Map<String, String> arraySecuenciasDesHabilitadas) {
        this.arraySecuenciasDesHabilitadas = arraySecuenciasDesHabilitadas;
    }

    protected Map<String, String> getArraySecuenciasDesHabilitadas() {
        return this.arraySecuenciasDesHabilitadas;
    }
}

