/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.gestionFicheros.importacionV2.boeV2;

import es.aeat.pftw.mtrc.configuracion.RegError;
import es.aeat.pftw.mtrc.gestionFicheros.exportacionV2.boeV2.ExportacionBOE;
import es.aeat.pftw.mtrc.gestionFicheros.exportacionV2.boeV2.GeneradorLineas;
import es.aeat.pftw.mtrc.gestionFicheros.exportacionV2.boeV2.IExportacionBOE;
import es.aeat.pftw.mtrc.gestionFicheros.exportacionV2.boeV2.IGeneradorLineas;
import es.aeat.pftw.mtrc.gestionFicheros.importacionV2.boeV2.CodigoComun;
import es.aeat.pftw.mtrc.gestionFicheros.importacionV2.boeV2.IValidacionCaracteres;
import es.aeat.pftw.mtrc.tipos.ITipoDatosIdentificarTabla;
import es.aeat.pftw.mtrc.tipos.ITipoDatosTabla;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrp.configuracion.IRegEntrada;
import es.aeat.pftw.mtrp.configuracion.IRegError;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.tipos.ITipoDatoRetornoMetodo;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampos;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValidacionCaracteres
extends CodigoComun
implements IValidacionCaracteres {
    private static final long serialVersionUID = 1L;
    protected String ultimaTabla = "";
    protected Map<String, String> primerCampoTabla = null;
    protected boolean errores2ValorPorDefecto = false;
    protected int contadorPosicionActualLinea = 0;

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            super.init(parametros);
            this.errores2ValorPorDefecto = false;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean validaCaracteres(String ficheroTXT) throws ExceptionMotor {
        try {
            if (this.getGestorBOE() == null) {
                throw new ExceptionMotor("No dispongo de gestor de traducciones, llame primero a establecerGestor");
            }
            return this.validaCaracteres(FuncionesUtiles.getFuncionesUtiles().file2bytesISO(ficheroTXT));
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Fichero " + ficheroTXT);
        }
    }

    @Override
    public boolean validaCaracteres(byte[] bytes) throws ExceptionMotor {
        try {
            if (this.getGestorBOE() == null) {
                throw new ExceptionMotor("No dispongo de gestor de traducciones, llame primero a establecerGestor");
            }
            this.getGestorFichero().errClear();
            this.abrirFichero(bytes);
            boolean ret = this.validaCaracteres();
            this.cerrarFichero();
            return ret;
        }
        catch (Exception ex) {
            if (this.isFicheroAbierto()) {
                this.cerrarFichero();
            }
            if (ex instanceof ExceptionMotor) {
                throw (ExceptionMotor)ex;
            }
            throw new ExceptionMotor(ex);
        }
    }

    protected boolean esPrimerCampoDeTabla(String partida, String tabla) throws ExceptionMotor {
        try {
            if (partida.contains("(")) {
                return FuncionesUtiles.getFuncionesUtiles().dameNombrePartidaSinParentesis(partida).equalsIgnoreCase(FuncionesUtiles.getFuncionesUtiles().dameNombrePartidaSinParentesis(this.primerCampoTabla.get(tabla)));
            }
            return partida.equalsIgnoreCase(this.primerCampoTabla.get(tabla));
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, partida + "(" + tabla + ")");
        }
    }

    protected String quitaFiltroAEntradaBitacora(String entradaBitacora) {
        if (entradaBitacora.startsWith("[FILTRO]")) {
            return entradaBitacora.substring("[FILTRO]".length());
        }
        return entradaBitacora;
    }

    @Override
    public String getTransformacionSegunTipoDato(String tipoDato) throws ExceptionMotor {
        try {
            ITipoDatoRetornoMetodo ret;
            if (this.getModelo() != null && this.getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getModelo().getFuncionalidadPersonalizadaModelo().getTransformacionSegunTipoDato(this, tipoDato)).isRetornaResultado()) {
                return ret.getObjetoRetornoAsString();
            }
            return this.getTransformacionSegunTipoDatoRecursivo(tipoDato).getObjetoRetornoAsString();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean validaCaracteres() throws ExceptionMotor {
        try {
            boolean introducirLeidos;
            this.ultimaTabla = "";
            this.primerCampoTabla = new HashMap<String, String>();
            this.getGestorFichero().setFueCancelado(false);
            this.setSuperoNumeroMaximoErrores(false);
            this.getGestorFichero().errClear();
            this.setCorrecto(true);
            if (this.getGestorFichero() == null) {
                throw new ExceptionMotor("No dispongo de gestor de traducciones, llame primero a establecerGestor");
            }
            String cadena = "";
            List<ITipoDatosCampos> campos = null;
            List<Object> errores = null;
            Map<String, String> propCamposOriginal = null;
            Map<String, String> propCampos = null;
            List<ITipoDatosTabla> listaTablas = this.getGestorBOE().getTablas();
            List<ITipoDatosTabla> listaTablasAdicionales = this.getGestorBOE().getTablasAuxiliares();
            Map<String, String> variables = this.getGestorBOE().getVariables();
            String cad = "";
            String cadenaLeida = "";
            String cadenaAGrabar = "";
            boolean grabarCadenaAGrabar = false;
            String sustitucionLectura = "";
            int longitudRegistro = 0;
            String registroAnterior = "";
            boolean esSiguiente = false;
            boolean bl = introducirLeidos = this.getGestorFichero().gettotalesLeidos().size() == 0;
            while ((cadenaLeida = this.lineaSiguiente()) != null) {
                if (this.getGestorFichero().isFueCancelado()) {
                    throw new ExceptionMotor("Cancelado...");
                }
                this.contadorPosicionActualLinea = 0;
                cadena = cadenaLeida;
                cadenaAGrabar = "";
                grabarCadenaAGrabar = false;
                if (cadena.compareTo(this.getSaltoDeLinea()) == 0) {
                    cadenaAGrabar = cadena;
                } else {
                    ITipoDatosIdentificarTabla ret = this.identificameTablaDeCadena(cadena, false);
                    if (ret != null) {
                        int accesoDirectoTablaAdicional;
                        int i = ret.getIndice();
                        cad = cadena.substring(0, ret.getPosicionesAConsumir());
                        esSiguiente = registroAnterior.length() != 0 && cad.equalsIgnoreCase(registroAnterior);
                        this.contadorPosicionActualLinea += ret.getPosicionesAConsumir();
                        if (introducirLeidos) {
                            this.getGestorFichero().addRegistroLeido(listaTablas.get(i).getNombreTabla().toUpperCase());
                        }
                        cadena = this.consumeDeCadena(cadena, cad.length());
                        cadenaAGrabar = cadenaAGrabar + cad;
                        campos = listaTablas.get(i).getCampos();
                        errores = new ArrayList();
                        propCampos = null;
                        for (int j = 0; j < campos.size(); ++j) {
                            errores.clear();
                            propCamposOriginal = FuncionesUtiles.getFuncionesUtiles().traducirTipoCampo(campos.get(j).getPropiedadesCampos(), this.getGestorBOE());
                            propCampos = propCamposOriginal == null ? null : (Map<String, String>)((HashMap)propCamposOriginal).clone();
                            if (propCampos != null && esSiguiente) {
                                propCampos.put("ESSIGUIENTE", "true");
                            }
                            if (propCampos != null && propCampos.containsKey("NOEXPORTAR")) {
                                propCampos.put("LONGITUD", "0");
                            }
                            sustitucionLectura = ((String)propCampos.get("SUSTITUCION")).toString();
                            propCampos.remove("SUSTITUCION");
                            longitudRegistro = this.sacarLongitud(cadena, propCampos.get("LONGITUD"));
                            cad = longitudRegistro == -1 ? cadena : cadena.substring(0, longitudRegistro);
                            cadena = this.consumeDeCadena(cadena, cad.length());
                            if (variables.containsKey(campos.get(j).getNombreCampo().toUpperCase())) {
                                variables.put(campos.get(j).getNombreCampo().toUpperCase(), cad);
                            }
                            this.setColetillaWarning("");
                            if (propCampos.get("NOIMPORTAR") == null || !propCampos.get("NOIMPORTAR").toString().equalsIgnoreCase("NI VALIDAR")) {
                                if (propCampos.containsKey("SIGUIENTES") && propCampos.containsKey("ESSIGUIENTE")) {
                                    if (propCampos.get("SIGUIENTES").toString().toUpperCase().startsWith("NO VALIDAR")) {
                                        cad = this.dameCadenaCte(propCampos);
                                    } else {
                                        Map clon = (Map)((HashMap)propCampos).clone();
                                        if (!propCampos.get("SIGUIENTES").startsWith("CTE:")) {
                                            propCampos.put("SIGUIENTES", "CTE:" + FuncionesUtiles.getFuncionesUtiles().codificaCadena(propCampos.get("SIGUIENTES")));
                                        }
                                        clon.put("TIPODATO", propCampos.get("SIGUIENTES"));
                                        clon.remove("SIGUIENTES");
                                        errores = this.getGestorBOE().validaCampo(clon, cad);
                                    }
                                } else {
                                    errores = this.getGestorBOE().validaCampo(propCampos, cad);
                                }
                            }
                            if (errores.size() > 0) {
                                this.setTransf("");
                                if (propCampos.get("TIPODATO") != null) {
                                    this.setTransf(this.getTransformacionSegunTipoDato(propCampos.get("TIPODATO")));
                                }
                                if (propCampos.get("TRANSVC") != null) {
                                    if (this.getTransf().length() > 0) {
                                        this.setTransf(this.getTransf() + ";");
                                    }
                                    this.setTransf(this.getTransf() + propCampos.get("TRANSVC").toString());
                                }
                                if (this.getTransf().length() > 0 && this.isPermitirTransformaciones()) {
                                    this.getGestorFichero().transfCargaTransformaciones(cad, this.getTransf());
                                    while (this.setTransf(this.getGestorFichero().transfDameSiguienteTransformacion()) != null) {
                                        this.setWarning(this.getGestorBOE().validaCampo(propCampos, this.getTransf()));
                                        if (this.getWarning().size() == 0) {
                                            this.setColetillaWarning(this.getGestorFichero().transfDameColetilla());
                                            break;
                                        }
                                        this.setColetillaWarning("");
                                        this.getGestorFichero().setValor(this.getTransf());
                                    }
                                }
                                for (int k = 0; k < errores.size(); ++k) {
                                    if (this.getColetillaWarning().length() == 0) {
                                        if (this.isErrores2ValorPorDefecto()) {
                                            IRegEntrada re = this.getModelo().getGestorConfiguracion().getEntrada(campos.get(j).getNombreCampo());
                                            IExportacionBOE expBOE = (IExportacionBOE)FuncionesUtiles.getFuncionesUtiles().getInstancia(ExportacionBOE.class, new Object[]{this.getModelo(), false});
                                            IGeneradorLineas genLinOBJ = (IGeneradorLineas)FuncionesUtiles.getFuncionesUtiles().getInstancia(GeneradorLineas.class, new Object[]{expBOE});
                                            sustitucionLectura = genLinOBJ.dameCampo(listaTablas.get(i).getNombreTabla(), campos.get(j).getNombreCampo(), re.getValorInicial());
                                            if (sustitucionLectura.length() == 0) {
                                                this.setCorrecto(false);
                                            }
                                            re = null;
                                            genLinOBJ = null;
                                        } else {
                                            this.setCorrecto(false);
                                        }
                                        this.addError(((String)errores.get(k)).toString(), campos.get(j).getNombreCampo(), propCampos, "", cad);
                                    } else {
                                        grabarCadenaAGrabar = true;
                                        this.addWarning(((String)errores.get(k)).toString(), campos.get(j).getNombreCampo(), propCampos, this.getColetillaWarning(), cad);
                                    }
                                    if (this.getGestorFichero().errCount() < this.getGestorFichero().getMaxErrores()) continue;
                                    this.setSuperoNumeroMaximoErrores(true);
                                    FuncionesUtiles.getFuncionesUtiles().dejaSoloNerroresEntreListas(this.getListaErrores(), this.getListaWarning(), this.getGestorFichero().getMaxErrores());
                                    return false;
                                }
                            }
                            if (this.getColetillaWarning().length() > 0) {
                                cadenaAGrabar = cadenaAGrabar + this.getTransf();
                            } else if (sustitucionLectura.length() == 0) {
                                cadenaAGrabar = cadenaAGrabar + cad;
                            } else {
                                cadenaAGrabar = cadenaAGrabar + sustitucionLectura;
                                grabarCadenaAGrabar = true;
                            }
                            this.contadorPosicionActualLinea += cad.length();
                        }
                        if (this.getGestorFichero().getRutaDatosAdicionales().length() > 0 && (accesoDirectoTablaAdicional = this.getGestorBOE().getTableAdicionalIndex(listaTablas.get(i).getNombreTabla())) > -1) {
                            cadena = this.lineaSiguienteAdicional();
                            campos = listaTablasAdicionales.get(accesoDirectoTablaAdicional).getCampos();
                            errores = new ArrayList();
                            propCampos = null;
                            for (int j = 0; j < campos.size(); ++j) {
                                errores.clear();
                                propCampos = campos.get(j).getPropiedadesCampos();
                                longitudRegistro = this.sacarLongitud(cadena, propCampos.get("LONGITUD"));
                                cad = longitudRegistro == -1 ? cadena : cadena.substring(0, longitudRegistro);
                                cadena = this.consumeDeCadena(cadena, cad.length());
                                if (propCampos.get("NOIMPORTAR") == null || !propCampos.get("NOIMPORTAR").toString().equalsIgnoreCase("NI VALIDAR")) {
                                    errores = this.getGestorBOE().validaCampo(propCampos, cad);
                                }
                                if (errores.size() <= 0) continue;
                                this.setCorrecto(false);
                                for (int k = 0; k < errores.size(); ++k) {
                                    this.addError(((String)errores.get(k)).toString(), campos.get(j).getNombreCampo(), propCampos, "", cad);
                                    if (this.getGestorFichero().errCount() < this.getGestorFichero().getMaxErrores()) continue;
                                    this.setSuperoNumeroMaximoErrores(true);
                                    throw new ExceptionMotor("CORTAR EJECUCION SIN MAS");
                                }
                            }
                        }
                        registroAnterior = cadenaLeida.substring(0, ret.getPosicionesAConsumir());
                    }
                }
                if (cadenaAGrabar == null) continue;
                if (cadenaAGrabar.equalsIgnoreCase(this.getSaltoDeLinea())) {
                    this.getgestorFicherosIntermediosDatos().saltoDeLinea(grabarCadenaAGrabar);
                    continue;
                }
                cadenaAGrabar = cadenaAGrabar + cadena;
                this.getgestorFicherosIntermediosDatos().nuevaLinea(cadenaAGrabar, grabarCadenaAGrabar);
            }
            if (this.getGestorFichero().isFueCancelado()) {
                throw new ExceptionMotor("Cancelado");
            }
            return this.isCorrecto();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public String dameCadenaCte(Map<String, String> campo) {
        String siguientes = campo.get("SIGUIENTES").toString();
        if (siguientes.toUpperCase().startsWith("NO VALIDAR")) {
            siguientes = siguientes.substring("NO VALIDAR".length() + 1);
        }
        if (siguientes.toUpperCase().startsWith("CTE:") && (siguientes = FuncionesUtiles.getFuncionesUtiles().desCodificaCadena(siguientes.substring("CTE:".length()))).length() == 1 && campo.containsKey("LONGITUD")) {
            siguientes = FuncionesUtiles.getFuncionesUtiles().rellena(siguientes, siguientes.charAt(0), Integer.parseInt(campo.get("LONGITUD")));
        }
        return siguientes;
    }

    @Override
    public IRegError addErrorWarningComun(String codError, String nombreCampo, Map<String, String> propCampos, String coletilla, String valorFallido) {
        RegError err = new RegError();
        err.setIdError(codError);
        err.setPropiedad("POSICIONFICHERO", String.valueOf(this.contadorPosicionActualLinea + 1));
        if (propCampos != null && propCampos.containsKey("TIPODATO")) {
            err.setPropiedad("TIPODATO", propCampos.get("TIPODATO"));
        }
        err.setTipoError("E");
        err.setCampoError(nombreCampo);
        if (valorFallido != null) {
            err.setPropiedad("VALORFALLIDO", valorFallido);
        }
        if (coletilla.length() > 0) {
            err.setIdError(err.getIdError() + coletilla);
            err.setPropiedad("CLASE_ORIGEN_ERROR", "VALIDACIONEXTRA");
            err.setTipoError("W");
        }
        return err;
    }

    @Override
    public void addError(String codError, String nombreCampo, Map<String, String> propCampos, String coletilla, String valorFallido) {
        this.getGestorFichero().addError(String.valueOf(this.getLineaSinSaltos()), this.addErrorWarningComun(codError, nombreCampo, propCampos, coletilla, valorFallido), propCampos);
    }

    @Override
    public void addWarning(String codError, String nombreCampo, Map<String, String> propCampos, String coletilla, String valorFallido) {
        this.getGestorFichero().addWarning(String.valueOf(this.getLineaSinSaltos()), this.addErrorWarningComun(codError, nombreCampo, propCampos, coletilla, valorFallido), propCampos);
    }

    @Override
    public void cancelar() {
        this.getGestorFichero().cancelar();
    }

    @Override
    public String formateaValor(String valor, Map<String, String> propiedades) {
        return valor;
    }

    @Override
    public boolean getErrores2ValorPorDefecto() {
        return this.isErrores2ValorPorDefecto();
    }

    @Override
    public void setErrores2ValorPorDefecto(boolean errores2ValorPorDefecto) {
        this.errores2ValorPorDefecto = errores2ValorPorDefecto;
    }

    @Override
    public boolean isErrores2ValorPorDefecto() {
        return this.errores2ValorPorDefecto;
    }
}

