/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.gestionFicheros.importacionV2.boeV2;

import es.aeat.pftw.mtrc.gestionFicheros.importacionV2.ComunReglasValidacion;
import es.aeat.pftw.mtrc.gestionFicheros.importacionV2.IReglasValidacion;
import es.aeat.pftw.mtrc.gestionFicheros.importacionV2.boeV2.CodigoComun;
import es.aeat.pftw.mtrc.tipos.ITipoDatosIdentificarTabla;
import es.aeat.pftw.mtrc.tipos.ITipoDatosTabla;
import es.aeat.pftw.mtrc.tipos.TipoDatosCampoValor;
import es.aeat.pftw.mtrc.tipos.TipoDatosRegistroApiladoImportacion;
import es.aeat.pftw.mtrc.tipos.TipoDatosTabla;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.utilidades.StringUtility;
import es.aeat.pftw.mtrp.configuracion.IRegEntrada;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampoValor;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampos;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReglasValidacion
extends ComunReglasValidacion
implements IReglasValidacion {
    private static final long serialVersionUID = 1L;
    protected reglasValidacionComun instanciaReglasValidacionComun = null;
    private String tablaEnCurso = "";
    List<ITipoDatosCampoValor> camposTabla = null;
    private static final String LITERAL_LONGITUD_ERRONEA = "Longitud de dato para FechaInvertida no es ni 4 ni 8";
    private Map<Integer, List<TipoDatosRegistroApiladoImportacion>> pilaRegistrosQueNoSePuedenCrearAun = null;
    protected Object[] parametrosConstructor = null;

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            super.init(parametros);
            this.parametrosConstructor = parametros;
            this.setListaTablasParaRegRegistro(new ArrayList<String>());
            this.getGestorFichero().errClear();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void dispose() throws ExceptionMotor {
        super.dispose();
        if (this.instanciaReglasValidacionComun != null) {
            this.instanciaReglasValidacionComun.dispose();
            this.instanciaReglasValidacionComun = null;
        }
        this.resetObjetos();
        this.pilaRegistrosQueNoSePuedenCrearAun = null;
        this.setListaTablasParaRegRegistro(null);
    }

    @Override
    public void resetObjetos() throws ExceptionMotor {
        try {
            super.resetObjetos();
            if (this.pilaRegistrosQueNoSePuedenCrearAun != null) {
                this.getPilaRegistrosQueNoSePuedenCrearAun().clear();
                this.pilaRegistrosQueNoSePuedenCrearAun = null;
            }
            this.setListaTablasParaRegRegistro(new ArrayList<String>());
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected reglasValidacionComun getInstanciaReglasValidacionComun() throws ExceptionMotor {
        if (this.instanciaReglasValidacionComun == null) {
            this.instanciaReglasValidacionComun = new reglasValidacionComun();
            this.instanciaReglasValidacionComun.init(this.parametrosConstructor);
        }
        return this.instanciaReglasValidacionComun;
    }

    @Override
    public String formateaValor(String partida, String tipoDato, String valor, Map<String, String> propiedades, String tDato) throws ExceptionMotor {
        try {
            if (propiedades.containsKey("TIPODATOREAL")) {
                tipoDato = propiedades.get("TIPODATOREAL");
            }
            if (tipoDato.equalsIgnoreCase("1_a_true")) {
                if (valor.equalsIgnoreCase("1")) {
                    return "true";
                }
                if (valor.equalsIgnoreCase("0")) {
                    return "false";
                }
                throw new ExceptionMotor("Valor (" + valor + ") no valido para tipo '" + "1_a_true" + "'");
            }
            return super.formateaValor(partida, tipoDato, valor, propiedades, tDato);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected String formateaValorBigDecimal(String valor, Map<String, String> propiedades) throws ExceptionMotor {
        try {
            String res;
            block23: {
                block24: {
                    String tipoDato;
                    block22: {
                        res = valor;
                        tipoDato = "";
                        try {
                            tipoDato = this.getGestor().traduceCadena(propiedades.get("TIPODATO").toString());
                        }
                        catch (Exception ex) {
                            return res;
                        }
                        if (tipoDato.toUpperCase().indexOf("Valores") == 0) {
                            String[] p = StringUtility.getStringUtility().split(tipoDato, ":");
                            for (int i = 0; i < p.length; ++i) {
                                String[] q = StringUtility.getStringUtility().split(p[i], "=");
                                if (q.length != 2 || !valor.equalsIgnoreCase(FuncionesUtiles.getFuncionesUtiles().desCodificaCadena(q[0]))) continue;
                                res = FuncionesUtiles.getFuncionesUtiles().desCodificaCadena(q[1]);
                                break;
                            }
                        } else if (tipoDato.toUpperCase().indexOf("CTE:") == 0) {
                            res = FuncionesUtiles.getFuncionesUtiles().desCodificaCadena(tipoDato.substring("CTE:".length()));
                        } else if (tipoDato.toUpperCase().indexOf("FUNCION") == 0) {
                            res = this.ejecutaMetodoDeClase(tipoDato.substring(8).split(","), valor);
                        }
                        if (res.compareTo(valor) != 0) {
                            return res;
                        }
                        tipoDato = "";
                        try {
                            tipoDato = this.getGestor().traduceCadena(propiedades.get("TIPODATO").toString());
                        }
                        catch (Exception ex) {
                            return res;
                        }
                        if (tipoDato.equalsIgnoreCase("Num")) {
                            return this.formateoADecimalesBigDecimal(valor, propiedades.get("DECIMALES"));
                        }
                        if (!tipoDato.equalsIgnoreCase("NumSigno")) break block22;
                        res = this.formateoADecimalesBigDecimal(valor.substring(1), propiedades.get("DECIMALES"));
                        if (valor.charAt(0) == 'N') {
                            res = "-" + res;
                        }
                        break block23;
                    }
                    if (!tipoDato.equalsIgnoreCase("FechaInvertida")) break block24;
                    switch (res.length()) {
                        case 6: {
                            res = res.substring(4, 6) + res.substring(2, 4) + res.substring(0, 2);
                            break block23;
                        }
                        case 8: {
                            res = res.substring(4, 8) + res.substring(2, 4) + res.substring(0, 2);
                            break block23;
                        }
                        default: {
                            throw new ExceptionMotor(LITERAL_LONGITUD_ERRONEA);
                        }
                    }
                }
                if (valor.trim().length() == 0) {
                    return "";
                }
                res = StringUtility.getStringUtility().rTrim(res);
                res = res.replaceAll("'", "\u00b4");
            }
            return res;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected String getNombreTabla(ITipoDatosTabla tdt) throws ExceptionMotor {
        try {
            String nombreTabla = tdt.getNombreTabla();
            if (this.getGestorConfiguracion().getTabla(nombreTabla) == null) {
                nombreTabla = null;
            }
            if (nombreTabla == null && tdt.getPropiedadesTabla().get("TABLABBDD") != null) {
                nombreTabla = tdt.getPropiedadesTabla().get("TABLABBDD").trim().toUpperCase();
            }
            if (nombreTabla == null || this.getGestorConfiguracion().getTabla(nombreTabla) == null) {
                throw new ExceptionMotor("No se a que tabla se refiere trans BOE con nombre " + tdt.getNombreTabla() + " use el nombre o el atributo '" + "TABLABBDD" + "'");
            }
            return nombreTabla;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected String creaTabla(ITipoDatosTabla tdt) throws ExceptionMotor {
        try {
            if (tdt.getPropiedadesTabla().containsKey("NOIMPORTAR")) {
                throw new ExceptionMotor("No se puede crear una tabla con el atributo de no ser importada!!!");
            }
            String nomTabla = this.getNombreTabla(tdt);
            if (this.getTablas().get(nomTabla) != null) {
                return nomTabla;
            }
            this.getTablas().put(nomTabla, new TipoDatosTabla(nomTabla));
            this.getTablas().get(nomTabla).setPropiedadesTabla(tdt.getPropiedadesTabla());
            return nomTabla;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected void guardaCampo(String nomTabla, ITipoDatosCampos campo) throws ExceptionMotor {
        try {
            if (campo.getNombreCampo().trim().length() > 0) {
                if (campo.getPropiedadesCampos().get("TABLA") != null || campo.getPropiedadesCampos().get("MUEVETABLA") != null) {
                    String tabla = campo.getPropiedadesCampos().get("TABLA");
                    if (tabla == null) {
                        tabla = campo.getPropiedadesCampos().get("MUEVETABLA");
                    }
                    tabla = tabla.trim().toUpperCase();
                    if (this.getTablas().get(tabla) == null) {
                        TipoDatosTabla t = new TipoDatosTabla(tabla);
                        t.setPropiedadesTabla(new HashMap<String, String>());
                        t.getPropiedadesTabla().put("TABLABBDD", tabla);
                        this.creaTabla(t);
                    }
                    nomTabla = tabla;
                }
                if (this.getTablas().get(nomTabla).getCampos() == null) {
                    this.getTablas().get(nomTabla).setCampos(new ArrayList<ITipoDatosCampos>());
                }
                this.getTablas().get(nomTabla).getCampos().add(campo);
            } else if (campo.getPropiedadesCampos().containsKey("VALOR")) {
                String[] partidas;
                for (String p : partidas = campo.getPropiedadesCampos().get("VALOR").split(",")) {
                    ITipoDatosCampos clon = campo.clone();
                    clon.setNombreCampo(p);
                    this.guardaCampo(nomTabla, clon);
                }
            }
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected void cargarEstructuras() throws ExceptionMotor {
        try {
            this.setTablas(new HashMap<String, TipoDatosTabla>());
            List<ITipoDatosTabla> listaTablas = this.getGestor().getTablas();
            for (ITipoDatosTabla tdt : listaTablas) {
                if (tdt.getPropiedadesTabla().containsKey("NOIMPORTAR")) continue;
                String nomTabla = this.creaTabla(tdt);
                for (ITipoDatosCampos campo : tdt.getCampos()) {
                    this.guardaCampo(nomTabla, campo);
                }
            }
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean reglasDeValidacion(byte[] ficheroAValidar) throws ExceptionMotor {
        try {
            boolean ret;
            if (this.getGestor() == null) {
                throw new ExceptionMotor("No dispongo de gestor de traducciones, llame primero a establecerGestor");
            }
            this.abrirFichero(ficheroAValidar);
            this.cargarEstructuras();
            boolean bl = ret = this.reglasDeValidacion();
            return bl;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
        finally {
            try {
                this.cerrarFichero();
            }
            catch (ExceptionMotor e) {}
        }
    }

    @Override
    public boolean reglasDeValidacion(String ficheroAValidar) throws ExceptionMotor {
        try {
            return this.reglasDeValidacion(FuncionesUtiles.getFuncionesUtiles().file2bytesISO(ficheroAValidar));
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public void cerrarFichero() throws ExceptionMotor {
        this.getInstanciaReglasValidacionComun().cerrarFichero();
    }

    public void abrirFichero(byte[] bytes) throws ExceptionMotor {
        this.getInstanciaReglasValidacionComun().abrirFichero(bytes);
    }

    public void abrirFichero(String ficheroTXT) throws ExceptionMotor {
        try {
            this.abrirFichero(FuncionesUtiles.getFuncionesUtiles().file2bytesISO(ficheroTXT));
        }
        catch (FileNotFoundException e) {
            throw new ExceptionMotor(e);
        }
        catch (IOException e) {
            throw new ExceptionMotor(e);
        }
    }

    public String lineaSiguiente() throws ExceptionMotor {
        return this.getInstanciaReglasValidacionComun().lineaSiguiente();
    }

    @Override
    protected void recorridoFicheroReglasValidacion() throws ExceptionMotor {
        try {
            String cadena = "";
            List<ITipoDatosCampos> campos = null;
            Map<String, String> propCampos = null;
            List<ITipoDatosTabla> listaTablas = this.getGestor().getTablas();
            List<ITipoDatosTabla> listaTablasAdicionales = this.getGestor().getTablasAuxiliares();
            String cad = "";
            int longitudRegistro = 0;
            String nombreTablaActual = "";
            int i = 0;
            int j = 0;
            while ((cadena = this.lineaSiguiente()) != null) {
                int accesoDirectoTablaAdicional;
                ITipoDatosIdentificarTabla ret;
                if (this.getGestorFichero().isFueCancelado()) {
                    this.getSesion().getOrigenDeDatos().rollBack(true);
                    throw new ExceptionMotor("CORTAR EJECUCION SIN MAS");
                }
                if (cadena.compareTo(this.getInstanciaReglasValidacionComun().getSaltoDeLinea()) == 0 || (ret = this.getInstanciaReglasValidacionComun().identificameTablaDeCadena(cadena, false)) == null) continue;
                cadena = this.eventoCadenaAImportar(cadena);
                i = ret.getIndice();
                nombreTablaActual = listaTablas.get(i).getPropiedadesTabla() != null && listaTablas.get(i).getPropiedadesTabla().containsKey("TABLABBDD") ? listaTablas.get(i).getPropiedadesTabla().get("TABLABBDD") : listaTablas.get(i).getNombreTabla();
                cadena = this.getInstanciaReglasValidacionComun().consumeDeCadena(cadena, ret.getPosicionesAConsumir());
                this.camposTabla = null;
                this.camposTabla = new ArrayList<ITipoDatosCampoValor>();
                campos = listaTablas.get(i).getCampos();
                propCampos = null;
                for (j = 0; j < campos.size(); ++j) {
                    propCampos = campos.get(j).getPropiedadesCampos();
                    if (propCampos != null) {
                        propCampos = (Map<String, String>)((HashMap)propCampos).clone();
                    }
                    if (propCampos != null && propCampos.containsKey("NOEXPORTAR")) {
                        propCampos.put("LONGITUD", "0");
                    }
                    if (cadena.length() == 0 && propCampos.get("EVITARSALTODELINEA") != null) {
                        while (cadena != null && cadena.length() == 0) {
                            cadena = this.lineaSiguiente();
                        }
                    }
                    cad = (longitudRegistro = this.getInstanciaReglasValidacionComun().sacarLongitud(cadena, propCampos.get("LONGITUD"))) == -1 ? cadena : cadena.substring(0, longitudRegistro);
                    cadena = this.getInstanciaReglasValidacionComun().consumeDeCadena(cadena, cad.length());
                    if (this.getGestor().getVariables().containsKey(campos.get(j).getNombreCampo().toUpperCase())) {
                        this.getGestor().getVariables().put(campos.get(j).getNombreCampo().toUpperCase(), cad);
                    }
                    if (propCampos != null && propCampos.containsKey("TIPODATO") && propCampos.get("TIPODATO").trim().toUpperCase().startsWith("LAQTENGAVALOR")) {
                        campos.get(j).setNombreCampo(this.nombrePartidaAImportarCasoLaQueTengaValor(this.camposTabla, propCampos.get("TIPODATO").trim().toUpperCase()));
                        propCampos.put("TIPODATO", propCampos.get("TIPODATOREAL"));
                    }
                    if (campos.get(j).getNombreCampo().length() != 0 && propCampos.get("NOIMPORTAR") == null && propCampos.get("IMPORTARESPECIAL") == null) {
                        this.addCampoATabla(nombreTablaActual, propCampos, campos.get(j).getNombreCampo(), cad, listaTablas.get(i));
                        continue;
                    }
                    if (propCampos.get("IMPORTARESPECIAL") == null) continue;
                    if (!propCampos.get("IMPORTARESPECIAL").equalsIgnoreCase("true")) {
                        this.addCampoATabla(nombreTablaActual, propCampos, "PARTIDA_ESPECIAL_" + propCampos.get("IMPORTARESPECIAL").toString(), cad, listaTablas.get(i));
                        continue;
                    }
                    this.addCampoATabla(nombreTablaActual, propCampos, "PARTIDA_ESPECIAL_" + propCampos.get("TIPODATO").toString(), cad, listaTablas.get(i));
                }
                if (this.getGestorFichero().getRutaDatosAdicionales().length() > 0 && (accesoDirectoTablaAdicional = this.getGestor().getTableAdicionalIndex(listaTablas.get(i).getNombreTabla())) > -1) {
                    cadena = this.getInstanciaReglasValidacionComun().lineaSiguienteAdicional();
                    campos = listaTablasAdicionales.get(accesoDirectoTablaAdicional).getCampos();
                    propCampos = null;
                    for (j = 0; j < campos.size(); ++j) {
                        propCampos = campos.get(j).getPropiedadesCampos();
                        longitudRegistro = this.getInstanciaReglasValidacionComun().sacarLongitud(cadena, propCampos.get("LONGITUD"));
                        cad = longitudRegistro == -1 ? cadena : cadena.substring(0, longitudRegistro);
                        cadena = this.getInstanciaReglasValidacionComun().consumeDeCadena(cadena, cad.length());
                        if (campos.get(j).getNombreCampo().length() == 0 || propCampos.get("NOIMPORTAR") != null) continue;
                        this.addCampoATabla(nombreTablaActual, propCampos, campos.get(j).getNombreCampo(), cad, listaTablas.get(i));
                    }
                }
                this.comprobarFragmentadas(listaTablas, i);
                if (this.cumunRegistroNuevo(listaTablas.get(i), this.camposTabla, null, null, false)) {
                    this.comprobarTablasAnidadas(this.camposTabla);
                }
                this.camposTabla = null;
            }
            this.comprobarFragmentadas(listaTablas, Integer.MAX_VALUE);
        }
        catch (ExceptionMotor e) {
            throw e;
        }
        catch (Exception ee) {
            throw new ExceptionMotor(ee);
        }
    }

    @Override
    public String eventoCadenaAImportar(String cadena) throws ExceptionMotor {
        return cadena;
    }

    protected void comprobarFragmentadas(List<ITipoDatosTabla> listaTablas, int i) throws Exception {
        if (this.getGestorTablasFragmentadas().size() > 0) {
            List<String> nombresTablas = this.getGestorTablasFragmentadas().getNombresTablas();
            for (String tb : nombresTablas) {
                boolean terminarTabla = true;
                for (int k = i; k < listaTablas.size(); ++k) {
                    if (!listaTablas.get(k).getPropiedadesTabla().containsKey("TABLABBDD") || !listaTablas.get(k).getPropiedadesTabla().get("TABLABBDD").equalsIgnoreCase(tb)) continue;
                    terminarTabla = false;
                    break;
                }
                if (!terminarTabla) continue;
                if (this.cumunRegistroNuevo(this.getGestorTablasFragmentadas().getTipoDatosTabla(tb), this.getGestorTablasFragmentadas().getListaCamposTabla(tb), null, null, true)) {
                    this.comprobarTablasAnidadas(this.getGestorTablasFragmentadas().getListaCamposTabla(tb));
                }
                this.getGestorTablasFragmentadas().remove(tb);
            }
        }
    }

    protected String dameLaqueTengaValor(String str1, String str2) throws Exception {
        if (str1 == null) {
            return str2;
        }
        return str1;
    }

    protected void addCampoATabla(String tablaActual, Map<String, String> propCampos, String nombre, String valor, ITipoDatosTabla tablaDondeSeEncuentraParaTrans) throws ExceptionMotor {
        try {
            if (propCampos != null && propCampos.containsKey("TABLA") || propCampos.containsKey("MUEVETABLA")) {
                String tabla = propCampos.get("TABLA");
                String mueveTabla = propCampos.get("MUEVETABLA");
                if (!tablaActual.equalsIgnoreCase(tabla) && !tablaActual.equalsIgnoreCase(mueveTabla)) {
                    String filtro = this.nuloACadena(propCampos.get("FILTRO"));
                    this.addRegistrosQueNoSePuedenCrearAun(((Object)this.camposTabla).hashCode(), this.dameLaqueTengaValor(tabla, mueveTabla), filtro, new TipoDatosCampoValor(nombre, valor), tablaDondeSeEncuentraParaTrans);
                    if (mueveTabla != null) {
                        if (filtro != null && filtro.trim().length() > 0) {
                            String[] filtros = filtro.split(";");
                            TipoDatosRegistroApiladoImportacion tda = this.dameUltimoRegistroQueNoSePuedenCrearAunDeTipo(((Object)this.camposTabla).hashCode(), this.dameLaqueTengaValor(tabla, mueveTabla), filtro);
                            String partida = tda.getCampos().get(0).getNombreCampo();
                            String indice = "";
                            if (partida.endsWith(")")) {
                                indice = partida.substring(partida.indexOf("("));
                            }
                            for (String filter : filtros) {
                                String[] filt = filter.split("=");
                                tda.getCampos().add(new TipoDatosCampoValor("[FILTRO]" + filt[0].trim() + indice, filt[1].trim()));
                            }
                        }
                        this.dameUltimoRegistroQueNoSePuedenCrearAunDeTipo(((Object)this.camposTabla).hashCode(), this.dameLaqueTengaValor(tabla, mueveTabla), filtro).setTablaCompletada(true);
                    }
                    return;
                }
            }
            this.camposTabla.add(new TipoDatosCampoValor(nombre, valor, this.getLineaFichero()));
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    protected boolean esValorPorDefecto(String valor, IRegEntrada ent) {
        String valorInicial = ent.getValorInicial();
        try {
            return Double.parseDouble(valor) == Double.parseDouble(valorInicial);
        }
        catch (Exception ex) {
            return valor.trim().equalsIgnoreCase(valorInicial.trim());
        }
    }

    protected boolean parteComunPartidaModificadaOEstablecerPartida(String campo, String valor) {
        String campoSinParentesis = FuncionesUtiles.getFuncionesUtiles().dameNombrePartidaSinParentesis(campo);
        try {
            String muevetabla = "";
            String tabla = "";
            try {
                muevetabla = this.getGestor().getCampo(campo).get("MUEVETABLA").toString();
            }
            catch (Exception ex) {
                muevetabla = "";
            }
            try {
                tabla = this.getGestor().getCampo(campo).get("TABLA").toString();
            }
            catch (Exception ex) {
                tabla = "";
            }
            if (tabla.length() > 0 && !this.getTablaEnCurso().equalsIgnoreCase(tabla)) {
                if (this.esValorPorDefecto(valor, this.getGestorConfiguracion().getEntrada(campoSinParentesis))) {
                    return false;
                }
                if (this.getGestor().getCampo(campo).get("ACCION") == null) {
                    this.getSesion().getOperaciones().anniadirRegistro(tabla);
                }
                this.setTablaEnCurso(tabla);
            }
            if (muevetabla.length() > 0) {
                if (!this.getTablaEnCurso().equalsIgnoreCase(muevetabla)) {
                    if (this.esValorPorDefecto(valor, this.getGestorConfiguracion().getEntrada(campoSinParentesis))) {
                        return false;
                    }
                } else {
                    this.setTablaEnCurso("");
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return true;
    }

    @Override
    protected boolean partidaModificada(String campo, String valor) throws ExceptionMotor {
        if (!this.parteComunPartidaModificadaOEstablecerPartida(campo, valor)) {
            return true;
        }
        return this.getSesion().getGestionReglas().partidaModificada(campo, valor);
    }

    @Override
    protected boolean establecerPartida(String campo, String valor) throws ExceptionMotor {
        if (!this.parteComunPartidaModificadaOEstablecerPartida(campo, valor)) {
            return true;
        }
        return this.getSesion().getOperaciones().establecerPartida(campo, valor);
    }

    protected void setTablaEnCurso(String tablaEnCurso) {
        this.tablaEnCurso = tablaEnCurso;
    }

    protected String getTablaEnCurso() {
        return this.tablaEnCurso;
    }

    @Override
    protected String getLineaFichero() throws ExceptionMotor {
        return this.getInstanciaReglasValidacionComun().getLineaFichero();
    }

    @Override
    protected void setLineaFichero(String linea) {
    }

    @Override
    public int getNumRegistros(String ficheroAValidar) throws ExceptionMotor {
        try {
            return this.getNumRegistros(FuncionesUtiles.getFuncionesUtiles().file2bytesISO(ficheroAValidar));
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public int getNumRegistros(byte[] ficheroAValidar) throws ExceptionMotor {
        return this.getInstanciaReglasValidacionComun().getNumRegistros(ficheroAValidar);
    }

    public Map<Integer, List<TipoDatosRegistroApiladoImportacion>> getPilaRegistrosQueNoSePuedenCrearAun() throws ExceptionMotor {
        try {
            if (this.pilaRegistrosQueNoSePuedenCrearAun == null) {
                this.pilaRegistrosQueNoSePuedenCrearAun = new HashMap<Integer, List<TipoDatosRegistroApiladoImportacion>>();
            }
            return this.pilaRegistrosQueNoSePuedenCrearAun;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public boolean hasRegistrosQueNoSePuedenCrearAun(int hashTabla) throws ExceptionMotor {
        return this.getPilaRegistrosQueNoSePuedenCrearAun().containsKey(hashTabla);
    }

    public void addRegistrosQueNoSePuedenCrearAun(int hashTabla, String nombreTabla, String filtro, ITipoDatosCampoValor campo, ITipoDatosTabla tablaDondeSeEncuentraParaTrans) throws ExceptionMotor {
        try {
            TipoDatosRegistroApiladoImportacion tda = this.dameUltimoRegistroQueNoSePuedenCrearAunDeTipo(hashTabla, nombreTabla, filtro);
            if (tda == null) {
                if (!this.hasRegistrosQueNoSePuedenCrearAun(hashTabla)) {
                    ArrayList listaTda = new ArrayList();
                    this.getPilaRegistrosQueNoSePuedenCrearAun().put(hashTabla, listaTda);
                }
                tda = new TipoDatosRegistroApiladoImportacion(filtro, nombreTabla, tablaDondeSeEncuentraParaTrans);
                this.getPilaRegistrosQueNoSePuedenCrearAun().get(hashTabla).add(tda);
            }
            tda.getCampos().add(campo);
        }
        catch (ExceptionMotor e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    protected String nuloACadena(String cadena) {
        if (cadena == null) {
            return "";
        }
        return cadena;
    }

    public TipoDatosRegistroApiladoImportacion dameUltimoRegistroQueNoSePuedenCrearAunDeTipo(int hashTabla, String nombreTabla, String filtro) throws ExceptionMotor {
        try {
            if (!this.hasRegistrosQueNoSePuedenCrearAun(hashTabla)) {
                return null;
            }
            List<TipoDatosRegistroApiladoImportacion> todas = this.getPilaRegistrosQueNoSePuedenCrearAun().get(hashTabla);
            if (todas != null && todas.size() > 0) {
                for (int i = todas.size() - 1; i > -1; --i) {
                    if (!todas.get(i).getTabla().getNombreTabla().equalsIgnoreCase(nombreTabla) || !this.nuloACadena(todas.get(i).getFiltro()).equalsIgnoreCase(this.nuloACadena(filtro)) || todas.get(i).isTablaCompletada()) continue;
                    return todas.get(i);
                }
            }
            return null;
        }
        catch (ExceptionMotor e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public List<TipoDatosRegistroApiladoImportacion> dameRegistrosQueNoSePuedenCrearAun(int hashTabla) throws ExceptionMotor {
        try {
            if (!this.hasRegistrosQueNoSePuedenCrearAun(hashTabla)) {
                throw new ExceptionMotor("No hay registros apilados!!!");
            }
            return this.getPilaRegistrosQueNoSePuedenCrearAun().get(hashTabla);
        }
        catch (ExceptionMotor e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public void borraRegistrosQueNoSePuedenCrearAun(int hashTabla) throws ExceptionMotor {
        try {
            if (!this.hasRegistrosQueNoSePuedenCrearAun(hashTabla)) {
                throw new ExceptionMotor("No hay registros apilados!!!");
            }
            this.getPilaRegistrosQueNoSePuedenCrearAun().remove(hashTabla);
        }
        catch (ExceptionMotor e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    protected void comprobarTablasAnidadas(List<ITipoDatosCampoValor> camposTablaAMirar) throws Exception {
        if (this.hasRegistrosQueNoSePuedenCrearAun(((Object)camposTablaAMirar).hashCode())) {
            List<TipoDatosRegistroApiladoImportacion> tablasARecorrer = this.dameRegistrosQueNoSePuedenCrearAun(((Object)camposTablaAMirar).hashCode());
            for (TipoDatosRegistroApiladoImportacion tab : tablasARecorrer) {
                this.cumunRegistroNuevo(tab.getTabla(), tab.getCampos(), null, null, false);
            }
            this.borraRegistrosQueNoSePuedenCrearAun(((Object)camposTablaAMirar).hashCode());
        }
    }

    protected class reglasValidacionComun
    extends CodigoComun {
        private static final long serialVersionUID = 1L;

        protected reglasValidacionComun() {
        }
    }
}

