/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.gestionFicheros.importacionV2;

import es.aeat.pftw.mtrc.formateador.FormateadorCadena;
import es.aeat.pftw.mtrc.formateador.FormateadorNIF;
import es.aeat.pftw.mtrc.formateador.FormateadorRellenarCadenaConCaracterDefinido;
import es.aeat.pftw.mtrc.gestionFicheros.importacionV2.ITransformaciones;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.utilidades.StringUtility;
import es.aeat.pftw.mtrc.utilidades.Validaciones;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import java.io.Serializable;

public final class Transformaciones
implements ITransformaciones,
Serializable {
    private static final long serialVersionUID = 1L;
    private FormateadorCadena formatCad = null;
    private FormateadorRellenarCadenaConCaracterDefinido relleno = null;
    private FormateadorNIF formatNif = null;

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            this.formatCad = new FormateadorCadena();
            this.relleno = new FormateadorRellenarCadenaConCaracterDefinido(' ', 0);
            this.formatNif = new FormateadorNIF();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public String ejecutarTransformacion(String val, String transSolicitada) throws ExceptionMotor {
        String transformacionSolicitada = transSolicitada;
        String valor = val;
        try {
            String coletilla = "";
            String[] param = StringUtility.getStringUtility().split(transformacionSolicitada, ":");
            if (param.length > 1) {
                coletilla = param[0];
                transformacionSolicitada = param[1];
            }
            if (transformacionSolicitada.equalsIgnoreCase("CDATE")) {
                if (valor.trim().length() > 0) {
                    String[] fechaLimpia = valor.split("-");
                    if (coletilla.equalsIgnoreCase("DDMMYYYY")) {
                        valor = fechaLimpia[2].substring(0, 2);
                        valor = valor + fechaLimpia[1];
                        valor = valor + fechaLimpia[0];
                    } else if (coletilla.equalsIgnoreCase("YYYYMMDD")) {
                        valor = fechaLimpia[0];
                        valor = valor + fechaLimpia[1];
                        valor = valor + fechaLimpia[2].substring(0, 2);
                    }
                    return "1:" + valor;
                }
                return valor;
            }
            if (transformacionSolicitada.equalsIgnoreCase("CDATE/")) {
                if (valor.trim().length() > 0 && !valor.equalsIgnoreCase("00000000")) {
                    String[] fechaLimpia = valor.split("/");
                    if (coletilla.equalsIgnoreCase("YYYYMMDD")) {
                        valor = fechaLimpia[2].substring(0, 4);
                        valor = valor + fechaLimpia[1];
                        valor = valor + fechaLimpia[0];
                    }
                    return "1:" + valor;
                }
                return valor;
            }
            if (coletilla.equalsIgnoreCase("SIVACIO") || coletilla.equalsIgnoreCase("SICERO")) {
                coletilla = param[1];
                transformacionSolicitada = param[0];
            }
            if (transformacionSolicitada.equalsIgnoreCase("SIVACIO")) {
                if (valor == null || valor.trim().length() == 0) {
                    return "1:" + coletilla;
                }
                return valor;
            }
            if (transformacionSolicitada.equalsIgnoreCase("SICERO")) {
                if (valor != null && valor.trim().equalsIgnoreCase("0")) {
                    return "1:" + coletilla;
                }
                return valor;
            }
            if (transformacionSolicitada.equalsIgnoreCase("RELLENAIZQUIERDA") || transformacionSolicitada.equalsIgnoreCase("RELLENADERECHA")) {
                String[] par = coletilla.split(",");
                if (par.length != 2) {
                    throw new ExceptionMotor("Los par\u00e1metros de la transformaci\u00f3n " + transformacionSolicitada + " no tiene el formato esperado");
                }
                int longitud = Integer.valueOf(par[1]);
                if (valor.length() >= longitud) {
                    return valor;
                }
                while (valor.length() < longitud) {
                    if (transformacionSolicitada.equalsIgnoreCase("RELLENAIZQUIERDA")) {
                        valor = par[0] + valor;
                        continue;
                    }
                    valor = valor + par[0];
                }
                return "1:" + valor;
            }
            if (transformacionSolicitada.equalsIgnoreCase("MAYUSCULAS")) {
                if (coletilla.length() == 0) {
                    coletilla = "1:";
                }
                return coletilla + valor.toUpperCase();
            }
            if (transformacionSolicitada.equalsIgnoreCase("LONGITUDREGISTRO")) {
                if (coletilla.length() == 0) {
                    coletilla = "1:";
                }
                return coletilla + valor;
            }
            if (transformacionSolicitada.equalsIgnoreCase("AJUSTARNOMBRE")) {
                int longitud = valor.length();
                String tmp = this.formatCad.formatearHaciaMotor(valor).toString();
                if (tmp == null) {
                    return null;
                }
                if ((tmp = this.relleno.formatearHaciaMotor(tmp, ' ', longitud).toString()) == null) {
                    return null;
                }
                if (coletilla.length() == 0) {
                    coletilla = "1:";
                }
                return coletilla + tmp;
            }
            if (transformacionSolicitada.equalsIgnoreCase("AJUSTARNIF")) {
                String tmp = this.formatNif.formatearHaciaMotor(valor).toString();
                if (tmp == null) {
                    return null;
                }
                tmp = tmp.replaceAll(" ", "0");
                if (coletilla.length() == 0) {
                    coletilla = "1:";
                }
                return coletilla + tmp;
            }
            if (transformacionSolicitada.equalsIgnoreCase("ACEROS")) {
                String tmp = FuncionesUtiles.getFuncionesUtiles().rellena("", "0".charAt(0), valor.length());
                if (coletilla.length() == 0) {
                    coletilla = "1:";
                }
                return coletilla + tmp;
            }
            if (transformacionSolicitada.equalsIgnoreCase("ABLANCOS")) {
                String tmp = FuncionesUtiles.getFuncionesUtiles().rellena("", ' ', valor.length());
                if (coletilla.length() == 0) {
                    coletilla = "1:";
                }
                return coletilla + tmp;
            }
            if (transformacionSolicitada.equalsIgnoreCase("MAYUSCULASACENTUADAS")) {
                String anterior = valor;
                char[] caracteres = valor.toCharArray();
                block19: for (int i = 0; i < valor.length(); ++i) {
                    switch (caracteres[i]) {
                        case '\u00e1': {
                            caracteres[i] = 65;
                            continue block19;
                        }
                        case '\u00e9': {
                            caracteres[i] = 69;
                            continue block19;
                        }
                        case '\u00ed': {
                            caracteres[i] = 73;
                            continue block19;
                        }
                        case '\u00f3': {
                            caracteres[i] = 79;
                            continue block19;
                        }
                        case '\u00fa': {
                            caracteres[i] = 85;
                            continue block19;
                        }
                        case '\u00fc': {
                            caracteres[i] = 85;
                            continue block19;
                        }
                        case '\u00c1': {
                            caracteres[i] = 65;
                            continue block19;
                        }
                        case '\u00c9': {
                            caracteres[i] = 69;
                            continue block19;
                        }
                        case '\u00cd': {
                            caracteres[i] = 73;
                            continue block19;
                        }
                        case '\u00d3': {
                            caracteres[i] = 79;
                            continue block19;
                        }
                        case '\u00da': {
                            caracteres[i] = 85;
                            continue block19;
                        }
                        case '\u00dc': {
                            caracteres[i] = 85;
                            continue block19;
                        }
                        case '\u00b4': {
                            caracteres[i] = 39;
                            continue block19;
                        }
                    }
                }
                valor = String.valueOf(caracteres);
                if (anterior.equals(valor)) {
                    return "0:" + valor;
                }
                return "1:" + valor;
            }
            if (transformacionSolicitada.equalsIgnoreCase("CARACTERESNOALFANUM")) {
                int tam = valor.length();
                for (int i = 0; i < tam; ++i) {
                    char tmp = valor.charAt(i);
                    if (Validaciones.getValidaciones().esAlfanumericaAEAT(tmp)) continue;
                    valor = valor.replace(tmp, ' ');
                }
                return "1:" + valor;
            }
            if (transformacionSolicitada.equalsIgnoreCase("CARACTERESNOALFABETICOS")) {
                int tam = valor.length();
                for (int i = 0; i < tam; ++i) {
                    char tmp = valor.charAt(i);
                    if (Validaciones.getValidaciones().esAlfabeticoAEAT(tmp)) continue;
                    valor = valor.replace(tmp, ' ');
                }
                return "1:" + valor;
            }
            if (transformacionSolicitada.equalsIgnoreCase("CTE:")) {
                valor = coletilla;
                return "1:" + valor;
            }
            throw new ExceptionMotor("Funci\u00f3n " + transformacionSolicitada + " no esperada");
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Valor " + val + " Transformacion " + transSolicitada);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Valor " + val + " Transformacion " + transSolicitada);
        }
    }

    @Override
    public void dispose() throws ExceptionMotor {
        this.formatCad = null;
        this.relleno = null;
        this.formatNif = null;
    }
}

