/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.gestionFicheros.importacionV2;

import es.aeat.pftw.mtrc.IAop;
import es.aeat.pftw.mtrc.tipos.ITipoDatosTabla;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampoValor;
import java.util.ArrayList;
import java.util.List;

public class GestorTablasFragmentadas
implements IAop {
    private static final long serialVersionUID = 1L;
    private List<String> nombresTablas = new ArrayList<String>();
    private List<ITipoDatosTabla> tablasTrans = new ArrayList<ITipoDatosTabla>();
    private List<List<ITipoDatosCampoValor>> camposTabla = new ArrayList<List<ITipoDatosCampoValor>>();

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
    }

    @Override
    public void dispose() throws ExceptionMotor {
        this.nombresTablas.clear();
        this.tablasTrans.clear();
        this.camposTabla.clear();
        this.nombresTablas = null;
        this.tablasTrans = null;
        this.camposTabla = null;
    }

    public boolean containsTabla(String tabla) throws ExceptionMotor {
        return this.nombresTablas.contains(tabla.toUpperCase());
    }

    public ITipoDatosTabla getTipoDatosTabla(String tabla) throws ExceptionMotor {
        try {
            int pos = this.nombresTablas.indexOf(tabla.toUpperCase());
            if (pos > -1) {
                return this.tablasTrans.get(pos);
            }
            throw new ExceptionMotor("No existe la tabla " + tabla);
        }
        catch (ExceptionMotor e) {
            throw e;
        }
        catch (Exception ee) {
            throw new ExceptionMotor(ee);
        }
    }

    public List<ITipoDatosCampoValor> getListaCamposTabla(String tabla) throws ExceptionMotor {
        try {
            int pos = this.nombresTablas.indexOf(tabla.toUpperCase());
            if (pos > -1) {
                return this.camposTabla.get(pos);
            }
            throw new ExceptionMotor("No existe la tabla " + tabla);
        }
        catch (ExceptionMotor e) {
            throw e;
        }
        catch (Exception ee) {
            throw new ExceptionMotor(ee);
        }
    }

    public void add(String tabla, ITipoDatosTabla tablaTrans) throws ExceptionMotor {
        try {
            int pos = this.nombresTablas.indexOf(tabla.toUpperCase());
            if (pos > -1) {
                throw new ExceptionMotor("Ya existe la tabla " + tabla);
            }
            this.nombresTablas.add(tabla.toUpperCase());
            this.tablasTrans.add(tablaTrans);
            this.camposTabla.add(new ArrayList());
        }
        catch (ExceptionMotor e) {
            throw e;
        }
        catch (Exception ee) {
            throw new ExceptionMotor(ee);
        }
    }

    public void append(String tabla, List<ITipoDatosCampoValor> camposAAgregar) throws ExceptionMotor {
        try {
            int pos = this.nombresTablas.indexOf(tabla.toUpperCase());
            if (pos == -1) {
                throw new ExceptionMotor("No existe la tabla " + tabla);
            }
            for (ITipoDatosCampoValor iTipoDatosCampoValor : camposAAgregar) {
                this.camposTabla.get(pos).add(iTipoDatosCampoValor);
            }
        }
        catch (ExceptionMotor e) {
            throw e;
        }
        catch (Exception ee) {
            throw new ExceptionMotor(ee);
        }
    }

    public void remove(String tabla) throws ExceptionMotor {
        try {
            int pos = this.nombresTablas.indexOf(tabla.toUpperCase());
            if (pos == -1) {
                throw new ExceptionMotor("No existe la tabla " + tabla);
            }
            this.nombresTablas.remove(pos);
            this.tablasTrans.remove(pos);
            this.camposTabla.remove(pos);
        }
        catch (ExceptionMotor e) {
            throw e;
        }
        catch (Exception ee) {
            throw new ExceptionMotor(ee);
        }
    }

    public List<String> getNombresTablas() {
        return this.nombresTablas;
    }

    public int size() {
        return this.nombresTablas.size();
    }
}

