/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.gestionFicheros.importacionV2;

import es.aeat.pftw.mtrc.configuracion.IGestorConfiguracion;
import es.aeat.pftw.mtrc.configuracion.RegError;
import es.aeat.pftw.mtrc.gestionFicheros.exportacion.boe.IExportacionBOE;
import es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.IGestorTraducciones;
import es.aeat.pftw.mtrc.gestionFicheros.importacionV2.Comun;
import es.aeat.pftw.mtrc.gestionFicheros.importacionV2.GestorTablasFragmentadas;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesionExtendida;
import es.aeat.pftw.mtrc.motor.modelo.sesion.tools.IGestionOperacionesExtendida;
import es.aeat.pftw.mtrc.motor.modelo.sesion.tools.IGestionReglasExtendida;
import es.aeat.pftw.mtrc.origenDatos.IOrigenDatos;
import es.aeat.pftw.mtrc.tipos.ITipoDatosAnotacionBitacora;
import es.aeat.pftw.mtrc.tipos.ITipoDatosReglasTipoYPartidas;
import es.aeat.pftw.mtrc.tipos.ITipoDatosTabla;
import es.aeat.pftw.mtrc.tipos.TipoDatoRetornoRegistroNuevo;
import es.aeat.pftw.mtrc.tipos.TipoDatosCampoValor;
import es.aeat.pftw.mtrc.tipos.TipoDatosCampoValorEx;
import es.aeat.pftw.mtrc.tipos.TipoDatosTabla;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.utilidades.StringUtility;
import es.aeat.pftw.mtrp.configuracion.IRegEntrada;
import es.aeat.pftw.mtrp.configuracion.IRegError;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.puente.ITablaMotorEntrada;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampoValor;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampoValorEx;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampos;
import es.aeat.pftw.mtrp.utilidades.INodoArbol;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ComunReglasValidacion
extends Comun {
    private static final long serialVersionUID = 1L;
    protected static final String LITERAL_LONGITUD_ERRONEA = "Longitud de dato para FechaInvertida no es ni 4 ni 8";
    private Map<String, List<Long>> conjuntoDeRegistrosAgregados = null;
    private List<ITipoDatosReglasTipoYPartidas> reglasRegistro = null;
    private List<String> cacheReglasRegistro = null;
    private String cacheNombreUltimaReglaRegistro = "";
    private INodoArbol arbolDelMotor = null;
    private Map<String, List<String>> listaCamposTablaRegistrosAgregar = null;
    private Map<String, String> listaTablasConReglasRegistroAlInsert = null;
    private List<String> listaTablasParaRegRegistro = null;
    private int estadoAnteriorMotor = 0;
    private int tiposReglaDispararAnterior = 0;
    private String discriminanteAnterior = "";
    private List<String> tablasFlush = null;
    private Map<String, List<String>> inicializaciones = null;
    private INodoArbol nodoTemporal = null;
    private IOrigenDatos origenDatos = null;
    private IGestorConfiguracion gestorConfiguracion = null;
    private transient ISesion sesion = null;
    private Map<String, List<ITipoDatosCampoValor>> pendientesParaRegRegistro = null;
    private Map<String, List<ITipoDatosCampoValorEx>> pendientesEstimarPorCambioEnReglas = null;
    protected transient GestorTablasFragmentadas gestorTablasFragmentadas = null;
    private Map<String, TipoDatosTabla> tablas = null;
    private Map<String, List<Object>> cacheClasesParaFunciones = null;

    @Override
    public void dispose() throws ExceptionMotor {
        super.dispose();
        this.conjuntoDeRegistrosAgregados = null;
        this.reglasRegistro = null;
        this.cacheReglasRegistro = null;
        this.arbolDelMotor = null;
        this.listaCamposTablaRegistrosAgregar = null;
        this.listaTablasConReglasRegistroAlInsert = null;
        this.listaTablasParaRegRegistro = null;
        this.tablasFlush = null;
        this.inicializaciones = null;
        this.nodoTemporal = null;
        this.origenDatos = null;
        this.gestorConfiguracion = null;
        this.sesion = null;
        this.pendientesParaRegRegistro = null;
        this.pendientesEstimarPorCambioEnReglas = null;
        this.setTablas(null);
        this.resetObjetos();
        this.gestorTablasFragmentadas = null;
        this.cacheNombreUltimaReglaRegistro = "";
    }

    public void resetObjetos() throws ExceptionMotor {
        try {
            this.pendientesParaRegRegistro = null;
            this.pendientesEstimarPorCambioEnReglas = null;
            if (this.gestorTablasFragmentadas != null) {
                this.gestorTablasFragmentadas.dispose();
                this.gestorTablasFragmentadas = null;
            }
            if (this.getGestorFichero() != null) {
                this.getGestorFichero().errClear();
            }
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            for (Object object : parametros) {
                if (!(object instanceof ISesion)) continue;
                this.sesion = (ISesion)object;
            }
            if (this.getSesion() == null) {
                throw new Exception("Falta por pasar la sesion al init!!!!");
            }
            super.init(parametros);
            this.origenDatos = this.getSesion().getOrigenDeDatos();
            this.gestorConfiguracion = this.getSesion().getModelo().getGestorConfiguracion();
            this.setArbolDelMotor(this.getSesion().getOperaciones().getArbolDatos());
            this.getGestorFichero().errClear();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected abstract String getLineaFichero() throws ExceptionMotor;

    protected abstract void setLineaFichero(String var1);

    public void borrarlistaTablasConReglasRegistroAlInsert() throws ExceptionMotor {
        try {
            this.getListaTablasConReglasRegistroAlInsert().clear();
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    public void borrarlistaTablasConReglasRegistroAlInsert(String nombreTabla) throws ExceptionMotor {
        try {
            if (this.getListaTablasConReglasRegistroAlInsert().remove(nombreTabla.toUpperCase()) == null) {
                throw new Exception("no se encuentra la tabla....");
            }
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e, "Tabla " + nombreTabla);
        }
    }

    public void establecerlistaTablasConReglasRegistroAlInsert(String nombreTabla) throws ExceptionMotor {
        try {
            this.getListaTablasConReglasRegistroAlInsert().put(nombreTabla.toUpperCase(), "");
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    public void borrarCamposDeTablaConPosibilidadDeAgregar() throws ExceptionMotor {
        this.getListaCamposTablaRegistrosAgregar().clear();
    }

    public boolean borrarCamposDeTablaConPosibilidadDeAgregar(String nombreTabla) {
        return this.getListaCamposTablaRegistrosAgregar().remove(nombreTabla.toUpperCase()) != null;
    }

    public void establecerCamposDeTablaConPosibilidadDeAgregar(String nombreTabla, List<String> camposComparacion) throws ExceptionMotor {
        try {
            ArrayList<String> a = new ArrayList<String>();
            for (int i = 0; i < camposComparacion.size(); ++i) {
                a.add(camposComparacion.get(i).toString().toUpperCase());
            }
            this.getListaCamposTablaRegistrosAgregar().put(nombreTabla.toUpperCase(), a);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    public Map<String, List<Long>> getRegistrosAgregados() {
        return this.getConjuntoDeRegistrosAgregados();
    }

    protected void revisarSiQuedanPartidasPendientesPorSaltar(String nombreTabla) throws ExceptionMotor {
        try {
            if (this.getPendientesParaRegRegistro().containsKey(nombreTabla)) {
                this.setLineaFichero(this.getPendientesParaRegRegistro().get(nombreTabla).get(0).getExtra());
                this.hacerSaltarLasReglasAlAnniadirRegistroNuevo(nombreTabla, this.getTablas().get(nombreTabla), null, this.getPendientesParaRegRegistro().get(nombreTabla), true);
                String localizacionActual = this.getSesion().getOperaciones().getLocalizacionEx(nombreTabla);
                for (ITipoDatosCampoValor campo : this.getPendientesParaRegRegistro().get(nombreTabla)) {
                    if (!this.getPendientesEstimarPorCambioEnReglas().containsKey(nombreTabla)) {
                        this.getPendientesEstimarPorCambioEnReglas().put(nombreTabla, new ArrayList());
                    }
                    ITipoDatosCampoValorEx reg = null;
                    List<ITipoDatosCampoValorEx> regs = this.getPendientesEstimarPorCambioEnReglas().get(nombreTabla);
                    int indReg = TipoDatosCampoValorEx.indiceListaContieneCampo(regs, localizacionActual);
                    reg = indReg == -1 ? new TipoDatosCampoValorEx(localizacionActual, new ArrayList()) : regs.get(indReg);
                    List listadoCampos = (List)reg.getValor();
                    int ind = TipoDatosCampoValor.indiceListaContieneCampo(listadoCampos, campo.getNombreCampo());
                    if (ind > -1) {
                        ((ITipoDatosCampoValor)listadoCampos.get(ind)).setValor(campo.getValor());
                        continue;
                    }
                    listadoCampos.add(new TipoDatosCampoValor(campo.getNombreCampo(), campo.getValor(), this.getLineaFichero()));
                }
                this.getPendientesParaRegRegistro().remove(nombreTabla);
                this.compruebaWarningsCambiosPorReglas();
            }
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected Map<String, String> getPropiedadesCampo(String tabla, String campo) throws ExceptionMotor {
        try {
            List<ITipoDatosCampos> campos = this.getTablas().get(tabla.toUpperCase()).getCampos();
            for (ITipoDatosCampos c : campos) {
                if (!c.getNombreCampo().equalsIgnoreCase(campo)) continue;
                return c.getPropiedadesCampos();
            }
            return null;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected void examinarPorCambioReglas(String nombreCampo, String valor, int lineaEnFichero, Map<String, String> propCampos) throws ExceptionMotor {
        try {
            if (!this.isPermitirTransformaciones()) {
                return;
            }
            IRegEntrada re = this.getGestorConfiguracion().getEntrada(nombreCampo);
            if (re == null) {
                throw new ExceptionMotor("No encuentro Entrada : " + nombreCampo);
            }
            String tipoDato = re.getTipoDato();
            valor = this.formateaValor(nombreCampo, valor, propCampos, tipoDato);
            String valorMotor = this.getSesion().getOperaciones().obtenerPartidaString(FuncionesUtiles.getFuncionesUtiles().dameNombrePartidaSinParentesis(nombreCampo));
            if (!FuncionesUtiles.getFuncionesUtiles().sonIguales(re.esTipoNumerico(), valor, valorMotor)) {
                RegError wnr = new RegError();
                if (propCampos.get("ERRORVC") == null) {
                    propCampos.put("ERRORVC", "ACTVAL");
                }
                wnr.setIdError(propCampos.get("ERRORVC") + "2");
                wnr.setPropiedad("CLASE_ORIGEN_ERROR", "VALIDACIONEXTRA");
                wnr.setCampoError(nombreCampo);
                if (propCampos.get("NOMBRE") != null) {
                    wnr.setMsg(propCampos.get("NOMBRE"));
                }
                this.getGestorFichero().addWarning(String.valueOf(lineaEnFichero), wnr, propCampos);
            }
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected boolean hacerSaltaReglasDeRegistro(String nombreTabla) throws ExceptionMotor {
        try {
            return this.hacerSaltaReglasDeRegistroDifferedWrite(nombreTabla);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected void colocarMotorEnLocalizacion(String localizacion) throws ExceptionMotor {
        try {
            String[] tablas = localizacion.split("-");
            String[] pos = null;
            for (int i = 0; i < tablas.length; ++i) {
                pos = tablas[i].split(":");
                this.getSesion().getOperaciones().move(pos[0], Long.valueOf(pos[1]));
            }
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected boolean hacerSaltaReglasDeRegistroDifferedWrite(String nombreTabla) throws ExceptionMotor {
        int tipoReglaBusquedaAnterior = ((IGestionReglasExtendida)this.getSesion().getGestionReglas()).getTipoReglaBusqueda();
        try {
            int rrI = 0;
            int reI = 0;
            if (this.getReglasRegistro() != null) {
                if (!this.getCacheNombreUltimaReglaRegistro().equalsIgnoreCase(nombreTabla)) {
                    this.setCacheNombreUltimaReglaRegistro(nombreTabla);
                    this.setCacheReglasRegistro(null);
                    this.setCacheReglasRegistro(new ArrayList<String>());
                    for (rrI = 0; rrI < this.getReglasRegistro().size(); ++rrI) {
                        if (!this.getReglasRegistro().get(rrI).getNombreRegistro().equalsIgnoreCase(nombreTabla)) continue;
                        this.setCacheReglasRegistro(this.getReglasRegistro().get(rrI).getPartidas());
                        break;
                    }
                }
                for (reI = 0; reI < this.getCacheReglasRegistro().size(); ++reI) {
                    for (int j = 0; j < 2; ++j) {
                        if (j == 0) {
                            ((IGestionReglasExtendida)this.getSesion().getGestionReglas()).setTipoReglaBusqueda(8);
                        } else {
                            ((IGestionReglasExtendida)this.getSesion().getGestionReglas()).setTipoReglaBusqueda(3);
                        }
                        this.getSesion().getGestionReglas().chequear(this.getCacheReglasRegistro().get(reI).toString(), false);
                        if (this.capturaErroresMotor(this.getSesion().getGestionReglas().getListaErroresEnReglas(), "Regla de Registro", j == 0, true, null)) continue;
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            this.revisarSiQuedanPartidasPendientesPorSaltar(nombreTabla);
            if (this.getPendientesEstimarPorCambioEnReglas().containsKey(nombreTabla)) {
                int linea = 0;
                this.getSesion().freezeSesionSoloPosicion("reglasValidacion" + this.toString());
                try {
                    for (int i = 0; i < this.getPendientesEstimarPorCambioEnReglas().get(nombreTabla).size(); ++i) {
                        this.colocarMotorEnLocalizacion(this.getPendientesEstimarPorCambioEnReglas().get(nombreTabla).get(i).getNombreCampo());
                        for (ITipoDatosCampoValor partida : (List)this.getPendientesEstimarPorCambioEnReglas().get(nombreTabla).get(i).getValor()) {
                            if (linea == 0 && FuncionesUtiles.getFuncionesUtiles().esNumerico(partida.getExtra())) {
                                linea = Integer.valueOf(partida.getExtra());
                            }
                            this.examinarPorCambioReglas(partida.getNombreCampo(), partida.getValor(), linea, this.getPropiedadesCampo(nombreTabla, partida.getNombreCampo()));
                        }
                    }
                    this.getPendientesEstimarPorCambioEnReglas().remove(nombreTabla);
                }
                catch (Exception ex) {
                    throw ex;
                }
                finally {
                    this.getSesion().unfreeze("reglasValidacion" + this.toString());
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
        finally {
            ((IGestionReglasExtendida)this.getSesion().getGestionReglas()).setTipoReglaBusqueda(tipoReglaBusquedaAnterior);
        }
    }

    protected void borraUltimaReglaDeRegistroPendiente() throws ExceptionMotor {
        try {
            this.getListaTablasParaRegRegistro().remove(this.getListaTablasParaRegRegistro().size() - 1);
            this.getListaTablasParaRegRegistro().remove(this.getListaTablasParaRegRegistro().size() - 1);
            this.getListaTablasParaRegRegistro().remove(this.getListaTablasParaRegRegistro().size() - 1);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected void vaciarPilaReglasRegistro(String hastaTabla) throws ExceptionMotor {
        try {
            boolean parar = false;
            if (this.getListaTablasParaRegRegistro() != null) {
                while (this.getListaTablasParaRegRegistro().size() > 0) {
                    if (hastaTabla.length() > 0 && hastaTabla.equalsIgnoreCase(this.getListaTablasParaRegRegistro().get(this.getListaTablasParaRegRegistro().size() - 3).toString())) {
                        parar = true;
                    }
                    if (this.getListaTablasParaRegRegistro().get(this.getListaTablasParaRegRegistro().size() - 2).toString().equalsIgnoreCase("1") && !this.hacerSaltaReglasDeRegistro(this.getListaTablasParaRegRegistro().get(this.getListaTablasParaRegRegistro().size() - 3).toString())) {
                        throw new ExceptionMotor("error...");
                    }
                    if (parar) {
                        return;
                    }
                    this.borraUltimaReglaDeRegistroPendiente();
                }
            }
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " HashTabla " + hastaTabla);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "HastaTabla " + hastaTabla);
        }
    }

    protected void vaciarPilaReglasRegistro() throws ExceptionMotor {
        this.vaciarPilaReglasRegistro("");
    }

    protected boolean estimarSiSeHacenSaltarReglasDeRegistro(String nombreTablaActual, String lineaFichero) throws ExceptionMotor {
        try {
            if (this.getListaTablasParaRegRegistro().size() == 0) {
                this.getListaTablasParaRegRegistro().add(nombreTablaActual);
                this.getListaTablasParaRegRegistro().add("1");
                this.getListaTablasParaRegRegistro().add(String.valueOf(lineaFichero));
            } else if (this.getListaTablasParaRegRegistro().get(this.getListaTablasParaRegRegistro().size() - 3).toString().equalsIgnoreCase(nombreTablaActual)) {
                if (this.getListaTablasParaRegRegistro().get(this.getListaTablasParaRegRegistro().size() - 2).toString().equalsIgnoreCase("1") && !this.hacerSaltaReglasDeRegistro(nombreTablaActual)) {
                    return false;
                }
                this.getListaTablasParaRegRegistro().set(this.getListaTablasParaRegRegistro().size() - 2, "1");
                this.getListaTablasParaRegRegistro().set(this.getListaTablasParaRegRegistro().size() - 1, String.valueOf(lineaFichero));
            } else {
                this.setNodoTemporal(this.getArbolDelMotor().buscaHijo(this.getListaTablasParaRegRegistro().get(this.getListaTablasParaRegRegistro().size() - 3).toString()));
                if (this.getNodoTemporal().getParent().getNombreNodo().equalsIgnoreCase(nombreTablaActual)) {
                    this.vaciarPilaReglasRegistro(nombreTablaActual);
                    this.getListaTablasParaRegRegistro().set(this.getListaTablasParaRegRegistro().size() - 2, "1");
                    this.getListaTablasParaRegRegistro().set(this.getListaTablasParaRegRegistro().size() - 1, String.valueOf(lineaFichero));
                } else {
                    this.getListaTablasParaRegRegistro().add(nombreTablaActual);
                    this.getListaTablasParaRegRegistro().add("1");
                    this.getListaTablasParaRegRegistro().add(String.valueOf(lineaFichero));
                }
            }
            return true;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Tabla " + nombreTablaActual + " linea " + lineaFichero);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor("Tabla " + nombreTablaActual + " linea " + lineaFichero);
        }
    }

    public boolean reglasDeValidacion() throws ExceptionMotor {
        int estadoAnteriorMotor = this.getSesion().getOrigenDeDatos().getDifferedWrite();
        boolean cacheOrigenDatosAnterior = this.sesion.getOrigenDeDatos().isCacheHabilitada();
        this.sesion.getOrigenDeDatos().setCacheHabilitada(true);
        this.resetObjetos();
        ((ISesionExtendida)this.sesion).setRegistrosA\u00f1adidosPorReglasAlImportar(new HashMap<String, String>());
        this.setTiposReglaDispararAnterior(((IGestionReglasExtendida)this.getSesion().getGestionReglas()).getTipoReglaBusqueda());
        this.setDiscriminanteAnterior(this.getSesion().getGestionReglas().getDiscriminante());
        try {
            this.getGestorFichero().setFueCancelado(false);
            this.setSuperoNumeroMaximoErrores(false);
            this.getGestorFichero().errClear();
            this.setCorrecto(true);
            if (this.getGestor() == null) {
                throw new ExceptionMotor("No dispongo de gestor de traducciones, llame primero a establecerGestor");
            }
            this.setListaTablasParaRegRegistro(null);
            this.setListaTablasParaRegRegistro(new ArrayList<String>());
            this.setInicializaciones(this.getGestor().getCamposInicializacionTablas());
            if (this.getInicializaciones() == null) {
                this.setInicializaciones(new HashMap<String, List<String>>());
            }
            this.setTablasFlush(new ArrayList<String>());
            this.setReglasRegistro(this.getGestor().getReglasRegistro());
            this.setConjuntoDeRegistrosAgregados(new HashMap<String, List<Long>>());
            this.getSesion().getOrigenDeDatos().setDifferedWrite(1);
            ((IGestionReglasExtendida)this.getSesion().getGestionReglas()).setTipoReglaBusqueda(0);
            this.recorridoFicheroReglasValidacion();
            this.getTablasFlush().clear();
            try {
                this.vaciarPilaReglasRegistro();
            }
            catch (ExceptionMotor e) {
                ((ISesionExtendida)this.getSesion()).rollBack();
                throw e;
            }
            this.getSesion().getOrigenDeDatos().setDifferedWrite(estadoAnteriorMotor);
            ((ISesionExtendida)this.getSesion()).commitTrans();
            boolean e = this.isCorrecto();
            return e;
        }
        catch (Exception ex) {
            this.setCorrecto(false);
            this.getSesion().getOrigenDeDatos().setDifferedWrite(estadoAnteriorMotor);
            try {
                ((ISesionExtendida)this.getSesion()).rollBack();
            }
            catch (Exception ignorar) {
                // empty catch block
            }
            if (!ex.toString().contains("CORTAR EJECUCION SIN MAS")) {
                this.getSesion().getGestionReglas().setDiscriminante(this.getDiscriminanteAnterior());
                try {
                    ((ISesionExtendida)this.getSesion()).rollBack();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.getGestorFichero().clearRegistrosImportados();
                this.getGestorFichero().clearTotales();
            }
            if (ex instanceof ExceptionMotor) {
                throw (ExceptionMotor)ex;
            }
            throw new ExceptionMotor(ex);
        }
        finally {
            this.getSesion().getOrigenDeDatos().setDifferedWrite(estadoAnteriorMotor);
            this.sesion.getOrigenDeDatos().setCacheHabilitada(cacheOrigenDatosAnterior);
            ((ISesionExtendida)this.sesion).setRegistrosA\u00f1adidosPorReglasAlImportar(null);
            this.getSesion().getGestionReglas().setDiscriminante(this.getDiscriminanteAnterior());
            ((IGestionReglasExtendida)this.getSesion().getGestionReglas()).setTipoReglaBusqueda(this.getTiposReglaDispararAnterior());
            if (this.getListaTablasParaRegRegistro() != null) {
                this.getListaTablasParaRegRegistro().clear();
            }
        }
    }

    protected boolean partidaModificada(String cmpo, String valor) throws ExceptionMotor {
        return this.partidaModificada(cmpo, valor, null);
    }

    protected boolean partidaModificada(String cmpo, String valor, Map<String, String> propCampo) throws ExceptionMotor {
        try {
            String campo = cmpo;
            if (campo.endsWith(")")) {
                campo = campo.substring(0, campo.indexOf(40));
            }
            if (this.getSesion().getGestionReglas().isErrorPartidaModificadaSobreCampoCerrado()) {
                this.getSesion().getGestionReglas().setEmpezandoPartidaModificadaDesdeImportacion(true);
            }
            return this.getSesion().getGestionReglas().partidaModificada(campo, valor, propCampo);
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Campo " + cmpo + " valor " + valor);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Campo " + cmpo + " valor " + valor);
        }
    }

    protected boolean establecerPartida(String campo, String valor) throws ExceptionMotor {
        try {
            String partida = campo;
            if (partida.endsWith(")")) {
                partida = campo.substring(0, campo.indexOf(40));
            }
            return this.getSesion().getOperaciones().establecerPartida(partida, valor);
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Campo " + campo + " valor " + valor);
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e, "Campo " + campo + " valor " + valor);
        }
    }

    protected boolean ejecutarInicializaciones(String nombreTabla, boolean esFinalizacion) throws ExceptionMotor {
        ArrayList<IRegError> erroresDelMotor = null;
        try {
            erroresDelMotor = new ArrayList();
            List<String> temporalArrayList = null;
            temporalArrayList = this.getInicializaciones().get(nombreTabla);
            if (temporalArrayList != null) {
                for (int m = 0; m < temporalArrayList.size(); m += 2) {
                    if (esFinalizacion) {
                        int differedWrite = this.getSesion().getOrigenDeDatos().getDifferedWrite();
                        this.getSesion().getOrigenDeDatos().setDifferedWrite(0);
                        try {
                            this.getSesion().getOperaciones().establecerPartida(temporalArrayList.get(m).toString().toUpperCase(), temporalArrayList.get(m + 1).toString());
                        }
                        catch (Exception ex) {
                            FuncionesUtiles.getFuncionesUtiles().muestraError(new ExceptionMotor("No se pudo establecer la partida " + temporalArrayList.get(m).toString().toUpperCase()));
                        }
                        this.getSesion().getOrigenDeDatos().setDifferedWrite(differedWrite);
                        continue;
                    }
                    this.partidaModificada(temporalArrayList.get(m).toUpperCase(), temporalArrayList.get(m + 1));
                    erroresDelMotor = this.getSesion().getGestionReglas().getListaErroresEnReglas();
                    if (this.capturaErroresMotor(erroresDelMotor, temporalArrayList.get(m).toUpperCase(), false, false, null)) continue;
                    ((ISesionExtendida)this.getSesion()).rollBack();
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
        finally {
            erroresDelMotor = null;
        }
    }

    protected boolean esUnCampoAgregado(String nombreTabla, List<ITipoDatosCampoValor> campos, ITipoDatosTabla tabla) throws ExceptionMotor {
        return this.esUnCampoAgregadoNOResultSet(nombreTabla, campos, tabla);
    }

    protected boolean esUnCampoAgregadoNOResultSet(String nombreTabla, List<ITipoDatosCampoValor> campos, ITipoDatosTabla tabla) throws ExceptionMotor {
        try {
            boolean esCampoAgregado = false;
            List<String> camposAgregadoRegistros = null;
            camposAgregadoRegistros = this.getListaCamposTablaRegistrosAgregar().get(nombreTabla);
            if (camposAgregadoRegistros != null && camposAgregadoRegistros.size() > 0) {
                for (int j = 0; j < camposAgregadoRegistros.size(); ++j) {
                    if (TipoDatosCampoValor.indiceListaContieneCampo(campos, camposAgregadoRegistros.get(j).toString()) == -1) {
                        esCampoAgregado = false;
                        break;
                    }
                    esCampoAgregado = true;
                }
                if (esCampoAgregado) {
                    long actual = this.getSesion().getOperaciones().moveFirst(nombreTabla);
                    long anterior = 0L;
                    Map<String, ITablaMotorEntrada> camposMotor = null;
                    esCampoAgregado = false;
                    while (actual != anterior) {
                        camposMotor = this.getSesion().getOperaciones().obtenerRegistroDatosTabla(nombreTabla);
                        for (int j = 0; j < camposAgregadoRegistros.size() && (esCampoAgregado = FuncionesUtiles.getFuncionesUtiles().object2String(camposMotor.get(camposAgregadoRegistros.get(j).toString()).getValor()).equalsIgnoreCase(FuncionesUtiles.getFuncionesUtiles().object2String(campos.get(TipoDatosCampoValor.indiceListaContieneCampo(campos, camposAgregadoRegistros.get(j).toString())).getValor()))); ++j) {
                        }
                        if (esCampoAgregado) {
                            String warning = tabla.getPropiedadesTabla().get("WARNINGAGREGADO");
                            if (warning == null) break;
                            RegError r = new RegError();
                            r.setPropiedad("NUM ERROR", warning.toString());
                            this.getGestorFichero().addWarning(String.valueOf(this.getLineaFichero()), r, null);
                            r = null;
                            if (this.getGestorFichero().errCount() < this.getGestorFichero().getMaxErrores()) break;
                            this.setSuperoNumeroMaximoErrores(true);
                            throw new ExceptionMotor("CORTAR EJECUCION SIN MAS");
                        }
                        anterior = actual;
                        actual = this.getSesion().getOperaciones().moveNext(tabla.getNombreTabla());
                    }
                }
            }
            if (tabla.getPropiedadesTabla() != null && !FuncionesUtiles.getFuncionesUtiles().object2String(tabla.getPropiedadesTabla().get("WARNINGREGISTROUNICO")).equalsIgnoreCase("") && this.getSesion().getOperaciones().recordCount(tabla.getNombreTabla().toUpperCase()) > 0L) {
                esCampoAgregado = true;
                String warning = tabla.getPropiedadesTabla().get("WARNINGREGISTROUNICO").toString();
                if (warning != null) {
                    RegError r = new RegError();
                    r.setPropiedad("NUM ERROR", warning);
                    this.getGestorFichero().addWarning(String.valueOf(this.getLineaFichero()), r, null);
                    r = null;
                    if (this.getGestorFichero().errCount() >= this.getGestorFichero().getMaxErrores()) {
                        this.setSuperoNumeroMaximoErrores(true);
                        throw new ExceptionMotor("CORTAR EJECUCION SIN MAS");
                    }
                }
            }
            return esCampoAgregado;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    protected List<ITipoDatosCampos> dameCamposOrdenadosSegunTransXXX(ITipoDatosTabla tabla) throws ExceptionMotor {
        int pos = TipoDatosTabla.indiceListaContieneTabla(this.getGestor().getTablasOrdenadas(), tabla.getNombreTabla());
        if (pos != -1) {
            return this.getGestor().getTablasOrdenadas().get(pos).getCampos();
        }
        for (ITipoDatosTabla tablaActual : this.getGestor().getTablasOrdenadas()) {
            if (!tablaActual.getPropiedadesTabla().containsKey("TABLABBDD") || !tabla.getPropiedadesTabla().containsKey("TABLABBDD") || !tablaActual.getPropiedadesTabla().get("TABLABBDD").equalsIgnoreCase(tabla.getPropiedadesTabla().get("TABLABBDD"))) continue;
            return tablaActual.getCampos();
        }
        return tabla.getCampos();
    }

    protected boolean hacerSaltarLasReglasAlAnniadirRegistroNuevo(String nombreTabla, ITipoDatosTabla tabla, TipoDatosTabla listaTablasAdicionales, List<ITipoDatosCampoValor> campos, boolean ignoreRegRegistro) throws ExceptionMotor {
        try {
            int k = 0;
            int j = 0;
            Map<String, String> propCampos = null;
            List<Object> erroresDelMotor = new ArrayList();
            List<ITipoDatosCampos> camposOrdenadosSegunTransXXX = this.dameCamposOrdenadosSegunTransXXX(tabla);
            block3: for (k = 0; k < camposOrdenadosSegunTransXXX.size(); ++k) {
                for (j = 0; j < campos.size(); ++j) {
                    if (campos.get(j).getNombreCampo().startsWith("[FILTRO]")) {
                        this.getSesion().getOperaciones().establecerPartida(campos.get(j).getNombreCampo().substring("[FILTRO]".length()), campos.get(j).getValor());
                        continue;
                    }
                    if (!campos.get(j).getNombreCampo().equalsIgnoreCase(camposOrdenadosSegunTransXXX.get(k).getNombreCampo())) continue;
                    propCampos = camposOrdenadosSegunTransXXX.get(k).getPropiedadesCampos();
                    if (campos.get(j).getNombreCampo().length() == 0 || propCampos.get("NOIMPORTAR") != null) continue block3;
                    String tipoDato = this.getGestorConfiguracion().getEntrada(campos.get(j).getNombreCampo()).getTipoDato();
                    if (!ignoreRegRegistro && propCampos.get("RVEJECUCION") != null && propCampos.get("RVEJECUCION").equalsIgnoreCase("RegRegistro")) {
                        if (!this.getPendientesParaRegRegistro().containsKey(nombreTabla)) {
                            this.getPendientesParaRegRegistro().put(nombreTabla, new ArrayList());
                        }
                        this.getPendientesParaRegRegistro().get(nombreTabla).add(new TipoDatosCampoValor(campos.get(j).getNombreCampo(), campos.get(j).getValor(), this.getLineaFichero()));
                        continue block3;
                    }
                    this.setColetillaWarning("");
                    this.setTransf("");
                    erroresDelMotor.clear();
                    this.partidaModificada(campos.get(j).getNombreCampo(), this.formateaValor(campos.get(j).getNombreCampo(), campos.get(j).getValor(), propCampos, tipoDato), propCampos);
                    erroresDelMotor = this.getSesion().getGestionReglas().getListaErroresEnReglas();
                    if (erroresDelMotor.size() > 0) {
                        if (this.getTransf().length() == 0 && propCampos.get("TRANSRV") != null) {
                            this.setTransf(propCampos.get("TRANSRV").toString());
                        }
                        if (this.getTransf().length() > 0) {
                            this.getGestorFichero().transfCargaTransformaciones(campos.get(j).getValor(), this.getTransf());
                            while (this.setTransf(this.getGestorFichero().transfDameSiguienteTransformacion()) != null) {
                                if (this.partidaModificada(campos.get(j).getNombreCampo(), this.formateaValor(campos.get(j).getNombreCampo(), this.getTransf(), propCampos, tipoDato))) {
                                    erroresDelMotor = this.getSesion().getGestionReglas().getListaErroresEnReglas();
                                    this.setColetillaWarning(this.getGestorFichero().transfDameColetilla());
                                    campos.get(j).setValor(this.getTransf());
                                    break;
                                }
                                erroresDelMotor = this.getSesion().getGestionReglas().getListaErroresEnReglas();
                                this.setColetillaWarning("");
                            }
                        }
                    }
                    if (this.capturaErroresMotor(erroresDelMotor, propCampos.get("LITERAL").toString(), false, false, campos.get(j).getExtra())) continue block3;
                    ((ISesionExtendida)this.getSesion()).rollBack();
                    throw new ExceptionMotor("CORTAR EJECUCION SIN MAS");
                }
            }
            camposOrdenadosSegunTransXXX = null;
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected void compruebaWarningsCambiosPorReglas() throws ExceptionMotor {
        try {
            if (this.getGestorFichero().getListaWarning().size() > 0) {
                block2: for (int i = this.getGestorFichero().getListaWarning().size() - 1; i >= 0; --i) {
                    if (this.getGestorFichero().getListaWarning().get(i).getPropiedad("LOCALIZACION") == null || this.getGestorFichero().getListaWarning().get(i).getCampoError() == null) continue;
                    for (IRegError err : this.getGestorFichero().getListaErrores()) {
                        if (err.getCampoError() == null || err.getPropiedad("LOCALIZACION") == null || !err.getCampoError().equalsIgnoreCase(this.getGestorFichero().getListaWarning().get(i).getCampoError()) || Integer.parseInt(err.getPropiedad("LOCALIZACION").toString()) != Integer.parseInt(this.getGestorFichero().getListaWarning().get(i).getPropiedad("LOCALIZACION").toString())) continue;
                        this.getGestorFichero().getListaWarning().remove(i);
                        continue block2;
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public String nombrePartidaAImportarCasoLaQueTengaValor(List<ITipoDatosCampoValor> camposImportados, String tipoDato) throws ExceptionMotor {
        throw new ExceptionMotor("Como tiene en ekl TransXXX algun campo 'LAQTENGAVALOR_' debe implementar el m\u00e9todo nombrePartidaAImportarCasoLaQueTengaValor");
    }

    protected boolean hacerSaltarLasReglasAlAnniadirRegistroNuevo(TipoDatosTabla tabla, TipoDatosTabla tablaAdicionales, List<String> campos, List<String> camposRegistroSegunTablasInternas) throws ExceptionMotor {
        try {
            int k = 0;
            Map<String, String> propCampos = null;
            ArrayList<IRegError> erroresDelMotor = new ArrayList();
            List<ITipoDatosCampos> camposOrdenadosSegunTransXXX = this.dameCamposOrdenadosSegunTransXXX(tabla);
            block3: for (k = 0; k < camposOrdenadosSegunTransXXX.size(); ++k) {
                for (int i = 0; i < camposRegistroSegunTablasInternas.size(); ++i) {
                    if (!camposRegistroSegunTablasInternas.get(i).equalsIgnoreCase(camposOrdenadosSegunTransXXX.get(k).getNombreCampo())) continue;
                    propCampos = this.getGestor().getCampo(camposRegistroSegunTablasInternas.get(i));
                    if (camposRegistroSegunTablasInternas.get(i).length() == 0 || propCampos.get("NOIMPORTAR") != null) continue block3;
                    this.setColetillaWarning("");
                    this.setTransf("");
                    erroresDelMotor.clear();
                    String[] nombrePartida = StringUtility.getStringUtility().split(camposRegistroSegunTablasInternas.get(i), "(");
                    String tipoDato = this.getGestorConfiguracion().getEntrada(nombrePartida[0]).getTipoDato();
                    this.partidaModificada(nombrePartida[0], this.formateaValor(nombrePartida[0], campos.get(i), propCampos, tipoDato));
                    erroresDelMotor = this.getSesion().getGestionReglas().getListaErroresEnReglas();
                    if (this.capturaErroresMotor(erroresDelMotor, propCampos.get("LITERAL").toString(), false, false, null)) continue block3;
                    ((ISesionExtendida)this.getSesion()).rollBack();
                    throw new ExceptionMotor("CORTAR EJECUCION SIN MAS");
                }
            }
            camposOrdenadosSegunTransXXX = null;
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected long anniadirElRegistroAlMotor(String nombreTabla, List<ITipoDatosCampoValor> campos) throws ExceptionMotor {
        try {
            return this.getSesion().getOperaciones().anniadirRegistro(nombreTabla);
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    protected boolean esValorPorDefectoParaNumericos(String valor) throws Exception {
        try {
            if (valor.length() == 0) {
                return true;
            }
            if (valor.startsWith("N")) {
                return this.esValorPorDefectoParaNumericos(valor.substring(1));
            }
            return Double.parseDouble(valor) == 0.0;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    protected boolean tieneContenido(String nombreCampo, String valor) throws ExceptionMotor {
        try {
            IRegEntrada ent = this.getModelo().getGestorConfiguracion().getEntrada(nombreCampo);
            if (!ent.esValorPorDefecto(valor.trim())) {
                return !ent.getTipoDato().equalsIgnoreCase("CADENA_NUMERICA") && !ent.getTipoDato().equalsIgnoreCase("CADENA_NUMERICA_2") && !ent.getTipoDato().equalsIgnoreCase("FECHA") && !ent.esTipoNumerico() || !this.esValorPorDefectoParaNumericos(valor.trim());
            }
            return false;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected GestorTablasFragmentadas getGestorTablasFragmentadas() {
        if (this.gestorTablasFragmentadas == null) {
            this.gestorTablasFragmentadas = new GestorTablasFragmentadas();
        }
        return this.gestorTablasFragmentadas;
    }

    protected boolean existenMasTablasDetrasDeFragmentada(String nomTab, List<ITipoDatosTabla> listaTablas, int iactual) throws ExceptionMotor {
        try {
            boolean terminarTabla = true;
            for (int k = iactual; k < listaTablas.size(); ++k) {
                if (!listaTablas.get(k).getPropiedadesTabla().containsKey("TABLABBDD") || !listaTablas.get(k).getPropiedadesTabla().get("TABLABBDD").equalsIgnoreCase(nomTab)) continue;
                terminarTabla = false;
                break;
            }
            return terminarTabla;
        }
        catch (Exception ee) {
            throw new ExceptionMotor(ee);
        }
    }

    protected boolean cumunRegistroNuevo(ITipoDatosTabla tablaActual, List<ITipoDatosCampoValor> camposTabla, ITipoDatosAnotacionBitacora anotacionTabla, ITipoDatosAnotacionBitacora tablaEnProgreso, boolean forceFragmentada) throws ExceptionMotor {
        try {
            if (!forceFragmentada && tablaActual.getPropiedadesTabla().containsKey("FRAGMENTADA") && (tablaActual.getPropiedadesTabla().get("FRAGMENTADA").equalsIgnoreCase("true") || tablaActual.getPropiedadesTabla().get("FRAGMENTADA").equalsIgnoreCase("si") || tablaActual.getPropiedadesTabla().get("FRAGMENTADA").equalsIgnoreCase("1"))) {
                if (!this.getGestorTablasFragmentadas().containsTabla(tablaActual.getPropiedadesTabla().get("TABLABBDD"))) {
                    this.getGestorTablasFragmentadas().add(tablaActual.getPropiedadesTabla().get("TABLABBDD"), tablaActual);
                }
                for (ITipoDatosCampoValor c : camposTabla) {
                    c.setExtra(this.getLineaFichero());
                }
                this.getGestorTablasFragmentadas().append(tablaActual.getPropiedadesTabla().get("TABLABBDD"), camposTabla);
                camposTabla = null;
                return false;
            }
            if (anotacionTabla != null) {
                anotacionTabla.setHanSaltadoSusReglas(false);
            }
            boolean vacio = true;
            for (ITipoDatosCampoValor iTipoDatosCampoValor : camposTabla) {
                if (iTipoDatosCampoValor.getNombreCampo().startsWith("[FILTRO]") || iTipoDatosCampoValor.getValor().trim().length() == 0 || !this.tieneContenido(iTipoDatosCampoValor.getNombreCampo(), iTipoDatosCampoValor.getValor().trim())) continue;
                vacio = false;
                break;
            }
            if (vacio) {
                return true;
            }
            int resultado = this.registroNuevo(tablaActual, null, camposTabla).getValor();
            switch (resultado) {
                case -91: {
                    if (anotacionTabla == null) {
                        throw new ExceptionMotor("Error al insertar registro en la base de datos " + tablaActual.getNombreTabla());
                    }
                    throw new ExceptionMotor("Error al insertar registro en la base de datos " + anotacionTabla.getNombreCampo());
                }
                case -92: 
                case -90: {
                    break;
                }
                default: {
                    if (anotacionTabla != null) {
                        anotacionTabla.setHanSaltadoSusReglas(true);
                    }
                    if (tablaEnProgreso == null) break;
                    tablaEnProgreso.setPosicionMotor(((ISesionExtendida)this.sesion).obtenerNodoTabla(tablaActual.getNombreTabla()).getLocalizacion());
                }
            }
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected TipoDatoRetornoRegistroNuevo registroNuevo(ITipoDatosTabla tabla, TipoDatosTabla tablaAdicional, List<ITipoDatosCampoValor> campos) throws ExceptionMotor {
        try {
            if (campos.size() == 0) {
                return new TipoDatoRetornoRegistroNuevo(-91);
            }
            long idAdded = 0L;
            List<Long> idsAdded = null;
            String nombreTabla = tabla.getNombreTabla();
            if (tabla.getPropiedadesTabla() != null && tabla.getPropiedadesTabla().containsKey("TABLABBDD")) {
                nombreTabla = tabla.getPropiedadesTabla().get("TABLABBDD");
            }
            if (this.getGestorConfiguracion().getTabla(nombreTabla) == null) {
                throw new ExceptionMotor("No encuentro tabla : " + nombreTabla);
            }
            this.getTablasFlush().clear();
            if (!this.estimarSiSeHacenSaltarReglasDeRegistro(nombreTabla, this.getLineaFichero())) {
                throw new ExceptionMotor("CORTAR EJECUCION SIN MAS");
            }
            this.getTablasFlush().clear();
            this.getTablasFlush().add(nombreTabla);
            if (this.esUnCampoAgregado(nombreTabla, campos, tabla)) {
                return new TipoDatoRetornoRegistroNuevo(-92);
            }
            idAdded = -1L;
            if (((ISesionExtendida)this.getSesion()).getRegistrosA\u00f1adidosPorReglasAlImportar().containsKey(nombreTabla)) {
                String loc = FuncionesUtiles.getFuncionesUtiles().dameCadenaPadreLocalizacion(((ISesionExtendida)this.getSesion()).obtenerNodoPartida(campos.get(0).getNombreCampo()).getLocalizacion());
                if (((ISesionExtendida)this.getSesion()).getRegistrosA\u00f1adidosPorReglasAlImportar().get(nombreTabla).equalsIgnoreCase(loc)) {
                    idAdded = this.getSesion().getOperaciones().obtenerClaveActiva(nombreTabla);
                    if (idAdded == 0L) {
                        idAdded = -1L;
                    }
                    ((ISesionExtendida)this.getSesion()).getRegistrosA\u00f1adidosPorReglasAlImportar().remove(nombreTabla);
                }
            }
            if (idAdded == -1L) {
                idAdded = this.anniadirElRegistroAlMotor(nombreTabla, campos);
            }
            if (idAdded < 1L) {
                if (idAdded == -2L) {
                    this.capturaErroresMotor(this.getSesion().getGestionReglas().getListaErroresEnReglas(), "", false, false, this.getLineaFichero());
                } else {
                    this.capturaErroresMotor(FuncionesUtiles.getFuncionesUtiles().generarErrorSiNoExiste(this.sesion, "ADDERR"), "", false, false);
                }
                ((ISesionExtendida)this.getSesion()).rollBack();
                throw new ExceptionMotor("CORTAR EJECUCION SIN MAS");
            }
            this.getGestorFichero().addRegistroImportado(nombreTabla.toUpperCase());
            idsAdded = this.getConjuntoDeRegistrosAgregados().get(nombreTabla.toUpperCase());
            if (idsAdded == null) {
                idsAdded = new ArrayList<Long>();
            }
            idsAdded.add(new Long(idAdded));
            this.getConjuntoDeRegistrosAgregados().put(nombreTabla.toUpperCase(), idsAdded);
            idsAdded = null;
            if (!this.ejecutarInicializaciones(nombreTabla, false)) {
                throw new ExceptionMotor("CORTAR EJECUCION SIN MAS");
            }
            this.hacerSaltarLasReglasAlAnniadirRegistroNuevo(nombreTabla, tabla, tablaAdicional, campos, false);
            if (this.getListaTablasConReglasRegistroAlInsert().get(nombreTabla) != null) {
                if (this.getListaTablasParaRegRegistro().get(this.getListaTablasParaRegRegistro().size() - 2).toString().equalsIgnoreCase("1") && !this.hacerSaltaReglasDeRegistro(nombreTabla)) {
                    ((ISesionExtendida)this.getSesion()).rollBack();
                    throw new ExceptionMotor("CORTAR EJECUCION SIN MAS");
                }
                this.borraUltimaReglaDeRegistroPendiente();
            }
            if (!this.flushRegistroNuevo(nombreTabla)) {
                return new TipoDatoRetornoRegistroNuevo(-91);
            }
            campos.get(0).setExtra(this.getLineaFichero());
            if (this.getSesion().getGestionReglas().isAvisosSobreCamposActualizados()) {
                TipoDatosCampoValorEx reg = new TipoDatosCampoValorEx(this.getSesion().getOperaciones().getLocalizacionEx(nombreTabla), campos);
                List<ITipoDatosCampoValorEx> regsTabla = this.getPendientesEstimarPorCambioEnReglas().get(nombreTabla);
                if (regsTabla == null) {
                    regsTabla = new ArrayList<ITipoDatosCampoValorEx>();
                }
                regsTabla.add(reg);
                this.getPendientesEstimarPorCambioEnReglas().put(nombreTabla, regsTabla);
            }
            return new TipoDatoRetornoRegistroNuevo((int)idAdded);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected boolean flushRegistroNuevo(String nombreTabla) throws ExceptionMotor {
        try {
            return ((IGestionOperacionesExtendida)this.getSesion().getOperaciones()).flush(nombreTabla);
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    protected boolean flushActualizarRegistro(String nombreTabla) throws ExceptionMotor {
        try {
            return ((IGestionOperacionesExtendida)this.getSesion().getOperaciones()).flushActualizarRegistro(nombreTabla);
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    protected abstract void recorridoFicheroReglasValidacion() throws ExceptionMotor;

    public void cancelar() {
        this.getGestorFichero().cancelar();
    }

    protected boolean capturaErroresMotor(IRegError unicoError, String campo, boolean forzarWarning, boolean estoyEnReglasDeRegistro) throws ExceptionMotor {
        try {
            ArrayList<IRegError> errores = new ArrayList<IRegError>();
            errores.add(unicoError);
            return this.capturaErroresMotor(errores, campo, forzarWarning, estoyEnReglasDeRegistro, null);
        }
        catch (ExceptionMotor e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    protected boolean capturaErroresMotor(List<IRegError> errores, String campo, boolean forzarWarning, boolean estoyEnReglasDeRegistro, String lineaFichero) throws ExceptionMotor {
        IRegError err = null;
        try {
            int k;
            if (this.isSuperoNumeroMaximoErrores()) {
                boolean bl = false;
                return bl;
            }
            if (errores == null) {
                boolean bl = true;
                return bl;
            }
            if (errores.size() == 0) {
                boolean bl = true;
                return bl;
            }
            for (k = 0; k < errores.size(); ++k) {
                err = errores.get(k);
                if (lineaFichero == null || lineaFichero.trim().length() == 0) {
                    lineaFichero = String.valueOf(this.getLineaFichero());
                    if (estoyEnReglasDeRegistro && this.getListaTablasParaRegRegistro() != null) {
                        lineaFichero = this.getListaTablasParaRegRegistro().get(this.getListaTablasParaRegRegistro().size() - 1).toString();
                    }
                }
                if (this.getColetillaWarning().length() == 0 && !forzarWarning && !err.getTipoError().equalsIgnoreCase("W")) {
                    if (!estoyEnReglasDeRegistro && this.getListaTablasParaRegRegistro() != null && !err.getIdError().equalsIgnoreCase("IMPROCEDENTE")) {
                        this.getListaTablasParaRegRegistro().set(this.getListaTablasParaRegRegistro().size() - 2, "0");
                    }
                    this.getGestorFichero().addError(lineaFichero, err, null);
                    if (this.getGestorFichero().getListaErrores().size() > 0) {
                        this.setCorrecto(false);
                    }
                } else {
                    err.setPropiedad("NUM ERROR", err.getPropiedad("NUM ERROR").toString() + this.getColetillaWarning());
                    this.getGestorFichero().addWarning(lineaFichero, err, null);
                }
                if (this.getGestorFichero().errCount() >= this.getGestorFichero().getMaxErrores()) {
                    this.setSuperoNumeroMaximoErrores(true);
                    this.getGestorFichero().clearRegistrosImportados();
                    FuncionesUtiles.getFuncionesUtiles().dejaSoloNerroresEntreListas(this.getListaErrores(), this.getListaWarning(), this.getGestorFichero().getMaxErrores());
                    boolean bl = false;
                    return bl;
                }
                if (err.getIdError().equalsIgnoreCase("OVERFLOW_MOTOR")) {
                    this.getGestorFichero().clearRegistrosImportados();
                    boolean bl = false;
                    return bl;
                }
                if (err.getTipoError() == null || !err.getTipoError().equalsIgnoreCase("H")) continue;
                this.getGestorFichero().clearRegistrosImportados();
                boolean bl = false;
                return bl;
            }
            k = 1;
            return k != 0;
        }
        catch (Exception ex) {
            this.getGestorFichero().clearRegistrosImportados();
            if (ex instanceof ExceptionMotor) {
                ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + "Campo " + campo);
                throw (ExceptionMotor)ex;
            }
            throw new ExceptionMotor(ex, "Campo" + campo);
        }
        finally {
            err = null;
        }
    }

    protected String formateaValor(String partida, String valor, Map<String, String> propiedades, String tDato) throws ExceptionMotor {
        try {
            String res = valor;
            String tipoDato = "";
            try {
                tipoDato = this.getGestor().traduceCadena(propiedades.get("TIPODATO").toString());
            }
            catch (Exception ex) {
                return res;
            }
            return this.formateaValor(partida, tipoDato, valor, propiedades, tDato);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String formateaValor(String partida, String tipoDato, String valor, Map<String, String> propiedades, String tDato) throws ExceptionMotor {
        try {
            String res = valor;
            if (tipoDato.toUpperCase().indexOf("Valores".toUpperCase()) == 0) {
                String[] p = StringUtility.getStringUtility().split(tipoDato, ":");
                int i = 0;
                while (i < p.length) {
                    String[] q = StringUtility.getStringUtility().split(p[i], "=");
                    if (q.length == 2 && valor.compareTo(FuncionesUtiles.getFuncionesUtiles().desCodificaCadena(q[0])) == 0) {
                        return FuncionesUtiles.getFuncionesUtiles().desCodificaCadena(q[1]);
                    }
                    ++i;
                }
                return res;
            }
            if (tipoDato.toUpperCase().indexOf("CONV_FECHA".toUpperCase()) == 0) {
                if (valor.length() == 0) return res;
                return this.transformarFecha(valor);
            }
            if (tipoDato.toUpperCase().indexOf("CTE:".toUpperCase()) == 0) {
                return FuncionesUtiles.getFuncionesUtiles().desCodificaCadena(tipoDato.substring("CTE:".length()));
            }
            if (tipoDato.toUpperCase().indexOf("FUNCION".toUpperCase()) == 0) {
                return this.ejecutaMetodoDeClase(tipoDato.substring("FUNCION".length() + 1).split(","), valor);
            }
            if (tipoDato.equalsIgnoreCase("Num")) {
                String retorno = "";
                retorno = tDato.equalsIgnoreCase("BIGDECIMAL") ? this.formateoADecimalesBigDecimal(valor, propiedades.get("DECIMALES")) : this.formateoADecimales(valor, propiedades.get("DECIMALES"));
                if (tDato == null) return retorno;
                if (!tDato.equalsIgnoreCase("CADENA_NUMERICA_2")) return retorno;
                try {
                    if (Double.parseDouble(retorno) != 0.0) return FuncionesUtiles.getFuncionesUtiles().rellena(retorno, '0', Integer.parseInt(propiedades.get("LONGITUD").toString()), true);
                    return "";
                }
                catch (Exception ex) {
                    // empty catch block
                }
                return retorno;
            }
            if (tipoDato.equalsIgnoreCase("NumSigno")) {
                if (valor.charAt(0) != 'N') return this.formateoADecimales(valor, propiedades.get("DECIMALES"));
                return "-" + this.formateoADecimales(valor.substring(1), propiedades.get("DECIMALES"));
            }
            if (tipoDato.equalsIgnoreCase("FechaInvertida")) {
                switch (res.length()) {
                    case 6: {
                        return res.substring(4, 6) + res.substring(2, 4) + res.substring(0, 2);
                    }
                    case 8: {
                        return res.substring(4, 8) + res.substring(2, 4) + res.substring(0, 2);
                    }
                    default: {
                        throw new ExceptionMotor(LITERAL_LONGITUD_ERRONEA);
                    }
                }
            }
            if (tipoDato.equalsIgnoreCase("X_a_true")) {
                if (valor.equalsIgnoreCase("X")) return "true";
                if (valor.equalsIgnoreCase("true")) {
                    return "true";
                }
                if (valor.equalsIgnoreCase(" ")) return "false";
                if (!valor.equalsIgnoreCase("false")) throw new ExceptionMotor("Valor (" + valor + ") no valido para tipo '" + "X_a_true" + "'");
                return "false";
            }
            if (valor.trim().length() != 0) return StringUtility.getStringUtility().rTrim(res);
            return "";
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Valor " + valor);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Valor " + valor);
        }
    }

    protected String formateoADecimalesBigDecimal(String valor, Object decimales) throws ExceptionMotor {
        int numDecimales = 0;
        try {
            if (valor.length() == 0) {
                return valor;
            }
            if (decimales != null && decimales.toString().length() > 0) {
                numDecimales = Integer.valueOf(decimales.toString());
            }
            String res = valor;
            if (numDecimales == 0) {
                return Long.valueOf(valor).toString();
            }
            if (numDecimales > valor.length() - 1) {
                throw new ExceptionMotor("Error, demasiados decimales solicitados Valor = " + valor + " Decimales = " + numDecimales);
            }
            res = valor.substring(0, valor.length() - numDecimales) + "." + valor.substring(valor.length() - numDecimales);
            return new BigDecimal(res.toString().trim()).toString();
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Valor " + valor + " Decimales " + numDecimales);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Valor " + valor + " Decimales " + numDecimales);
        }
    }

    protected String formateoADecimales(String valor, Object decimales) throws ExceptionMotor {
        int numDecimales = 0;
        try {
            if (valor.length() == 0) {
                return valor;
            }
            if (decimales != null && decimales.toString().length() > 0) {
                numDecimales = Integer.valueOf(decimales.toString());
            }
            String res = valor;
            if (numDecimales == 0) {
                return Long.valueOf(valor).toString();
            }
            if (numDecimales > valor.length() - 1) {
                throw new ExceptionMotor("Error, demasiados decimales solicitados Valor = " + valor + " Decimales = " + numDecimales);
            }
            res = valor.substring(0, valor.length() - numDecimales) + "." + valor.substring(valor.length() - numDecimales);
            String ret = Double.valueOf(res).toString();
            if (ret.toLowerCase().contains("e")) {
                return this.formateoADecimalesBigDecimal(valor, decimales);
            }
            return ret;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Valor " + valor + " Decimales " + numDecimales);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Valor " + valor + " Decimales " + numDecimales);
        }
    }

    private String transformarFecha(String fechaDeclaracion) {
        String fechaAux = "";
        fechaAux = fechaDeclaracion.substring(12) + FuncionesUtiles.getFuncionesUtiles().convierteMesenNumero(fechaDeclaracion.substring(2, 12)) + fechaDeclaracion.substring(0, 2);
        return fechaAux;
    }

    protected String ejecutaMetodoDeClase(String[] parametros, String val) throws ExceptionMotor {
        String valor = val;
        String nombreClase = "";
        String nombreMetodo = "";
        try {
            nombreClase = parametros[0];
            nombreMetodo = parametros[1];
            if (this.cacheClasesParaFunciones == null) {
                this.cacheClasesParaFunciones = new HashMap<String, List<Object>>();
            }
            Class[] parametrosClase = new Class[]{String.class, Object[].class};
            List<Object> claseAInvocar = this.cacheClasesParaFunciones.get(nombreClase.toUpperCase());
            Object cls = null;
            Method metodo = null;
            if (claseAInvocar == null) {
                cls = this.getSesion().getModelo().getClaseGeneradorDinamicoClases().loadClassFromJarFile(nombreClase);
                if (cls == null) {
                    throw new ExceptionMotor("Imposible encontrar clase");
                }
                try {
                    metodo = cls.getClass().getMethod(nombreMetodo, parametrosClase);
                }
                catch (Exception ex) {
                    throw new ExceptionMotor(ex, "Imposible encontrar m\u00e9todo");
                }
            } else {
                cls = claseAInvocar.get(0);
                if (cls == null) {
                    throw new ExceptionMotor("Imposible encontrar clase");
                }
                metodo = (Method)claseAInvocar.get(1);
                if (metodo == null) {
                    throw new ExceptionMotor("Imposible encontrar m\u00e9todo");
                }
            }
            ArrayList<String> param = new ArrayList<String>();
            for (int i = 2; i < parametros.length; ++i) {
                param.add(parametros[i]);
            }
            try {
                valor = metodo.invoke(cls, valor, param.toArray()).toString();
            }
            catch (Exception ex) {
                valor = null;
            }
            param = null;
            if (claseAInvocar == null) {
                claseAInvocar = new ArrayList<Object>();
                claseAInvocar.add(cls);
                claseAInvocar.add(metodo);
                this.cacheClasesParaFunciones.put(nombreClase.toUpperCase(), claseAInvocar);
            }
            return valor;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Valor " + val);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Valor " + val);
        }
    }

    protected void setConjuntoDeRegistrosAgregados(Map<String, List<Long>> conjuntoDeRegistrosAgregados) {
        this.conjuntoDeRegistrosAgregados = conjuntoDeRegistrosAgregados;
    }

    protected Map<String, List<Long>> getConjuntoDeRegistrosAgregados() {
        return this.conjuntoDeRegistrosAgregados;
    }

    protected void setReglasRegistro(List<ITipoDatosReglasTipoYPartidas> reglasRegistro) {
        this.reglasRegistro = reglasRegistro;
    }

    protected List<ITipoDatosReglasTipoYPartidas> getReglasRegistro() {
        return this.reglasRegistro;
    }

    protected void setCacheReglasRegistro(List<String> cacheReglasRegistro) {
        this.cacheReglasRegistro = cacheReglasRegistro;
    }

    protected List<String> getCacheReglasRegistro() {
        return this.cacheReglasRegistro;
    }

    protected void setCacheNombreUltimaReglaRegistro(String cacheNombreUltimaReglaRegistro) {
        this.cacheNombreUltimaReglaRegistro = cacheNombreUltimaReglaRegistro;
    }

    protected String getCacheNombreUltimaReglaRegistro() {
        return this.cacheNombreUltimaReglaRegistro;
    }

    protected void setArbolDelMotor(INodoArbol arbolDelMotor) {
        this.arbolDelMotor = arbolDelMotor;
    }

    protected INodoArbol getArbolDelMotor() {
        return this.arbolDelMotor;
    }

    protected void setListaCamposTablaRegistrosAgregar(Map<String, List<String>> listaCamposTablaRegistrosAgregar) {
        this.listaCamposTablaRegistrosAgregar = listaCamposTablaRegistrosAgregar;
    }

    protected Map<String, List<String>> getListaCamposTablaRegistrosAgregar() {
        if (this.listaCamposTablaRegistrosAgregar == null) {
            this.listaCamposTablaRegistrosAgregar = new HashMap<String, List<String>>();
        }
        return this.listaCamposTablaRegistrosAgregar;
    }

    protected void setListaTablasConReglasRegistroAlInsert(Map<String, String> listaTablasConReglasRegistroAlInsert) {
        this.listaTablasConReglasRegistroAlInsert = listaTablasConReglasRegistroAlInsert;
    }

    protected Map<String, String> getListaTablasConReglasRegistroAlInsert() {
        if (this.listaTablasConReglasRegistroAlInsert == null) {
            this.listaTablasConReglasRegistroAlInsert = new HashMap<String, String>();
        }
        return this.listaTablasConReglasRegistroAlInsert;
    }

    protected Map<String, List<ITipoDatosCampoValor>> getPendientesParaRegRegistro() {
        if (this.pendientesParaRegRegistro == null) {
            this.pendientesParaRegRegistro = new HashMap<String, List<ITipoDatosCampoValor>>();
        }
        return this.pendientesParaRegRegistro;
    }

    protected void setPendientesParaRegRegistro(Map<String, List<ITipoDatosCampoValor>> pendientesParaRegRegistro) {
        this.pendientesParaRegRegistro = pendientesParaRegRegistro;
    }

    protected Map<String, List<ITipoDatosCampoValorEx>> getPendientesEstimarPorCambioEnReglas() {
        if (this.pendientesEstimarPorCambioEnReglas == null) {
            this.pendientesEstimarPorCambioEnReglas = new HashMap<String, List<ITipoDatosCampoValorEx>>();
        }
        return this.pendientesEstimarPorCambioEnReglas;
    }

    protected void setPendientesEstimarPorCambioEnReglas(Map<String, List<ITipoDatosCampoValorEx>> pendientesEstimarPorCambioEnReglas) {
        this.pendientesEstimarPorCambioEnReglas = pendientesEstimarPorCambioEnReglas;
    }

    protected void setListaTablasParaRegRegistro(List<String> listaTablasParaRegRegistro) {
        this.listaTablasParaRegRegistro = listaTablasParaRegRegistro;
    }

    protected List<String> getListaTablasParaRegRegistro() {
        if (this.listaTablasParaRegRegistro == null) {
            this.listaTablasParaRegRegistro = new ArrayList<String>();
        }
        return this.listaTablasParaRegRegistro;
    }

    protected void setEstadoAnteriorMotor(int estadoAnteriorMotor) {
        this.estadoAnteriorMotor = estadoAnteriorMotor;
    }

    protected int getEstadoAnteriorMotor() {
        return this.estadoAnteriorMotor;
    }

    private void setTiposReglaDispararAnterior(int tiposReglaDispararAnterior) {
        this.tiposReglaDispararAnterior = tiposReglaDispararAnterior;
    }

    private int getTiposReglaDispararAnterior() {
        return this.tiposReglaDispararAnterior;
    }

    protected void setDiscriminanteAnterior(String discriminanteAnterior) {
        this.discriminanteAnterior = discriminanteAnterior;
    }

    protected String getDiscriminanteAnterior() {
        return this.discriminanteAnterior;
    }

    protected void setTablasFlush(List<String> tablasFlush) {
        this.tablasFlush = tablasFlush;
    }

    protected List<String> getTablasFlush() {
        return this.tablasFlush;
    }

    protected void setInicializaciones(Map<String, List<String>> inicializaciones) {
        this.inicializaciones = inicializaciones;
    }

    protected Map<String, List<String>> getInicializaciones() {
        return this.inicializaciones;
    }

    protected void setNodoTemporal(INodoArbol nodoTemporal) {
        this.nodoTemporal = nodoTemporal;
    }

    protected INodoArbol getNodoTemporal() {
        return this.nodoTemporal;
    }

    protected void setOrigenDatos(IOrigenDatos origenDatos) {
        this.origenDatos = origenDatos;
    }

    public IOrigenDatos getOrigenDatos() {
        return this.origenDatos;
    }

    protected void setGestorConfiguracion(IGestorConfiguracion gestorConfiguracion) {
        this.gestorConfiguracion = gestorConfiguracion;
    }

    protected IGestorConfiguracion getGestorConfiguracion() {
        return this.gestorConfiguracion;
    }

    @Override
    public void setSesion(ISesion sesion) throws ExceptionMotor {
        this.sesion = sesion;
        this.setModelo(sesion.getModelo());
        this.getGestor().setModelo(sesion.getModelo());
        IGestorTraducciones gt = null;
        try {
            gt = (IGestorTraducciones)this.getGestorFichero().getGestorTraducciones();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (gt == null) {
            try {
                gt = (IGestorTraducciones)((es.aeat.pftw.mtrc.gestionFicheros.exportacionV2.boeV2.IExportacionBOE)((ISesionExtendida)sesion).getClaseExportacionBOE()).getGestorFichero().getGestorTraducciones();
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
        if (gt == null) {
            try {
                gt = (IGestorTraducciones)((IExportacionBOE)((ISesionExtendida)sesion).getClaseExportacionBOE()).getGestorFichero().getGestorTraducciones();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (gt != null) {
            this.getGestorFichero().setGestorTraducciones(gt);
            ((IGestorTraducciones)this.getGestorFichero().getGestorTraducciones()).setModelo(sesion.getModelo());
        }
        this.getOrigenDatos().setSesion(sesion);
    }

    @Override
    public ISesion getSesion() {
        return this.sesion;
    }

    protected void setTablas(Map<String, TipoDatosTabla> tablas) {
        this.tablas = tablas;
    }

    protected Map<String, TipoDatosTabla> getTablas() {
        return this.tablas;
    }
}

