/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.gestionFicheros.importacion.boe;

import es.aeat.pftw.mtrc.configuracion.RegError;
import es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.GestorTraducciones;
import es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.IGestorTraducciones;
import es.aeat.pftw.mtrc.gestionFicheros.importacion.boe.IValidacionSecuencias;
import es.aeat.pftw.mtrc.gestionFicheros.importacion.boe.IValidacionSecuenciasCaller;
import es.aeat.pftw.mtrc.motor.modelo.IModelo;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.tipos.TipoDatoRetornoMetodo;
import es.aeat.pftw.mtrc.tipos.TipoDatosCampoValor;
import es.aeat.pftw.mtrp.configuracion.IRegError;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.tipos.ITipoDatoRetornoMetodo;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampoValor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValidacionSecuencias
implements IValidacionSecuencias,
IValidacionSecuenciasCaller,
Serializable {
    private static final long serialVersionUID = 1L;
    protected List<IRegError> listaErrores = null;
    protected List<IRegError> listaWarning = null;
    protected List<Object> arraySecuencias = null;
    protected List<ITipoDatosCampoValor> arraySecuenciasLeidas = new ArrayList<ITipoDatosCampoValor>();
    protected Map<String, String> arraySecuenciasDesHabilitadas = new HashMap<String, String>();
    protected String errorPredeterminado = "ERRSEC";
    private transient IModelo modelo;

    public Map<String, String> getArraySecuenciasDesHabilitadas() {
        return this.arraySecuenciasDesHabilitadas;
    }

    @Override
    public void setArraySecuenciasDesHabilitadas(Map<String, String> arraySecuenciasDesHabilitadas) {
        this.arraySecuenciasDesHabilitadas = arraySecuenciasDesHabilitadas;
    }

    @Override
    public void setListaErrores(List<IRegError> listaErrores) {
        this.listaErrores = listaErrores;
    }

    @Override
    public void setListaWarning(List<IRegError> listaWarning) {
        this.listaWarning = listaWarning;
    }

    @Override
    public void setArraySecuenciasLeidas(List<ITipoDatosCampoValor> arraySecuenciasLeidas) {
        this.arraySecuenciasLeidas = arraySecuenciasLeidas;
    }

    @Override
    public void setErrorPredeterminado(String errorPredeterminado) {
        this.errorPredeterminado = errorPredeterminado;
    }

    public ValidacionSecuencias() {
        this.listaErrores = new ArrayList<IRegError>();
        this.listaWarning = new ArrayList<IRegError>();
    }

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            ISesion ses = null;
            for (Object object : parametros) {
                if (object instanceof GestorTraducciones) {
                    this.setArraySecuencias(((IGestorTraducciones)object).getSecuencias());
                    continue;
                }
                if (object instanceof IModelo) {
                    this.modelo = (IModelo)object;
                    continue;
                }
                if (!(object instanceof ISesion)) continue;
                ses = (ISesion)object;
                this.modelo = ses.getModelo();
            }
            if (this.getArraySecuencias() == null && this.modelo != null && this.modelo.getGestorTraduccionesBOE(ses) != null) {
                this.setArraySecuencias(this.modelo.getGestorTraduccionesBOE(ses).getSecuencias());
            }
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void dispose() throws ExceptionMotor {
        this.listaErrores = null;
        this.listaWarning = null;
        this.arraySecuencias = null;
        this.arraySecuenciasLeidas = null;
        this.arraySecuenciasDesHabilitadas = null;
    }

    @Override
    public List<Object> getArraySecuencias() {
        return this.arraySecuencias;
    }

    @Override
    public void setArraySecuencias(List<Object> ArraySec) {
        this.arraySecuencias = ArraySec;
    }

    @Override
    public void setArrayEstadoSecuencias(Map<String, String> ArraySec) {
        this.arraySecuenciasDesHabilitadas = ArraySec;
    }

    @Override
    public void limpiarComprobadorSecuencias() throws ExceptionMotor {
        try {
            this.arraySecuenciasLeidas.clear();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean comprobacionesFinales() throws ExceptionMotor {
        ITipoDatoRetornoMetodo ret;
        if (this.getModelo() != null && this.getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getModelo().getFuncionalidadPersonalizadaModelo().comprobacionesFinales(this)).isRetornaResultado()) {
            return ret.getObjetoRetornoAsBoolean();
        }
        return this.comprobacionesFinalesRecursiva().getObjetoRetornoAsBoolean();
    }

    @Override
    public ITipoDatoRetornoMetodo comprobacionesFinalesRecursiva() throws ExceptionMotor {
        try {
            boolean ret = true;
            this.listaErrores.clear();
            this.listaWarning.clear();
            if (this.arraySecuencias == null) {
                return new TipoDatoRetornoMetodo(true);
            }
            Map hashCampos = null;
            for (int i = 0; i < this.arraySecuencias.size(); i += 2) {
                hashCampos = (Map)this.arraySecuencias.get(i + 1);
                if (hashCampos.get("TIPOFUNCION") == null || !((String)hashCampos.get("TIPOFUNCION")).toString().equalsIgnoreCase("FINAL") || this.comprobarValidacion("", "", i, false, -1, -1) || this.listaErrores.size() <= 0) continue;
                ret = false;
            }
            return new TipoDatoRetornoMetodo(ret);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void addError(List<IRegError> lista, String linea, String codError, String tipoError) {
        RegError r = new RegError();
        r.setPropiedad("LOCALIZACION", linea);
        r.setIdError(codError);
        r.setTipoError(tipoError);
        lista.add(r);
        r = null;
    }

    @Override
    public boolean comprobarSecuencia(String tipoRegistro, String cadenaCompleta, int numLineaFichero, int numLineaSinSaltos) throws ExceptionMotor {
        ITipoDatoRetornoMetodo ret;
        if (this.getModelo() != null && this.getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getModelo().getFuncionalidadPersonalizadaModelo().comprobarSecuencia(this, tipoRegistro, cadenaCompleta, numLineaFichero, numLineaSinSaltos)).isRetornaResultado()) {
            return ret.getObjetoRetornoAsBoolean();
        }
        return this.comprobarSecuenciaRecursiva(tipoRegistro, cadenaCompleta, numLineaFichero, numLineaSinSaltos).getObjetoRetornoAsBoolean();
    }

    @Override
    public ITipoDatoRetornoMetodo comprobarSecuenciaRecursiva(String tipoRegistro, String cadenaCompleta, int numLineaFichero, int numLineaSinSaltos) throws ExceptionMotor {
        try {
            this.listaErrores.clear();
            this.listaWarning.clear();
            if (this.arraySecuencias == null) {
                this.arraySecuenciasLeidas.add(new TipoDatosCampoValor(tipoRegistro, cadenaCompleta));
                return new TipoDatoRetornoMetodo(true);
            }
            Map hashCampos = null;
            boolean ejecutar = false;
            for (int i = 0; i < this.arraySecuencias.size(); i += 2) {
                hashCampos = (Map)this.arraySecuencias.get(i + 1);
                ejecutar = false;
                if (hashCampos.get("TIPOFUNCION") == null) {
                    ejecutar = true;
                } else if (!((String)hashCampos.get("TIPOFUNCION")).toString().equalsIgnoreCase("FINAL")) {
                    ejecutar = true;
                }
                if (!ejecutar || this.comprobarValidacion(tipoRegistro, cadenaCompleta, i, false, numLineaFichero, numLineaSinSaltos)) continue;
                return new TipoDatoRetornoMetodo(false);
            }
            this.arraySecuenciasLeidas.add(new TipoDatosCampoValor(tipoRegistro, cadenaCompleta));
            return new TipoDatoRetornoMetodo(true);
        }
        catch (Exception ex) {
            this.addError(this.listaErrores, "", "Error interno", "E");
            if (ex instanceof ExceptionMotor) {
                throw (ExceptionMotor)ex;
            }
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean comprobarValidacion(String tipoRegistro, String cadenaCompleta, int i, boolean resetTablas, int numLineaFichero, int numLineaSinSaltos) throws ExceptionMotor {
        ITipoDatoRetornoMetodo ret;
        if (this.getModelo() != null && this.getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getModelo().getFuncionalidadPersonalizadaModelo().comprobarValidacion(this, tipoRegistro, cadenaCompleta, i, resetTablas, numLineaFichero, numLineaSinSaltos)).isRetornaResultado()) {
            return ret.getObjetoRetornoAsBoolean();
        }
        return this.comprobarValidacionRecursiva(tipoRegistro, cadenaCompleta, i, resetTablas, numLineaFichero, numLineaSinSaltos).getObjetoRetornoAsBoolean();
    }

    @Override
    public ITipoDatoRetornoMetodo comprobarValidacionRecursiva(String tipoRegistro, String cadenaCompleta, int i, boolean resetTablas, int numLineaFichero, int numLineaSinSaltos) throws ExceptionMotor {
        try {
            String[] strTmp = null;
            boolean bln = false;
            String strError = "";
            String strWarning = "";
            if (resetTablas) {
                this.listaErrores.clear();
                this.listaWarning.clear();
            }
            Map hashCampos = null;
            hashCampos = (Map)this.arraySecuencias.get(i + 1);
            String tmpCad = "";
            if (hashCampos.get("MENSAJE") != null) {
                tmpCad = ((String)hashCampos.get("MENSAJE")).toString();
            }
            if (tmpCad.length() == 0) {
                strError = this.errorPredeterminado;
            } else if (tmpCad.toUpperCase().startsWith("WARNING:")) {
                strWarning = tmpCad.substring(8);
            } else {
                strError = tmpCad;
            }
            tmpCad = ((String)hashCampos.get("NOMBREFUNCION")).toString();
            if (tmpCad.equalsIgnoreCase("REQUIEREANTES") && this.arraySecuenciasDesHabilitadas.get("REQUIEREANTES~" + this.arraySecuencias.get(i).toString().toUpperCase()) == null) {
                bln = false;
                strTmp = this.arraySecuencias.get(i).toString().split(",");
                if (tipoRegistro.equalsIgnoreCase(strTmp[0])) {
                    if (strTmp[1].equalsIgnoreCase(" ")) {
                        if (this.arraySecuenciasLeidas.size() > 0) {
                            if (strWarning.length() > 0) {
                                this.addError(this.listaWarning, "", strWarning, "W");
                            } else {
                                this.addError(this.listaErrores, "", strError, "E");
                            }
                            return new TipoDatoRetornoMetodo(false);
                        }
                        bln = true;
                    } else {
                        for (int j = 0; j < this.arraySecuenciasLeidas.size(); ++j) {
                            if (!this.arraySecuenciasLeidas.get(j).getNombreCampo().equalsIgnoreCase(strTmp[1])) continue;
                            bln = true;
                            break;
                        }
                    }
                    if (!bln) {
                        if (strWarning.length() > 0) {
                            this.addError(this.listaWarning, "", strWarning, "W");
                        } else {
                            this.addError(this.listaErrores, "", strError, "E");
                        }
                        return new TipoDatoRetornoMetodo(false);
                    }
                }
            } else if (tmpCad.equalsIgnoreCase(" ") && this.arraySecuenciasDesHabilitadas.get(" ~" + this.arraySecuencias.get(i).toString().toUpperCase()) == null) {
                strTmp = this.arraySecuencias.get(i).toString().split(",");
                if (tipoRegistro.equalsIgnoreCase(strTmp[0]) && this.arraySecuenciasLeidas.size() > 0) {
                    if (strWarning.length() > 0) {
                        this.addError(this.listaWarning, "", strWarning, "W");
                    } else {
                        this.addError(this.listaErrores, "", strError, "E");
                    }
                    return new TipoDatoRetornoMetodo(false);
                }
            } else if (tmpCad.equalsIgnoreCase("VARIOS_REQUIEREN") && this.arraySecuenciasDesHabilitadas.get("VARIOS_REQUIEREN~" + this.arraySecuencias.get(i).toString().toUpperCase()) == null) {
                strTmp = this.arraySecuencias.get(i).toString().split(",");
                if (tipoRegistro.equalsIgnoreCase(strTmp[0])) {
                    bln = false;
                    boolean bln2 = false;
                    for (int J = 0; J < this.arraySecuenciasLeidas.size(); ++J) {
                        if (this.arraySecuenciasLeidas.get(J).getNombreCampo().equalsIgnoreCase(strTmp[0])) {
                            bln = true;
                        }
                        if (!this.arraySecuenciasLeidas.get(J).getNombreCampo().equalsIgnoreCase(strTmp[1])) continue;
                        bln2 = true;
                    }
                    if (bln && !bln2) {
                        if (strWarning.length() > 0) {
                            this.addError(this.listaWarning, "", strWarning, "W");
                        } else {
                            this.addError(this.listaErrores, "", strError, "E");
                        }
                        return new TipoDatoRetornoMetodo(false);
                    }
                }
            } else if (tmpCad.equalsIgnoreCase("DOS_SEGUIDOS_NO") && this.arraySecuenciasDesHabilitadas.get("DOS_SEGUIDOS_NO~" + this.arraySecuencias.get(i).toString().toUpperCase()) == null) {
                strTmp = this.arraySecuencias.get(i).toString().split(",");
                if (tipoRegistro.equalsIgnoreCase(strTmp[0]) && this.arraySecuenciasLeidas.size() > 0 && this.arraySecuenciasLeidas.get(this.arraySecuenciasLeidas.size() - 1).getNombreCampo().equalsIgnoreCase(tipoRegistro)) {
                    if (strWarning.length() > 0) {
                        this.addError(this.listaWarning, "", strWarning, "W");
                    } else {
                        this.addError(this.listaErrores, "", strError, "E");
                    }
                    return new TipoDatoRetornoMetodo(false);
                }
            } else if (tmpCad.equalsIgnoreCase("MAXIMO_SEGUIDOS_DE") && this.arraySecuenciasDesHabilitadas.get("MAXIMO_SEGUIDOS_DE~" + this.arraySecuencias.get(i).toString().toUpperCase()) == null) {
                strTmp = this.arraySecuencias.get(i).toString().split(",");
                if (tipoRegistro.equalsIgnoreCase(strTmp[1])) {
                    int con = 1;
                    for (int j = this.arraySecuenciasLeidas.size() - 1; j > -1 && this.arraySecuenciasLeidas.get(j).getNombreCampo().equalsIgnoreCase(strTmp[1]); --j) {
                        ++con;
                    }
                    if (con > new Integer(strTmp[0].toString())) {
                        if (strWarning.length() > 0) {
                            this.addError(this.listaWarning, "", strWarning, "W");
                        } else {
                            this.addError(this.listaErrores, "", strError, "E");
                        }
                        return new TipoDatoRetornoMetodo(false);
                    }
                }
            } else if (tmpCad.equalsIgnoreCase("SI_MINIMO_DE") && this.arraySecuenciasDesHabilitadas.get("SI_MINIMO_DE~" + this.arraySecuencias.get(i).toString().toUpperCase()) == null) {
                strTmp = this.arraySecuencias.get(i).toString().split(",");
                int con = 0;
                bln = false;
                for (int j = 0; j < this.arraySecuenciasLeidas.size(); ++j) {
                    if (this.arraySecuenciasLeidas.get(j).getNombreCampo().equalsIgnoreCase(strTmp[0])) {
                        if (bln && con < new Integer(strTmp[1].toString())) {
                            if (strWarning.length() > 0) {
                                this.addError(this.listaWarning, "", strWarning, "W");
                            } else {
                                this.addError(this.listaErrores, "", strError, "E");
                            }
                            return new TipoDatoRetornoMetodo(false);
                        }
                        con = 0;
                        bln = true;
                        continue;
                    }
                    if (!this.arraySecuenciasLeidas.get(j).getNombreCampo().equalsIgnoreCase(strTmp[2])) continue;
                    ++con;
                }
                if (bln && con < new Integer(strTmp[1].toString())) {
                    if (strWarning.length() > 0) {
                        this.addError(this.listaWarning, "", strWarning, "W");
                    } else {
                        this.addError(this.listaErrores, "", strError, "E");
                    }
                    return new TipoDatoRetornoMetodo(false);
                }
            } else if (tmpCad.equalsIgnoreCase("SIPRIMERO_VACIARSECUENCIASLEIDAS") && this.arraySecuenciasDesHabilitadas.get("SIPRIMERO_VACIARSECUENCIASLEIDAS~" + this.arraySecuencias.get(i).toString().toUpperCase()) == null) {
                strTmp = this.arraySecuencias.get(i).toString().split(",");
                if (numLineaSinSaltos == 1 && tipoRegistro.equalsIgnoreCase(strTmp[0])) {
                    this.arraySecuenciasLeidas.clear();
                }
            }
            return new TipoDatoRetornoMetodo(true);
        }
        catch (Exception ex) {
            this.addError(this.listaErrores, "", "Error interno", "E");
            if (ex instanceof ExceptionMotor) {
                throw (ExceptionMotor)ex;
            }
            throw new ExceptionMotor(ex);
        }
    }

    protected void borrarSecuencias() throws ExceptionMotor {
        try {
            this.limpiarComprobadorSecuencias();
            if (this.arraySecuencias != null) {
                this.arraySecuencias.clear();
            }
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected void agregarSecuencia(String nombreFuncion, String parametros, String error_o_Warning, boolean ejecutarAlFinal) throws ExceptionMotor {
        try {
            if (this.arraySecuencias == null) {
                this.arraySecuencias = new ArrayList<Object>();
            }
            HashMap<String, String> hashCampos = new HashMap<String, String>();
            hashCampos.put("NOMBREFUNCION", nombreFuncion);
            hashCampos.put("MENSAJE", error_o_Warning);
            if (ejecutarAlFinal) {
                hashCampos.put("TIPOFUNCION", "FINAL");
            }
            this.arraySecuencias.add(parametros);
            this.arraySecuencias.add(hashCampos);
            hashCampos = null;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public List<IRegError> getListaErrores() {
        return this.listaErrores;
    }

    @Override
    public List<IRegError> getListaWarning() {
        return this.listaWarning;
    }

    @Override
    public List<ITipoDatosCampoValor> getArraySecuenciasLeidas() {
        return this.arraySecuenciasLeidas;
    }

    @Override
    public Map<String, String> getArraySecuenciasDeshabilitadas() {
        return this.arraySecuenciasDesHabilitadas;
    }

    @Override
    public String getErrorPredeterminado() {
        return this.errorPredeterminado;
    }

    protected void setModelo(IModelo modelo) {
        this.modelo = modelo;
    }

    protected IModelo getModelo() {
        return this.modelo;
    }
}

