/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.gestionFicheros.importacion.boe;

import es.aeat.pftw.mtrc.configuracion.RegError;
import es.aeat.pftw.mtrc.gestionFicheros.importacion.boe.CodigoComun;
import es.aeat.pftw.mtrc.gestionFicheros.importacion.boe.IValidacionPrevia;
import es.aeat.pftw.mtrc.tipos.ITipoDatosIdentificarTabla;
import es.aeat.pftw.mtrc.tipos.ITipoDatosTabla;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrp.configuracion.IRegError;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.excepciones.ExceptionTamSuperado;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampos;
import java.util.List;
import java.util.Map;

public class ValidacionPrevia
extends CodigoComun
implements IValidacionPrevia {
    private static final long serialVersionUID = 1L;
    private int posicionSello = -1;
    private boolean ficheroEstaVacio = true;
    static final String LITERAL_ERROR_LONGITUD_REGISTRO = "#ErrorLongitudRegistro#";

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            super.init(parametros);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public int getPosicionSello() {
        return this.posicionSello;
    }

    @Override
    public boolean setPosicionSello(int posSello) {
        this.posicionSello = posSello;
        return true;
    }

    @Override
    public boolean validaPreviaFichero(String ficheroTXT) throws ExceptionMotor {
        try {
            if (this.getGestorBOE() == null) {
                throw new ExceptionMotor("No dispongo de gestor de traducciones, llame primero a establecerGestor");
            }
            return this.validaPreviaFichero(FuncionesUtiles.getFuncionesUtiles().file2bytesISO(ficheroTXT));
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Fichero " + ficheroTXT);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Fichero " + ficheroTXT);
        }
    }

    @Override
    public boolean validaPreviaFichero(byte[] bytes) throws ExceptionMotor {
        try {
            if (this.getGestorBOE() == null) {
                throw new ExceptionMotor("No dispongo de gestor de traducciones, llame primero a establecerGestor");
            }
            if (!this.isLecturaDeLineasEstricta() && this.getGestorFichero().superaMaxFicheros(bytes.length)) {
                throw new ExceptionTamSuperado();
            }
            this.getGestorFichero().errClear();
            this.abrirFichero(bytes);
            if (this.getPosicionSello() == -1) {
                this.setPosicionSello(this.getGestorBoe().buscaPosicionDelSello(!this.isLecturaDeLineasEstricta()));
            }
            boolean ret = this.validaPreviaFichero();
            this.cerrarFichero();
            return ret;
        }
        catch (Exception ex) {
            if (this.isFicheroAbierto()) {
                this.cerrarFichero();
            }
            if (ex instanceof ExceptionMotor) {
                throw (ExceptionMotor)ex;
            }
            throw new ExceptionMotor(ex);
        }
    }

    protected boolean validarLinea(String cade, List<ITipoDatosTabla> listaTablas, boolean introducirLeidos) throws ExceptionMotor {
        try {
            String cadena = cade;
            String cad = "";
            boolean encontrada = false;
            IRegError err = null;
            if (cadena.startsWith("~~~~ERROR DE SECUENCIA~~~~")) {
                cad = this.getGestorBOE().traduceCadena(LITERAL_ERROR_LONGITUD_REGISTRO);
                if (cad.equalsIgnoreCase(LITERAL_ERROR_LONGITUD_REGISTRO)) {
                    cad = cadena.substring(27);
                }
                if ((err = this.getModelo().getGestorConfiguracion().getErrorIfExists(cad)) == null) {
                    err = new RegError();
                    err.setIdError(cad);
                } else {
                    err = err.clone();
                }
                this.getGestorFichero().addError(String.valueOf(this.getLineaFichero()), err, null);
                err = null;
                throw new ExceptionMotor(cad);
            }
            if (this.getGestorFichero().isFueCancelado()) {
                throw new ExceptionMotor("Cancelado");
            }
            encontrada = false;
            if (cadena.compareTo(this.getSaltoDeLinea()) == 0) {
                cadena = null;
            } else {
                this.setFicheroEstaVacio(false);
                int con = 0;
                ITipoDatosIdentificarTabla ret = this.identificameTablaDeCadena(cadena);
                if (ret != null) {
                    int i = ret.getIndice();
                    if (introducirLeidos) {
                        this.getGestorFichero().addRegistroLeido(listaTablas.get(i).getNombreTabla().toUpperCase());
                    }
                    encontrada = true;
                    con = this.sacarLongitud(cadena, listaTablas.get(i).getPropiedadesTabla().get("LONGITUD"));
                    if (con == -1) {
                        String cadaux = this.extraeCadenaDeLongitud(listaTablas.get(i).getPropiedadesTabla().get("LONGITUD"));
                        if (cadaux == null) {
                            encontrada = false;
                        } else {
                            cadena = cadena + cadaux;
                        }
                    } else {
                        List<ITipoDatosCampos> campos = listaTablas.get(i).getCampos();
                        String o = null;
                        Map<String, String> prop = null;
                        for (int p = 0; p < campos.size(); ++p) {
                            prop = campos.get(p).getPropiedadesCampos();
                            o = prop.get("LITERAL");
                            if (o == null || !o.equalsIgnoreCase("FinalRegistro")) continue;
                            if (prop.get("TIPODATO") == null || !prop.get("TIPODATO").startsWith("CTE:") || cadena.endsWith(FuncionesUtiles.getFuncionesUtiles().desCodificaCadena(prop.get("TIPODATO").substring("CTE:".length())))) break;
                            err = this.getModelo().getGestorConfiguracion().getErrorIfExists(prop.get("ERRORVC"));
                            if (err == null) {
                                err = new RegError();
                                err.setIdError(prop.get("ERRORVC"));
                            } else {
                                err = err.clone();
                            }
                            this.getGestorFichero().addError(String.valueOf(this.getLineaFichero()), err, prop);
                            cad = err.getMsg();
                            err = null;
                            return false;
                        }
                    }
                    if (con != -1 && cadena.length() != con) {
                        this.setColetillaWarning("");
                        this.setTransf("LONGITUDREGISTRO");
                        this.getGestorFichero().transfCargaTransformaciones(cad, this.getTransf());
                        while (this.setTransf(this.getGestorFichero().transfDameSiguienteTransformacion()) != null) {
                            if (con == this.getTransf().length()) {
                                this.setColetillaWarning(this.getGestorFichero().transfDameColetilla());
                                break;
                            }
                            this.setColetillaWarning("");
                        }
                        if (this.getColetillaWarning().length() == 0) {
                            this.setCorrecto(false);
                            this.getgestorFicherosIntermediosDatos().nuevaLinea(cadena, false);
                        } else {
                            this.getgestorFicherosIntermediosDatos().nuevaLinea(this.getTransf(), true);
                        }
                        cad = this.getGestorBOE().traduceCadena(LITERAL_ERROR_LONGITUD_REGISTRO);
                        if (cad.equalsIgnoreCase(LITERAL_ERROR_LONGITUD_REGISTRO)) {
                            cad = "Longitud de Registro incorrecta " + cadena.substring(0, 15) + "...";
                        }
                        if (this.getColetillaWarning().length() == 0) {
                            err = this.getModelo().getGestorConfiguracion().getErrorIfExists(cad);
                            if (err == null) {
                                err = new RegError();
                                err.setIdError(cad);
                            } else {
                                err = err.clone();
                            }
                            this.getGestorFichero().addError(String.valueOf(this.getLineaFichero()), err, null);
                            err = null;
                        } else {
                            err = this.getModelo().getGestorConfiguracion().getErrorIfExists(cad + this.getColetillaWarning());
                            if (err == null) {
                                err = new RegError();
                                err.setIdError(cad + this.getColetillaWarning());
                            } else {
                                err = err.clone();
                            }
                            this.getGestorFichero().addWarning(String.valueOf(this.getLineaFichero()), err, null);
                            err = null;
                        }
                        if (!this.isCorrecto()) {
                            return false;
                        }
                    } else {
                        this.getgestorFicherosIntermediosDatos().nuevaLinea(cadena, false);
                    }
                }
            }
            if (!encontrada && cadena != null) {
                cad = this.getGestorBOE().traduceCadena("#ErrorRegistroDesconocido#");
                if (cad.equalsIgnoreCase("#ErrorRegistroDesconocido#")) {
                    cad = "EMALREG";
                }
                if ((err = this.getModelo().getGestorConfiguracion().getErrorIfExists(cad)) == null) {
                    err = new RegError();
                    err.setIdError(cad);
                } else {
                    err = err.clone();
                }
                this.getGestorFichero().addError(String.valueOf(this.getLineaFichero()), err, null);
                err = null;
                return false;
            }
            if (cadena == null) {
                this.getgestorFicherosIntermediosDatos().saltoDeLinea(false);
            }
            return true;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Cadena " + cade);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Cadena " + cade);
        }
    }

    @Override
    public boolean validaPreviaFichero() throws ExceptionMotor {
        try {
            boolean introducirLeidos;
            this.setCorrecto(true);
            this.getGestorFichero().setFueCancelado(false);
            this.setSuperoNumeroMaximoErrores(false);
            this.getGestorFichero().errClear();
            if (this.getGestorBOE() == null) {
                throw new ExceptionMotor("No dispongo de gestor de traducciones, llame primero a establecerGestor");
            }
            IRegError err = null;
            String cadena = "";
            String cad = "";
            this.setFicheroEstaVacio(true);
            boolean bl = introducirLeidos = this.getGestorFichero().gettotalesLeidos().size() == 0;
            while ((cadena = this.lineaSiguiente()) != null) {
                if (this.validarLinea(cadena, this.getGestorBOE().getTablas(), introducirLeidos)) continue;
                this.setCorrecto(false);
                return false;
            }
            if (this.isFicheroEstaVacio()) {
                cad = this.getGestorBOE().traduceCadena("#ErrorFicheroVacio#");
                if (cad.equalsIgnoreCase("#ErrorFicheroVacio#")) {
                    cad = "EMALEMP";
                }
                if ((err = this.getModelo().getGestorConfiguracion().getErrorIfExists(cad)) == null) {
                    err = new RegError();
                    err.setIdError(cad);
                } else {
                    err = err.clone();
                }
                this.getGestorFichero().addError(String.valueOf(this.getLineaFichero()), err, null);
                err = null;
                this.setCorrecto(false);
                return false;
            }
            if (this.getGestorFichero().isFueCancelado()) {
                throw new ExceptionMotor("Cancelado...");
            }
            return this.isCorrecto();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void setlecturaDeLineasEstricta(boolean estricta) {
        this.setLecturaDeLineasEstricta(estricta);
    }

    @Override
    public void cancelar() {
        this.getGestorFichero().cancelar();
    }

    protected String formateaValor(String valor, Map<String, String> propiedades) {
        return valor;
    }

    protected void setFicheroEstaVacio(boolean ficheroEstaVacio) {
        this.ficheroEstaVacio = ficheroEstaVacio;
    }

    protected boolean isFicheroEstaVacio() {
        return this.ficheroEstaVacio;
    }
}

