/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.gestionFicheros.importacion.boe;

import es.aeat.pftw.mtrc.configuracion.RegError;
import es.aeat.pftw.mtrc.gestionFicheros.exportacion.boe.ExportacionBOE;
import es.aeat.pftw.mtrc.gestionFicheros.exportacion.boe.GeneradorLineas;
import es.aeat.pftw.mtrc.gestionFicheros.exportacion.boe.IExportacionBOE;
import es.aeat.pftw.mtrc.gestionFicheros.exportacion.boe.IGeneradorLineas;
import es.aeat.pftw.mtrc.gestionFicheros.importacion.boe.CodigoComun;
import es.aeat.pftw.mtrc.gestionFicheros.importacion.boe.IValidacionCaracteres;
import es.aeat.pftw.mtrc.gestionFicheros.importacion.boe.IValidacionCaracteresCaller;
import es.aeat.pftw.mtrc.tipos.ITipoDatosAnotacionBitacora;
import es.aeat.pftw.mtrc.tipos.ITipoDatosIdentificarTabla;
import es.aeat.pftw.mtrc.tipos.ITipoDatosTabla;
import es.aeat.pftw.mtrc.tipos.TipoDatoRetornoMetodo;
import es.aeat.pftw.mtrc.tipos.TipoDatosAnotacionBitacora;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrp.configuracion.IRegEntrada;
import es.aeat.pftw.mtrp.configuracion.IRegError;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.tipos.ITipoDatoRetornoMetodo;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampos;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValidacionCaracteres
extends CodigoComun
implements IValidacionCaracteres,
IValidacionCaracteresCaller {
    private static final long serialVersionUID = 1L;
    protected List<ITipoDatosAnotacionBitacora> bitacora = null;
    protected String ultimaTabla = "";
    protected Map<String, String> primerCampoTabla = null;
    protected boolean usarPosteriormenteBitacora = false;
    private boolean errores2ValorPorDefecto = false;
    protected int contadorPosicionActualLinea = 0;

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            super.init(parametros);
            this.errores2ValorPorDefecto = false;
            this.bitacora = new ArrayList<ITipoDatosAnotacionBitacora>();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean validaCaracteres(String ficheroTXT) throws ExceptionMotor {
        try {
            if (this.getGestorBOE() == null) {
                throw new ExceptionMotor("No dispongo de gestor de traducciones, llame primero a establecerGestor");
            }
            return this.validaCaracteres(FuncionesUtiles.getFuncionesUtiles().file2bytesISO(ficheroTXT));
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Fichero " + ficheroTXT);
        }
    }

    @Override
    public boolean validaCaracteres(byte[] bytes) throws ExceptionMotor {
        try {
            if (this.getGestorBOE() == null) {
                throw new ExceptionMotor("No dispongo de gestor de traducciones, llame primero a establecerGestor");
            }
            this.getGestorFichero().errClear();
            this.abrirFichero(bytes);
            boolean ret = this.validaCaracteres();
            this.cerrarFichero();
            return ret;
        }
        catch (Exception ex) {
            if (this.isFicheroAbierto()) {
                this.cerrarFichero();
            }
            if (ex instanceof ExceptionMotor) {
                throw (ExceptionMotor)ex;
            }
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void estimaGuardarBitacora(String partida, String valor, Map<String, String> propCampos, int numeroLineaFichero) throws ExceptionMotor {
        try {
            ITipoDatoRetornoMetodo ret;
            if (!this.isUsarPosteriormenteBitacora()) {
                return;
            }
            if (this.getModelo() != null && this.getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getModelo().getFuncionalidadPersonalizadaModelo().estimaGuardarBitacora(this, partida, valor, propCampos, numeroLineaFichero)).isRetornaResultado()) {
                return;
            }
            this.estimaGuardarBitacoraRecursivo(partida, valor, propCampos, numeroLineaFichero);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, partida);
        }
    }

    protected boolean esPrimerCampoDeTabla(String partida, String tabla) throws ExceptionMotor {
        try {
            if (partida.contains("(")) {
                return FuncionesUtiles.getFuncionesUtiles().dameNombrePartidaSinParentesis(partida).equalsIgnoreCase(FuncionesUtiles.getFuncionesUtiles().dameNombrePartidaSinParentesis(this.primerCampoTabla.get(tabla)));
            }
            return partida.equalsIgnoreCase(this.primerCampoTabla.get(tabla));
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, partida + "(" + tabla + ")");
        }
    }

    protected String quitaFiltroAEntradaBitacora(String entradaBitacora) {
        if (entradaBitacora.startsWith("[FILTRO]")) {
            return entradaBitacora.substring("[FILTRO]".length());
        }
        return entradaBitacora;
    }

    @Override
    public ITipoDatoRetornoMetodo estimaGuardarBitacoraRecursivo(String partida, String valor, Map<String, String> propCampos, int numeroLineaFichero) throws ExceptionMotor {
        try {
            if (!this.isUsarPosteriormenteBitacora()) {
                return new TipoDatoRetornoMetodo(ITipoDatoRetornoMetodo.tipoDato_Void);
            }
            if (propCampos != null && propCampos.containsKey("NOIMPORTAR")) {
                return new TipoDatoRetornoMetodo(ITipoDatoRetornoMetodo.tipoDato_Void);
            }
            if (partida.trim().length() == 0) {
                throw new Exception("\u00bfDeberia llevar NOIMPORTAR? Campo " + propCampos);
            }
            String tabla = this.getModelo().getGestorConfiguracion().getEntrada(partida).getIdTabla();
            boolean esPrimerCampoDeTabla = false;
            if (this.bitacora.size() == 0 || !tabla.equalsIgnoreCase(this.ultimaTabla) || this.esPrimerCampoDeTabla(partida, tabla)) {
                if (this.bitacora.size() > 0 && this.primerCampoTabla.get(tabla) != null && !tabla.equalsIgnoreCase(this.ultimaTabla) && !this.esPrimerCampoDeTabla(partida, tabla)) {
                    boolean guarda = false;
                    for (int i = this.bitacora.size() - 1; i >= 0; --i) {
                        if (this.bitacora.get(i).isEsTabla() && this.bitacora.get(i).getNombreCampo().equalsIgnoreCase(tabla)) {
                            guarda = true;
                        }
                        if (!guarda && !this.bitacora.get(i).isEsTabla() && tabla.equalsIgnoreCase(this.getModelo().getGestorConfiguracion().getEntrada(this.quitaFiltroAEntradaBitacora(this.bitacora.get(i).getNombreCampo())).getIdTabla())) {
                            guarda = true;
                        }
                        if (!guarda) continue;
                        TipoDatosAnotacionBitacora td = new TipoDatosAnotacionBitacora(partida, tabla, valor, numeroLineaFichero);
                        if (this.primerCampoTabla.get(tabla) != null && this.esPrimerCampoDeTabla(partida, tabla)) {
                            td.setEsPrimerCampoDeTabla(true);
                        }
                        this.bitacora.add(i + 1, td);
                        return new TipoDatoRetornoMetodo(ITipoDatoRetornoMetodo.tipoDato_Void);
                    }
                    throw new ExceptionMotor("Error al ordenar partida " + partida + " de tabla " + tabla);
                }
                this.bitacora.add(new TipoDatosAnotacionBitacora(tabla, numeroLineaFichero));
                esPrimerCampoDeTabla = true;
                this.ultimaTabla = tabla;
                this.primerCampoTabla.put(tabla, partida);
            }
            TipoDatosAnotacionBitacora td = new TipoDatosAnotacionBitacora(partida, tabla, valor, numeroLineaFichero);
            if (esPrimerCampoDeTabla) {
                td.setEsPrimerCampoDeTabla(true);
                String filtro = propCampos.get("FILTRO");
                if (filtro != null && filtro.trim().length() > 0) {
                    String[] filtros = filtro.split(";");
                    String indice = "";
                    if (partida.endsWith(")")) {
                        indice = partida.substring(partida.indexOf("("));
                    }
                    for (String filter : filtros) {
                        String[] filt = filter.split("=");
                        TipoDatosAnotacionBitacora tdFiltro = new TipoDatosAnotacionBitacora("[FILTRO]" + filt[0].trim() + indice, tabla, filt[1].trim(), numeroLineaFichero);
                        this.bitacora.add(tdFiltro);
                    }
                }
            }
            this.bitacora.add(td);
            return new TipoDatoRetornoMetodo(ITipoDatoRetornoMetodo.tipoDato_Void);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, partida);
        }
    }

    @Override
    public String getTransformacionSegunTipoDato(String tipoDato) throws ExceptionMotor {
        try {
            ITipoDatoRetornoMetodo ret;
            if (this.getModelo() != null && this.getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getModelo().getFuncionalidadPersonalizadaModelo().getTransformacionSegunTipoDato(this, tipoDato)).isRetornaResultado()) {
                return ret.getObjetoRetornoAsString();
            }
            return this.getTransformacionSegunTipoDatoRecursivo(tipoDato).getObjetoRetornoAsString();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean validaCaracteres() throws ExceptionMotor {
        try {
            boolean introducirLeidos;
            this.bitacora.clear();
            this.ultimaTabla = "";
            this.primerCampoTabla = new HashMap<String, String>();
            this.getGestorFichero().setFueCancelado(false);
            this.setSuperoNumeroMaximoErrores(false);
            this.getGestorFichero().errClear();
            this.setCorrecto(true);
            if (this.getGestorFichero() == null) {
                throw new ExceptionMotor("No dispongo de gestor de traducciones, llame primero a establecerGestor");
            }
            String cadena = "";
            List<ITipoDatosCampos> campos = null;
            List<Object> errores = null;
            Map<String, String> propCamposOriginal = null;
            Map<String, String> propCampos = null;
            List<ITipoDatosTabla> listaTablas = this.getGestorBOE().getTablas();
            List<ITipoDatosTabla> listaTablasAdicionales = this.getGestorBOE().getTablasAuxiliares();
            Map<String, String> variables = this.getGestorBOE().getVariables();
            String cad = "";
            String cadenaLeida = "";
            String cadenaAGrabar = "";
            boolean grabarCadenaAGrabar = false;
            String sustitucionLectura = "";
            int longitudRegistro = 0;
            String registroAnterior = "";
            boolean esSiguiente = false;
            boolean bl = introducirLeidos = this.getGestorFichero().gettotalesLeidos().size() == 0;
            while ((cadenaLeida = this.lineaSiguiente()) != null) {
                if (this.getGestorFichero().isFueCancelado()) {
                    throw new ExceptionMotor("Cancelado...");
                }
                this.contadorPosicionActualLinea = 0;
                cadena = cadenaLeida;
                cadenaAGrabar = "";
                grabarCadenaAGrabar = false;
                if (cadena.compareTo(this.getSaltoDeLinea()) == 0) {
                    cadenaAGrabar = cadena;
                } else {
                    ITipoDatosIdentificarTabla ret = this.identificameTablaDeCadena(cadena);
                    if (ret != null) {
                        int accesoDirectoTablaAdicional;
                        int i = ret.getIndice();
                        cad = cadena.substring(0, ret.getPosicionesAConsumir());
                        esSiguiente = registroAnterior.length() != 0 && cad.equalsIgnoreCase(registroAnterior);
                        this.contadorPosicionActualLinea += ret.getPosicionesAConsumir();
                        if (introducirLeidos) {
                            this.getGestorFichero().addRegistroLeido(listaTablas.get(i).getNombreTabla().toUpperCase());
                        }
                        cadena = this.consumeDeCadena(cadena, cad.length());
                        cadenaAGrabar = cadenaAGrabar + cad;
                        campos = listaTablas.get(i).getCampos();
                        errores = new ArrayList();
                        propCampos = null;
                        for (int j = 0; j < campos.size(); ++j) {
                            String valorAGuardar;
                            errores.clear();
                            propCamposOriginal = FuncionesUtiles.getFuncionesUtiles().traducirTipoCampo(campos.get(j).getPropiedadesCampos(), this.getGestorBOE());
                            propCampos = propCamposOriginal == null ? null : (Map<String, String>)((HashMap)propCamposOriginal).clone();
                            if (propCampos != null && esSiguiente) {
                                propCampos.put("ESSIGUIENTE", "true");
                            }
                            if (propCampos != null && propCampos.containsKey("NOEXPORTAR")) {
                                propCampos.put("LONGITUD", "0");
                            }
                            sustitucionLectura = ((String)propCampos.get("SUSTITUCION")).toString();
                            propCampos.remove("SUSTITUCION");
                            longitudRegistro = this.sacarLongitud(cadena, propCampos.get("LONGITUD"));
                            cad = longitudRegistro == -1 ? cadena : cadena.substring(0, longitudRegistro);
                            cadena = this.consumeDeCadena(cadena, cad.length());
                            if (variables.containsKey(campos.get(j).getNombreCampo().toUpperCase())) {
                                variables.put(campos.get(j).getNombreCampo().toUpperCase(), cad);
                            }
                            this.setColetillaWarning("");
                            if (propCampos.get("NOIMPORTAR") == null || !propCampos.get("NOIMPORTAR").toString().equalsIgnoreCase("NI VALIDAR")) {
                                if (propCampos.containsKey("SIGUIENTES") && propCampos.containsKey("ESSIGUIENTE")) {
                                    if (propCampos.get("SIGUIENTES").toString().toUpperCase().startsWith("NO VALIDAR")) {
                                        cad = this.dameCadenaCte(propCampos);
                                    } else {
                                        Map clon = (Map)((HashMap)propCampos).clone();
                                        if (!propCampos.get("SIGUIENTES").startsWith("CTE:")) {
                                            propCampos.put("SIGUIENTES", "CTE:" + FuncionesUtiles.getFuncionesUtiles().codificaCadena(propCampos.get("SIGUIENTES")));
                                        }
                                        clon.put("TIPODATO", propCampos.get("SIGUIENTES"));
                                        clon.remove("SIGUIENTES");
                                        errores = this.getGestorBOE().validaCampo(clon, cad);
                                    }
                                } else {
                                    errores = this.getGestorBOE().validaCampo(propCampos, cad);
                                }
                            }
                            if (errores.size() > 0) {
                                this.setTransf("");
                                if (propCampos.get("TIPODATO") != null) {
                                    this.setTransf(this.getTransformacionSegunTipoDato(propCampos.get("TIPODATO")));
                                }
                                if (propCampos.get("TRANSVC") != null) {
                                    if (this.getTransf().length() > 0) {
                                        this.setTransf(this.getTransf() + ";");
                                    }
                                    this.setTransf(this.getTransf() + propCampos.get("TRANSVC").toString());
                                }
                                if (this.getTransf().length() > 0 && this.isPermitirTransformaciones()) {
                                    this.getGestorFichero().transfCargaTransformaciones(cad, this.getTransf());
                                    while (this.setTransf(this.getGestorFichero().transfDameSiguienteTransformacion()) != null) {
                                        this.setWarning(this.getGestorBOE().validaCampo(propCampos, this.getTransf()));
                                        if (this.getWarning().size() == 0) {
                                            this.setColetillaWarning(this.getGestorFichero().transfDameColetilla());
                                            break;
                                        }
                                        this.setColetillaWarning("");
                                        this.getGestorFichero().setValor(this.getTransf());
                                    }
                                }
                                for (int k = 0; k < errores.size(); ++k) {
                                    if (this.getColetillaWarning().length() == 0) {
                                        if (this.isErrores2ValorPorDefecto()) {
                                            IRegEntrada re = this.getModelo().getGestorConfiguracion().getEntrada(campos.get(j).getNombreCampo());
                                            IExportacionBOE expBOE = (IExportacionBOE)FuncionesUtiles.getFuncionesUtiles().getInstancia(ExportacionBOE.class, new Object[]{this.getModelo(), false});
                                            IGeneradorLineas genLinOBJ = (IGeneradorLineas)FuncionesUtiles.getFuncionesUtiles().getInstancia(GeneradorLineas.class, new Object[]{expBOE});
                                            sustitucionLectura = genLinOBJ.dameCampo(listaTablas.get(i).getNombreTabla(), campos.get(j).getNombreCampo(), re.getValorInicial());
                                            if (sustitucionLectura.length() == 0) {
                                                this.setCorrecto(false);
                                            }
                                            re = null;
                                            genLinOBJ = null;
                                        } else {
                                            this.setCorrecto(false);
                                        }
                                        this.addError(((String)errores.get(k)).toString(), campos.get(j).getNombreCampo(), propCampos, "");
                                    } else {
                                        grabarCadenaAGrabar = true;
                                        this.addWarning(((String)errores.get(k)).toString(), campos.get(j).getNombreCampo(), propCampos, this.getColetillaWarning());
                                    }
                                    if (this.getGestorFichero().errCount() < this.getGestorFichero().getMaxErrores()) continue;
                                    this.setSuperoNumeroMaximoErrores(true);
                                    FuncionesUtiles.getFuncionesUtiles().dejaSoloNerroresEntreListas(this.getListaErrores(), this.getListaWarning(), this.getGestorFichero().getMaxErrores());
                                    return false;
                                }
                            }
                            if (this.getColetillaWarning().length() > 0) {
                                cadenaAGrabar = cadenaAGrabar + this.getTransf();
                                valorAGuardar = this.getTransf();
                            } else if (sustitucionLectura.length() == 0) {
                                cadenaAGrabar = cadenaAGrabar + cad;
                                valorAGuardar = cad;
                            } else {
                                cadenaAGrabar = cadenaAGrabar + sustitucionLectura;
                                valorAGuardar = sustitucionLectura;
                                grabarCadenaAGrabar = true;
                            }
                            if (this.isUsarPosteriormenteBitacora()) {
                                this.estimaGuardarBitacora(campos.get(j).getNombreCampo().toUpperCase(), valorAGuardar, propCampos, this.getLineaReal());
                            }
                            this.contadorPosicionActualLinea += cad.length();
                        }
                        if (this.getGestorFichero().getRutaDatosAdicionales().length() > 0 && (accesoDirectoTablaAdicional = this.getGestorBOE().getTableAdicionalIndex(listaTablas.get(i).getNombreTabla())) > -1) {
                            cadena = this.lineaSiguienteAdicional();
                            campos = listaTablasAdicionales.get(accesoDirectoTablaAdicional).getCampos();
                            errores = new ArrayList();
                            propCampos = null;
                            for (int j = 0; j < campos.size(); ++j) {
                                errores.clear();
                                propCampos = campos.get(j).getPropiedadesCampos();
                                longitudRegistro = this.sacarLongitud(cadena, propCampos.get("LONGITUD"));
                                cad = longitudRegistro == -1 ? cadena : cadena.substring(0, longitudRegistro);
                                cadena = this.consumeDeCadena(cadena, cad.length());
                                if (propCampos.get("NOIMPORTAR") == null || !propCampos.get("NOIMPORTAR").toString().equalsIgnoreCase("NI VALIDAR")) {
                                    errores = this.getGestorBOE().validaCampo(propCampos, cad);
                                }
                                if (errores.size() <= 0) continue;
                                this.setCorrecto(false);
                                for (int k = 0; k < errores.size(); ++k) {
                                    this.addError(((String)errores.get(k)).toString(), campos.get(j).getNombreCampo(), propCampos, "");
                                    if (this.getGestorFichero().errCount() < this.getGestorFichero().getMaxErrores()) continue;
                                    this.setSuperoNumeroMaximoErrores(true);
                                    throw new ExceptionMotor("CORTAR EJECUCION SIN MAS");
                                }
                            }
                        }
                        registroAnterior = cadenaLeida.substring(0, ret.getPosicionesAConsumir());
                    }
                }
                if (cadenaAGrabar == null) continue;
                if (cadenaAGrabar.equalsIgnoreCase(this.getSaltoDeLinea())) {
                    this.getgestorFicherosIntermediosDatos().saltoDeLinea(grabarCadenaAGrabar);
                    continue;
                }
                cadenaAGrabar = cadenaAGrabar + cadena;
                this.getgestorFicherosIntermediosDatos().nuevaLinea(cadenaAGrabar, grabarCadenaAGrabar);
            }
            if (this.getGestorFichero().isFueCancelado()) {
                throw new ExceptionMotor("Cancelado");
            }
            if (!this.isCorrecto()) {
                return false;
            }
            this.revisarBitacora(listaTablas);
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean isUsarPosteriormenteBitacora() {
        return this.usarPosteriormenteBitacora;
    }

    @Override
    public void setUsarPosteriormenteBitacora(boolean usarPosteriormenteBitacora) {
        this.usarPosteriormenteBitacora = usarPosteriormenteBitacora;
    }

    @Override
    public String dameCadenaCte(Map<String, String> campo) {
        String siguientes = campo.get("SIGUIENTES").toString();
        if (siguientes.toUpperCase().startsWith("NO VALIDAR")) {
            siguientes = siguientes.substring("NO VALIDAR".length() + 1);
        }
        if (siguientes.toUpperCase().startsWith("CTE:") && (siguientes = FuncionesUtiles.getFuncionesUtiles().desCodificaCadena(siguientes.substring("CTE:".length()))).length() == 1 && campo.containsKey("LONGITUD")) {
            siguientes = FuncionesUtiles.getFuncionesUtiles().rellena(siguientes, siguientes.charAt(0), Integer.parseInt(campo.get("LONGITUD")));
        }
        return siguientes;
    }

    @Override
    public void revisarBitacora(List<ITipoDatosTabla> listaTablas) throws ExceptionMotor {
        try {
            int i;
            if (!this.isUsarPosteriormenteBitacora()) {
                return;
            }
            HashMap<Integer, String> nulos = new HashMap<Integer, String>();
            Map<String, String> campo = null;
            for (int i2 = 0; i2 < this.bitacora.size(); ++i2) {
                if (!this.bitacora.get(i2).isEsTabla()) {
                    campo = this.getGestorBOE().getCampo(this.bitacora.get(i2).getNombreCampo());
                    if (campo == null || !campo.containsKey("SIGUIENTES")) continue;
                    String siguientes = this.dameCadenaCte(campo);
                    if (!this.bitacora.get(i2).getValor().equals(siguientes)) continue;
                    nulos.put(i2, "Siguientes");
                    continue;
                }
                if (i2 <= 0) continue;
                this.bitacora.get(i2 - 1).setEsUltimoCampoDeTabla(true);
            }
            if (nulos.size() == 0) {
                return;
            }
            ArrayList<String> tablasHechas = new ArrayList<String>();
            boolean bucle = true;
            while (bucle) {
                bucle = false;
                for (i = 0; i < this.bitacora.size(); ++i) {
                    if (!this.bitacora.get(i).isEsTabla() || tablasHechas.contains(this.bitacora.get(i).getTabla())) continue;
                    bucle = true;
                    tablasHechas.add(this.bitacora.get(i).getTabla());
                    this.verificaTabla(this.bitacora.get(i).getTabla(), nulos);
                }
            }
            nulos.clear();
            bucle = true;
            block6: while (bucle) {
                bucle = false;
                for (i = 0; i < this.bitacora.size(); ++i) {
                    if (!this.bitacora.get(i).isEsTabla() || !this.bitacora.get(i).getValor().equalsIgnoreCase("LIMPIAR")) continue;
                    String tabla = this.bitacora.get(i).getTabla();
                    this.bitacora.remove(i);
                    for (int j = i; j < this.bitacora.size(); ++j) {
                        if (!this.bitacora.get(j).getTabla().equalsIgnoreCase(tabla)) continue;
                        if (this.bitacora.get(j).isEsUltimoCampoDeTabla()) {
                            this.bitacora.remove(j);
                            break;
                        }
                        this.bitacora.remove(j);
                        --j;
                    }
                    bucle = true;
                    continue block6;
                }
            }
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void verificaTabla(String tabla, Map<Integer, String> nulos) throws ExceptionMotor {
        ITipoDatoRetornoMetodo ret;
        if (this.getModelo() != null && this.getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getModelo().getFuncionalidadPersonalizadaModelo().verificaTabla(this, tabla, nulos)).isRetornaResultado()) {
            return;
        }
        this.verificaTablaRecursivo(tabla, nulos);
    }

    @Override
    public ITipoDatoRetornoMetodo verificaTablaRecursivo(String tabla, Map<Integer, String> nulos) throws ExceptionMotor {
        try {
            boolean hayAlgunaConContenido = false;
            boolean actualConContenido = false;
            int inicioTablaActual = -1;
            for (int i = 0; i < this.bitacora.size(); ++i) {
                if (this.bitacora.get(i).isEsTabla()) {
                    if (!this.bitacora.get(i).getTabla().equalsIgnoreCase(tabla)) continue;
                    actualConContenido = false;
                    inicioTablaActual = i;
                    continue;
                }
                if (!this.bitacora.get(i).getTabla().equalsIgnoreCase(tabla)) continue;
                if (!nulos.containsKey(i)) {
                    hayAlgunaConContenido = true;
                    actualConContenido = true;
                }
                if (!this.bitacora.get(i).isEsUltimoCampoDeTabla() || !hayAlgunaConContenido || actualConContenido) continue;
                this.bitacora.get(inicioTablaActual).setValor("LIMPIAR");
            }
            return new TipoDatoRetornoMetodo(ITipoDatoRetornoMetodo.tipoDato_Void);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public IRegError addErrorWarningComun(String codError, String nombreCampo, Map<String, String> propCampos, String coletilla) {
        RegError err = new RegError();
        err.setIdError(codError);
        err.setPropiedad("POSICIONFICHERO", String.valueOf(this.contadorPosicionActualLinea + 1));
        if (propCampos != null && propCampos.containsKey("TIPODATO")) {
            err.setPropiedad("TIPODATO", propCampos.get("TIPODATO"));
        }
        err.setTipoError("E");
        err.setCampoError(nombreCampo);
        if (coletilla.length() > 0) {
            err.setIdError(err.getIdError() + coletilla);
            err.setPropiedad("CLASE_ORIGEN_ERROR", "VALIDACIONEXTRA");
            err.setTipoError("W");
        }
        return err;
    }

    @Override
    public void addError(String codError, String nombreCampo, Map<String, String> propCampos, String coletilla) {
        this.getGestorFichero().addError(String.valueOf(this.getLineaSinSaltos()), this.addErrorWarningComun(codError, nombreCampo, propCampos, coletilla), propCampos);
    }

    @Override
    public void addWarning(String codError, String nombreCampo, Map<String, String> propCampos, String coletilla) {
        this.getGestorFichero().addWarning(String.valueOf(this.getLineaSinSaltos()), this.addErrorWarningComun(codError, nombreCampo, propCampos, coletilla), propCampos);
    }

    @Override
    public void cancelar() {
        this.getGestorFichero().cancelar();
    }

    @Override
    public String formateaValor(String valor, Map<String, String> propiedades) {
        return valor;
    }

    @Override
    public boolean getErrores2ValorPorDefecto() {
        return this.isErrores2ValorPorDefecto();
    }

    @Override
    public void setErrores2ValorPorDefecto(boolean errores2ValorPorDefecto) {
        this.errores2ValorPorDefecto = errores2ValorPorDefecto;
    }

    @Override
    public boolean isErrores2ValorPorDefecto() {
        return this.errores2ValorPorDefecto;
    }

    @Override
    public List<ITipoDatosAnotacionBitacora> getBitacora() {
        return this.bitacora;
    }
}

