/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.gestionFicheros.importacion.boe;

import es.aeat.pftw.mtrc.gestionFicheros.importacion.ComunReglasValidacion;
import es.aeat.pftw.mtrc.tipos.ITipoDatosAnotacionBitacora;
import es.aeat.pftw.mtrc.tipos.ITipoDatosTabla;
import es.aeat.pftw.mtrc.tipos.TipoDatoRetornoMetodo;
import es.aeat.pftw.mtrc.tipos.TipoDatosCampoValor;
import es.aeat.pftw.mtrc.tipos.TipoDatosTabla;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.tipos.ITipoDatoRetornoMetodo;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampoValor;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampos;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReglasValidacionBitacora
extends ComunReglasValidacion {
    private static final long serialVersionUID = 1L;
    protected List<ITipoDatosAnotacionBitacora> bitacora = null;
    protected int lineaEnFichero = -1;

    @Override
    public void dispose() throws ExceptionMotor {
        super.dispose();
        this.bitacora = null;
    }

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            super.init(parametros);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public void setBitacora(List<ITipoDatosAnotacionBitacora> bitacora) {
        this.bitacora = bitacora;
    }

    @Override
    protected String getLineaFichero() {
        return String.valueOf(this.lineaEnFichero);
    }

    @Override
    protected void setLineaFichero(String linea) {
        this.lineaEnFichero = Integer.valueOf(linea);
    }

    protected String getNombreTabla(ITipoDatosTabla tdt) throws ExceptionMotor {
        try {
            String nombreTabla = tdt.getNombreTabla();
            if (this.getGestorConfiguracion().getTabla(nombreTabla) == null) {
                nombreTabla = null;
            }
            if (nombreTabla == null && tdt.getPropiedadesTabla().get("TABLABBDD") != null) {
                nombreTabla = tdt.getPropiedadesTabla().get("TABLABBDD").trim().toUpperCase();
            }
            if (nombreTabla == null || this.getGestorConfiguracion().getTabla(nombreTabla) == null) {
                throw new ExceptionMotor("No se a que tabla se refiere trans XML con nombre " + tdt.getNombreTabla() + " use el nombre o el atributo '" + "TABLABBDD" + "'");
            }
            return nombreTabla;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected String creaTabla(ITipoDatosTabla tdt) throws ExceptionMotor {
        try {
            if (tdt.getPropiedadesTabla().containsKey("NOIMPORTAR")) {
                throw new ExceptionMotor("No se puede crear una tabla con el atributo de no ser importada!!!");
            }
            String nomTabla = this.getNombreTabla(tdt);
            if (this.getTablas().get(nomTabla) != null) {
                return nomTabla;
            }
            this.getTablas().put(nomTabla, new TipoDatosTabla(nomTabla));
            this.getTablas().get(nomTabla).setPropiedadesTabla(tdt.getPropiedadesTabla());
            return nomTabla;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected void guardaCampo(String nomTabla, ITipoDatosCampos campo) throws ExceptionMotor {
        try {
            if (campo.getNombreCampo().trim().length() > 0) {
                if (campo.getPropiedadesCampos().get("TABLA") != null || campo.getPropiedadesCampos().get("MUEVETABLA") != null) {
                    String tabla = campo.getPropiedadesCampos().get("TABLA");
                    if (tabla == null) {
                        tabla = campo.getPropiedadesCampos().get("MUEVETABLA");
                    }
                    tabla = tabla.trim().toUpperCase();
                    if (this.getTablas().get(tabla) == null) {
                        TipoDatosTabla t = new TipoDatosTabla(tabla);
                        t.setPropiedadesTabla(new HashMap<String, String>());
                        t.getPropiedadesTabla().put("TABLABBDD", tabla);
                        this.creaTabla(t);
                    }
                    nomTabla = tabla;
                }
                if (this.getTablas().get(nomTabla).getCampos() == null) {
                    this.getTablas().get(nomTabla).setCampos(new ArrayList<ITipoDatosCampos>());
                }
                this.getTablas().get(nomTabla).getCampos().add(campo);
            } else if (campo.getPropiedadesCampos().containsKey("VALOR")) {
                String[] partidas;
                for (String p : partidas = campo.getPropiedadesCampos().get("VALOR").split(",")) {
                    ITipoDatosCampos clon = campo.clone();
                    clon.setNombreCampo(p);
                    this.guardaCampo(nomTabla, clon);
                }
            }
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected void cargarEstructuras() throws ExceptionMotor {
        try {
            this.setTablas(new HashMap<String, TipoDatosTabla>());
            List<ITipoDatosTabla> listaTablas = this.getGestor().getTablas();
            for (ITipoDatosTabla tdt : listaTablas) {
                if (tdt.getPropiedadesTabla().containsKey("NOIMPORTAR")) continue;
                String nomTabla = this.creaTabla(tdt);
                for (ITipoDatosCampos campo : tdt.getCampos()) {
                    this.guardaCampo(nomTabla, campo);
                }
            }
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public boolean reglasDeValidacion(List<ITipoDatosAnotacionBitacora> bitacora) throws ExceptionMotor {
        try {
            this.bitacora = bitacora;
            this.cargarEstructuras();
            boolean ret = this.reglasDeValidacion();
            return ret;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    protected String formateaValor(String tipoDato, String valor, Map<String, String> propiedades, String tDato) throws ExceptionMotor {
        try {
            if (this.getSesion().getModelo() != null && this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo() != null) {
                try {
                    ITipoDatoRetornoMetodo ret = this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo().formateaValor(this, tipoDato, valor, propiedades, tDato);
                    if (ret.isRetornaResultado()) {
                        return ret.getObjetoRetornoAsString();
                    }
                }
                catch (Exception exc) {
                    throw new ExceptionMotor(exc);
                }
            }
            return this.formateaValorRecursiva(tipoDato, valor, propiedades, tDato).getObjetoRetornoAsString();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    protected long anniadirElRegistroAlMotor(String nombreTabla, List<ITipoDatosCampoValor> campos) throws ExceptionMotor {
        try {
            if (this.getSesion().getModelo() != null && this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo() != null) {
                try {
                    ITipoDatoRetornoMetodo ret = this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo().anniadirElRegistroAlMotor(this, nombreTabla, campos);
                    if (ret.isRetornaResultado()) {
                        return ret.getObjetoRetornoAsLong();
                    }
                }
                catch (Exception exc) {
                    throw new ExceptionMotor(exc);
                }
            }
            return this.anniadirElRegistroAlMotorRecursiva(nombreTabla, campos).getObjetoRetornoAsLong();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public ITipoDatoRetornoMetodo anniadirElRegistroAlMotorRecursiva(String nombreTabla, List<ITipoDatosCampoValor> campos) throws ExceptionMotor {
        try {
            return new TipoDatoRetornoMetodo(super.anniadirElRegistroAlMotor(nombreTabla, campos));
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public ITipoDatoRetornoMetodo formateaValorRecursiva(String tipoDato, String valor, Map<String, String> propiedades, String tDato) throws ExceptionMotor {
        try {
            if (propiedades.containsKey("TIPODATOREAL")) {
                tipoDato = propiedades.get("TIPODATOREAL");
            }
            if (tipoDato.equalsIgnoreCase("1_a_true")) {
                if (valor.equalsIgnoreCase("1")) {
                    return new TipoDatoRetornoMetodo("true");
                }
                if (valor.equalsIgnoreCase("0")) {
                    return new TipoDatoRetornoMetodo("false");
                }
                throw new ExceptionMotor("Valor (" + valor + ") no valido para tipo '" + "1_a_true" + "'");
            }
            return new TipoDatoRetornoMetodo(super.formateaValor(tipoDato, valor, propiedades, tDato));
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    protected void cumunRegistroNuevo(ITipoDatosTabla tablaActual, List<ITipoDatosCampoValor> camposTabla, ITipoDatosAnotacionBitacora anotacionTabla, ITipoDatosAnotacionBitacora tablaEnProgreso) throws ExceptionMotor {
        try {
            super.cumunRegistroNuevo(tablaActual, camposTabla, anotacionTabla, tablaEnProgreso);
            if (!anotacionTabla.isHanSaltadoSusReglas()) {
                for (int i = this.bitacora.indexOf(anotacionTabla) + 1; i < this.bitacora.size() && !this.bitacora.get(i).isEsTabla(); ++i) {
                    this.bitacora.get(i).setHanSaltadoSusReglas(false);
                }
            }
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    protected void recorridoFicheroReglasValidacion() throws ExceptionMotor {
        String ultimoCampo = "";
        Map<String, String> propCampos = null;
        try {
            ArrayList<ITipoDatosCampoValor> camposTabla = new ArrayList<ITipoDatosCampoValor>();
            TipoDatosTabla tablaActual = null;
            ITipoDatosAnotacionBitacora tablaEnProgreso = null;
            ITipoDatosAnotacionBitacora ultimaTabla = null;
            for (ITipoDatosAnotacionBitacora anotacion : this.bitacora) {
                ultimoCampo = anotacion.getNombreCampo();
                if (anotacion.isEsTabla()) {
                    if (camposTabla.size() > 0) {
                        this.cumunRegistroNuevo(tablaActual, camposTabla, ultimaTabla, tablaEnProgreso);
                        camposTabla.clear();
                    }
                    ultimaTabla = anotacion;
                    tablaActual = this.getTablas().get(anotacion.getTabla().trim().toUpperCase());
                    tablaEnProgreso = anotacion;
                    this.setLineaFichero(tablaEnProgreso.getLineaEnFichero());
                    if (tablaActual != null) continue;
                    throw new Exception("Error al buscar tabla " + anotacion.getTabla().trim().toUpperCase());
                }
                if (this.getGestor().getVariables().containsKey(anotacion.getNombreCampo().toUpperCase())) {
                    this.getGestor().getVariables().put(anotacion.getNombreCampo().toUpperCase(), anotacion.getValor());
                }
                propCampos = this.getPropiedadesCampo(tablaActual.getNombreTabla(), anotacion.getNombreCampo());
                String lineaFichero = "";
                List<ITipoDatosCampoValor> dondeInsertar = camposTabla;
                if (anotacion.getNombreCampo().startsWith("[FILTRO]")) {
                    dondeInsertar.add(new TipoDatosCampoValor(anotacion.getNombreCampo(), anotacion.getValor(), lineaFichero));
                    continue;
                }
                if (propCampos.get("RVEJECUCION") != null) {
                    if (!this.getPendientesParaRegRegistro().containsKey(tablaActual.getNombreTabla())) {
                        this.getPendientesParaRegRegistro().put(tablaActual.getNombreTabla(), new ArrayList());
                    }
                    dondeInsertar = this.getPendientesParaRegRegistro().get(tablaActual.getNombreTabla());
                    lineaFichero = String.valueOf(anotacion.getLineaEnFichero());
                } else {
                    anotacion.setHanSaltadoSusReglas(true);
                }
                if (anotacion.getNombreCampo().length() != 0 && propCampos.get("NOIMPORTAR") == null && propCampos.get("IMPORTARESPECIAL") == null) {
                    dondeInsertar.add(new TipoDatosCampoValor(anotacion.getNombreCampo(), anotacion.getValor(), lineaFichero));
                    continue;
                }
                if (propCampos.get("IMPORTARESPECIAL") == null) continue;
                if (!propCampos.get("IMPORTARESPECIAL").equalsIgnoreCase("true")) {
                    dondeInsertar.add(new TipoDatosCampoValor("PARTIDA_ESPECIAL_" + propCampos.get("IMPORTARESPECIAL").toString(), anotacion.getValor(), lineaFichero));
                    continue;
                }
                dondeInsertar.add(new TipoDatosCampoValor("PARTIDA_ESPECIAL_" + propCampos.get("TIPODATO").toString(), anotacion.getValor(), lineaFichero));
            }
            if (camposTabla.size() > 0) {
                this.cumunRegistroNuevo(tablaActual, camposTabla, ultimaTabla, tablaEnProgreso);
            }
            for (ITipoDatosAnotacionBitacora anotacion : this.bitacora) {
                if (anotacion.isEsTabla()) {
                    tablaActual = this.getTablas().get(anotacion.getTabla().trim().toUpperCase());
                    if (anotacion.getPosicionMotor() == null) continue;
                    this.colocarseEnPosicion(anotacion.getPosicionMotor());
                    continue;
                }
                if (!anotacion.isHanSaltadoSusReglas()) continue;
                propCampos = this.getPropiedadesCampo(tablaActual.getNombreTabla(), anotacion.getNombreCampo());
                this.examinarPorCambioReglas(anotacion.getNombreCampo(), anotacion.getValor(), anotacion.getLineaEnFichero(), propCampos);
            }
            this.compruebaWarningsCambiosPorReglas();
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " UltimoCampo : " + ultimoCampo);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "UltimoCampo : " + ultimoCampo);
        }
    }

    protected void colocarseEnPosicion(List<ITipoDatosCampoValor> posicionMotor) throws ExceptionMotor {
        try {
            if (posicionMotor != null) {
                for (int i = 0; i < posicionMotor.size(); ++i) {
                    long posicionAmoverse = this.getSesion().getOperaciones().move(posicionMotor.get(i).getNombreCampo(), Long.valueOf(posicionMotor.get(i).getValor()));
                    if (Long.valueOf(posicionMotor.get(i).getValor()) == posicionAmoverse) continue;
                    throw new Exception("No pudo moverse motor a posicion " + posicionMotor.get(i).getValor() + " de tabla " + posicionMotor.get(i).getNombreCampo());
                }
            }
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected void setLineaFichero(int lineaEnFichero) {
        this.lineaEnFichero = lineaEnFichero;
    }
}

