/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.gestionFicheros.importacion.boe;

import es.aeat.pftw.mtrc.gestionFicheros.importacion.ComunReglasValidacion;
import es.aeat.pftw.mtrc.gestionFicheros.importacion.boe.CodigoComun;
import es.aeat.pftw.mtrc.tipos.ITipoDatosIdentificarTabla;
import es.aeat.pftw.mtrc.tipos.ITipoDatosTabla;
import es.aeat.pftw.mtrc.tipos.TipoDatoRetornoMetodo;
import es.aeat.pftw.mtrc.tipos.TipoDatosCampoValor;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.utilidades.StringUtility;
import es.aeat.pftw.mtrp.configuracion.IRegEntrada;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.tipos.ITipoDatoRetornoMetodo;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampoValor;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampos;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ReglasValidacion
extends ComunReglasValidacion {
    private static final long serialVersionUID = 1L;
    protected reglasValidacionComun instanciaReglasValidacionComun = null;
    private String tablaEnCurso = "";
    private static final String LITERAL_LONGITUD_ERRONEA = "Longitud de dato para FechaInvertida no es ni 4 ni 8";

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            super.init(parametros);
            this.instanciaReglasValidacionComun = new reglasValidacionComun();
            this.instanciaReglasValidacionComun.init(parametros);
            this.setListaTablasParaRegRegistro(new ArrayList<String>());
            this.getGestorFichero().errClear();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected String formateaValor(String valor, Map<String, String> propiedades) throws ExceptionMotor {
        try {
            String res;
            block13: {
                block14: {
                    String tipoDato;
                    block12: {
                        res = super.formateaValor(valor, propiedades, "");
                        if (res.compareTo(valor) != 0) {
                            return res;
                        }
                        tipoDato = "";
                        try {
                            tipoDato = this.getGestor().traduceCadena(propiedades.get("TIPODATO").toString());
                        }
                        catch (Exception ex) {
                            return res;
                        }
                        if (tipoDato.equalsIgnoreCase("Num")) {
                            return this.formateoADecimales(valor, propiedades.get("DECIMALES"));
                        }
                        if (!tipoDato.equalsIgnoreCase("NumSigno")) break block12;
                        res = valor.charAt(0) == 'N' ? "-" + this.formateoADecimales(valor.substring(1), propiedades.get("DECIMALES")) : this.formateoADecimales(valor, propiedades.get("DECIMALES"));
                        break block13;
                    }
                    if (!tipoDato.equalsIgnoreCase("FechaInvertida")) break block14;
                    switch (res.length()) {
                        case 6: {
                            res = res.substring(4, 6) + res.substring(2, 4) + res.substring(0, 2);
                            break block13;
                        }
                        case 8: {
                            res = res.substring(4, 8) + res.substring(2, 4) + res.substring(0, 2);
                            break block13;
                        }
                        default: {
                            throw new ExceptionMotor(LITERAL_LONGITUD_ERRONEA);
                        }
                    }
                }
                if (valor.trim().length() == 0) {
                    return "";
                }
                res = StringUtility.getStringUtility().rTrim(res);
                res = res.replaceAll("\u00b4", "'");
            }
            return res;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected String formateaValorBigDecimal(String valor, Map<String, String> propiedades) throws ExceptionMotor {
        try {
            String res;
            block23: {
                block24: {
                    String tipoDato;
                    block22: {
                        res = valor;
                        tipoDato = "";
                        try {
                            tipoDato = this.getGestor().traduceCadena(propiedades.get("TIPODATO").toString());
                        }
                        catch (Exception ex) {
                            return res;
                        }
                        if (tipoDato.toUpperCase().indexOf("Valores") == 0) {
                            String[] p = StringUtility.getStringUtility().split(tipoDato, ":");
                            for (int i = 0; i < p.length; ++i) {
                                String[] q = StringUtility.getStringUtility().split(p[i], "=");
                                if (q.length != 2 || valor.compareTo(FuncionesUtiles.getFuncionesUtiles().desCodificaCadena(q[0])) != 0) continue;
                                res = FuncionesUtiles.getFuncionesUtiles().desCodificaCadena(q[1]);
                                break;
                            }
                        } else if (tipoDato.toUpperCase().indexOf("CTE:") == 0) {
                            res = FuncionesUtiles.getFuncionesUtiles().desCodificaCadena(tipoDato.substring("CTE:".length()));
                        } else if (tipoDato.toUpperCase().indexOf("FUNCION") == 0) {
                            res = this.ejecutaMetodoDeClase(tipoDato.substring(8).split(","), valor);
                        }
                        if (res.compareTo(valor) != 0) {
                            return res;
                        }
                        tipoDato = "";
                        try {
                            tipoDato = this.getGestor().traduceCadena(propiedades.get("TIPODATO").toString());
                        }
                        catch (Exception ex) {
                            return res;
                        }
                        if (tipoDato.equalsIgnoreCase("Num")) {
                            return this.formateoADecimalesBigDecimal(valor, propiedades.get("DECIMALES"));
                        }
                        if (!tipoDato.equalsIgnoreCase("NumSigno")) break block22;
                        res = this.formateoADecimalesBigDecimal(valor.substring(1), propiedades.get("DECIMALES"));
                        if (valor.charAt(0) == 'N') {
                            res = "-" + res;
                        }
                        break block23;
                    }
                    if (!tipoDato.equalsIgnoreCase("FechaInvertida")) break block24;
                    switch (res.length()) {
                        case 6: {
                            res = res.substring(4, 6) + res.substring(2, 4) + res.substring(0, 2);
                            break block23;
                        }
                        case 8: {
                            res = res.substring(4, 8) + res.substring(2, 4) + res.substring(0, 2);
                            break block23;
                        }
                        default: {
                            throw new ExceptionMotor(LITERAL_LONGITUD_ERRONEA);
                        }
                    }
                }
                if (valor.trim().length() == 0) {
                    return "";
                }
                res = StringUtility.getStringUtility().rTrim(res);
                res = res.replaceAll("'", "\u00b4");
            }
            return res;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public boolean reglasDeValidacion(String ficheroTXT) throws ExceptionMotor {
        try {
            if (this.getGestor() == null) {
                throw new ExceptionMotor("No dispongo de gestor de traducciones, llame primero a establecerGestor");
            }
            this.abrirFichero(ficheroTXT);
            boolean ret = this.reglasDeValidacion();
            this.cerrarFichero();
            return ret;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public void cerrarFichero() throws ExceptionMotor {
        this.instanciaReglasValidacionComun.cerrarFichero();
    }

    public void abrirFichero(byte[] bytes) throws ExceptionMotor {
        this.instanciaReglasValidacionComun.abrirFichero(bytes);
    }

    public void abrirFichero(String ficheroTXT) throws ExceptionMotor {
        try {
            this.abrirFichero(FuncionesUtiles.getFuncionesUtiles().file2bytesISO(ficheroTXT));
        }
        catch (FileNotFoundException e) {
            throw new ExceptionMotor(e);
        }
        catch (IOException e) {
            throw new ExceptionMotor(e);
        }
    }

    public String lineaSiguiente() throws ExceptionMotor {
        return this.instanciaReglasValidacionComun.lineaSiguiente();
    }

    @Override
    protected void recorridoFicheroReglasValidacion() throws ExceptionMotor {
        String cadena = "";
        List<ITipoDatosCampos> campos = null;
        Map<String, String> propCampos = null;
        List<ITipoDatosTabla> listaTablas = this.getGestor().getTablas();
        List<ITipoDatosTabla> listaTablasAdicionales = this.getGestor().getTablasAuxiliares();
        String cad = "";
        ArrayList<ITipoDatosCampoValor> camposTabla = null;
        int longitudRegistro = 0;
        int i = 0;
        int j = 0;
        while ((cadena = this.lineaSiguiente()) != null) {
            int accesoDirectoTablaAdicional;
            ITipoDatosIdentificarTabla ret;
            if (this.getGestorFichero().isFueCancelado()) {
                this.getSesion().getOrigenDeDatos().rollBack(true);
                throw new ExceptionMotor("CORTAR EJECUCION SIN MAS");
            }
            if (cadena.compareTo(this.instanciaReglasValidacionComun.getSaltoDeLinea()) == 0 || (ret = this.instanciaReglasValidacionComun.identificameTablaDeCadena(cadena)) == null) continue;
            i = ret.getIndice();
            cadena = this.instanciaReglasValidacionComun.consumeDeCadena(cadena, ret.getPosicionesAConsumir());
            camposTabla = null;
            camposTabla = new ArrayList<ITipoDatosCampoValor>();
            campos = listaTablas.get(i).getCampos();
            propCampos = null;
            for (j = 0; j < campos.size(); ++j) {
                propCampos = campos.get(j).getPropiedadesCampos();
                if (propCampos != null && propCampos.containsKey("NOEXPORTAR")) {
                    propCampos.put("LONGITUD", "0");
                }
                if (cadena.length() == 0 && propCampos.get("EVITARSALTODELINEA") != null) {
                    while (cadena != null && cadena.length() == 0) {
                        cadena = this.lineaSiguiente();
                    }
                }
                cad = (longitudRegistro = this.instanciaReglasValidacionComun.sacarLongitud(cadena, propCampos.get("LONGITUD"))) == -1 ? cadena : cadena.substring(0, longitudRegistro);
                cadena = this.instanciaReglasValidacionComun.consumeDeCadena(cadena, cad.length());
                if (this.getGestor().getVariables().containsKey(campos.get(j).getNombreCampo().toUpperCase())) {
                    this.getGestor().getVariables().put(campos.get(j).getNombreCampo().toUpperCase(), cad);
                }
                if (campos.get(j).getNombreCampo().length() != 0 && propCampos.get("NOIMPORTAR") == null && propCampos.get("IMPORTARESPECIAL") == null) {
                    camposTabla.add(new TipoDatosCampoValor(campos.get(j).getNombreCampo(), cad));
                    continue;
                }
                if (propCampos.get("IMPORTARESPECIAL") == null) continue;
                if (!propCampos.get("IMPORTARESPECIAL").equalsIgnoreCase("true")) {
                    camposTabla.add(new TipoDatosCampoValor("PARTIDA_ESPECIAL_" + propCampos.get("IMPORTARESPECIAL").toString(), cad));
                    continue;
                }
                camposTabla.add(new TipoDatosCampoValor("PARTIDA_ESPECIAL_" + propCampos.get("TIPODATO").toString(), cad));
            }
            if (this.getGestorFichero().getRutaDatosAdicionales().length() > 0 && (accesoDirectoTablaAdicional = this.getGestor().getTableAdicionalIndex(listaTablas.get(i).getNombreTabla())) > -1) {
                cadena = this.instanciaReglasValidacionComun.lineaSiguienteAdicional();
                campos = listaTablasAdicionales.get(accesoDirectoTablaAdicional).getCampos();
                propCampos = null;
                for (j = 0; j < campos.size(); ++j) {
                    propCampos = campos.get(j).getPropiedadesCampos();
                    longitudRegistro = this.instanciaReglasValidacionComun.sacarLongitud(cadena, propCampos.get("LONGITUD"));
                    cad = longitudRegistro == -1 ? cadena : cadena.substring(0, longitudRegistro);
                    cadena = this.instanciaReglasValidacionComun.consumeDeCadena(cadena, cad.length());
                    if (campos.get(j).getNombreCampo().length() == 0 || propCampos.get("NOIMPORTAR") != null) continue;
                    camposTabla.add(new TipoDatosCampoValor(campos.get(j).getNombreCampo(), cad));
                }
            }
            this.cumunRegistroNuevo(listaTablas.get(i), camposTabla, null, null);
            camposTabla = null;
        }
    }

    protected boolean esValorPorDefecto(String valor, IRegEntrada ent) {
        String valorInicial = ent.getValorInicial();
        try {
            return Double.parseDouble(valor) == Double.parseDouble(valorInicial);
        }
        catch (Exception ex) {
            return valor.trim().equalsIgnoreCase(valorInicial.trim());
        }
    }

    protected boolean parteComunPartidaModificadaOEstablecerPartida(String campo, String valor) {
        String campoSinParentesis = FuncionesUtiles.getFuncionesUtiles().dameNombrePartidaSinParentesis(campo);
        try {
            String muevetabla = "";
            String tabla = "";
            try {
                muevetabla = this.getGestor().getCampo(campo).get("MUEVETABLA").toString();
            }
            catch (Exception ex) {
                muevetabla = "";
            }
            try {
                tabla = this.getGestor().getCampo(campo).get("TABLA").toString();
            }
            catch (Exception ex) {
                tabla = "";
            }
            if (tabla.length() > 0 && !this.getTablaEnCurso().equalsIgnoreCase(tabla)) {
                if (this.esValorPorDefecto(valor, this.getGestorConfiguracion().getEntrada(campoSinParentesis))) {
                    return false;
                }
                if (this.getGestor().getCampo(campo).get("ACCION") == null) {
                    this.getSesion().getOperaciones().anniadirRegistro(tabla);
                }
                this.setTablaEnCurso(tabla);
            }
            if (muevetabla.length() > 0) {
                if (!this.getTablaEnCurso().equalsIgnoreCase(muevetabla)) {
                    if (this.esValorPorDefecto(valor, this.getGestorConfiguracion().getEntrada(campoSinParentesis))) {
                        return false;
                    }
                } else {
                    this.setTablaEnCurso("");
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return true;
    }

    @Override
    protected boolean partidaModificada(String campo, String valor) throws ExceptionMotor {
        if (!this.parteComunPartidaModificadaOEstablecerPartida(campo, valor)) {
            return true;
        }
        return this.getSesion().getGestionReglas().partidaModificada(campo, valor);
    }

    @Override
    protected boolean establecerPartida(String campo, String valor) throws ExceptionMotor {
        if (!this.parteComunPartidaModificadaOEstablecerPartida(campo, valor)) {
            return true;
        }
        return this.getSesion().getOperaciones().establecerPartida(campo, valor);
    }

    protected void setTablaEnCurso(String tablaEnCurso) {
        this.tablaEnCurso = tablaEnCurso;
    }

    protected String getTablaEnCurso() {
        return this.tablaEnCurso;
    }

    @Override
    public ITipoDatoRetornoMetodo formateaValorRecursiva(String tipoDato, String valor, Map<String, String> propiedades, String tDato) throws ExceptionMotor {
        return new TipoDatoRetornoMetodo(super.formateaValor(tipoDato, valor, propiedades, tDato));
    }

    @Override
    public ITipoDatoRetornoMetodo anniadirElRegistroAlMotorRecursiva(String nombreTabla, List<ITipoDatosCampoValor> campos) throws ExceptionMotor {
        return new TipoDatoRetornoMetodo(super.anniadirElRegistroAlMotor(nombreTabla, campos));
    }

    @Override
    protected String getLineaFichero() {
        return this.instanciaReglasValidacionComun.getLineaFichero();
    }

    @Override
    protected void setLineaFichero(String linea) {
    }

    protected class reglasValidacionComun
    extends CodigoComun {
        private static final long serialVersionUID = 1L;

        protected reglasValidacionComun() {
        }
    }
}

