/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.gestionFicheros.importacion.boe;

import es.aeat.pftw.mtrc.IAop;
import es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.boe.IGestorTraduccionesBOE;
import es.aeat.pftw.mtrc.gestionFicheros.importacion.Comun;
import es.aeat.pftw.mtrc.gestionFicheros.importacion.boe.ICodigoComun;
import es.aeat.pftw.mtrc.tipos.ITipoDatosIdentificarTabla;
import es.aeat.pftw.mtrc.tipos.ITipoDatosTabla;
import es.aeat.pftw.mtrc.tipos.TipoDatoRetornoMetodo;
import es.aeat.pftw.mtrc.tipos.TipoDatosIdentificarTabla;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.utilidades.IFicherosIntermedios;
import es.aeat.pftw.mtrc.utilidades.IFileReaderBytes;
import es.aeat.pftw.mtrc.utilidades.StringAEAT;
import es.aeat.pftw.mtrp.configuracion.IRegError;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.tipos.ITipoDatoRetornoMetodo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class CodigoComun
extends Comun
implements IAop,
ICodigoComun {
    private static final long serialVersionUID = 1L;
    private boolean anteriorLecturaConDatosPrincipal = false;
    private List<String> tiposDeRegistroDelFichero = null;
    private int anteriorCaracterLeido = -1;
    private static final String SALTO_DE_LINEA = "~~~ EsTo Es Un SaLto De LiNeA ~ PaRa El CoNtAdOr De LiNeAs~~~";
    private static final String LITERAL_ERR_FICHERO_NO_ABIERTO = "No hay ningun fichero abierto";
    private transient IFileReaderBytes fR = null;
    private boolean ficheroAbierto = false;
    private boolean eof = false;
    private int linea = 0;
    private int lineaReal = 0;
    private transient byte[] ficheroActual = null;
    private List<String> arrSecuencia = new ArrayList<String>();
    private List<String> warning = null;
    private boolean lecturaDeLineasEstricta = false;
    private boolean huboSaltoDeLinea = false;
    private boolean permitirTransformaciones = true;

    protected boolean isHuboSaltoDeLinea() {
        return this.huboSaltoDeLinea;
    }

    protected void setHuboSaltoDeLinea(boolean huboSaltoDeLinea) {
        this.huboSaltoDeLinea = huboSaltoDeLinea;
    }

    @Override
    public IFicherosIntermedios getgestorFicherosIntermediosDatos() {
        return this.getGestorFichero().getGestorFichIntermediosDatos();
    }

    @Override
    public void abrirFichero(byte[] bytes) throws ExceptionMotor {
        try {
            this.getArrSecuencia().clear();
            this.getGestorFichero().errClear();
            if (this.isFicheroAbierto()) {
                throw new ExceptionMotor("Ya existe un fichero abierto cierrelo primero");
            }
            this.setAnteriorLecturaConDatosPrincipal(false);
            this.setfR(this.getgestorFicherosIntermediosDatos().abrirFichero(bytes));
            if (this.getfR() == null) {
                throw new ExceptionMotor("Imposible crear fichero temporal...");
            }
            this.setFicheroAbierto(true);
            if (this.isLecturaDeLineasEstricta()) {
                this.setLinea(0);
            } else {
                this.setLinea(1);
            }
            this.setLineaReal(1);
            this.setEof(false);
            this.setFicheroActual(bytes);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void cerrarFichero() throws ExceptionMotor {
        try {
            if (!this.isFicheroAbierto()) {
                throw new ExceptionMotor(LITERAL_ERR_FICHERO_NO_ABIERTO);
            }
            this.getgestorFicherosIntermediosDatos().cerrarFichero();
            this.setFicheroAbierto(false);
            this.setLinea(0);
            this.setLineaReal(0);
            this.setEof(false);
            this.setAnteriorLecturaConDatosPrincipal(false);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public String getLineaSinSaltos() {
        return String.valueOf(this.getLineaReal());
    }

    @Override
    public String getLineaFichero() {
        return String.valueOf(this.getLinea());
    }

    @Override
    public void posicionarseInicio() throws ExceptionMotor {
        try {
            if (!this.isFicheroAbierto()) {
                throw new ExceptionMotor(LITERAL_ERR_FICHERO_NO_ABIERTO);
            }
            this.cerrarFichero();
            this.abrirFichero(this.getFicheroActual());
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public String comunlineaSiguienteSinCrLF(boolean conEventos) throws ExceptionMotor {
        if (this.isHuboSaltoDeLinea()) {
            this.setLinea(this.getLinea() + 1);
        }
        StringAEAT cadena = new StringAEAT();
        int longitudDelRegistro = Integer.MAX_VALUE;
        ITipoDatosIdentificarTabla identificaTabla = null;
        int aux = -1;
        try {
            boolean tmpEof = false;
            tmpEof = this.isEof();
            if (!this.isFicheroAbierto()) {
                throw new ExceptionMotor(LITERAL_ERR_FICHERO_NO_ABIERTO);
            }
            if (tmpEof) {
                String string = null;
                return string;
            }
            while (!tmpEof) {
                int c = this.getfR().read();
                if (c == -1) {
                    tmpEof = true;
                    this.setEof(true);
                    this.setAnteriorLecturaConDatosPrincipal(false);
                    if (cadena.length() == 0) {
                        String string = null;
                        return string;
                    }
                    if (conEventos) {
                        this.getGestorFichero().fireProgressEvent();
                    }
                    String string = cadena.toString();
                    return string;
                }
                if (c < 0) {
                    cadena.append((char)(256 + c));
                } else {
                    cadena.append((char)c);
                }
                if (this.getAnteriorCaracterLeido() == -99) {
                    this.setAnteriorCaracterLeido(-1);
                } else {
                    this.setAnteriorCaracterLeido(c);
                }
                boolean esDelTamanioDelRegistro = false;
                if (longitudDelRegistro == Integer.MAX_VALUE && (identificaTabla = this.identificameTablaDeCadena(cadena.toString())) != null && (aux = this.sacarLongitud(cadena.toString(), this.getGestorBOE().getTablas().get(identificaTabla.getIndice()).getPropiedadesTabla().get("LONGITUD"))) > -1) {
                    longitudDelRegistro = aux;
                }
                boolean bl = esDelTamanioDelRegistro = longitudDelRegistro > 0 && longitudDelRegistro == cadena.length();
                if (!esDelTamanioDelRegistro) continue;
                this.setAnteriorCaracterLeido(-99);
                if (cadena.length() == 0) {
                    String e = this.getSaltoDeLinea();
                    return e;
                }
                if (this.getTiposDeRegistroDelFichero() != null) {
                    this.getTiposDeRegistroDelFichero().add(cadena.substring(0, 1));
                }
                if (conEventos) {
                    this.getGestorFichero().fireProgressEvent();
                }
                this.setAnteriorLecturaConDatosPrincipal(true);
                String e = cadena.toString();
                return e;
            }
            String string = null;
            return string;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
        finally {
            try {
                cadena.close();
            }
            catch (IOException e) {}
            cadena = null;
        }
    }

    @Override
    public String comunlineaSiguiente(boolean conEventos) throws ExceptionMotor {
        if (this.isLecturaDeLineasEstricta()) {
            return this.comunlineaSiguienteSinCrLF(conEventos);
        }
        if (this.isHuboSaltoDeLinea()) {
            this.setLinea(this.getLinea() + 1);
        }
        StringAEAT cadena = new StringAEAT();
        int longitudDelRegistro = Integer.MAX_VALUE;
        ITipoDatosIdentificarTabla identificaTabla = null;
        int aux = -1;
        try {
            boolean tmpEof = false;
            tmpEof = this.isEof();
            if (!this.isFicheroAbierto()) {
                throw new ExceptionMotor(LITERAL_ERR_FICHERO_NO_ABIERTO);
            }
            if (tmpEof) {
                String string = null;
                return string;
            }
            while (!tmpEof) {
                int c = this.getfR().read();
                if (c == -1) {
                    tmpEof = true;
                    this.setEof(true);
                    this.setAnteriorLecturaConDatosPrincipal(false);
                    if (cadena.length() == 0) {
                        String string = null;
                        return string;
                    }
                    if (conEventos) {
                        this.getGestorFichero().fireProgressEvent();
                    }
                    String string = cadena.toString();
                    return string;
                }
                if (c != 26 && c != 10 && c != 13) {
                    if (c < 0) {
                        cadena.append((char)(256 + c));
                    } else {
                        cadena.append((char)c);
                    }
                }
                if (c == 13 || c == 10) {
                    boolean contarLinea = true;
                    if (c == 13 && this.getAnteriorCaracterLeido() == 10) {
                        contarLinea = false;
                        this.setAnteriorCaracterLeido(-99);
                    }
                    if (c == 10 && this.getAnteriorCaracterLeido() == 13) {
                        contarLinea = false;
                        this.setAnteriorCaracterLeido(-99);
                    }
                    if (contarLinea) {
                        this.setHuboSaltoDeLinea(true);
                        if (this.isAnteriorLecturaConDatosPrincipal()) {
                            this.setLineaReal(this.getLineaReal() + 1);
                            this.setAnteriorLecturaConDatosPrincipal(false);
                        }
                    }
                }
                if (this.getAnteriorCaracterLeido() == -99) {
                    this.setAnteriorCaracterLeido(-1);
                } else {
                    this.setAnteriorCaracterLeido(c);
                }
                boolean esDelTamanioDelRegistro = false;
                if (longitudDelRegistro == Integer.MAX_VALUE && (identificaTabla = this.identificameTablaDeCadena(cadena.toString())) != null && (aux = this.sacarLongitud(cadena.toString(), this.getGestorBOE().getTablas().get(identificaTabla.getIndice()).getPropiedadesTabla().get("LONGITUD"))) > -1) {
                    longitudDelRegistro = aux;
                }
                boolean bl = esDelTamanioDelRegistro = longitudDelRegistro > 0 && longitudDelRegistro == cadena.length();
                if (c != 13 && !esDelTamanioDelRegistro) continue;
                this.setAnteriorCaracterLeido(-99);
                if (cadena.length() == 0) {
                    String e = this.getSaltoDeLinea();
                    return e;
                }
                if (this.getTiposDeRegistroDelFichero() != null) {
                    this.getTiposDeRegistroDelFichero().add(cadena.substring(0, 1));
                }
                if (conEventos) {
                    this.getGestorFichero().fireProgressEvent();
                }
                this.setAnteriorLecturaConDatosPrincipal(true);
                String e = cadena.toString();
                return e;
            }
            String string = null;
            return string;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
        finally {
            try {
                cadena.close();
            }
            catch (IOException e) {}
            cadena = null;
        }
    }

    @Override
    public String lineaSiguiente() throws ExceptionMotor {
        return this.lineaSiguiente(true);
    }

    @Override
    public String extraeCadenaDeLongitud(Object propiedadLongitud) throws ExceptionMotor {
        try {
            if (propiedadLongitud == null) {
                return null;
            }
            String cadAux = "";
            String cadena = "";
            while ((cadAux = this.lineaSiguiente()) != null) {
                cadena = cadena + cadAux;
                if (!cadAux.toUpperCase().contains(propiedadLongitud.toString().toUpperCase())) continue;
                return cadena;
            }
            return null;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public String lineaSiguiente(boolean conEventos) throws ExceptionMotor {
        return this.comunlineaSiguiente(conEventos);
    }

    @Override
    public String lineaSiguienteAdicional() throws ExceptionMotor {
        boolean flagLecturaDeLineasEstricta = this.isLecturaDeLineasEstricta();
        try {
            this.setLecturaDeLineasEstricta(false);
            String string = this.comunlineaSiguiente(false);
            return string;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
        finally {
            this.setLecturaDeLineasEstricta(flagLecturaDeLineasEstricta);
        }
    }

    @Override
    public String consumeDeCadena(String cadena, int posiciones) throws ExceptionMotor {
        try {
            return cadena.substring(posiciones);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean getSuperoNumeroMaximoErrores() {
        return this.isSuperoNumeroMaximoErrores();
    }

    @Override
    public List<IRegError> getListaErrores() throws ExceptionMotor {
        try {
            return this.getGestorFichero().getListaErrores();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public List<IRegError> getListaWarning() throws ExceptionMotor {
        try {
            return this.getGestorFichero().getListaWarning();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean eliminaFicherosTemporales() throws ExceptionMotor {
        return this.getgestorFicherosIntermediosDatos().eliminarFicheroVirtual();
    }

    @Override
    public List<String> getTipoRegistros(byte[] bytes) throws ExceptionMotor {
        try {
            ArrayList<String> registros = new ArrayList<String>();
            if (this.isFicheroAbierto()) {
                throw new ExceptionMotor("Ya existe un fichero abierto, cierrelo primero");
            }
            this.abrirFichero(bytes);
            int con = 0;
            while (this.lineaSiguiente(false) != null) {
                ++con;
            }
            this.cerrarFichero();
            this.getGestorFichero().fireProgressEvent(0, con);
            return registros;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public List<String> getCabeceraRegistros(byte[] bytes) throws ExceptionMotor {
        try {
            this.setTiposDeRegistroDelFichero(new ArrayList<String>());
            this.getNumRegistros(bytes);
            return this.getTiposDeRegistroDelFichero();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public int getNumRegistros(byte[] bytes) throws ExceptionMotor {
        try {
            if (this.isFicheroAbierto()) {
                throw new ExceptionMotor("Ya existe un fichero abierto, cierrelo primero");
            }
            this.abrirFichero(bytes);
            int con = 0;
            while (this.lineaSiguiente(false) != null) {
                ++con;
            }
            this.cerrarFichero();
            this.getGestorFichero().fireProgressEvent(0, con);
            return con;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public ITipoDatosIdentificarTabla identificameTablaDeCadena(String cadenaAIdentificar) throws ExceptionMotor {
        try {
            List<ITipoDatosTabla> listaTablas = this.getGestorBOE().getTablas();
            String cadTmp = "";
            String[] cadPosiciones = null;
            String[] cadExpresion = null;
            boolean encontrado = false;
            int consumirCaracteres = 0;
            int pos = 0;
            int pos2 = 0;
            for (int i = 0; i < listaTablas.size(); ++i) {
                if (listaTablas.get(i).getPropiedadesTabla().containsKey("CONSTANTE")) {
                    cadTmp = this.getGestorBOE().traduceCadena(listaTablas.get(i).getPropiedadesTabla().get("CONSTANTE").toString());
                } else if (listaTablas.get(i).getPropiedadesTabla().containsKey("VARIABLE") && (cadTmp = this.getSesion().getOperaciones().obtenerPartidaString(this.getGestorBOE().traduceCadena(listaTablas.get(i).getPropiedadesTabla().get("VARIABLE").toString()))).length() == 0) {
                    cadTmp = FuncionesUtiles.getFuncionesUtiles().rellena("", 'X', this.getModelo().getGestorConfiguracion().getEntrada(listaTablas.get(i).getPropiedadesTabla().get("VARIABLE")).getTamannioCampo());
                }
                encontrado = false;
                if (cadTmp.length() > 0 && cadTmp.length() <= cadenaAIdentificar.length()) {
                    cadPosiciones = cadTmp.split(";");
                    for (int j = 0; j < cadPosiciones.length; ++j) {
                        cadExpresion = cadPosiciones[j].split(":");
                        switch (cadExpresion.length) {
                            case 1: {
                                pos = 0;
                                cadTmp = cadExpresion[0];
                                consumirCaracteres = 1;
                                if (cadTmp.length() <= 1) break;
                                consumirCaracteres = cadTmp.length();
                                break;
                            }
                            case 2: {
                                pos = Integer.valueOf(cadExpresion[0]);
                                cadTmp = cadExpresion[1];
                                consumirCaracteres = 0;
                                break;
                            }
                            case 3: {
                                pos = Integer.valueOf(cadExpresion[0]);
                                cadTmp = "";
                                if (pos2 < 1) {
                                    throw new ExceptionMotor("Cadena constante no valida : " + cadenaAIdentificar);
                                }
                                for (pos2 = Integer.valueOf(cadExpresion[1]).intValue(); pos2 > 0; --pos2) {
                                    cadTmp = cadTmp + cadExpresion[2];
                                }
                                consumirCaracteres = 0;
                                break;
                            }
                            default: {
                                throw new ExceptionMotor("Parametros en propiedad Constante incorrectos!!");
                            }
                        }
                        if (!cadenaAIdentificar.substring(pos).startsWith(cadTmp)) {
                            if (cadenaAIdentificar.length() == cadTmp.length() && listaTablas.get(i).getPropiedadesTabla().containsKey("VARIABLE")) {
                                this.getSesion().getOperaciones().establecerPartida(listaTablas.get(i).getPropiedadesTabla().get("VARIABLE"), cadenaAIdentificar);
                                encontrado = true;
                                break;
                            }
                            encontrado = false;
                            break;
                        }
                        encontrado = true;
                    }
                }
                if (!encontrado) continue;
                TipoDatosIdentificarTabla ret = new TipoDatosIdentificarTabla();
                ret.setIndice(i);
                ret.setPosicionesAConsumir(consumirCaracteres);
                return ret;
            }
            return null;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Cadena " + cadenaAIdentificar);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Cadena " + cadenaAIdentificar);
        }
    }

    @Override
    public IGestorTraduccionesBOE getGestorBoe() {
        return this.getGestorBOE();
    }

    @Override
    public int sacarLongitud(String cadena, Object propiedadLongitud) {
        try {
            if (propiedadLongitud == null) {
                return -1;
            }
            return Integer.valueOf(propiedadLongitud.toString());
        }
        catch (Exception e) {
            int pos = cadena.toUpperCase().indexOf(propiedadLongitud.toString().toUpperCase());
            if (pos == -1) {
                return -1;
            }
            if (pos != -1) {
                pos += propiedadLongitud.toString().length();
            }
            return pos;
        }
    }

    @Override
    public void setAnteriorLecturaConDatosPrincipal(boolean anteriorLecturaConDatosPrincipal) {
        this.anteriorLecturaConDatosPrincipal = anteriorLecturaConDatosPrincipal;
    }

    @Override
    public boolean isAnteriorLecturaConDatosPrincipal() {
        return this.anteriorLecturaConDatosPrincipal;
    }

    @Override
    public void setTiposDeRegistroDelFichero(List<String> tiposDeRegistroDelFichero) {
        this.tiposDeRegistroDelFichero = tiposDeRegistroDelFichero;
    }

    @Override
    public List<String> getTiposDeRegistroDelFichero() {
        return this.tiposDeRegistroDelFichero;
    }

    @Override
    public void setAnteriorCaracterLeido(int anteriorCaracterLeido) {
        this.anteriorCaracterLeido = anteriorCaracterLeido;
    }

    @Override
    public int getAnteriorCaracterLeido() {
        return this.anteriorCaracterLeido;
    }

    @Override
    public String getSaltoDeLinea() {
        return SALTO_DE_LINEA;
    }

    @Override
    public void setfR(IFileReaderBytes fR) {
        this.fR = fR;
    }

    @Override
    public IFileReaderBytes getfR() {
        return this.fR;
    }

    @Override
    public void setFicheroAbierto(boolean ficheroAbierto) {
        this.ficheroAbierto = ficheroAbierto;
    }

    @Override
    public boolean isFicheroAbierto() {
        return this.ficheroAbierto;
    }

    @Override
    public void setEof(boolean eof) {
        this.eof = eof;
    }

    @Override
    public boolean isEof() {
        return this.eof;
    }

    @Override
    public void setLinea(int linea) {
        this.linea = linea;
    }

    @Override
    public int getLinea() {
        return this.linea;
    }

    @Override
    public void setLineaReal(int lineaReal) {
        this.lineaReal = lineaReal;
    }

    @Override
    public int getLineaReal() {
        return this.lineaReal;
    }

    @Override
    public void setGestorBOE(IGestorTraduccionesBOE gestorBOE) {
        this.setGestor(gestorBOE);
    }

    @Override
    public IGestorTraduccionesBOE getGestorBOE() {
        return (IGestorTraduccionesBOE)this.getGestor();
    }

    @Override
    public void setFicheroActual(byte[] ficheroActual) {
        this.ficheroActual = ficheroActual;
    }

    @Override
    public byte[] getFicheroActual() {
        return this.ficheroActual;
    }

    @Override
    public void setArrSecuencia(List<String> arrSecuencia) {
        this.arrSecuencia = arrSecuencia;
    }

    @Override
    public List<String> getArrSecuencia() {
        return this.arrSecuencia;
    }

    @Override
    public void setWarning(List<String> warning) {
        this.warning = warning;
    }

    @Override
    public List<String> getWarning() {
        return this.warning;
    }

    @Override
    public void setLecturaDeLineasEstricta(boolean lecturaDeLineasEstricta) {
        this.lecturaDeLineasEstricta = lecturaDeLineasEstricta;
    }

    @Override
    public boolean isLecturaDeLineasEstricta() {
        return this.lecturaDeLineasEstricta;
    }

    @Override
    public boolean isPermitirTransformaciones() {
        return this.permitirTransformaciones;
    }

    @Override
    public void setPermitirTransformaciones(boolean permitirTransformaciones) {
        this.permitirTransformaciones = permitirTransformaciones;
    }

    @Override
    public ITipoDatoRetornoMetodo getTransformacionSegunTipoDatoRecursivo(String tipoDato) throws ExceptionMotor {
        try {
            if (tipoDato.equalsIgnoreCase("An")) {
                return new TipoDatoRetornoMetodo("MAYUSCULASACENTUADAS;MAYUSCULAS;AJUSTARNOMBRE");
            }
            if (tipoDato.equalsIgnoreCase("An")) {
                return new TipoDatoRetornoMetodo("MAYUSCULAS");
            }
            if (tipoDato.equalsIgnoreCase("A")) {
                return new TipoDatoRetornoMetodo("MAYUSCULASACENTUADAS;MAYUSCULAS;AJUSTARNOMBRE");
            }
            if (tipoDato.equalsIgnoreCase("Nif")) {
                return new TipoDatoRetornoMetodo("AJUSTARNIF");
            }
            return new TipoDatoRetornoMetodo("");
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }
}

