/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.gestionFicheros.importacion;

import es.aeat.pftw.mtrc.IAop;
import es.aeat.pftw.mtrc.gestionFicheros.IGestorFicheros;
import es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.GestorTraducciones;
import es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.IGestorTraducciones;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.tipos.ITipoDatosReglasTipoYPartidas;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrp.configuracion.IRegError;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.utilidades.INodoArbol;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class ComunChequear
implements IAop,
Serializable {
    private static final long serialVersionUID = 1L;
    private ISesion sesion = null;
    private INodoArbol prvArbolDelMotor = null;
    private Map<String, List<Long>> mRegistrosAValidar = null;
    private boolean superoNumeroMaximoErrores = false;
    private IGestorFicheros gestorFichero = null;

    @Override
    public void dispose() throws ExceptionMotor {
        this.sesion = null;
        this.prvArbolDelMotor = null;
        this.mRegistrosAValidar = null;
        this.gestorFichero = null;
    }

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            for (Object object : parametros) {
                if (!(object instanceof ISesion)) continue;
                this.sesion = (ISesion)object;
                this.gestorFichero = this.sesion.getGestorFicheros(this.sesion.getEntradaTransOpciones());
            }
            if (this.getSesion() == null) {
                throw new Exception("Falta por pasar la sesion al init!!!!");
            }
            this.prvArbolDelMotor = this.getSesion().getOperaciones().getArbolDatos();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected void ejecutarRecursivo(List<String> listaTablas, String nombreTabla, List<String> partidas, String localizcion) throws ExceptionMotor {
        String localizacion = localizcion;
        try {
            List<IRegError> erroresPartida = null;
            localizacion = localizacion.length() == 0 ? listaTablas.get(0).toString() : localizacion + "/" + listaTablas.get(0).toString();
            long con = 0L;
            String tabla = "";
            List<Long> ids = null;
            long idActual = -1L;
            boolean ejecutaRegistro = false;
            tabla = listaTablas.get(0).toString();
            con = this.getSesion().getOperaciones().recordCount(tabla);
            if (con > 0L) {
                idActual = this.getSesion().getOperaciones().moveFirst(tabla);
                int numReg = 0;
                while (true) {
                    int k;
                    ++numReg;
                    if (con < 1L) break;
                    --con;
                    if (tabla.equalsIgnoreCase(nombreTabla)) {
                        ejecutaRegistro = false;
                        if (this.getmRegistrosAValidar() == null) {
                            ejecutaRegistro = true;
                        } else {
                            ids = this.getmRegistrosAValidar().get(nombreTabla.toUpperCase());
                            if (ids != null) {
                                ejecutaRegistro = ids.contains(idActual);
                            }
                        }
                        if (ejecutaRegistro) {
                            for (int j = 0; j < partidas.size(); ++j) {
                                this.getSesion().getGestionReglas().chequear(partidas.get(j).toString());
                                erroresPartida = this.getSesion().getGestionReglas().getListaErroresEnReglas();
                                if (erroresPartida.size() <= 0) continue;
                                for (k = 0; k < erroresPartida.size(); ++k) {
                                    this.getGestorFichero().addError("", erroresPartida.get(k), null);
                                }
                            }
                        }
                    } else {
                        ArrayList<String> a = new ArrayList<String>();
                        for (k = 1; k < listaTablas.size(); ++k) {
                            a.add(listaTablas.get(k));
                        }
                        if (a.size() > 0) {
                            this.ejecutarRecursivo(a, nombreTabla, partidas, localizacion + "[" + numReg + "]");
                        }
                    }
                    if (con <= 0L) continue;
                    idActual = this.getSesion().getOperaciones().moveNext(tabla);
                }
            }
            if (this.getGestorFichero().errCount() != 0) {
                throw new ExceptionMotor("Hay errores...");
            }
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Tabla " + nombreTabla + " localizacion " + localizcion);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla + " localizacion " + localizcion);
        }
    }

    protected void ejecutarPartidasDeTabla(String nombreTabla, List<String> partidas) throws ExceptionMotor {
        try {
            if (this.getArbolDelMotor() == null) {
                throw new ExceptionMotor("Arbol del motor nulo");
            }
            INodoArbol n = this.getArbolDelMotor().buscaHijo(nombreTabla);
            ArrayList<String> listaTablas = new ArrayList<String>();
            listaTablas.add(nombreTabla);
            while ((n = n.getParent()) != null) {
                listaTablas.add(0, n.getNombreNodo());
            }
            this.ejecutarRecursivo(listaTablas, nombreTabla, partidas, "");
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    public boolean getSuperoNumeroMaximoErrores() {
        return this.isSuperoNumeroMaximoErrores();
    }

    protected void comunValidacionReglas(String claveBusqueda) throws ExceptionMotor {
        try {
            IGestorTraducciones gestor = (IGestorTraducciones)this.getGestorFichero().getGestorTraducciones();
            if (gestor == null && (gestor = (IGestorTraducciones)FuncionesUtiles.getFuncionesUtiles().getInstancia(GestorTraducciones.class, new Object[]{this.getSesion().getModelo()})).cargarEstructura(this.getGestorFichero().getFicheroGestorTraducciones())) {
                this.getGestorFichero().setGestorTraducciones(gestor);
            }
            List<ITipoDatosReglasTipoYPartidas> datos = null;
            datos = claveBusqueda.equalsIgnoreCase("Fichero") ? gestor.getReglasFichero() : gestor.getReglasRegistro();
            if (datos == null) {
                throw new ExceptionMotor("Error al cargar las estructuras del fichero de traducciones");
            }
            if (datos.size() == 0) {
                return;
            }
            this.getGestorFichero().fireProgressEvent(0, datos.size() / 2);
            for (int i = 0; i < datos.size(); ++i) {
                this.ejecutarPartidasDeTabla(datos.get(i).getNombreRegistro(), datos.get(i).getPartidas());
                this.getGestorFichero().fireProgressEvent();
            }
            if (this.getGestorFichero().errCount() != 0) {
                throw new ExceptionMotor("Hay errores...");
            }
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Clave " + claveBusqueda);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Clave " + claveBusqueda);
        }
    }

    public List<IRegError> getListaErrores() throws ExceptionMotor {
        try {
            return this.getGestorFichero().getListaErrores();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public void validar(String claveBusqueda, Map<String, List<Long>> registrosAValidar) throws ExceptionMotor {
        try {
            this.setmRegistrosAValidar(registrosAValidar);
            if (this.getSesion() == null) {
                throw new ExceptionMotor("Sesion no v\u00e1lida");
            }
            if (this.getArbolDelMotor() == null) {
                throw new ExceptionMotor("Arbol del Motor no v\u00e1lido");
            }
            this.setSuperoNumeroMaximoErrores(false);
            this.getGestorFichero().errClear();
            this.comunValidacionReglas(claveBusqueda);
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Clave " + claveBusqueda);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Clave " + claveBusqueda);
        }
    }

    abstract void validar(Map<String, List<Long>> var1) throws ExceptionMotor;

    protected void setArbolDelMotor(INodoArbol arbolDelMotor) {
        this.setPrvArbolDelMotor(arbolDelMotor);
    }

    protected INodoArbol getArbolDelMotor() {
        return this.getPrvArbolDelMotor();
    }

    private void setmRegistrosAValidar(Map<String, List<Long>> mRegistrosAValidar) {
        this.mRegistrosAValidar = mRegistrosAValidar;
    }

    private Map<String, List<Long>> getmRegistrosAValidar() {
        return this.mRegistrosAValidar;
    }

    protected void setSuperoNumeroMaximoErrores(boolean superoNumeroMaximoErrores) {
        this.superoNumeroMaximoErrores = superoNumeroMaximoErrores;
    }

    protected boolean isSuperoNumeroMaximoErrores() {
        return this.superoNumeroMaximoErrores;
    }

    protected void setGestorFichero(IGestorFicheros gestorFichero) {
        this.gestorFichero = gestorFichero;
    }

    protected IGestorFicheros getGestorFichero() {
        return this.gestorFichero;
    }

    protected void setSesion(ISesion sesion) {
        this.sesion = sesion;
    }

    protected ISesion getSesion() {
        return this.sesion;
    }

    protected void setPrvArbolDelMotor(INodoArbol prvArbolDelMotor) {
        this.prvArbolDelMotor = prvArbolDelMotor;
    }

    protected INodoArbol getPrvArbolDelMotor() {
        return this.prvArbolDelMotor;
    }
}

