/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.gestionFicheros.importacion;

import es.aeat.pftw.mtrc.IAop;
import es.aeat.pftw.mtrc.gestionFicheros.IGestorFicheros;
import es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.IGestorTraducciones;
import es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.boe.IGestorTraduccionesBOE;
import es.aeat.pftw.mtrc.gestionFicheros.importacion.IComun;
import es.aeat.pftw.mtrc.motor.modelo.IModelo;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrp.configuracion.IRegError;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import java.io.Serializable;
import java.util.List;

public abstract class Comun
implements IAop,
Serializable,
IComun {
    private static final long serialVersionUID = 1L;
    private boolean correcto = true;
    private String coletillaWarning = "";
    private String transf = "";
    private IGestorFicheros gestorFichero = null;
    private boolean superoNumeroMaximoErrores = false;
    private IGestorTraducciones gestor = null;
    private transient IModelo modelo = null;
    private transient ISesion sesion = null;

    @Override
    public void dispose() throws ExceptionMotor {
        this.gestorFichero = null;
        this.gestor = null;
    }

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            String clase = IGestorTraduccionesBOE.class.getName();
            for (Object object : parametros) {
                if (object instanceof ISesion) {
                    this.sesion = (ISesion)object;
                    this.setGestorFichero(this.sesion.getGestorFicheros(this.sesion.getEntradaTransOpciones()));
                    continue;
                }
                if (object instanceof IModelo) {
                    this.modelo = (IModelo)object;
                    continue;
                }
                if (object instanceof IGestorTraducciones) {
                    this.gestor = (IGestorTraducciones)object;
                    continue;
                }
                if (!(object instanceof String)) continue;
                clase = object.toString();
            }
            if (this.getSesion() == null && this.modelo == null) {
                throw new ExceptionMotor("Init incompleto!!!");
            }
            if (this.modelo == null && this.getSesion() != null) {
                this.modelo = this.getSesion().getModelo();
            }
            if (this.gestor == null) {
                this.gestor = (IGestorTraducciones)this.getGestorFichero().getGestorTraducciones();
            }
            if (this.gestor == null && this.modelo != null) {
                this.gestor = this.modelo.getGestorTraduccionesBOE(this.sesion);
            }
            if (this.gestor == null && this.modelo != null) {
                this.gestor = (IGestorTraducciones)FuncionesUtiles.getFuncionesUtiles().getInstancia(Class.forName(clase), new Object[]{this.modelo});
                if (this.gestor.cargarEstructura(this.getGestorFichero().getFicheroGestorTraducciones())) {
                    this.getGestorFichero().setGestorTraducciones(this.gestor);
                } else {
                    this.gestor = null;
                    FuncionesUtiles.getFuncionesUtiles().muestraError(new ExceptionMotor("Imposible abrir GestorTraducciones"));
                }
            }
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public IGestorFicheros getGestorFichero() {
        return this.gestorFichero;
    }

    @Override
    public void setGestorFichero(IGestorFicheros gestorFichero) {
        this.gestorFichero = gestorFichero;
    }

    @Override
    public void setSuperoNumeroMaximoErrores(boolean superoNumeroMaximoErrores) {
        this.superoNumeroMaximoErrores = superoNumeroMaximoErrores;
        try {
            IRegError errMax;
            if (superoNumeroMaximoErrores && (this.getGestorFichero().getListaErrores().size() == 0 || !this.getGestorFichero().getListaErrores().get(this.getGestorFichero().getListaErrores().size() - 1).getIdError().equalsIgnoreCase("MAXERR")) && (errMax = this.getModelo().getGestorConfiguracion().getError("MAXERR")) != null) {
                this.getGestorFichero().getListaErrores().add(errMax);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isSuperoNumeroMaximoErrores() {
        return this.superoNumeroMaximoErrores;
    }

    @Override
    public void setGestor(IGestorTraducciones gestor) {
        this.gestor = gestor;
    }

    @Override
    public IGestorTraducciones getGestor() {
        return this.gestor;
    }

    @Override
    public void setColetillaWarning(String coletillaWarning) {
        this.coletillaWarning = coletillaWarning;
    }

    @Override
    public String getColetillaWarning() {
        return this.coletillaWarning;
    }

    @Override
    public String setTransf(String transf) {
        this.transf = transf;
        return transf;
    }

    @Override
    public String getTransf() {
        return this.transf;
    }

    @Override
    public void setCorrecto(boolean correcto) {
        this.correcto = correcto;
    }

    @Override
    public boolean isCorrecto() {
        return this.correcto;
    }

    @Override
    public IModelo getModelo() {
        return this.modelo;
    }

    @Override
    public void setModelo(IModelo modelo) throws ExceptionMotor {
        try {
            this.modelo = modelo;
            this.setGestor(modelo.getGestorTraduccionesBOE(this.sesion));
            this.getGestor().setModelo(modelo);
            if (this.getGestorFichero() != null) {
                this.getGestorFichero().setGestorTraducciones(modelo.getGestorTraduccionesBOE(this.sesion));
            }
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void setSesion(ISesion sesion) throws ExceptionMotor {
        try {
            this.sesion = sesion;
            this.setModelo(sesion.getModelo());
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public ISesion getSesion() {
        return this.sesion;
    }

    @Override
    public List<IRegError> getListaErrores() throws ExceptionMotor {
        try {
            return this.getGestorFichero().getListaErrores();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public List<IRegError> getListaWarning() throws ExceptionMotor {
        try {
            return this.getGestorFichero().getListaWarning();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }
}

