/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.xml;

import es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.GestorTraducciones;
import es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.xml.IGestorTraduccionesXML;
import es.aeat.pftw.mtrc.tipos.ITipoDatosTabla;
import es.aeat.pftw.mtrc.tipos.TipoDatosCampos;
import es.aeat.pftw.mtrc.utilidades.HashMapNoCase;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampos;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GestorTraduccionesXML
extends GestorTraducciones
implements IGestorTraduccionesXML {
    private static final long serialVersionUID = 1L;
    private Map<String, String> listaTablasOrdenadasPorEquivalencia = null;
    private Map<String, String> listaCamposOrdenadasPorEquivalencia = null;
    private Map<String, List<Object>> listaCamposSinEquivalencia = null;
    private Map<String, Map<String, String>> listaCamposEnAtributos = null;
    private Map<String, String> corrPartidaCampoEnAtributos = null;
    private Map<String, String> listaXmlNS = null;
    private String nodoNamespaces = "";
    protected String tablaRaiz = "";

    protected void comunCargarEstructura() throws ExceptionMotor {
        this.listaTablasOrdenadasPorEquivalencia = null;
        this.listaCamposOrdenadasPorEquivalencia = null;
        this.listaCamposEnAtributos = null;
        this.corrPartidaCampoEnAtributos = null;
        this.listaXmlNS = null;
    }

    @Override
    public boolean cargarEstructura(InputStream ficheroTraduccion) throws ExceptionMotor {
        this.comunCargarEstructura();
        return super.cargarEstructura(ficheroTraduccion);
    }

    @Override
    public boolean cargarEstructura(InputStream[] ficheroTraduccion) throws ExceptionMotor {
        this.comunCargarEstructura();
        return super.cargarEstructura(ficheroTraduccion);
    }

    public String sustituyeNameSpacePorPathCompleto(String etiqueta) throws Exception {
        int posNameSpace = etiqueta.indexOf(":");
        if (posNameSpace > -1) {
            return etiqueta.replaceAll(etiqueta.substring(0, posNameSpace + 1), this.getRutaXmlNS(etiqueta.substring(0, posNameSpace)) + ":");
        }
        return etiqueta;
    }

    @Override
    public String getTablaConEquivalencia(String equivalencia) throws ExceptionMotor {
        try {
            String ret;
            equivalencia = this.sustituyeNameSpacePorPathCompleto(equivalencia);
            if (this.listaTablasOrdenadasPorEquivalencia == null) {
                this.listaTablasOrdenadasPorEquivalencia = new HashMapNoCase<String, String>();
                for (int i = 0; i < this.getListaTablas().size(); ++i) {
                    this.listaTablasOrdenadasPorEquivalencia.put(this.sustituyeNameSpacePorPathCompleto(this.getListaTablas().get(i).getPropiedadesTabla().get("EQUIVALENCIA").toString().toUpperCase()), this.getListaTablas().get(i).getNombreTabla().toUpperCase());
                }
            }
            if ((ret = this.listaTablasOrdenadasPorEquivalencia.get(equivalencia)) == null) {
                return "";
            }
            return ret;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public String getCampoConEquivalencia(String equivalencia) throws ExceptionMotor {
        try {
            String ret;
            equivalencia = this.sustituyeNameSpacePorPathCompleto(equivalencia);
            if (this.listaCamposOrdenadasPorEquivalencia == null) {
                this.listaCamposOrdenadasPorEquivalencia = new HashMapNoCase<String, String>();
                String obj2 = null;
                Set<String> s = this.getListaCampos().keySet();
                for (String obj2 : s) {
                    try {
                        this.listaCamposOrdenadasPorEquivalencia.put(this.sustituyeNameSpacePorPathCompleto(this.getListaCampos().get(obj2).get("EQUIVALENCIA").toString()), obj2);
                    }
                    catch (Exception Ex) {}
                }
            }
            if ((ret = this.listaCamposOrdenadasPorEquivalencia.get(equivalencia)) == null) {
                return "";
            }
            return ret;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public String getNodoNamespaces() throws ExceptionMotor {
        return this.nodoNamespaces;
    }

    @Override
    public Map<String, String> getListaXmlNS() throws ExceptionMotor {
        if (this.listaXmlNS == null) {
            this.listaXmlNS = new HashMapNoCase<String, String>();
        }
        return this.listaXmlNS;
    }

    @Override
    public String getRutaXmlNS(String nombreXmlNS) throws ExceptionMotor {
        return this.getListaXmlNS().get(nombreXmlNS);
    }

    @Override
    public String getNombreXmlNS(String rutaXmlNS) throws ExceptionMotor {
        for (String xmlNS : this.getListaXmlNS().keySet()) {
            if (!this.getListaXmlNS().get(xmlNS).toString().equalsIgnoreCase(rutaXmlNS)) continue;
            return xmlNS;
        }
        return null;
    }

    @Override
    public void addNombreYRutaXmlNS(String nombreXmlNS, String rutaXmlNS) throws ExceptionMotor {
        this.getListaXmlNS().put(nombreXmlNS, rutaXmlNS);
    }

    @Override
    public Map<String, String> getListaCamposEnAtributos(String nombreCampo) throws ExceptionMotor {
        if (this.listaCamposEnAtributos == null) {
            this.listaCamposEnAtributos = new HashMapNoCase<String, Map<String, String>>();
        }
        return this.listaCamposEnAtributos.get(nombreCampo);
    }

    @Override
    public Map<String, String> getPropPartidaEnAtributo(String partida) throws ExceptionMotor {
        if (this.corrPartidaCampoEnAtributos == null) {
            this.corrPartidaCampoEnAtributos = new HashMap<String, String>();
        }
        if (this.corrPartidaCampoEnAtributos.containsKey(partida)) {
            return this.getListaCamposEnAtributos(this.corrPartidaCampoEnAtributos.get(partida));
        }
        return null;
    }

    public List<Object> getCamposSinEquivalencia(String nombreTabla) throws ExceptionMotor {
        try {
            List<Object> ret;
            if (this.listaCamposSinEquivalencia == null) {
                this.listaCamposSinEquivalencia = new HashMapNoCase<String, List<Object>>();
            }
            if ((ret = this.listaCamposSinEquivalencia.get(nombreTabla = nombreTabla.toUpperCase())) == null) {
                for (int i = 0; i < this.getListaTablas().size(); ++i) {
                    if (!this.getListaTablas().get(i).getNombreTabla().equalsIgnoreCase(nombreTabla)) continue;
                    ret = new ArrayList<Object>();
                    List<ITipoDatosCampos> campos = this.getListaTablas().get(i).getCampos();
                    for (int j = 0; j < campos.size(); ++j) {
                        if (campos.get(j).getPropiedadesCampos().get("SINEQUIVALENCIA") == null) continue;
                        ret.add(campos.get(j).getNombreCampo());
                    }
                    this.listaCamposSinEquivalencia.put(nombreTabla, ret);
                    break;
                }
            }
            if (ret == null) {
                System.err.println("No se encontro tabla " + nombreTabla);
                ret = new ArrayList<Object>();
            }
            return ret;
        }
        catch (Exception Ex) {
            return new ArrayList<Object>();
        }
    }

    @Override
    protected boolean examinarNodo(Node nodo) throws ExceptionMotor {
        try {
            int j = 0;
            int k = 0;
            NodeList listaNodosHijos = null;
            HashMapNoCase<String, String> hashCampos = null;
            NamedNodeMap attr = null;
            String nombre = nodo.getNodeName();
            if (this.tablaRaiz.length() == 0 && nombre.equalsIgnoreCase("TABLA")) {
                listaNodosHijos = nodo.getChildNodes();
                block3: for (j = 0; j < listaNodosHijos.getLength(); ++j) {
                    if (listaNodosHijos.item(j).getNodeType() != 1 || !listaNodosHijos.item(j).getNodeName().equalsIgnoreCase("NOMBRE")) continue;
                    attr = listaNodosHijos.item(j).getAttributes();
                    for (k = 0; k < attr.getLength(); ++k) {
                        if (!attr.item(k).getNodeName().toUpperCase().equalsIgnoreCase("EQUIVALENCIA")) continue;
                        this.tablaRaiz = attr.item(k).getNodeValue().split("/")[0];
                        continue block3;
                    }
                }
            }
            if (nombre.equalsIgnoreCase("CAMPOSENATRIBUTOS")) {
                String nombreCampo = "";
                listaNodosHijos = nodo.getChildNodes();
                for (j = 0; j < listaNodosHijos.getLength(); ++j) {
                    if (listaNodosHijos.item(j).getNodeType() != 1 || !listaNodosHijos.item(j).getNodeName().equalsIgnoreCase("CAMPO")) continue;
                    hashCampos = new HashMapNoCase<String, String>();
                    attr = listaNodosHijos.item(j).getAttributes();
                    for (k = 0; k < attr.getLength(); ++k) {
                        hashCampos.put(attr.item(k).getNodeName(), attr.item(k).getNodeValue());
                    }
                    nombreCampo = "";
                    if (listaNodosHijos.item(j).getChildNodes().item(0) == null) {
                        throw new ExceptionMotor("Campo sin nombre en etiqueta CAMPOSENATRIBUTOS");
                    }
                    nombreCampo = listaNodosHijos.item(j).getChildNodes().item(0).getNodeValue();
                    hashCampos.put("CORRESPONDENCIA_ATRIBUTO", nombreCampo);
                    if (this.getListaCamposEnAtributos(nombreCampo) != null) {
                        throw new ExceptionMotor("Campo " + nombreCampo + " duplicado en etiqueta " + "CAMPOSENATRIBUTOS");
                    }
                    this.listaCamposEnAtributos.put(nombreCampo, hashCampos);
                    if (hashCampos.containsKey("PARTIDA")) {
                        if (this.corrPartidaCampoEnAtributos == null) {
                            this.corrPartidaCampoEnAtributos = new HashMap<String, String>();
                        }
                        this.corrPartidaCampoEnAtributos.put((String)hashCampos.get("PARTIDA"), nombreCampo);
                    }
                    hashCampos = null;
                }
                return true;
            }
            if (nombre.equalsIgnoreCase("NAMESPACES")) {
                String rutaXmlNS = "";
                String nombreXmlns = "";
                attr = nodo.getAttributes();
                for (k = 0; k < attr.getLength(); ++k) {
                    if (!attr.item(k).getNodeName().equalsIgnoreCase("NODO")) continue;
                    this.nodoNamespaces = attr.item(k).getNodeValue();
                    break;
                }
                listaNodosHijos = nodo.getChildNodes();
                for (j = 0; j < listaNodosHijos.getLength(); ++j) {
                    if (listaNodosHijos.item(j).getNodeType() != 1 || !listaNodosHijos.item(j).getNodeName().equalsIgnoreCase("XMLNS") && !listaNodosHijos.item(j).getNodeName().equalsIgnoreCase("XSI")) continue;
                    rutaXmlNS = "";
                    nombreXmlns = "";
                    attr = listaNodosHijos.item(j).getAttributes();
                    for (k = 0; k < attr.getLength(); ++k) {
                        if (!attr.item(k).getNodeName().equalsIgnoreCase("NOMBRE")) continue;
                        nombreXmlns = attr.item(k).getNodeValue();
                        break;
                    }
                    if (nombreXmlns.trim().length() == 0) {
                        throw new ExceptionMotor("NameSpace sin etiqueta NOMBRE");
                    }
                    if (listaNodosHijos.item(j).getChildNodes().item(0) == null) {
                        throw new ExceptionMotor("XmlNS sin espacio de nombres en etiqueta CAMPOSENATRIBUTOS");
                    }
                    rutaXmlNS = listaNodosHijos.item(j).getChildNodes().item(0).getNodeValue();
                    if (listaNodosHijos.item(j).getNodeName().equalsIgnoreCase("XSI")) {
                        rutaXmlNS = "xsi:" + nombreXmlns + "=\"" + rutaXmlNS + "\"";
                        nombreXmlns = "CASO_ESPECIAL_NAMESPACES";
                    }
                    this.getListaXmlNS().put(nombreXmlns, rutaXmlNS);
                }
                return true;
            }
            return super.examinarNodo(nodo);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected void anniadirAtributosDeCampo(ITipoDatosTabla tablaActual, List<ITipoDatosCampos> camposDeTabla, TipoDatosCampos cmp, HashMap<String, String> hashCampos) throws ExceptionMotor {
        try {
            if (hashCampos != null && hashCampos.containsKey("CAMPO_ATRIBUTO")) {
                Map<String, String> prop = this.getListaCamposEnAtributos(hashCampos.get("CAMPO_ATRIBUTO"));
                if (cmp == null) {
                    prop.put("ATRIBUTO_PARA_TABLA", "true");
                }
                TipoDatosCampos cmp2 = new TipoDatosCampos(prop.get("PARTIDA"));
                cmp2.setPropiedadesCampos(prop);
                camposDeTabla.add(cmp2);
            }
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    protected void anniadirCampo(ITipoDatosTabla tablaActual, List<ITipoDatosCampos> camposDeTabla, TipoDatosCampos cmp, HashMap<String, String> hashCampos) throws ExceptionMotor {
        this.anniadirAtributosDeCampo(tablaActual, camposDeTabla, cmp, hashCampos);
        if (cmp != null) {
            super.anniadirCampo(tablaActual, camposDeTabla, cmp, hashCampos);
        }
    }

    @Override
    public String getTablaRaiz() throws ExceptionMotor {
        return this.tablaRaiz;
    }
}

