/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.boe;

import es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.GestorTraducciones;
import es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.boe.IGestorTraduccionesBOE;
import es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.boe.IGestorTraduccionesBOECaller;
import es.aeat.pftw.mtrc.tipos.ITipoDatosTabla;
import es.aeat.pftw.mtrc.tipos.TipoDatoRetornoMetodo;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.utilidades.StringUtility;
import es.aeat.pftw.mtrc.utilidades.Validaciones;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.tipos.ITipoDatoRetornoMetodo;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampos;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GestorTraduccionesBOE
extends GestorTraducciones
implements IGestorTraduccionesBOE,
IGestorTraduccionesBOECaller {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean esNumericaAEAT(String sCadena) {
        try {
            for (int i = 0; i < sCadena.length(); ++i) {
                if (Character.isDigit(sCadena.charAt(i))) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public boolean esnumericaConSignoAEAT(String sCadena) {
        try {
            if (sCadena.length() == 0) {
                return false;
            }
            if (!this.isEsNumeroPositivoCon0()) {
                if (sCadena.charAt(0) == 'N' || sCadena.charAt(0) == ' ') {
                    boolean res = this.esNumericaAEAT(sCadena.substring(1, sCadena.length()));
                    if (res && sCadena.charAt(0) == 'N' && Long.valueOf(sCadena.substring(1, sCadena.length())) == 0L && !this.isAdmitoN00000000()) {
                        return false;
                    }
                    return res;
                }
                return false;
            }
            if (sCadena.charAt(0) == 'N' || this.esNumericaAEAT(String.valueOf(sCadena.charAt(0)))) {
                boolean res = this.esNumericaAEAT(sCadena.substring(1, sCadena.length()));
                if (res && sCadena.charAt(0) == 'N' && Long.valueOf(sCadena.substring(1, sCadena.length())) == 0L && !this.isAdmitoN00000000()) {
                    return false;
                }
                return res;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public List<String> validacampo(String nombreCampo, String valor) throws ExceptionMotor {
        try {
            return this.validaCampo(this.getCampo(nombreCampo), valor);
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " valor " + valor);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, nombreCampo + " valor " + valor);
        }
    }

    public List<String> validaLongitudCampo(Map<String, String> propiedades, String valor) throws ExceptionMotor {
        try {
            ArrayList<String> res = new ArrayList<String>();
            String prop = propiedades.get("LONGITUD");
            if (prop != null) {
                if (prop.toString().equals("0")) {
                    return res;
                }
                if (FuncionesUtiles.getFuncionesUtiles().esNumerico(prop.toString()) && valor.length() > new Integer(prop.toString())) {
                    res.add("LNGINC");
                }
            }
            return res;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public List<String> validaCampo(Map<String, String> propiedades, String valor) throws ExceptionMotor {
        ITipoDatoRetornoMetodo ret;
        if (this.getModelo() != null && this.getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getModelo().getFuncionalidadPersonalizadaModelo().validaCampo(this, propiedades, valor)).isRetornaResultado()) {
            return ret.getObjetoRetornoAsList();
        }
        return this.validaCampoRecursivo(propiedades, valor).getObjetoRetornoAsList();
    }

    @Override
    public ITipoDatoRetornoMetodo validaCampoRecursivo(Map<String, String> propiedades, String valor) throws ExceptionMotor {
        try {
            List<String> res = new ArrayList<String>();
            if (propiedades != null) {
                FuncionesUtiles.getFuncionesUtiles().concatenaArrayListStrings(res, this.validaLongitudCampo(propiedades, valor));
                String prop = propiedades.get("TIPODATO");
                if (prop != null) {
                    if (prop.toString().trim().equalsIgnoreCase("CONV_FECHA")) {
                        if (!this.esAlfanumericaAEAT(valor)) {
                            res.add(this.errorChrValidos(propiedades));
                        }
                    } else if (prop.toString().trim().equalsIgnoreCase("An")) {
                        if (this.esAlfanumericaAEAT(valor)) {
                            if (propiedades.get("CON_BLANCOS_EN_MEDIO") != null && propiedades.get("CON_BLANCOS_EN_MEDIO").toString().equalsIgnoreCase("true")) {
                                String valorAux = valor;
                                if (!valorAux.trim().equalsIgnoreCase(valor)) {
                                    res.add(this.errorChrValidos(propiedades));
                                }
                            } else if (this.cadenaEmpiezaPorBlancosOVariosBlancosSeguidos(valor)) {
                                res.add(this.errorChrValidos(propiedades));
                            }
                        } else {
                            res.add(this.errorChrValidos(propiedades));
                        }
                    } else if (prop.toString().trim().equalsIgnoreCase("A")) {
                        if (this.esAlfabeticoAEAT(valor)) {
                            if (this.cadenaEmpiezaPorBlancosOVariosBlancosSeguidos(valor)) {
                                res.add(this.errorChrValidos(propiedades));
                            }
                        } else {
                            res.add(this.errorChrValidos(propiedades));
                        }
                    } else if (prop.toString().trim().equalsIgnoreCase("CADNUM2")) {
                        if (!this.esNumericaAEAT(valor) && valor.trim().length() > 0) {
                            res.add(this.errorChrValidos(propiedades));
                        }
                    } else if (prop.toString().trim().equalsIgnoreCase("Num") || prop.toString().trim().equalsIgnoreCase("CADNUM") || prop.toString().trim().equalsIgnoreCase("FECHA_SIN_FORMATO") || prop.toString().trim().equalsIgnoreCase("FechaInvertida")) {
                        if (!this.esNumericaAEAT(valor)) {
                            res.add(this.errorChrValidos(propiedades));
                        }
                    } else if (prop.toString().trim().equalsIgnoreCase("NumSigno")) {
                        if (!this.esnumericaConSignoAEAT(valor)) {
                            res.add(this.errorChrValidos(propiedades));
                        }
                    } else if (prop.toString().toUpperCase().trim().indexOf("CTE:") == 0) {
                        String longitudAux;
                        int longitud;
                        char[] chr = FuncionesUtiles.getFuncionesUtiles().desCodificaCadena(prop.toString().substring(4)).toCharArray();
                        if (chr.length != (longitud = Integer.valueOf((longitudAux = propiedades.get("LONGITUD")).toString()).intValue())) {
                            String cadena = chr[0] + "";
                            for (int k = 1; k < longitud; ++k) {
                                cadena = cadena + chr[0] + "";
                            }
                            chr = cadena.toCharArray();
                        }
                        for (int i = 0; i < valor.length(); ++i) {
                            if (valor.charAt(i) == chr[i]) continue;
                            res.add(this.errorChrValidos(propiedades));
                            break;
                        }
                    } else if (prop.toString().trim().indexOf("Valores") == 0) {
                        boolean correcto = false;
                        String[] p = StringUtility.getStringUtility().split(prop.toString(), ":");
                        for (int i = 0; i < p.length; ++i) {
                            String[] q = StringUtility.getStringUtility().split(p[i], "=");
                            if (q.length != 2 || valor.compareTo(FuncionesUtiles.getFuncionesUtiles().desCodificaCadena(q[0])) != 0) continue;
                            correcto = true;
                            break;
                        }
                        if (!correcto) {
                            res.add(this.errorChrValidos(propiedades));
                        }
                    } else if (prop.toString().trim().equalsIgnoreCase("Nif")) {
                        if (!this.esAlfanumericaAEAT(valor) || valor.indexOf(32) != -1 && valor.trim().length() > 0) {
                            res.add(this.errorChrValidos(propiedades));
                        }
                    } else if (!prop.toString().trim().equalsIgnoreCase("Nv")) {
                        if (prop.toString().trim().equalsIgnoreCase("1_a_true")) {
                            switch (valor.charAt(0)) {
                                case '0': 
                                case '1': {
                                    break;
                                }
                                default: {
                                    res.add(this.errorChrValidos(propiedades));
                                    break;
                                }
                            }
                        } else if (prop.toString().trim().equalsIgnoreCase("X_a_true")) {
                            switch (valor.charAt(0)) {
                                case ' ': 
                                case 'X': {
                                    break;
                                }
                                default: {
                                    res.add(this.errorChrValidos(propiedades));
                                    break;
                                }
                            }
                        } else if (!prop.toString().trim().equalsIgnoreCase("SELLO")) {
                            if (prop.toString().trim().equalsIgnoreCase("TEL")) {
                                String sAux = valor.trim();
                                if (sAux.length() > 0 && !this.esTelefonoEuropeo(sAux)) {
                                    res.add(this.errorChrValidos(propiedades));
                                    return new TipoDatoRetornoMetodo(res);
                                }
                            } else {
                                if (prop.toString().trim().equalsIgnoreCase("EMAIL")) {
                                    String sAux = valor.trim();
                                    if (sAux.trim().length() > 0 && sAux.startsWith(" ")) {
                                        res.add(this.errorChrValidos(propiedades));
                                        return new TipoDatoRetornoMetodo(res);
                                    }
                                    char[] cadena = sAux.toUpperCase().toCharArray();
                                    for (int i = 0; i < sAux.length(); ++i) {
                                        if ("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-._@\u00d1\u00c7\u00b4\\:;&/()".indexOf(cadena[i]) != -1) continue;
                                        res.add(this.errorChrValidos(propiedades));
                                        break;
                                    }
                                    return new TipoDatoRetornoMetodo(res);
                                }
                                if (prop.toString().trim().toUpperCase().startsWith("DE_")) {
                                    int i = prop.toString().toUpperCase().substring(3).indexOf("A");
                                    if (i == -1) {
                                        throw new Exception("Tipo de dato De_XaY mal construido");
                                    }
                                    int inicio = Integer.parseInt(prop.toString().toUpperCase().substring(3, i += 3));
                                    int fin = Integer.parseInt(prop.toString().toUpperCase().substring(i + 1));
                                    if (!this.esNumericaAEAT(valor) || Integer.valueOf(valor) < inicio || Integer.valueOf(valor) > fin) {
                                        res.add(this.errorChrValidos(propiedades));
                                    }
                                    return new TipoDatoRetornoMetodo(res);
                                }
                                if (prop.toString().trim().toUpperCase().startsWith("ORDINALCASILLAS")) {
                                    String[] params = prop.toString().trim().substring("ORDINALCASILLAS".length() + 1).split(",");
                                    if (!this.esNumericaAEAT(valor) || Integer.valueOf(valor) > params.length || Integer.valueOf(valor) < 0) {
                                        res.add(this.errorChrValidos(propiedades));
                                    }
                                    return new TipoDatoRetornoMetodo(res);
                                }
                                if (prop.toString().trim().toUpperCase().startsWith("LAQTENGAVALOR")) {
                                    String tipoDatoReal = propiedades.get("TIPODATOREAL");
                                    if (tipoDatoReal == null) {
                                        throw new Exception("El campo no tiene propiedad obligatoria TIPODATOREAL, revise TransXXX.xml");
                                    }
                                    propiedades.put("TIPODATO", tipoDatoReal.toString());
                                    res = this.validaCampo(propiedades, valor);
                                    propiedades.put("TIPODATO", prop.toString());
                                    return new TipoDatoRetornoMetodo(res);
                                }
                                if (prop.toString().trim().toUpperCase().startsWith("DEB_")) {
                                    int i = prop.toString().toUpperCase().substring(4).indexOf("A");
                                    if (i == -1) {
                                        throw new Exception("Tipo de dato DeB_XaY mal construido");
                                    }
                                    i += 4;
                                    if (valor.trim().length() == 0) {
                                        return new TipoDatoRetornoMetodo(res);
                                    }
                                    int inicio = Integer.parseInt(prop.toString().toUpperCase().substring(4, i));
                                    int fin = Integer.parseInt(prop.toString().toUpperCase().substring(i + 1));
                                    if (!this.esNumericaAEAT(valor) || Integer.valueOf(valor) < inicio || Integer.valueOf(valor) > fin) {
                                        res.add(this.errorChrValidos(propiedades));
                                    }
                                    return new TipoDatoRetornoMetodo(res);
                                }
                                FuncionesUtiles.getFuncionesUtiles().muestraAviso(new ExceptionMotor("No entendido atributo TipoDato =" + prop.toString() + " no se valida el tipo de campo"));
                            }
                        }
                    }
                }
            }
            return new TipoDatoRetornoMetodo(res);
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Valor " + valor);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Valor " + valor);
        }
    }

    @Override
    public List<String> validaCampoEx(Map<String, String> propiedades, String valor) throws ExceptionMotor {
        ITipoDatoRetornoMetodo ret;
        if (this.getModelo() != null && this.getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getModelo().getFuncionalidadPersonalizadaModelo().validaCampoEx(this, propiedades, valor)).isRetornaResultado()) {
            return ret.getObjetoRetornoAsList();
        }
        return this.validaCampoExRecursivo(propiedades, valor).getObjetoRetornoAsList();
    }

    @Override
    public ITipoDatoRetornoMetodo validaCampoExRecursivo(Map<String, String> propiedades, String valor) throws ExceptionMotor {
        try {
            String prop;
            ArrayList<String> res = new ArrayList<String>();
            if (propiedades != null && (prop = propiedades.get("Condicion".toUpperCase())) != null) {
                if (prop.toString().startsWith("=")) {
                    String traduccion = this.traduceCadena(FuncionesUtiles.getFuncionesUtiles().desCodificaCadena(prop.toString().substring(1)));
                    if (traduccion != null && !valor.equals(traduccion)) {
                        String err = propiedades.get("MENSAJE");
                        if (err != null) {
                            res.add(err.toString());
                        } else {
                            res.add("CONTINCCAMPO");
                        }
                    }
                } else if (prop.toString().startsWith("!")) {
                    String traduccion = this.traduceCadena(FuncionesUtiles.getFuncionesUtiles().desCodificaCadena(prop.toString().substring(1)));
                    if (traduccion != null && valor.equals(traduccion)) {
                        String err = propiedades.get("MENSAJE");
                        if (err != null) {
                            res.add(err.toString());
                        } else {
                            res.add("CONTINCCAMPO");
                        }
                    }
                } else {
                    throw new ExceptionMotor("Al atributo condicion length falta operador, Ejemplo CONDICION=\"=4\" ");
                }
            }
            return new TipoDatoRetornoMetodo(res);
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Valor " + valor);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Valor " + valor);
        }
    }

    @Override
    public String errorChrValidos(Map<String, String> propiedades) {
        try {
            String prop = propiedades.get("ERRORVC");
            if (prop != null) {
                return prop.toString();
            }
            return "CHRNV";
        }
        catch (Exception ex) {
            return "CHRNV";
        }
    }

    @Override
    public boolean cadenaEmpiezaPorBlancosOVariosBlancosSeguidos(String cad) {
        return Validaciones.getValidaciones().cadenaEmpiezaPorBlancosOVariosBlancosSeguidos(cad);
    }

    @Override
    public int[] getPosicionyLongitudCampo(String nombreCampo) throws ExceptionMotor {
        try {
            return this.getPosicionyLongitudCampo(nombreCampo, false, false);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected int[] getPosicionyLongitudCampo(String nombreCampo, boolean buscarEnTipoDato, boolean haySaltosDeLinea) throws ExceptionMotor {
        try {
            int contador = 0;
            Map<String, String> propiedadesCampo = null;
            for (ITipoDatosTabla tabla : this.getListaTablas()) {
                if (haySaltosDeLinea && contador > 0) {
                    contador += 2;
                }
                if (tabla.getPropiedadesTabla() != null && tabla.getPropiedadesTabla().containsKey("CONSTANTE")) {
                    contador += Integer.valueOf(tabla.getPropiedadesTabla().get("CONSTANTE").length()).intValue();
                } else if (tabla.getPropiedadesTabla() != null && tabla.getPropiedadesTabla().containsKey("VARIABLE")) {
                    String tamPartida = this.getModelo().getGestorConfiguracion().getEntrada(tabla.getPropiedadesTabla().get("VARIABLE")).getPropiedad("LONGITUD");
                    contador += Integer.valueOf(tamPartida).intValue();
                }
                for (ITipoDatosCampos campo : tabla.getCampos()) {
                    propiedadesCampo = campo.getPropiedadesCampos();
                    if (buscarEnTipoDato) {
                        if (propiedadesCampo.containsKey("TIPODATO") && propiedadesCampo.get("TIPODATO").equalsIgnoreCase(nombreCampo)) {
                            if (!propiedadesCampo.containsKey("LONGITUD")) {
                                throw new ExceptionMotor("El campo " + nombreCampo + " no tiene atributo tama\u00f1o en el TransBOE.xml!!!");
                            }
                            return new int[]{contador, Integer.valueOf(propiedadesCampo.get("LONGITUD"))};
                        }
                    } else if (campo.getNombreCampo().equalsIgnoreCase(nombreCampo)) {
                        return new int[]{contador, Integer.valueOf(propiedadesCampo.get("LONGITUD"))};
                    }
                    if (!propiedadesCampo.containsKey("LONGITUD")) continue;
                    contador += Integer.valueOf(propiedadesCampo.get("LONGITUD")).intValue();
                }
            }
            return null;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public int buscaPosicionDelSello(boolean haySaltosDeLinea) throws ExceptionMotor {
        try {
            int[] res = this.getPosicionyLongitudCampo("SELLO", true, haySaltosDeLinea);
            if (res != null) {
                return res[0];
            }
            return -1;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }
}

