/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones;

import es.aeat.pftw.mtrc.IAop;
import es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.IGestorTraducciones;
import es.aeat.pftw.mtrc.motor.modelo.IModelo;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.tipos.ITipoDatosReglasTipoYPartidas;
import es.aeat.pftw.mtrc.tipos.ITipoDatosTabla;
import es.aeat.pftw.mtrc.tipos.TipoDatosCampoValorEx;
import es.aeat.pftw.mtrc.tipos.TipoDatosCampos;
import es.aeat.pftw.mtrc.tipos.TipoDatosReglasTipoYPartidas;
import es.aeat.pftw.mtrc.tipos.TipoDatosTabla;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.utilidades.Validaciones;
import es.aeat.pftw.mtrp.configuracion.IRegEntrada;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.puente.ITablaMotorEntrada;
import es.aeat.pftw.mtrp.tipos.ITipoDatoRetornoMetodo;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampos;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class GestorTraducciones
implements IAop,
Serializable,
IGestorTraducciones {
    private static final long serialVersionUID = 1L;
    private List<Document> documentosTraduccion = null;
    private int contadorERRORVC = 0;
    private boolean esNumeroPositivoCon0 = false;
    private boolean admitoN00000000 = false;
    private String versionTrans = "0.0";
    private Map<String, String> listadoAtributosTransXXX = new HashMap<String, String>();
    private List<ITipoDatosTabla> listaTablas = new ArrayList<ITipoDatosTabla>();
    private List<ITipoDatosTabla> listaTablasOrdenadasParaReglas = new ArrayList<ITipoDatosTabla>();
    private List<ITipoDatosTabla> listaTablasAuxiliares = new ArrayList<ITipoDatosTabla>();
    private Map<String, Map<String, String>> listaCampos = new HashMap<String, Map<String, String>>();
    private Map<String, String> constantes = null;
    private Map<String, String> variables = null;
    private List<Object> secuencias = new ArrayList<Object>();
    private Map<String, String> configuracion = null;
    private Map<String, Map<String, String>> localizadorUnicoCampo = null;
    private Map<String, List<ITipoDatosCampos>> listaCamposDeTabla = null;
    private Map<String, List<String>> addTabla = new HashMap<String, List<String>>();
    private List<ITipoDatosReglasTipoYPartidas> reglasDeRegistro = new ArrayList<ITipoDatosReglasTipoYPartidas>();
    private List<ITipoDatosReglasTipoYPartidas> reglasDeFichero = new ArrayList<ITipoDatosReglasTipoYPartidas>();
    private transient IModelo modelo = null;

    @Override
    public void dispose() throws ExceptionMotor {
    }

    public GestorTraducciones() {
        this.localizadorUnicoCampo = new HashMap<String, Map<String, String>>();
        this.listaCamposDeTabla = new HashMap<String, List<ITipoDatosCampos>>();
        this.constantes = new HashMap<String, String>();
        this.variables = new HashMap<String, String>();
        this.configuracion = new HashMap<String, String>();
    }

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            for (Object object : parametros) {
                if (object instanceof IModelo) {
                    this.modelo = (IModelo)object;
                    continue;
                }
                if (!(object instanceof ISesion)) continue;
                ISesion sesion = (ISesion)object;
                if (this.modelo != null) continue;
                this.modelo = sesion.getModelo();
            }
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public String getVersionTrans() {
        return this.versionTrans;
    }

    @Override
    public IModelo getModelo() {
        return this.modelo;
    }

    @Override
    public void setModelo(IModelo m) {
        this.modelo = m;
    }

    protected boolean examinarNodo(Node nodo) throws ExceptionMotor {
        int j = 0;
        int k = 0;
        NodeList listaNodosHijos = null;
        NodeList listaNodosNietos = null;
        HashMap<String, String> hashCampos = null;
        NamedNodeMap attr = null;
        String nombre = nodo.getNodeName();
        if (nombre.equalsIgnoreCase("Configuracion")) {
            try {
                listaNodosHijos = nodo.getChildNodes();
                for (j = 0; j < listaNodosHijos.getLength(); ++j) {
                    if (listaNodosHijos.item(j).getNodeType() != 1) continue;
                    this.getConfiguracion().put(listaNodosHijos.item(j).getNodeName().toUpperCase(), listaNodosHijos.item(j).getChildNodes().item(0).getNodeValue());
                }
                return true;
            }
            catch (ExceptionMotor ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ExceptionMotor(ex);
            }
        }
        if (nombre.equalsIgnoreCase("Constantes")) {
            try {
                listaNodosHijos = nodo.getChildNodes();
                for (j = 0; j < listaNodosHijos.getLength(); ++j) {
                    if (listaNodosHijos.item(j).getNodeType() != 1) continue;
                    this.getConstantes().put(listaNodosHijos.item(j).getNodeName().toUpperCase(), listaNodosHijos.item(j).getChildNodes().item(0).getNodeValue());
                }
                return true;
            }
            catch (ExceptionMotor ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ExceptionMotor(ex);
            }
        }
        if (nombre.equalsIgnoreCase("Variables")) {
            try {
                listaNodosHijos = nodo.getChildNodes();
                for (j = 0; j < listaNodosHijos.getLength(); ++j) {
                    if (listaNodosHijos.item(j).getNodeType() != 1) continue;
                    this.getVariables().put(listaNodosHijos.item(j).getNodeName().toUpperCase(), null);
                }
                return true;
            }
            catch (Exception ex) {
                throw new ExceptionMotor(ex);
            }
        }
        if (nombre.equalsIgnoreCase("Secuencias")) {
            try {
                listaNodosHijos = nodo.getChildNodes();
                hashCampos = null;
                for (j = 0; j < listaNodosHijos.getLength(); ++j) {
                    if (listaNodosHijos.item(j).getNodeType() != 1) continue;
                    hashCampos = new HashMap<String, String>();
                    attr = listaNodosHijos.item(j).getAttributes();
                    for (k = 0; k < attr.getLength(); ++k) {
                        hashCampos.put(attr.item(k).getNodeName().toUpperCase(), attr.item(k).getNodeValue().toUpperCase());
                    }
                    if (hashCampos.get("NOMBREFUNCION") == null) {
                        throw new ExceptionMotor("Error formato Secuencia : No encuentro NombreFuncion");
                    }
                    this.getSecuencias().add(listaNodosHijos.item(j).getChildNodes().item(0).getNodeValue().toUpperCase());
                    this.getSecuencias().add(hashCampos);
                    hashCampos = null;
                }
            }
            catch (ExceptionMotor ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ExceptionMotor(ex);
            }
        }
        if (nombre.equalsIgnoreCase("InicializacionTabla")) {
            ArrayList<String> campoyvalor = new ArrayList<String>();
            String tabla = "";
            listaNodosHijos = nodo.getChildNodes();
            for (j = 0; j < listaNodosHijos.getLength(); ++j) {
                if (listaNodosHijos.item(j).getNodeType() != 1) continue;
                if (listaNodosHijos.item(j).getNodeName().equalsIgnoreCase("TABLA")) {
                    tabla = listaNodosHijos.item(j).getChildNodes().item(0).getNodeValue().trim();
                }
                campoyvalor = new ArrayList();
                listaNodosNietos = listaNodosHijos.item(j).getChildNodes();
                for (k = 0; k < listaNodosNietos.getLength(); ++k) {
                    if (listaNodosNietos.item(k).getNodeType() != 1) continue;
                    campoyvalor.add(listaNodosNietos.item(k).getChildNodes().item(0).getNodeValue().trim());
                }
                this.getAddTabla().put(tabla.toUpperCase(), campoyvalor);
                campoyvalor = null;
            }
            campoyvalor = null;
        }
        if (nombre.equalsIgnoreCase("Registro") || nombre.equalsIgnoreCase("Fichero")) {
            listaNodosHijos = nodo.getChildNodes();
            for (j = 0; j < listaNodosHijos.getLength(); ++j) {
                if (listaNodosHijos.item(j).getNodeType() != 1) continue;
                TipoDatosReglasTipoYPartidas r = new TipoDatosReglasTipoYPartidas("");
                if (listaNodosHijos.item(j).getNodeName().equalsIgnoreCase("NOMBRE")) {
                    r.setNombreRegistro(listaNodosHijos.item(j).getChildNodes().item(0).getNodeValue().trim());
                }
                listaNodosNietos = listaNodosHijos.item(j).getChildNodes();
                for (k = 0; k < listaNodosNietos.getLength(); ++k) {
                    if (listaNodosNietos.item(k).getNodeType() != 1) continue;
                    r.addPartida(listaNodosNietos.item(k).getChildNodes().item(0).getNodeValue().trim());
                }
                if (nombre.equalsIgnoreCase("Registro")) {
                    this.getReglasDeRegistro().add(r);
                } else {
                    this.getReglasDeFichero().add(r);
                }
                r = null;
            }
        }
        if (nombre.equalsIgnoreCase("TABLA") || nombre.equalsIgnoreCase("TABLAADICIONAL")) {
            boolean destinoTabla = nombre.equalsIgnoreCase("TABLA");
            List<ITipoDatosCampos> camposDeTabla = new ArrayList<ITipoDatosCampos>();
            String nombreTabla = "";
            String nombreCampo = "";
            ArrayList<TipoDatosCampoValorEx> listaTablasAnidadas = new ArrayList<TipoDatosCampoValorEx>();
            try {
                int indTab;
                listaNodosHijos = nodo.getChildNodes();
                ITipoDatosTabla tablaActual = null;
                for (j = 0; j < listaNodosHijos.getLength(); ++j) {
                    if (listaNodosHijos.item(j).getNodeType() != 1) continue;
                    if (listaNodosHijos.item(j).getNodeName().equalsIgnoreCase("NOMBRE")) {
                        int indTab2;
                        hashCampos = new HashMap();
                        nombreTabla = listaNodosHijos.item(j).getChildNodes().item(0).getNodeValue();
                        tablaActual = new TipoDatosTabla(nombreTabla);
                        tablaActual.setCampos(new ArrayList<ITipoDatosCampos>());
                        if (destinoTabla) {
                            indTab2 = TipoDatosTabla.indiceListaContieneTabla(this.getListaTablas(), nombreTabla);
                            if (indTab2 > -1) {
                                tablaActual = this.getListaTablas().get(indTab2);
                            }
                        } else {
                            indTab2 = TipoDatosTabla.indiceListaContieneTabla(this.getListaTablasAuxiliares(), nombreTabla);
                            if (indTab2 > -1) {
                                tablaActual = this.getListaTablasAuxiliares().get(indTab2);
                            }
                        }
                        camposDeTabla = tablaActual.getCampos();
                        attr = listaNodosHijos.item(j).getAttributes();
                        for (k = 0; k < attr.getLength(); ++k) {
                            hashCampos.put(attr.item(k).getNodeName().toUpperCase(), attr.item(k).getNodeValue());
                            if (!attr.item(k).getNodeName().toUpperCase().equalsIgnoreCase("VALOR") && !attr.item(k).getNodeName().toUpperCase().equalsIgnoreCase("RVANTESQUE") && !attr.item(k).getNodeName().toUpperCase().equalsIgnoreCase("RVDESPUESQUE") && !attr.item(k).getNodeName().toUpperCase().equalsIgnoreCase("RVEJECUCION") || this.getModelo().getGestorConfiguracion().getEntrada(FuncionesUtiles.getFuncionesUtiles().dameNombrePartidaSinParentesis(attr.item(k).getNodeValue().trim().toUpperCase())) != null) continue;
                            FuncionesUtiles.getFuncionesUtiles().muestraError(new ExceptionMotor("Campo " + FuncionesUtiles.getFuncionesUtiles().dameNombrePartidaSinParentesis(attr.item(k).getNodeValue().trim().toUpperCase()) + " del transXXX no existe en entradas, compruebelo antes de ejecutar!!!!"));
                        }
                        tablaActual.setPropiedadesTabla(hashCampos);
                        this.anniadirCampo(tablaActual, camposDeTabla, null, hashCampos);
                        hashCampos = null;
                    }
                    if (listaNodosHijos.item(j).getNodeName().equalsIgnoreCase("CAMPO")) {
                        hashCampos = new HashMap();
                        attr = listaNodosHijos.item(j).getAttributes();
                        for (k = 0; k < attr.getLength(); ++k) {
                            hashCampos.put(attr.item(k).getNodeName().toUpperCase(), attr.item(k).getNodeValue());
                        }
                        nombreCampo = "";
                        if (listaNodosHijos.item(j).getChildNodes().item(0) != null) {
                            nombreCampo = listaNodosHijos.item(j).getChildNodes().item(0).getNodeValue().toUpperCase();
                            if (this.getModelo().getGestorConfiguracion().getEntrada(FuncionesUtiles.getFuncionesUtiles().dameNombrePartidaSinParentesis(nombreCampo)) == null) {
                                FuncionesUtiles.getFuncionesUtiles().muestraError(new ExceptionMotor("Campo " + FuncionesUtiles.getFuncionesUtiles().dameNombrePartidaSinParentesis(nombreCampo) + " del transXXX no existe en entradas, compruebelo antes de ejecutar!!!!"));
                            }
                        } else if (hashCampos.containsKey("LOCALIZADORUNICOCAMPO")) {
                            nombreCampo = ((String)hashCampos.get("LOCALIZADORUNICOCAMPO")).toUpperCase();
                        }
                        TipoDatosCampos cmp = new TipoDatosCampos("");
                        if (nombreCampo.length() != 0) {
                            cmp.setNombreCampo(nombreCampo);
                            if (this.getListaCampos().containsKey(nombreCampo) && (hashCampos == null || !hashCampos.containsKey("FILTRO"))) {
                                FuncionesUtiles.getFuncionesUtiles().muestraAviso(new ExceptionMotor("Es Peligroso tener entradas en el transXXX con el mismo nombre, mejor use atributo VALOR. Ocurrio con : " + nombreCampo));
                            }
                            this.getListaCampos().put(nombreCampo, hashCampos);
                        }
                        cmp.setPropiedadesCampos(hashCampos);
                        if (hashCampos != null && hashCampos.containsKey("LOCALIZADORUNICOCAMPO")) {
                            this.getLocalizadorUnicoCampo().put(hashCampos.get("LOCALIZADORUNICOCAMPO").toString().toUpperCase(), hashCampos);
                        }
                        this.anniadirCampo(tablaActual, camposDeTabla, cmp, hashCampos);
                        hashCampos = null;
                        continue;
                    }
                    if (!listaNodosHijos.item(j).getNodeName().equalsIgnoreCase("TABLA")) continue;
                    if (tablaActual.getPropiedadesTabla().containsKey("EQUIVALENCIA")) {
                        listaTablasAnidadas.add(new TipoDatosCampoValorEx(tablaActual.getPropiedadesTabla().get("EQUIVALENCIA"), listaNodosHijos.item(j)));
                        continue;
                    }
                    if (tablaActual.getPropiedadesTabla().containsKey("TABLABBDD")) {
                        listaTablasAnidadas.add(new TipoDatosCampoValorEx(tablaActual.getPropiedadesTabla().get("TABLABBDD"), listaNodosHijos.item(j)));
                        continue;
                    }
                    throw new ExceptionMotor("Tabla anidada pero sin atributo que identifique al padre!!!");
                }
                this.compruebaTamEntradas(camposDeTabla);
                if (tablaActual.getPropiedadesTabla() != null && camposDeTabla != null && camposDeTabla.size() > 0 && tablaActual.getPropiedadesTabla().containsKey("ITERARTABLA")) {
                    ((ITipoDatosCampos)camposDeTabla.get(camposDeTabla.size() - 1)).getPropiedadesCampos().put("ULTIMOCAMPO", "true");
                }
                this.getListaCamposDeTabla().put(nombreTabla, camposDeTabla);
                tablaActual.setCampos(camposDeTabla);
                if (destinoTabla) {
                    indTab = TipoDatosTabla.indiceListaContieneTabla(this.getListaTablas(), tablaActual.getNombreTabla());
                    if (indTab == -1) {
                        this.getListaTablas().add(tablaActual);
                    } else {
                        this.getListaTablas().remove(indTab);
                        this.getListaTablas().add(indTab, tablaActual);
                    }
                } else {
                    indTab = TipoDatosTabla.indiceListaContieneTabla(this.getListaTablasAuxiliares(), tablaActual.getNombreTabla());
                    if (indTab == -1) {
                        this.getListaTablasAuxiliares().add(tablaActual);
                    } else {
                        this.getListaTablasAuxiliares().remove(indTab);
                        this.getListaTablasAuxiliares().add(indTab, tablaActual);
                    }
                }
                boolean ret = true;
                if (listaTablasAnidadas.size() > 0) {
                    for (TipoDatosCampoValorEx tvex : listaTablasAnidadas) {
                        String Xpath = tvex.getNombreCampo();
                        Node node = (Node)tvex.getValor();
                        NodeList lista = node.getChildNodes();
                        for (int h = 0; h < lista.getLength(); ++h) {
                            if (lista.item(h).getNodeType() != 1) continue;
                            Attr at = node.getOwnerDocument().createAttribute("ANIDADA");
                            at.setValue("true");
                            lista.item(h).getAttributes().setNamedItem(at);
                            at = node.getOwnerDocument().createAttribute("TABLAPADRE");
                            at.setValue(Xpath);
                            lista.item(h).getAttributes().setNamedItem(at);
                            break;
                        }
                        ret &= this.examinarNodo(node);
                    }
                }
                return ret;
            }
            catch (ExceptionMotor ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ExceptionMotor(ex);
            }
        }
        return false;
    }

    protected void anniadirCampo(ITipoDatosTabla tablaActual, List<ITipoDatosCampos> camposDeTabla, TipoDatosCampos cmp, HashMap<String, String> hashCampos) throws ExceptionMotor {
        try {
            if (cmp != null) {
                camposDeTabla.add(cmp);
            }
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected boolean compruebaTamEntradas(List<ITipoDatosCampos> camposDeTabla) {
        try {
            IRegEntrada r = null;
            for (int i = 0; i < camposDeTabla.size(); ++i) {
                String tipo;
                if (camposDeTabla.get(i).getNombreCampo() == null || camposDeTabla.get(i).getNombreCampo().length() <= 0 || (tipo = camposDeTabla.get(i).getPropiedadesCampos().get("TIPODATO")) == null || !tipo.equalsIgnoreCase("A") && !tipo.equalsIgnoreCase("An") && !tipo.equalsIgnoreCase("EMAIL") && !tipo.equalsIgnoreCase("TEL") && !tipo.equalsIgnoreCase("CADNUM") && !tipo.equalsIgnoreCase("CuentaBancaria") && !tipo.equalsIgnoreCase("Nif") && !tipo.equalsIgnoreCase("Num") && !tipo.equalsIgnoreCase("NumSigno")) continue;
                String valor = "";
                try {
                    valor = camposDeTabla.get(i).getPropiedadesCampos().get("VALOR");
                }
                catch (Exception ex) {
                    valor = null;
                }
                if (valor == null) {
                    valor = FuncionesUtiles.getFuncionesUtiles().dameNombrePartidaSinParentesis(camposDeTabla.get(i).getNombreCampo());
                }
                if ((r = this.getModelo().getGestorConfiguracion().getEntrada(valor)) != null) {
                    int trans;
                    int ent;
                    if (camposDeTabla.get(i).getPropiedadesCampos() == null || camposDeTabla.get(i).getPropiedadesCampos().get("LONGITUD") == null || (ent = r.getTamannioTotal()) <= (trans = Integer.parseInt(camposDeTabla.get(i).getPropiedadesCampos().get("LONGITUD")))) continue;
                    FuncionesUtiles.getFuncionesUtiles().muestraInfoDebug("Entrada " + valor + " en entradas tiene longitud " + ent + " y en transXXX.xml tiene longitud " + trans + "!!!");
                    continue;
                }
                FuncionesUtiles.getFuncionesUtiles().muestraInfoDebug("No encuentro partida " + camposDeTabla.get(i).getNombreCampo() + "!!!");
            }
            r = null;
            return true;
        }
        catch (Exception ex) {
            FuncionesUtiles.getFuncionesUtiles().muestraInfoDebug(ex);
            return false;
        }
    }

    @Override
    public boolean cargarEstructura(InputStream ficheroTraduccion) throws ExceptionMotor {
        InputStream[] is = new InputStream[]{ficheroTraduccion};
        return this.cargarEstructura(is);
    }

    @Override
    public boolean cargarEstructura(InputStream[] ficheroTraduccion, boolean mantenerDocumentos) throws ExceptionMotor {
        try {
            if (this.getDocumentosTraduccion() == null) {
                this.setDocumentosTraduccion(new ArrayList<Document>());
            }
            this.getDocumentosTraduccion().clear();
            this.setDocumentosTraduccion(this.normalizaEstructuras(ficheroTraduccion));
            if (this.getDocumentosTraduccion() == null | this.getDocumentosTraduccion().size() == 0) {
                throw new ExceptionMotor("No se pudo sacar ficheros de traducciones");
            }
            this.getListaTablas().clear();
            this.getListaTablasAuxiliares().clear();
            this.getListaCampos().clear();
            this.getConstantes().clear();
            this.getVariables().clear();
            this.getSecuencias().clear();
            this.getConfiguracion().clear();
            this.getListaCamposDeTabla().clear();
            Document doc = null;
            NodeList listaNodos = null;
            for (int iteradorIS = 0; iteradorIS < this.getDocumentosTraduccion().size(); ++iteradorIS) {
                doc = this.getDocumentosTraduccion().get(iteradorIS);
                NamedNodeMap attr = doc.getFirstChild().getAttributes();
                for (int k = 0; k < attr.getLength(); ++k) {
                    this.getListadoAtributosTransXXX().put(attr.item(k).getNodeName().toUpperCase(), attr.item(k).getNodeValue().toUpperCase());
                }
                if (this.versionTrans.equalsIgnoreCase("0.0")) {
                    this.versionTrans = this.getListadoAtributosTransXXX().get("VERSION");
                    if (this.versionTrans == null) {
                        this.versionTrans = "0.0";
                    }
                }
                listaNodos = doc.getChildNodes();
                listaNodos = listaNodos.item(0).getChildNodes();
                for (int i = 0; i < listaNodos.getLength(); ++i) {
                    this.examinarNodo(listaNodos.item(i));
                }
                listaNodos = null;
                doc = null;
            }
            boolean bl = this.normalizaTablas() & this.ordenaTablas();
            return bl;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
        finally {
            if (!mantenerDocumentos) {
                this.getDocumentosTraduccion().clear();
                this.setDocumentosTraduccion(null);
            }
        }
    }

    protected boolean ordenaTablas() throws ExceptionMotor {
        try {
            int i;
            ITipoDatosTabla tablaActual = null;
            for (i = 0; i < this.getListaTablas().size(); ++i) {
                tablaActual = null;
                for (int h = 0; h < this.getListaTablasOrdenadasParaReglas().size(); ++h) {
                    if (!this.getListaTablasOrdenadasParaReglas().get(h).getPropiedadesTabla().containsKey("TABLABBDD") || !this.getListaTablas().get(h).getPropiedadesTabla().containsKey("TABLABBDD") || !this.getListaTablasOrdenadasParaReglas().get(h).getPropiedadesTabla().get("TABLABBDD").equalsIgnoreCase(this.getListaTablas().get(i).getPropiedadesTabla().get("TABLABBDD"))) continue;
                    tablaActual = this.getListaTablasOrdenadasParaReglas().get(h);
                    break;
                }
                if (tablaActual == null) {
                    tablaActual = new TipoDatosTabla(this.getListaTablas().get(i).getNombreTabla());
                    this.getListaTablasOrdenadasParaReglas().add(tablaActual);
                    tablaActual.setPropiedadesTabla((Map)((HashMap)this.getListaTablas().get(i).getPropiedadesTabla()).clone());
                }
                if (tablaActual.getCampos() == null) {
                    tablaActual.setCampos(new ArrayList<ITipoDatosCampos>());
                }
                for (int j = 0; j < this.getListaTablas().get(i).getCampos().size(); ++j) {
                    tablaActual.getCampos().add(this.getListaTablas().get(i).getCampos().get(j));
                }
            }
            for (i = 0; i < this.getListaTablasOrdenadasParaReglas().size(); ++i) {
                this.ordenaCamposTransXXXSegunDependencias(this.getListaTablasOrdenadasParaReglas().get(i).getCampos());
            }
            return true;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    private void ordenaCamposTransXXXSegunDependencias(List<ITipoDatosCampos> camposOrdenadosSegunTransXXX) throws ExceptionMotor {
        try {
            List<ITipoDatosCampos> listaOrdenada = camposOrdenadosSegunTransXXX;
            boolean huboCambios = true;
            boolean encontrado = false;
            String rvAntesQue = "";
            String rvDespuesQue = "";
            block7: while (huboCambios) {
                huboCambios = false;
                for (int i = 0; i < listaOrdenada.size(); ++i) {
                    if (listaOrdenada.get(i).getNombreCampo() != null && listaOrdenada.get(i).getNombreCampo().length() > 0) {
                        try {
                            rvAntesQue = listaOrdenada.get(i).getPropiedadesCampos().get("RVANTESQUE").toString();
                        }
                        catch (Exception ex) {
                            rvAntesQue = "";
                        }
                        try {
                            rvDespuesQue = listaOrdenada.get(i).getPropiedadesCampos().get("RVDESPUESQUE").toString();
                        }
                        catch (Exception ex) {
                            rvDespuesQue = "";
                        }
                        if (rvAntesQue.length() > 0) {
                            if (i == listaOrdenada.size() || !listaOrdenada.get(i + 1).getNombreCampo().equalsIgnoreCase(rvAntesQue)) {
                                for (int j = 0; j < listaOrdenada.size(); ++j) {
                                    encontrado = false;
                                    if (!listaOrdenada.get(j).getNombreCampo().equalsIgnoreCase(rvAntesQue)) continue;
                                    encontrado = true;
                                    if (i < j) break;
                                    huboCambios = true;
                                    listaOrdenada.add(j, listaOrdenada.get(i));
                                    listaOrdenada.remove(i + 1);
                                    break;
                                }
                                if (!encontrado) {
                                    throw new ExceptionMotor("No encuentro entrada " + rvAntesQue);
                                }
                            }
                        } else if (!(rvDespuesQue.length() <= 0 || i != listaOrdenada.size() && listaOrdenada.get(i + 1).getNombreCampo().equalsIgnoreCase(rvDespuesQue))) {
                            for (int j = 0; j < listaOrdenada.size(); ++j) {
                                encontrado = false;
                                if (!listaOrdenada.get(j).getNombreCampo().equalsIgnoreCase(rvDespuesQue)) continue;
                                encontrado = true;
                                if (i > j) break;
                                huboCambios = true;
                                listaOrdenada.add(j + 1, listaOrdenada.get(i));
                                listaOrdenada.remove(i);
                                break;
                            }
                            if (!encontrado) {
                                throw new ExceptionMotor("No encuentro entrada " + rvDespuesQue);
                            }
                        }
                    }
                    if (huboCambios) continue block7;
                }
            }
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Imposible ordenar campos (RV****Que)");
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Imposible ordenar campos (RV*****Que)");
        }
    }

    @Override
    public boolean cargarEstructura(InputStream[] ficheroTraduccion) throws ExceptionMotor {
        return this.cargarEstructura(ficheroTraduccion, false);
    }

    protected boolean normalizaTablas() throws ExceptionMotor {
        try {
            List<ITipoDatosCampos> coleccion = null;
            Map<String, String> campos = null;
            int iterador = 1;
            int maxiterador = Integer.MAX_VALUE;
            String tablaActual = "";
            int iteradorComienzoTabla = -1;
            int iteradorFinalTabla = -1;
            boolean normalizar = false;
            for (int i = 0; i < this.getListaTablas().size(); ++i) {
                coleccion = this.getListaTablas().get(i).getCampos();
                for (int j = 0; j < coleccion.size(); ++j) {
                    campos = coleccion.get(j).getPropiedadesCampos();
                    if (campos.containsKey("TABLA") || campos.containsKey("MUEVETABLA")) {
                        if (tablaActual.length() == 0) {
                            tablaActual = campos.get("TABLA");
                            if (tablaActual == null) {
                                tablaActual = campos.get("MUEVETABLA");
                            }
                            iterador = 1;
                            maxiterador = Integer.MAX_VALUE;
                            iteradorComienzoTabla = j - 1;
                            normalizar = false;
                        }
                        if (campos.containsKey("TABLA") && !campos.get("TABLA").equalsIgnoreCase(tablaActual)) {
                            throw new ExceptionMotor("error en fichero Trans, grupo no acaba en MueveTabla...");
                        }
                        if (coleccion.get(j).getNombreCampo().endsWith("(?)") || iterador > 1) {
                            if (iterador == 1) {
                                coleccion.get(j).setNombreCampo(coleccion.get(j).getNombreCampo().substring(0, coleccion.get(j).getNombreCampo().length() - 3) + "(1)");
                                normalizar = true;
                            } else {
                                TipoDatosCampos tc = new TipoDatosCampos(coleccion.get(j).getNombreCampo().substring(0, coleccion.get(j).getNombreCampo().length() - 3) + "(" + iterador + ")");
                                tc.setPropiedadesCampos(coleccion.get(j).getPropiedadesCampos());
                                coleccion.add(iteradorFinalTabla, tc);
                                ++iteradorFinalTabla;
                            }
                        } else {
                            tablaActual = "";
                        }
                    }
                    if (!campos.containsKey("MUEVETABLA")) continue;
                    if (normalizar) {
                        if (!campos.containsKey("ITERACIONES")) {
                            throw new ExceptionMotor("error en fichero Trans, grupo no tiene etiqueta Iteraciones...");
                        }
                        maxiterador = Integer.valueOf(campos.get("ITERACIONES"));
                        if (iterador == 1) {
                            iteradorFinalTabla = j + 1;
                        }
                        if (maxiterador >= ++iterador) {
                            j = iteradorComienzoTabla;
                            continue;
                        }
                        tablaActual = "";
                        j = iteradorFinalTabla - 1;
                        continue;
                    }
                    tablaActual = "";
                }
            }
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Map<String, String> getTabla(String nombreTabla) throws ExceptionMotor {
        try {
            for (int i = 0; i < this.getListaTablas().size(); ++i) {
                if (!this.getListaTablas().get(i).getNombreTabla().equalsIgnoreCase(nombreTabla)) continue;
                return this.getListaTablas().get(i).getPropiedadesTabla();
            }
            return null;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public ITipoDatosTabla getTablaEntry(String nombreTabla) throws ExceptionMotor {
        try {
            for (int i = 0; i < this.getListaTablas().size(); ++i) {
                if (!this.getListaTablas().get(i).getNombreTabla().equalsIgnoreCase(nombreTabla)) continue;
                return this.getListaTablas().get(i);
            }
            return null;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public int getTableIndex(String nombreTabla) throws ExceptionMotor {
        try {
            for (int i = 0; i < this.getListaTablas().size(); ++i) {
                if (!this.getListaTablas().get(i).getNombreTabla().equalsIgnoreCase(nombreTabla)) continue;
                return i;
            }
            return -1;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public int getTableAdicionalIndex(String nombreTabla) throws ExceptionMotor {
        try {
            for (int i = 0; i < this.getListaTablasAuxiliares().size(); ++i) {
                if (!this.getListaTablasAuxiliares().get(i).getNombreTabla().equalsIgnoreCase(nombreTabla)) continue;
                return i;
            }
            return -1;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public ITipoDatosTabla getTablaAuxiliarEntry(String nombreTabla) throws ExceptionMotor {
        try {
            for (int i = 0; i < this.getListaTablasAuxiliares().size(); ++i) {
                if (!this.getListaTablasAuxiliares().get(i).getNombreTabla().equalsIgnoreCase(nombreTabla)) continue;
                return this.getListaTablasAuxiliares().get(i);
            }
            return null;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public List<ITipoDatosTabla> getTablas() throws ExceptionMotor {
        try {
            return this.getListaTablas();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void setTablas(List<ITipoDatosTabla> tablas) throws ExceptionMotor {
        try {
            this.setListaTablas(tablas);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public List<ITipoDatosTabla> getTablasOrdenadas() throws ExceptionMotor {
        try {
            return this.getListaTablasOrdenadasParaReglas();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void setTablasOrdenadas(List<ITipoDatosTabla> tablas) throws ExceptionMotor {
        try {
            this.setListaTablasOrdenadasParaReglas(tablas);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Map<String, String> getTablaAuxiliar(String nombreTabla) throws ExceptionMotor {
        try {
            for (int i = 0; i < this.getListaTablasAuxiliares().size(); ++i) {
                if (!this.getListaTablasAuxiliares().get(i).getNombreTabla().equalsIgnoreCase(nombreTabla)) continue;
                return this.getListaTablasAuxiliares().get(i).getPropiedadesTabla();
            }
            return null;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public List<ITipoDatosTabla> getTablasAuxiliares() throws ExceptionMotor {
        try {
            return this.getListaTablasAuxiliares();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Map<String, Map<String, String>> getCampos() throws ExceptionMotor {
        try {
            return this.getListaCampos();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Map<String, String> getCampoPorLocalizadorUnicoCampo(String nombreCampo) throws ExceptionMotor {
        try {
            if (this.getListaCampos() == null) {
                return null;
            }
            if (this.getListaCampos().size() == 0) {
                return null;
            }
            if (this.getLocalizadorUnicoCampo() == null) {
                return null;
            }
            if (this.getLocalizadorUnicoCampo().size() == 0) {
                return null;
            }
            return this.getLocalizadorUnicoCampo().get(nombreCampo.toUpperCase());
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Campo " + nombreCampo);
        }
    }

    @Override
    public List<ITipoDatosCampos> getListaCamposDeTabla(String nombreTabla) throws ExceptionMotor {
        try {
            if (this.listaCamposDeTabla == null) {
                return null;
            }
            if (this.listaCamposDeTabla.size() == 0) {
                return null;
            }
            return this.listaCamposDeTabla.get(nombreTabla.toUpperCase());
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public Map<String, String> getCampo(String nombreCampo) throws ExceptionMotor {
        try {
            if (this.getListaCampos() == null) {
                return null;
            }
            if (this.getListaCampos().size() == 0) {
                return null;
            }
            return this.getListaCampos().get(nombreCampo.toUpperCase());
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Campo " + nombreCampo);
        }
    }

    @Override
    public Map<String, String> getConstantes() throws ExceptionMotor {
        try {
            return this.constantes;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Map<String, String> getConfiguracion() throws ExceptionMotor {
        try {
            return this.configuracion;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Map<String, String> getVariables() throws ExceptionMotor {
        try {
            return this.variables;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public List<Object> getSecuencias() throws ExceptionMotor {
        try {
            return this.secuencias;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    private String extrae(String cad, String separadorAmbito, Map<String, ?> coleccion) throws ExceptionMotor {
        try {
            String res = cad;
            String trad = null;
            int inicio = 0;
            int iFinal = 0;
            while ((inicio = res.indexOf(separadorAmbito, iFinal)) != -1) {
                iFinal = res.indexOf(separadorAmbito, inicio + separadorAmbito.length());
                if (iFinal == -1) {
                    return res;
                }
                Object o = coleccion.get(res.substring(inicio + separadorAmbito.length(), iFinal));
                if (o == null) {
                    return null;
                }
                trad = o.toString();
                iFinal += separadorAmbito.length();
                if (trad == null) continue;
                res = res.substring(0, inicio) + trad + res.substring(iFinal);
                inicio = 0;
                iFinal = 0;
            }
            return res;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Cadena " + cad);
        }
    }

    @Override
    public String traduceCadena(String cade) throws ExceptionMotor {
        String cad = cade.toUpperCase();
        try {
            cad = this.extrae(cad, "#", this.getConstantes());
            if (cad == null) {
                cad = cade.toUpperCase();
            }
            cad = this.extrae(cad, "%", this.getVariables());
            return cad;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Cadena " + cade);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Cadena " + cade);
        }
    }

    @Override
    public String traduceCadena(String cade, Map<String, ITablaMotorEntrada> listaCamposBD) throws ExceptionMotor {
        String cad = cade.toUpperCase();
        try {
            cad = this.extrae(cad, "#", this.getConstantes());
            if (cad == null) {
                cad = cade.toUpperCase();
            }
            cad = this.extrae(cad, "%", listaCamposBD);
            return cad;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Cadena " + cade);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Cadena " + cade);
        }
    }

    @Override
    public boolean esAlfabetico(String sCadena) {
        return Validaciones.getValidaciones().esAlfabetico(sCadena);
    }

    @Override
    public boolean esAlfabetico(char c) {
        return Validaciones.getValidaciones().esAlfabetico(c);
    }

    @Override
    public boolean esAlfabeticoAEAT(char c) {
        return Validaciones.getValidaciones().esAlfabeticoAEAT(c);
    }

    @Override
    public boolean esAlfabeticoAEAT(String sCadena) {
        return Validaciones.getValidaciones().esAlfabeticoAEAT(sCadena);
    }

    @Override
    public boolean esAlfanumericaAEAT(String sCadena) {
        return Validaciones.getValidaciones().esAlfanumericaAEAT(sCadena);
    }

    @Override
    public boolean esAlfanumericaAEAT(char c) {
        return Validaciones.getValidaciones().esAlfanumericaAEAT(c);
    }

    @Override
    public boolean esNumerica(String sCadena) {
        return Validaciones.getValidaciones().esNumerica(sCadena);
    }

    @Override
    public boolean esNumericaAEAT(String sCadena) {
        return Validaciones.getValidaciones().esNumericaAEAT(sCadena);
    }

    @Override
    public boolean esTelefonoEuropeo(String sCadena) {
        return Validaciones.getValidaciones().esTelefonoEuropeo(sCadena);
    }

    @Override
    public boolean esnumericaConSignoAEAT(String sCadena) {
        return Validaciones.getValidaciones().esnumericaConSignoAEAT(sCadena);
    }

    @Override
    public Map<String, List<String>> getCamposInicializacionTablas() throws ExceptionMotor {
        try {
            return this.getAddTabla();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public List<ITipoDatosReglasTipoYPartidas> getReglasRegistro() throws ExceptionMotor {
        try {
            return this.getReglasDeRegistro();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public List<ITipoDatosReglasTipoYPartidas> getReglasFichero() throws ExceptionMotor {
        try {
            return this.getReglasDeFichero();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    public static List<ITipoDatosReglasTipoYPartidas> cargarEstructuraReglasRegistroReglasFichero(InputStream[] ficheroTraduccion, String claveBusqueda) throws ExceptionMotor {
        return GestorTraducciones.cargarEstructuraReglasRegistroReglasFichero(ficheroTraduccion, claveBusqueda, null);
    }

    public static List<ITipoDatosReglasTipoYPartidas> cargarEstructuraReglasRegistroReglasFichero(InputStream[] ficheroTraduccion, String claveBusqueda, String nombreTabla) throws ExceptionMotor {
        try {
            ArrayList<ITipoDatosReglasTipoYPartidas> todas = new ArrayList<ITipoDatosReglasTipoYPartidas>();
            List<ITipoDatosReglasTipoYPartidas> tmp = null;
            for (int i = 0; i < ficheroTraduccion.length; ++i) {
                tmp = nombreTabla != null ? GestorTraducciones.cargarEstructuraReglasRegistroReglasFichero(ficheroTraduccion[i], claveBusqueda, nombreTabla) : GestorTraducciones.cargarEstructuraReglasRegistroReglasFichero(ficheroTraduccion[i], claveBusqueda);
                if (tmp == null) continue;
                for (int j = 0; j < tmp.size(); ++j) {
                    boolean nueva = true;
                    for (int k = 0; k < todas.size(); ++k) {
                        if (!((ITipoDatosReglasTipoYPartidas)todas.get(k)).getNombreRegistro().equalsIgnoreCase(tmp.get(j).getNombreRegistro())) continue;
                        nueva = false;
                        for (int l = 0; l < tmp.get(j).getPartidas().size(); ++l) {
                            if (((ITipoDatosReglasTipoYPartidas)todas.get(k)).contienePartida(tmp.get(j).getPartidas().get(l))) continue;
                            ((ITipoDatosReglasTipoYPartidas)todas.get(k)).addPartida(tmp.get(j).getPartidas().get(l));
                        }
                    }
                    if (!nueva) continue;
                    todas.add(tmp.get(j));
                }
            }
            return todas;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Clave " + claveBusqueda + " Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Clave " + claveBusqueda + " Tabla " + nombreTabla);
        }
    }

    public static List<ITipoDatosReglasTipoYPartidas> cargarEstructuraReglasRegistroReglasFichero(InputStream ficheroTraduccion, String claveBusqueda, String nombreTabla) throws ExceptionMotor {
        try {
            List<ITipoDatosReglasTipoYPartidas> todas = GestorTraducciones.cargarEstructuraReglasRegistroReglasFichero(ficheroTraduccion, claveBusqueda);
            if (todas.size() > 0) {
                for (int i = todas.size() - 1; i >= 0; --i) {
                    if (todas.get(i).getNombreRegistro().equalsIgnoreCase(nombreTabla)) continue;
                    todas.remove(i);
                }
            }
            return todas;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Clave " + claveBusqueda + " Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Clave " + claveBusqueda + " Tabla " + nombreTabla);
        }
    }

    public static List<ITipoDatosReglasTipoYPartidas> cargarEstructuraReglasRegistroReglasFichero(InputStream ficheroTraduccion, String claveBusqueda) throws ExceptionMotor {
        try {
            ArrayList<ITipoDatosReglasTipoYPartidas> listaTablas = new ArrayList<ITipoDatosReglasTipoYPartidas>();
            byte[] bdata = FuncionesUtiles.getFuncionesUtiles().inputStream2byteArray(ficheroTraduccion);
            Document doc = FuncionesUtiles.getFuncionesUtiles().documentFromString(new String(bdata));
            NodeList listaNodos = doc.getChildNodes();
            NodeList listaNodosHijos = null;
            NodeList listaNodosNietos = null;
            String nombre = "";
            listaNodos = listaNodos.item(0).getChildNodes();
            TipoDatosReglasTipoYPartidas tf = null;
            int j = 0;
            for (int i = 0; i < listaNodos.getLength(); ++i) {
                nombre = listaNodos.item(i).getNodeName();
                if (!nombre.equalsIgnoreCase(claveBusqueda)) continue;
                listaNodosHijos = listaNodos.item(i).getChildNodes();
                for (j = 0; j < listaNodosHijos.getLength(); ++j) {
                    if (listaNodosHijos.item(j).getNodeType() != 1) continue;
                    if (listaNodosHijos.item(j).getNodeName().equalsIgnoreCase("NOMBRE")) {
                        tf = new TipoDatosReglasTipoYPartidas(listaNodosHijos.item(j).getChildNodes().item(0).getNodeValue().trim());
                    }
                    listaNodosNietos = listaNodosHijos.item(j).getChildNodes();
                    for (int k = 0; k < listaNodosNietos.getLength(); ++k) {
                        if (listaNodosNietos.item(k).getNodeType() != 1) continue;
                        tf.addPartida(listaNodosNietos.item(k).getChildNodes().item(0).getNodeValue().trim());
                    }
                    listaTablas.add(tf);
                    tf = null;
                }
            }
            doc = null;
            return listaTablas;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + " Clave " + claveBusqueda);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Clave " + claveBusqueda);
        }
    }

    @Override
    public void setEsNumeroPositivoCon0(boolean esNumeroPositivoCon0) {
        this.esNumeroPositivoCon0 = esNumeroPositivoCon0;
    }

    @Override
    public boolean isEsNumeroPositivoCon0() throws ExceptionMotor {
        ITipoDatoRetornoMetodo ret;
        if (this.getModelo() != null && this.getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getModelo().getFuncionalidadPersonalizadaModelo().isEsNumeroPositivoCon0()).isRetornaResultado()) {
            return ret.getObjetoRetornoAsBoolean();
        }
        return this.esNumeroPositivoCon0;
    }

    @Override
    public void setAdmitoN00000000(boolean admitoN00000000) {
        this.admitoN00000000 = admitoN00000000;
    }

    @Override
    public boolean isAdmitoN00000000() throws ExceptionMotor {
        ITipoDatoRetornoMetodo ret;
        if (this.getModelo() != null && this.getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getModelo().getFuncionalidadPersonalizadaModelo().isAdmitoN00000000()).isRetornaResultado()) {
            return ret.getObjetoRetornoAsBoolean();
        }
        return this.admitoN00000000;
    }

    protected List<Document> normalizaEstructuras(InputStream[] ficheroTraduccion) throws ExceptionMotor {
        try {
            String[] cadenas = new String[ficheroTraduccion.length];
            int i = 0;
            for (InputStream is : ficheroTraduccion) {
                byte[] bdata = FuncionesUtiles.getFuncionesUtiles().inputStream2byteArray(is);
                cadenas[i] = new String(bdata);
                ++i;
            }
            return this.normalizaEstructuras(cadenas);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected List<Document> normalizaEstructuras(String[] ficheroTraduccion) throws ExceptionMotor {
        try {
            Document doc = null;
            NodeList listaNodos = null;
            ArrayList<Document> ret = new ArrayList<Document>();
            for (int iteradorIS = 0; iteradorIS < ficheroTraduccion.length; ++iteradorIS) {
                doc = FuncionesUtiles.getFuncionesUtiles().documentFromString(ficheroTraduccion[iteradorIS]);
                listaNodos = doc.getChildNodes();
                listaNodos = listaNodos.item(0).getChildNodes();
                for (int i = 0; i < listaNodos.getLength(); ++i) {
                    String nombre = listaNodos.item(i).getNodeName();
                    if (nombre.equalsIgnoreCase("TABLA") | nombre.equalsIgnoreCase("TABLAADICIONAL")) {
                        this.normalizaTabla(doc, listaNodos.item(i));
                    }
                    this.normalizaERRORVC(listaNodos.item(i));
                }
                ret.add(doc);
                listaNodos = null;
                doc = null;
            }
            return ret;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected void normalizaNodoTabla(Document doc, Node nodoPadre, Node nodo) throws ExceptionMotor {
        try {
            NodeList listaNodosNietos = null;
            HashMap<String, String> hashAttrs = null;
            NamedNodeMap attr = null;
            NamedNodeMap attr2 = null;
            Node nuevo = null;
            Attr enuevo = null;
            Text saltodelinea = null;
            ArrayList<Node> nuevas = new ArrayList<Node>();
            hashAttrs = new HashMap<String, String>();
            attr = nodo.getAttributes();
            for (int k = 0; k < attr.getLength(); ++k) {
                hashAttrs.put(attr.item(k).getNodeName().toUpperCase(), attr.item(k).getNodeValue());
            }
            if (hashAttrs.get("NOMBRETABLA") == null | hashAttrs.get("VAR") == null | hashAttrs.get("DESDE") == null | hashAttrs.get("HASTA") == null) {
                throw new ExceptionMotor("Revise el nodo RECORRIDOTABLA esta mal construido");
            }
            HashMap<String, Integer> indicesIteradores = new HashMap<String, Integer>();
            int indexUltimoCampoDeTabla = -1;
            String filtro = (String)hashAttrs.get("FILTRO");
            String var = ((String)hashAttrs.get("VAR")).toString();
            int desde = Integer.valueOf(((String)hashAttrs.get("DESDE")).toString());
            int hasta = Integer.valueOf(((String)hashAttrs.get("HASTA")).toString());
            for (int k = desde; k <= hasta; ++k) {
                indicesIteradores.put(var, k);
                listaNodosNietos = nodo.getChildNodes();
                for (int j = 0; j < listaNodosNietos.getLength(); ++j) {
                    if (listaNodosNietos.item(j).getNodeType() != 1) continue;
                    if (listaNodosNietos.item(j).getNodeName().equalsIgnoreCase("RECORRIDOTABLA")) {
                        this.normalizaNodoTabla(doc, nodo, listaNodosNietos.item(j));
                        --j;
                        continue;
                    }
                    nuevo = null;
                    nuevo = listaNodosNietos.item(j).cloneNode(true);
                    saltodelinea = doc.createTextNode("\n");
                    nuevas.add(saltodelinea);
                    nuevas.add(nuevo);
                    for (int l = 0; l < nuevo.getChildNodes().getLength(); ++l) {
                        if (nuevo.getChildNodes().item(l).getNodeType() != 3) continue;
                        nuevo.getChildNodes().item(l).setNodeValue(this.normalizaCadena(nuevo.getChildNodes().item(l).getNodeValue().trim(), indicesIteradores));
                    }
                    if (nuevo.getAttributes().getNamedItem("TABLA") != null || nuevo.getAttributes().getNamedItem("MUEVETABLA") != null) continue;
                    indexUltimoCampoDeTabla = nuevas.size() - 1;
                    enuevo = doc.createAttribute("TABLA");
                    enuevo.setNodeValue(FuncionesUtiles.getFuncionesUtiles().dameValorAtributo(attr, "NOMBRETABLA"));
                    nuevo.getAttributes().setNamedItem(enuevo);
                    enuevo = null;
                    if (filtro != null) {
                        enuevo = doc.createAttribute("FILTRO");
                        enuevo.setNodeValue(FuncionesUtiles.getFuncionesUtiles().dameValorAtributo(attr, "FILTRO"));
                        nuevo.getAttributes().setNamedItem(enuevo);
                        enuevo = null;
                    }
                    attr2 = nuevo.getAttributes();
                    for (int m = 0; m < attr2.getLength(); ++m) {
                        attr2.item(m).setNodeValue(this.normalizaCadena(attr2.item(m).getNodeValue(), indicesIteradores));
                    }
                    attr2 = null;
                }
                if (indexUltimoCampoDeTabla == -1) continue;
                nuevo = (Node)nuevas.get(indexUltimoCampoDeTabla);
                nuevo.getAttributes().removeNamedItem("TABLA");
                enuevo = doc.createAttribute("MUEVETABLA");
                enuevo.setNodeValue(FuncionesUtiles.getFuncionesUtiles().dameValorAtributo(attr, "NOMBRETABLA"));
                nuevo.getAttributes().setNamedItem(enuevo);
                enuevo = null;
                nuevo = null;
            }
            hashAttrs = null;
            for (Node nodeExpandido : nuevas) {
                nodoPadre.insertBefore(nodeExpandido, nodo);
            }
            nodoPadre.removeChild(nodo);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected void normalizaTabla(Document doc, Node nodo) throws ExceptionMotor {
        try {
            NodeList listaNodosHijos = null;
            listaNodosHijos = nodo.getChildNodes();
            for (int i = 0; i < listaNodosHijos.getLength(); ++i) {
                if (listaNodosHijos.item(i).getNodeType() != 1 || !listaNodosHijos.item(i).getNodeName().equalsIgnoreCase("RECORRIDOTABLA")) continue;
                this.normalizaNodoTabla(doc, nodo, listaNodosHijos.item(i));
            }
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected boolean esNumericoERRORVC(String valor) {
        try {
            if (valor.startsWith("+") || valor.startsWith("-")) {
                return false;
            }
            new BigDecimal(valor.trim());
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected int valor(String cadena) throws ExceptionMotor {
        try {
            cadena = cadena.substring(1);
            String val = cadena.substring(0, cadena.indexOf(","));
            if (val.length() > 0) {
                return Integer.valueOf(val);
            }
            return 1;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Cadena = " + cadena);
        }
    }

    protected void normalizaERRORVC(Node nodo) throws ExceptionMotor {
        try {
            if (nodo != null && nodo.getAttributes() != null) {
                for (int k = 0; k < nodo.getAttributes().getLength(); ++k) {
                    String error;
                    if (!nodo.getAttributes().item(k).getNodeName().equalsIgnoreCase("ERRORVC") || !(error = nodo.getAttributes().item(k).getNodeValue()).contains("#")) continue;
                    String errTraducc = error.substring(0, error.indexOf(35));
                    int coma = error.substring(error.indexOf(35)).indexOf(",");
                    if (coma == -1) {
                        throw new ExceptionMotor("ERRORVC=\"" + error + "\"" + " mal formado falta coma...");
                    }
                    int longitud = error.substring(coma += error.indexOf(35)).indexOf(35);
                    if (longitud == -1) {
                        throw new ExceptionMotor("ERRORVC=\"" + error + "\"" + " mal formado falta ultima #...");
                    }
                    longitud = Integer.valueOf(error.substring(coma + 1, error.lastIndexOf(35)));
                    if (this.esNumericoERRORVC(error.substring(error.indexOf(35) + 1, coma))) {
                        this.setContadorERRORVC(Integer.valueOf(error.substring(error.indexOf(35) + 1, coma)));
                    } else {
                        switch (error.charAt(error.indexOf(35) + 1)) {
                            case '+': {
                                this.setContadorERRORVC(this.getContadorERRORVC() + this.valor(error.substring(error.indexOf(35) + 1)));
                                break;
                            }
                            case '-': {
                                this.setContadorERRORVC(this.getContadorERRORVC() - this.valor(error.substring(error.indexOf(35) + 1)));
                                break;
                            }
                            case 'A': {
                                break;
                            }
                            default: {
                                throw new ExceptionMotor("ERRORVC=\"" + error + "\"" + " mal formado falta valor aritmetico...");
                            }
                        }
                    }
                    errTraducc = errTraducc + FuncionesUtiles.getFuncionesUtiles().rellena(String.valueOf(this.getContadorERRORVC()), '0', longitud, true);
                    errTraducc = errTraducc + error.substring(error.lastIndexOf(35) + 1);
                    nodo.getAttributes().item(k).setNodeValue(errTraducc);
                }
            }
            if (nodo != null) {
                NodeList listaNodosHijos = nodo.getChildNodes();
                for (int i = 0; i < listaNodosHijos.getLength(); ++i) {
                    this.normalizaERRORVC(listaNodosHijos.item(i));
                }
            }
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected String normalizaCadena(String cad, Map<String, Integer> iteradores) throws ExceptionMotor {
        try {
            String cadena = cad;
            String clave2 = null;
            Set<String> s = iteradores.keySet();
            for (String clave2 : s) {
                iteradores.get(clave2);
                cadena = cadena.replaceAll(clave2, String.valueOf(iteradores.get(clave2)));
            }
            return cadena;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public String dameValorPara(String solicitud) {
        return "";
    }

    protected void setContadorERRORVC(int contadorERRORVC) {
        this.contadorERRORVC = contadorERRORVC;
    }

    protected int getContadorERRORVC() {
        return this.contadorERRORVC;
    }

    protected void setListaTablas(List<ITipoDatosTabla> listaTablas) {
        this.listaTablas = listaTablas;
    }

    protected List<ITipoDatosTabla> getListaTablas() {
        return this.listaTablas;
    }

    protected void setListadoAtributosTransXXX(Map<String, String> listadoAtributosTransXXX) {
        this.listadoAtributosTransXXX = listadoAtributosTransXXX;
    }

    public Map<String, String> getListadoAtributosTransXXX() {
        return this.listadoAtributosTransXXX;
    }

    protected void setListaTablasOrdenadasParaReglas(List<ITipoDatosTabla> listaTablasOrdenadasParaReglas) {
        this.listaTablasOrdenadasParaReglas = listaTablasOrdenadasParaReglas;
    }

    protected List<ITipoDatosTabla> getListaTablasOrdenadasParaReglas() {
        return this.listaTablasOrdenadasParaReglas;
    }

    protected void setListaTablasAuxiliares(List<ITipoDatosTabla> listaTablasAuxiliares) {
        this.listaTablasAuxiliares = listaTablasAuxiliares;
    }

    protected List<ITipoDatosTabla> getListaTablasAuxiliares() {
        return this.listaTablasAuxiliares;
    }

    protected void setListaCampos(Map<String, Map<String, String>> listaCampos) {
        this.listaCampos = listaCampos;
    }

    protected Map<String, Map<String, String>> getListaCampos() {
        return this.listaCampos;
    }

    protected void setConstantes(Map<String, String> constantes) {
        this.constantes = constantes;
    }

    protected void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    protected void setSecuencias(List<Object> secuencias) {
        this.secuencias = secuencias;
    }

    protected void setConfiguracion(Map<String, String> configuracion) {
        this.configuracion = configuracion;
    }

    protected void setLocalizadorUnicoCampo(Map<String, Map<String, String>> localizadorUnicoCampo) {
        this.localizadorUnicoCampo = localizadorUnicoCampo;
    }

    protected Map<String, Map<String, String>> getLocalizadorUnicoCampo() {
        return this.localizadorUnicoCampo;
    }

    protected void setListaCamposDeTabla(Map<String, List<ITipoDatosCampos>> listaCamposDeTabla) {
        this.listaCamposDeTabla = listaCamposDeTabla;
    }

    protected Map<String, List<ITipoDatosCampos>> getListaCamposDeTabla() {
        return this.listaCamposDeTabla;
    }

    protected void setAddTabla(Map<String, List<String>> addTabla) {
        this.addTabla = addTabla;
    }

    protected Map<String, List<String>> getAddTabla() {
        return this.addTabla;
    }

    protected void setReglasDeRegistro(List<ITipoDatosReglasTipoYPartidas> reglasDeRegistro) {
        this.reglasDeRegistro = reglasDeRegistro;
    }

    protected List<ITipoDatosReglasTipoYPartidas> getReglasDeRegistro() {
        return this.reglasDeRegistro;
    }

    protected void setReglasDeFichero(List<ITipoDatosReglasTipoYPartidas> reglasDeFichero) {
        this.reglasDeFichero = reglasDeFichero;
    }

    protected List<ITipoDatosReglasTipoYPartidas> getReglasDeFichero() {
        return this.reglasDeFichero;
    }

    @Override
    public void setDocumentosTraduccion(List<Document> documentosTraduccion) {
        this.documentosTraduccion = documentosTraduccion;
    }

    @Override
    public List<Document> getDocumentosTraduccion() {
        return this.documentosTraduccion;
    }
}

