/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.gestionFicheros.exportacionV2.xml;

import es.aeat.pftw.mtrc.IAop;
import es.aeat.pftw.mtrc.configuracion.IGestorConfiguracion;
import es.aeat.pftw.mtrc.gestionFicheros.exportacionV2.xml.ExportacionXML;
import es.aeat.pftw.mtrc.gestionFicheros.exportacionV2.xml.IExportacionXML;
import es.aeat.pftw.mtrc.gestionFicheros.exportacionV2.xml.IGeneradorLineas;
import es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.IGestorTraducciones;
import es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.xml.IGestorTraduccionesXML;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.puente.TablaMotorEntrada;
import es.aeat.pftw.mtrc.tipos.ITipoDatosTabla;
import es.aeat.pftw.mtrc.tipos.TipoDatosCampoValor;
import es.aeat.pftw.mtrc.tipos.TipoDatosCampos;
import es.aeat.pftw.mtrc.utilidades.FileWriterAEAT;
import es.aeat.pftw.mtrc.utilidades.Formatear;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.utilidades.IFileWriterAEAT;
import es.aeat.pftw.mtrc.utilidades.StringAEAT;
import es.aeat.pftw.mtrc.utilidades.StringUtility;
import es.aeat.pftw.mtrp.configuracion.IRegEntrada;
import es.aeat.pftw.mtrp.configuracion.IRegRelacionada;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.puente.ITablaMotorEntrada;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampoValor;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampos;
import es.aeat.pftw.mtrp.utilidades.GestorTablas;
import es.aeat.pftw.mtrp.utilidades.IGestorTablas;
import es.aeat.pftw.mtrp.utilidades.INodoArbol;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class GeneradorLineas
implements IAop,
Serializable,
IGeneradorLineas {
    private static final long serialVersionUID = 1L;
    protected IExportacionXML claseExportacionXML = null;
    protected static final int CTE_NO_HAY_TABLAS = 0;
    protected static final int CTE_SI_HAY_TABLAS_PERO_SIN_DATOS = 1;
    protected static final int CTE_SI_HAY_TABLAS_Y_HAY_DATOS = 2;
    protected static final String IGNORAR_CAMPO = "~Ignorar este campo porque no es necesario escribirlo~";
    protected static final int CACHE_GENERADOR_MAX_CAPACITY = 1000;
    private Map<String, Map<String, String>> cacheGenerador = null;
    protected boolean generarAuxiliar = true;
    protected String nombreTablaActual = "";
    protected String ficheroLogPrivado = "";
    protected IFileWriterAEAT fw = null;
    protected Map<String, List<String>> cacheParaDameTablasHijasDe = null;
    protected transient IGestorTablas gestorTablas = null;
    protected final String cadenaBorrado = "----borrar esta linea pq es del registro padre-----";

    @Override
    public void dispose() throws ExceptionMotor {
        this.claseExportacionXML = null;
        this.cacheGenerador = null;
        this.fw = null;
        this.cacheParaDameTablasHijasDe = null;
        this.gestorTablas.init();
        this.gestorTablas = null;
    }

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            this.claseExportacionXML = (ExportacionXML)parametros[0];
            this.cacheGenerador = new HashMap<String, Map<String, String>>();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void clearMem() {
        try {
            this.cacheGenerador.clear();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.gestorTablas.init();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.cacheParaDameTablasHijasDe.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public IGestorTablas getGestorTablas() throws ExceptionMotor {
        if (this.gestorTablas == null) {
            this.gestorTablas = new GestorTablas(this.getArbolDatos());
        }
        return this.gestorTablas;
    }

    @Override
    public void setGenerarAuxiliar(boolean bol) {
        this.generarAuxiliar = bol;
    }

    @Override
    public boolean getGenerarAuxiliar() {
        return this.isGenerarAuxiliar();
    }

    @Override
    public boolean setGestorTraducciones(IGestorTraduccionesXML g) throws ExceptionMotor {
        try {
            this.getClaseExportacionXML().setGestorTraduccionesXML(g);
            return true;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public String eliminaNotacionExponencial(String num, int numDecimales) {
        if (!num.toUpperCase().contains("E")) {
            return num;
        }
        String numero = num;
        numero = numero.replace('.', ',');
        Locale esp = new Locale("es", "ES");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(esp);
        DecimalFormat df = null;
        String formatear = "#0";
        for (int i = 1; i <= numDecimales; ++i) {
            if (i == 1) {
                formatear = formatear + ".";
            }
            formatear = formatear + "0";
        }
        df = new DecimalFormat(formatear, dfs);
        try {
            numero = df.format(df.parse(numero));
        }
        catch (Exception e) {
            numero = "";
        }
        numero = numero.replace(',', '.');
        return numero;
    }

    @Override
    public String formateaNumero(String val, int longitudTotal, int numDecimales) throws ExceptionMotor {
        try {
            int i = 0;
            String valor = val;
            String resultado = "";
            String parteEntera = "";
            String parteDecimal = "";
            valor = this.eliminaNotacionExponencial(valor, numDecimales);
            int posPunto = valor.indexOf(46);
            if (posPunto > 0) {
                parteEntera = valor.substring(0, posPunto);
                parteDecimal = valor.substring(posPunto + 1);
                if (parteDecimal.length() > numDecimales) {
                    parteDecimal = parteDecimal.substring(0, numDecimales);
                }
            } else {
                parteEntera = valor;
            }
            resultado = resultado + parteEntera;
            if (posPunto > 0) {
                resultado = resultado + ".";
            }
            if (numDecimales > 0) {
                resultado = resultado + parteDecimal;
                for (i = 0; i < numDecimales - parteDecimal.length(); ++i) {
                    resultado = resultado + "0";
                }
            }
            return resultado;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Valor " + val + " long " + longitudTotal + " decimales " + numDecimales);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String dameCampo(String nombreTabla, String nombreCampo, String valor) throws ExceptionMotor {
        List<ITipoDatosCampos> camposTransXML = null;
        List<ITipoDatosTabla> tablasEnGestor = null;
        HashMap<String, ITablaMotorEntrada> listaCamposBD = null;
        try {
            try {
                listaCamposBD = new HashMap<String, ITablaMotorEntrada>();
                TablaMotorEntrada te = new TablaMotorEntrada(nombreCampo, valor);
                listaCamposBD.put(te.getNombreEntrada(), te);
                te = null;
                int iteradorColeccionesDeTablas = 0;
                block9: while (true) {
                    if (iteradorColeccionesDeTablas >= 2) {
                        throw new ExceptionMotor("Imposible encontrar campo " + nombreCampo + " de tabla " + nombreTabla);
                    }
                    switch (iteradorColeccionesDeTablas) {
                        case 0: {
                            tablasEnGestor = ((IGestorTraduccionesXML)this.getClaseExportacionXML().getGestorTraduccionesXML()).getTablas();
                            break;
                        }
                        case 1: {
                            tablasEnGestor = ((IGestorTraduccionesXML)this.getClaseExportacionXML().getGestorTraduccionesXML()).getTablasAuxiliares();
                            break;
                        }
                        default: {
                            throw new ExceptionMotor("Imposible encontrar campo " + nombreCampo + " de tabla " + nombreTabla);
                        }
                    }
                    int i = 0;
                    while (true) {
                        block14: {
                            block15: {
                                block13: {
                                    if (i >= tablasEnGestor.size()) break block13;
                                    if (!tablasEnGestor.get(i).getNombreTabla().equalsIgnoreCase(nombreTabla)) break block14;
                                    camposTransXML = tablasEnGestor.get(i).getCampos();
                                    break block15;
                                }
                                ++iteradorColeccionesDeTablas;
                                continue block9;
                            }
                            for (int j = 0; j < camposTransXML.size(); ++j) {
                                if (!nombreCampo.equalsIgnoreCase(camposTransXML.get(j).getNombreCampo())) continue;
                                return this.dameCampo(camposTransXML.get(j), listaCamposBD);
                            }
                        }
                        ++i;
                    }
                    break;
                }
            }
            catch (ExceptionMotor ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ExceptionMotor(ex, "Campo " + nombreCampo + " de tabla " + nombreTabla);
            }
        }
        catch (Throwable throwable) {
            camposTransXML = null;
            tablasEnGestor = null;
            listaCamposBD = null;
            throw throwable;
        }
    }

    public String sacaValorDeListaCamposBD(ITipoDatosCampos campoTransXML, String tipoDato, Map<String, String> propiedades, Map<String, ITablaMotorEntrada> listaCamposBD) throws ExceptionMotor {
        try {
            String nombreCampoOriginal = campoTransXML.getNombreCampo();
            String nombreCampo = FuncionesUtiles.getFuncionesUtiles().dameNombrePartidaSinParentesis(nombreCampoOriginal);
            String valorBD = propiedades.get("SUSTITUCION").toString();
            propiedades.remove("SUSTITUCION");
            if (valorBD.length() == 0 && !tipoDato.startsWith("CTE:")) {
                try {
                    String filtro = propiedades.get("FILTRO");
                    valorBD = FuncionesUtiles.getFuncionesUtiles().sacaDeListaEx(listaCamposBD, nombreCampo, nombreCampoOriginal, nombreCampo + "[" + filtro + "]", nombreCampoOriginal + "[" + filtro + "]").getValor().toString();
                }
                catch (Exception ex) {
                    valorBD = "";
                }
            }
            return valorBD;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public String dameCampo(ITipoDatosCampos campoTransXML, Map<String, ITablaMotorEntrada> listaCamposBD) throws ExceptionMotor {
        Map<String, String> propiedades = null;
        String nombreCampoOriginal = campoTransXML.getNombreCampo();
        try {
            String valorBD = "";
            String tipoDato = "";
            String valorAux = "";
            String valor = "";
            String filtro = "";
            String nombreCampo = FuncionesUtiles.getFuncionesUtiles().dameNombrePartidaSinParentesis(nombreCampoOriginal);
            propiedades = FuncionesUtiles.getFuncionesUtiles().traducirTipoCampo(campoTransXML.getPropiedadesCampos(), (IGestorTraduccionesXML)this.getClaseExportacionXML().getGestorTraduccionesXML(), listaCamposBD);
            if (propiedades.containsKey("NOEXPORTAR")) {
                String string = "";
                return string;
            }
            if (nombreCampo.length() == 0 && propiedades.containsKey("VALOR")) {
                nombreCampo = propiedades.get("VALOR");
            }
            tipoDato = propiedades.get("TIPODATO").toString();
            valorBD = propiedades.get("SUSTITUCION").toString();
            propiedades.remove("SUSTITUCION");
            int numDecimales = 0;
            if (propiedades.get("DECIMALES") != null) {
                try {
                    numDecimales = Integer.valueOf(propiedades.get("DECIMALES").toString());
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (valorBD.length() == 0 && !tipoDato.startsWith("CTE:")) {
                try {
                    filtro = propiedades.get("FILTRO");
                    valorBD = FuncionesUtiles.getFuncionesUtiles().sacaDeListaEx(listaCamposBD, nombreCampo, nombreCampoOriginal, nombreCampo + "[" + filtro + "]", nombreCampoOriginal + "[" + filtro + "]").getValor().toString();
                }
                catch (Exception ex) {
                    valorBD = "";
                }
            }
            int longitud = propiedades.containsKey("LONGITUD") ? Integer.valueOf(propiedades.get("LONGITUD").toString()) : (tipoDato.startsWith("CTE:") ? Integer.valueOf(tipoDato.substring("CTE:".length()).length()) : -1);
            String string = this.dameCampoEx(tipoDato, valorBD, longitud, numDecimales, valorAux, nombreCampoOriginal, listaCamposBD, valor, campoTransXML, propiedades);
            return string;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Campo " + nombreCampoOriginal);
        }
        finally {
            propiedades = null;
        }
    }

    @Override
    public String dameCampoEx(String tipoDato, String valorBD, int longitud, int numDecimales, String valorAux, String nomCampo, Map<String, ITablaMotorEntrada> listaCamposBD, String valor, ITipoDatosCampos campoTransXML, Map<String, String> propiedades) throws ExceptionMotor {
        try {
            String nombreCampo = FuncionesUtiles.getFuncionesUtiles().dameNombrePartidaSinParentesis(nomCampo);
            if (tipoDato.equalsIgnoreCase("Num")) {
                if (valorBD.length() == 0) {
                    valorBD = "0";
                }
                if (valorBD.contains("-")) {
                    throw new ExceptionMotor("Partida " + nombreCampo + " no admite negativos y se intenta grabar " + valorBD);
                }
                valorBD = Formatear.getFormatear().redondea(new BigDecimal(valorBD.trim()), (Object)numDecimales).toString();
                return this.formateaNumero(valorBD, longitud, numDecimales);
            }
            if (tipoDato.equalsIgnoreCase("NumSigno")) {
                String lineaSalida = "";
                valorBD = Formatear.getFormatear().redondea(new BigDecimal(valorBD.trim()), (Object)numDecimales).toString();
                valorAux = valorBD;
                if (valorAux.length() == 0) {
                    valorBD = "0";
                }
                if (valorAux.charAt(0) == '-') {
                    valorAux = valorAux.substring(1);
                    lineaSalida = "N";
                } else if (this.longitudNumeroSinPuntosetc(valorAux) < longitud) {
                    lineaSalida = ((IGestorTraducciones)this.getClaseExportacionXML().getGestorTraduccionesXML()).isEsNumeroPositivoCon0() ? "0" : " ";
                }
                return lineaSalida + this.formateaNumero(valorAux, longitud - 1, numDecimales);
            }
            if (tipoDato.equalsIgnoreCase("CADNUM")) {
                if (valorBD.length() != longitud) {
                    valorBD = FuncionesUtiles.getFuncionesUtiles().rellena(valorBD, '0', longitud, true);
                }
                return valorBD;
            }
            if (tipoDato.equalsIgnoreCase("CADNUM2")) {
                if (valorBD.length() != longitud) {
                    valorBD = valorBD.trim().length() == 0 ? FuncionesUtiles.getFuncionesUtiles().rellena(valorBD, ' ', longitud, true) : FuncionesUtiles.getFuncionesUtiles().rellena(valorBD, '0', longitud, true);
                }
                return valorBD;
            }
            if (tipoDato.equalsIgnoreCase("Nif")) {
                if (valorBD.length() != longitud) {
                    valorBD = FuncionesUtiles.getFuncionesUtiles().rellena(valorBD, ' ', longitud);
                }
                return valorBD;
            }
            if (tipoDato.equalsIgnoreCase("FECHA_SIN_FORMATO")) {
                valor = FuncionesUtiles.getFuncionesUtiles().sacaDeLista(listaCamposBD, nombreCampo, nomCampo).getValor().toString();
                return this.formateaFecha(valor);
            }
            if (tipoDato.equalsIgnoreCase("FechaInvertidaF")) {
                longitud = 8;
                if ((valorBD = valorBD.replaceAll("-", "").replaceAll("/", "")).trim().length() == 0) {
                    return "";
                }
                if (valorBD.length() != longitud) {
                    valorBD = FuncionesUtiles.getFuncionesUtiles().rellena(valorBD, '0', longitud);
                }
                return valorBD.substring(4) + "-" + valorBD.substring(2, 4) + "-" + valorBD.substring(0, 2);
            }
            if (tipoDato.equalsIgnoreCase("FechaInvertida")) {
                longitud = 8;
                if ((valorBD = valorBD.replaceAll("-", "").replaceAll("/", "")).length() != longitud) {
                    valorBD = FuncionesUtiles.getFuncionesUtiles().rellena(valorBD, '0', longitud);
                }
                return valorBD.substring(6, 8) + valorBD.substring(4, 6) + valorBD.substring(0, 4);
            }
            if (tipoDato.startsWith("Valores:")) {
                String ll = tipoDato.substring(8);
                String valorFinal = "";
                Map<String, String> correspondencias = this.getFromCache(ll);
                if (correspondencias == null) {
                    correspondencias = new HashMap<String, String>();
                    String[] p = StringUtility.getStringUtility().split(ll, ":");
                    for (int k = 0; k < p.length; ++k) {
                        String[] q = StringUtility.getStringUtility().split(p[k], "=");
                        if (q.length != 2) continue;
                        correspondencias.put(FuncionesUtiles.getFuncionesUtiles().desCodificaCadena(q[1]).toUpperCase(), FuncionesUtiles.getFuncionesUtiles().desCodificaCadena(q[0]));
                    }
                    this.setInCache(ll, correspondencias);
                }
                try {
                    valorFinal = correspondencias.get(valorBD.toUpperCase()).toString();
                }
                catch (Exception ex) {
                    valorFinal = "";
                }
                if (valorFinal.length() == 0) {
                    throw new ExceptionMotor("Imposible encontrar valores para partida " + nombreCampo + " en tipo " + tipoDato);
                }
                return valorFinal;
            }
            if (tipoDato.startsWith("CTE:")) {
                valorBD = FuncionesUtiles.getFuncionesUtiles().desCodificaCadena(tipoDato.substring("CTE:".length()));
                if (valorBD.length() == 0) {
                    valorBD = " ";
                }
                valorAux = valorBD.length() > 1 ? valorBD : FuncionesUtiles.getFuncionesUtiles().rellena("", valorBD.charAt(0), longitud);
                return valorAux;
            }
            if (tipoDato.trim().equalsIgnoreCase("1_a_true")) {
                if (FuncionesUtiles.getFuncionesUtiles().sacaDeLista(listaCamposBD, nombreCampo, nomCampo).getValor().toString().equalsIgnoreCase("true")) {
                    return "1";
                }
                return "0";
            }
            if (tipoDato.trim().equalsIgnoreCase("SELLO")) {
                return FuncionesUtiles.getFuncionesUtiles().rellena("", ' ', longitud);
            }
            if (tipoDato.equalsIgnoreCase("X_a_true")) {
                if (FuncionesUtiles.getFuncionesUtiles().sacaDeLista(listaCamposBD, nombreCampo, nomCampo).getValor().toString().equalsIgnoreCase("true")) {
                    return "X";
                }
                return " ";
            }
            if (tipoDato.trim().toUpperCase().startsWith("SIVALOR")) {
                String[] valores = tipoDato.substring(8).split("_");
                if (FuncionesUtiles.getFuncionesUtiles().sacaDeLista(listaCamposBD, nombreCampo, nomCampo).getValor().toString().length() == 0) {
                    return valores[1];
                }
                if (FuncionesUtiles.getFuncionesUtiles().sacaDeLista(listaCamposBD, nombreCampo, nomCampo).getValor().toString().equalsIgnoreCase("0") | FuncionesUtiles.getFuncionesUtiles().sacaDeLista(listaCamposBD, nombreCampo, nomCampo).getValor().toString().equalsIgnoreCase("0.0") | FuncionesUtiles.getFuncionesUtiles().sacaDeLista(listaCamposBD, nombreCampo, nomCampo).getValor().toString().equalsIgnoreCase("0.00") | FuncionesUtiles.getFuncionesUtiles().sacaDeLista(listaCamposBD, nombreCampo, nomCampo).getValor().toString().equalsIgnoreCase("0.000") | FuncionesUtiles.getFuncionesUtiles().sacaDeLista(listaCamposBD, nombreCampo, nomCampo).getValor().toString().equalsIgnoreCase("0.0000")) {
                    return valores[1];
                }
                return valores[0];
            }
            if (tipoDato.trim().startsWith("CADNUM")) {
                valor = FuncionesUtiles.getFuncionesUtiles().sacaDeLista(listaCamposBD, nombreCampo, nomCampo).getValor().toString();
                valor = FuncionesUtiles.getFuncionesUtiles().rellena(valor, '0', longitud);
                return valor;
            }
            if (tipoDato.trim().toUpperCase().startsWith("ORDINALCASILLAS")) {
                String[] partidas = tipoDato.substring("ORDINALCASILLAS".length() + 1).toUpperCase().split(",");
                for (int i = 0; i < partidas.length; ++i) {
                    if (listaCamposBD.get(partidas[i]) == null) {
                        TablaMotorEntrada te = new TablaMotorEntrada(partidas[i], "false");
                        listaCamposBD.put(te.getNombreEntrada(), te);
                        te = null;
                    }
                    if (listaCamposBD.get(partidas[i]).getValor().toString().compareToIgnoreCase("true") != 0) continue;
                    return String.valueOf(i + 1);
                }
                return "0";
            }
            if (tipoDato.trim().toUpperCase().startsWith("LAQTENGAVALOR")) {
                String ret = "";
                String[] partidas = tipoDato.substring("LAQTENGAVALOR".length() + 1).toUpperCase().split(",");
                for (int i = 0; i < partidas.length; ++i) {
                    String valorEnBBDD;
                    if (listaCamposBD.get(partidas[i]) == null) {
                        TablaMotorEntrada te = new TablaMotorEntrada(partidas[i], this.claseExportacionXML.getSesion().getModelo().getGestorConfiguracion().getEntrada(partidas[i]).getValorInicial());
                        listaCamposBD.put(te.getNombreEntrada(), te);
                        te = null;
                    }
                    valor = valorEnBBDD = listaCamposBD.get(partidas[i]).getValor().toString();
                    String tipoReal = campoTransXML.getPropiedadesCampos().get("TIPODATOREAL");
                    if (tipoReal == null) {
                        throw new Exception("Debe tener en el trans la entrada TIPODATOREAL para tipo de dato LAQTENGAVALOR");
                    }
                    TipoDatosCampos tclon = new TipoDatosCampos(partidas[i]);
                    tclon.setPropiedadesCampos(campoTransXML.getPropiedadesCampos());
                    tclon.getPropiedadesCampos().put("TIPODATO", tipoReal);
                    valor = this.dameCampo(tclon, listaCamposBD);
                    if (i == 0) {
                        ret = valor;
                    }
                    if (this.claseExportacionXML.getSesion().getModelo().getGestorConfiguracion().getEntrada(partidas[i]).esValorPorDefecto(valorEnBBDD)) continue;
                    return valor;
                }
                return ret;
            }
            if (tipoDato.trim().toUpperCase().startsWith("DE_") && (valor = FuncionesUtiles.getFuncionesUtiles().sacaDeLista(listaCamposBD, nombreCampo, nomCampo).getValor().toString()).trim().length() == 0) {
                return "0";
            }
            if (tipoDato.trim().toUpperCase().startsWith("DEB_") && (valor = FuncionesUtiles.getFuncionesUtiles().sacaDeLista(listaCamposBD, nombreCampo, nomCampo).getValor().toString()).trim().length() == 0) {
                return " ";
            }
            valorAux = FuncionesUtiles.getFuncionesUtiles().rellena(valorBD, ' ', longitud);
            return valorAux;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public String formateaFecha(String valor) throws ExceptionMotor {
        if (valor.length() == 10) {
            return valor.substring(0, 2) + valor.substring(3, 5) + valor.substring(6);
        }
        if (valor.length() == 8) {
            return valor;
        }
        if (valor.length() == 0 || valor.equalsIgnoreCase("00000000")) {
            return "00000000";
        }
        throw new ExceptionMotor("Formato incorrecto en FECHA_SIN_FORMATO");
    }

    @Override
    public int longitudNumeroSinPuntosetc(String valor) {
        int ret = 0;
        for (int i = 0; i < valor.length(); ++i) {
            try {
                Integer.valueOf(valor.substring(i, i + 1));
                ++ret;
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return ret;
    }

    @Override
    public String compruebaCampo(ITipoDatosCampos campoTransXML, Map<String, ITablaMotorEntrada> listaCamposBD, String valor) throws ExceptionMotor {
        try {
            return valor;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void escribeLogPrivadoCabecera(String observaciones) {
        try {
            this.getFw().writeln();
            FuncionesUtiles.getFuncionesUtiles().muestraAviso("\u00a1\u00a1\u00a1\u00a1\u00a1\u00a1USANDO LOG PARA LA EXPORTACION, RALENTIZA TODO SOLO USAR EN DEBUG!!!!!!");
            this.getFw().writeln("--------------------------------------------------------------------------------------");
            this.getFw().writeln(observaciones);
            this.getFw().writeln("--------------------------------------------------------------------------------------");
            this.getFw().writeln();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void escribeLogPrivado(int posicion, String nombreCampo, String valor, String observaciones) {
        try {
            this.getFw().writeln(posicion + " " + nombreCampo + " => [" + valor + "]" + " " + observaciones);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected String limpiaIndice(String atributo) {
        if (atributo.contains("(")) {
            return atributo.substring(0, atributo.indexOf("("));
        }
        return atributo;
    }

    protected void escribeEnXML(StringAEAT lineaSalida, String aEscribir, boolean ultimaAlias, boolean esCampo, Stack<String> pilaCierre, String etiquetaCierre) throws ExceptionMotor {
        try {
            if (esCampo) {
                lineaSalida.append(aEscribir);
                if (ultimaAlias) {
                    pilaCierre.push(etiquetaCierre);
                } else {
                    pilaCierre.push(etiquetaCierre);
                }
            } else {
                lineaSalida.append(aEscribir);
                pilaCierre.push(etiquetaCierre);
            }
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public String dameLinea(Map<String, String> parametrosTabla, List<ITipoDatosCampos> camposTransXML, Map<String, ITablaMotorEntrada> listaCamposBD) throws ExceptionMotor {
        String campo = "";
        StringAEAT lineaSalida = new StringAEAT();
        try {
            int desplazamiento = 0;
            try {
                if (parametrosTabla.containsKey("VARIABLE")) {
                    desplazamiento = parametrosTabla.get("VARIABLE").toString().length() + 1;
                } else if (parametrosTabla.containsKey("CONSTANTE")) {
                    desplazamiento = parametrosTabla.get("CONSTANTE").toString().length() + 1;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (!parametrosTabla.containsKey("EQUIVALENCIA")) {
                String nombre = "??";
                if (parametrosTabla.containsKey("LITERAL")) {
                    nombre = parametrosTabla.get("LITERAL");
                }
                throw new ExceptionMotor("Tabla " + nombre + " sin atributo obligatorio " + "EQUIVALENCIA");
            }
            String atributosTabla = "";
            if (parametrosTabla.containsKey("CAMPO_ATRIBUTO")) {
                TipoDatosCampos tdc = new TipoDatosCampos(parametrosTabla.get("CAMPO_ATRIBUTO").toUpperCase());
                tdc.setPropiedadesCampos(((IGestorTraduccionesXML)this.claseExportacionXML.getGestorTraduccionesXML()).getListaCamposEnAtributos(parametrosTabla.get("CAMPO_ATRIBUTO")));
                String valor = this.dameCampo(tdc, listaCamposBD);
                if (valor.trim().length() > 0) {
                    atributosTabla = " " + tdc.getPropiedadesCampos().get("CORRESPONDENCIA_ATRIBUTO") + "='" + valor + "'";
                }
            }
            Stack<String> closeCampoPool = new Stack<String>();
            Stack<String> closeTablePool = new Stack<String>();
            String[] tablas = parametrosTabla.get("EQUIVALENCIA").split("/");
            for (int i = 0; i < tablas.length; ++i) {
                if (tablas[i].equalsIgnoreCase(((IGestorTraduccionesXML)this.claseExportacionXML.getGestorTraduccionesXML()).getTablaRaiz())) continue;
                this.escribeEnXML(lineaSalida, "<" + tablas[i] + atributosTabla + ">", false, false, closeTablePool, "</" + tablas[i] + ">");
            }
            while (!closeTablePool.isEmpty()) {
                lineaSalida.append((String)closeTablePool.pop());
            }
            closeTablePool = null;
            Stack<String> pilaAtributosPendientes = new Stack<String>();
            for (int i = 0; i < camposTransXML.size(); ++i) {
                campo = this.dameCampo(camposTransXML.get(i), listaCamposBD);
                if (this.getFicheroLogPrivado().length() > 0) {
                    this.escribeLogPrivado(lineaSalida.length() + desplazamiento, camposTransXML.get(i).getPropiedadesCampos().get("LITERAL").toString(), campo, "");
                }
                if (campo == null) {
                    return null;
                }
                boolean comprobarlo = true;
                if (camposTransXML.get(i).getPropiedadesCampos() != null) {
                    boolean bl = comprobarlo = !camposTransXML.get(i).getPropiedadesCampos().containsKey("NOEXPORTAR");
                    if (camposTransXML.get(i).getPropiedadesCampos().containsKey("ATRIBUTO_PARA_TABLA")) continue;
                }
                if (comprobarlo && (campo = this.compruebaCampo(camposTransXML.get(i), listaCamposBD, campo)) == null) {
                    return null;
                }
                if (camposTransXML.get(i).getPropiedadesCampos().containsKey("CORRESPONDENCIA_ATRIBUTO")) {
                    if (campo.trim().length() <= 0) continue;
                    pilaAtributosPendientes.push(this.limpiaIndice(camposTransXML.get(i).getPropiedadesCampos().get("CORRESPONDENCIA_ATRIBUTO")) + "='" + campo + "'");
                    continue;
                }
                if (!camposTransXML.get(i).getPropiedadesCampos().containsKey("EQUIVALENCIA")) {
                    throw new ExceptionMotor("Campo " + campo + " sin atributo obligatorio " + "EQUIVALENCIA");
                }
                if (campo.trim().length() == 0 && pilaAtributosPendientes.isEmpty()) continue;
                String[] rutaCampo = camposTransXML.get(i).getPropiedadesCampos().get("EQUIVALENCIA").split("/");
                StringAEAT lineaCampo = new StringAEAT();
                for (int u = 1; u < rutaCampo.length; ++u) {
                    if (rutaCampo[u].equalsIgnoreCase(IGNORAR_CAMPO)) continue;
                    String atributo = "";
                    if (u == rutaCampo.length - 1) {
                        atributo = this.dameAtributos(pilaAtributosPendientes);
                    }
                    this.escribeEnXML(lineaCampo, "<" + rutaCampo[u] + atributo + ">", u == rutaCampo.length - 1, true, closeCampoPool, "</" + rutaCampo[u] + ">");
                }
                lineaCampo.append(campo);
                if (!closeCampoPool.isEmpty()) {
                    lineaCampo.append((String)closeCampoPool.pop());
                }
                while (!closeCampoPool.isEmpty()) {
                    lineaCampo.append((String)closeCampoPool.pop());
                }
                String merged = this.dameCadenaIncrustadaEnSuSitio(lineaSalida.getString(), lineaCampo.getString(), null, false);
                lineaSalida.close();
                lineaCampo.close();
                lineaSalida = new StringAEAT();
                lineaSalida.append(merged);
            }
            return lineaSalida.getString();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Campo " + campo + " lineaSalida " + lineaSalida);
        }
    }

    protected String dameAtributos(Stack<String> pilaAtributosPendientes) throws Exception {
        if (pilaAtributosPendientes.size() > 0) {
            String ret = "";
            while (!pilaAtributosPendientes.isEmpty()) {
                ret = ret + " " + pilaAtributosPendientes.pop();
            }
            return ret;
        }
        return "";
    }

    @Override
    public String dameNombrePartidaSinParentesis(String partida) {
        int i = partida.indexOf(40);
        if (i > -1) {
            return partida.substring(0, i);
        }
        return partida;
    }

    @Override
    public ITipoDatosCampoValor damePartida(String cadenas) throws ExceptionMotor {
        try {
            String[] partidas;
            TipoDatosCampoValor ret = new TipoDatosCampoValor("", "");
            for (String partida : partidas = cadenas.split(",")) {
                String nom = this.dameNombrePartidaSinParentesis(partida);
                String val = this.getSesion().getOperaciones().obtenerPartidaString(nom);
                if (ret.getNombreCampo().trim().length() == 0) {
                    ret.setNombreCampo(nom);
                    ret.setValor(val);
                    continue;
                }
                if (this.getSesion().getModelo().getGestorConfiguracion().getEntrada(nom).esValorPorDefecto(val)) continue;
                ret.setNombreCampo(nom);
                ret.setValor(val);
            }
            return ret;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public boolean tieneDatos(List<ITipoDatosCampos> camposTransXML, Map<String, ITablaMotorEntrada> listaCamposBD) throws ExceptionMotor {
        String partida = "";
        try {
            for (ITipoDatosCampos campo : camposTransXML) {
                partida = campo.getNombreCampo();
                IRegEntrada entrada = this.getSesion().getModelo().getGestorConfiguracion().getEntrada(this.dameNombrePartidaSinParentesis(partida));
                if (entrada == null || entrada.esValorPorDefecto(listaCamposBD.get(partida).getValor().toString())) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Partida " + partida);
        }
    }

    protected String concatenaFiltroAEntrada(String entrada, String filtro) {
        if (filtro != null && filtro.length() > 0) {
            return entrada + "[" + filtro + "]";
        }
        return entrada;
    }

    protected boolean esTipoDatoCTE(Map<String, String> prop) throws ExceptionMotor {
        try {
            if (prop != null && prop.containsKey("TIPODATO")) {
                return prop.get("TIPODATO").startsWith("CTE:");
            }
            return false;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public List<String> generaLinea(String sNombreTabla, Map<String, ITablaMotorEntrada> listaCamposBD) throws ExceptionMotor {
        ArrayList<String> aFinal = new ArrayList<String>();
        String lineaSalida = "";
        List<Object> camposTransXML = new ArrayList();
        TablaMotorEntrada te = null;
        long l = -1L;
        try {
            List<ITipoDatosTabla> tablasEnGestor = ((IGestorTraduccionesXML)this.getClaseExportacionXML().getGestorTraduccionesXML()).getTablas();
            for (int i = 0; i < tablasEnGestor.size(); ++i) {
                this.setNombreTablaActual(tablasEnGestor.get(i).getNombreTabla());
                Map<String, String> parametrosTabla = ((IGestorTraduccionesXML)this.getClaseExportacionXML().getGestorTraduccionesXML()).getTabla(this.getNombreTablaActual());
                camposTransXML = FuncionesUtiles.getFuncionesUtiles().cloneList(tablasEnGestor.get(i).getCampos());
                listaCamposBD = null;
                listaCamposBD = new HashMap<String, ITablaMotorEntrada>();
                boolean primeraPasada = true;
                do {
                    ITipoDatosCampoValor tcv;
                    Map<String, String> propCampos;
                    lineaSalida = "";
                    if (parametrosTabla.containsKey("CONSTANTE")) {
                        if (parametrosTabla.get("CONSTANTE").toString().indexOf(":") == -1) {
                            lineaSalida = FuncionesUtiles.getFuncionesUtiles().html2Text(parametrosTabla.get("CONSTANTE").toString().toUpperCase());
                        }
                    } else if (parametrosTabla.containsKey("VARIABLE")) {
                        lineaSalida = FuncionesUtiles.getFuncionesUtiles().html2Text(this.getSesion().getOperaciones().obtenerPartidaString(parametrosTabla.get("VARIABLE")).trim().toUpperCase());
                    }
                    int hayDatosEnTablas = 0;
                    String filtro = "";
                    if (parametrosTabla.containsKey("CAMPO_ATRIBUTO")) {
                        TipoDatosCampos tdc = new TipoDatosCampos(parametrosTabla.get("CAMPO_ATRIBUTO"));
                        tdc.setPropiedadesCampos(((IGestorTraduccionesXML)this.claseExportacionXML.getGestorTraduccionesXML()).getListaCamposEnAtributos(parametrosTabla.get("CAMPO_ATRIBUTO")));
                        String nombrePartida = tdc.getPropiedadesCampos().get("CORRESPONDENCIA_ATRIBUTO").toUpperCase();
                        propCampos = ((IGestorTraduccionesXML)this.getClaseExportacionXML().getGestorTraduccionesXML()).getListaCamposEnAtributos(nombrePartida);
                        if (propCampos == null) {
                            throw new ExceptionMotor("No encuentro atributos de campo " + nombrePartida);
                        }
                        String nombreCampo = propCampos.get("PARTIDA");
                        if (nombreCampo != null) {
                            tcv = this.damePartida(nombreCampo);
                            String valorPartida = tcv.getValor();
                            te = new TablaMotorEntrada(nombrePartida, valorPartida);
                            listaCamposBD.put(te.getNombreEntrada(), te);
                        }
                    }
                    for (int j = 0; j < camposTransXML.size(); ++j) {
                        String nombreTabla;
                        propCampos = ((ITipoDatosCampos)camposTransXML.get(j)).getPropiedadesCampos();
                        if (propCampos.get("PARTIDA") == null) {
                            propCampos.put("PARTIDA", "");
                        }
                        if (((ITipoDatosCampos)camposTransXML.get(j)).getNombreCampo() == null) {
                            ((ITipoDatosCampos)camposTransXML.get(j)).setNombreCampo("");
                        }
                        if (!primeraPasada && propCampos.containsKey("SIGUIENTES")) {
                            String siguientes = propCampos.get("SIGUIENTES");
                            if (siguientes.startsWith("NO VALIDAR")) {
                                siguientes = siguientes.substring("NO VALIDAR".length() + 1);
                            }
                            if (!siguientes.toUpperCase().startsWith("CTE:")) {
                                siguientes = "CTE:" + FuncionesUtiles.getFuncionesUtiles().codificaCadena(siguientes);
                            }
                            if (!((ITipoDatosCampos)camposTransXML.get(j)).getNombreCampo().equals("")) {
                                ((ITipoDatosCampos)camposTransXML.get(j)).setNombreCampo("~comp");
                            }
                            propCampos.put("TIPODATO", siguientes);
                        }
                        filtro = propCampos.get("FILTRO");
                        if (propCampos.containsKey("LOCALIZADORUNICOCAMPO") && !propCampos.containsKey("VALOR") && this.getSesion().getModelo().getGestorConfiguracion().getEntrada(propCampos.get("LOCALIZADORUNICOCAMPO").toUpperCase()) == null) {
                            propCampos.remove("LOCALIZADORUNICOCAMPO");
                            ((ITipoDatosCampos)camposTransXML.get(j)).setNombreCampo("");
                        }
                        if (((ITipoDatosCampos)camposTransXML.get(j)).getNombreCampo().equalsIgnoreCase("") && propCampos.get("VALOR") == null && propCampos.get("ULTIMOCAMPO") == null || ((ITipoDatosCampos)camposTransXML.get(j)).getNombreCampo().equalsIgnoreCase("~comp")) continue;
                        boolean tratar = true;
                        if (parametrosTabla.get("ITERARTABLA") != null) {
                            if (hayDatosEnTablas == 0) {
                                hayDatosEnTablas = 1;
                            }
                            nombreTabla = this.getNombreTablaActual();
                            if (this.getGestorTablas().esTablaAcabada(nombreTabla, filtro) || this.getSesion() != null && this.obtenerClaveActiva(nombreTabla) == -1L) {
                                this.getGestorTablas().acaboTabla(nombreTabla, filtro);
                                tratar = false;
                            }
                            if (!this.getGestorTablas().isComenzoTabla(nombreTabla, filtro)) {
                                this.getGestorTablas().comenzoTabla(nombreTabla, filtro);
                                l = -1L;
                                if (this.getSesion() != null) {
                                    l = this.moveFirst(nombreTabla, filtro);
                                }
                                if (l > 0L) {
                                    this.getGestorTablas().recorriendoTabla(nombreTabla, filtro, new TipoDatosCampoValor(String.valueOf(l), this.getSesion().getOperaciones().getLocalizacion(nombreTabla)));
                                } else {
                                    this.getGestorTablas().acaboTabla(nombreTabla, filtro);
                                    tratar = false;
                                }
                            } else if (this.getGestorTablas().isRecorriendoTabla(nombreTabla, filtro)) {
                                this.move(nombreTabla, this.getGestorTablas().getPosicionRecorriendoTabla(nombreTabla, filtro));
                            }
                            if (tratar && hayDatosEnTablas != 2 && this.obtenerClaveActiva(nombreTabla) > 0L) {
                                hayDatosEnTablas = 2;
                            }
                            this.estudiarCasosEspeciales(nombreTabla, propCampos, this.getGestorTablas());
                        } else if (propCampos.get("ULTIMOCAMPO") != null) {
                            nombreTabla = this.getNombreTablaActual();
                            if (this.getGestorTablas().esTablaAcabada(nombreTabla, filtro) || this.getSesion() != null && this.obtenerClaveActiva(nombreTabla) < 1L) {
                                tratar = false;
                            }
                        }
                        if (!tratar) {
                            te = new TablaMotorEntrada(((ITipoDatosCampos)camposTransXML.get(j)).getNombreCampo().toUpperCase(), (String)this.getSesion().getOperaciones().obtenerValorPorDefectoPartida(this.dameNombrePartidaSinParentesis(((ITipoDatosCampos)camposTransXML.get(j)).getNombreCampo().toUpperCase()).toString()));
                            listaCamposBD.put(this.concatenaFiltroAEntrada(te.getNombreEntrada(), filtro), te);
                            te = null;
                            continue;
                        }
                        String partidaAObtener = ((ITipoDatosCampos)camposTransXML.get(j)).getNombreCampo().toUpperCase();
                        String valorPartida = "";
                        if (propCampos.get("VALOR") != null) {
                            partidaAObtener = propCampos.get("VALOR").toString().toUpperCase();
                        }
                        if (partidaAObtener.length() > 0) {
                            if (this.getSesion() != null) {
                                tcv = this.damePartida(partidaAObtener);
                                valorPartida = tcv.getValor();
                                tcv = null;
                            }
                            if (propCampos.get("LOCALIZADORUNICOCAMPO") != null) {
                                partidaAObtener = propCampos.get("LOCALIZADORUNICOCAMPO").toUpperCase();
                            }
                            if (propCampos.containsKey("TIPODATO") && propCampos.get("TIPODATO").toUpperCase().startsWith("ORDINALCASILLAS_")) {
                                String[] partidas = propCampos.get("TIPODATO").substring("ORDINALCASILLAS_".length()).toUpperCase().split(",");
                                for (int k = 0; k < partidas.length; ++k) {
                                    if (partidas[k].equalsIgnoreCase(partidaAObtener)) continue;
                                    String valor = "";
                                    valor = this.getSesion().getOperaciones().obtenerPartidaString(this.dameNombrePartidaSinParentesis(partidas[k]));
                                    valor = FuncionesUtiles.getFuncionesUtiles().html2Text(valor);
                                    te = new TablaMotorEntrada(partidas[k], valor);
                                    listaCamposBD.put(this.concatenaFiltroAEntrada(te.getNombreEntrada(), filtro), te);
                                    te = null;
                                }
                            }
                            valorPartida = FuncionesUtiles.getFuncionesUtiles().html2Text(valorPartida);
                            te = new TablaMotorEntrada(partidaAObtener, valorPartida);
                            listaCamposBD.put(this.concatenaFiltroAEntrada(te.getNombreEntrada(), filtro), te);
                            te = null;
                        }
                        if (propCampos.get("ULTIMOCAMPO") == null || !this.puedoHacerMoveNext(nombreTabla = this.getNombreTablaActual(), filtro, this.getGestorTablas())) continue;
                        l = 0L;
                        if (!this.isEndOfRecordSet(nombreTabla, filtro)) {
                            l = this.moveNext(nombreTabla, filtro);
                        }
                        if (l < 1L || this.getSesion().getOperaciones().getLocalizacion(nombreTabla) == this.getGestorTablas().getLocalizacionRecorriendoTabla(nombreTabla, filtro)) {
                            this.getGestorTablas().acaboTabla(nombreTabla, filtro);
                            continue;
                        }
                        this.getGestorTablas().recorriendoTabla(nombreTabla, filtro, new TipoDatosCampoValor(String.valueOf(l), this.getSesion().getOperaciones().getLocalizacion(nombreTabla)));
                    }
                    if (this.getFicheroLogPrivado().length() > 0) {
                        this.escribeLogPrivadoCabecera("TABLA " + parametrosTabla.get("LITERAL").toString());
                    }
                    String contenidoGenerado = null;
                    boolean hayDatos = false;
                    if (hayDatosEnTablas == 2 || parametrosTabla.containsKey("OBLIGATORIA") && !parametrosTabla.get("OBLIGATORIA").equalsIgnoreCase("no")) {
                        hayDatos = true;
                    } else if (this.tieneDatos(camposTransXML, listaCamposBD)) {
                        hayDatos = true;
                    }
                    if (hayDatos) {
                        contenidoGenerado = this.dameLinea(parametrosTabla, camposTransXML, listaCamposBD);
                    }
                    if (contenidoGenerado != null) {
                        lineaSalida = lineaSalida + contenidoGenerado;
                        listaCamposBD.clear();
                        if (parametrosTabla.get("LONGITUD") != null && FuncionesUtiles.getFuncionesUtiles().esNumerico(parametrosTabla.get("LONGITUD").toString())) {
                            int longitudRegistro = Integer.valueOf(parametrosTabla.get("LONGITUD").toString());
                            if (lineaSalida.length() != longitudRegistro) {
                                throw new ExceptionMotor("Tabla " + tablasEnGestor.get(i).getNombreTabla() + " no tiene la longitud esperada compruebe fichero Trans " + longitudRegistro + "!=" + lineaSalida.length());
                            }
                            while (lineaSalida.length() < longitudRegistro) {
                                lineaSalida = lineaSalida + " ";
                            }
                        }
                        if (parametrosTabla.get("PRECEDERPORSALTODELINEA") != null) {
                            lineaSalida = "\r\n" + lineaSalida;
                        }
                        boolean anniadirAlFinal = false;
                        if (parametrosTabla.containsKey("ANIDADA")) {
                            String rutaTabla = parametrosTabla.get("EQUIVALENCIA");
                            rutaTabla = rutaTabla.contains("/") ? "</" + rutaTabla.substring(rutaTabla.indexOf("/") + 1).replaceAll("/", "></") + ">" : "</" + rutaTabla + ">";
                            String cadenaFinal = this.dameCadenaIncrustadaEnSuSitio((String)aFinal.get(aFinal.size() - 2), lineaSalida, rutaTabla, false);
                            if (cadenaFinal.equalsIgnoreCase(lineaSalida)) {
                                anniadirAlFinal = true;
                            } else {
                                aFinal.remove(aFinal.size() - 2);
                                aFinal.add(aFinal.size() - 1, cadenaFinal);
                            }
                        } else {
                            anniadirAlFinal = true;
                        }
                        if (anniadirAlFinal) {
                            aFinal.add(lineaSalida);
                            aFinal.add("");
                        }
                    }
                    primeraPasada = false;
                } while (this.getGestorTablas().isRecorriendoTablas());
            }
            return aFinal;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + sNombreTabla + " linea " + lineaSalida);
        }
    }

    protected boolean profundidadActual(String nodo, String cadena) {
        Stack<String> pila = new Stack<String>();
        while (cadena.length() > 0) {
            int posF = cadena.indexOf("</");
            int posIni = cadena.indexOf("<");
            if (posF == -1 && posIni == -1) {
                return false;
            }
            if (posF == posIni) {
                pila.pop();
                cadena = cadena.substring(posF + cadena.substring(posF).indexOf(">") + 1);
                continue;
            }
            int posFin = cadena.indexOf(">");
            String cad = cadena.substring(posIni + 1, posFin).split(" ")[0];
            cadena = cadena.substring(posFin + 1);
            if (nodo.substring(1).equalsIgnoreCase(cad)) {
                return pila.isEmpty();
            }
            pila.push(cad);
        }
        return true;
    }

    protected String dameCadenaIncrustadaEnSuSitio(String cadenaPadre, String cadenaHija, String rutaTablaACrear, boolean noEstoyEnProfundidad) throws ExceptionMotor {
        try {
            int posPadre;
            boolean estoyEnLaProfundidadAdecuada;
            int pos = cadenaHija.lastIndexOf("</");
            if (pos == -1) {
                if (cadenaPadre.trim().length() == 0) {
                    return cadenaHija;
                }
                return cadenaHija + cadenaPadre;
            }
            int posFin = cadenaHija.substring(pos).indexOf(">");
            if (posFin == -1) {
                throw new ExceptionMotor("Error no esperado....");
            }
            posFin = pos + posFin + 1;
            String nodo = cadenaHija.substring(pos, posFin);
            String nodoApertura = "<" + cadenaHija.substring(pos + 2, posFin - 1);
            if (rutaTablaACrear != null) {
                if (rutaTablaACrear.startsWith(nodo)) {
                    if (rutaTablaACrear.substring(nodo.length()).split("</").length == 1) {
                        return cadenaPadre + cadenaHija;
                    }
                    rutaTablaACrear = rutaTablaACrear.substring(nodo.length());
                } else {
                    if (rutaTablaACrear.length() == 0) {
                        return cadenaPadre + cadenaHija;
                    }
                    if (rutaTablaACrear.startsWith(nodoApertura)) {
                        rutaTablaACrear = rutaTablaACrear.substring(rutaTablaACrear.indexOf(">") + 1);
                    }
                }
            }
            if (!(estoyEnLaProfundidadAdecuada = this.profundidadActual(nodoApertura, cadenaPadre)) || noEstoyEnProfundidad) {
                if (cadenaPadre.trim().length() > 0 && cadenaPadre.startsWith("<") && !cadenaPadre.startsWith("</")) {
                    if (!cadenaPadre.trim().startsWith(nodoApertura)) {
                        String nodoHermano = this.quitaAtributosANodo(cadenaPadre.substring(1, cadenaPadre.indexOf(">")));
                        String cadenaHermana = cadenaPadre.substring(0, cadenaPadre.indexOf("</" + nodoHermano + ">") + ("</" + nodoHermano + ">").length());
                        cadenaPadre = cadenaPadre.substring(cadenaHermana.length());
                        return cadenaHermana + this.dameCadenaIncrustadaEnSuSitio(cadenaPadre, cadenaHija, rutaTablaACrear, true);
                    }
                } else {
                    return cadenaPadre + cadenaHija;
                }
            }
            if ((posPadre = cadenaPadre.lastIndexOf(nodo)) == -1) {
                return cadenaPadre + cadenaHija;
            }
            if (cadenaHija.trim().startsWith(nodoApertura) && cadenaPadre.trim().startsWith(nodoApertura) && cadenaHija.trim().startsWith(nodoApertura + " ") && cadenaPadre.trim().startsWith(nodoApertura + ">")) {
                String iniNodo = cadenaHija.trim().substring(0, cadenaHija.trim().indexOf(">")) + ">";
                cadenaPadre = iniNodo + cadenaPadre.trim().substring(cadenaPadre.trim().indexOf(">") + 1);
                posPadre = cadenaPadre.lastIndexOf(nodo);
            }
            String remanenteHermanas = "";
            if (!cadenaPadre.startsWith(nodoApertura)) {
                ITipoDatosCampoValor ret = this.quitaHermanas(cadenaPadre, nodoApertura);
                if (ret == null) {
                    return cadenaPadre + cadenaHija;
                }
                remanenteHermanas = ret.getNombreCampo();
                cadenaPadre = ret.getValor();
                posPadre = cadenaPadre.lastIndexOf(nodo);
            }
            cadenaHija = cadenaHija.substring(cadenaHija.indexOf(">") + 1, pos);
            int posPadreIni = cadenaPadre.lastIndexOf(nodoApertura + " ");
            if (posPadreIni == -1 && (posPadreIni = cadenaPadre.lastIndexOf(nodoApertura + ">")) == -1) {
                throw new ExceptionMotor("Error no esperado.....");
            }
            int posFinPadre = posPadreIni + cadenaPadre.substring(posPadreIni).indexOf(">");
            if (posFinPadre == -1) {
                throw new ExceptionMotor("Error no esperado......");
            }
            String cadenaPendiente = remanenteHermanas + cadenaPadre.substring(0, posPadreIni);
            String inicioCadenaPadre = cadenaPadre.substring(posPadreIni, ++posFinPadre);
            String finCadenaPadre = cadenaPadre.substring(posPadre);
            cadenaPadre = cadenaPadre.substring(posFinPadre, posPadre);
            return cadenaPendiente + inicioCadenaPadre + this.dameCadenaIncrustadaEnSuSitio(cadenaPadre, cadenaHija, rutaTablaACrear, false) + finCadenaPadre;
        }
        catch (ExceptionMotor e) {
            throw e;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected ITipoDatosCampoValor quitaHermanas(String cadena, String nodoDeseado) throws ExceptionMotor {
        try {
            int finNodo;
            TipoDatosCampoValor ret = new TipoDatosCampoValor("", "");
            do {
                int iniNodo = cadena.indexOf(">");
                String nodo = cadena.substring(1, iniNodo + 1);
                finNodo = cadena.indexOf("</" + nodo) + nodo.length() + 2;
                ret.setNombreCampo(ret.getNombreCampo() + cadena.substring(0, finNodo));
            } while (!(cadena = cadena.substring(finNodo)).startsWith(nodoDeseado));
            ret.setValor(cadena);
            return ret;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected String quitaAtributosANodo(String nodo) throws ExceptionMotor {
        try {
            for (int i = 0; i < nodo.length(); ++i) {
                if (nodo.charAt(i) != ' ') continue;
                return nodo.substring(0, i) + ">";
            }
            return nodo;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected String quitarTablaPadreDeCadena(String cadena, String xPathPadre) throws ExceptionMotor {
        try {
            String ret = "";
            String tablaRaiz = ((IGestorTraduccionesXML)this.claseExportacionXML.getGestorTraduccionesXML()).getTablaRaiz().toUpperCase();
            if (xPathPadre.toUpperCase().startsWith(tablaRaiz + "/")) {
                xPathPadre = xPathPadre.substring(tablaRaiz.length() + 1);
            } else if (xPathPadre.toUpperCase().startsWith(tablaRaiz)) {
                xPathPadre = xPathPadre.substring(tablaRaiz.length());
            }
            String[] tablaPadre = xPathPadre.split("/");
            String[] cadenas = cadena.split(">");
            for (int i = 0; i < cadenas.length; ++i) {
                if (cadenas[i].equalsIgnoreCase("----borrar esta linea pq es del registro padre-----")) {
                    return ret;
                }
                if (tablaPadre.length > i && cadenas[i].trim().toUpperCase().endsWith("<" + tablaPadre[i].toUpperCase())) {
                    boolean encontrado = false;
                    for (int j = cadenas.length - i - 1; j > -1; --j) {
                        if (!cadenas[j].trim().toUpperCase().endsWith("</" + tablaPadre[i].toUpperCase())) continue;
                        cadenas[j] = "----borrar esta linea pq es del registro padre-----";
                        encontrado = true;
                        break;
                    }
                    if (encontrado) continue;
                    throw new ExceptionMotor("No encuentro final de tabla </" + tablaPadre[i].toUpperCase() + ">");
                }
                ret = cadenas[i].trim().contains("<") ? ret + cadenas[i] + ">" : ret + cadenas[i];
            }
            throw new ExceptionMotor("Error al intentar quitar padre de cadena " + cadena + " Padre " + tablaPadre);
        }
        catch (ExceptionMotor em) {
            throw em;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    protected boolean cumpleConFiltro(String filtro) throws ExceptionMotor {
        try {
            String[] filtros;
            for (String filter : filtros = filtro.split(";")) {
                String[] filt = filter.split("=");
                if (this.getSesion().getOperaciones().obtenerPartidaString(filt[0].trim()).equalsIgnoreCase(filt[1].trim())) continue;
                return false;
            }
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Filtro " + filtro);
        }
    }

    protected long moveComun(String nombreTabla, String filtro, long posActual) throws ExceptionMotor {
        try {
            while (posActual > 0L) {
                if (this.cumpleConFiltro(filtro)) {
                    return posActual;
                }
                if (!this.getSesion().getOperaciones().moveIfHasNext(nombreTabla)) break;
                posActual = this.getSesion().getOperaciones().obtenerClaveActiva(nombreTabla);
            }
            return 0L;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean puedoHacerMoveNext(String nombreTabla, String filtro, IGestorTablas gestorTablas) throws ExceptionMotor {
        boolean ret = true;
        List<String> relacionadas = null;
        try {
            if (!gestorTablas.isRecorriendoTablas()) {
                boolean bl = ret;
                return bl;
            }
            if (gestorTablas.recorriendoTablasCount() == 1 && gestorTablas.isRecorriendoTabla(nombreTabla, filtro)) {
                boolean bl = ret;
                return bl;
            }
            relacionadas = this.dameTablasHijasDe(nombreTabla);
            List<String> tablasRecorriendose = gestorTablas.dameListaTablasRecorriendose();
            for (String tabla : tablasRecorriendose) {
                if (tabla.equalsIgnoreCase(nombreTabla) || relacionadas == null || !relacionadas.contains(tabla)) continue;
                ret = false;
                break;
            }
            boolean bl = ret;
            return bl;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
        finally {
            if (ret) {
                ArrayList<String> elementosABorrar = new ArrayList<String>();
                relacionadas = this.dameTablasHijasDe(nombreTabla);
                if (relacionadas != null) {
                    List<String> tablasAcabadas = gestorTablas.dameListaTablasAcabadas();
                    for (String tabla : tablasAcabadas) {
                        if (!relacionadas.contains(tabla)) continue;
                        elementosABorrar.add(tabla);
                    }
                    while (elementosABorrar.size() > 0) {
                        gestorTablas.quitarAcaboTabla((String)elementosABorrar.get(0), filtro);
                        elementosABorrar.remove(0);
                    }
                    List<String> tablasEmpezadas = gestorTablas.dameListaTablasEmpezadas();
                    for (String tabla : tablasEmpezadas) {
                        if (!relacionadas.contains(tabla)) continue;
                        elementosABorrar.add(tabla);
                    }
                    while (elementosABorrar.size() > 0) {
                        gestorTablas.quitarComenzoTabla((String)elementosABorrar.get(0), filtro);
                        elementosABorrar.remove(0);
                    }
                }
            }
        }
    }

    @Override
    public long moveFirst(String nombreTabla, String filtro) throws ExceptionMotor {
        long ret = this.getSesion().getOperaciones().moveFirst(nombreTabla);
        if (filtro == null) {
            return ret;
        }
        return this.moveComun(nombreTabla, filtro, ret);
    }

    @Override
    public long moveNext(String nombreTabla, String filtro) throws ExceptionMotor {
        long ret = this.getSesion().getOperaciones().moveNext(nombreTabla);
        if (filtro == null) {
            return ret;
        }
        return this.moveComun(nombreTabla, filtro, ret);
    }

    @Override
    public long move(String nombreTabla, long pos) throws ExceptionMotor {
        return this.getSesion().getOperaciones().move(nombreTabla, pos);
    }

    @Override
    public long obtenerClaveActiva(String nombreTabla) throws ExceptionMotor {
        return this.getSesion().getOperaciones().obtenerClaveActiva(nombreTabla);
    }

    @Override
    public boolean isEndOfRecordSet(String nombreTabla, String filtro) throws ExceptionMotor {
        boolean usandoFreezer = false;
        try {
            if (filtro == null) {
                boolean bl = this.getSesion().getOperaciones().obtenerClaveActiva(nombreTabla) == this.getSesion().getOperaciones().recordCount(nombreTabla);
                return bl;
            }
            if (!this.getGestorTablas().isRecorriendoTabla(nombreTabla, filtro)) {
                boolean bl = true;
                return bl;
            }
            this.getSesion().freezeSesionSoloPosicion("generadorLineas" + this.toString());
            usandoFreezer = true;
            long posActual = this.getGestorTablas().getPosicionRecorriendoTabla(nombreTabla, filtro);
            long posSiguiente = this.moveNext(nombreTabla, filtro);
            boolean bl = posActual == posSiguiente || posSiguiente == 0L;
            return bl;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
        finally {
            if (usandoFreezer) {
                this.getSesion().unfreeze("generadorLineas" + this.toString());
            }
        }
    }

    @Override
    public void estudiarCasosEspeciales(String nombreTabla, Map<String, String> propCampos, IGestorTablas gestorTablas) throws ExceptionMotor {
    }

    @Override
    public List<String> dameTablasHijasDe(String nombreTabla) throws ExceptionMotor {
        try {
            IRegRelacionada rsTaRel;
            if (this.getCacheParaDameTablasHijasDe() == null) {
                this.setCacheParaDameTablasHijasDe(new HashMap<String, List<String>>());
            }
            if (this.getCacheParaDameTablasHijasDe().containsKey(nombreTabla)) {
                return this.getCacheParaDameTablasHijasDe().get(nombreTabla);
            }
            IGestorConfiguracion gestorConfiguracion = this.getSesion().getModelo().getGestorConfiguracion();
            if (gestorConfiguracion != null && (rsTaRel = gestorConfiguracion.getRelacionada(nombreTabla)) != null) {
                this.getCacheParaDameTablasHijasDe().put(nombreTabla, rsTaRel.getTablaRelacionada());
                return this.getCacheParaDameTablasHijasDe().get(nombreTabla);
            }
            this.getCacheParaDameTablasHijasDe().put(nombreTabla, null);
            return null;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public Map<String, String> getFromCache(String valor) throws ExceptionMotor {
        try {
            return this.getCacheGenerador().get(valor);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Valor " + valor);
        }
    }

    @Override
    public void setInCache(String valor, Map<String, String> dato) throws ExceptionMotor {
        try {
            if (this.getCacheGenerador().size() == this.getCacheGeneradorMAXCapacity()) {
                Set<String> claves = this.getCacheGenerador().keySet();
                Iterator<String> it = claves.iterator();
                this.getCacheGenerador().remove(it.next());
            }
            this.getCacheGenerador().put(valor, dato);
        }
        catch (Exception ex) {
            this.getCacheGenerador().clear();
            if (ex instanceof ExceptionMotor) {
                ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + "Valor " + valor);
                throw (ExceptionMotor)ex;
            }
            throw new ExceptionMotor(ex, "Valor " + valor);
        }
    }

    @Override
    public void setFicheroLogPrivado(String ficheroLogPrivado) {
        try {
            new File(ficheroLogPrivado).delete();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.setFw(new FileWriterAEAT(ficheroLogPrivado));
        }
        catch (Exception e) {
            this.ficheroLogPrivado = "";
            FuncionesUtiles.getFuncionesUtiles().muestraError(e);
            return;
        }
        this.ficheroLogPrivado = ficheroLogPrivado;
    }

    @Override
    public String getFicheroLogPrivado() {
        return this.ficheroLogPrivado;
    }

    @Override
    public void setClaseExportacionXML(IExportacionXML claseExportacionXML) {
        this.claseExportacionXML = claseExportacionXML;
    }

    @Override
    public IExportacionXML getClaseExportacionXML() {
        return this.claseExportacionXML;
    }

    @Override
    public int getCacheGeneradorMAXCapacity() {
        return 1000;
    }

    @Override
    public void setCacheGenerador(Map<String, Map<String, String>> cacheGenerador) {
        this.cacheGenerador = cacheGenerador;
    }

    @Override
    public Map<String, Map<String, String>> getCacheGenerador() {
        return this.cacheGenerador;
    }

    @Override
    public boolean isGenerarAuxiliar() {
        return this.generarAuxiliar;
    }

    @Override
    public void setNombreTablaActual(String nombreTablaActual) {
        this.nombreTablaActual = nombreTablaActual;
    }

    @Override
    public String getNombreTablaActual() {
        return this.nombreTablaActual;
    }

    @Override
    public void setFw(IFileWriterAEAT fw) {
        this.fw = fw;
    }

    @Override
    public IFileWriterAEAT getFw() {
        return this.fw;
    }

    @Override
    public void setCacheParaDameTablasHijasDe(Map<String, List<String>> cacheParaDameTablasHijasDe) {
        this.cacheParaDameTablasHijasDe = cacheParaDameTablasHijasDe;
    }

    @Override
    public Map<String, List<String>> getCacheParaDameTablasHijasDe() {
        return this.cacheParaDameTablasHijasDe;
    }

    @Override
    public INodoArbol getArbolDatos() throws ExceptionMotor {
        return this.claseExportacionXML.getArbolDatos();
    }

    @Override
    public ISesion getSesion() {
        return this.claseExportacionXML.getSesion();
    }
}

