/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.gestionFicheros.exportacionV2.xml;

import es.aeat.pftw.mtrc.gestionFicheros.IProcessEvents;
import es.aeat.pftw.mtrc.gestionFicheros.exportacionV2.Exportacion;
import es.aeat.pftw.mtrc.gestionFicheros.exportacionV2.xml.GeneradorLineas;
import es.aeat.pftw.mtrc.gestionFicheros.exportacionV2.xml.IExportacionXML;
import es.aeat.pftw.mtrc.gestionFicheros.exportacionV2.xml.IGeneradorLineas;
import es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.xml.IGestorTraduccionesXML;
import es.aeat.pftw.mtrc.motor.modelo.IModelo;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesionExtendida;
import es.aeat.pftw.mtrc.motor.modelo.sesion.tools.IGestionOperacionesExtendida;
import es.aeat.pftw.mtrc.tipos.ITipoDatosFicherosResultado;
import es.aeat.pftw.mtrc.tipos.TipoDatosFicherosBytesResultado;
import es.aeat.pftw.mtrc.tipos.TipoDatosFicherosResultado;
import es.aeat.pftw.mtrc.utilidades.ByteWriterAEAT;
import es.aeat.pftw.mtrc.utilidades.FileWriterAEAT;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.utilidades.IWriterAEAT;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.excepciones.ExceptionTamSuperado;
import es.aeat.pftw.mtrp.puente.ITablaMotorEntrada;
import es.aeat.pftw.mtrp.tipos.ITipoDatosAExportar;
import es.aeat.pftw.mtrp.tipos.ITipoDatosFicherosBytesResultado;
import es.aeat.pftw.mtrp.utilidades.INodoArbol;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ExportacionXML
extends Exportacion
implements IProcessEvents,
Serializable,
IExportacionXML {
    private static final long serialVersionUID = 1L;
    private IGestorTraduccionesXML gestorXML = null;
    private IWriterAEAT fw = null;
    private IWriterAEAT fwAuxiliar = null;
    private INodoArbol arbolMotor = null;
    private List<Object> listaFicheros = null;
    private List<Object> listaFicherosAuxiliares = null;
    private long contadorVolumenActual = 0L;
    private IGeneradorLineas lineGen = null;
    private boolean crlf = false;
    public static final String CHRTABULADO = " ";
    private String namespaces = "";
    private int modo = 0;

    @Override
    public IWriterAEAT getWriter(String nombre) throws ExceptionMotor {
        try {
            switch (this.modo) {
                case 0: {
                    return new FileWriterAEAT(nombre);
                }
                case 1: {
                    return new ByteWriterAEAT();
                }
            }
            throw new ExceptionMotor("No entiendo modo = " + this.modo);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (IOException e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            super.init(parametros);
            boolean generarAuxiliares = false;
            IModelo modelo = null;
            for (Object object : parametros) {
                if (object instanceof IModelo) {
                    modelo = (IModelo)object;
                    continue;
                }
                if (!(object instanceof Boolean)) continue;
                generarAuxiliares = (Boolean)object;
            }
            if (this.getSesion() != null && modelo == null) {
                this.arbolMotor = this.getArbolDatos();
                modelo = this.getSesion().getModelo();
            }
            this.gestorXML = (IGestorTraduccionesXML)this.getGestorFichero().getGestorTraducciones();
            if (this.gestorXML == null && modelo != null) {
                this.gestorXML = modelo.getGestorTraduccionesXML(this.getSesion());
            }
            if (this.gestorXML == null) {
                String clase = "es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.xml.GestorTraduccionesXML";
                this.gestorXML = (IGestorTraduccionesXML)FuncionesUtiles.getFuncionesUtiles().getInstancia(clase, new Object[]{modelo});
                if (this.gestorXML.cargarEstructura(this.getGestorFichero().getFicheroGestorTraducciones())) {
                    this.getGestorFichero().setGestorTraducciones(this.gestorXML);
                } else {
                    this.gestorXML = null;
                    throw new ExceptionMotor("Imposible abrir GestorTraducciones");
                }
            }
            this.setLineGen((IGeneradorLineas)FuncionesUtiles.getFuncionesUtiles().getInstancia(GeneradorLineas.class, new Object[]{this}));
            this.getLineGen().setGenerarAuxiliar(generarAuxiliares);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Object getGestorTraduccionesXML() {
        return this.getGestorXML();
    }

    @Override
    public void setGestorTraduccionesXML(Object g) {
        this.setGestorXML((IGestorTraduccionesXML)g);
    }

    @Override
    public void setCrLf(boolean habilitar) {
        this.crlf = habilitar;
    }

    @Override
    public boolean getCrLf() {
        return this.crlf;
    }

    @Override
    public void dispose() throws ExceptionMotor {
        super.dispose();
        if (this.getLineGen() != null) {
            this.getLineGen().dispose();
            this.lineGen = null;
        }
        if (this.listaFicheros != null) {
            this.listaFicheros.clear();
        }
        if (this.listaFicherosAuxiliares != null) {
            this.listaFicherosAuxiliares.clear();
        }
        this.arbolMotor = null;
        if (this.gestorXML != null) {
            this.gestorXML.dispose();
            this.gestorXML = null;
        }
    }

    @Override
    public boolean exportaRegistro(String nombreTabla, Map<String, ITablaMotorEntrada> registro) throws ExceptionMotor {
        try {
            if (this.isFueCancelado()) {
                return false;
            }
            List<String> lineas = this.getLineGen().generaLinea(nombreTabla, registro);
            if (lineas == null || lineas.size() == 0) {
                return false;
            }
            String cadena = "";
            for (int numlineas = 0; numlineas < lineas.size(); numlineas += 2) {
                cadena = lineas.get(numlineas).toString();
                this.contadorVolumenActual += (long)cadena.length();
                if (this.getGestorFichero().superaMaxFicheros(this.contadorVolumenActual)) {
                    throw new ExceptionTamSuperado();
                }
                if (this.getTamVolumenes() > 0L && this.contadorVolumenActual > this.getTamVolumenes()) {
                    this.contadorVolumenActual = cadena.length();
                    this.guardaBytes(this.fw);
                    String nombreFichero = "";
                    if (this.modo == 0) {
                        nombreFichero = this.getFicheroTemporal();
                        if (nombreFichero.length() == 0) {
                            throw new ExceptionMotor("Imposible generar " + nombreFichero + " compruebe la ruta o la protecci\u00f3n contra escritura");
                        }
                        this.listaFicheros.add(nombreFichero);
                    }
                    this.fw = this.getWriter(nombreFichero);
                }
                if (this.crlf) {
                    this.fw.writeln(cadena);
                    continue;
                }
                this.fw.write(cadena);
            }
            this.getGestorFichero().fireProgressEvent(1);
            return this.exportaRegistroHIJOS(nombreTabla);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public boolean exportaRegistroHIJOS(String nombreTabla) throws ExceptionMotor {
        try {
            return true;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public void cancelar() {
        this.setFueCancelado(true);
    }

    @Override
    public void setFicheroLogPrivado(String ficheroLogPrivado) {
        this.getLineGen().setFicheroLogPrivado(ficheroLogPrivado);
    }

    @Override
    public String getFicheroLogPrivado() {
        return this.getLineGen().getFicheroLogPrivado();
    }

    @Override
    public void setLineGen(IGeneradorLineas lineGen) throws ExceptionMotor {
        this.lineGen = lineGen;
    }

    @Override
    public IGeneradorLineas getLineGen() {
        return this.lineGen;
    }

    @Override
    public void setGestorXML(IGestorTraduccionesXML gestorXML) {
        this.gestorXML = gestorXML;
    }

    @Override
    public IGestorTraduccionesXML getGestorXML() {
        return this.gestorXML;
    }

    @Override
    public void setArbolMotor(INodoArbol arbolMotor) {
        this.arbolMotor = arbolMotor;
    }

    @Override
    public INodoArbol getArbolDatos() throws ExceptionMotor {
        if (this.arbolMotor == null) {
            if (this.getSesion() != null) {
                this.arbolMotor = this.getSesion().getOperaciones().getArbolDatos();
            } else {
                throw new ExceptionMotor("Imposible crear arbol del motor");
            }
        }
        return this.arbolMotor;
    }

    @Override
    public void setSesion(ISesion sesion) throws ExceptionMotor {
        try {
            super.setSesion(sesion);
            this.setGestorFichero(sesion.getGestorFicheros(sesion.getEntradaTransOpciones()));
            this.setGestorXML(sesion.getModelo().getGestorTraduccionesXML(sesion));
            if (this.getGestorFichero() != null) {
                this.getGestorFichero().setGestorTraducciones(sesion.getModelo().getGestorTraduccionesXML(sesion));
            }
            this.setPosicionSello(((ISesionExtendida)sesion).getPosicionSello());
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void guardaBytes(IWriterAEAT f) throws ExceptionMotor, IOException {
        switch (this.modo) {
            case 0: {
                f.close();
                break;
            }
            case 1: {
                this.listaFicheros.add(((ByteWriterAEAT)f).getBytes());
                break;
            }
            default: {
                throw new ExceptionMotor("No entiendo modo " + this.modo);
            }
        }
    }

    @Override
    public boolean exportaCOMUN(List<ITipoDatosAExportar> listaRegistrosExportar) throws ExceptionMotor {
        boolean flagIgnorarRegistrosDeEstadosAnterior = false;
        boolean flagTablaIdInfCacheHabilitada = false;
        boolean cacheOrigenDatosAnterior = this.getSesion().getOrigenDeDatos().isCacheHabilitada();
        try {
            String cadena;
            this.getSesion().getOrigenDeDatos().setCacheHabilitada(true);
            flagIgnorarRegistrosDeEstadosAnterior = ((IGestionOperacionesExtendida)this.getSesion().getOperaciones()).getIgnorarRegistrosDeEstados();
            flagTablaIdInfCacheHabilitada = ((IGestionOperacionesExtendida)this.getSesion().getOperaciones()).getTablaIdInfCacheHabilitada();
            this.setFueCancelado(false);
            this.contadorVolumenActual = 0L;
            this.listaFicheros = new ArrayList<Object>();
            this.listaFicherosAuxiliares = new ArrayList<Object>();
            String nombreFichero = "";
            if (this.modo == 0) {
                nombreFichero = this.getFicheroTemporal();
                if (nombreFichero.length() == 0) {
                    throw new ExceptionMotor("Imposible generar " + nombreFichero + " compruebe la ruta o la protecci\u00f3n contra escritura");
                }
                this.listaFicheros.add(nombreFichero);
            }
            this.getGestorFichero().fireProgressEvent(0, this.calcularPasosExportacion(listaRegistrosExportar));
            boolean ret = true;
            int i = 0;
            Map<String, String> listaXmlNS = this.getGestorXML().getListaXmlNS();
            if (listaXmlNS.size() > 0) {
                for (String nombre : listaXmlNS.keySet()) {
                    if (nombre.equalsIgnoreCase("CASO_ESPECIAL_NAMESPACES")) {
                        this.namespaces = this.namespaces + CHRTABULADO + listaXmlNS.get(nombre);
                        continue;
                    }
                    this.namespaces = this.namespaces + " xmlns:" + nombre + "=\"" + listaXmlNS.get(nombre) + "\"";
                }
            }
            this.fw = this.getWriter(nombreFichero);
            this.fw.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"yes\" ?>");
            String sello = "";
            if (((IGestorTraduccionesXML)this.getGestorTraduccionesXML()).getListadoAtributosTransXXX().containsKey("SELLO")) {
                sello = " SELLO=\"             \"";
            }
            if (this.getGestorXML().getNodoNamespaces().length() == 0 || this.getGestorXML().getNodoNamespaces().equalsIgnoreCase(((IGestorTraduccionesXML)this.getGestorTraduccionesXML()).getTablaRaiz())) {
                this.fw.write("<" + ((IGestorTraduccionesXML)this.getGestorTraduccionesXML()).getTablaRaiz() + this.namespaces + sello + ">");
            } else {
                this.fw.write("<" + ((IGestorTraduccionesXML)this.getGestorTraduccionesXML()).getTablaRaiz() + sello + ">");
            }
            this.getSesion().freezeSesionSoloPosicion();
            ((IGestionOperacionesExtendida)this.getSesion().getOperaciones()).setIgnorarRegistrosDeEstados(true);
            ((IGestionOperacionesExtendida)this.getSesion().getOperaciones()).setTablaIdInfCacheHabilitada(true);
            for (i = 0; i < listaRegistrosExportar.size(); ++i) {
                if (listaRegistrosExportar.get(i).getId() > 0L && this.getSesion().getOperaciones().move(listaRegistrosExportar.get(i).getTabla(), listaRegistrosExportar.get(i).getId()) == -1L) {
                    ret = false;
                    break;
                }
                boolean bl = ret = ret && this.exportaRegistro(listaRegistrosExportar.get(i).getTabla(), this.getSesion().getOperaciones().obtenerRegistroDatosTabla(listaRegistrosExportar.get(i).getTabla()));
                if (!ret) break;
            }
            ((IGestionOperacionesExtendida)this.getSesion().getOperaciones()).setIgnorarRegistrosDeEstados(flagIgnorarRegistrosDeEstadosAnterior);
            ((IGestionOperacionesExtendida)this.getSesion().getOperaciones()).setTablaIdInfCacheHabilitada(flagTablaIdInfCacheHabilitada);
            this.eventoAntesDeGuardarDatos(this.fw);
            this.fw.write("</" + ((IGestorTraduccionesXML)this.getGestorTraduccionesXML()).getTablaRaiz() + ">");
            if (this.getGestorXML().getNodoNamespaces().length() > 0 && !this.getGestorXML().getNodoNamespaces().equalsIgnoreCase(((IGestorTraduccionesXML)this.getGestorTraduccionesXML()).getTablaRaiz())) {
                cadena = this.fw.toString();
                int pos = cadena.indexOf(this.getGestorXML().getNodoNamespaces());
                if (pos == -1) {
                    throw new ExceptionMotor("Error al incrustar los namespaces!!!");
                }
                cadena = cadena.substring(0, pos + this.getGestorXML().getNodoNamespaces().length()) + this.namespaces + cadena.substring(pos + this.getGestorXML().getNodoNamespaces().length());
                this.fw.sobreEscribirContenido(cadena);
            }
            if (sello.length() > 0) {
                cadena = this.fw.toString();
                int posSello = cadena.indexOf("SELLO=\"");
                if (posSello == -1) {
                    throw new ExceptionMotor("Error al buscar posicion del sello!!!");
                }
                String s = FuncionesUtiles.getFuncionesUtiles().selloPos(cadena.getBytes(), posSello += "SELLO=\"".length(), ' ');
                cadena = cadena.substring(0, posSello) + s + cadena.substring(posSello + 13);
                this.fw.sobreEscribirContenido(cadena);
            }
            this.guardaBytes(this.fw);
            if (this.listaFicheros != null && this.listaFicheros.size() > 0 && this.getPosicionSello() > -1) {
                block28: for (i = 0; i < this.listaFicheros.size(); ++i) {
                    switch (this.modo) {
                        case 0: {
                            FuncionesUtiles.getFuncionesUtiles().selloPos(this.listaFicheros.get(i).toString(), this.getPosicionSello(), this.getCaracterFinalSello());
                            continue block28;
                        }
                        case 1: {
                            FuncionesUtiles.getFuncionesUtiles().selloPos((byte[])this.listaFicheros.get(i), this.getPosicionSello(), this.getCaracterFinalSello());
                            continue block28;
                        }
                        default: {
                            throw new Exception("Modo de generacion de ficheros no definido!!!");
                        }
                    }
                }
            }
            if (this.fwAuxiliar != null) {
                this.guardaBytes(this.fwAuxiliar);
            }
            this.getSesion().unfreeze();
            boolean bl = ret;
            return bl;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
        finally {
            this.getSesion().getOrigenDeDatos().setCacheHabilitada(cacheOrigenDatosAnterior);
            try {
                ((IGestionOperacionesExtendida)this.getSesion().getOperaciones()).setIgnorarRegistrosDeEstados(flagIgnorarRegistrosDeEstadosAnterior);
            }
            catch (Exception e) {}
            try {
                ((IGestionOperacionesExtendida)this.getSesion().getOperaciones()).setTablaIdInfCacheHabilitada(flagTablaIdInfCacheHabilitada);
            }
            catch (Exception e) {}
            if (this.getSesion().isFreezed()) {
                this.getSesion().unfreeze();
            }
            if (this.fw != null) {
                try {
                    this.fw.close();
                }
                catch (IOException e) {}
            }
            if (this.fwAuxiliar != null) {
                try {
                    this.fwAuxiliar.close();
                }
                catch (IOException e) {}
            }
            this.fwAuxiliar = null;
            this.fw = null;
        }
    }

    @Override
    public void eventoAntesDeGuardarDatos(IWriterAEAT fw) throws ExceptionMotor {
    }

    @Override
    public ITipoDatosFicherosResultado exporta(List<ITipoDatosAExportar> listaRegistrosExportar) throws ExceptionMotor {
        try {
            this.modo = 0;
            boolean ret = this.exportaCOMUN(listaRegistrosExportar);
            if (!ret) {
                int i;
                File fl = null;
                for (i = 0; i < this.listaFicheros.size(); ++i) {
                    fl = new File(this.listaFicheros.get(i).toString());
                    fl.delete();
                    fl = null;
                }
                this.listaFicheros.clear();
                for (i = 0; i < this.listaFicherosAuxiliares.size(); ++i) {
                    fl = new File(this.listaFicherosAuxiliares.get(i).toString());
                    fl.delete();
                    fl = null;
                }
                this.listaFicherosAuxiliares.clear();
                Object var3_5 = null;
            }
            return new TipoDatosFicherosResultado(this.listaFicheros, this.listaFicherosAuxiliares);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public ITipoDatosFicherosBytesResultado exportaBytes(List<ITipoDatosAExportar> listaRegistrosExportar) throws ExceptionMotor {
        try {
            this.modo = 1;
            this.getLineGen().clearMem();
            this.exportaCOMUN(listaRegistrosExportar);
            this.getLineGen().clearMem();
            return new TipoDatosFicherosBytesResultado(this.listaFicheros, this.listaFicherosAuxiliares);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }
}

