/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.gestionFicheros.exportacionV2;

import es.aeat.pftw.mtrc.gestionFicheros.IGestorFicheros;
import es.aeat.pftw.mtrc.gestionFicheros.exportacionV2.IExportacion;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.tipos.ITipoDatosFicherosResultado;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.tipos.ITipoDatosAExportar;
import es.aeat.pftw.mtrp.utilidades.INodoArbol;
import java.io.File;
import java.io.Serializable;
import java.util.List;

public abstract class Exportacion
implements IExportacion,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final int CTE_MIL = 1000;
    private long tamVolumenes = 0L;
    private int posicionSello = -1;
    private char caracterFinalSello = (char)77;
    private String rutaFichero = "";
    private transient ISesion sesion = null;
    private IGestorFicheros gestorFichero = null;
    private boolean fueCancelado = false;

    @Override
    public void dispose() throws ExceptionMotor {
        this.sesion = null;
    }

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            for (Object object : parametros) {
                if (!(object instanceof ISesion)) continue;
                this.sesion = (ISesion)object;
            }
            if (this.sesion == null) {
                throw new Exception("Falta pasar la sesion en el init!!!");
            }
            if (this.sesion != null && this.sesion.getModelo() != null) {
                this.gestorFichero = this.sesion.getGestorFicheros(this.sesion.getEntradaTransOpciones());
            }
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public String getFicheroTemporal() {
        try {
            File f = FuncionesUtiles.getFuncionesUtiles().creaArchivoTemporal("EXPT", ".Tmp");
            String nombreFichero = f.getAbsolutePath();
            f = null;
            if (!FuncionesUtiles.getFuncionesUtiles().ficheroEscribible(nombreFichero)) {
                return "";
            }
            return nombreFichero;
        }
        catch (Exception ex) {
            return "";
        }
    }

    @Override
    public boolean setPosicionSello(int posSello) {
        this.posicionSello = posSello;
        return true;
    }

    @Override
    public int getPosicionSello() {
        return this.posicionSello;
    }

    @Override
    public boolean setCaracterFinalSello(char chr) {
        this.caracterFinalSello = chr;
        return true;
    }

    @Override
    public char getCaracterFinalSello() {
        return this.caracterFinalSello;
    }

    @Override
    public boolean setTamVolumenes(long tamVol) {
        this.tamVolumenes = tamVol * 1000L;
        return true;
    }

    @Override
    public long getTamVolumenes() {
        return this.tamVolumenes / 1000L;
    }

    @Override
    public abstract ITipoDatosFicherosResultado exporta(List<ITipoDatosAExportar> var1) throws ExceptionMotor;

    @Override
    public int calculaPasosTabla(INodoArbol arbolMotor, String nombreTabla) {
        try {
            int ret = 0;
            INodoArbol n = arbolMotor.buscaHijo(nombreTabla);
            if (n.numeroHijos() == 0) {
                return (int)this.getSesion().getOperaciones().recordCount(nombreTabla);
            }
            long pos = this.getSesion().getOperaciones().obtenerClaveActiva(nombreTabla);
            long actual = this.getSesion().getOperaciones().moveFirst(nombreTabla);
            long anterior = 0L;
            long rc = this.getSesion().getOperaciones().recordCount(nombreTabla);
            while (anterior != actual) {
                ++ret;
                for (int j = 0; j < n.numeroHijos(); ++j) {
                    ret += this.calculaPasosTabla(arbolMotor, n.getHijo(j).getNombreNodo());
                }
                anterior = actual;
                if (actual == rc) break;
                actual = this.getSesion().getOperaciones().moveNext(nombreTabla);
            }
            this.getSesion().getOperaciones().move(nombreTabla, pos);
            return ret;
        }
        catch (Exception ex) {
            FuncionesUtiles.getFuncionesUtiles().muestraError(ex);
            return 0;
        }
    }

    @Override
    public int calcularPasosExportacion(List<ITipoDatosAExportar> listaRegistrosExportar) throws ExceptionMotor {
        try {
            int ret = 0;
            long pos = 0L;
            long posIni = 0L;
            INodoArbol arbolMotor = this.getSesion().getOperaciones().getArbolDatos();
            this.getSesion().freezeSesionSoloPosicion();
            for (int i = 0; i < listaRegistrosExportar.size(); ++i) {
                String nombreTabla = listaRegistrosExportar.get(i).getTabla();
                pos = this.getSesion().getOperaciones().obtenerClaveActiva(nombreTabla);
                posIni = listaRegistrosExportar.get(i).getId() - 1L;
                if (posIni > -1L) {
                    this.getSesion().getOperaciones().moveFirst(nombreTabla);
                    if (this.getSesion().getOperaciones().move(nombreTabla, posIni) == -1L) {
                        ret = 0;
                        this.getSesion().getOperaciones().move(nombreTabla, pos);
                        break;
                    }
                }
                ++ret;
                INodoArbol n = arbolMotor.buscaHijo(nombreTabla);
                for (int j = 0; j < n.numeroHijos(); ++j) {
                    ret += this.calculaPasosTabla(arbolMotor, n.getHijo(j).getNombreNodo());
                }
                this.getSesion().getOperaciones().move(nombreTabla, pos);
            }
            this.getSesion().unfreeze();
            return ret;
        }
        catch (Exception ex) {
            if (this.getSesion().isFreezed()) {
                this.getSesion().unfreeze();
            }
            if (ex instanceof ExceptionMotor) {
                throw (ExceptionMotor)ex;
            }
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void setRutaFichero(String rutaFichero) {
        this.rutaFichero = rutaFichero;
    }

    @Override
    public String getRutaFichero() {
        return this.rutaFichero;
    }

    @Override
    public void setGestorFichero(IGestorFicheros gestorFichero) {
        this.gestorFichero = gestorFichero;
    }

    @Override
    public IGestorFicheros getGestorFichero() {
        return this.gestorFichero;
    }

    @Override
    public void setFueCancelado(boolean fueCancelado) {
        this.fueCancelado = fueCancelado;
    }

    @Override
    public boolean isFueCancelado() {
        return this.fueCancelado;
    }

    @Override
    public ISesion getSesion() {
        return this.sesion;
    }

    @Override
    public void setSesion(ISesion sesion) throws ExceptionMotor {
        this.sesion = sesion;
    }
}

