/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.gestionFicheros.exportacion.boe;

import es.aeat.pftw.mtrc.IAop;
import es.aeat.pftw.mtrc.configuracion.IGestorConfiguracion;
import es.aeat.pftw.mtrc.gestionFicheros.exportacion.boe.ExportacionBOE;
import es.aeat.pftw.mtrc.gestionFicheros.exportacion.boe.IExportacionBOE;
import es.aeat.pftw.mtrc.gestionFicheros.exportacion.boe.IGeneradorLineas;
import es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.IGestorTraducciones;
import es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.boe.IGestorTraduccionesBOE;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.puente.TablaMotorEntrada;
import es.aeat.pftw.mtrc.tipos.ITipoDatosTabla;
import es.aeat.pftw.mtrc.tipos.TipoDatoRetornoMetodo;
import es.aeat.pftw.mtrc.tipos.TipoDatosCampoValor;
import es.aeat.pftw.mtrc.tipos.TipoDatosCampos;
import es.aeat.pftw.mtrc.utilidades.FileWriterAEAT;
import es.aeat.pftw.mtrc.utilidades.Formatear;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.utilidades.IFileWriterAEAT;
import es.aeat.pftw.mtrc.utilidades.StringUtility;
import es.aeat.pftw.mtrp.configuracion.IRegEntrada;
import es.aeat.pftw.mtrp.configuracion.IRegRelacionada;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.puente.ITablaMotorEntrada;
import es.aeat.pftw.mtrp.tipos.ITipoDatoRetornoMetodo;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampoValor;
import es.aeat.pftw.mtrp.tipos.ITipoDatosCampos;
import es.aeat.pftw.mtrp.utilidades.GestorTablas;
import es.aeat.pftw.mtrp.utilidades.IGestorTablas;
import es.aeat.pftw.mtrp.utilidades.INodoArbol;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class GeneradorLineas
implements IAop,
Serializable,
IGeneradorLineas {
    private static final long serialVersionUID = 1L;
    private IExportacionBOE claseExportacionBOE = null;
    private static final int CACHE_GENERADOR_MAX_CAPACITY = 1000;
    private Map<String, Map<String, String>> cacheGenerador = null;
    private boolean generarAuxiliar = true;
    private String nombreTablaActual = "";
    private String ficheroLogPrivado = "";
    private IFileWriterAEAT fw = null;
    private Map<String, List<String>> cacheParaDameTablasHijasDe = null;
    private transient IGestorTablas gestorTablas = null;

    @Override
    public void dispose() throws ExceptionMotor {
        this.claseExportacionBOE = null;
        this.cacheGenerador = null;
        this.fw = null;
        this.cacheParaDameTablasHijasDe = null;
        this.gestorTablas.init();
        this.gestorTablas = null;
    }

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            this.claseExportacionBOE = (ExportacionBOE)parametros[0];
            this.cacheGenerador = new HashMap<String, Map<String, String>>();
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void clearMem() {
        try {
            this.cacheGenerador.clear();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.gestorTablas.init();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.cacheParaDameTablasHijasDe.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public IGestorTablas getGestorTablas() throws ExceptionMotor {
        if (this.gestorTablas == null) {
            this.gestorTablas = new GestorTablas(this.getArbolDatos());
        }
        return this.gestorTablas;
    }

    @Override
    public void setGenerarAuxiliar(boolean bol) {
        this.generarAuxiliar = bol;
    }

    @Override
    public boolean getGenerarAuxiliar() {
        return this.isGenerarAuxiliar();
    }

    @Override
    public boolean setGestorTraducciones(IGestorTraduccionesBOE g) throws ExceptionMotor {
        try {
            this.getClaseExportacionBOE().setGestorTraduccionesBOE(g);
            return true;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public String eliminaNotacionExponencial(String num, int numDecimales) {
        String numero = num;
        numero = numero.replace('.', ',');
        Locale esp = new Locale("es", "ES");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(esp);
        DecimalFormat df = null;
        String formatear = "#0";
        for (int i = 1; i <= numDecimales; ++i) {
            if (i == 1) {
                formatear = formatear + ".";
            }
            formatear = formatear + "0";
        }
        df = new DecimalFormat(formatear, dfs);
        try {
            numero = df.format(df.parse(numero));
        }
        catch (Exception e) {
            numero = "";
        }
        numero = numero.replace(',', '.');
        return numero;
    }

    @Override
    public String formateaNumero(String val, int longitudTotal, int numDecimales) throws ExceptionMotor {
        ITipoDatoRetornoMetodo ret;
        if (this.getSesion().getModelo() != null && this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo().formateaNumero(this, val, longitudTotal, numDecimales)).isRetornaResultado()) {
            return ret.getObjetoRetornoAsString();
        }
        return this.formateaNumeroRecursivo(val, longitudTotal, numDecimales).getObjetoRetornoAsString();
    }

    @Override
    public ITipoDatoRetornoMetodo formateaNumeroRecursivo(String val, int longitudTotal, int numDecimales) throws ExceptionMotor {
        try {
            int i = 0;
            String valor = val;
            String resultado = "";
            String parteEntera = "";
            String parteDecimal = "";
            valor = this.eliminaNotacionExponencial(valor, numDecimales);
            int posPunto = valor.indexOf(46);
            if (posPunto > 0) {
                parteEntera = valor.substring(0, posPunto);
                parteDecimal = valor.substring(posPunto + 1);
                if (parteDecimal.length() > numDecimales) {
                    parteDecimal = parteDecimal.substring(0, numDecimales);
                }
            } else {
                parteEntera = valor;
            }
            for (i = 0; i < longitudTotal - numDecimales - parteEntera.length(); ++i) {
                resultado = "0" + resultado;
            }
            resultado = resultado + parteEntera;
            if (numDecimales > 0) {
                resultado = resultado + parteDecimal;
                for (i = 0; i < numDecimales - parteDecimal.length(); ++i) {
                    resultado = resultado + "0";
                }
            }
            return new TipoDatoRetornoMetodo(resultado);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Valor " + val + " long " + longitudTotal + " decimales " + numDecimales);
        }
    }

    @Override
    public String dameCampo(String nombreTabla, String nombreCampo, String valor) throws ExceptionMotor {
        ITipoDatoRetornoMetodo ret;
        if (this.getSesion().getModelo() != null && this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo().dameCampo(this, nombreTabla, nombreCampo, valor)).isRetornaResultado()) {
            return ret.getObjetoRetornoAsString();
        }
        return this.dameCampoRecursiva(nombreTabla, nombreCampo, valor).getObjetoRetornoAsString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ITipoDatoRetornoMetodo dameCampoRecursiva(String nombreTabla, String nombreCampo, String valor) throws ExceptionMotor {
        List<ITipoDatosCampos> camposTransBOE = null;
        List<ITipoDatosTabla> tablasEnGestor = null;
        HashMap<String, ITablaMotorEntrada> listaCamposBD = null;
        try {
            try {
                listaCamposBD = new HashMap<String, ITablaMotorEntrada>();
                TablaMotorEntrada te = new TablaMotorEntrada(nombreCampo, valor);
                listaCamposBD.put(te.getNombreEntrada(), te);
                te = null;
                int iteradorColeccionesDeTablas = 0;
                block9: while (true) {
                    if (iteradorColeccionesDeTablas >= 2) {
                        throw new ExceptionMotor("Imposible encontrar campo " + nombreCampo + " de tabla " + nombreTabla);
                    }
                    switch (iteradorColeccionesDeTablas) {
                        case 0: {
                            tablasEnGestor = ((IGestorTraduccionesBOE)this.getClaseExportacionBOE().getGestorTraduccionesBOE()).getTablas();
                            break;
                        }
                        case 1: {
                            tablasEnGestor = ((IGestorTraduccionesBOE)this.getClaseExportacionBOE().getGestorTraduccionesBOE()).getTablasAuxiliares();
                            break;
                        }
                        default: {
                            throw new ExceptionMotor("Imposible encontrar campo " + nombreCampo + " de tabla " + nombreTabla);
                        }
                    }
                    int i = 0;
                    while (true) {
                        block14: {
                            block15: {
                                block13: {
                                    if (i >= tablasEnGestor.size()) break block13;
                                    if (!tablasEnGestor.get(i).getNombreTabla().equalsIgnoreCase(nombreTabla)) break block14;
                                    camposTransBOE = tablasEnGestor.get(i).getCampos();
                                    break block15;
                                }
                                ++iteradorColeccionesDeTablas;
                                continue block9;
                            }
                            for (int j = 0; j < camposTransBOE.size(); ++j) {
                                if (!nombreCampo.equalsIgnoreCase(camposTransBOE.get(j).getNombreCampo())) continue;
                                return new TipoDatoRetornoMetodo(this.dameCampo(camposTransBOE.get(j), listaCamposBD));
                            }
                        }
                        ++i;
                    }
                    break;
                }
            }
            catch (ExceptionMotor ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ExceptionMotor(ex, "Campo " + nombreCampo + " de tabla " + nombreTabla);
            }
        }
        catch (Throwable throwable) {
            camposTransBOE = null;
            tablasEnGestor = null;
            listaCamposBD = null;
            throw throwable;
        }
    }

    @Override
    public String dameCampo(ITipoDatosCampos campoTransBOE, Map<String, ITablaMotorEntrada> listaCamposBD) throws ExceptionMotor {
        ITipoDatoRetornoMetodo ret;
        if (this.getSesion().getModelo() != null && this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo().dameCampo(this, campoTransBOE, listaCamposBD)).isRetornaResultado()) {
            return ret.getObjetoRetornoAsString();
        }
        return this.dameCampoRecursiva(campoTransBOE, listaCamposBD).getObjetoRetornoAsString();
    }

    @Override
    public ITipoDatoRetornoMetodo dameCampoRecursiva(ITipoDatosCampos campoTransBOE, Map<String, ITablaMotorEntrada> listaCamposBD) throws ExceptionMotor {
        Map<String, String> propiedades = null;
        String nombreCampoOriginal = campoTransBOE.getNombreCampo();
        try {
            String valorBD = "";
            String tipoDato = "";
            String valorAux = "";
            String valor = "";
            String filtro = "";
            String nombreCampo = FuncionesUtiles.getFuncionesUtiles().dameNombrePartidaSinParentesis(nombreCampoOriginal);
            propiedades = FuncionesUtiles.getFuncionesUtiles().traducirTipoCampo(campoTransBOE.getPropiedadesCampos(), (IGestorTraduccionesBOE)this.getClaseExportacionBOE().getGestorTraduccionesBOE(), listaCamposBD);
            if (propiedades.containsKey("NOEXPORTAR")) {
                TipoDatoRetornoMetodo tipoDatoRetornoMetodo = new TipoDatoRetornoMetodo("");
                return tipoDatoRetornoMetodo;
            }
            if (nombreCampo.length() == 0 && propiedades.containsKey("VALOR")) {
                nombreCampo = propiedades.get("VALOR");
            }
            tipoDato = propiedades.get("TIPODATO").toString();
            valorBD = propiedades.get("SUSTITUCION").toString();
            propiedades.remove("SUSTITUCION");
            int numDecimales = 0;
            if (propiedades.get("DECIMALES") != null) {
                try {
                    numDecimales = Integer.valueOf(propiedades.get("DECIMALES").toString());
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (valorBD.length() == 0 && !tipoDato.startsWith("CTE:")) {
                try {
                    filtro = propiedades.get("FILTRO");
                    valorBD = FuncionesUtiles.getFuncionesUtiles().sacaDeListaEx(listaCamposBD, nombreCampo, nombreCampoOriginal, nombreCampo + "[" + filtro + "]", nombreCampoOriginal + "[" + filtro + "]").getValor().toString();
                }
                catch (Exception ex) {
                    valorBD = "";
                }
            }
            int longitud = Integer.valueOf(propiedades.get("LONGITUD").toString());
            TipoDatoRetornoMetodo tipoDatoRetornoMetodo = new TipoDatoRetornoMetodo(this.dameCampoEx(tipoDato, valorBD, longitud, numDecimales, valorAux, nombreCampoOriginal, listaCamposBD, valor, campoTransBOE, propiedades));
            return tipoDatoRetornoMetodo;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Campo " + nombreCampoOriginal);
        }
        finally {
            propiedades = null;
        }
    }

    @Override
    public String dameCampoEx(String tipoDato, String valorBD, int longitud, int numDecimales, String valorAux, String nomCampo, Map<String, ITablaMotorEntrada> listaCamposBD, String valor, ITipoDatosCampos campoTransBOE, Map<String, String> propiedades) throws ExceptionMotor {
        ITipoDatoRetornoMetodo ret;
        if (this.getSesion().getModelo() != null && this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo().dameCampoEx(this, tipoDato, valorBD, longitud, numDecimales, valorAux, nomCampo, listaCamposBD, valor, campoTransBOE, propiedades)).isRetornaResultado()) {
            return ret.getObjetoRetornoAsString();
        }
        return this.dameCampoExRecursiva(tipoDato, valorBD, longitud, numDecimales, valorAux, nomCampo, listaCamposBD, valor, campoTransBOE, propiedades).getObjetoRetornoAsString();
    }

    @Override
    public ITipoDatoRetornoMetodo dameCampoExRecursiva(String tipoDato, String valorBD, int longitud, int numDecimales, String valorAux, String nomCampo, Map<String, ITablaMotorEntrada> listaCamposBD, String valor, ITipoDatosCampos campoTransBOE, Map<String, String> propiedades) throws ExceptionMotor {
        try {
            String nombreCampo = FuncionesUtiles.getFuncionesUtiles().dameNombrePartidaSinParentesis(nomCampo);
            if (tipoDato.equalsIgnoreCase("Num")) {
                if (valorBD.length() == 0) {
                    valorBD = FuncionesUtiles.getFuncionesUtiles().rellena(valorBD, '0', longitud);
                }
                valorBD = Formatear.getFormatear().redondea(new BigDecimal(valorBD.trim()), (Object)numDecimales).toString();
                return new TipoDatoRetornoMetodo(this.formateaNumero(valorBD, longitud, numDecimales));
            }
            if (tipoDato.equalsIgnoreCase("NumSigno")) {
                String lineaSalida = "";
                valorBD = Formatear.getFormatear().redondea(new BigDecimal(valorBD.trim()), (Object)numDecimales).toString();
                valorAux = valorBD;
                if (valorAux.length() == 0) {
                    valorAux = FuncionesUtiles.getFuncionesUtiles().rellena(valorAux, '0', longitud);
                }
                if (valorAux.charAt(0) == '-') {
                    valorAux = valorAux.substring(1);
                    lineaSalida = "N";
                } else if (this.longitudNumeroSinPuntosetc(valorAux) < longitud) {
                    lineaSalida = ((IGestorTraducciones)this.getClaseExportacionBOE().getGestorTraduccionesBOE()).isEsNumeroPositivoCon0() ? "0" : " ";
                }
                return new TipoDatoRetornoMetodo(lineaSalida + this.formateaNumero(valorAux, longitud - 1, numDecimales));
            }
            if (tipoDato.equalsIgnoreCase("CADNUM") || tipoDato.equalsIgnoreCase("CADNUM2")) {
                if (valorBD.length() != longitud) {
                    valorBD = FuncionesUtiles.getFuncionesUtiles().rellena(valorBD, '0', longitud, true);
                }
                return new TipoDatoRetornoMetodo(valorBD);
            }
            if (tipoDato.equalsIgnoreCase("Nif")) {
                if (valorBD.length() != longitud) {
                    valorBD = FuncionesUtiles.getFuncionesUtiles().rellena(valorBD, ' ', longitud);
                }
                return new TipoDatoRetornoMetodo(valorBD);
            }
            if (tipoDato.equalsIgnoreCase("FECHA_SIN_FORMATO")) {
                valor = FuncionesUtiles.getFuncionesUtiles().sacaDeLista(listaCamposBD, nombreCampo, nomCampo).getValor().toString();
                return new TipoDatoRetornoMetodo(this.formateaFecha(valor));
            }
            if (tipoDato.equalsIgnoreCase("FechaInvertida")) {
                longitud = 8;
                if ((valorBD = valorBD.replaceAll("-", "").replaceAll("/", "")).length() != longitud) {
                    valorBD = FuncionesUtiles.getFuncionesUtiles().rellena(valorBD, '0', longitud);
                }
                return new TipoDatoRetornoMetodo(valorBD.substring(6, 8) + valorBD.substring(4, 6) + valorBD.substring(0, 4));
            }
            if (tipoDato.startsWith("Valores:")) {
                String ll = tipoDato.substring(8);
                String valorFinal = "";
                Map<String, String> correspondencias = this.getFromCache(ll);
                if (correspondencias == null) {
                    correspondencias = new HashMap<String, String>();
                    String[] p = StringUtility.getStringUtility().split(ll, ":");
                    for (int k = 0; k < p.length; ++k) {
                        String[] q = StringUtility.getStringUtility().split(p[k], "=");
                        if (q.length != 2) continue;
                        correspondencias.put(FuncionesUtiles.getFuncionesUtiles().desCodificaCadena(q[1]).toUpperCase(), FuncionesUtiles.getFuncionesUtiles().desCodificaCadena(q[0]));
                    }
                    this.setInCache(ll, correspondencias);
                }
                try {
                    valorFinal = correspondencias.get(valorBD.toUpperCase()).toString();
                }
                catch (Exception ex) {
                    valorFinal = "";
                }
                if (valorFinal.length() == 0) {
                    throw new ExceptionMotor("Imposible encontrar valores para partida " + nombreCampo + " en tipo " + tipoDato);
                }
                return new TipoDatoRetornoMetodo(valorFinal);
            }
            if (tipoDato.startsWith("CTE:")) {
                valorBD = FuncionesUtiles.getFuncionesUtiles().desCodificaCadena(tipoDato.substring("CTE:".length()));
                if (valorBD.length() == 0) {
                    valorBD = " ";
                }
                valorAux = valorBD.length() > 1 ? valorBD : FuncionesUtiles.getFuncionesUtiles().rellena("", valorBD.charAt(0), longitud);
                return new TipoDatoRetornoMetodo(valorAux);
            }
            if (tipoDato.trim().equalsIgnoreCase("1_a_true")) {
                if (FuncionesUtiles.getFuncionesUtiles().sacaDeLista(listaCamposBD, nombreCampo, nomCampo).getValor().toString().equalsIgnoreCase("true")) {
                    return new TipoDatoRetornoMetodo("1");
                }
                return new TipoDatoRetornoMetodo("0");
            }
            if (tipoDato.trim().equalsIgnoreCase("SELLO")) {
                return new TipoDatoRetornoMetodo(FuncionesUtiles.getFuncionesUtiles().rellena("", ' ', longitud));
            }
            if (tipoDato.equalsIgnoreCase("X_a_true")) {
                if (FuncionesUtiles.getFuncionesUtiles().sacaDeLista(listaCamposBD, nombreCampo, nomCampo).getValor().toString().equalsIgnoreCase("true")) {
                    return new TipoDatoRetornoMetodo("X");
                }
                return new TipoDatoRetornoMetodo(" ");
            }
            if (tipoDato.trim().toUpperCase().startsWith("SIVALOR")) {
                String[] valores = tipoDato.substring(8).split("_");
                if (FuncionesUtiles.getFuncionesUtiles().sacaDeLista(listaCamposBD, nombreCampo, nomCampo).getValor().toString().length() == 0) {
                    return new TipoDatoRetornoMetodo(valores[1]);
                }
                if (FuncionesUtiles.getFuncionesUtiles().sacaDeLista(listaCamposBD, nombreCampo, nomCampo).getValor().toString().equalsIgnoreCase("0") | FuncionesUtiles.getFuncionesUtiles().sacaDeLista(listaCamposBD, nombreCampo, nomCampo).getValor().toString().equalsIgnoreCase("0.0") | FuncionesUtiles.getFuncionesUtiles().sacaDeLista(listaCamposBD, nombreCampo, nomCampo).getValor().toString().equalsIgnoreCase("0.00") | FuncionesUtiles.getFuncionesUtiles().sacaDeLista(listaCamposBD, nombreCampo, nomCampo).getValor().toString().equalsIgnoreCase("0.000") | FuncionesUtiles.getFuncionesUtiles().sacaDeLista(listaCamposBD, nombreCampo, nomCampo).getValor().toString().equalsIgnoreCase("0.0000")) {
                    return new TipoDatoRetornoMetodo(valores[1]);
                }
                return new TipoDatoRetornoMetodo(valores[0]);
            }
            if (tipoDato.trim().startsWith("CADNUM")) {
                valor = FuncionesUtiles.getFuncionesUtiles().sacaDeLista(listaCamposBD, nombreCampo, nomCampo).getValor().toString();
                valor = FuncionesUtiles.getFuncionesUtiles().rellena(valor, '0', longitud);
                return new TipoDatoRetornoMetodo(valor);
            }
            if (tipoDato.trim().toUpperCase().startsWith("ORDINALCASILLAS")) {
                String[] partidas = tipoDato.substring("ORDINALCASILLAS".length() + 1).toUpperCase().split(",");
                for (int i = 0; i < partidas.length; ++i) {
                    if (listaCamposBD.get(partidas[i]) == null) {
                        TablaMotorEntrada te = new TablaMotorEntrada(partidas[i], "false");
                        listaCamposBD.put(te.getNombreEntrada(), te);
                        te = null;
                    }
                    if (listaCamposBD.get(partidas[i]).getValor().toString().compareToIgnoreCase("true") != 0) continue;
                    return new TipoDatoRetornoMetodo(String.valueOf(i + 1));
                }
                return new TipoDatoRetornoMetodo("0");
            }
            if (tipoDato.trim().toUpperCase().startsWith("LAQTENGAVALOR")) {
                String ret = "";
                String[] partidas = tipoDato.substring("LAQTENGAVALOR".length() + 1).toUpperCase().split(",");
                for (int i = 0; i < partidas.length; ++i) {
                    String valorEnBBDD;
                    if (listaCamposBD.get(partidas[i]) == null) {
                        TablaMotorEntrada te = new TablaMotorEntrada(partidas[i], this.claseExportacionBOE.getSesion().getModelo().getGestorConfiguracion().getEntrada(partidas[i]).getValorInicial());
                        listaCamposBD.put(te.getNombreEntrada(), te);
                        te = null;
                    }
                    valor = valorEnBBDD = listaCamposBD.get(partidas[i]).getValor().toString();
                    String tipoReal = campoTransBOE.getPropiedadesCampos().get("TIPODATOREAL");
                    if (tipoReal == null) {
                        throw new Exception("Debe tener en el trans la entrada TIPODATOREAL para tipo de dato LAQTENGAVALOR");
                    }
                    TipoDatosCampos tclon = new TipoDatosCampos(partidas[i]);
                    tclon.setPropiedadesCampos(campoTransBOE.getPropiedadesCampos());
                    tclon.getPropiedadesCampos().put("TIPODATO", tipoReal);
                    valor = this.dameCampo(tclon, listaCamposBD);
                    if (i == 0) {
                        ret = valor;
                    }
                    if (this.claseExportacionBOE.getSesion().getModelo().getGestorConfiguracion().getEntrada(partidas[i]).esValorPorDefecto(valorEnBBDD)) continue;
                    return new TipoDatoRetornoMetodo(valor);
                }
                return new TipoDatoRetornoMetodo(ret);
            }
            if (tipoDato.trim().toUpperCase().startsWith("DE_") && (valor = FuncionesUtiles.getFuncionesUtiles().sacaDeLista(listaCamposBD, nombreCampo, nomCampo).getValor().toString()).trim().length() == 0) {
                return new TipoDatoRetornoMetodo("0");
            }
            if (tipoDato.trim().toUpperCase().startsWith("DEB_") && (valor = FuncionesUtiles.getFuncionesUtiles().sacaDeLista(listaCamposBD, nombreCampo, nomCampo).getValor().toString()).trim().length() == 0) {
                return new TipoDatoRetornoMetodo(" ");
            }
            valorAux = FuncionesUtiles.getFuncionesUtiles().rellena(valorBD, ' ', longitud);
            return new TipoDatoRetornoMetodo(valorAux);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public String formateaFecha(String valor) throws ExceptionMotor {
        try {
            ITipoDatoRetornoMetodo ret;
            if (this.getSesion().getModelo() != null && this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo().formateaFecha(this, valor)).isRetornaResultado()) {
                return ret.getObjetoRetornoAsString();
            }
            return this.formateaFechaRecursivo(valor).getObjetoRetornoAsString();
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public ITipoDatoRetornoMetodo formateaFechaRecursivo(String valor) throws ExceptionMotor {
        if (valor.length() == 10) {
            return new TipoDatoRetornoMetodo(valor.substring(0, 2) + valor.substring(3, 5) + valor.substring(6));
        }
        if (valor.length() == 8) {
            return new TipoDatoRetornoMetodo(valor);
        }
        if (valor.length() == 0 || valor.equalsIgnoreCase("00000000")) {
            return new TipoDatoRetornoMetodo("00000000");
        }
        throw new ExceptionMotor("Formato incorrecto en FECHA_SIN_FORMATO");
    }

    @Override
    public int longitudNumeroSinPuntosetc(String valor) {
        int ret = 0;
        for (int i = 0; i < valor.length(); ++i) {
            try {
                Integer.valueOf(valor.substring(i, i + 1));
                ++ret;
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return ret;
    }

    @Override
    public String compruebaCampo(ITipoDatosCampos campoTransBOE, Map<String, ITablaMotorEntrada> listaCamposBD, String valor) throws ExceptionMotor {
        ITipoDatoRetornoMetodo ret = null;
        if (this.getSesion().getModelo() != null && this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo().compruebaCampo(this, campoTransBOE, listaCamposBD, valor)) != null && ret.isRetornaResultado()) {
            return ret.getObjetoRetornoAsString();
        }
        ret = this.compruebaCampoRecursivo(campoTransBOE, listaCamposBD, valor);
        if (ret == null) {
            return null;
        }
        return ret.getObjetoRetornoAsString();
    }

    @Override
    public ITipoDatoRetornoMetodo compruebaCampoRecursivo(ITipoDatosCampos campoTransBOE, Map<String, ITablaMotorEntrada> listaCamposBD, String valor) throws ExceptionMotor {
        try {
            Map<String, String> propiedades = FuncionesUtiles.getFuncionesUtiles().traducirTipoCampo(campoTransBOE.getPropiedadesCampos(), (IGestorTraduccionesBOE)this.getClaseExportacionBOE().getGestorTraduccionesBOE(), listaCamposBD);
            if (propiedades.get("LONGITUD") != null && FuncionesUtiles.getFuncionesUtiles().esNumerico(propiedades.get("LONGITUD").toString())) {
                int len = Integer.valueOf(propiedades.get("LONGITUD").toString());
                if (valor.length() > len) {
                    FuncionesUtiles.getFuncionesUtiles().muestraError(new ExceptionMotor("Campo " + propiedades.get("LITERAL") + " " + campoTransBOE.getNombreCampo() + " tiene un tama\u00f1o mayor al esperado se trunca..."));
                    return new TipoDatoRetornoMetodo(valor.substring(0, len));
                }
                if (valor.length() < len) {
                    FuncionesUtiles.getFuncionesUtiles().muestraError(new ExceptionMotor("Campo " + propiedades.get("LITERAL") + " " + campoTransBOE.getNombreCampo() + " tiene un tama\u00f1o menor al esperado..."));
                    return null;
                }
            }
            return new TipoDatoRetornoMetodo(valor);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void escribeLogPrivadoCabecera(String observaciones) {
        try {
            this.getFw().writeln();
            FuncionesUtiles.getFuncionesUtiles().muestraAviso("\u00a1\u00a1\u00a1\u00a1\u00a1\u00a1USANDO LOG PARA LA EXPORTACION, RALENTIZA TODO SOLO USAR EN DEBUG!!!!!!");
            this.getFw().writeln("--------------------------------------------------------------------------------------");
            this.getFw().writeln(observaciones);
            this.getFw().writeln("--------------------------------------------------------------------------------------");
            this.getFw().writeln();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void escribeLogPrivado(int posicion, String nombreCampo, String valor, String observaciones) {
        try {
            this.getFw().writeln(posicion + " " + nombreCampo + " => [" + valor + "]" + " " + observaciones);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public String dameLinea(Map<String, String> parametrosTabla, List<ITipoDatosCampos> camposTransBOE, Map<String, ITablaMotorEntrada> listaCamposBD) throws ExceptionMotor {
        ITipoDatoRetornoMetodo ret;
        if (this.getSesion().getModelo() != null && this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo().dameLinea(this, parametrosTabla, camposTransBOE, listaCamposBD)).isRetornaResultado()) {
            return ret.getObjetoRetornoAsString();
        }
        return this.dameLineaRecursiva(parametrosTabla, camposTransBOE, listaCamposBD).getObjetoRetornoAsString();
    }

    @Override
    public ITipoDatoRetornoMetodo dameLineaRecursiva(Map<String, String> parametrosTabla, List<ITipoDatosCampos> camposTransBOE, Map<String, ITablaMotorEntrada> listaCamposBD) throws ExceptionMotor {
        String campo = "";
        String lineaSalida = "";
        try {
            int desplazamiento = 0;
            try {
                if (parametrosTabla.containsKey("VARIABLE")) {
                    desplazamiento = parametrosTabla.get("VARIABLE").toString().length() + 1;
                } else if (parametrosTabla.containsKey("CONSTANTE")) {
                    desplazamiento = parametrosTabla.get("CONSTANTE").toString().length() + 1;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            for (int i = 0; i < camposTransBOE.size(); ++i) {
                campo = this.dameCampo(camposTransBOE.get(i), listaCamposBD);
                if (this.getFicheroLogPrivado().length() > 0) {
                    this.escribeLogPrivado(lineaSalida.length() + desplazamiento, camposTransBOE.get(i).getPropiedadesCampos().get("LITERAL").toString(), campo, "");
                }
                if (campo == null) {
                    return new TipoDatoRetornoMetodo(null);
                }
                boolean comprobarlo = true;
                if (camposTransBOE.get(i).getPropiedadesCampos() != null) {
                    boolean bl = comprobarlo = !camposTransBOE.get(i).getPropiedadesCampos().containsKey("NOEXPORTAR");
                }
                if (comprobarlo && (campo = this.compruebaCampo(camposTransBOE.get(i), listaCamposBD, campo)) == null) {
                    return new TipoDatoRetornoMetodo(null);
                }
                lineaSalida = lineaSalida + campo;
            }
            return new TipoDatoRetornoMetodo(lineaSalida);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Campo " + campo + " lineaSalida " + lineaSalida);
        }
    }

    @Override
    public String dameNombrePartidaSinParentesis(String partida) {
        int i = partida.indexOf(40);
        if (i > -1) {
            return partida.substring(0, i);
        }
        return partida;
    }

    @Override
    public ITipoDatosCampoValor damePartida(String cadenas) throws ExceptionMotor {
        try {
            String[] partidas;
            TipoDatosCampoValor ret = new TipoDatosCampoValor("", "");
            for (String partida : partidas = cadenas.split(",")) {
                String nom = this.dameNombrePartidaSinParentesis(partida);
                String val = this.getSesion().getOperaciones().obtenerPartidaString(nom);
                if (ret.getNombreCampo().trim().length() == 0) {
                    ret.setNombreCampo(nom);
                    ret.setValor(val);
                    continue;
                }
                if (this.getSesion().getModelo().getGestorConfiguracion().getEntrada(nom).esValorPorDefecto(val)) continue;
                ret.setNombreCampo(nom);
                ret.setValor(val);
            }
            return ret;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public boolean tieneDatos(List<ITipoDatosCampos> camposTransBOE, Map<String, ITablaMotorEntrada> listaCamposBD) throws ExceptionMotor {
        ITipoDatoRetornoMetodo ret;
        if (this.getSesion().getModelo() != null && this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo().tieneDatos(this, camposTransBOE, listaCamposBD)).isRetornaResultado()) {
            return ret.getObjetoRetornoAsBoolean();
        }
        return this.tieneDatosRecursiva(camposTransBOE, listaCamposBD).getObjetoRetornoAsBoolean();
    }

    @Override
    public ITipoDatoRetornoMetodo tieneDatosRecursiva(List<ITipoDatosCampos> camposTransBOE, Map<String, ITablaMotorEntrada> listaCamposBD) throws ExceptionMotor {
        String partida = "";
        try {
            for (ITipoDatosCampos campo : camposTransBOE) {
                partida = campo.getNombreCampo();
                IRegEntrada entrada = this.getSesion().getModelo().getGestorConfiguracion().getEntrada(this.dameNombrePartidaSinParentesis(partida));
                if (entrada == null || entrada.esValorPorDefecto(listaCamposBD.get(partida).getValor().toString())) continue;
                return new TipoDatoRetornoMetodo(true);
            }
            return new TipoDatoRetornoMetodo(false);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Partida " + partida);
        }
    }

    @Override
    public List<String> generaLinea(String sNombreTabla, Map<String, ITablaMotorEntrada> listaCamposBD) throws ExceptionMotor {
        ITipoDatoRetornoMetodo ret;
        if (this.getSesion().getModelo() != null && this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo().generaLinea(this, sNombreTabla, listaCamposBD)).isRetornaResultado()) {
            return ret.getObjetoRetornoAsList();
        }
        return this.generaLineaRecursiva(sNombreTabla, listaCamposBD).getObjetoRetornoAsList();
    }

    protected String concatenaFiltroAEntrada(String entrada, String filtro) {
        if (filtro != null && filtro.length() > 0) {
            return entrada + "[" + filtro + "]";
        }
        return entrada;
    }

    @Override
    public ITipoDatoRetornoMetodo generaLineaRecursiva(String sNombreTabla, Map<String, ITablaMotorEntrada> listaCamposBD) throws ExceptionMotor {
        ArrayList<String> aFinal = new ArrayList<String>();
        String lineaSalida = "";
        List<Object> camposTransBOE = new ArrayList();
        TablaMotorEntrada te = null;
        long l = -1L;
        try {
            List<ITipoDatosTabla> tablasEnGestor = ((IGestorTraduccionesBOE)this.getClaseExportacionBOE().getGestorTraduccionesBOE()).getTablas();
            for (int i = 0; i < tablasEnGestor.size(); ++i) {
                this.setNombreTablaActual(tablasEnGestor.get(i).getNombreTabla());
                Map<String, String> parametrosTabla = ((IGestorTraduccionesBOE)this.getClaseExportacionBOE().getGestorTraduccionesBOE()).getTabla(this.getNombreTablaActual());
                camposTransBOE = FuncionesUtiles.getFuncionesUtiles().cloneList(tablasEnGestor.get(i).getCampos());
                listaCamposBD = null;
                listaCamposBD = new HashMap<String, ITablaMotorEntrada>();
                boolean primeraPasada = true;
                do {
                    lineaSalida = "";
                    if (parametrosTabla.containsKey("CONSTANTE")) {
                        if (parametrosTabla.get("CONSTANTE").toString().indexOf(":") == -1) {
                            lineaSalida = FuncionesUtiles.getFuncionesUtiles().html2Text(parametrosTabla.get("CONSTANTE").toString().toUpperCase());
                        }
                    } else if (parametrosTabla.containsKey("VARIABLE")) {
                        lineaSalida = FuncionesUtiles.getFuncionesUtiles().html2Text(this.getSesion().getOperaciones().obtenerPartidaString(parametrosTabla.get("VARIABLE")).trim().toUpperCase());
                    }
                    int hayDatosEnTablas = 0;
                    String filtro = "";
                    for (int j = 0; j < camposTransBOE.size(); ++j) {
                        String nombreTabla;
                        Map<String, String> propCampos = ((ITipoDatosCampos)camposTransBOE.get(j)).getPropiedadesCampos();
                        if (!primeraPasada && propCampos.containsKey("SIGUIENTES")) {
                            String siguientes = propCampos.get("SIGUIENTES");
                            if (siguientes.startsWith("NO VALIDAR")) {
                                siguientes = siguientes.substring("NO VALIDAR".length() + 1);
                            }
                            if (!siguientes.toUpperCase().startsWith("CTE:")) {
                                siguientes = "CTE:" + FuncionesUtiles.getFuncionesUtiles().codificaCadena(siguientes);
                            }
                            if (!((ITipoDatosCampos)camposTransBOE.get(j)).getNombreCampo().equals("")) {
                                ((ITipoDatosCampos)camposTransBOE.get(j)).setNombreCampo("~comp");
                            }
                            propCampos.put("TIPODATO", siguientes);
                        }
                        filtro = propCampos.get("FILTRO");
                        if (propCampos.containsKey("LOCALIZADORUNICOCAMPO") && !propCampos.containsKey("VALOR") && this.getSesion().getModelo().getGestorConfiguracion().getEntrada(propCampos.get("LOCALIZADORUNICOCAMPO").toUpperCase()) == null) {
                            propCampos.remove("LOCALIZADORUNICOCAMPO");
                            ((ITipoDatosCampos)camposTransBOE.get(j)).setNombreCampo("");
                        }
                        if (((ITipoDatosCampos)camposTransBOE.get(j)).getNombreCampo().equalsIgnoreCase("") && propCampos.get("VALOR") == null && propCampos.get("TABLA") == null && propCampos.get("MUEVETABLA") == null || ((ITipoDatosCampos)camposTransBOE.get(j)).getNombreCampo().equalsIgnoreCase("~comp")) continue;
                        boolean tratar = true;
                        if (propCampos.get("TABLA") != null) {
                            if (hayDatosEnTablas == 0) {
                                hayDatosEnTablas = 1;
                            }
                            nombreTabla = propCampos.get("TABLA").toString();
                            if (this.getGestorTablas().esTablaAcabada(nombreTabla, filtro) || this.getSesion() != null && this.obtenerClaveActiva(nombreTabla) == -1L) {
                                this.getGestorTablas().acaboTabla(nombreTabla, filtro);
                                tratar = false;
                            }
                            if (!this.getGestorTablas().isComenzoTabla(nombreTabla, filtro)) {
                                this.getGestorTablas().comenzoTabla(nombreTabla, filtro);
                                l = -1L;
                                if (this.getSesion() != null) {
                                    l = this.moveFirst(nombreTabla, filtro);
                                }
                                if (l > 0L) {
                                    this.getGestorTablas().recorriendoTabla(nombreTabla, filtro, new TipoDatosCampoValor(String.valueOf(l), this.getSesion().getOperaciones().getLocalizacion(nombreTabla)));
                                } else {
                                    this.getGestorTablas().acaboTabla(nombreTabla, filtro);
                                    tratar = false;
                                }
                            } else if (this.getGestorTablas().isRecorriendoTabla(nombreTabla, filtro)) {
                                this.move(nombreTabla, this.getGestorTablas().getPosicionRecorriendoTabla(nombreTabla, filtro));
                            }
                            if (hayDatosEnTablas != 2 && this.obtenerClaveActiva(nombreTabla) > 0L) {
                                hayDatosEnTablas = 2;
                            }
                            this.estudiarCasosEspeciales(nombreTabla, propCampos, this.getGestorTablas());
                        } else if (propCampos.get("MUEVETABLA") != null) {
                            nombreTabla = propCampos.get("MUEVETABLA").toString();
                            if (this.getGestorTablas().esTablaAcabada(nombreTabla, filtro) || this.getSesion() != null && this.obtenerClaveActiva(nombreTabla) < 1L) {
                                tratar = false;
                            }
                        }
                        if (!tratar) {
                            te = new TablaMotorEntrada(((ITipoDatosCampos)camposTransBOE.get(j)).getNombreCampo().toUpperCase(), (String)this.getSesion().getOperaciones().obtenerValorPorDefectoPartida(this.dameNombrePartidaSinParentesis(((ITipoDatosCampos)camposTransBOE.get(j)).getNombreCampo().toUpperCase()).toString()));
                            listaCamposBD.put(this.concatenaFiltroAEntrada(te.getNombreEntrada(), filtro), te);
                            te = null;
                            continue;
                        }
                        String partidaAObtener = ((ITipoDatosCampos)camposTransBOE.get(j)).getNombreCampo().toUpperCase();
                        String valorPartida = "";
                        if (propCampos.get("VALOR") != null) {
                            partidaAObtener = propCampos.get("VALOR").toString().toUpperCase();
                        }
                        if (partidaAObtener.length() > 0) {
                            if (this.getSesion() != null) {
                                ITipoDatosCampoValor tcv = this.damePartida(partidaAObtener);
                                valorPartida = tcv.getValor();
                                tcv = null;
                            }
                            if (propCampos.get("LOCALIZADORUNICOCAMPO") != null) {
                                partidaAObtener = propCampos.get("LOCALIZADORUNICOCAMPO").toUpperCase();
                            }
                            if (propCampos.containsKey("TIPODATO") && propCampos.get("TIPODATO").toUpperCase().startsWith("ORDINALCASILLAS_")) {
                                String[] partidas = propCampos.get("TIPODATO").substring("ORDINALCASILLAS_".length()).toUpperCase().split(",");
                                for (int k = 0; k < partidas.length; ++k) {
                                    if (partidas[k].equalsIgnoreCase(partidaAObtener)) continue;
                                    String valor = "";
                                    valor = this.getSesion().getOperaciones().obtenerPartidaString(this.dameNombrePartidaSinParentesis(partidas[k]));
                                    valor = FuncionesUtiles.getFuncionesUtiles().html2Text(valor);
                                    te = new TablaMotorEntrada(partidas[k], valor);
                                    listaCamposBD.put(this.concatenaFiltroAEntrada(te.getNombreEntrada(), filtro), te);
                                    te = null;
                                }
                            }
                            valorPartida = FuncionesUtiles.getFuncionesUtiles().html2Text(valorPartida);
                            te = new TablaMotorEntrada(partidaAObtener, valorPartida);
                            listaCamposBD.put(this.concatenaFiltroAEntrada(te.getNombreEntrada(), filtro), te);
                            te = null;
                        }
                        if (propCampos.get("MUEVETABLA") == null || !this.puedoHacerMoveNext(nombreTabla = propCampos.get("MUEVETABLA").toString(), filtro, this.getGestorTablas())) continue;
                        l = 0L;
                        if (!this.isEndOfRecordSet(nombreTabla, filtro)) {
                            l = this.moveNext(nombreTabla, filtro);
                        }
                        if (l < 1L || this.getSesion().getOperaciones().getLocalizacion(nombreTabla) == this.getGestorTablas().getLocalizacionRecorriendoTabla(nombreTabla, filtro)) {
                            this.getGestorTablas().acaboTabla(nombreTabla, filtro);
                            continue;
                        }
                        this.getGestorTablas().recorriendoTabla(nombreTabla, filtro, new TipoDatosCampoValor(String.valueOf(l), this.getSesion().getOperaciones().getLocalizacion(nombreTabla)));
                    }
                    if (this.getFicheroLogPrivado().length() > 0) {
                        this.escribeLogPrivadoCabecera("TABLA " + parametrosTabla.get("LITERAL").toString());
                    }
                    String contenidoGenerado = null;
                    if (hayDatosEnTablas != 1 || parametrosTabla.containsKey("OBLIGATORIA") && !parametrosTabla.get("OBLIGATORIA").equalsIgnoreCase("no") || this.tieneDatos(camposTransBOE, listaCamposBD)) {
                        contenidoGenerado = this.dameLinea(parametrosTabla, camposTransBOE, listaCamposBD);
                    }
                    if (contenidoGenerado != null) {
                        lineaSalida = lineaSalida + contenidoGenerado;
                        listaCamposBD.clear();
                        if (parametrosTabla.get("LONGITUD") != null && FuncionesUtiles.getFuncionesUtiles().esNumerico(parametrosTabla.get("LONGITUD").toString())) {
                            int longitudRegistro = Integer.valueOf(parametrosTabla.get("LONGITUD").toString());
                            if (lineaSalida.length() != longitudRegistro) {
                                throw new ExceptionMotor("Tabla " + tablasEnGestor.get(i).getNombreTabla() + " no tiene la longitud esperada compruebe fichero Trans " + longitudRegistro + "!=" + lineaSalida.length());
                            }
                            while (lineaSalida.length() < longitudRegistro) {
                                lineaSalida = lineaSalida + " ";
                            }
                        }
                        if (parametrosTabla.get("PRECEDERPORSALTODELINEA") != null) {
                            lineaSalida = "\r\n" + lineaSalida;
                        }
                        aFinal.add(lineaSalida);
                        aFinal.add("");
                    }
                    primeraPasada = false;
                } while (this.getGestorTablas().isRecorriendoTablas());
            }
            return new TipoDatoRetornoMetodo(aFinal);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + sNombreTabla + " linea " + lineaSalida);
        }
    }

    protected boolean cumpleConFiltro(String filtro) throws ExceptionMotor {
        try {
            String[] filtros;
            for (String filter : filtros = filtro.split(";")) {
                String[] filt = filter.split("=");
                if (this.getSesion().getOperaciones().obtenerPartidaString(filt[0].trim()).equalsIgnoreCase(filt[1].trim())) continue;
                return false;
            }
            return true;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Filtro " + filtro);
        }
    }

    protected long moveComun(String nombreTabla, String filtro, long posActual) throws ExceptionMotor {
        try {
            while (posActual > 0L) {
                if (this.cumpleConFiltro(filtro)) {
                    return posActual;
                }
                if (!this.getSesion().getOperaciones().moveIfHasNext(nombreTabla)) break;
                posActual = this.getSesion().getOperaciones().obtenerClaveActiva(nombreTabla);
            }
            return 0L;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public boolean puedoHacerMoveNext(String nombreTabla, String filtro, IGestorTablas gestorTablas) throws ExceptionMotor {
        ITipoDatoRetornoMetodo ret;
        if (this.getSesion().getModelo() != null && this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo().puedoHacerMoveNext(this, nombreTabla, filtro, gestorTablas)).isRetornaResultado()) {
            return ret.getObjetoRetornoAsBoolean();
        }
        return this.puedoHacerMoveNextRecursiva(nombreTabla, filtro, gestorTablas).getObjetoRetornoAsBoolean();
    }

    @Override
    public ITipoDatoRetornoMetodo puedoHacerMoveNextRecursiva(String nombreTabla, String filtro, IGestorTablas gestorTablas) throws ExceptionMotor {
        boolean ret = true;
        List<String> relacionadas = null;
        try {
            if (!gestorTablas.isRecorriendoTablas()) {
                TipoDatoRetornoMetodo tipoDatoRetornoMetodo = new TipoDatoRetornoMetodo(ret);
                return tipoDatoRetornoMetodo;
            }
            if (gestorTablas.recorriendoTablasCount() == 1 && gestorTablas.isRecorriendoTabla(nombreTabla, filtro)) {
                TipoDatoRetornoMetodo tipoDatoRetornoMetodo = new TipoDatoRetornoMetodo(ret);
                return tipoDatoRetornoMetodo;
            }
            relacionadas = this.dameTablasHijasDe(nombreTabla);
            List<String> tablasRecorriendose = gestorTablas.dameListaTablasRecorriendose();
            for (String tabla : tablasRecorriendose) {
                if (tabla.equalsIgnoreCase(nombreTabla) || relacionadas == null || !relacionadas.contains(tabla)) continue;
                ret = false;
                break;
            }
            TipoDatoRetornoMetodo tipoDatoRetornoMetodo = new TipoDatoRetornoMetodo(ret);
            return tipoDatoRetornoMetodo;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
        finally {
            if (ret) {
                ArrayList<String> elementosABorrar = new ArrayList<String>();
                relacionadas = this.dameTablasHijasDe(nombreTabla);
                if (relacionadas != null) {
                    List<String> tablasAcabadas = gestorTablas.dameListaTablasAcabadas();
                    for (String tabla : tablasAcabadas) {
                        if (!relacionadas.contains(tabla)) continue;
                        elementosABorrar.add(tabla);
                    }
                    while (elementosABorrar.size() > 0) {
                        gestorTablas.quitarAcaboTabla((String)elementosABorrar.get(0), filtro);
                        elementosABorrar.remove(0);
                    }
                    List<String> tablasEmpezadas = gestorTablas.dameListaTablasEmpezadas();
                    for (String tabla : tablasEmpezadas) {
                        if (!relacionadas.contains(tabla)) continue;
                        elementosABorrar.add(tabla);
                    }
                    while (elementosABorrar.size() > 0) {
                        gestorTablas.quitarComenzoTabla((String)elementosABorrar.get(0), filtro);
                        elementosABorrar.remove(0);
                    }
                }
            }
        }
    }

    @Override
    public ITipoDatoRetornoMetodo obtenerClaveActivaRecursiva(String nombreTabla) throws ExceptionMotor {
        return new TipoDatoRetornoMetodo(this.getSesion().getOperaciones().obtenerClaveActiva(nombreTabla));
    }

    @Override
    public ITipoDatoRetornoMetodo moveFirstRecursiva(String nombreTabla, String filtro) throws ExceptionMotor {
        long ret = this.getSesion().getOperaciones().moveFirst(nombreTabla);
        if (filtro == null) {
            return new TipoDatoRetornoMetodo(ret);
        }
        return new TipoDatoRetornoMetodo(this.moveComun(nombreTabla, filtro, ret));
    }

    @Override
    public long moveFirst(String nombreTabla, String filtro) throws ExceptionMotor {
        ITipoDatoRetornoMetodo ret;
        if (this.getSesion().getModelo() != null && this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo().moveFirst(this, nombreTabla, filtro)).isRetornaResultado()) {
            return ret.getObjetoRetornoAsLong();
        }
        return this.moveFirstRecursiva(nombreTabla, filtro).getObjetoRetornoAsLong();
    }

    @Override
    public ITipoDatoRetornoMetodo moveNextRecursiva(String nombreTabla, String filtro) throws ExceptionMotor {
        long ret = this.getSesion().getOperaciones().moveNext(nombreTabla);
        if (filtro == null) {
            return new TipoDatoRetornoMetodo(ret);
        }
        return new TipoDatoRetornoMetodo(this.moveComun(nombreTabla, filtro, ret));
    }

    @Override
    public long moveNext(String nombreTabla, String filtro) throws ExceptionMotor {
        ITipoDatoRetornoMetodo ret;
        if (this.getSesion().getModelo() != null && this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo().moveNext(this, nombreTabla, filtro)).isRetornaResultado()) {
            return ret.getObjetoRetornoAsLong();
        }
        return this.moveNextRecursiva(nombreTabla, filtro).getObjetoRetornoAsLong();
    }

    @Override
    public ITipoDatoRetornoMetodo moveRecursiva(String nombreTabla, long pos) throws ExceptionMotor {
        return new TipoDatoRetornoMetodo(this.getSesion().getOperaciones().move(nombreTabla, pos));
    }

    @Override
    public long move(String nombreTabla, long pos) throws ExceptionMotor {
        ITipoDatoRetornoMetodo ret;
        if (this.getSesion().getModelo() != null && this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo().move(this, nombreTabla, pos)).isRetornaResultado()) {
            return ret.getObjetoRetornoAsLong();
        }
        return this.moveRecursiva(nombreTabla, pos).getObjetoRetornoAsLong();
    }

    @Override
    public long obtenerClaveActiva(String nombreTabla) throws ExceptionMotor {
        ITipoDatoRetornoMetodo ret;
        if (this.getSesion().getModelo() != null && this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo().obtenerClaveActiva(this, nombreTabla)).isRetornaResultado()) {
            return ret.getObjetoRetornoAsLong();
        }
        return this.obtenerClaveActivaRecursiva(nombreTabla).getObjetoRetornoAsLong();
    }

    @Override
    public ITipoDatoRetornoMetodo isEndOfRecordSetRecursiva(String nombreTabla, String filtro) throws ExceptionMotor {
        boolean usandoFreezer = false;
        try {
            if (filtro == null) {
                TipoDatoRetornoMetodo tipoDatoRetornoMetodo = new TipoDatoRetornoMetodo(this.getSesion().getOperaciones().obtenerClaveActiva(nombreTabla) == this.getSesion().getOperaciones().recordCount(nombreTabla));
                return tipoDatoRetornoMetodo;
            }
            if (!this.getGestorTablas().isRecorriendoTabla(nombreTabla, filtro)) {
                TipoDatoRetornoMetodo tipoDatoRetornoMetodo = new TipoDatoRetornoMetodo(true);
                return tipoDatoRetornoMetodo;
            }
            this.getSesion().freezeSesionSoloPosicion("generadorLineas" + this.toString());
            usandoFreezer = true;
            long posActual = this.getGestorTablas().getPosicionRecorriendoTabla(nombreTabla, filtro);
            long posSiguiente = this.moveNext(nombreTabla, filtro);
            TipoDatoRetornoMetodo tipoDatoRetornoMetodo = new TipoDatoRetornoMetodo(posActual == posSiguiente || posSiguiente == 0L);
            return tipoDatoRetornoMetodo;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
        finally {
            if (usandoFreezer) {
                this.getSesion().unfreeze("generadorLineas" + this.toString());
            }
        }
    }

    @Override
    public boolean isEndOfRecordSet(String nombreTabla, String filtro) throws ExceptionMotor {
        ITipoDatoRetornoMetodo ret;
        if (this.getSesion().getModelo() != null && this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo().isEndOfRecordSet(this, nombreTabla, filtro)).isRetornaResultado()) {
            return ret.getObjetoRetornoAsBoolean();
        }
        return this.isEndOfRecordSetRecursiva(nombreTabla, filtro).getObjetoRetornoAsBoolean();
    }

    @Override
    public void estudiarCasosEspeciales(String nombreTabla, Map<String, String> propCampos, IGestorTablas gestorTablas) throws ExceptionMotor {
        ITipoDatoRetornoMetodo ret;
        if (this.getSesion().getModelo() != null && this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo().estudiarCasosEspeciales(this, nombreTabla, propCampos, this.getGestorTablas())).isRetornaResultado()) {
            return;
        }
        this.estudiarCasosEspecialesRecursiva(nombreTabla, propCampos, this.getGestorTablas());
    }

    @Override
    public ITipoDatoRetornoMetodo estudiarCasosEspecialesRecursiva(String nombreTabla, Map<String, String> propCampos, IGestorTablas gestorTablas) throws ExceptionMotor {
        return new TipoDatoRetornoMetodo(ITipoDatoRetornoMetodo.tipoDato_Void);
    }

    @Override
    public List<String> dameTablasHijasDe(String nombreTabla) throws ExceptionMotor {
        try {
            IRegRelacionada rsTaRel;
            if (this.getCacheParaDameTablasHijasDe() == null) {
                this.setCacheParaDameTablasHijasDe(new HashMap<String, List<String>>());
            }
            if (this.getCacheParaDameTablasHijasDe().containsKey(nombreTabla)) {
                return this.getCacheParaDameTablasHijasDe().get(nombreTabla);
            }
            IGestorConfiguracion gestorConfiguracion = this.getSesion().getModelo().getGestorConfiguracion();
            if (gestorConfiguracion != null && (rsTaRel = gestorConfiguracion.getRelacionada(nombreTabla)) != null) {
                this.getCacheParaDameTablasHijasDe().put(nombreTabla, rsTaRel.getTablaRelacionada());
                return this.getCacheParaDameTablasHijasDe().get(nombreTabla);
            }
            this.getCacheParaDameTablasHijasDe().put(nombreTabla, null);
            return null;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public Map<String, String> getFromCache(String valor) throws ExceptionMotor {
        try {
            return this.getCacheGenerador().get(valor);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Valor " + valor);
        }
    }

    @Override
    public void setInCache(String valor, Map<String, String> dato) throws ExceptionMotor {
        try {
            if (this.getCacheGenerador().size() == this.getCacheGeneradorMAXCapacity()) {
                Set<String> claves = this.getCacheGenerador().keySet();
                Iterator<String> it = claves.iterator();
                this.getCacheGenerador().remove(it.next());
            }
            this.getCacheGenerador().put(valor, dato);
        }
        catch (Exception ex) {
            this.getCacheGenerador().clear();
            if (ex instanceof ExceptionMotor) {
                ((ExceptionMotor)ex).setInformacionExtra(((ExceptionMotor)ex).getInformacionExtra() + "Valor " + valor);
                throw (ExceptionMotor)ex;
            }
            throw new ExceptionMotor(ex, "Valor " + valor);
        }
    }

    @Override
    public void setFicheroLogPrivado(String ficheroLogPrivado) {
        try {
            new File(ficheroLogPrivado).delete();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.setFw(new FileWriterAEAT(ficheroLogPrivado));
        }
        catch (Exception e) {
            this.ficheroLogPrivado = "";
            FuncionesUtiles.getFuncionesUtiles().muestraError(e);
            return;
        }
        this.ficheroLogPrivado = ficheroLogPrivado;
    }

    @Override
    public String getFicheroLogPrivado() {
        return this.ficheroLogPrivado;
    }

    @Override
    public void setClaseExportacionBOE(IExportacionBOE claseExportacionBOE) {
        this.claseExportacionBOE = claseExportacionBOE;
    }

    @Override
    public IExportacionBOE getClaseExportacionBOE() {
        return this.claseExportacionBOE;
    }

    @Override
    public int getCacheGeneradorMAXCapacity() {
        return 1000;
    }

    @Override
    public void setCacheGenerador(Map<String, Map<String, String>> cacheGenerador) {
        this.cacheGenerador = cacheGenerador;
    }

    @Override
    public Map<String, Map<String, String>> getCacheGenerador() {
        return this.cacheGenerador;
    }

    @Override
    public boolean isGenerarAuxiliar() {
        return this.generarAuxiliar;
    }

    @Override
    public void setNombreTablaActual(String nombreTablaActual) {
        this.nombreTablaActual = nombreTablaActual;
    }

    @Override
    public String getNombreTablaActual() {
        return this.nombreTablaActual;
    }

    @Override
    public void setFw(IFileWriterAEAT fw) {
        this.fw = fw;
    }

    @Override
    public IFileWriterAEAT getFw() {
        return this.fw;
    }

    @Override
    public void setCacheParaDameTablasHijasDe(Map<String, List<String>> cacheParaDameTablasHijasDe) {
        this.cacheParaDameTablasHijasDe = cacheParaDameTablasHijasDe;
    }

    @Override
    public Map<String, List<String>> getCacheParaDameTablasHijasDe() {
        return this.cacheParaDameTablasHijasDe;
    }

    @Override
    public INodoArbol getArbolDatos() throws ExceptionMotor {
        return this.claseExportacionBOE.getArbolDatos();
    }

    @Override
    public ISesion getSesion() {
        return this.claseExportacionBOE.getSesion();
    }
}

