/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.gestionFicheros.exportacion.boe;

import es.aeat.pftw.mtrc.gestionFicheros.IProcessEvents;
import es.aeat.pftw.mtrc.gestionFicheros.exportacion.Exportacion;
import es.aeat.pftw.mtrc.gestionFicheros.exportacion.boe.GeneradorLineas;
import es.aeat.pftw.mtrc.gestionFicheros.exportacion.boe.IExportacionBOE;
import es.aeat.pftw.mtrc.gestionFicheros.exportacion.boe.IExportacionBOECaller;
import es.aeat.pftw.mtrc.gestionFicheros.exportacion.boe.IGeneradorLineas;
import es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.boe.IGestorTraduccionesBOE;
import es.aeat.pftw.mtrc.motor.modelo.IModelo;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesion;
import es.aeat.pftw.mtrc.motor.modelo.sesion.ISesionExtendida;
import es.aeat.pftw.mtrc.motor.modelo.sesion.tools.IGestionOperacionesExtendida;
import es.aeat.pftw.mtrc.tipos.ITipoDatosFicherosResultado;
import es.aeat.pftw.mtrc.tipos.TipoDatoRetornoMetodo;
import es.aeat.pftw.mtrc.tipos.TipoDatosFicherosBytesResultado;
import es.aeat.pftw.mtrc.tipos.TipoDatosFicherosResultado;
import es.aeat.pftw.mtrc.utilidades.ByteWriterAEAT;
import es.aeat.pftw.mtrc.utilidades.ClassLoaderFromBytes;
import es.aeat.pftw.mtrc.utilidades.FileWriterAEAT;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.utilidades.IWriterAEAT;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import es.aeat.pftw.mtrp.excepciones.ExceptionTamSuperado;
import es.aeat.pftw.mtrp.puente.ITablaMotorEntrada;
import es.aeat.pftw.mtrp.tipos.ITipoDatoRetornoMetodo;
import es.aeat.pftw.mtrp.tipos.ITipoDatosAExportar;
import es.aeat.pftw.mtrp.tipos.ITipoDatosFicherosBytesResultado;
import es.aeat.pftw.mtrp.utilidades.INodoArbol;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ExportacionBOE
extends Exportacion
implements IProcessEvents,
Serializable,
IExportacionBOE,
IExportacionBOECaller {
    private static final long serialVersionUID = 1L;
    private IGeneradorLineas lineGen = null;
    private IGestorTraduccionesBOE gestorBoe = null;
    private IWriterAEAT fw = null;
    private IWriterAEAT fwAuxiliar = null;
    private INodoArbol arbolMotor = null;
    private List<Object> listaFicheros = null;
    private List<Object> listaFicherosAuxiliares = null;
    private long contadorVolumenActual = 0L;
    private long contadorVolumenActualAuxiliares = 0L;
    private boolean crlf = false;
    private int modo = 0;

    @Override
    public IWriterAEAT getWriter(String nombre) throws ExceptionMotor {
        try {
            switch (this.modo) {
                case 0: {
                    return new FileWriterAEAT(nombre);
                }
                case 1: {
                    return new ByteWriterAEAT();
                }
            }
            throw new ExceptionMotor("No entiendo modo = " + this.modo);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (IOException e) {
            throw new ExceptionMotor(e);
        }
    }

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            super.init(parametros);
            boolean generarAuxiliares = false;
            IModelo modelo = null;
            for (Object object : parametros) {
                if (object instanceof IModelo) {
                    modelo = (IModelo)object;
                    continue;
                }
                if (!(object instanceof Boolean)) continue;
                generarAuxiliares = (Boolean)object;
            }
            if (this.getSesion() != null && modelo == null) {
                this.arbolMotor = this.getArbolDatos();
                modelo = this.getSesion().getModelo();
            }
            this.gestorBoe = (IGestorTraduccionesBOE)this.getGestorFichero().getGestorTraducciones();
            if (this.gestorBoe == null && modelo != null) {
                this.gestorBoe = modelo.getGestorTraduccionesBOE(this.getSesion());
            }
            if (this.gestorBoe == null) {
                String clase = FuncionesUtiles.getFuncionesUtiles().damePrimeraOpcion(modelo.getGestorDatosOpciones().getOpcion("ClaseGestorTraduccionesBOE"));
                if (clase == null) {
                    clase = "es.aeat.pftw.mtrc.gestionFicheros.gestorTraducciones.boe.GestorTraduccionesBOE";
                }
                ClassLoaderFromBytes cl = null;
                if (this.getSesion() != null) {
                    cl = ((ISesionExtendida)this.getSesion()).getCloader();
                }
                if (cl == null) {
                    cl = new ClassLoaderFromBytes(this.getClass().getClassLoader(), modelo.getListaBinariosClases());
                }
                this.gestorBoe = (IGestorTraduccionesBOE)FuncionesUtiles.getFuncionesUtiles().getInstancia(clase, new Object[]{modelo}, cl);
                if (this.gestorBoe.cargarEstructura(this.getGestorFichero().getFicheroGestorTraducciones())) {
                    this.getGestorFichero().setGestorTraducciones(this.gestorBoe);
                } else {
                    this.gestorBoe = null;
                    throw new ExceptionMotor("Imposible abrir GestorTraducciones");
                }
            }
            this.setLineGen((IGeneradorLineas)FuncionesUtiles.getFuncionesUtiles().getInstancia(GeneradorLineas.class, new Object[]{this}));
            this.getLineGen().setGenerarAuxiliar(generarAuxiliares);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Object getGestorTraduccionesBOE() {
        return this.getGestorBoe();
    }

    @Override
    public void setGestorTraduccionesBOE(Object g) {
        this.setGestorBoe((IGestorTraduccionesBOE)g);
    }

    @Override
    public void setCrLf(boolean habilitar) {
        this.crlf = habilitar;
    }

    @Override
    public boolean getCrLf() {
        return this.crlf;
    }

    @Override
    public boolean exportaRegistro(String nombreTabla, Map<String, ITablaMotorEntrada> registro) throws ExceptionMotor {
        ITipoDatoRetornoMetodo ret;
        if (this.getSesion().getModelo() != null && this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo().exportaRegistro(this, nombreTabla, registro)).isRetornaResultado()) {
            return ret.getObjetoRetornoAsBoolean();
        }
        return this.exportaRegistroRecursiva(nombreTabla, registro).getObjetoRetornoAsBoolean();
    }

    @Override
    public ITipoDatoRetornoMetodo exportaRegistroRecursiva(String nombreTabla, Map<String, ITablaMotorEntrada> registro) throws ExceptionMotor {
        try {
            if (this.isFueCancelado()) {
                return new TipoDatoRetornoMetodo(false);
            }
            List<String> lineas = this.getLineGen().generaLinea(nombreTabla, registro);
            if (lineas == null || lineas.size() == 0) {
                return new TipoDatoRetornoMetodo(false);
            }
            String cadena = "";
            String cadenaAuxiliar = "";
            for (int numlineas = 0; numlineas < lineas.size(); numlineas += 2) {
                cadena = lineas.get(numlineas).toString();
                cadenaAuxiliar = lineas.get(numlineas + 1).toString();
                this.contadorVolumenActual += (long)cadena.length();
                if (this.getGestorFichero().superaMaxFicheros(this.contadorVolumenActual)) {
                    throw new ExceptionTamSuperado();
                }
                if (this.getTamVolumenes() > 0L && this.contadorVolumenActual > this.getTamVolumenes()) {
                    this.contadorVolumenActual = cadena.length();
                    this.guardaBytes(this.fw);
                    String nombreFichero = "";
                    if (this.modo == 0) {
                        nombreFichero = this.getFicheroTemporal();
                        if (nombreFichero.length() == 0) {
                            throw new ExceptionMotor("Imposible generar " + nombreFichero + " compruebe la ruta o la protecci\u00f3n contra escritura");
                        }
                        this.listaFicheros.add(nombreFichero);
                    }
                    this.fw = this.getWriter(nombreFichero);
                }
                if (this.crlf) {
                    this.fw.writeln(cadena);
                } else {
                    this.fw.write(cadena);
                }
                if (cadenaAuxiliar.length() <= 0) continue;
                this.contadorVolumenActualAuxiliares += (long)cadenaAuxiliar.length();
                if (this.getTamVolumenes() > 0L || this.fwAuxiliar == null && this.contadorVolumenActual > this.getTamVolumenes() || this.fwAuxiliar == null) {
                    this.contadorVolumenActualAuxiliares = cadenaAuxiliar.length();
                    if (this.fwAuxiliar != null) {
                        this.guardaBytes(this.fwAuxiliar);
                    }
                    String nombreFicheroAuxiliar = "";
                    if (this.modo == 0) {
                        nombreFicheroAuxiliar = this.getFicheroTemporal();
                        if (nombreFicheroAuxiliar.length() == 0) {
                            throw new ExceptionMotor("Imposible generar " + nombreFicheroAuxiliar + " compruebe la ruta o la protecci\u00f3n contra escritura");
                        }
                        this.listaFicherosAuxiliares.add(nombreFicheroAuxiliar);
                    }
                    this.fwAuxiliar = this.getWriter(nombreFicheroAuxiliar);
                }
                if (this.crlf) {
                    this.fwAuxiliar.writeln(cadenaAuxiliar);
                    continue;
                }
                this.fwAuxiliar.write(cadenaAuxiliar);
            }
            this.getGestorFichero().fireProgressEvent(1);
            return new TipoDatoRetornoMetodo(this.exportaRegistroHIJOS(nombreTabla));
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public boolean exportaRegistroHIJOS(String nombreTabla) throws ExceptionMotor {
        ITipoDatoRetornoMetodo ret;
        if (this.getSesion().getModelo() != null && this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo() != null && (ret = this.getSesion().getModelo().getFuncionalidadPersonalizadaModelo().exportaRegistroHIJOS(this, nombreTabla)).isRetornaResultado()) {
            return ret.getObjetoRetornoAsBoolean();
        }
        return this.exportaRegistroHIJOSRecursiva(nombreTabla).getObjetoRetornoAsBoolean();
    }

    @Override
    public ITipoDatoRetornoMetodo exportaRegistroHIJOSRecursiva(String nombreTabla) throws ExceptionMotor {
        try {
            return new TipoDatoRetornoMetodo(true);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public void cancelar() {
        this.setFueCancelado(true);
    }

    @Override
    public void setFicheroLogPrivado(String ficheroLogPrivado) {
        this.getLineGen().setFicheroLogPrivado(ficheroLogPrivado);
    }

    @Override
    public String getFicheroLogPrivado() {
        return this.getLineGen().getFicheroLogPrivado();
    }

    @Override
    public void setLineGen(IGeneradorLineas lineGen) {
        this.lineGen = lineGen;
    }

    @Override
    public IGeneradorLineas getLineGen() {
        return this.lineGen;
    }

    @Override
    public void setGestorBoe(IGestorTraduccionesBOE gestorBoe) {
        this.gestorBoe = gestorBoe;
    }

    @Override
    public IGestorTraduccionesBOE getGestorBoe() {
        return this.gestorBoe;
    }

    @Override
    public void setArbolMotor(INodoArbol arbolMotor) {
        this.arbolMotor = arbolMotor;
    }

    @Override
    public INodoArbol getArbolDatos() throws ExceptionMotor {
        if (this.arbolMotor == null) {
            if (this.getSesion() != null) {
                this.arbolMotor = this.getSesion().getOperaciones().getArbolDatos();
            } else {
                throw new ExceptionMotor("Imposible crear arbol del motor");
            }
        }
        return this.arbolMotor;
    }

    @Override
    public void setSesion(ISesion sesion) throws ExceptionMotor {
        try {
            super.setSesion(sesion);
            this.setGestorFichero(sesion.getGestorFicheros(sesion.getEntradaTransOpciones().toUpperCase()));
            this.setGestorBoe(sesion.getModelo().getGestorTraduccionesBOE(sesion));
            if (this.getGestorFichero() != null) {
                this.getGestorFichero().setGestorTraducciones(sesion.getModelo().getGestorTraduccionesBOE(sesion));
            }
            this.setPosicionSello(((ISesionExtendida)sesion).getPosicionSello());
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public void guardaBytes(IWriterAEAT f) throws ExceptionMotor, IOException {
        switch (this.modo) {
            case 0: {
                f.close();
                break;
            }
            case 1: {
                this.listaFicheros.add(((ByteWriterAEAT)f).getBytes());
                break;
            }
            default: {
                throw new ExceptionMotor("No entiendo modo " + this.modo);
            }
        }
    }

    @Override
    public boolean exportaCOMUN(List<ITipoDatosAExportar> listaRegistrosExportar) throws ExceptionMotor {
        boolean flagIgnorarRegistrosDeEstadosAnterior = false;
        try {
            flagIgnorarRegistrosDeEstadosAnterior = ((IGestionOperacionesExtendida)this.getSesion().getOperaciones()).getIgnorarRegistrosDeEstados();
            this.setFueCancelado(false);
            this.contadorVolumenActual = 0L;
            this.contadorVolumenActualAuxiliares = 0L;
            this.listaFicheros = new ArrayList<Object>();
            this.listaFicherosAuxiliares = new ArrayList<Object>();
            String nombreFichero = "";
            if (this.modo == 0) {
                nombreFichero = this.getFicheroTemporal();
                if (nombreFichero.length() == 0) {
                    throw new ExceptionMotor("Imposible generar " + nombreFichero + " compruebe la ruta o la protecci\u00f3n contra escritura");
                }
                this.listaFicheros.add(nombreFichero);
            }
            this.getGestorFichero().fireProgressEvent(0, this.calcularPasosExportacion(listaRegistrosExportar));
            boolean ret = true;
            int i = 0;
            this.fw = this.getWriter(nombreFichero);
            this.getSesion().freezeSesionSoloPosicion();
            ((IGestionOperacionesExtendida)this.getSesion().getOperaciones()).setIgnorarRegistrosDeEstados(true);
            for (i = 0; i < listaRegistrosExportar.size(); ++i) {
                if (listaRegistrosExportar.get(i).getId() > 0L && this.getSesion().getOperaciones().move(listaRegistrosExportar.get(i).getTabla(), listaRegistrosExportar.get(i).getId()) == -1L) {
                    ret = false;
                    break;
                }
                boolean bl = ret = ret && this.exportaRegistro(listaRegistrosExportar.get(i).getTabla(), this.getSesion().getOperaciones().obtenerRegistroDatosTabla(listaRegistrosExportar.get(i).getTabla()));
                if (!ret) break;
            }
            ((IGestionOperacionesExtendida)this.getSesion().getOperaciones()).setIgnorarRegistrosDeEstados(flagIgnorarRegistrosDeEstadosAnterior);
            this.guardaBytes(this.fw);
            if (this.getPosicionSello() == -1) {
                this.setPosicionSello(this.getGestorBoe().buscaPosicionDelSello(this.getCrLf()));
            }
            if (this.listaFicheros != null && this.listaFicheros.size() > 0 && this.getPosicionSello() > -1) {
                block23: for (i = 0; i < this.listaFicheros.size(); ++i) {
                    switch (this.modo) {
                        case 0: {
                            FuncionesUtiles.getFuncionesUtiles().selloPos(this.listaFicheros.get(i).toString(), this.getPosicionSello(), this.getCaracterFinalSello());
                            continue block23;
                        }
                        case 1: {
                            FuncionesUtiles.getFuncionesUtiles().selloPos((byte[])this.listaFicheros.get(i), this.getPosicionSello(), this.getCaracterFinalSello());
                            continue block23;
                        }
                        default: {
                            throw new Exception("Modo de generacion de ficheros no definido!!!");
                        }
                    }
                }
            }
            if (this.fwAuxiliar != null) {
                this.guardaBytes(this.fwAuxiliar);
            }
            this.getSesion().unfreeze();
            boolean bl = ret;
            return bl;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
        finally {
            try {
                ((IGestionOperacionesExtendida)this.getSesion().getOperaciones()).setIgnorarRegistrosDeEstados(flagIgnorarRegistrosDeEstadosAnterior);
            }
            catch (Exception e) {}
            if (this.getSesion().isFreezed()) {
                this.getSesion().unfreeze();
            }
            if (this.fw != null) {
                try {
                    this.fw.close();
                }
                catch (IOException e) {}
            }
            if (this.fwAuxiliar != null) {
                try {
                    this.fwAuxiliar.close();
                }
                catch (IOException e) {}
            }
            this.fwAuxiliar = null;
            this.fw = null;
        }
    }

    @Override
    public ITipoDatosFicherosResultado exporta(List<ITipoDatosAExportar> listaRegistrosExportar) throws ExceptionMotor {
        try {
            this.modo = 0;
            boolean ret = this.exportaCOMUN(listaRegistrosExportar);
            if (!ret) {
                int i;
                File fl = null;
                for (i = 0; i < this.listaFicheros.size(); ++i) {
                    fl = new File(this.listaFicheros.get(i).toString());
                    fl.delete();
                    fl = null;
                }
                this.listaFicheros.clear();
                for (i = 0; i < this.listaFicherosAuxiliares.size(); ++i) {
                    fl = new File(this.listaFicherosAuxiliares.get(i).toString());
                    fl.delete();
                    fl = null;
                }
                this.listaFicherosAuxiliares.clear();
                Object var3_5 = null;
            }
            return new TipoDatosFicherosResultado(this.listaFicheros, this.listaFicherosAuxiliares);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public ITipoDatosFicherosBytesResultado exportaBytes(List<ITipoDatosAExportar> listaRegistrosExportar) throws ExceptionMotor {
        try {
            this.modo = 1;
            this.getLineGen().clearMem();
            this.exportaCOMUN(listaRegistrosExportar);
            this.getLineGen().clearMem();
            return new TipoDatosFicherosBytesResultado(this.listaFicheros, this.listaFicherosAuxiliares);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }
}

