/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.gestionFicheros;

import es.aeat.pftw.mtrc.gestionFicheros.IGestorFicheros;
import es.aeat.pftw.mtrc.gestionFicheros.IProgressListener;
import es.aeat.pftw.mtrc.gestionFicheros.importacion.ITransformaciones;
import es.aeat.pftw.mtrc.utilidades.FicherosIntermedios;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrc.utilidades.IFicherosIntermedios;
import es.aeat.pftw.mtrc.utilidades.StringUtility;
import es.aeat.pftw.mtrp.configuracion.IRegError;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class GestorFicheros
implements IGestorFicheros,
Serializable {
    private static final long serialVersionUID = 1L;
    private int iMaxErrores = Integer.MAX_VALUE;
    private long maxFicheros = -1L;
    private transient IFicherosIntermedios gestorFicherosIntermediosDatos = null;
    private List<IRegError> listadoErrores = new ArrayList<IRegError>();
    private List<IRegError> listadoWarning = new ArrayList<IRegError>();
    private int contadorErrores = 0;
    private String rutaFicheroDatosAuxiliares = "";
    private String rutaJar = "";
    private String[] nombreFicheroTraducciones = null;
    private Object gestorTraducciones = null;
    private String[] listado = null;
    private String sValor = "";
    private int iteradorTrans = 0;
    private String coletilla = "";
    private Map<String, Integer> listadoTotalesImportados = new HashMap<String, Integer>();
    private Map<String, Integer> listadoTotalesLeidos = new HashMap<String, Integer>();
    private List<IProgressListener> progressListenerList = new ArrayList<IProgressListener>();
    private boolean fueCancelado = false;
    private ITransformaciones claseTransformaciones = null;

    @Override
    public void dispose() throws ExceptionMotor {
        if (this.gestorFicherosIntermediosDatos != null) {
            this.gestorFicherosIntermediosDatos.dispose();
            this.gestorFicherosIntermediosDatos = null;
        }
        this.listadoErrores.clear();
        this.listadoWarning.clear();
        this.listadoTotalesImportados.clear();
        this.listadoTotalesLeidos.clear();
        this.progressListenerList.clear();
    }

    @Override
    public void init(Object[] parametros) throws ExceptionMotor {
        try {
            this.claseTransformaciones = (ITransformaciones)parametros[0];
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public InputStream[] getFicheroGestorTraducciones() throws ExceptionMotor {
        try {
            if (this.nombreFicheroTraducciones == null) {
                throw new ExceptionMotor("Desconozco el fichero a tratar");
            }
            return this.getFicheroGestorTraducciones(this.nombreFicheroTraducciones);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public InputStream[] getFicheroGestorTraducciones(String[] sNombreFicheroTraducciones) throws ExceptionMotor {
        try {
            if (sNombreFicheroTraducciones == null) {
                throw new ExceptionMotor("Desconozco el fichero a tratar");
            }
            InputStream[] is = new InputStream[sNombreFicheroTraducciones.length];
            for (int i = 0; i < sNombreFicheroTraducciones.length; ++i) {
                is[i] = this.rutaJar.trim().length() == 0 ? FuncionesUtiles.getFuncionesUtiles().string2inputstream(sNombreFicheroTraducciones[i], Charset.forName("ISO-8859-1")) : FuncionesUtiles.getFuncionesUtiles().getRecurso(sNombreFicheroTraducciones[i], this.rutaJar);
            }
            this.nombreFicheroTraducciones = (String[])sNombreFicheroTraducciones.clone();
            return is;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public Object getGestorTraducciones() {
        return this.gestorTraducciones;
    }

    @Override
    public void setGestorTraducciones(Object gestor) {
        this.gestorTraducciones = gestor;
    }

    @Override
    public void setMaxErrores(int maxErrores) {
        this.iMaxErrores = maxErrores;
    }

    @Override
    public int getMaxErrores() {
        return this.iMaxErrores;
    }

    @Override
    public void setRutaJar(String sRutaJar) {
        this.rutaJar = sRutaJar;
    }

    @Override
    public String getRutaJar() {
        return this.rutaJar;
    }

    @Override
    public void setRutaDatosAdicionales(String sRutaDatosAdicionales) {
        if (sRutaDatosAdicionales != null) {
            this.rutaFicheroDatosAuxiliares = sRutaDatosAdicionales;
        }
    }

    @Override
    public String getRutaDatosAdicionales() {
        return this.rutaFicheroDatosAuxiliares;
    }

    @Override
    public void setnombreFicheroTraducciones(String sNombreFicheroTraducciones) {
        this.nombreFicheroTraducciones = null;
        this.addnombreFicheroTraducciones(sNombreFicheroTraducciones);
    }

    @Override
    public void setnombresFicheroTraducciones(String[] sNombreFicheroTraduccionesLista) {
        this.nombreFicheroTraducciones = sNombreFicheroTraduccionesLista;
    }

    @Override
    public void addnombreFicheroTraducciones(String sNombreFicheroTraducciones) {
        if (this.nombreFicheroTraducciones == null) {
            this.nombreFicheroTraducciones = new String[1];
        } else {
            String[] tmp = new String[this.nombreFicheroTraducciones.length + 1];
            System.arraycopy(this.nombreFicheroTraducciones, 0, tmp, 0, tmp.length - 1);
            this.nombreFicheroTraducciones = tmp;
            Object var2_2 = null;
        }
        this.nombreFicheroTraducciones[this.nombreFicheroTraducciones.length - 1] = sNombreFicheroTraducciones;
    }

    @Override
    public String[] getnombreFicheroTraducciones() {
        return this.nombreFicheroTraducciones;
    }

    @Override
    public ITransformaciones getClaseTransformaciones() throws ExceptionMotor {
        return this.claseTransformaciones;
    }

    @Override
    public boolean transfCargaTransformaciones(String valor, String cadenaTransformaciones) throws ExceptionMotor {
        try {
            this.coletilla = "";
            this.iteradorTrans = 0;
            this.coletilla = "";
            this.sValor = valor;
            this.listado = StringUtility.getStringUtility().split(cadenaTransformaciones.toUpperCase(), ";");
            return true;
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Valor " + valor + " Cadena Transf " + cadenaTransformaciones);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Valor " + valor + " Cadena Transf " + cadenaTransformaciones);
        }
    }

    @Override
    public void setValor(String valor) {
        this.sValor = valor;
    }

    @Override
    public String transfDameSiguienteTransformacion() throws ExceptionMotor {
        try {
            this.coletilla = "";
            ++this.iteradorTrans;
            if (this.iteradorTrans > this.listado.length) {
                return null;
            }
            if (this.getClaseTransformaciones() == null) {
                return null;
            }
            String tmp = this.getClaseTransformaciones().ejecutarTransformacion(this.sValor, this.listado[this.iteradorTrans - 1]);
            int i = tmp.indexOf(58);
            if (i == -1) {
                return tmp;
            }
            this.coletilla = tmp.substring(0, i);
            return tmp.substring(i + 1);
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    @Override
    public String transfDameColetilla() {
        return this.coletilla;
    }

    @Override
    public void borraUltimoError() {
        this.listadoErrores.remove(this.listadoErrores.size() - 1);
        --this.contadorErrores;
    }

    @Override
    public void borraUltimoWarning() {
        this.listadoWarning.remove(this.listadoWarning.size() - 1);
    }

    @Override
    public IRegError addErrorWarningComun(String localizacion, IRegError rp, Map<String, String> propCampos, boolean incrementarContador) {
        if (incrementarContador && rp.getTipoError().equalsIgnoreCase("E") || rp.getTipoError().equalsIgnoreCase("H")) {
            ++this.contadorErrores;
        }
        if (propCampos != null && propCampos.containsKey("NOMBRE") && "".equals(rp.getMsg())) {
            rp.setMsg(propCampos.get("NOMBRE").toString());
        } else if (propCampos != null && propCampos.containsKey("LITERAL") && "".equals(rp.getMsg())) {
            rp.setMsg(propCampos.get("LITERAL").toString());
        }
        rp.setPropiedad("LOCALIZACION", localizacion);
        return rp;
    }

    @Override
    public void addError(String localizacion, IRegError rp, Map<String, String> propCampos, boolean incrementarContador) {
        if (this.errCount() >= this.getMaxErrores()) {
            return;
        }
        if ((rp = this.addErrorWarningComun(localizacion, rp, propCampos, incrementarContador)).getTipoError() == null || rp.getTipoError().length() == 0) {
            rp.setTipoError("E");
        } else if (!rp.getTipoError().equalsIgnoreCase("E") && !rp.getTipoError().equalsIgnoreCase("H")) {
            this.addWarning(localizacion, rp, propCampos, false);
            return;
        }
        this.listadoErrores.add(rp);
    }

    @Override
    public void addError(String localizacion, IRegError rp, Map<String, String> propCampos) {
        this.addError(localizacion, rp, propCampos, true);
    }

    @Override
    public void addWarning(String localizacion, IRegError rp, Map<String, String> propCampos, boolean incrementarContador) {
        if ((rp = this.addErrorWarningComun(localizacion, rp, propCampos, incrementarContador)).getTipoError() == null || rp.getTipoError().length() == 0) {
            rp.setTipoError("W");
        }
        this.listadoWarning.add(rp);
    }

    @Override
    public void addWarning(String localizacion, IRegError rp, Map<String, String> propCampos) {
        this.addWarning(localizacion, rp, propCampos, true);
    }

    @Override
    public int errCount() {
        return this.contadorErrores;
    }

    @Override
    public List<IRegError> getListaErrores() {
        return this.listadoErrores;
    }

    @Override
    public List<IRegError> getListaWarning() {
        return this.listadoWarning;
    }

    @Override
    public void errClear() {
        this.contadorErrores = 0;
        this.listadoErrores.clear();
        this.listadoWarning.clear();
    }

    @Override
    public Map<String, Map<String, Integer>> getEstadisticasTotales() {
        HashMap<String, Map<String, Integer>> totales = new HashMap<String, Map<String, Integer>>();
        totales.put("IMPORTADOS", this.listadoTotalesImportados);
        totales.put("LEIDOS", this.listadoTotalesLeidos);
        return totales;
    }

    @Override
    public boolean clearRegistrosImportados() {
        this.listadoTotalesImportados.clear();
        return true;
    }

    @Override
    public boolean actualizaRegistroImportadoLeido(String nombreTabla, int add, boolean hashMapLeidos) throws ExceptionMotor {
        Integer obj = null;
        obj = hashMapLeidos ? this.listadoTotalesLeidos.get(nombreTabla.toUpperCase()) : this.listadoTotalesImportados.get(nombreTabla.toUpperCase());
        int cuenta = 0;
        if (obj != null) {
            cuenta = obj;
        }
        if ((cuenta += add) > 0) {
            if (hashMapLeidos) {
                this.listadoTotalesLeidos.put(nombreTabla.toUpperCase(), cuenta);
            } else {
                this.listadoTotalesImportados.put(nombreTabla.toUpperCase(), cuenta);
            }
        } else if (hashMapLeidos) {
            this.listadoTotalesLeidos.remove(nombreTabla.toUpperCase());
        } else {
            this.listadoTotalesImportados.remove(nombreTabla.toUpperCase());
        }
        return true;
    }

    @Override
    public boolean addRegistroImportado(String nombreTabla) throws ExceptionMotor {
        try {
            return this.actualizaRegistroImportadoLeido(nombreTabla, 1, false);
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public boolean removeRegistroImportado(String nombreTabla) throws ExceptionMotor {
        try {
            return this.actualizaRegistroImportadoLeido(nombreTabla, -1, false);
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public boolean addRegistroLeido(String nombreTabla) throws ExceptionMotor {
        try {
            return this.actualizaRegistroImportadoLeido(nombreTabla, 1, true);
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public boolean removeRegistroLeido(String nombreTabla) throws ExceptionMotor {
        try {
            return this.actualizaRegistroImportadoLeido(nombreTabla, -1, true);
        }
        catch (ExceptionMotor ex) {
            ex.setInformacionExtra(ex.getInformacionExtra() + "Tabla " + nombreTabla);
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public void addProgressListener(IProgressListener pl) {
        this.progressListenerList.add(pl);
    }

    @Override
    public void fireProgressEvent() {
        this.fireProgressEvent(1);
    }

    @Override
    public void fireProgressEvent(int encada) {
        Iterator<IProgressListener> ite = this.progressListenerList.iterator();
        while (ite.hasNext()) {
            ite.next().progressPerformed(encada);
        }
    }

    @Override
    public void fireProgressEvent(int min, int max) {
        Iterator<IProgressListener> ite = this.progressListenerList.iterator();
        while (ite.hasNext()) {
            if (min != max) {
                ite.next().progressInit(min, max);
                continue;
            }
            ite.next().progressEnd(min, max);
        }
    }

    @Override
    public IFicherosIntermedios getGestorFichIntermediosDatos() {
        if (this.gestorFicherosIntermediosDatos == null) {
            this.gestorFicherosIntermediosDatos = new FicherosIntermedios();
        }
        return this.gestorFicherosIntermediosDatos;
    }

    @Override
    public boolean eliminarFicheroVirtual() throws ExceptionMotor {
        if (this.gestorFicherosIntermediosDatos != null) {
            return this.gestorFicherosIntermediosDatos.eliminarFicheroVirtual();
        }
        return true;
    }

    @Override
    public void cancelar() {
        this.setFueCancelado(true);
    }

    @Override
    public void clearTotales() {
        this.listadoTotalesImportados.clear();
        this.listadoTotalesLeidos.clear();
    }

    @Override
    public Map<String, Integer> gettotalesLeidos() {
        return this.listadoTotalesLeidos;
    }

    @Override
    public void setFueCancelado(boolean fueCancelado) {
        this.fueCancelado = fueCancelado;
    }

    @Override
    public boolean isFueCancelado() {
        return this.fueCancelado;
    }

    @Override
    public boolean superaMaxFicheros(long tamActual) {
        return this.maxFicheros != -1L && this.maxFicheros < tamActual;
    }

    @Override
    public void setMaxFicheros(long maxFicheros) {
        this.maxFicheros = maxFicheros;
    }
}

