/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.formateador;

import es.aeat.pftw.mtrc.formateador.FormateaSegunTipoNumero;
import es.aeat.pftw.mtrc.formateador.Formateador;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;

public final class FormateadorNumerico
extends Formateador {
    private static final long serialVersionUID = 1L;
    private String tipoNumerico = null;
    private int numDecimales = 0;
    private boolean aplicarFormateo = false;

    @Override
    public void constructor(Map<?, ?> parametros) {
        if (parametros.get("TIPO_CAMPO") != null) {
            this.tipoNumerico = (String)parametros.get("TIPO_CAMPO");
        }
        if (parametros.get("NUMERO_DECIMALES") != null) {
            this.numDecimales = Integer.valueOf(parametros.get("NUMERO_DECIMALES").toString());
        }
        if (parametros.get("APLICAR_FORMATEO") != null) {
            String aux = (String)parametros.get("APLICAR_FORMATEO");
            this.aplicarFormateo = Boolean.getBoolean(aux);
        }
    }

    @Override
    public Object formatearHaciaMotor(String text) {
        return this.formateoNumericoParaMotor(text);
    }

    private String formateoNumericoParaMotor(String textField) {
        String res = "0";
        if (textField.trim().equalsIgnoreCase("") || textField.trim().equalsIgnoreCase("-")) {
            return res;
        }
        textField = textField.replace(".", "");
        res = textField = textField.replace(',', '.');
        return res;
    }

    @Override
    public Object formatearDesdeMotor(String cad) {
        String cadena;
        String cadNumerica = cadena = cad;
        cadena = cadena.replace('.', ',');
        if (this.tipoNumerico.equalsIgnoreCase("ENTERO")) {
            if (this.aplicarFormateo) {
                cadena = FormateaSegunTipoNumero.formateaSegunTipoNumerico(cadena);
            }
        } else if (this.tipoNumerico.equalsIgnoreCase("DOBLE") || this.tipoNumerico.equalsIgnoreCase("BIGDECIMAL")) {
            cadena = FormateaSegunTipoNumero.formateaSegunTipoNumerico(cadena, this.numDecimales);
        }
        if (this.esCero(cadNumerica)) {
            cadena = "";
        }
        return cadena;
    }

    private boolean esCero(String cadena) {
        boolean res = true;
        try {
            res = Double.valueOf(cadena) == 0.0;
            return res;
        }
        catch (Exception e) {
            return res;
        }
    }

    @Override
    public String formatearDesdeMotorDatoGanarFoco(String cad) {
        String cadena;
        String cadNumerica = cadena = cad;
        BigDecimal bg = new BigDecimal(cadena.trim());
        NumberFormat f = NumberFormat.getInstance(new Locale("es", "ES"));
        if (f instanceof DecimalFormat) {
            ((DecimalFormat)f).setDecimalSeparatorAlwaysShown(true);
            ((DecimalFormat)f).setMaximumFractionDigits(2);
            ((DecimalFormat)f).setMinimumFractionDigits(2);
            ((DecimalFormat)f).setGroupingSize(3);
        }
        cadena = f.format(bg);
        if (this.esCero(cadNumerica)) {
            cadena = "";
        }
        return cadena;
    }

    public void setTipoDato(String tipoDato) {
        this.tipoNumerico = tipoDato;
    }

    public void setNumDecimales(int iNumDecimales) {
        this.numDecimales = iNumDecimales;
    }

    public Object formatearCadenaParaBigDecimal(String res) {
        return FormateaSegunTipoNumero.formateaSegunTipoNumerico(res, this.numDecimales);
    }
}

